const char *textlabelbase_vs =
  "#version 400\n"
  "precision highp float;\n"
  "// Modelview/projection matrix\n"
  "uniform mat4 mv;\n"
  "uniform mat4 proj;\n"
  "\n"
  "// anchor position\n"
  "uniform vec3 anchor;\n"
  "\n"
  "// Distance to project the label towards the camera\n"
  "uniform float radius;\n"
  "\n"
  "// Vertex attributes.\n"
  "in vec2 offset;\n"
  "in vec2 texCoord;\n"
  "\n"
  "// Viewport dimensions:\n"
  "uniform ivec2 vpDims;\n"
  "\n"
  "// Texture coordinate.\n"
  "out vec2 texc;\n"
  "\n"
  "// Given a clip coordinate, align the vertex to the nearest pixel center.\n"
  "void alignToPixelCenter(inout vec4 clipCoord)\n"
  "{\n"
  "  // Half pixel increments (clip coord span / [2*numPixels] = [2*w] / [2*l]):\n"
  "  vec2 inc = abs(clipCoord.w) / vec2(vpDims);\n"
  "\n"
  "  // Fix up coordinates -- pixel centers are at xy = (-w + (2*i + 1) * inc)\n"
  "  // for the i'th pixel. First find i and floor it. Just solve the above for i:\n"
  "  ivec2 pixels = ivec2(floor((clipCoord.xy + abs(clipCoord.ww) - inc)\n"
  "                             / (2. * inc)));\n"
  "\n"
  "  // Now reapply the equation to obtain a pixel centered offset.\n"
  "  clipCoord.xy = -abs(clipCoord.ww) + (2. * vec2(pixels) + vec2(1., 1.)) * inc;\n"
  "}\n"
  "\n"
  "void main(void)\n"
  "{\n"
  "  // Transform to eye coordinates:\n"
  "  vec4 eyeAnchor = mv * vec4(anchor, 1.0);\n"
  "\n"
  "  // Apply radius;\n"
  "  eyeAnchor += vec4(0., 0., radius, 0.);\n"
  "\n"
  "  // Transform to clip coordinates\n"
  "  vec4 clipAnchor = proj * eyeAnchor;\n"
  "\n"
  "  // Move the anchor to a pixel center:\n"
  "  alignToPixelCenter(clipAnchor);\n"
  "\n"
  "  // Align offset to cell centers using the w coordinate:\n"
  "  // Since w determines whether or not the vertex is clipped, (-w, w) spans\n"
  "  // the width/height of the display. Using the viewport width/height in pixels,\n"
  "  // we can properly convert the offset into pixel units.\n"
  "  vec2 conv = (2. * abs(clipAnchor.w)) / vec2(vpDims);\n"
  "\n"
  "  // Apply the offset:\n"
  "  gl_Position = clipAnchor + vec4(offset.x * conv.x, offset.y * conv.y, 0., 0.);\n"
  "\n"
  "  // Pass through the texture coordinate\n"
  "  texc = texCoord;\n"
  "}\n"
  "\n";
