// Code generated by smithy-go/middleware/generate.go DO NOT EDIT.
package middleware

import (
	"context"
	"fmt"
)

// DeserializeInput provides the input parameters for the DeserializeInput to
// consume. DeserializeMiddleware should not modify the Request, and instead
// forward it along to the next DeserializeHandler.
type DeserializeInput struct {
	Request interface{}
}

// DeserializeOutput provides the result returned by the next DeserializeHandler.
type DeserializeOutput struct {
	RawResponse interface{}
	Result      interface{}
}

// DeserializeHandler provides the interface for the next handler the
// DeserializeMiddleware will call in the middleware chain.
type DeserializeHandler interface {
	HandleDeserialize(ctx context.Context, in DeserializeInput) (
		out DeserializeOutput, metadata Metadata, err error,
	)
}

// DeserializeMiddleware provides the interface for middleware specific to the
// deserialize step. Delegates to the next DeserializeHandler for further
// processing.
type DeserializeMiddleware interface {
	// ID returns a unique ID for the middleware in the DeserializeStep. The step does not
	// allow duplicate IDs.
	ID() string

	// HandleDeserialize invokes the middleware behavior which must delegate to the next handler
	// for the middleware chain to continue. The method must return a result or
	// error to its caller.
	HandleDeserialize(ctx context.Context, in DeserializeInput, next DeserializeHandler) (
		out DeserializeOutput, metadata Metadata, err error,
	)
}

// DeserializeMiddlewareFunc returns a DeserializeMiddleware with the unique ID provided,
// and the func to be invoked.
func DeserializeMiddlewareFunc(id string, fn func(context.Context, DeserializeInput, DeserializeHandler) (DeserializeOutput, Metadata, error)) DeserializeMiddleware {
	return deserializeMiddlewareFunc{
		id: id,
		fn: fn,
	}
}

type deserializeMiddlewareFunc struct {
	// Unique ID for the middleware.
	id string

	// Middleware function to be called.
	fn func(context.Context, DeserializeInput, DeserializeHandler) (
		DeserializeOutput, Metadata, error,
	)
}

// ID returns the unique ID for the middleware.
func (s deserializeMiddlewareFunc) ID() string { return s.id }

// HandleDeserialize invokes the middleware Fn.
func (s deserializeMiddlewareFunc) HandleDeserialize(ctx context.Context, in DeserializeInput, next DeserializeHandler) (
	out DeserializeOutput, metadata Metadata, err error,
) {
	return s.fn(ctx, in, next)
}

var _ DeserializeMiddleware = (deserializeMiddlewareFunc{})

// DeserializeStep provides the ordered grouping of DeserializeMiddleware to be
// invoked on a handler.
type DeserializeStep struct {
	head *decoratedDeserializeHandler
	tail *decoratedDeserializeHandler
}

// NewDeserializeStep returns an DeserializeStep ready to have middleware for
// deserialize added to it.
func NewDeserializeStep() *DeserializeStep {
	return &DeserializeStep{}
}

var _ Middleware = (*DeserializeStep)(nil)

// ID returns the unique ID of the step as a middleware.
func (s *DeserializeStep) ID() string {
	return "Deserialize stack step"
}

// HandleMiddleware invokes the middleware by decorating the next handler
// provided. Returns the result of the middleware and handler being invoked.
//
// Implements Middleware interface.
func (s *DeserializeStep) HandleMiddleware(ctx context.Context, in interface{}, next Handler) (
	out interface{}, metadata Metadata, err error,
) {
	sIn := DeserializeInput{
		Request: in,
	}

	wh := &deserializeWrapHandler{next}
	if s.head == nil {
		res, metadata, err := wh.HandleDeserialize(ctx, sIn)
		return res.Result, metadata, err
	}

	s.tail.Next = wh
	res, metadata, err := s.head.HandleDeserialize(ctx, sIn)
	return res.Result, metadata, err
}

// Get retrieves the middleware identified by id. If the middleware is not present, returns false.
func (s *DeserializeStep) Get(id string) (DeserializeMiddleware, bool) {
	found, _ := s.get(id)
	if found == nil {
		return nil, false
	}

	return found.With, true
}

// Add injects the middleware to the relative position of the middleware group.
//
// Add never returns an error. It used to for duplicate phases but this
// behavior has since been removed as part of a performance optimization. The
// return value from Add can be ignored.
func (s *DeserializeStep) Add(m DeserializeMiddleware, pos RelativePosition) error {
	if s.head == nil {
		s.head = &decoratedDeserializeHandler{nil, m}
		s.tail = s.head
		return nil
	}

	if pos == Before {
		s.head = &decoratedDeserializeHandler{s.head, m}
	} else {
		tail := &decoratedDeserializeHandler{nil, m}
		s.tail.Next = tail
		s.tail = tail
	}

	return nil
}

// Insert injects the middleware relative to an existing middleware ID.
// Returns error if the original middleware does not exist, or the middleware
// being added already exists.
func (s *DeserializeStep) Insert(m DeserializeMiddleware, relativeTo string, pos RelativePosition) error {
	found, prev := s.get(relativeTo)
	if found == nil {
		return fmt.Errorf("not found: %s", m.ID())
	}

	if pos == Before {
		if prev == nil { // at the front
			s.head = &decoratedDeserializeHandler{s.head, m}
		} else { // somewhere in the middle
			prev.Next = &decoratedDeserializeHandler{found, m}
		}
	} else {
		if found.Next == nil { // at the end
			tail := &decoratedDeserializeHandler{nil, m}
			s.tail.Next = tail
			s.tail = tail
		} else { // somewhere in the middle
			found.Next = &decoratedDeserializeHandler{found.Next, m}
		}
	}

	return nil
}

// Swap removes the middleware by id, replacing it with the new middleware.
// Returns the middleware removed, or error if the middleware to be removed
// doesn't exist.
func (s *DeserializeStep) Swap(id string, m DeserializeMiddleware) (DeserializeMiddleware, error) {
	found, _ := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", m.ID())
	}

	swapped := found.With
	found.With = m
	return swapped, nil
}

// Remove removes the middleware by id. Returns error if the middleware
// doesn't exist.
func (s *DeserializeStep) Remove(id string) (DeserializeMiddleware, error) {
	found, prev := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", id)
	}

	if s.head == s.tail { // it's the only one
		s.head = nil
		s.tail = nil
	} else if found == s.head { // at the front
		s.head = s.head.Next.(*decoratedDeserializeHandler)
	} else if found == s.tail { // at the end
		prev.Next = nil
		s.tail = prev
	} else {
		prev.Next = found.Next // somewhere in the middle
	}

	return found.With, nil
}

// List returns a list of the middleware in the step.
func (s *DeserializeStep) List() []string {
	var ids []string
	for h := s.head; h != nil; {
		ids = append(ids, h.With.ID())
		if h.Next == nil {
			break
		}

		// once executed, tail.Next of the list will be set to an
		// *deserializeWrapHandler, make sure to check for that
		if hnext, ok := h.Next.(*decoratedDeserializeHandler); ok {
			h = hnext
		} else {
			break
		}
	}
	return ids
}

// Clear removes all middleware in the step.
func (s *DeserializeStep) Clear() {
	s.head = nil
	s.tail = nil
}

func (s *DeserializeStep) get(id string) (found, prev *decoratedDeserializeHandler) {
	for h := s.head; h != nil; {
		if h.With.ID() == id {
			found = h
			return
		}
		prev = h
		if h.Next == nil {
			return
		}

		// once executed, tail.Next of the list will be set to an
		// *deserializeWrapHandler
		h, _ = h.Next.(*decoratedDeserializeHandler)
	}
	return
}

type deserializeWrapHandler struct {
	Next Handler
}

var _ DeserializeHandler = (*deserializeWrapHandler)(nil)

// HandleDeserialize implements DeserializeHandler, converts types and delegates to underlying
// generic handler.
func (w deserializeWrapHandler) HandleDeserialize(ctx context.Context, in DeserializeInput) (
	out DeserializeOutput, metadata Metadata, err error,
) {
	res, metadata, err := w.Next.Handle(ctx, in.Request)
	return DeserializeOutput{
		RawResponse: res,
		Result:      nil,
	}, metadata, err
}

type decoratedDeserializeHandler struct {
	Next DeserializeHandler
	With DeserializeMiddleware
}

var _ DeserializeHandler = (*decoratedDeserializeHandler)(nil)

func (h decoratedDeserializeHandler) HandleDeserialize(ctx context.Context, in DeserializeInput) (
	out DeserializeOutput, metadata Metadata, err error,
) {
	return h.With.HandleDeserialize(ctx, in, h.Next)
}

// DeserializeHandlerFunc provides a wrapper around a function to be used as deserializeMiddleware.
type DeserializeHandlerFunc func(context.Context, DeserializeInput) (DeserializeOutput, Metadata, error)

// HandleDeserialize calls the wrapped function with the provided arguments.
func (f DeserializeHandlerFunc) HandleDeserialize(ctx context.Context, in DeserializeInput) (DeserializeOutput, Metadata, error) {
	return f(ctx, in)
}

var _ DeserializeHandler = DeserializeHandlerFunc(nil)
