// Code generated by smithy-go-codegen DO NOT EDIT.

package outposts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/outposts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// A list of Amazon EC2 instances, belonging to all accounts, running on the
// specified Outpost. Does not include Amazon EBS or Amazon S3 instances.
func (c *Client) ListAssetInstances(ctx context.Context, params *ListAssetInstancesInput, optFns ...func(*Options)) (*ListAssetInstancesOutput, error) {
	if params == nil {
		params = &ListAssetInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAssetInstances", params, optFns, c.addOperationListAssetInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAssetInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAssetInstancesInput struct {

	// The ID of the Outpost.
	//
	// This member is required.
	OutpostIdentifier *string

	// Filters the results by account ID.
	AccountIdFilter []string

	// Filters the results by asset ID.
	AssetIdFilter []string

	// Filters the results by Amazon Web Services service.
	AwsServiceFilter []types.AWSServiceName

	// Filters the results by instance ID.
	InstanceTypeFilter []string

	// The maximum page size.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAssetInstancesOutput struct {

	// List of instances owned by all accounts on the Outpost. Does not include Amazon
	// EBS or Amazon S3 instances.
	AssetInstances []types.AssetInstance

	// The pagination token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAssetInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAssetInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAssetInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAssetInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAssetInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAssetInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAssetInstancesPaginatorOptions is the paginator options for
// ListAssetInstances
type ListAssetInstancesPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAssetInstancesPaginator is a paginator for ListAssetInstances
type ListAssetInstancesPaginator struct {
	options   ListAssetInstancesPaginatorOptions
	client    ListAssetInstancesAPIClient
	params    *ListAssetInstancesInput
	nextToken *string
	firstPage bool
}

// NewListAssetInstancesPaginator returns a new ListAssetInstancesPaginator
func NewListAssetInstancesPaginator(client ListAssetInstancesAPIClient, params *ListAssetInstancesInput, optFns ...func(*ListAssetInstancesPaginatorOptions)) *ListAssetInstancesPaginator {
	if params == nil {
		params = &ListAssetInstancesInput{}
	}

	options := ListAssetInstancesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAssetInstancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAssetInstancesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAssetInstances page.
func (p *ListAssetInstancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAssetInstancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAssetInstances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAssetInstancesAPIClient is a client that implements the ListAssetInstances
// operation.
type ListAssetInstancesAPIClient interface {
	ListAssetInstances(context.Context, *ListAssetInstancesInput, ...func(*Options)) (*ListAssetInstancesOutput, error)
}

var _ ListAssetInstancesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAssetInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAssetInstances",
	}
}
