/* pwl.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from pwl.vala, do not modify */

/* libenchant: Personal word lists
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2026 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <stdio.h>
#include <sys/file.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <time.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include <gobject/gvaluecollector.h>

#define BOM ((gunichar) 0xfeff)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantPWLPrivate EnchantPWLPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecEnchantPWL ParamSpecEnchantPWL;

#define TYPE_ENCHANT_PROVIDER_DICT (enchant_provider_dict_get_type ())
#define ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDict))
#define ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))
#define IS_ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER_DICT))
#define IS_ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER_DICT))
#define ENCHANT_PROVIDER_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))

typedef struct _EnchantProviderDict EnchantProviderDict;
typedef struct _EnchantProviderDictClass EnchantProviderDictClass;
typedef struct _EnchantProviderDictPrivate EnchantProviderDictPrivate;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef gint (*DictCheck) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantProviderDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantProviderDict* me);
typedef gint (*DictIsWordCharacter) (EnchantProviderDict* me, guint32 uc_in, size_t n);

#define TYPE_ENCHANT_PWL_DICT (enchant_pwl_dict_get_type ())
#define ENCHANT_PWL_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL_DICT, EnchantPwlDict))
#define ENCHANT_PWL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL_DICT, EnchantPwlDictClass))
#define IS_ENCHANT_PWL_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL_DICT))
#define IS_ENCHANT_PWL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL_DICT))
#define ENCHANT_PWL_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL_DICT, EnchantPwlDictClass))

typedef struct _EnchantPwlDict EnchantPwlDict;
typedef struct _EnchantPwlDictClass EnchantPwlDictClass;
typedef struct _EnchantPwlDictPrivate EnchantPwlDictPrivate;

struct _EnchantPWL {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantPWLPrivate * priv;
};

struct _EnchantPWLClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantPWL *self);
};

struct _EnchantPWLPrivate {
	gchar* filename;
	gboolean exclude;
	time_t file_changed;
	GHashTable* words;
};

struct _ParamSpecEnchantPWL {
	GParamSpec parent_instance;
};

struct _EnchantProviderDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderDictPrivate * priv;
	void* user_data;
	EnchantProvider* provider;
	gchar* language_tag;
	gchar* error;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantProviderDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProviderDict *self);
};

struct _EnchantPwlDict {
	EnchantProviderDict parent_instance;
	EnchantPwlDictPrivate * priv;
};

struct _EnchantPwlDictClass {
	EnchantProviderDictClass parent_class;
};

static gint EnchantPWL_private_offset;
static gpointer enchant_pwl_parent_class = NULL;
static gpointer enchant_pwl_dict_parent_class = NULL;

VALA_EXTERN void lock_file (FILE* f);
VALA_EXTERN void unlock_file (FILE* f);
VALA_EXTERN gchar* utf8_strtitle (const gchar* str);
VALA_EXTERN gboolean is_all_caps (const gchar* word);
VALA_EXTERN gboolean is_title_case (const gchar* word);
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
static void _g_free0_ (gpointer var);
VALA_EXTERN EnchantPWL* enchant_pwl_new (const gchar* filename,
                             gboolean exclude);
VALA_EXTERN EnchantPWL* enchant_pwl_construct (GType object_type,
                                   const gchar* filename,
                                   gboolean exclude);
static void enchant_pwl_add_to_table (EnchantPWL* self,
                               const gchar* word);
VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      EnchantDict* session,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
static void enchant_pwl_refresh_from_file (EnchantPWL* self,
                                    EnchantDict* session);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         EnchantDict* session,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gint enchant_pwl_check (EnchantPWL* self,
                        EnchantDict* session,
                        const gchar* word_buf,
                        ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
static void enchant_pwl_finalize (EnchantPWL * obj);
static GType enchant_pwl_get_type_once (void);
VALA_EXTERN gpointer enchant_provider_dict_ref (gpointer instance);
VALA_EXTERN void enchant_provider_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider_dict (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider_dict (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_enchant_provider_dict (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider_dict (const GValue* value);
VALA_EXTERN GType enchant_provider_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProviderDict, enchant_provider_dict_unref)
VALA_EXTERN gint check_impl (EnchantProviderDict* me,
                 const gchar* word,
                 size_t len);
VALA_EXTERN gchar** suggest_impl (EnchantProviderDict* me,
                      const gchar* word,
                      size_t len,
                      size_t* result_length1);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN GType enchant_pwl_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPwlDict, enchant_provider_dict_unref)
VALA_EXTERN EnchantPwlDict* enchant_pwl_dict_new (void);
VALA_EXTERN EnchantPwlDict* enchant_pwl_dict_construct (GType object_type);
VALA_EXTERN EnchantProviderDict* enchant_provider_dict_new (EnchantProvider* provider,
                                                const gchar* tag);
VALA_EXTERN EnchantProviderDict* enchant_provider_dict_construct (GType object_type,
                                                      EnchantProvider* provider,
                                                      const gchar* tag);
static gint _check_impl_dict_check (EnchantProviderDict* me,
                             const gchar* word,
                             size_t len);
static gchar** _suggest_impl_dict_suggest (EnchantProviderDict* me,
                                    const gchar* word,
                                    size_t len,
                                    size_t* result_length1);
static GType enchant_pwl_dict_get_type_once (void);

void
lock_file (FILE* f)
{
#line 43 "pwl.vala"
	g_return_if_fail (f != NULL);
#line 44 "pwl.vala"
	flock (fileno (f), LOCK_EX);
#line 311 "pwl.c"
}

void
unlock_file (FILE* f)
{
#line 47 "pwl.vala"
	g_return_if_fail (f != NULL);
#line 48 "pwl.vala"
	flock (fileno (f), LOCK_UN);
#line 321 "pwl.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 335 "pwl.c"
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1122 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1122 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1123 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, str);
#line 1124 "glib-2.0.vapi"
	result = str;
#line 1124 "glib-2.0.vapi"
	return result;
#line 354 "pwl.c"
}

gchar*
utf8_strtitle (const gchar* str)
{
	gchar* upper_str = NULL;
	gchar* _tmp0_;
	gchar* lower_tail = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gunichar title_case_char = 0U;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
#line 51 "pwl.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 52 "pwl.vala"
	_tmp0_ = g_utf8_strup (str, (gssize) -1);
#line 52 "pwl.vala"
	upper_str = _tmp0_;
#line 53 "pwl.vala"
	_tmp1_ = g_utf8_next_char (upper_str);
#line 53 "pwl.vala"
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
#line 53 "pwl.vala"
	lower_tail = _tmp2_;
#line 54 "pwl.vala"
	title_case_char = g_unichar_totitle (string_get_char (upper_str, (glong) 0));
#line 55 "pwl.vala"
	_tmp3_ = g_unichar_to_string (title_case_char);
#line 55 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 55 "pwl.vala"
	_tmp5_ = g_strdup_printf ("%s%s", _tmp4_, lower_tail);
#line 55 "pwl.vala"
	_tmp6_ = _tmp5_;
#line 55 "pwl.vala"
	_g_free0 (_tmp4_);
#line 55 "pwl.vala"
	result = _tmp6_;
#line 55 "pwl.vala"
	_g_free0 (lower_tail);
#line 55 "pwl.vala"
	_g_free0 (upper_str);
#line 55 "pwl.vala"
	return result;
#line 403 "pwl.c"
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
#line 1302 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1303 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1304 "glib-2.0.vapi"
	if (_vala_c != ((gunichar) 0)) {
#line 419 "pwl.c"
		gchar* _tmp0_;
#line 1305 "glib-2.0.vapi"
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1305 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1306 "glib-2.0.vapi"
		result = TRUE;
#line 1306 "glib-2.0.vapi"
		if (c) {
#line 1306 "glib-2.0.vapi"
			*c = _vala_c;
#line 431 "pwl.c"
		}
#line 1306 "glib-2.0.vapi"
		return result;
#line 435 "pwl.c"
	} else {
#line 1308 "glib-2.0.vapi"
		result = FALSE;
#line 1308 "glib-2.0.vapi"
		if (c) {
#line 1308 "glib-2.0.vapi"
			*c = _vala_c;
#line 443 "pwl.c"
		}
#line 1308 "glib-2.0.vapi"
		return result;
#line 447 "pwl.c"
	}
}

gboolean
is_all_caps (const gchar* word)
{
	gboolean has_cap = FALSE;
	gunichar c = 0U;
	gboolean result;
#line 58 "pwl.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 59 "pwl.vala"
	has_cap = FALSE;
#line 461 "pwl.c"
	{
		gint i = 0;
#line 61 "pwl.vala"
		i = 0;
#line 466 "pwl.c"
		{
			gboolean _tmp0_ = FALSE;
#line 61 "pwl.vala"
			_tmp0_ = TRUE;
#line 61 "pwl.vala"
			while (TRUE) {
#line 473 "pwl.c"
				gunichar _tmp1_ = 0U;
				gboolean _tmp2_;
				GUnicodeType type = 0;
#line 61 "pwl.vala"
				if (!_tmp0_) {
#line 479 "pwl.c"
				}
#line 61 "pwl.vala"
				_tmp0_ = FALSE;
#line 61 "pwl.vala"
				_tmp2_ = string_get_next_char (word, &i, &_tmp1_);
#line 61 "pwl.vala"
				c = _tmp1_;
#line 61 "pwl.vala"
				if (!_tmp2_) {
#line 61 "pwl.vala"
					break;
#line 491 "pwl.c"
				}
#line 62 "pwl.vala"
				type = g_unichar_type (c);
#line 63 "pwl.vala"
				switch (type) {
#line 63 "pwl.vala"
					case G_UNICODE_UPPERCASE_LETTER:
#line 499 "pwl.c"
					{
#line 65 "pwl.vala"
						has_cap = TRUE;
#line 66 "pwl.vala"
						break;
#line 505 "pwl.c"
					}
#line 63 "pwl.vala"
					case G_UNICODE_TITLECASE_LETTER:
#line 63 "pwl.vala"
					case G_UNICODE_LOWERCASE_LETTER:
#line 511 "pwl.c"
					{
#line 69 "pwl.vala"
						result = FALSE;
#line 69 "pwl.vala"
						return result;
#line 517 "pwl.c"
					}
					default:
#line 63 "pwl.vala"
					case G_UNICODE_CONTROL:
#line 63 "pwl.vala"
					case G_UNICODE_FORMAT:
#line 63 "pwl.vala"
					case G_UNICODE_UNASSIGNED:
#line 63 "pwl.vala"
					case G_UNICODE_PRIVATE_USE:
#line 63 "pwl.vala"
					case G_UNICODE_SURROGATE:
#line 63 "pwl.vala"
					case G_UNICODE_MODIFIER_LETTER:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_LETTER:
#line 63 "pwl.vala"
					case G_UNICODE_SPACING_MARK:
#line 63 "pwl.vala"
					case G_UNICODE_ENCLOSING_MARK:
#line 63 "pwl.vala"
					case G_UNICODE_NON_SPACING_MARK:
#line 63 "pwl.vala"
					case G_UNICODE_DECIMAL_NUMBER:
#line 63 "pwl.vala"
					case G_UNICODE_LETTER_NUMBER:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_NUMBER:
#line 63 "pwl.vala"
					case G_UNICODE_CONNECT_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_DASH_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_CLOSE_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_FINAL_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_INITIAL_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_OPEN_PUNCTUATION:
#line 63 "pwl.vala"
					case G_UNICODE_CURRENCY_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_MODIFIER_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_MATH_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_OTHER_SYMBOL:
#line 63 "pwl.vala"
					case G_UNICODE_LINE_SEPARATOR:
#line 63 "pwl.vala"
					case G_UNICODE_PARAGRAPH_SEPARATOR:
#line 63 "pwl.vala"
					case G_UNICODE_SPACE_SEPARATOR:
#line 574 "pwl.c"
					{
#line 99 "pwl.vala"
						break;
#line 578 "pwl.c"
					}
				}
			}
		}
	}
#line 103 "pwl.vala"
	result = has_cap;
#line 103 "pwl.vala"
	return result;
#line 588 "pwl.c"
}

gboolean
is_title_case (const gchar* word)
{
	gint i = 0;
	gunichar c = 0U;
	gunichar _tmp0_ = 0U;
	GUnicodeType type = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
#line 106 "pwl.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 107 "pwl.vala"
	i = 0;
#line 109 "pwl.vala"
	string_get_next_char (word, &i, &_tmp0_);
#line 109 "pwl.vala"
	c = _tmp0_;
#line 110 "pwl.vala"
	type = g_unichar_type (c);
#line 111 "pwl.vala"
	if (type != G_UNICODE_UPPERCASE_LETTER) {
#line 111 "pwl.vala"
		_tmp2_ = type != G_UNICODE_TITLECASE_LETTER;
#line 615 "pwl.c"
	} else {
#line 111 "pwl.vala"
		_tmp2_ = FALSE;
#line 619 "pwl.c"
	}
#line 111 "pwl.vala"
	if (_tmp2_) {
#line 111 "pwl.vala"
		_tmp1_ = TRUE;
#line 625 "pwl.c"
	} else {
#line 112 "pwl.vala"
		_tmp1_ = c != g_unichar_totitle (c);
#line 629 "pwl.c"
	}
#line 111 "pwl.vala"
	if (_tmp1_) {
#line 113 "pwl.vala"
		result = FALSE;
#line 113 "pwl.vala"
		return result;
#line 637 "pwl.c"
	}
#line 115 "pwl.vala"
	while (TRUE) {
#line 641 "pwl.c"
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
#line 115 "pwl.vala"
		_tmp4_ = string_get_next_char (word, &i, &_tmp3_);
#line 115 "pwl.vala"
		c = _tmp3_;
#line 115 "pwl.vala"
		if (!_tmp4_) {
#line 115 "pwl.vala"
			break;
#line 653 "pwl.c"
		}
#line 116 "pwl.vala"
		type = g_unichar_type (c);
#line 117 "pwl.vala"
		if (type == G_UNICODE_UPPERCASE_LETTER) {
#line 117 "pwl.vala"
			_tmp5_ = TRUE;
#line 661 "pwl.c"
		} else {
#line 117 "pwl.vala"
			_tmp5_ = type == G_UNICODE_TITLECASE_LETTER;
#line 665 "pwl.c"
		}
#line 117 "pwl.vala"
		if (_tmp5_) {
#line 118 "pwl.vala"
			result = FALSE;
#line 118 "pwl.vala"
			return result;
#line 673 "pwl.c"
		}
	}
#line 121 "pwl.vala"
	result = TRUE;
#line 121 "pwl.vala"
	return result;
#line 680 "pwl.c"
}

static inline gpointer
enchant_pwl_get_instance_private (EnchantPWL* self)
{
	return G_STRUCT_MEMBER_P (self, EnchantPWL_private_offset);
}

static void
_g_free0_ (gpointer var)
{
#line 128 "pwl.vala"
	var = (g_free (var), NULL);
#line 694 "pwl.c"
}

EnchantPWL*
enchant_pwl_construct (GType object_type,
                       const gchar* filename,
                       gboolean exclude)
{
	EnchantPWL* self = NULL;
	gchar* _tmp0_;
#line 130 "pwl.vala"
	self = (EnchantPWL*) g_type_create_instance (object_type);
#line 131 "pwl.vala"
	_tmp0_ = g_strdup (filename);
#line 131 "pwl.vala"
	_g_free0 (self->priv->filename);
#line 131 "pwl.vala"
	self->priv->filename = _tmp0_;
#line 132 "pwl.vala"
	self->priv->exclude = exclude;
#line 130 "pwl.vala"
	return self;
#line 716 "pwl.c"
}

EnchantPWL*
enchant_pwl_new (const gchar* filename,
                 gboolean exclude)
{
#line 130 "pwl.vala"
	return enchant_pwl_construct (TYPE_ENCHANT_PWL, filename, exclude);
#line 725 "pwl.c"
}

static void
enchant_pwl_add_to_table (EnchantPWL* self,
                          const gchar* word)
{
	gchar* normalized_word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
#line 135 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 135 "pwl.vala"
	g_return_if_fail (word != NULL);
#line 136 "pwl.vala"
	_tmp0_ = g_utf8_normalize (word, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 136 "pwl.vala"
	normalized_word = _tmp0_;
#line 137 "pwl.vala"
	_tmp1_ = self->priv->words;
#line 137 "pwl.vala"
	_tmp2_ = normalized_word;
#line 137 "pwl.vala"
	if (!g_hash_table_contains (_tmp1_, _tmp2_)) {
#line 750 "pwl.c"
		GHashTable* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 138 "pwl.vala"
		_tmp3_ = self->priv->words;
#line 138 "pwl.vala"
		_tmp4_ = normalized_word;
#line 138 "pwl.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 138 "pwl.vala"
		_tmp6_ = g_strdup (word);
#line 138 "pwl.vala"
		g_hash_table_insert (_tmp3_, _tmp5_, _tmp6_);
#line 765 "pwl.c"
	}
#line 135 "pwl.vala"
	_g_free0 (normalized_word);
#line 769 "pwl.c"
}

void
enchant_pwl_add (EnchantPWL* self,
                 EnchantDict* session,
                 const gchar* word_buf,
                 ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 141 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 141 "pwl.vala"
	g_return_if_fail (session != NULL);
#line 141 "pwl.vala"
	g_return_if_fail (word_buf != NULL);
#line 142 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 142 "pwl.vala"
	word = _tmp0_;
#line 144 "pwl.vala"
	enchant_pwl_refresh_from_file (self, session);
#line 145 "pwl.vala"
	_tmp1_ = word;
#line 145 "pwl.vala"
	enchant_pwl_add_to_table (self, _tmp1_);
#line 147 "pwl.vala"
	_tmp2_ = self->priv->filename;
#line 147 "pwl.vala"
	if (_tmp2_ != NULL) {
#line 802 "pwl.c"
		FILE* f = NULL;
		const gchar* _tmp3_;
		FILE* _tmp4_;
		FILE* _tmp5_;
#line 148 "pwl.vala"
		_tmp3_ = self->priv->filename;
#line 148 "pwl.vala"
		_tmp4_ = g_fopen (_tmp3_, "a+");
#line 148 "pwl.vala"
		f = _tmp4_;
#line 149 "pwl.vala"
		_tmp5_ = f;
#line 149 "pwl.vala"
		if (_tmp5_ != NULL) {
#line 817 "pwl.c"
			FILE* _tmp6_;
			struct stat stats = {0};
			const gchar* _tmp7_;
			struct stat _tmp8_ = {0};
			gint _tmp9_;
			FILE* _tmp11_;
			FILE* _tmp15_;
			const gchar* _tmp16_;
			FILE* _tmp18_;
#line 152 "pwl.vala"
			_tmp6_ = f;
#line 152 "pwl.vala"
			lock_file (_tmp6_);
#line 154 "pwl.vala"
			_tmp7_ = self->priv->filename;
#line 154 "pwl.vala"
			_tmp9_ = stat (_tmp7_, &_tmp8_);
#line 154 "pwl.vala"
			stats = _tmp8_;
#line 154 "pwl.vala"
			if (_tmp9_ == 0) {
#line 839 "pwl.c"
				struct stat _tmp10_;
#line 155 "pwl.vala"
				_tmp10_ = stats;
#line 155 "pwl.vala"
				self->priv->file_changed = _tmp10_.st_mtime;
#line 845 "pwl.c"
			}
#line 158 "pwl.vala"
			_tmp11_ = f;
#line 158 "pwl.vala"
			if (fseek (_tmp11_, (glong) -1, SEEK_END) == 0) {
#line 851 "pwl.c"
				gint c = 0;
				FILE* _tmp12_;
				FILE* _tmp13_;
#line 159 "pwl.vala"
				_tmp12_ = f;
#line 159 "pwl.vala"
				c = fgetc (_tmp12_);
#line 160 "pwl.vala"
				_tmp13_ = f;
#line 160 "pwl.vala"
				fseek (_tmp13_, (glong) 0, SEEK_CUR);
#line 161 "pwl.vala"
				if (c != ((gint) '\n')) {
#line 865 "pwl.c"
					FILE* _tmp14_;
#line 162 "pwl.vala"
					_tmp14_ = f;
#line 162 "pwl.vala"
					fputc ('\n', _tmp14_);
#line 871 "pwl.c"
				}
			}
#line 165 "pwl.vala"
			_tmp15_ = f;
#line 165 "pwl.vala"
			_tmp16_ = word;
#line 165 "pwl.vala"
			if (fputs (_tmp16_, _tmp15_) != EOF) {
#line 880 "pwl.c"
				FILE* _tmp17_;
#line 166 "pwl.vala"
				_tmp17_ = f;
#line 166 "pwl.vala"
				fputc ('\n', _tmp17_);
#line 886 "pwl.c"
			}
#line 167 "pwl.vala"
			_tmp18_ = f;
#line 167 "pwl.vala"
			unlock_file (_tmp18_);
#line 892 "pwl.c"
		}
#line 147 "pwl.vala"
		_fclose0 (f);
#line 896 "pwl.c"
	}
#line 141 "pwl.vala"
	_g_free0 (word);
#line 900 "pwl.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 924 "pwl.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 932 "pwl.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 938 "pwl.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1503 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1503 "glib-2.0.vapi"
	end = _tmp0_;
#line 1504 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1504 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1505 "glib-2.0.vapi"
		result = maxlen;
#line 1505 "glib-2.0.vapi"
		return result;
#line 962 "pwl.c"
	} else {
		gchar* _tmp2_;
#line 1507 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1507 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1507 "glib-2.0.vapi"
		return result;
#line 971 "pwl.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1514 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1516 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 990 "pwl.c"
	} else {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 994 "pwl.c"
	}
#line 1516 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1518 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1000 "pwl.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1520 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1520 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1520 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1010 "pwl.c"
	}
#line 1523 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1524 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1018 "pwl.c"
	} else {
#line 1527 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1022 "pwl.c"
	}
#line 1529 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1530 "glib-2.0.vapi"
		len = string_length - offset;
#line 1028 "pwl.c"
	}
#line 1532 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1533 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1533 "glib-2.0.vapi"
	result = _tmp3_;
#line 1533 "glib-2.0.vapi"
	return result;
#line 1038 "pwl.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 1055 "pwl.c"
}

void
enchant_pwl_remove (EnchantPWL* self,
                    EnchantDict* session,
                    const gchar* word_buf,
                    ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 172 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 172 "pwl.vala"
	g_return_if_fail (session != NULL);
#line 172 "pwl.vala"
	g_return_if_fail (word_buf != NULL);
#line 173 "pwl.vala"
	enchant_pwl_refresh_from_file (self, session);
#line 175 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 175 "pwl.vala"
	word = _tmp0_;
#line 176 "pwl.vala"
	_tmp1_ = self->priv->words;
#line 176 "pwl.vala"
	_tmp2_ = word;
#line 176 "pwl.vala"
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 176 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 176 "pwl.vala"
	g_hash_table_remove (_tmp1_, _tmp4_);
#line 176 "pwl.vala"
	_g_free0 (_tmp4_);
#line 178 "pwl.vala"
	_tmp5_ = self->priv->filename;
#line 178 "pwl.vala"
	if (_tmp5_ != NULL) {
#line 1100 "pwl.c"
		gchar* contents = NULL;
		gsize length = 0UL;
		FILE* f = NULL;
		const gchar* _tmp9_;
		FILE* _tmp10_;
		FILE* _tmp11_;
		{
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gsize _tmp8_ = 0UL;
#line 182 "pwl.vala"
			_tmp6_ = self->priv->filename;
#line 182 "pwl.vala"
			g_file_get_contents (_tmp6_, &_tmp7_, &_tmp8_, &_inner_error0_);
#line 182 "pwl.vala"
			_g_free0 (contents);
#line 182 "pwl.vala"
			contents = _tmp7_;
#line 182 "pwl.vala"
			length = _tmp8_;
#line 182 "pwl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 182 "pwl.vala"
				if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1125 "pwl.c"
					goto __catch0_g_file_error;
				}
#line 182 "pwl.vala"
				_g_free0 (contents);
#line 182 "pwl.vala"
				_g_free0 (word);
#line 182 "pwl.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 182 "pwl.vala"
				g_clear_error (&_inner_error0_);
#line 182 "pwl.vala"
				return;
#line 1138 "pwl.c"
			}
		}
		goto __finally0;
		__catch0_g_file_error:
		{
#line 181 "pwl.vala"
			g_clear_error (&_inner_error0_);
#line 184 "pwl.vala"
			_g_free0 (contents);
#line 184 "pwl.vala"
			_g_free0 (word);
#line 184 "pwl.vala"
			return;
#line 1152 "pwl.c"
		}
		__finally0:
#line 181 "pwl.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "pwl.vala"
			_g_free0 (contents);
#line 181 "pwl.vala"
			_g_free0 (word);
#line 181 "pwl.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "pwl.vala"
			g_clear_error (&_inner_error0_);
#line 181 "pwl.vala"
			return;
#line 1167 "pwl.c"
		}
#line 187 "pwl.vala"
		_tmp9_ = self->priv->filename;
#line 187 "pwl.vala"
		_tmp10_ = g_fopen (_tmp9_, "wb");
#line 187 "pwl.vala"
		f = _tmp10_;
#line 188 "pwl.vala"
		_tmp11_ = f;
#line 188 "pwl.vala"
		if (_tmp11_ != NULL) {
#line 1179 "pwl.c"
			FILE* _tmp12_;
			glong filestart = 0L;
			const gchar* _tmp13_;
			struct stat stats = {0};
			const gchar* _tmp63_;
			struct stat _tmp64_ = {0};
			gint _tmp65_;
			FILE* _tmp67_;
#line 189 "pwl.vala"
			_tmp12_ = f;
#line 189 "pwl.vala"
			lock_file (_tmp12_);
#line 190 "pwl.vala"
			filestart = (glong) 0;
#line 193 "pwl.vala"
			_tmp13_ = contents;
#line 193 "pwl.vala"
			if (BOM == string_get_char (_tmp13_, filestart)) {
#line 1198 "pwl.c"
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				FILE* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 194 "pwl.vala"
				_tmp14_ = contents;
#line 194 "pwl.vala"
				_tmp15_ = g_utf8_next_char (_tmp14_);
#line 194 "pwl.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 194 "pwl.vala"
				_g_free0 (contents);
#line 194 "pwl.vala"
				contents = _tmp16_;
#line 195 "pwl.vala"
				_tmp17_ = f;
#line 195 "pwl.vala"
				_tmp18_ = g_unichar_to_string (BOM);
#line 195 "pwl.vala"
				_tmp19_ = _tmp18_;
#line 195 "pwl.vala"
				fputs (_tmp19_, _tmp17_);
#line 195 "pwl.vala"
				_g_free0 (_tmp19_);
#line 1225 "pwl.c"
			}
			{
				gint start_index = 0;
#line 198 "pwl.vala"
				start_index = 0;
#line 1231 "pwl.c"
				{
					gboolean _tmp20_ = FALSE;
#line 198 "pwl.vala"
					_tmp20_ = TRUE;
#line 198 "pwl.vala"
					while (TRUE) {
#line 1238 "pwl.c"
						gint word_pos = 0;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
#line 198 "pwl.vala"
						if (!_tmp20_) {
#line 1244 "pwl.c"
						}
#line 198 "pwl.vala"
						_tmp20_ = FALSE;
#line 200 "pwl.vala"
						_tmp21_ = contents;
#line 200 "pwl.vala"
						_tmp22_ = word;
#line 200 "pwl.vala"
						word_pos = string_index_of (_tmp21_, _tmp22_, start_index);
#line 201 "pwl.vala"
						if (word_pos == -1) {
#line 1256 "pwl.c"
							FILE* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
#line 202 "pwl.vala"
							_tmp23_ = f;
#line 202 "pwl.vala"
							_tmp24_ = contents;
#line 202 "pwl.vala"
							_tmp25_ = string_substring (_tmp24_, (glong) start_index, (glong) -1);
#line 202 "pwl.vala"
							_tmp26_ = _tmp25_;
#line 202 "pwl.vala"
							fputs (_tmp26_, _tmp23_);
#line 202 "pwl.vala"
							_g_free0 (_tmp26_);
#line 203 "pwl.vala"
							break;
#line 1275 "pwl.c"
						} else {
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
#line 205 "pwl.vala"
							if (word_pos == 0) {
#line 205 "pwl.vala"
								_tmp29_ = TRUE;
#line 1284 "pwl.c"
							} else {
								const gchar* _tmp30_;
#line 205 "pwl.vala"
								_tmp30_ = contents;
#line 205 "pwl.vala"
								_tmp29_ = string_get (_tmp30_, (glong) (word_pos - 1)) == '\n';
#line 1291 "pwl.c"
							}
#line 205 "pwl.vala"
							if (_tmp29_) {
#line 205 "pwl.vala"
								_tmp28_ = TRUE;
#line 1297 "pwl.c"
							} else {
								const gchar* _tmp31_;
#line 205 "pwl.vala"
								_tmp31_ = contents;
#line 205 "pwl.vala"
								_tmp28_ = string_get (_tmp31_, (glong) (word_pos - 1)) == '\r';
#line 1304 "pwl.c"
							}
#line 205 "pwl.vala"
							if (_tmp28_) {
#line 1308 "pwl.c"
								gboolean _tmp32_ = FALSE;
								gboolean _tmp33_ = FALSE;
								const gchar* _tmp34_;
								gint _tmp35_;
								gint _tmp36_;
								const gchar* _tmp37_;
								gint _tmp38_;
								gint _tmp39_;
#line 206 "pwl.vala"
								_tmp34_ = word;
#line 206 "pwl.vala"
								_tmp35_ = strlen (_tmp34_);
#line 206 "pwl.vala"
								_tmp36_ = _tmp35_;
#line 206 "pwl.vala"
								_tmp37_ = contents;
#line 206 "pwl.vala"
								_tmp38_ = strlen (_tmp37_);
#line 206 "pwl.vala"
								_tmp39_ = _tmp38_;
#line 206 "pwl.vala"
								if ((word_pos + _tmp36_) == _tmp39_) {
#line 206 "pwl.vala"
									_tmp33_ = TRUE;
#line 1333 "pwl.c"
								} else {
									const gchar* _tmp40_;
									const gchar* _tmp41_;
									gint _tmp42_;
									gint _tmp43_;
#line 206 "pwl.vala"
									_tmp40_ = contents;
#line 206 "pwl.vala"
									_tmp41_ = word;
#line 206 "pwl.vala"
									_tmp42_ = strlen (_tmp41_);
#line 206 "pwl.vala"
									_tmp43_ = _tmp42_;
#line 206 "pwl.vala"
									_tmp33_ = string_get (_tmp40_, (glong) (word_pos + _tmp43_)) == '\n';
#line 1349 "pwl.c"
								}
#line 206 "pwl.vala"
								if (_tmp33_) {
#line 206 "pwl.vala"
									_tmp32_ = TRUE;
#line 1355 "pwl.c"
								} else {
									const gchar* _tmp44_;
									const gchar* _tmp45_;
									gint _tmp46_;
									gint _tmp47_;
#line 206 "pwl.vala"
									_tmp44_ = contents;
#line 206 "pwl.vala"
									_tmp45_ = word;
#line 206 "pwl.vala"
									_tmp46_ = strlen (_tmp45_);
#line 206 "pwl.vala"
									_tmp47_ = _tmp46_;
#line 206 "pwl.vala"
									_tmp32_ = string_get (_tmp44_, (glong) (word_pos + _tmp47_)) == '\r';
#line 1371 "pwl.c"
								}
#line 206 "pwl.vala"
								_tmp27_ = _tmp32_;
#line 1375 "pwl.c"
							} else {
#line 205 "pwl.vala"
								_tmp27_ = FALSE;
#line 1379 "pwl.c"
							}
#line 205 "pwl.vala"
							if (_tmp27_) {
#line 1383 "pwl.c"
								FILE* _tmp48_;
								const gchar* _tmp49_;
								gchar* _tmp50_;
								gchar* _tmp51_;
								const gchar* _tmp52_;
								gint _tmp53_;
								gint _tmp54_;
#line 207 "pwl.vala"
								_tmp48_ = f;
#line 207 "pwl.vala"
								_tmp49_ = contents;
#line 207 "pwl.vala"
								_tmp50_ = string_substring (_tmp49_, (glong) start_index, (glong) (word_pos - start_index));
#line 207 "pwl.vala"
								_tmp51_ = _tmp50_;
#line 207 "pwl.vala"
								fputs (_tmp51_, _tmp48_);
#line 207 "pwl.vala"
								_g_free0 (_tmp51_);
#line 208 "pwl.vala"
								_tmp52_ = word;
#line 208 "pwl.vala"
								_tmp53_ = strlen (_tmp52_);
#line 208 "pwl.vala"
								_tmp54_ = _tmp53_;
#line 208 "pwl.vala"
								start_index = word_pos + _tmp54_;
#line 209 "pwl.vala"
								while (TRUE) {
#line 1413 "pwl.c"
									gboolean _tmp55_ = FALSE;
									const gchar* _tmp56_;
									gint _tmp58_;
#line 209 "pwl.vala"
									_tmp56_ = contents;
#line 209 "pwl.vala"
									if (string_get (_tmp56_, (glong) start_index) == '\n') {
#line 209 "pwl.vala"
										_tmp55_ = TRUE;
#line 1423 "pwl.c"
									} else {
										const gchar* _tmp57_;
#line 209 "pwl.vala"
										_tmp57_ = contents;
#line 209 "pwl.vala"
										_tmp55_ = string_get (_tmp57_, (glong) start_index) == '\r';
#line 1430 "pwl.c"
									}
#line 209 "pwl.vala"
									if (!_tmp55_) {
#line 209 "pwl.vala"
										break;
#line 1436 "pwl.c"
									}
#line 210 "pwl.vala"
									start_index = start_index + 1;
#line 210 "pwl.vala"
									_tmp58_ = start_index;
#line 1442 "pwl.c"
								}
							} else {
								FILE* _tmp59_;
								const gchar* _tmp60_;
								gchar* _tmp61_;
								gchar* _tmp62_;
#line 212 "pwl.vala"
								_tmp59_ = f;
#line 212 "pwl.vala"
								_tmp60_ = contents;
#line 212 "pwl.vala"
								_tmp61_ = string_substring (_tmp60_, (glong) start_index, (glong) ((word_pos - start_index) + 1));
#line 212 "pwl.vala"
								_tmp62_ = _tmp61_;
#line 212 "pwl.vala"
								fputs (_tmp62_, _tmp59_);
#line 212 "pwl.vala"
								_g_free0 (_tmp62_);
#line 213 "pwl.vala"
								start_index = word_pos + 1;
#line 1463 "pwl.c"
							}
						}
					}
				}
			}
#line 219 "pwl.vala"
			_tmp63_ = self->priv->filename;
#line 219 "pwl.vala"
			_tmp65_ = stat (_tmp63_, &_tmp64_);
#line 219 "pwl.vala"
			stats = _tmp64_;
#line 219 "pwl.vala"
			if (_tmp65_ == 0) {
#line 1477 "pwl.c"
				struct stat _tmp66_;
#line 220 "pwl.vala"
				_tmp66_ = stats;
#line 220 "pwl.vala"
				self->priv->file_changed = _tmp66_.st_mtime;
#line 1483 "pwl.c"
			}
#line 222 "pwl.vala"
			_tmp67_ = f;
#line 222 "pwl.vala"
			unlock_file (_tmp67_);
#line 1489 "pwl.c"
		}
#line 178 "pwl.vala"
		_fclose0 (f);
#line 178 "pwl.vala"
		_g_free0 (contents);
#line 1495 "pwl.c"
	}
#line 172 "pwl.vala"
	_g_free0 (word);
#line 1499 "pwl.c"
}

gint
enchant_pwl_check (EnchantPWL* self,
                   EnchantDict* session,
                   const gchar* word_buf,
                   ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean all_caps = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gint result;
#line 227 "pwl.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 227 "pwl.vala"
	g_return_val_if_fail (session != NULL, 0);
#line 227 "pwl.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 228 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 228 "pwl.vala"
	word = _tmp0_;
#line 229 "pwl.vala"
	enchant_pwl_refresh_from_file (self, session);
#line 231 "pwl.vala"
	_tmp1_ = self->priv->words;
#line 231 "pwl.vala"
	_tmp2_ = word;
#line 231 "pwl.vala"
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 231 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 231 "pwl.vala"
	_tmp5_ = g_hash_table_contains (_tmp1_, _tmp4_);
#line 231 "pwl.vala"
	_g_free0 (_tmp4_);
#line 231 "pwl.vala"
	if (_tmp5_) {
#line 232 "pwl.vala"
		result = 0;
#line 232 "pwl.vala"
		_g_free0 (word);
#line 232 "pwl.vala"
		return result;
#line 1551 "pwl.c"
	}
#line 234 "pwl.vala"
	all_caps = FALSE;
#line 235 "pwl.vala"
	_tmp7_ = word;
#line 235 "pwl.vala"
	if (is_title_case (_tmp7_)) {
#line 235 "pwl.vala"
		_tmp6_ = TRUE;
#line 1561 "pwl.c"
	} else {
		const gchar* _tmp8_;
#line 235 "pwl.vala"
		_tmp8_ = word;
#line 235 "pwl.vala"
		all_caps = is_all_caps (_tmp8_);
#line 235 "pwl.vala"
		_tmp6_ = all_caps;
#line 1570 "pwl.c"
	}
#line 235 "pwl.vala"
	if (_tmp6_) {
#line 1574 "pwl.c"
		gchar* lower_case_word = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GHashTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
#line 236 "pwl.vala"
		_tmp9_ = word;
#line 236 "pwl.vala"
		_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
#line 236 "pwl.vala"
		lower_case_word = _tmp10_;
#line 237 "pwl.vala"
		_tmp11_ = self->priv->words;
#line 237 "pwl.vala"
		_tmp12_ = lower_case_word;
#line 237 "pwl.vala"
		_tmp13_ = g_utf8_normalize (_tmp12_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 237 "pwl.vala"
		_tmp14_ = _tmp13_;
#line 237 "pwl.vala"
		_tmp15_ = g_hash_table_contains (_tmp11_, _tmp14_);
#line 237 "pwl.vala"
		_g_free0 (_tmp14_);
#line 237 "pwl.vala"
		if (_tmp15_) {
#line 238 "pwl.vala"
			result = 0;
#line 238 "pwl.vala"
			_g_free0 (lower_case_word);
#line 238 "pwl.vala"
			_g_free0 (word);
#line 238 "pwl.vala"
			return result;
#line 1611 "pwl.c"
		}
#line 240 "pwl.vala"
		if (all_caps) {
#line 1615 "pwl.c"
			gchar* title_case_word = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			GHashTable* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_;
#line 241 "pwl.vala"
			_tmp16_ = word;
#line 241 "pwl.vala"
			_tmp17_ = utf8_strtitle (_tmp16_);
#line 241 "pwl.vala"
			title_case_word = _tmp17_;
#line 242 "pwl.vala"
			_tmp18_ = self->priv->words;
#line 242 "pwl.vala"
			_tmp19_ = title_case_word;
#line 242 "pwl.vala"
			_tmp20_ = g_utf8_normalize (_tmp19_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 242 "pwl.vala"
			_tmp21_ = _tmp20_;
#line 242 "pwl.vala"
			_tmp22_ = g_hash_table_contains (_tmp18_, _tmp21_);
#line 242 "pwl.vala"
			_g_free0 (_tmp21_);
#line 242 "pwl.vala"
			if (_tmp22_) {
#line 243 "pwl.vala"
				result = 0;
#line 243 "pwl.vala"
				_g_free0 (title_case_word);
#line 243 "pwl.vala"
				_g_free0 (lower_case_word);
#line 243 "pwl.vala"
				_g_free0 (word);
#line 243 "pwl.vala"
				return result;
#line 1654 "pwl.c"
			}
#line 240 "pwl.vala"
			_g_free0 (title_case_word);
#line 1658 "pwl.c"
		}
#line 235 "pwl.vala"
		_g_free0 (lower_case_word);
#line 1662 "pwl.c"
	}
#line 247 "pwl.vala"
	result = 1;
#line 247 "pwl.vala"
	_g_free0 (word);
#line 247 "pwl.vala"
	return result;
#line 1670 "pwl.c"
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
#line 4101 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 4103 "glib-2.0.vapi"
	ret = NULL;
#line 4104 "glib-2.0.vapi"
	while (TRUE) {
#line 1686 "pwl.c"
		GString* _tmp0_;
		GString* _tmp2_;
#line 4104 "glib-2.0.vapi"
		c = fgetc (self);
#line 4104 "glib-2.0.vapi"
		if (!(c != EOF)) {
#line 4104 "glib-2.0.vapi"
			break;
#line 1695 "pwl.c"
		}
#line 4105 "glib-2.0.vapi"
		_tmp0_ = ret;
#line 4105 "glib-2.0.vapi"
		if (_tmp0_ == NULL) {
#line 1701 "pwl.c"
			GString* _tmp1_;
#line 4106 "glib-2.0.vapi"
			_tmp1_ = g_string_new ("");
#line 4106 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 4106 "glib-2.0.vapi"
			ret = _tmp1_;
#line 1709 "pwl.c"
		}
#line 4108 "glib-2.0.vapi"
		if (c == ((gint) '\n')) {
#line 4109 "glib-2.0.vapi"
			break;
#line 1715 "pwl.c"
		}
#line 4111 "glib-2.0.vapi"
		_tmp2_ = ret;
#line 4111 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
#line 1721 "pwl.c"
	}
#line 4113 "glib-2.0.vapi"
	_tmp3_ = ret;
#line 4113 "glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4114 "glib-2.0.vapi"
		result = NULL;
#line 4114 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4114 "glib-2.0.vapi"
		return result;
#line 1733 "pwl.c"
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
#line 4116 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 4116 "glib-2.0.vapi"
		_tmp5_ = ((GString*) _tmp4_)->str;
#line 4116 "glib-2.0.vapi"
		((GString*) _tmp4_)->str = NULL;
#line 4116 "glib-2.0.vapi"
		result = _tmp5_;
#line 4116 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4116 "glib-2.0.vapi"
		return result;
#line 1749 "pwl.c"
	}
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1399 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1400 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1400 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1401 "glib-2.0.vapi"
	g_strchomp (_result_);
#line 1402 "glib-2.0.vapi"
	result = _result_;
#line 1402 "glib-2.0.vapi"
	return result;
#line 1771 "pwl.c"
}

static void
enchant_pwl_refresh_from_file (EnchantPWL* self,
                               EnchantDict* session)
{
	const gchar* _tmp0_;
	struct stat stats = {0};
	const gchar* _tmp1_;
	struct stat _tmp2_ = {0};
	gint _tmp3_;
	struct stat _tmp4_;
	FILE* f = NULL;
	const gchar* _tmp5_;
	FILE* _tmp6_;
	FILE* _tmp7_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	struct stat _tmp18_;
	FILE* _tmp19_;
	gsize line_number = 0UL;
	gchar* line = NULL;
	FILE* _tmp38_;
#line 250 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 250 "pwl.vala"
	g_return_if_fail (session != NULL);
#line 251 "pwl.vala"
	_tmp0_ = self->priv->filename;
#line 251 "pwl.vala"
	if (_tmp0_ == NULL) {
#line 252 "pwl.vala"
		return;
#line 1806 "pwl.c"
	}
#line 255 "pwl.vala"
	_tmp1_ = self->priv->filename;
#line 255 "pwl.vala"
	_tmp3_ = stat (_tmp1_, &_tmp2_);
#line 255 "pwl.vala"
	stats = _tmp2_;
#line 255 "pwl.vala"
	if (_tmp3_ == -1) {
#line 256 "pwl.vala"
		return;
#line 1818 "pwl.c"
	}
#line 257 "pwl.vala"
	_tmp4_ = stats;
#line 257 "pwl.vala"
	if (self->priv->file_changed == _tmp4_.st_mtime) {
#line 258 "pwl.vala"
		return;
#line 1826 "pwl.c"
	}
#line 260 "pwl.vala"
	_tmp5_ = self->priv->filename;
#line 260 "pwl.vala"
	_tmp6_ = g_fopen (_tmp5_, "r");
#line 260 "pwl.vala"
	f = _tmp6_;
#line 261 "pwl.vala"
	_tmp7_ = f;
#line 261 "pwl.vala"
	if (_tmp7_ == NULL) {
#line 262 "pwl.vala"
		_fclose0 (f);
#line 262 "pwl.vala"
		return;
#line 1842 "pwl.c"
	}
#line 265 "pwl.vala"
	if (!self->priv->exclude) {
#line 1846 "pwl.c"
		GHashTable* _tmp8_;
		GList* _tmp9_;
#line 266 "pwl.vala"
		_tmp8_ = self->priv->words;
#line 266 "pwl.vala"
		_tmp9_ = g_hash_table_get_keys (_tmp8_);
#line 1853 "pwl.c"
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
#line 266 "pwl.vala"
			w_collection = _tmp9_;
#line 266 "pwl.vala"
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
#line 1861 "pwl.c"
				gchar* _tmp10_;
				gchar* w = NULL;
#line 266 "pwl.vala"
				_tmp10_ = g_strdup ((const gchar*) w_it->data);
#line 266 "pwl.vala"
				w = _tmp10_;
#line 1868 "pwl.c"
				{
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 267 "pwl.vala"
					_tmp11_ = w;
#line 267 "pwl.vala"
					_tmp12_ = w;
#line 267 "pwl.vala"
					_tmp13_ = strlen (_tmp12_);
#line 267 "pwl.vala"
					_tmp14_ = _tmp13_;
#line 267 "pwl.vala"
					enchant_dict_remove_from_session (session, _tmp11_, (ssize_t) _tmp14_);
#line 266 "pwl.vala"
					_g_free0 (w);
#line 1886 "pwl.c"
				}
			}
#line 266 "pwl.vala"
			(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
#line 1891 "pwl.c"
		}
	}
#line 270 "pwl.vala"
	_tmp15_ = g_str_hash;
#line 270 "pwl.vala"
	_tmp16_ = g_str_equal;
#line 270 "pwl.vala"
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, _g_free0_);
#line 270 "pwl.vala"
	_g_hash_table_unref0 (self->priv->words);
#line 270 "pwl.vala"
	self->priv->words = _tmp17_;
#line 272 "pwl.vala"
	_tmp18_ = stats;
#line 272 "pwl.vala"
	self->priv->file_changed = _tmp18_.st_mtime;
#line 273 "pwl.vala"
	_tmp19_ = f;
#line 273 "pwl.vala"
	lock_file (_tmp19_);
#line 275 "pwl.vala"
	line_number = (gsize) 1;
#line 1914 "pwl.c"
	{
		gboolean _tmp20_ = FALSE;
#line 277 "pwl.vala"
		_tmp20_ = TRUE;
#line 277 "pwl.vala"
		while (TRUE) {
#line 1921 "pwl.c"
			FILE* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			const gchar* _tmp33_;
#line 277 "pwl.vala"
			if (!_tmp20_) {
#line 1932 "pwl.c"
				gsize _tmp21_;
#line 277 "pwl.vala"
				line_number = line_number + 1;
#line 277 "pwl.vala"
				_tmp21_ = line_number;
#line 1938 "pwl.c"
			}
#line 277 "pwl.vala"
			_tmp20_ = FALSE;
#line 277 "pwl.vala"
			_tmp22_ = f;
#line 277 "pwl.vala"
			_tmp23_ = g_file_stream_read_line (_tmp22_);
#line 277 "pwl.vala"
			_g_free0 (line);
#line 277 "pwl.vala"
			line = _tmp23_;
#line 277 "pwl.vala"
			_tmp24_ = line;
#line 277 "pwl.vala"
			if (!(_tmp24_ != NULL)) {
#line 277 "pwl.vala"
				break;
#line 1956 "pwl.c"
			}
#line 278 "pwl.vala"
			if (line_number == ((gsize) 1)) {
#line 1960 "pwl.c"
				const gchar* _tmp26_;
#line 278 "pwl.vala"
				_tmp26_ = line;
#line 278 "pwl.vala"
				_tmp25_ = BOM == string_get_char (_tmp26_, (glong) 0);
#line 1966 "pwl.c"
			} else {
#line 278 "pwl.vala"
				_tmp25_ = FALSE;
#line 1970 "pwl.c"
			}
#line 278 "pwl.vala"
			if (_tmp25_) {
#line 1974 "pwl.c"
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
#line 279 "pwl.vala"
				_tmp27_ = line;
#line 279 "pwl.vala"
				_tmp28_ = g_utf8_next_char (_tmp27_);
#line 279 "pwl.vala"
				_tmp29_ = g_strdup (_tmp28_);
#line 279 "pwl.vala"
				_g_free0 (line);
#line 279 "pwl.vala"
				line = _tmp29_;
#line 1988 "pwl.c"
			}
#line 281 "pwl.vala"
			_tmp30_ = line;
#line 281 "pwl.vala"
			_tmp31_ = string_chomp (_tmp30_);
#line 281 "pwl.vala"
			_g_free0 (line);
#line 281 "pwl.vala"
			line = _tmp31_;
#line 282 "pwl.vala"
			_tmp33_ = line;
#line 282 "pwl.vala"
			if (string_get (_tmp33_, (glong) 0) != '\0') {
#line 2002 "pwl.c"
				const gchar* _tmp34_;
#line 282 "pwl.vala"
				_tmp34_ = line;
#line 282 "pwl.vala"
				_tmp32_ = string_get (_tmp34_, (glong) 0) != '#';
#line 2008 "pwl.c"
			} else {
#line 282 "pwl.vala"
				_tmp32_ = FALSE;
#line 2012 "pwl.c"
			}
#line 282 "pwl.vala"
			if (_tmp32_) {
#line 2016 "pwl.c"
				const gchar* _tmp35_;
#line 283 "pwl.vala"
				_tmp35_ = line;
#line 283 "pwl.vala"
				if (g_utf8_validate (_tmp35_, (gssize) -1, NULL)) {
#line 2022 "pwl.c"
					const gchar* _tmp36_;
#line 284 "pwl.vala"
					_tmp36_ = line;
#line 284 "pwl.vala"
					enchant_pwl_add_to_table (self, _tmp36_);
#line 2028 "pwl.c"
				} else {
					const gchar* _tmp37_;
#line 286 "pwl.vala"
					_tmp37_ = self->priv->filename;
#line 286 "pwl.vala"
					g_warning ("pwl.vala:286: Bad UTF-8 sequence in %s at line:%zu", _tmp37_, line_number);
#line 2035 "pwl.c"
				}
			}
		}
	}
#line 290 "pwl.vala"
	_tmp38_ = f;
#line 290 "pwl.vala"
	unlock_file (_tmp38_);
#line 293 "pwl.vala"
	if (!self->priv->exclude) {
#line 2046 "pwl.c"
		GHashTable* _tmp39_;
		GList* _tmp40_;
#line 294 "pwl.vala"
		_tmp39_ = self->priv->words;
#line 294 "pwl.vala"
		_tmp40_ = g_hash_table_get_keys (_tmp39_);
#line 2053 "pwl.c"
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
#line 294 "pwl.vala"
			w_collection = _tmp40_;
#line 294 "pwl.vala"
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
#line 2061 "pwl.c"
				gchar* _tmp41_;
				gchar* w = NULL;
#line 294 "pwl.vala"
				_tmp41_ = g_strdup ((const gchar*) w_it->data);
#line 294 "pwl.vala"
				w = _tmp41_;
#line 2068 "pwl.c"
				{
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
#line 295 "pwl.vala"
					_tmp42_ = w;
#line 295 "pwl.vala"
					_tmp43_ = w;
#line 295 "pwl.vala"
					_tmp44_ = strlen (_tmp43_);
#line 295 "pwl.vala"
					_tmp45_ = _tmp44_;
#line 295 "pwl.vala"
					enchant_dict_add_to_session (session, _tmp42_, (ssize_t) _tmp45_);
#line 294 "pwl.vala"
					_g_free0 (w);
#line 2086 "pwl.c"
				}
			}
#line 294 "pwl.vala"
			(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
#line 2091 "pwl.c"
		}
	}
#line 250 "pwl.vala"
	_g_free0 (line);
#line 250 "pwl.vala"
	_fclose0 (f);
#line 2098 "pwl.c"
}

static void
value_enchant_pwl_init (GValue* value)
{
#line 124 "pwl.vala"
	value->data[0].v_pointer = NULL;
#line 2106 "pwl.c"
}

static void
value_enchant_pwl_free_value (GValue* value)
{
#line 124 "pwl.vala"
	if (value->data[0].v_pointer) {
#line 124 "pwl.vala"
		enchant_pwl_unref (value->data[0].v_pointer);
#line 2116 "pwl.c"
	}
}

static void
value_enchant_pwl_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 124 "pwl.vala"
	if (src_value->data[0].v_pointer) {
#line 124 "pwl.vala"
		dest_value->data[0].v_pointer = enchant_pwl_ref (src_value->data[0].v_pointer);
#line 2128 "pwl.c"
	} else {
#line 124 "pwl.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2132 "pwl.c"
	}
}

static gpointer
value_enchant_pwl_peek_pointer (const GValue* value)
{
#line 124 "pwl.vala"
	return value->data[0].v_pointer;
#line 2141 "pwl.c"
}

static gchar*
value_enchant_pwl_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 124 "pwl.vala"
	if (collect_values[0].v_pointer) {
#line 2152 "pwl.c"
		EnchantPWL * object;
		object = collect_values[0].v_pointer;
#line 124 "pwl.vala"
		if (object->parent_instance.g_class == NULL) {
#line 124 "pwl.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2159 "pwl.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 124 "pwl.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2163 "pwl.c"
		}
#line 124 "pwl.vala"
		value->data[0].v_pointer = enchant_pwl_ref (object);
#line 2167 "pwl.c"
	} else {
#line 124 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2171 "pwl.c"
	}
#line 124 "pwl.vala"
	return NULL;
#line 2175 "pwl.c"
}

static gchar*
value_enchant_pwl_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	EnchantPWL ** object_p;
	object_p = collect_values[0].v_pointer;
#line 124 "pwl.vala"
	if (!object_p) {
#line 124 "pwl.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2190 "pwl.c"
	}
#line 124 "pwl.vala"
	if (!value->data[0].v_pointer) {
#line 124 "pwl.vala"
		*object_p = NULL;
#line 2196 "pwl.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 124 "pwl.vala"
		*object_p = value->data[0].v_pointer;
#line 2200 "pwl.c"
	} else {
#line 124 "pwl.vala"
		*object_p = enchant_pwl_ref (value->data[0].v_pointer);
#line 2204 "pwl.c"
	}
#line 124 "pwl.vala"
	return NULL;
#line 2208 "pwl.c"
}

GParamSpec*
param_spec_enchant_pwl (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecEnchantPWL* spec;
#line 124 "pwl.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_PWL), NULL);
#line 124 "pwl.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 124 "pwl.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 124 "pwl.vala"
	return G_PARAM_SPEC (spec);
#line 2227 "pwl.c"
}

gpointer
value_get_enchant_pwl (const GValue* value)
{
#line 124 "pwl.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL), NULL);
#line 124 "pwl.vala"
	return value->data[0].v_pointer;
#line 2237 "pwl.c"
}

void
value_set_enchant_pwl (GValue* value,
                       gpointer v_object)
{
	EnchantPWL * old;
#line 124 "pwl.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
	old = value->data[0].v_pointer;
#line 124 "pwl.vala"
	if (v_object) {
#line 124 "pwl.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 124 "pwl.vala"
		value->data[0].v_pointer = v_object;
#line 124 "pwl.vala"
		enchant_pwl_ref (value->data[0].v_pointer);
#line 2259 "pwl.c"
	} else {
#line 124 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2263 "pwl.c"
	}
#line 124 "pwl.vala"
	if (old) {
#line 124 "pwl.vala"
		enchant_pwl_unref (old);
#line 2269 "pwl.c"
	}
}

void
value_take_enchant_pwl (GValue* value,
                        gpointer v_object)
{
	EnchantPWL * old;
#line 124 "pwl.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
	old = value->data[0].v_pointer;
#line 124 "pwl.vala"
	if (v_object) {
#line 124 "pwl.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PWL));
#line 124 "pwl.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 124 "pwl.vala"
		value->data[0].v_pointer = v_object;
#line 2290 "pwl.c"
	} else {
#line 124 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2294 "pwl.c"
	}
#line 124 "pwl.vala"
	if (old) {
#line 124 "pwl.vala"
		enchant_pwl_unref (old);
#line 2300 "pwl.c"
	}
}

static void
enchant_pwl_class_init (EnchantPWLClass * klass,
                        gpointer klass_data)
{
#line 124 "pwl.vala"
	enchant_pwl_parent_class = g_type_class_peek_parent (klass);
#line 124 "pwl.vala"
	((EnchantPWLClass *) klass)->finalize = enchant_pwl_finalize;
#line 124 "pwl.vala"
	g_type_class_adjust_private_offset (klass, &EnchantPWL_private_offset);
#line 2314 "pwl.c"
}

static void
enchant_pwl_instance_init (EnchantPWL * self,
                           gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 124 "pwl.vala"
	self->priv = enchant_pwl_get_instance_private (self);
#line 126 "pwl.vala"
	self->priv->exclude = FALSE;
#line 127 "pwl.vala"
	self->priv->file_changed = (time_t) 0;
#line 128 "pwl.vala"
	_tmp0_ = g_str_hash;
#line 128 "pwl.vala"
	_tmp1_ = g_str_equal;
#line 128 "pwl.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
#line 128 "pwl.vala"
	self->priv->words = _tmp2_;
#line 124 "pwl.vala"
	self->ref_count = 1;
#line 2340 "pwl.c"
}

static void
enchant_pwl_finalize (EnchantPWL * obj)
{
	EnchantPWL * self;
#line 124 "pwl.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_PWL, EnchantPWL);
#line 124 "pwl.vala"
	g_signal_handlers_destroy (self);
#line 125 "pwl.vala"
	_g_free0 (self->priv->filename);
#line 128 "pwl.vala"
	_g_hash_table_unref0 (self->priv->words);
#line 2355 "pwl.c"
}

static GType
enchant_pwl_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_pwl_init, value_enchant_pwl_free_value, value_enchant_pwl_copy_value, value_enchant_pwl_peek_pointer, "p", value_enchant_pwl_collect_value, "p", value_enchant_pwl_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantPWLClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_pwl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantPWL), 0, (GInstanceInitFunc) enchant_pwl_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_pwl_type_id;
	enchant_pwl_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantPWL", &g_define_type_info, &g_define_type_fundamental_info, 0);
	EnchantPWL_private_offset = g_type_add_instance_private (enchant_pwl_type_id, sizeof (EnchantPWLPrivate));
	return enchant_pwl_type_id;
}

GType
enchant_pwl_get_type (void)
{
	static volatile gsize enchant_pwl_type_id__once = 0;
	if (g_once_init_enter (&enchant_pwl_type_id__once)) {
		GType enchant_pwl_type_id;
		enchant_pwl_type_id = enchant_pwl_get_type_once ();
		g_once_init_leave (&enchant_pwl_type_id__once, enchant_pwl_type_id);
	}
	return enchant_pwl_type_id__once;
}

gpointer
enchant_pwl_ref (gpointer instance)
{
	EnchantPWL * self;
	self = instance;
#line 124 "pwl.vala"
	g_atomic_int_inc (&self->ref_count);
#line 124 "pwl.vala"
	return instance;
#line 2391 "pwl.c"
}

void
enchant_pwl_unref (gpointer instance)
{
	EnchantPWL * self;
	self = instance;
#line 124 "pwl.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 124 "pwl.vala"
		ENCHANT_PWL_GET_CLASS (self)->finalize (self);
#line 124 "pwl.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2405 "pwl.c"
	}
}

gint
check_impl (EnchantProviderDict* me,
            const gchar* word,
            size_t len)
{
	gint result;
#line 300 "pwl.vala"
	g_return_val_if_fail (me != NULL, 0);
#line 300 "pwl.vala"
	g_return_val_if_fail (word != NULL, 0);
#line 301 "pwl.vala"
	result = 1;
#line 301 "pwl.vala"
	return result;
#line 2423 "pwl.c"
}

gchar**
suggest_impl (EnchantProviderDict* me,
              const gchar* word,
              size_t len,
              size_t* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** result;
#line 305 "pwl.vala"
	g_return_val_if_fail (me != NULL, NULL);
#line 305 "pwl.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 306 "pwl.vala"
	_tmp0_ = NULL;
#line 306 "pwl.vala"
	_tmp0__length1 = 0;
#line 306 "pwl.vala"
	if (result_length1) {
#line 306 "pwl.vala"
		*result_length1 = _tmp0__length1;
#line 2447 "pwl.c"
	}
#line 306 "pwl.vala"
	result = _tmp0_;
#line 306 "pwl.vala"
	return result;
#line 2453 "pwl.c"
}

static gint
_check_impl_dict_check (EnchantProviderDict* me,
                        const gchar* word,
                        size_t len)
{
	gint result;
	result = check_impl (me, word, len);
#line 312 "pwl.vala"
	return result;
#line 2465 "pwl.c"
}

static gchar**
_suggest_impl_dict_suggest (EnchantProviderDict* me,
                            const gchar* word,
                            size_t len,
                            size_t* result_length1)
{
	gchar** result;
	result = suggest_impl (me, word, len, result_length1);
#line 313 "pwl.vala"
	return result;
#line 2478 "pwl.c"
}

EnchantPwlDict*
enchant_pwl_dict_construct (GType object_type)
{
	EnchantPwlDict* self = NULL;
#line 311 "pwl.vala"
	self = (EnchantPwlDict*) enchant_provider_dict_construct (object_type, NULL, "Personal Wordlist");
#line 312 "pwl.vala"
	((EnchantProviderDict*) self)->check_method = _check_impl_dict_check;
#line 313 "pwl.vala"
	((EnchantProviderDict*) self)->suggest_method = _suggest_impl_dict_suggest;
#line 310 "pwl.vala"
	return self;
#line 2493 "pwl.c"
}

EnchantPwlDict*
enchant_pwl_dict_new (void)
{
#line 310 "pwl.vala"
	return enchant_pwl_dict_construct (TYPE_ENCHANT_PWL_DICT);
#line 2501 "pwl.c"
}

static void
enchant_pwl_dict_class_init (EnchantPwlDictClass * klass,
                             gpointer klass_data)
{
#line 309 "pwl.vala"
	enchant_pwl_dict_parent_class = g_type_class_peek_parent (klass);
#line 2510 "pwl.c"
}

static void
enchant_pwl_dict_instance_init (EnchantPwlDict * self,
                                gpointer klass)
{
}

static GType
enchant_pwl_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EnchantPwlDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_pwl_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantPwlDict), 0, (GInstanceInitFunc) enchant_pwl_dict_instance_init, NULL };
	GType enchant_pwl_dict_type_id;
	enchant_pwl_dict_type_id = g_type_register_static (TYPE_ENCHANT_PROVIDER_DICT, "EnchantPwlDict", &g_define_type_info, 0);
	return enchant_pwl_dict_type_id;
}

GType
enchant_pwl_dict_get_type (void)
{
	static volatile gsize enchant_pwl_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_pwl_dict_type_id__once)) {
		GType enchant_pwl_dict_type_id;
		enchant_pwl_dict_type_id = enchant_pwl_dict_get_type_once ();
		g_once_init_leave (&enchant_pwl_dict_type_id__once, enchant_pwl_dict_type_id);
	}
	return enchant_pwl_dict_type_id__once;
}

