
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "locationbar_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "squeezelabelv2_wrapper.h"

// inner classes
#include "locationbar_loadaction_wrapper.h"

// Wrappers
#include "lineedit_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_LocationBar_Type = nullptr;
static PyTypeObject *Sbk_LocationBar_TypeF(void)
{
    return _Sbk_LocationBar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void LocationBarWrapper::pysideInitQtMetaTypes()
{
}

void LocationBarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

LocationBarWrapper::LocationBarWrapper(::QWidget * parent) : LocationBar(parent)
{
}

void LocationBarWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::changeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_changeEvent("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("LocationBar", funcName, gil, pyOverride, signal);
}

void LocationBarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("LocationBar", funcName, gil, pyOverride, event);
}

int LocationBarWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("LocationBar", funcName, gil, pyOverride);
}

void LocationBarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("LocationBar", funcName, gil, pyOverride, signal);
}

void LocationBarWrapper::dragEnterEvent(::QDragEnterEvent * arg__1)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dragEnterEvent(arg__1);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::dragLeaveEvent(::QDragLeaveEvent * e)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dragLeaveEvent(e);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("LocationBar", funcName, gil, pyOverride, e);
}

void LocationBarWrapper::dragMoveEvent(::QDragMoveEvent * e)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::dragMoveEvent(e);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("LocationBar", funcName, gil, pyOverride, e);
}

void LocationBarWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("LocationBar", funcName, gil, pyOverride, event);
}

bool LocationBarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::event(event);
    }
    return WebViewWrapper::sbk_o_event("LocationBar", funcName, gil, pyOverride, event);
}

bool LocationBarWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("LocationBar", funcName, gil, pyOverride, watched, event);
}

bool LocationBarWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("LocationBar", funcName, gil, pyOverride, next);
}

bool LocationBarWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("LocationBar", funcName, gil, pyOverride);
}

int LocationBarWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("LocationBar", funcName, gil, pyOverride, painter);
}

void LocationBarWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::initStyleOption(option);
    }
    SqueezeLabelV2Wrapper::sbk_o_initStyleOption("LocationBar", funcName, gil, pyOverride, option);
}

void LocationBarWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::inputMethodEvent(arg__1);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("LocationBar", funcName, gil, pyOverride, arg__1);
}

::QVariant LocationBarWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::keyReleaseEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::keyReleaseEvent(arg__1);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("LocationBar", funcName, gil, pyOverride, event);
}

int LocationBarWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("LocationBar", funcName, gil, pyOverride, arg__1);
}

::QSize LocationBarWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("LocationBar", funcName, gil, pyOverride);
}

void LocationBarWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::mouseMoveEvent(arg__1);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("LocationBar", funcName, gil, pyOverride, event);
}

bool LocationBarWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("LocationBar", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * LocationBarWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("LocationBar", funcName, gil, pyOverride);
}

::QPaintDevice * LocationBarWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("LocationBar", funcName, gil, pyOverride, offset);
}

void LocationBarWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("LocationBar", funcName, gil, pyOverride, visible);
}

::QPainter * LocationBarWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("LocationBar", funcName, gil, pyOverride);
}

::QSize LocationBarWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::LineEdit::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("LocationBar", funcName, gil, pyOverride);
}

void LocationBarWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("LocationBar", funcName, gil, pyOverride, event);
}

void LocationBarWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLineEdit::timerEvent(arg__1);
    }
    WebViewWrapper::sbk_o_timerEvent("LocationBar", funcName, gil, pyOverride, arg__1);
}

void LocationBarWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_LocationBar_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("LocationBar", funcName, gil, pyOverride, event);
}

const QMetaObject *LocationBarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return LocationBar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int LocationBarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = LocationBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *LocationBarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< LocationBarWrapper *>(this));
    }
    return LocationBar::qt_metacast(_clname);
}

LocationBarWrapper::~LocationBarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_LocationBar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_LocationBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::LocationBar >()))
        return -1;

    LocationBarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:LocationBar", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: LocationBar::LocationBar(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // LocationBar(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // LocationBar(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // LocationBar(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) LocationBarWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new LocationBarWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< LocationBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_LocationBarFunc_browserWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // browserWindow()const
        BrowserWindow * cppResult = const_cast<const LocationBarWrapper *>(cppSelf)->browserWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LocationBarFunc_contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::contextMenuEvent(QContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QContextMenuEvent_IDX]), (pyArg)))) {
        overloadId = 0; // contextMenuEvent(QContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contextMenuEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("contextMenuEvent(QContextMenuEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_convertUrlToText(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static LocationBar::convertUrlToText(QUrl)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // convertUrlToText(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "convertUrlToText", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // convertUrlToText(QUrl)
            QString cppResult = ::LocationBar::convertUrlToText(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LocationBarFunc_dropEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dropEvent(QDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDropEvent_IDX]), (pyArg)))) {
        overloadId = 0; // dropEvent(QDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dropEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("dropEvent(QDropEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusInEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("focusInEvent(QFocusEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusOutEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("focusOutEvent(QFocusEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyPressEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_loadAction(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static LocationBar::loadAction(QString)->LocationBar::LoadAction
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // loadAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadAction", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadAction(QString)
            LocationBar::LoadAction cppResult = ::LocationBar::loadAction(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LocationBarFunc_loadRequest(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LocationBar::loadRequest(LoadRequest)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyArg)))) {
        overloadId = 0; // loadRequest(LoadRequest)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadRequest", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::LoadRequest cppArg0_local;
        ::LoadRequest *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // loadRequest(LoadRequest)
            cppSelf->loadRequest(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("paintEvent(QPaintEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_searchEngine(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // searchEngine()
        SearchEnginesManager::Engine cppResult = ::LocationBar::searchEngine();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LocationBarFunc_setBrowserWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LocationBar::setBrowserWindow(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArg)))) {
        overloadId = 0; // setBrowserWindow(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBrowserWindow", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBrowserWindow(BrowserWindow*)
            cppSelf->setBrowserWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LocationBar::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_setWebView(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LocationBar::setWebView(TabbedWebView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), (pyArg)))) {
        overloadId = 0; // setWebView(TabbedWebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWebView", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::TabbedWebView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWebView(TabbedWebView*)
            cppSelf->setWebView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QShowEvent_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showEvent", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("showEvent(QShowEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_showUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LocationBar::showUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // showUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showUrl", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // showUrl(QUrl)
            cppSelf->showUrl(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LocationBarFunc_webView(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<LocationBarWrapper *>(reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webView()const
        TabbedWebView * cppResult = const_cast<const LocationBarWrapper *>(cppSelf)->webView();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_LocationBar_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_LocationBar_EnumFlagInfo[] = {
    "ProgressStyle:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_LocationBar_methods[] = {
    {"browserWindow", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_browserWindow), METH_NOARGS, nullptr},
    {"contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_contextMenuEvent), METH_O, nullptr},
    {"convertUrlToText", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_convertUrlToText), METH_O|METH_STATIC, nullptr},
    {"dropEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_dropEvent), METH_O, nullptr},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_focusInEvent), METH_O, nullptr},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_focusOutEvent), METH_O, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_keyPressEvent), METH_O, nullptr},
    {"loadAction", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_loadAction), METH_O|METH_STATIC, nullptr},
    {"loadRequest", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_loadRequest), METH_O, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_paintEvent), METH_O, nullptr},
    {"searchEngine", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_searchEngine), METH_NOARGS|METH_STATIC, nullptr},
    {"setBrowserWindow", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_setBrowserWindow), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_setText), METH_O, nullptr},
    {"setWebView", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_setWebView), METH_O, nullptr},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_showEvent), METH_O, nullptr},
    {"showUrl", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_showUrl), METH_O, nullptr},
    {"webView", reinterpret_cast<PyCFunction>(Sbk_LocationBarFunc_webView), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_LocationBar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::LocationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<LocationBarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_LocationBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_LocationBar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_LocationBarSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::LocationBar *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]))
        return static_cast< ::LineEdit *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_IDX]))
        return static_cast< ::QLineEdit *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_LocationBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_LocationBar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_LocationBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_LocationBar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_LocationBar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_LocationBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_LocationBar_spec = {
    "1:PyFalkon.LocationBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_LocationBar_slots
};

} //extern "C"

static void *Sbk_LocationBar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::LocationBar *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::LocationBar *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::LocationBar *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void LocationBar_PythonToCpp_LocationBar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_LocationBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_LocationBar_PythonToCpp_LocationBar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_LocationBar_TypeF()))
        return LocationBar_PythonToCpp_LocationBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *LocationBar_PTR_CppToPython_LocationBar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::LocationBar *>(const_cast<void *>(cppIn)), Sbk_LocationBar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *LocationBar_SignatureStrings[] = {
    "PyFalkon.LocationBar(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.LocationBar.browserWindow(self)->PyFalkon.BrowserWindow",
    "PyFalkon.LocationBar.contextMenuEvent(self,event:PySide6.QtGui.QContextMenuEvent)",
    "PyFalkon.LocationBar.convertUrlToText(url:typing.Union[PySide6.QtCore.QUrl, QString])->QString",
    "PyFalkon.LocationBar.dropEvent(self,event:PySide6.QtGui.QDropEvent)",
    "PyFalkon.LocationBar.focusInEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "PyFalkon.LocationBar.focusOutEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "PyFalkon.LocationBar.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.LocationBar.loadAction(text:QString)->PyFalkon.LocationBar.LoadAction",
    "PyFalkon.LocationBar.loadRequest(self,request:typing.Union[PyFalkon.LoadRequest, PySide6.QtCore.QUrl])",
    "PyFalkon.LocationBar.paintEvent(self,event:PySide6.QtGui.QPaintEvent)",
    "PyFalkon.LocationBar.searchEngine()->PyFalkon.SearchEnginesManager.Engine",
    "PyFalkon.LocationBar.setBrowserWindow(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.LocationBar.setText(self,text:Optional[str])",
    "PyFalkon.LocationBar.setWebView(self,view:PyFalkon.TabbedWebView)",
    "PyFalkon.LocationBar.showEvent(self,event:PySide6.QtGui.QShowEvent)",
    "PyFalkon.LocationBar.showUrl(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "PyFalkon.LocationBar.webView(self)->PyFalkon.TabbedWebView",
    nullptr}; // Sentinel
#else
static constexpr size_t LocationBar_SignatureByteSize = 377;
static constexpr uint8_t LocationBar_SignatureBytes[377] = {
    0x78, 0xda, 0xa5, 0x93, 0x4f, 0x6f, 0x82, 0x30, 0x18, 0x87, 0xef, 0x7e, 0x0a, 0x8f, 0x9a, 0xb0,
    0x1e, 0x77, 0x20, 0xd9, 0x92, 0xe9, 0x74, 0x59, 0xa6, 0x11, 0x86, 0xce, 0x83, 0xf1, 0x50, 0xe0,
    0x15, 0x1b, 0x9b, 0x96, 0xb5, 0x05, 0xc6, 0xb7, 0x5f, 0xf9, 0x33, 0x44, 0x47, 0x25, 0xcb, 0x6e,
    0x6f, 0xd3, 0xa7, 0x0f, 0xbf, 0xf6, 0xe5, 0x75, 0xf2, 0x39, 0xa6, 0x27, 0xce, 0xd0, 0x82, 0x07,
    0x58, 0x11, 0xce, 0x26, 0x58, 0x8c, 0x24, 0xd0, 0x83, 0x15, 0x63, 0x01, 0x4c, 0xd9, 0x4e, 0xee,
    0x91, 0x10, 0xee, 0x91, 0xab, 0xb6, 0x24, 0x8c, 0x40, 0x49, 0xe4, 0x56, 0xc5, 0x03, 0x4b, 0x28,
    0x8d, 0x95, 0x18, 0x0f, 0x9c, 0x0e, 0x07, 0xf2, 0x05, 0xcf, 0x24, 0x88, 0x2d, 0x61, 0x21, 0xcf,
    0x4a, 0xe3, 0xf8, 0xee, 0xb1, 0x21, 0x27, 0xed, 0xdd, 0x6e, 0x41, 0xc0, 0x99, 0x82, 0x2f, 0xb5,
    0x04, 0x96, 0xcc, 0x52, 0x9d, 0xa4, 0x4a, 0x05, 0xe9, 0x65, 0xa8, 0x97, 0x84, 0x20, 0x77, 0x7a,
    0x85, 0x8e, 0x8d, 0xc6, 0x14, 0x84, 0xda, 0x08, 0xba, 0xe6, 0x6b, 0xcd, 0x8f, 0x12, 0x41, 0x6d,
    0x95, 0xc7, 0x84, 0x45, 0x68, 0xc3, 0x34, 0xb4, 0x3b, 0x7b, 0xa7, 0x5c, 0x00, 0x72, 0x35, 0x6a,
    0x0d, 0x5d, 0x4f, 0x09, 0x8d, 0xec, 0x75, 0xfe, 0xba, 0xec, 0xd6, 0x87, 0x82, 0xc7, 0x7d, 0x49,
    0x9f, 0x7f, 0x18, 0x43, 0xc4, 0x03, 0x0f, 0x12, 0xf9, 0xca, 0xfa, 0x34, 0xf3, 0x02, 0xeb, 0xf5,
    0xac, 0x12, 0xf5, 0x6f, 0xd1, 0x09, 0x72, 0x47, 0x80, 0x94, 0x7d, 0xa2, 0x37, 0xc8, 0x6f, 0x69,
    0x28, 0xc7, 0xe1, 0x53, 0x50, 0xac, 0x46, 0x45, 0xa7, 0xec, 0xfa, 0x21, 0xdb, 0xbf, 0x44, 0x1b,
    0x5f, 0x34, 0xb8, 0x59, 0xf7, 0x0e, 0x9f, 0x09, 0xc8, 0x3a, 0x93, 0xa8, 0x16, 0xd7, 0xdd, 0x6c,
    0x8e, 0x36, 0xb8, 0x35, 0xec, 0xe8, 0xf1, 0xde, 0x90, 0x3a, 0xc6, 0x84, 0xf5, 0x3e, 0xa1, 0xd3,
    0x40, 0x06, 0x8b, 0x04, 0x2c, 0x82, 0xe3, 0x8c, 0x45, 0x84, 0xc1, 0xa8, 0x7d, 0x63, 0xaf, 0xb5,
    0x21, 0x97, 0x98, 0xe1, 0x08, 0x04, 0xaa, 0x96, 0x26, 0x93, 0x9a, 0xfc, 0x1a, 0x2b, 0x2b, 0x2b,
    0x6b, 0xbb, 0x7b, 0xb6, 0x8c, 0x99, 0x54, 0x39, 0x01, 0xa5, 0xa0, 0xec, 0xc8, 0x2a, 0x2e, 0xf6,
    0x30, 0xdd, 0x49, 0x25, 0xf6, 0xe6, 0x53, 0x5b, 0xf0, 0x3f, 0x08, 0xd4, 0x5f, 0x4e, 0x75, 0x75,
    0xfe, 0xee, 0x1a, 0xfb, 0x3e, 0x84, 0x35, 0x60, 0x32, 0x1c, 0x79, 0xd6, 0xf7, 0xa0, 0xde, 0x0f,
    0x73, 0xc3, 0xa1, 0x9b, 0x56, 0x19, 0xfe, 0x38, 0xc2, 0xdd, 0xc6, 0xac, 0x75, 0xa9, 0x76, 0x83,
    0x2e, 0x6e, 0x34, 0xf8, 0x06, 0x69, 0x4b, 0xe7, 0x47
};
#endif

PyTypeObject *init_LocationBar(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_LocationBar_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_LocationBar_IDX].type;

    Shiboken::AutoDecRef Sbk_LocationBar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LineEdit_IDX]))));

    _Sbk_LocationBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "LocationBar",
        "LocationBar*",
        &Sbk_LocationBar_spec,
        &Shiboken::callCppDestructor< LocationBar >,
        Sbk_LocationBar_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_LocationBar_Type; // references _Sbk_LocationBar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, LocationBar_SignatureStrings);
#else
    InitSignatureBytes(pyType, LocationBar_SignatureBytes, LocationBar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_LocationBar_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_LocationBar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        LocationBar_PythonToCpp_LocationBar_PTR,
        is_LocationBar_PythonToCpp_LocationBar_PTR_Convertible,
        LocationBar_PTR_CppToPython_LocationBar);

    Shiboken::Conversions::registerConverterName(converter, "LocationBar");
    Shiboken::Conversions::registerConverterName(converter, "LocationBar*");
    Shiboken::Conversions::registerConverterName(converter, "LocationBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::LocationBar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(LocationBarWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_LocationBar_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_LocationBar_TypeF(), &Sbk_LocationBarSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_LocationBar_TypeF(), &Sbk_LocationBar_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_LocationBar_EnumFlagInfo);

    LocationBarWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::LocationBar::staticMetaObject, sizeof(LocationBarWrapper));

    return pyType;
}
