/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	resourcev1beta1 "k8s.io/api/resource/v1beta1"
)

// DeviceTolerationApplyConfiguration represents a declarative configuration of the DeviceToleration type for use
// with apply.
//
// The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches
// the triple <key,value,effect> using the matching operator <operator>.
type DeviceTolerationApplyConfiguration struct {
	// Key is the taint key that the toleration applies to. Empty means match all taint keys.
	// If the key is empty, operator must be Exists; this combination means to match all values and all keys.
	// Must be a label name.
	Key *string `json:"key,omitempty"`
	// Operator represents a key's relationship to the value.
	// Valid operators are Exists and Equal. Defaults to Equal.
	// Exists is equivalent to wildcard for value, so that a ResourceClaim can
	// tolerate all taints of a particular category.
	Operator *resourcev1beta1.DeviceTolerationOperator `json:"operator,omitempty"`
	// Value is the taint value the toleration matches to.
	// If the operator is Exists, the value must be empty, otherwise just a regular string.
	// Must be a label value.
	Value *string `json:"value,omitempty"`
	// Effect indicates the taint effect to match. Empty means match all taint effects.
	// When specified, allowed values are NoSchedule and NoExecute.
	Effect *resourcev1beta1.DeviceTaintEffect `json:"effect,omitempty"`
	// TolerationSeconds represents the period of time the toleration (which must be
	// of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
	// it is not set, which means tolerate the taint forever (do not evict). Zero and
	// negative values will be treated as 0 (evict immediately) by the system.
	// If larger than zero, the time when the pod needs to be evicted is calculated as <time when
	// taint was adedd> + <toleration seconds>.
	TolerationSeconds *int64 `json:"tolerationSeconds,omitempty"`
}

// DeviceTolerationApplyConfiguration constructs a declarative configuration of the DeviceToleration type for use with
// apply.
func DeviceToleration() *DeviceTolerationApplyConfiguration {
	return &DeviceTolerationApplyConfiguration{}
}

// WithKey sets the Key field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Key field is set to the value of the last call.
func (b *DeviceTolerationApplyConfiguration) WithKey(value string) *DeviceTolerationApplyConfiguration {
	b.Key = &value
	return b
}

// WithOperator sets the Operator field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Operator field is set to the value of the last call.
func (b *DeviceTolerationApplyConfiguration) WithOperator(value resourcev1beta1.DeviceTolerationOperator) *DeviceTolerationApplyConfiguration {
	b.Operator = &value
	return b
}

// WithValue sets the Value field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Value field is set to the value of the last call.
func (b *DeviceTolerationApplyConfiguration) WithValue(value string) *DeviceTolerationApplyConfiguration {
	b.Value = &value
	return b
}

// WithEffect sets the Effect field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Effect field is set to the value of the last call.
func (b *DeviceTolerationApplyConfiguration) WithEffect(value resourcev1beta1.DeviceTaintEffect) *DeviceTolerationApplyConfiguration {
	b.Effect = &value
	return b
}

// WithTolerationSeconds sets the TolerationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TolerationSeconds field is set to the value of the last call.
func (b *DeviceTolerationApplyConfiguration) WithTolerationSeconds(value int64) *DeviceTolerationApplyConfiguration {
	b.TolerationSeconds = &value
	return b
}
