/* Generated by wayland-scanner 1.24.0 */

#ifndef EXT_BACKGROUND_EFFECT_V1_CLIENT_PROTOCOL_H
#define EXT_BACKGROUND_EFFECT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ext_background_effect_v1 The ext_background_effect_v1 protocol
 * @section page_ifaces_ext_background_effect_v1 Interfaces
 * - @subpage page_iface_ext_background_effect_manager_v1 - background effect factory
 * - @subpage page_iface_ext_background_effect_surface_v1 - background effects for a surface
 * @section page_copyright_ext_background_effect_v1 Copyright
 * <pre>
 *
 * Copyright (C) 2015 Martin Gräßlin
 * Copyright (C) 2015 Marco Martin
 * Copyright (C) 2020 Vlad Zahorodnii
 * Copyright (C) 2024 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ext_background_effect_manager_v1;
struct ext_background_effect_surface_v1;
struct wl_region;
struct wl_surface;

#ifndef EXT_BACKGROUND_EFFECT_MANAGER_V1_INTERFACE
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_background_effect_manager_v1 ext_background_effect_manager_v1
 * @section page_iface_ext_background_effect_manager_v1_desc Description
 *
 * This protocol provides a way to improve visuals of translucent surfaces
 * by applying effects like blur to the background behind them.
 *
 * The capabilities are send when the global is bound, and every time they
 * change. Note that when the capability goes away, the corresponding effect
 * is no longer applied by the compositor, even if it was set before.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_ext_background_effect_manager_v1_api API
 * See @ref iface_ext_background_effect_manager_v1.
 */
/**
 * @defgroup iface_ext_background_effect_manager_v1 The ext_background_effect_manager_v1 interface
 *
 * This protocol provides a way to improve visuals of translucent surfaces
 * by applying effects like blur to the background behind them.
 *
 * The capabilities are send when the global is bound, and every time they
 * change. Note that when the capability goes away, the corresponding effect
 * is no longer applied by the compositor, even if it was set before.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface ext_background_effect_manager_v1_interface;
#endif
#ifndef EXT_BACKGROUND_EFFECT_SURFACE_V1_INTERFACE
#define EXT_BACKGROUND_EFFECT_SURFACE_V1_INTERFACE
/**
 * @page page_iface_ext_background_effect_surface_v1 ext_background_effect_surface_v1
 * @section page_iface_ext_background_effect_surface_v1_desc Description
 *
 * The background effect object provides a way to specify a region behind
 * a surface that should have background effects like blur applied.
 *
 * If the wl_surface associated with the ext_background_effect_surface_v1
 * object has been destroyed, this object becomes inert.
 * @section page_iface_ext_background_effect_surface_v1_api API
 * See @ref iface_ext_background_effect_surface_v1.
 */
/**
 * @defgroup iface_ext_background_effect_surface_v1 The ext_background_effect_surface_v1 interface
 *
 * The background effect object provides a way to specify a region behind
 * a surface that should have background effects like blur applied.
 *
 * If the wl_surface associated with the ext_background_effect_surface_v1
 * object has been destroyed, this object becomes inert.
 */
extern const struct wl_interface ext_background_effect_surface_v1_interface;
#endif

#ifndef EXT_BACKGROUND_EFFECT_MANAGER_V1_ERROR_ENUM
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_ERROR_ENUM
enum ext_background_effect_manager_v1_error {
	/**
	 * the surface already has a background effect object
	 */
	EXT_BACKGROUND_EFFECT_MANAGER_V1_ERROR_BACKGROUND_EFFECT_EXISTS = 0,
};
#endif /* EXT_BACKGROUND_EFFECT_MANAGER_V1_ERROR_ENUM */

#ifndef EXT_BACKGROUND_EFFECT_MANAGER_V1_CAPABILITY_ENUM
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_CAPABILITY_ENUM
enum ext_background_effect_manager_v1_capability {
	/**
	 * the compositor supports applying blur
	 */
	EXT_BACKGROUND_EFFECT_MANAGER_V1_CAPABILITY_BLUR = 1,
};
#endif /* EXT_BACKGROUND_EFFECT_MANAGER_V1_CAPABILITY_ENUM */

/**
 * @ingroup iface_ext_background_effect_manager_v1
 * @struct ext_background_effect_manager_v1_listener
 */
struct ext_background_effect_manager_v1_listener {
	/**
	 * capabilities of the compositor
	 *
	 * 
	 */
	void (*capabilities)(void *data,
			     struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1,
			     uint32_t flags);
};

/**
 * @ingroup iface_ext_background_effect_manager_v1
 */
static inline int
ext_background_effect_manager_v1_add_listener(struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1,
					      const struct ext_background_effect_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_background_effect_manager_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_BACKGROUND_EFFECT_MANAGER_V1_DESTROY 0
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_GET_BACKGROUND_EFFECT 1

/**
 * @ingroup iface_ext_background_effect_manager_v1
 */
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_CAPABILITIES_SINCE_VERSION 1

/**
 * @ingroup iface_ext_background_effect_manager_v1
 */
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_background_effect_manager_v1
 */
#define EXT_BACKGROUND_EFFECT_MANAGER_V1_GET_BACKGROUND_EFFECT_SINCE_VERSION 1

/** @ingroup iface_ext_background_effect_manager_v1 */
static inline void
ext_background_effect_manager_v1_set_user_data(struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_background_effect_manager_v1, user_data);
}

/** @ingroup iface_ext_background_effect_manager_v1 */
static inline void *
ext_background_effect_manager_v1_get_user_data(struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_background_effect_manager_v1);
}

static inline uint32_t
ext_background_effect_manager_v1_get_version(struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_background_effect_manager_v1);
}

/**
 * @ingroup iface_ext_background_effect_manager_v1
 *
 * Informs the server that the client will no longer be using this
 * protocol object. Existing objects created by this object are not
 * affected.
 */
static inline void
ext_background_effect_manager_v1_destroy(struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_background_effect_manager_v1,
			 EXT_BACKGROUND_EFFECT_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_background_effect_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ext_background_effect_manager_v1
 *
 * Instantiate an interface extension for the given wl_surface to add
 * effects like blur for the background behind it.
 *
 * If the given wl_surface already has a ext_background_effect_surface_v1
 * object associated, the background_effect_exists protocol error will be
 * raised.
 */
static inline struct ext_background_effect_surface_v1 *
ext_background_effect_manager_v1_get_background_effect(struct ext_background_effect_manager_v1 *ext_background_effect_manager_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ext_background_effect_manager_v1,
			 EXT_BACKGROUND_EFFECT_MANAGER_V1_GET_BACKGROUND_EFFECT, &ext_background_effect_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_background_effect_manager_v1), 0, NULL, surface);

	return (struct ext_background_effect_surface_v1 *) id;
}

#ifndef EXT_BACKGROUND_EFFECT_SURFACE_V1_ERROR_ENUM
#define EXT_BACKGROUND_EFFECT_SURFACE_V1_ERROR_ENUM
enum ext_background_effect_surface_v1_error {
	/**
	 * the associated surface has been destroyed
	 */
	EXT_BACKGROUND_EFFECT_SURFACE_V1_ERROR_SURFACE_DESTROYED = 0,
};
#endif /* EXT_BACKGROUND_EFFECT_SURFACE_V1_ERROR_ENUM */

#define EXT_BACKGROUND_EFFECT_SURFACE_V1_DESTROY 0
#define EXT_BACKGROUND_EFFECT_SURFACE_V1_SET_BLUR_REGION 1


/**
 * @ingroup iface_ext_background_effect_surface_v1
 */
#define EXT_BACKGROUND_EFFECT_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_background_effect_surface_v1
 */
#define EXT_BACKGROUND_EFFECT_SURFACE_V1_SET_BLUR_REGION_SINCE_VERSION 1

/** @ingroup iface_ext_background_effect_surface_v1 */
static inline void
ext_background_effect_surface_v1_set_user_data(struct ext_background_effect_surface_v1 *ext_background_effect_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_background_effect_surface_v1, user_data);
}

/** @ingroup iface_ext_background_effect_surface_v1 */
static inline void *
ext_background_effect_surface_v1_get_user_data(struct ext_background_effect_surface_v1 *ext_background_effect_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_background_effect_surface_v1);
}

static inline uint32_t
ext_background_effect_surface_v1_get_version(struct ext_background_effect_surface_v1 *ext_background_effect_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_background_effect_surface_v1);
}

/**
 * @ingroup iface_ext_background_effect_surface_v1
 *
 * Informs the server that the client will no longer be using this protocol
 * object. The effect regions will be removed on the next commit.
 */
static inline void
ext_background_effect_surface_v1_destroy(struct ext_background_effect_surface_v1 *ext_background_effect_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_background_effect_surface_v1,
			 EXT_BACKGROUND_EFFECT_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_background_effect_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ext_background_effect_surface_v1
 *
 * This request sets the region of the surface that will have its
 * background blurred.
 *
 * The blur region is specified in the surface-local coordinates, and
 * clipped by the compositor to the surface size.
 *
 * The initial value for the blur region is empty. Setting the pending
 * blur region has copy semantics, and the wl_region object can be
 * destroyed immediately. A NULL wl_region removes the effect.
 *
 * The blur region is double-buffered state, and will be applied on
 * the next wl_surface.commit.
 *
 * The blur algorithm is subject to compositor policies.
 *
 * If the associated surface has been destroyed, the surface_destroyed
 * error will be raised.
 */
static inline void
ext_background_effect_surface_v1_set_blur_region(struct ext_background_effect_surface_v1 *ext_background_effect_surface_v1, struct wl_region *region)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_background_effect_surface_v1,
			 EXT_BACKGROUND_EFFECT_SURFACE_V1_SET_BLUR_REGION, NULL, wl_proxy_get_version((struct wl_proxy *) ext_background_effect_surface_v1), 0, region);
}

#ifdef  __cplusplus
}
#endif

#endif
