/* gitg-add-remote-action.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-add-remote-action.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2022 - Adwait Rawat
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgit2-glib/ggit.h>
#include <gtk/gtk.h>

#define GITG_ADD_REMOTE_ACTION_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_ADD_REMOTE_ACTION (gitg_add_remote_action_get_type ())
#define GITG_ADD_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_ADD_REMOTE_ACTION, GitgAddRemoteAction))
#define GITG_ADD_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_ADD_REMOTE_ACTION, GitgAddRemoteActionClass))
#define GITG_IS_ADD_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_ADD_REMOTE_ACTION))
#define GITG_IS_ADD_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_ADD_REMOTE_ACTION))
#define GITG_ADD_REMOTE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_ADD_REMOTE_ACTION, GitgAddRemoteActionClass))

typedef struct _GitgAddRemoteAction GitgAddRemoteAction;
typedef struct _GitgAddRemoteActionClass GitgAddRemoteActionClass;
typedef struct _GitgAddRemoteActionPrivate GitgAddRemoteActionPrivate;
enum  {
	GITG_ADD_REMOTE_ACTION_0_PROPERTY,
	GITG_ADD_REMOTE_ACTION_APPLICATION_PROPERTY,
	GITG_ADD_REMOTE_ACTION_ID_PROPERTY,
	GITG_ADD_REMOTE_ACTION_DISPLAY_NAME_PROPERTY,
	GITG_ADD_REMOTE_ACTION_DESCRIPTION_PROPERTY,
	GITG_ADD_REMOTE_ACTION_NUM_PROPERTIES
};
static GParamSpec* gitg_add_remote_action_properties[GITG_ADD_REMOTE_ACTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block72Data Block72Data;

#define GITG_TYPE_REMOTE_NOTIFICATION (gitg_remote_notification_get_type ())
#define GITG_REMOTE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotification))
#define GITG_REMOTE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotificationClass))
#define GITG_IS_REMOTE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE_NOTIFICATION))
#define GITG_IS_REMOTE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE_NOTIFICATION))
#define GITG_REMOTE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotificationClass))

typedef struct _GitgRemoteNotification GitgRemoteNotification;
typedef struct _GitgRemoteNotificationClass GitgRemoteNotificationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgAddRemoteActionFetchData GitgAddRemoteActionFetchData;

#define GITG_TYPE_ADD_REMOTE_ACTION_DIALOG (gitg_add_remote_action_dialog_get_type ())
#define GITG_ADD_REMOTE_ACTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_ADD_REMOTE_ACTION_DIALOG, GitgAddRemoteActionDialog))
#define GITG_ADD_REMOTE_ACTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_ADD_REMOTE_ACTION_DIALOG, GitgAddRemoteActionDialogClass))
#define GITG_IS_ADD_REMOTE_ACTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_ADD_REMOTE_ACTION_DIALOG))
#define GITG_IS_ADD_REMOTE_ACTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_ADD_REMOTE_ACTION_DIALOG))
#define GITG_ADD_REMOTE_ACTION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_ADD_REMOTE_ACTION_DIALOG, GitgAddRemoteActionDialogClass))

typedef struct _GitgAddRemoteActionDialog GitgAddRemoteActionDialog;
typedef struct _GitgAddRemoteActionDialogClass GitgAddRemoteActionDialogClass;
typedef struct _Block73Data Block73Data;

struct _GitgAddRemoteAction {
	GObject parent_instance;
	GitgAddRemoteActionPrivate * priv;
};

struct _GitgAddRemoteActionClass {
	GObjectClass parent_class;
};

struct _GitgAddRemoteActionPrivate {
	GitgExtApplication* _application;
	GitgRemote* d_remote;
	GitgRepository* repo;
	gchar* remote_name;
	gchar* remote_url;
};

struct _Block72Data {
	int _ref_count_;
	GitgAddRemoteAction* self;
	GeeArrayList* updates;
	gpointer _async_data_;
};

struct _GitgAddRemoteActionFetchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgAddRemoteAction* self;
	gboolean result;
	Block72Data* _data72_;
	GitgRemoteNotification* notification;
	GitgRemote* _tmp0_;
	GitgRemoteNotification* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtApplication* _tmp3_;
	GitgExtApplication* _tmp4_;
	GitgExtNotifications* _tmp5_;
	GitgExtNotifications* _tmp6_;
	GitgExtNotifications* _tmp7_;
	GitgRemote* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GeeArrayList* _tmp12_;
	gulong tip_updated_id;
	GitgRemote* _tmp13_;
	gulong _tmp14_;
	GitgRemote* _tmp15_;
	GError* e;
	GitgRemote* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GitgExtApplication* _tmp22_;
	GitgExtApplication* _tmp23_;
	GitgExtApplication* _tmp24_;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError* _inner_error1_;
	GitgRemote* _tmp27_;
	GitgExtApplication* _tmp28_;
	GitgExtApplication* _tmp29_;
	GtkApplicationWindow* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GitgRemote* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gpointer* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	GError* _inner_error0_;
};

struct _Block73Data {
	int _ref_count_;
	GitgAddRemoteAction* self;
	GitgAddRemoteActionDialog* dlg;
};

static gint GitgAddRemoteAction_private_offset;
static gpointer gitg_add_remote_action_parent_class = NULL;
static GitgExtUIElementIface * gitg_add_remote_action_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_add_remote_action_gitg_ext_action_parent_iface = NULL;

VALA_EXTERN GType gitg_add_remote_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgAddRemoteAction, g_object_unref)
VALA_EXTERN GitgAddRemoteAction* gitg_add_remote_action_new (GitgExtApplication* application);
VALA_EXTERN GitgAddRemoteAction* gitg_add_remote_action_construct (GType object_type,
                                                       GitgExtApplication* application);
static void gitg_add_remote_action_real_fetch_data_free (gpointer _data);
static void gitg_add_remote_action_real_fetch (GitgExtAction* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean gitg_add_remote_action_real_fetch_co (GitgAddRemoteActionFetchData* _data_);
static Block72Data* block72_data_ref (Block72Data* _data72_);
static void block72_data_unref (void * _userdata_);
VALA_EXTERN GType gitg_remote_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoteNotification, g_object_unref)
VALA_EXTERN GitgRemoteNotification* gitg_remote_notification_new (GitgRemote* remote);
VALA_EXTERN GitgRemoteNotification* gitg_remote_notification_construct (GType object_type,
                                                            GitgRemote* remote);
VALA_EXTERN void gitg_remote_notification_set_text (GitgRemoteNotification* self,
                                        const gchar* value);
static void __lambda130_ (Block72Data* _data72_,
                   GitgRemote* d_remote,
                   const gchar* name,
                   GgitOId* a,
                   GgitOId* b);
static void ___lambda130__gitg_remote_tip_updated (GitgRemote* _sender,
                                            const gchar* refname,
                                            GgitOId* a,
                                            GgitOId* b,
                                            gpointer self);
static void gitg_add_remote_action_fetch_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void gitg_remote_notification_error (GitgRemoteNotification* self,
                                     const gchar* text);
VALA_EXTERN void gitg_remote_notification_success (GitgRemoteNotification* self,
                                       const gchar* text);
VALA_EXTERN void gitg_add_remote_action_add_remote (GitgAddRemoteAction* self,
                                        gchar* name,
                                        gchar* url);
VALA_EXTERN GType gitg_add_remote_action_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgAddRemoteActionDialog, g_object_unref)
static Block73Data* block73_data_ref (Block73Data* _data73_);
static void block73_data_unref (void * _userdata_);
VALA_EXTERN GitgAddRemoteActionDialog* gitg_add_remote_action_dialog_new (GtkWindow* parent);
VALA_EXTERN GitgAddRemoteActionDialog* gitg_add_remote_action_dialog_construct (GType object_type,
                                                                    GtkWindow* parent);
VALA_EXTERN void gitg_add_remote_action_dialog_set_remote_name (GitgAddRemoteActionDialog* self,
                                                    const gchar* value);
VALA_EXTERN void gitg_add_remote_action_dialog_set_remote_url (GitgAddRemoteActionDialog* self,
                                                   const gchar* value);
static void __lambda133_ (Block73Data* _data73_,
                   GtkDialog* d,
                   gint resp);
VALA_EXTERN gchar* gitg_add_remote_action_dialog_get_remote_name (GitgAddRemoteActionDialog* self);
VALA_EXTERN gchar* gitg_add_remote_action_dialog_get_remote_url (GitgAddRemoteActionDialog* self);
static void ____lambda134_ (GitgAddRemoteAction* self,
                     GObject* obj,
                     GAsyncResult* res);
static void _____lambda134__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static void ___lambda133__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void gitg_add_remote_action_real_activate (GitgExtUIElement* base);
static void gitg_add_remote_action_finalize (GObject * obj);
static GType gitg_add_remote_action_get_type_once (void);
static void _vala_gitg_add_remote_action_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gitg_add_remote_action_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_add_remote_action_get_instance_private (GitgAddRemoteAction* self)
{
	return G_STRUCT_MEMBER_P (self, GitgAddRemoteAction_private_offset);
}

GitgAddRemoteAction*
gitg_add_remote_action_construct (GType object_type,
                                  GitgExtApplication* application)
{
	GitgAddRemoteAction * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (GitgAddRemoteAction*) g_object_new (object_type, "application", application, NULL);
	return self;
}

GitgAddRemoteAction*
gitg_add_remote_action_new (GitgExtApplication* application)
{
	return gitg_add_remote_action_construct (GITG_TYPE_ADD_REMOTE_ACTION, application);
}

static void
gitg_add_remote_action_real_fetch_data_free (gpointer _data)
{
	GitgAddRemoteActionFetchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgAddRemoteActionFetchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_add_remote_action_real_fetch (GitgExtAction* base,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GitgAddRemoteAction * self;
	GitgAddRemoteActionFetchData* _data_;
	GitgAddRemoteAction* _tmp0_;
	self = (GitgAddRemoteAction*) base;
	_data_ = g_slice_new0 (GitgAddRemoteActionFetchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_add_remote_action_real_fetch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_add_remote_action_real_fetch_co (_data_);
}

static gboolean
gitg_add_remote_action_fetch_finish (GitgExtAction* base,
                                     GAsyncResult* _res_)
{
	gboolean result;
	GitgAddRemoteActionFetchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block72Data*
block72_data_ref (Block72Data* _data72_)
{
	g_atomic_int_inc (&_data72_->_ref_count_);
	return _data72_;
}

static void
block72_data_unref (void * _userdata_)
{
	Block72Data* _data72_;
	_data72_ = (Block72Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data72_->_ref_count_)) {
		GitgAddRemoteAction* self;
		self = _data72_->self;
		_g_object_unref0 (_data72_->updates);
		_g_object_unref0 (self);
		g_slice_free (Block72Data, _data72_);
	}
}

static void
__lambda130_ (Block72Data* _data72_,
              GitgRemote* d_remote,
              const gchar* name,
              GgitOId* a,
              GgitOId* b)
{
	GitgAddRemoteAction* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data72_->self;
	g_return_if_fail (d_remote != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = g_strdup_printf ("%s (%s)", name, _ ("new"));
	_tmp1_ = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data72_->updates, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
___lambda130__gitg_remote_tip_updated (GitgRemote* _sender,
                                       const gchar* refname,
                                       GgitOId* a,
                                       GgitOId* b,
                                       gpointer self)
{
	__lambda130_ (self, _sender, refname, a, b);
}

static void
gitg_add_remote_action_fetch_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GitgAddRemoteActionFetchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_add_remote_action_real_fetch_co (_data_);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
gitg_add_remote_action_real_fetch_co (GitgAddRemoteActionFetchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data72_ = g_slice_new0 (Block72Data);
	_data_->_data72_->_ref_count_ = 1;
	_data_->_data72_->self = g_object_ref (_data_->self);
	_data_->_data72_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->d_remote;
	_data_->_tmp1_ = gitg_remote_notification_new (_data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_data_->notification = _data_->_tmp1_;
	_data_->_tmp2_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = gitg_ext_application_get_notifications (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_tmp6_;
	gitg_ext_notifications_add (_data_->_tmp7_, (GitgExtNotification*) _data_->notification);
	_g_object_unref0 (_data_->_tmp7_);
	_g_object_unref0 (_data_->_tmp4_);
	_data_->_tmp8_ = _data_->self->priv->d_remote;
	_data_->_tmp9_ = ggit_remote_get_url ((GgitRemote*) _data_->_tmp8_);
	_data_->_tmp10_ = g_strdup_printf (_ ("Fetching from %s"), _data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	gitg_remote_notification_set_text (_data_->notification, _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data_->_data72_->updates = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->priv->d_remote;
	_data_->_tmp14_ = g_signal_connect_data (_data_->_tmp13_, "tip-updated", (GCallback) ___lambda130__gitg_remote_tip_updated, block72_data_ref (_data_->_data72_), (GClosureNotify) block72_data_unref, 0);
	_data_->tip_updated_id = _data_->_tmp14_;
	{
		_data_->_tmp15_ = _data_->self->priv->d_remote;
		_data_->_state_ = 1;
		gitg_remote_fetch (_data_->_tmp15_, NULL, NULL, gitg_add_remote_action_fetch_ready, _data_);
		return FALSE;
		_state_1:
		gitg_remote_fetch_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		{
			_data_->_tmp16_ = _data_->self->priv->d_remote;
			_data_->_tmp17_ = ggit_remote_get_url ((GgitRemote*) _data_->_tmp16_);
			_data_->_tmp18_ = _data_->e;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			_data_->_tmp20_ = g_strdup_printf (_ ("Failed to fetch from %s: %s"), _data_->_tmp17_, _data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			gitg_remote_notification_error (_data_->notification, _data_->_tmp21_);
			_g_free0 (_data_->_tmp21_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->notification);
			block72_data_unref (_data_->_data72_);
			_data_->_data72_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		gitg_ext_application_show_infobar (_data_->_tmp24_, _ ("Failed to fetch added remote"), _data_->_tmp26_, GTK_MESSAGE_ERROR);
		_g_object_unref0 (_data_->_tmp24_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	{
		_data_->_tmp27_ = _data_->self->priv->d_remote;
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, G_TYPE_OBJECT, GObject), _data_->tip_updated_id);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->notification);
		block72_data_unref (_data_->_data72_);
		_data_->_data72_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp29_, gtk_application_window_get_type (), GtkApplicationWindow);
	g_action_group_activate_action ((GActionGroup*) _data_->_tmp30_, "reload", NULL);
	_g_object_unref0 (_data_->_tmp30_);
	_data_->_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_data72_->updates);
	_data_->_tmp32_ = _data_->_tmp31_;
	if (_data_->_tmp32_ != 0) {
		_data_->_tmp33_ = _data_->self->priv->d_remote;
		_data_->_tmp34_ = ggit_remote_get_url ((GgitRemote*) _data_->_tmp33_);
		_data_->_tmp35_ = 0;
		_data_->_tmp36_ = gee_collection_to_array ((GeeCollection*) _data_->_data72_->updates, &_data_->_tmp35_);
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp37__length1 = _data_->_tmp35_;
		_data_->_tmp38_ = _vala_g_strjoinv (", ", _data_->_tmp37_, (gint) _data_->_tmp35_);
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp40_ = g_strdup_printf (_ ("Fetched from %s: %s"), _data_->_tmp34_, _data_->_tmp39_);
		_data_->_tmp41_ = _data_->_tmp40_;
		gitg_remote_notification_success (_data_->notification, _data_->_tmp41_);
		_g_free0 (_data_->_tmp41_);
		_g_free0 (_data_->_tmp39_);
		_data_->_tmp37_ = (_vala_array_free (_data_->_tmp37_, _data_->_tmp37__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_data_->_tmp42_ = _data_->self->priv->remote_name;
		_data_->_tmp43_ = g_strdup (_data_->_tmp42_);
		_data_->_tmp44_ = _data_->self->priv->remote_url;
		_data_->_tmp45_ = g_strdup (_data_->_tmp44_);
		gitg_add_remote_action_add_remote (_data_->self, _data_->_tmp43_, _data_->_tmp45_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->notification);
		block72_data_unref (_data_->_data72_);
		_data_->_data72_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_g_object_unref0 (_data_->notification);
	block72_data_unref (_data_->_data72_);
	_data_->_data72_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block73Data*
block73_data_ref (Block73Data* _data73_)
{
	g_atomic_int_inc (&_data73_->_ref_count_);
	return _data73_;
}

static void
block73_data_unref (void * _userdata_)
{
	Block73Data* _data73_;
	_data73_ = (Block73Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data73_->_ref_count_)) {
		GitgAddRemoteAction* self;
		self = _data73_->self;
		_g_object_unref0 (_data73_->dlg);
		_g_object_unref0 (self);
		g_slice_free (Block73Data, _data73_);
	}
}

static void
____lambda134_ (GitgAddRemoteAction* self,
                GObject* obj,
                GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	gitg_ext_action_fetch_finish ((GitgExtAction*) self, res);
}

static void
_____lambda134__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	____lambda134_ ((GitgAddRemoteAction*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda133_ (Block73Data* _data73_,
              GtkDialog* d,
              gint resp)
{
	GitgAddRemoteAction* self;
	GError* _inner_error0_ = NULL;
	self = _data73_->self;
	g_return_if_fail (d != NULL);
	if (resp == ((gint) GTK_RESPONSE_OK)) {
		GgitRemote* remote = NULL;
		GitgExtApplication* _tmp0_;
		GitgExtApplication* _tmp1_;
		GitgExtApplication* _tmp2_;
		GitgRepository* _tmp3_;
		GitgRepository* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GitgExtApplication* _tmp24_;
		GitgExtApplication* _tmp25_;
		GitgExtApplication* _tmp26_;
		GitgExtRemoteLookup* _tmp27_;
		GitgExtRemoteLookup* _tmp28_;
		GitgExtRemoteLookup* _tmp29_;
		const gchar* _tmp30_;
		GitgRemote* _tmp31_;
		GgitRemote* _tmp32_;
		remote = NULL;
		_g_object_unref0 (self->priv->d_remote);
		self->priv->d_remote = NULL;
		_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gitg_ext_application_get_repository (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (self->priv->repo);
		self->priv->repo = _tmp4_;
		_g_object_unref0 (_tmp2_);
		_tmp5_ = gitg_add_remote_action_dialog_get_remote_name (_data73_->dlg);
		_tmp6_ = _tmp5_;
		_g_free0 (self->priv->remote_name);
		self->priv->remote_name = _tmp6_;
		_tmp7_ = gitg_add_remote_action_dialog_get_remote_url (_data73_->dlg);
		_tmp8_ = _tmp7_;
		_g_free0 (self->priv->remote_url);
		self->priv->remote_url = _tmp8_;
		{
			GgitRemote* _tmp9_ = NULL;
			GitgRepository* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			GgitRemote* _tmp13_;
			GgitRemote* _tmp14_;
			_tmp10_ = self->priv->repo;
			_tmp11_ = self->priv->remote_name;
			_tmp12_ = self->priv->remote_url;
			_tmp13_ = ggit_repository_create_remote ((GgitRepository*) _tmp10_, _tmp11_, _tmp12_, &_inner_error0_);
			_tmp9_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp14_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (remote);
			remote = _tmp14_;
			_g_object_unref0 (_tmp9_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			GitgExtApplication* _tmp19_;
			GitgExtApplication* _tmp20_;
			GitgExtApplication* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = self->priv->remote_name;
			_tmp16_ = g_strdup (_tmp15_);
			_tmp17_ = self->priv->remote_url;
			_tmp18_ = g_strdup (_tmp17_);
			gitg_add_remote_action_add_remote (self, _tmp16_, _tmp18_);
			_tmp19_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			gitg_ext_application_show_infobar (_tmp21_, _ ("Failed to add remote"), _tmp23_, GTK_MESSAGE_ERROR);
			_g_object_unref0 (_tmp21_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (remote);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp24_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp27_ = gitg_ext_application_get_remote_lookup (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->remote_name;
		_tmp31_ = gitg_ext_remote_lookup_lookup (_tmp29_, _tmp30_);
		_g_object_unref0 (self->priv->d_remote);
		self->priv->d_remote = _tmp31_;
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (_tmp26_);
		_tmp32_ = remote;
		if (_tmp32_ != NULL) {
			gitg_ext_action_fetch ((GitgExtAction*) self, _____lambda134__gasync_ready_callback, g_object_ref (self));
		}
		_g_object_unref0 (remote);
	}
	gtk_widget_destroy ((GtkWidget*) _data73_->dlg);
}

static void
___lambda133__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda133_ (self, _sender, response_id);
}

void
gitg_add_remote_action_add_remote (GitgAddRemoteAction* self,
                                   gchar* name,
                                   gchar* url)
{
	Block73Data* _data73_;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GtkWindow* _tmp2_;
	GitgAddRemoteActionDialog* _tmp3_;
	GitgAddRemoteActionDialog* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_data73_ = g_slice_new0 (Block73Data);
	_data73_->_ref_count_ = 1;
	_data73_->self = g_object_ref (self);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow);
	_tmp3_ = gitg_add_remote_action_dialog_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_data73_->dlg = _tmp4_;
	_tmp5_ = g_strdup (name);
	_g_free0 (self->priv->remote_name);
	self->priv->remote_name = _tmp5_;
	_tmp6_ = g_strdup (url);
	_g_free0 (self->priv->remote_url);
	self->priv->remote_url = _tmp6_;
	_tmp7_ = self->priv->remote_name;
	gitg_add_remote_action_dialog_set_remote_name (_data73_->dlg, _tmp7_);
	_tmp8_ = self->priv->remote_url;
	gitg_add_remote_action_dialog_set_remote_url (_data73_->dlg, _tmp8_);
	g_signal_connect_data ((GtkDialog*) _data73_->dlg, "response", (GCallback) ___lambda133__gtk_dialog_response, block73_data_ref (_data73_), (GClosureNotify) block73_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data73_->dlg);
	_g_free0 (name);
	_g_free0 (url);
	block73_data_unref (_data73_);
	_data73_ = NULL;
}

static void
gitg_add_remote_action_real_activate (GitgExtUIElement* base)
{
	GitgAddRemoteAction * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GitgAddRemoteAction*) base;
	_tmp0_ = g_strdup ("");
	_tmp1_ = g_strdup ("");
	gitg_add_remote_action_add_remote (self, _tmp0_, _tmp1_);
}

static GitgExtApplication*
gitg_add_remote_action_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgAddRemoteAction* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgAddRemoteAction*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_add_remote_action_real_set_application (GitgExtUIElement* base,
                                             GitgExtApplication* value)
{
	GitgAddRemoteAction* self;
	GitgExtApplication* old_value;
	self = (GitgAddRemoteAction*) base;
	old_value = gitg_add_remote_action_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_add_remote_action_properties[GITG_ADD_REMOTE_ACTION_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static gchar*
gitg_add_remote_action_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgAddRemoteAction* self;
	gchar* _tmp0_;
	self = (GitgAddRemoteAction*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/ref-actions/add-remote");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_add_remote_action_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgAddRemoteAction* self;
	gchar* _tmp0_;
	self = (GitgAddRemoteAction*) base;
	_tmp0_ = g_strdup (_ ("Add Remote"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_add_remote_action_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgAddRemoteAction* self;
	gchar* _tmp0_;
	self = (GitgAddRemoteAction*) base;
	_tmp0_ = g_strdup (_ ("Adds remote to the remotes list"));
	result = _tmp0_;
	return result;
}

static void
gitg_add_remote_action_class_init (GitgAddRemoteActionClass * klass,
                                   gpointer klass_data)
{
	gitg_add_remote_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgAddRemoteAction_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_add_remote_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_add_remote_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_add_remote_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ADD_REMOTE_ACTION_APPLICATION_PROPERTY, gitg_add_remote_action_properties[GITG_ADD_REMOTE_ACTION_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ADD_REMOTE_ACTION_ID_PROPERTY, gitg_add_remote_action_properties[GITG_ADD_REMOTE_ACTION_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ADD_REMOTE_ACTION_DISPLAY_NAME_PROPERTY, gitg_add_remote_action_properties[GITG_ADD_REMOTE_ACTION_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ADD_REMOTE_ACTION_DESCRIPTION_PROPERTY, gitg_add_remote_action_properties[GITG_ADD_REMOTE_ACTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_add_remote_action_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                           gpointer iface_data)
{
	gitg_add_remote_action_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_add_remote_action_real_activate;
	iface->get_application = gitg_add_remote_action_real_get_application;
	iface->set_application = gitg_add_remote_action_real_set_application;
	iface->get_id = gitg_add_remote_action_real_get_id;
	iface->get_display_name = gitg_add_remote_action_real_get_display_name;
	iface->get_description = gitg_add_remote_action_real_get_description;
}

static void
gitg_add_remote_action_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                       gpointer iface_data)
{
	gitg_add_remote_action_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->fetch = (void (*) (GitgExtAction*, GAsyncReadyCallback, gpointer)) gitg_add_remote_action_real_fetch;
	iface->fetch_finish = (gboolean (*) (GitgExtAction*, GAsyncResult*)) gitg_add_remote_action_fetch_finish;
}

static void
gitg_add_remote_action_instance_init (GitgAddRemoteAction * self,
                                      gpointer klass)
{
	self->priv = gitg_add_remote_action_get_instance_private (self);
}

static void
gitg_add_remote_action_finalize (GObject * obj)
{
	GitgAddRemoteAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_ADD_REMOTE_ACTION, GitgAddRemoteAction);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->d_remote);
	_g_object_unref0 (self->priv->repo);
	_g_free0 (self->priv->remote_name);
	_g_free0 (self->priv->remote_url);
	G_OBJECT_CLASS (gitg_add_remote_action_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_add_remote_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgAddRemoteActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_add_remote_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgAddRemoteAction), 0, (GInstanceInitFunc) gitg_add_remote_action_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_add_remote_action_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_add_remote_action_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_add_remote_action_type_id;
	gitg_add_remote_action_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgAddRemoteAction", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_add_remote_action_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_add_remote_action_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	GitgAddRemoteAction_private_offset = g_type_add_instance_private (gitg_add_remote_action_type_id, sizeof (GitgAddRemoteActionPrivate));
	return gitg_add_remote_action_type_id;
}

GType
gitg_add_remote_action_get_type (void)
{
	static gsize gitg_add_remote_action_type_id__once = 0;
	if (g_once_init_enter (&gitg_add_remote_action_type_id__once)) {
		GType gitg_add_remote_action_type_id;
		gitg_add_remote_action_type_id = gitg_add_remote_action_get_type_once ();
		g_once_init_leave (&gitg_add_remote_action_type_id__once, gitg_add_remote_action_type_id);
	}
	return gitg_add_remote_action_type_id__once;
}

static void
_vala_gitg_add_remote_action_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GitgAddRemoteAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_ADD_REMOTE_ACTION, GitgAddRemoteAction);
	switch (property_id) {
		case GITG_ADD_REMOTE_ACTION_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_ADD_REMOTE_ACTION_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_ADD_REMOTE_ACTION_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_ADD_REMOTE_ACTION_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_add_remote_action_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GitgAddRemoteAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_ADD_REMOTE_ACTION, GitgAddRemoteAction);
	switch (property_id) {
		case GITG_ADD_REMOTE_ACTION_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

