/* gitg-lanes.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_LANES_TYPE_LANE_CONTAINER (gitg_lanes_lane_container_get_type ())
#define GITG_LANES_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer))
#define GITG_LANES_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))
#define GITG_LANES_IS_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_IS_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_LANE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))

typedef struct _GitgLanesLaneContainer GitgLanesLaneContainer;
typedef struct _GitgLanesLaneContainerClass GitgLanesLaneContainerClass;
typedef struct _GitgLanesCollapsedLane GitgLanesCollapsedLane;
enum  {
	GITG_LANES_0_PROPERTY,
	GITG_LANES_INACTIVE_MAX_PROPERTY,
	GITG_LANES_INACTIVE_COLLAPSE_PROPERTY,
	GITG_LANES_INACTIVE_GAP_PROPERTY,
	GITG_LANES_INACTIVE_ENABLED_PROPERTY,
	GITG_LANES_MISS_COMMITS_PROPERTY,
	GITG_LANES_NUM_PROPERTIES
};
static GParamSpec* gitg_lanes_properties[GITG_LANES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GitgLanesLaneContainerPrivate GitgLanesLaneContainerPrivate;
#define _gitg_lanes_lane_container_unref0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_lane_container_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gitg_lanes_collapsed_lane_free0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL)))
typedef struct _GitgLanesParamSpecLaneContainer GitgLanesParamSpecLaneContainer;

struct _GitgLanesPrivate {
	gint _inactive_max;
	gint _inactive_collapse;
	gint _inactive_gap;
	gboolean _inactive_enabled;
	GeeLinkedList* _miss_commits;
	GSList* d_previous;
	GeeLinkedList* d_lanes;
	GHashTable* d_collapsed;
	GeeHashSet* d_roots;
};

struct _GitgLanesLaneContainer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgLanesLaneContainerPrivate * priv;
	GitgLane* lane;
	gint inactive;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesLaneContainerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgLanesLaneContainer *self);
};

struct _GitgLanesCollapsedLane {
	GitgColor* color;
	guint index;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesParamSpecLaneContainer {
	GParamSpec parent_instance;
};

static gint GitgLanes_private_offset;
static gpointer gitg_lanes_parent_class = NULL;
static gpointer gitg_lanes_lane_container_parent_class = NULL;

static gpointer gitg_lanes_lane_container_ref (gpointer instance);
static void gitg_lanes_lane_container_unref (gpointer instance);
static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void gitg_lanes_value_set_lane_container (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static void gitg_lanes_value_take_lane_container (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer gitg_lanes_value_get_lane_container (const GValue* value) G_GNUC_UNUSED ;
static GType gitg_lanes_lane_container_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane * self);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a,
                                      gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void _gitg_lanes_collapsed_lane_free0_ (gpointer var);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from,
                                                       GgitOId* to);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type,
                                                             GgitOId* from,
                                                             GgitOId* to);
static void gitg_lanes_lane_container_set_is_hidden (GitgLanesLaneContainer* self,
                                              gboolean value);
static void gitg_lanes_collapse_lanes (GitgLanes* self);
static void gitg_lanes_expand_lanes (GitgLanes* self,
                              GitgCommit* commit);
static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self,
                                                     GgitOId* id,
                                                     gint* pos);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static gboolean gitg_lanes_lane_container_get_is_hidden (GitgLanesLaneContainer* self);
static GSList* gitg_lanes_lanes_list (GitgLanes* self);
static void gitg_lanes_prepare_lanes (GitgLanes* self,
                               GitgCommit* next,
                               gint pos,
                               gboolean hidden);
static void gitg_lanes_init_next_layer (GitgLanes* self);
static void gitg_lanes_add_collapsed (GitgLanes* self,
                               GitgLanesLaneContainer* container,
                               gint index);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static void gitg_lanes_collapse_lane (GitgLanes* self,
                               GitgLanesLaneContainer* container,
                               gint index);
static void gitg_lanes_update_merge_indices (GitgLanes* self,
                                      GSList* lanes,
                                      gint index,
                                      gint direction);
static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self,
                                                   gint index,
                                                   gint direction);
static gint gitg_lanes_ensure_correct_index (GitgLanes* self,
                                      GitgCommit* commit,
                                      gint index);
static void gitg_lanes_update_lane_merge_indices (GitgLanes* self,
                                           GSList* from,
                                           gint index,
                                           gint direction);
static void gitg_lanes_expand_lane (GitgLanes* self,
                             GitgLanesCollapsedLane* lane);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from,
                                                                  GgitOId* to,
                                                                  GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type,
                                                                        GgitOId* from,
                                                                        GgitOId* to,
                                                                        GitgColor* color);
static void gitg_lanes_expand_lane_from_oid (GitgLanes* self,
                                      GgitOId* id);
static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self,
                                     gint index);
static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer * obj);
static GType gitg_lanes_lane_container_get_type_once (void);
static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self);
static void gitg_lanes_finalize (GObject * obj);
static GType gitg_lanes_get_type_once (void);
static void _vala_gitg_lanes_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_gitg_lanes_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static inline gpointer
gitg_lanes_get_instance_private (GitgLanes* self)
{
	return G_STRUCT_MEMBER_P (self, GitgLanes_private_offset);
}

static guint
_ggit_oid_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = ggit_oid_hash (key);
	return result;
}

static gboolean
_ggit_oid_equal_gequal_func (gconstpointer a,
                             gconstpointer b)
{
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
	return result;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
__vala_GgitOId_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
}

static void
_gitg_lanes_collapsed_lane_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL));
}

GitgLanes*
gitg_lanes_construct (GType object_type)
{
	GitgLanes * self = NULL;
	GHashTable* _tmp0_;
	GSettings* settings = NULL;
	GSettings* _tmp1_;
	self = (GitgLanes*) g_object_new (object_type, NULL);
	_tmp0_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, _gitg_lanes_collapsed_lane_free0_);
	_g_hash_table_unref0 (self->priv->d_collapsed);
	self->priv->d_collapsed = _tmp0_;
	_tmp1_ = g_settings_new (APPLICATION_ID ".preferences.history");
	settings = _tmp1_;
	g_settings_bind (settings, "collapse-inactive-lanes-enabled", (GObject*) self, "inactive-enabled", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	g_settings_bind (settings, "collapse-inactive-lanes", (GObject*) self, "inactive-collapse", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	gitg_lanes_reset (self, NULL, (gint) 0, NULL);
	_g_object_unref0 (settings);
	return self;
}

GitgLanes*
gitg_lanes_new (void)
{
	return gitg_lanes_construct (GITG_TYPE_LANES);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static gpointer
__vala_GgitOId_copy0 (gpointer self)
{
	return self ? _vala_GgitOId_copy (self) : NULL;
}

void
gitg_lanes_reset (GitgLanes* self,
                  GgitOId** reserved,
                  gint reserved_length1,
                  GeeHashSet* roots)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeHashSet* _tmp3_;
	GHashTable* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (GITG_LANES_TYPE_LANE_CONTAINER, (GBoxedCopyFunc) gitg_lanes_lane_container_ref, (GDestroyNotify) gitg_lanes_lane_container_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_lanes);
	self->priv->d_lanes = _tmp0_;
	_tmp1_ = gee_linked_list_new (GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp2_ = _tmp1_;
	gitg_lanes_set_miss_commits (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = _g_object_ref0 (roots);
	_g_object_unref0 (self->priv->d_roots);
	self->priv->d_roots = _tmp3_;
	gitg_color_reset ();
	if (reserved != NULL) {
		{
			GgitOId** r_collection = NULL;
			gint r_collection_length1 = 0;
			gint _r_collection_size_ = 0;
			gint r_it = 0;
			r_collection = reserved;
			r_collection_length1 = reserved_length1;
			for (r_it = 0; r_it < r_collection_length1; r_it = r_it + 1) {
				GgitOId* _tmp4_;
				GgitOId* r = NULL;
				_tmp4_ = __vala_GgitOId_copy0 (r_collection[r_it]);
				r = _tmp4_;
				{
					GitgLanesLaneContainer* ct = NULL;
					GgitOId* _tmp5_;
					GitgLanesLaneContainer* _tmp6_;
					GitgLanesLaneContainer* _tmp7_;
					GitgLanesLaneContainer* _tmp8_;
					GeeLinkedList* _tmp9_;
					GitgLanesLaneContainer* _tmp10_;
					_tmp5_ = r;
					_tmp6_ = gitg_lanes_lane_container_new (NULL, _tmp5_);
					ct = _tmp6_;
					_tmp7_ = ct;
					_tmp7_->inactive = -1;
					_tmp8_ = ct;
					gitg_lanes_lane_container_set_is_hidden (_tmp8_, TRUE);
					_tmp9_ = self->priv->d_lanes;
					_tmp10_ = ct;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
					_gitg_lanes_lane_container_unref0 (ct);
					__vala_GgitOId_free0 (r);
				}
			}
		}
	}
	_tmp11_ = self->priv->d_collapsed;
	g_hash_table_remove_all (_tmp11_);
	(self->priv->d_previous == NULL) ? NULL : (self->priv->d_previous = (g_slist_free (self->priv->d_previous), NULL));
	self->priv->d_previous = NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

gboolean
gitg_lanes_next (GitgLanes* self,
                 GitgCommit* next,
                 GSList** lanes,
                 gint* nextpos,
                 gboolean save_miss)
{
	GSList* _vala_lanes = NULL;
	gint _vala_nextpos = 0;
	GgitOId* myoid = NULL;
	GgitOId* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	GgitOId* _tmp3_;
	GgitOId* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GitgLanesLaneContainer* mylane = NULL;
	GgitOId* _tmp7_;
	gint _tmp8_ = 0;
	GitgLanesLaneContainer* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GitgLanesLaneContainer* _tmp12_;
	GitgLanesLaneContainer* _tmp25_;
	gboolean hidden = FALSE;
	GitgLanesLaneContainer* _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	GSList* _tmp58_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (next != NULL, FALSE);
	_tmp0_ = ggit_object_get_id ((GgitObject*) next);
	myoid = _tmp0_;
	_tmp1_ = self->priv->_inactive_enabled;
	if (_tmp1_) {
		gitg_lanes_collapse_lanes (self);
		gitg_lanes_expand_lanes (self, next);
	}
	_tmp2_ = ggit_commit_get_subject ((GgitCommit*) next);
	_tmp3_ = ggit_object_get_id ((GgitObject*) next);
	_tmp4_ = _tmp3_;
	_tmp5_ = ggit_oid_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	g_debug ("gitg-lanes.vala:171: commit: %s %s", _tmp2_, _tmp6_);
	_g_free0 (_tmp6_);
	__vala_GgitOId_free0 (_tmp4_);
	_tmp7_ = myoid;
	_tmp9_ = gitg_lanes_find_lane_by_oid (self, _tmp7_, &_tmp8_);
	_vala_nextpos = _tmp8_;
	mylane = _tmp9_;
	_tmp12_ = mylane;
	if (_tmp12_ == NULL) {
		GeeHashSet* _tmp13_;
		_tmp13_ = self->priv->d_roots;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GeeHashSet* _tmp14_;
		GgitOId* _tmp15_;
		_tmp14_ = self->priv->d_roots;
		_tmp15_ = myoid;
		_tmp10_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		(_vala_lanes == NULL) ? NULL : (_vala_lanes = (_g_slist_free__g_object_unref0_ (_vala_lanes), NULL));
		_vala_lanes = NULL;
		if (save_miss) {
			GgitOId* _tmp16_;
			GgitOId* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GgitOId* _tmp20_;
			GgitOId* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GeeLinkedList* _tmp24_;
			_tmp16_ = ggit_object_get_id ((GgitObject*) next);
			_tmp17_ = _tmp16_;
			_tmp18_ = ggit_oid_to_string (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = ggit_object_get_id ((GgitObject*) next);
			_tmp21_ = _tmp20_;
			_tmp22_ = ggit_oid_to_string (_tmp21_);
			_tmp23_ = _tmp22_;
			g_debug ("gitg-lanes.vala:177: saving miss %s %s", _tmp19_, _tmp23_);
			_g_free0 (_tmp23_);
			__vala_GgitOId_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			__vala_GgitOId_free0 (_tmp17_);
			_tmp24_ = self->priv->_miss_commits;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, next);
		}
		result = FALSE;
		_gitg_lanes_lane_container_unref0 (mylane);
		__vala_GgitOId_free0 (myoid);
		if (lanes) {
			*lanes = _vala_lanes;
		} else {
			(_vala_lanes == NULL) ? NULL : (_vala_lanes = (_g_slist_free__g_object_unref0_ (_vala_lanes), NULL));
		}
		if (nextpos) {
			*nextpos = _vala_nextpos;
		}
		return result;
	}
	_tmp25_ = mylane;
	if (_tmp25_ == NULL) {
		GgitOId* _tmp26_;
		GitgLanesLaneContainer* _tmp27_;
		GeeLinkedList* _tmp28_;
		GitgLanesLaneContainer* _tmp29_;
		GeeLinkedList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp26_ = myoid;
		_tmp27_ = gitg_lanes_lane_container_new (_tmp26_, NULL);
		_gitg_lanes_lane_container_unref0 (mylane);
		mylane = _tmp27_;
		_tmp28_ = self->priv->d_lanes;
		_tmp29_ = mylane;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
		_tmp30_ = self->priv->d_lanes;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_vala_nextpos = ((gint) _tmp32_) - 1;
	} else {
		GitgLanesLaneContainer* _tmp33_;
		GitgLane* _tmp34_;
		GitgLanesLaneContainer* _tmp35_;
		GitgLane* _tmp36_;
		GitgColor* _tmp37_;
		GitgColor* _tmp38_;
		GitgLanesLaneContainer* _tmp39_;
		GitgLanesLaneContainer* _tmp40_;
		GgitOId* _tmp41_;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		GitgLanesLaneContainer* _tmp44_;
		gboolean _tmp45_;
		gboolean _tmp46_;
		GitgLanesLaneContainer* _tmp53_;
		_tmp33_ = mylane;
		_tmp34_ = _tmp33_->lane;
		_tmp35_ = mylane;
		_tmp36_ = _tmp35_->lane;
		_tmp37_ = _tmp36_->color;
		_tmp38_ = gitg_color_copy (_tmp37_);
		_g_object_unref0 (_tmp34_->color);
		_tmp34_->color = _tmp38_;
		_tmp39_ = mylane;
		__vala_GgitOId_free0 (_tmp39_->to);
		_tmp39_->to = NULL;
		_tmp40_ = mylane;
		_tmp41_ = ggit_object_get_id ((GgitObject*) next);
		__vala_GgitOId_free0 (_tmp40_->from);
		_tmp40_->from = _tmp41_;
		_tmp44_ = mylane;
		_tmp45_ = gitg_lanes_lane_container_get_is_hidden (_tmp44_);
		_tmp46_ = _tmp45_;
		if (_tmp46_) {
			GeeHashSet* _tmp47_;
			_tmp47_ = self->priv->d_roots;
			_tmp43_ = _tmp47_ != NULL;
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			GeeHashSet* _tmp48_;
			GgitOId* _tmp49_;
			_tmp48_ = self->priv->d_roots;
			_tmp49_ = myoid;
			_tmp42_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp48_, _tmp49_);
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			GitgLanesLaneContainer* _tmp50_;
			GitgLanesLaneContainer* _tmp51_;
			GitgLane* _tmp52_;
			_tmp50_ = mylane;
			gitg_lanes_lane_container_set_is_hidden (_tmp50_, FALSE);
			_tmp51_ = mylane;
			_tmp52_ = _tmp51_->lane;
			(_tmp52_->from == NULL) ? NULL : (_tmp52_->from = (g_slist_free (_tmp52_->from), NULL));
			_tmp52_->from = NULL;
		}
		_tmp53_ = mylane;
		if (_tmp53_->inactive >= 0) {
			GitgLanesLaneContainer* _tmp54_;
			_tmp54_ = mylane;
			_tmp54_->inactive = 0;
		}
	}
	_tmp55_ = mylane;
	_tmp56_ = gitg_lanes_lane_container_get_is_hidden (_tmp55_);
	_tmp57_ = _tmp56_;
	hidden = _tmp57_;
	_tmp58_ = gitg_lanes_lanes_list (self);
	(_vala_lanes == NULL) ? NULL : (_vala_lanes = (_g_slist_free__g_object_unref0_ (_vala_lanes), NULL));
	_vala_lanes = _tmp58_;
	gitg_lanes_prepare_lanes (self, next, _vala_nextpos, hidden);
	result = !hidden;
	_gitg_lanes_lane_container_unref0 (mylane);
	__vala_GgitOId_free0 (myoid);
	if (lanes) {
		*lanes = _vala_lanes;
	} else {
		(_vala_lanes == NULL) ? NULL : (_vala_lanes = (_g_slist_free__g_object_unref0_ (_vala_lanes), NULL));
	}
	if (nextpos) {
		*nextpos = _vala_nextpos;
	}
	return result;
}

static void
gitg_lanes_prepare_lanes (GitgLanes* self,
                          GitgCommit* next,
                          gint pos,
                          gboolean hidden)
{
	GgitCommitParents* parents = NULL;
	GgitCommitParents* _tmp0_;
	GgitOId* myoid = NULL;
	GgitOId* _tmp1_;
	GitgLanesLaneContainer* mylane = NULL;
	GeeLinkedList* _tmp2_;
	gpointer _tmp3_;
	gboolean _tmp72_ = FALSE;
	GitgLanesLaneContainer* _tmp73_;
	GSList* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (next != NULL);
	_tmp0_ = ggit_commit_get_parents ((GgitCommit*) next);
	parents = _tmp0_;
	_tmp1_ = ggit_object_get_id ((GgitObject*) next);
	myoid = _tmp1_;
	if (!hidden) {
		gitg_lanes_init_next_layer (self);
	}
	_tmp2_ = self->priv->d_lanes;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, pos);
	mylane = (GitgLanesLaneContainer*) _tmp3_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GgitCommitParents* _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				gint lnpos = 0;
				GgitOId* poid = NULL;
				GgitCommitParents* _tmp9_;
				GgitOId* _tmp10_;
				GitgLanesLaneContainer* container = NULL;
				GgitOId* _tmp11_;
				gint _tmp12_ = 0;
				GitgLanesLaneContainer* _tmp13_;
				GitgLanesLaneContainer* _tmp14_;
				if (!_tmp4_) {
					guint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				_tmp6_ = parents;
				_tmp7_ = ggit_commit_parents_get_size (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = parents;
				_tmp10_ = ggit_commit_parents_get_id (_tmp9_, i);
				poid = _tmp10_;
				_tmp11_ = poid;
				_tmp13_ = gitg_lanes_find_lane_by_oid (self, _tmp11_, &_tmp12_);
				lnpos = _tmp12_;
				container = _tmp13_;
				_tmp14_ = container;
				if (_tmp14_ != NULL) {
					gboolean _tmp15_ = FALSE;
					if (i == ((guint) 0)) {
						_tmp15_ = pos < lnpos;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						GitgLanesLaneContainer* _tmp16_;
						GgitOId* _tmp17_;
						GgitOId* _tmp18_;
						GitgLanesLaneContainer* _tmp19_;
						GgitOId* _tmp20_;
						GgitOId* _tmp21_;
						GitgLanesLaneContainer* _tmp22_;
						gboolean _tmp23_;
						gboolean _tmp24_;
						GitgLanesLaneContainer* _tmp28_;
						GitgLane* _tmp29_;
						GitgLanesLaneContainer* _tmp30_;
						GitgLane* _tmp31_;
						GitgColor* _tmp32_;
						GitgColor* _tmp33_;
						GitgLanesLaneContainer* _tmp34_;
						GeeLinkedList* _tmp36_;
						GitgLanesLaneContainer* _tmp37_;
						_tmp16_ = mylane;
						_tmp17_ = poid;
						_tmp18_ = __vala_GgitOId_copy0 (_tmp17_);
						__vala_GgitOId_free0 (_tmp16_->to);
						_tmp16_->to = _tmp18_;
						_tmp19_ = mylane;
						_tmp20_ = myoid;
						_tmp21_ = __vala_GgitOId_copy0 (_tmp20_);
						__vala_GgitOId_free0 (_tmp19_->from);
						_tmp19_->from = _tmp21_;
						_tmp22_ = container;
						_tmp23_ = gitg_lanes_lane_container_get_is_hidden (_tmp22_);
						_tmp24_ = _tmp23_;
						if (!_tmp24_) {
							GitgLanesLaneContainer* _tmp25_;
							GitgLane* _tmp26_;
							GitgLanesLaneContainer* _tmp27_;
							_tmp25_ = mylane;
							_tmp26_ = _tmp25_->lane;
							_tmp26_->from = g_slist_append (_tmp26_->from, (gpointer) ((gintptr) lnpos));
							_tmp27_ = mylane;
							gitg_lanes_lane_container_set_is_hidden (_tmp27_, FALSE);
						}
						_tmp28_ = mylane;
						_tmp29_ = _tmp28_->lane;
						_tmp30_ = mylane;
						_tmp31_ = _tmp30_->lane;
						_tmp32_ = _tmp31_->color;
						_tmp33_ = gitg_color_copy (_tmp32_);
						_g_object_unref0 (_tmp29_->color);
						_tmp29_->color = _tmp33_;
						_tmp34_ = mylane;
						if (_tmp34_->inactive >= 0) {
							GitgLanesLaneContainer* _tmp35_;
							_tmp35_ = mylane;
							_tmp35_->inactive = 0;
						}
						_tmp36_ = self->priv->d_lanes;
						_tmp37_ = container;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp36_, _tmp37_);
					} else {
						GitgLanesLaneContainer* _tmp38_;
						GgitOId* _tmp39_;
						GgitOId* _tmp40_;
						GitgLanesLaneContainer* _tmp43_;
						GitgLane* _tmp44_;
						GitgLanesLaneContainer* _tmp45_;
						GitgLane* _tmp46_;
						GitgColor* _tmp47_;
						GitgColor* _tmp48_;
						GitgLanesLaneContainer* _tmp50_;
						_tmp38_ = container;
						_tmp39_ = myoid;
						_tmp40_ = __vala_GgitOId_copy0 (_tmp39_);
						__vala_GgitOId_free0 (_tmp38_->from);
						_tmp38_->from = _tmp40_;
						if (!hidden) {
							GitgLanesLaneContainer* _tmp41_;
							GitgLane* _tmp42_;
							_tmp41_ = container;
							_tmp42_ = _tmp41_->lane;
							_tmp42_->from = g_slist_append (_tmp42_->from, (gpointer) ((gintptr) pos));
						}
						_tmp43_ = container;
						_tmp44_ = _tmp43_->lane;
						_tmp45_ = container;
						_tmp46_ = _tmp45_->lane;
						_tmp47_ = _tmp46_->color;
						_tmp48_ = gitg_color_copy (_tmp47_);
						_g_object_unref0 (_tmp44_->color);
						_tmp44_->color = _tmp48_;
						if (!hidden) {
							GitgLanesLaneContainer* _tmp49_;
							_tmp49_ = container;
							gitg_lanes_lane_container_set_is_hidden (_tmp49_, FALSE);
						}
						_tmp50_ = container;
						if (_tmp50_->inactive >= 0) {
							GitgLanesLaneContainer* _tmp51_;
							_tmp51_ = container;
							_tmp51_->inactive = 0;
						}
					}
					_gitg_lanes_lane_container_unref0 (container);
					__vala_GgitOId_free0 (poid);
					continue;
				} else {
					gboolean _tmp52_ = FALSE;
					GitgLanesLaneContainer* _tmp53_;
					_tmp53_ = mylane;
					if (_tmp53_ != NULL) {
						GitgLanesLaneContainer* _tmp54_;
						GgitOId* _tmp55_;
						_tmp54_ = mylane;
						_tmp55_ = _tmp54_->to;
						_tmp52_ = _tmp55_ == NULL;
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						GitgLanesLaneContainer* _tmp56_;
						GgitOId* _tmp57_;
						GgitOId* _tmp58_;
						GitgLanesLaneContainer* _tmp59_;
						GitgLane* _tmp60_;
						GitgLanesLaneContainer* _tmp61_;
						GitgLane* _tmp62_;
						GitgColor* _tmp63_;
						GitgColor* _tmp64_;
						_tmp56_ = mylane;
						_tmp57_ = poid;
						_tmp58_ = __vala_GgitOId_copy0 (_tmp57_);
						__vala_GgitOId_free0 (_tmp56_->to);
						_tmp56_->to = _tmp58_;
						_tmp59_ = mylane;
						_tmp60_ = _tmp59_->lane;
						_tmp61_ = mylane;
						_tmp62_ = _tmp61_->lane;
						_tmp63_ = _tmp62_->color;
						_tmp64_ = gitg_color_copy (_tmp63_);
						_g_object_unref0 (_tmp60_->color);
						_tmp60_->color = _tmp64_;
					} else {
						if (!hidden) {
							GitgLanesLaneContainer* newlane = NULL;
							GgitOId* _tmp65_;
							GgitOId* _tmp66_;
							GitgLanesLaneContainer* _tmp67_;
							GitgLanesLaneContainer* _tmp68_;
							GitgLane* _tmp69_;
							GeeLinkedList* _tmp70_;
							GitgLanesLaneContainer* _tmp71_;
							_tmp65_ = myoid;
							_tmp66_ = poid;
							_tmp67_ = gitg_lanes_lane_container_new (_tmp65_, _tmp66_);
							newlane = _tmp67_;
							_tmp68_ = newlane;
							_tmp69_ = _tmp68_->lane;
							_tmp69_->from = g_slist_prepend (_tmp69_->from, (gpointer) ((gintptr) pos));
							_tmp70_ = self->priv->d_lanes;
							_tmp71_ = newlane;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, _tmp71_);
							_gitg_lanes_lane_container_unref0 (newlane);
						}
					}
				}
				_gitg_lanes_lane_container_unref0 (container);
				__vala_GgitOId_free0 (poid);
			}
		}
	}
	_tmp73_ = mylane;
	if (_tmp73_ != NULL) {
		GitgLanesLaneContainer* _tmp74_;
		GgitOId* _tmp75_;
		_tmp74_ = mylane;
		_tmp75_ = _tmp74_->to;
		_tmp72_ = _tmp75_ == NULL;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		GeeLinkedList* _tmp76_;
		GitgLanesLaneContainer* _tmp77_;
		_tmp76_ = self->priv->d_lanes;
		_tmp77_ = mylane;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp76_, _tmp77_);
	}
	_tmp78_ = self->priv->d_previous;
	_tmp79_ = self->priv->_inactive_collapse;
	_tmp80_ = self->priv->_inactive_gap;
	if (g_slist_length (_tmp78_) == ((guint) ((_tmp79_ + _tmp80_) + 1))) {
		GSList* _tmp81_;
		GSList* _tmp82_;
		_tmp81_ = self->priv->d_previous;
		_tmp82_ = g_slist_last (_tmp81_);
		self->priv->d_previous = g_slist_delete_link (self->priv->d_previous, _tmp82_);
	}
	self->priv->d_previous = g_slist_prepend (self->priv->d_previous, next);
	_gitg_lanes_lane_container_unref0 (mylane);
	__vala_GgitOId_free0 (myoid);
	_g_object_unref0 (parents);
}

static void
gitg_lanes_add_collapsed (GitgLanes* self,
                          GitgLanesLaneContainer* container,
                          gint index)
{
	GitgLanesCollapsedLane* collapsed = NULL;
	GitgLanesCollapsedLane* _tmp0_;
	GitgLanesCollapsedLane* _tmp1_;
	GHashTable* _tmp2_;
	GgitOId* _tmp3_;
	GgitOId* _tmp4_;
	GitgLanesCollapsedLane* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = gitg_lanes_collapsed_lane_new (container);
	collapsed = _tmp0_;
	_tmp1_ = collapsed;
	_tmp1_->index = (guint) index;
	_tmp2_ = self->priv->d_collapsed;
	_tmp3_ = container->to;
	_tmp4_ = __vala_GgitOId_copy0 (_tmp3_);
	_tmp5_ = collapsed;
	collapsed = NULL;
	g_hash_table_insert (_tmp2_, _tmp4_, _tmp5_);
	_gitg_lanes_collapsed_lane_free0 (collapsed);
}

static void
gitg_lanes_collapse_lane (GitgLanes* self,
                          GitgLanesLaneContainer* container,
                          gint index)
{
	GSList* item = NULL;
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	gitg_lanes_add_collapsed (self, container, index);
	_tmp0_ = self->priv->d_previous;
	item = _tmp0_;
	while (TRUE) {
		GSList* _tmp1_;
		GitgCommit* commit = NULL;
		GSList* _tmp2_;
		gconstpointer _tmp3_;
		GitgCommit* _tmp4_;
		GSList* lns = NULL;
		GitgCommit* _tmp5_;
		GSList* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GSList* _tmp8_;
		GSList* _tmp39_;
		GSList* _tmp40_;
		_tmp1_ = item;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = item;
		_tmp3_ = _tmp2_->data;
		_tmp4_ = _g_object_ref0 ((GitgCommit*) _tmp3_);
		commit = _tmp4_;
		_tmp5_ = commit;
		_tmp6_ = gitg_commit_get_lanes (_tmp5_);
		lns = _tmp6_;
		_tmp8_ = lns;
		if (_tmp8_ != NULL) {
			GSList* _tmp9_;
			_tmp9_ = lns;
			_tmp7_ = ((guint) index) < g_slist_length (_tmp9_);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GitgLane* lane = NULL;
			GSList* _tmp10_;
			gconstpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			GSList* _tmp13_;
			GSList* _tmp14_;
			_tmp10_ = lns;
			_tmp11_ = g_slist_nth_data (_tmp10_, (guint) index);
			lane = (GitgLane*) _tmp11_;
			_tmp13_ = item;
			_tmp14_ = _tmp13_->next;
			if (_tmp14_ != NULL) {
				GitgLane* _tmp15_;
				GSList* _tmp16_;
				_tmp15_ = lane;
				_tmp16_ = _tmp15_->from;
				_tmp12_ = _tmp16_ != NULL;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gint newindex = 0;
				GitgLane* _tmp17_;
				GSList* _tmp18_;
				gconstpointer _tmp19_;
				GitgCommit* _tmp20_;
				GitgLane* _tmp21_;
				GSList* _tmp22_;
				GSList* _tmp23_;
				GSList* _tmp24_;
				GSList* _tmp25_;
				guint mylane = 0U;
				GitgCommit* _tmp27_;
				guint _tmp28_;
				guint _tmp29_;
				_tmp17_ = lane;
				_tmp18_ = _tmp17_->from;
				_tmp19_ = _tmp18_->data;
				newindex = (gint) ((gintptr) _tmp19_);
				_tmp20_ = commit;
				_tmp21_ = lane;
				_tmp22_ = gitg_commit_remove_lane (_tmp20_, _tmp21_);
				lns = _tmp22_;
				_tmp23_ = item;
				_tmp24_ = _tmp23_->next;
				_tmp25_ = _tmp24_->next;
				if (_tmp25_ != NULL) {
					GSList* _tmp26_;
					_tmp26_ = lns;
					gitg_lanes_update_merge_indices (self, _tmp26_, newindex, -1);
				}
				_tmp27_ = commit;
				_tmp28_ = gitg_commit_get_mylane (_tmp27_);
				_tmp29_ = _tmp28_;
				mylane = _tmp29_;
				if (mylane > ((guint) index)) {
					GitgCommit* _tmp30_;
					guint _tmp31_;
					guint _tmp32_;
					guint _tmp33_;
					_tmp30_ = commit;
					_tmp31_ = gitg_commit_get_mylane (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp32_ = _tmp32_ - 1;
					_tmp33_ = _tmp32_;
					gitg_commit_set_mylane (_tmp30_, _tmp33_);
				}
				index = newindex;
			} else {
				GitgLane* _tmp34_;
				GitgLane* _tmp35_;
				GitgLane* _tmp36_;
				GgitOId* _tmp37_;
				GgitOId* _tmp38_;
				_tmp34_ = lane;
				_tmp35_ = lane;
				_tmp35_->tag = _tmp35_->tag | GITG_LANE_TAG_END;
				_tmp36_ = lane;
				_tmp37_ = container->to;
				_tmp38_ = __vala_GgitOId_copy0 (_tmp37_);
				__vala_GgitOId_free0 (_tmp36_->boundary_id);
				_tmp36_->boundary_id = _tmp38_;
			}
		}
		_tmp39_ = item;
		_tmp40_ = _tmp39_->next;
		item = _tmp40_;
		_g_object_unref0 (commit);
	}
}

static void
gitg_lanes_collapse_lanes (GitgLanes* self)
{
	gint index = 0;
	GeeIterator* iter = NULL;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	index = 0;
	_tmp0_ = self->priv->d_lanes;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GitgLanesLaneContainer* container = NULL;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		GitgLanesLaneContainer* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GitgLanesLaneContainer* _tmp9_;
		GitgLanesLaneContainer* _tmp10_;
		GitgLane* _tmp11_;
		GSList* _tmp12_;
		gconstpointer _tmp13_;
		GeeIterator* _tmp14_;
		_tmp2_ = iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_iterator_get (_tmp3_);
		container = (GitgLanesLaneContainer*) _tmp4_;
		_tmp5_ = container;
		_tmp6_ = self->priv->_inactive_max;
		_tmp7_ = self->priv->_inactive_gap;
		if (_tmp5_->inactive != (_tmp6_ + _tmp7_)) {
			gint _tmp8_;
			index = index + 1;
			_tmp8_ = index;
			_gitg_lanes_lane_container_unref0 (container);
			continue;
		}
		_tmp9_ = container;
		_tmp10_ = container;
		_tmp11_ = _tmp10_->lane;
		_tmp12_ = _tmp11_->from;
		_tmp13_ = _tmp12_->data;
		gitg_lanes_collapse_lane (self, _tmp9_, (gint) ((gintptr) _tmp13_));
		gitg_lanes_update_current_lane_merge_indices (self, index, -1);
		_tmp14_ = iter;
		gee_iterator_remove (_tmp14_);
		_gitg_lanes_lane_container_unref0 (container);
	}
	_g_object_unref0 (iter);
}

static gint
gitg_lanes_ensure_correct_index (GitgLanes* self,
                                 GitgCommit* commit,
                                 gint index)
{
	guint len = 0U;
	GSList* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (commit != NULL, 0);
	_tmp0_ = gitg_commit_get_lanes (commit);
	len = g_slist_length (_tmp0_);
	if (((guint) index) > len) {
		result = (gint) len;
		return result;
	} else {
		result = index;
		return result;
	}
}

static void
gitg_lanes_update_lane_merge_indices (GitgLanes* self,
                                      GSList* from,
                                      gint index,
                                      gint direction)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gint idx = 0;
		gconstpointer _tmp0_;
		gboolean _tmp1_ = FALSE;
		GSList* _tmp3_;
		if (!(from != NULL)) {
			break;
		}
		_tmp0_ = from->data;
		idx = (gint) ((gintptr) _tmp0_);
		if (idx > index) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (direction > 0) {
				_tmp2_ = idx == index;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		if (_tmp1_) {
			from->data = (gpointer) ((gintptr) (idx + direction));
		}
		_tmp3_ = from->next;
		from = _tmp3_;
	}
}

static void
gitg_lanes_update_merge_indices (GitgLanes* self,
                                 GSList* lanes,
                                 gint index,
                                 gint direction)
{
	g_return_if_fail (self != NULL);
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
		lane_collection = lanes;
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
			GitgLane* lane = NULL;
			lane = (GitgLane*) lane_it->data;
			{
				GitgLane* _tmp0_;
				GSList* _tmp1_;
				_tmp0_ = lane;
				_tmp1_ = _tmp0_->from;
				gitg_lanes_update_lane_merge_indices (self, _tmp1_, index, direction);
			}
		}
	}
}

static void
gitg_lanes_update_current_lane_merge_indices (GitgLanes* self,
                                              gint index,
                                              gint direction)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _container_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _container_index = 0;
		_tmp0_ = self->priv->d_lanes;
		_container_list = _tmp0_;
		_tmp1_ = _container_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_container_size = _tmp3_;
		_container_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			GitgLanesLaneContainer* _tmp8_;
			GitgLane* _tmp9_;
			GSList* _tmp10_;
			_container_index = _container_index + 1;
			_tmp4_ = _container_index;
			_tmp5_ = _container_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _container_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _container_index);
			container = (GitgLanesLaneContainer*) _tmp7_;
			_tmp8_ = container;
			_tmp9_ = _tmp8_->lane;
			_tmp10_ = _tmp9_->from;
			gitg_lanes_update_lane_merge_indices (self, _tmp10_, index, direction);
			_gitg_lanes_lane_container_unref0 (container);
		}
	}
}

static void
gitg_lanes_expand_lane (GitgLanes* self,
                        GitgLanesCollapsedLane* lane)
{
	guint index = 0U;
	GitgLane* ln = NULL;
	GitgColor* _tmp0_;
	GitgLane* _tmp1_;
	gint len = 0;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint next = 0;
	GSList* _tmp5_;
	gconstpointer _tmp6_;
	GitgLanesLaneContainer* container = NULL;
	GgitOId* _tmp7_;
	GgitOId* _tmp8_;
	GitgColor* _tmp9_;
	GitgLanesLaneContainer* _tmp10_;
	GitgLanesLaneContainer* _tmp11_;
	GitgLane* _tmp12_;
	GeeLinkedList* _tmp13_;
	GitgLanesLaneContainer* _tmp14_;
	guint cnt = 0U;
	GSList* ptr = NULL;
	GSList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lane != NULL);
	index = lane->index;
	_tmp0_ = lane->color;
	_tmp1_ = gitg_lane_new_with_color (_tmp0_);
	ln = _tmp1_;
	_tmp2_ = self->priv->d_lanes;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	if (index > ((guint) len)) {
		index = (guint) len;
	}
	_tmp5_ = self->priv->d_previous;
	_tmp6_ = _tmp5_->data;
	next = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp6_, (gint) index);
	_tmp7_ = lane->from;
	_tmp8_ = lane->to;
	_tmp9_ = lane->color;
	_tmp10_ = gitg_lanes_lane_container_new_with_color (_tmp7_, _tmp8_, _tmp9_);
	container = _tmp10_;
	gitg_lanes_update_current_lane_merge_indices (self, (gint) index, 1);
	_tmp11_ = container;
	_tmp12_ = _tmp11_->lane;
	_tmp12_->from = g_slist_prepend (_tmp12_->from, (gpointer) ((gintptr) next));
	_tmp13_ = self->priv->d_lanes;
	_tmp14_ = container;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp13_, (gint) index, _tmp14_);
	index = (guint) next;
	cnt = (guint) 0;
	_tmp15_ = self->priv->d_previous;
	ptr = _tmp15_;
	while (TRUE) {
		GSList* _tmp16_;
		GitgCommit* commit = NULL;
		GSList* _tmp17_;
		gconstpointer _tmp18_;
		GitgCommit* _tmp19_;
		gint _tmp20_;
		GitgLane* copy = NULL;
		GitgLane* _tmp21_;
		GitgLane* _tmp22_;
		GSList* lns = NULL;
		GitgCommit* _tmp23_;
		GSList* _tmp24_;
		gboolean _tmp25_ = FALSE;
		GSList* _tmp26_;
		GSList* _tmp27_;
		GitgCommit* _tmp39_;
		GitgLane* _tmp40_;
		guint mylane = 0U;
		GitgCommit* _tmp41_;
		guint _tmp42_;
		guint _tmp43_;
		guint _tmp48_;
		GSList* _tmp49_;
		GSList* _tmp50_;
		_tmp16_ = ptr;
		if (!(_tmp16_ != NULL)) {
			break;
		}
		_tmp17_ = ptr;
		_tmp18_ = _tmp17_->data;
		_tmp19_ = _g_object_ref0 ((GitgCommit*) _tmp18_);
		commit = _tmp19_;
		_tmp20_ = self->priv->_inactive_collapse;
		if (cnt == ((guint) _tmp20_)) {
			_g_object_unref0 (commit);
			break;
		}
		_tmp21_ = ln;
		_tmp22_ = gitg_lane_copy (_tmp21_);
		copy = _tmp22_;
		_tmp23_ = commit;
		_tmp24_ = gitg_commit_get_lanes (_tmp23_);
		lns = _tmp24_;
		_tmp26_ = ptr;
		_tmp27_ = _tmp26_->next;
		if (_tmp27_ == NULL) {
			_tmp25_ = TRUE;
		} else {
			gint _tmp28_;
			_tmp28_ = self->priv->_inactive_collapse;
			_tmp25_ = (cnt + 1) == ((guint) _tmp28_);
		}
		if (_tmp25_) {
			GitgLane* _tmp29_;
			GgitOId* _tmp30_;
			GgitOId* _tmp31_;
			GitgLane* _tmp32_;
			GitgLane* _tmp33_;
			_tmp29_ = copy;
			_tmp30_ = lane->from;
			_tmp31_ = __vala_GgitOId_copy0 (_tmp30_);
			__vala_GgitOId_free0 (_tmp29_->boundary_id);
			_tmp29_->boundary_id = _tmp31_;
			_tmp32_ = copy;
			_tmp33_ = copy;
			_tmp33_->tag = _tmp33_->tag | GITG_LANE_TAG_START;
		} else {
			GSList* _tmp34_;
			GSList* _tmp35_;
			gconstpointer _tmp36_;
			GitgLane* _tmp37_;
			GSList* _tmp38_;
			_tmp34_ = ptr;
			_tmp35_ = _tmp34_->next;
			_tmp36_ = _tmp35_->data;
			next = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp36_, (gint) index);
			_tmp37_ = copy;
			_tmp37_->from = g_slist_prepend (_tmp37_->from, (gpointer) ((gintptr) next));
			_tmp38_ = lns;
			gitg_lanes_update_merge_indices (self, _tmp38_, (gint) index, 1);
		}
		_tmp39_ = commit;
		_tmp40_ = copy;
		gitg_commit_insert_lane (_tmp39_, _tmp40_, (gint) index);
		_tmp41_ = commit;
		_tmp42_ = gitg_commit_get_mylane (_tmp41_);
		_tmp43_ = _tmp42_;
		mylane = _tmp43_;
		if (mylane >= index) {
			GitgCommit* _tmp44_;
			guint _tmp45_;
			guint _tmp46_;
			guint _tmp47_;
			_tmp44_ = commit;
			_tmp45_ = gitg_commit_get_mylane (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp46_ = _tmp46_ + 1;
			_tmp47_ = _tmp46_;
			gitg_commit_set_mylane (_tmp44_, _tmp47_);
		}
		index = (guint) next;
		cnt = cnt + 1;
		_tmp48_ = cnt;
		_tmp49_ = ptr;
		_tmp50_ = _tmp49_->next;
		ptr = _tmp50_;
		_g_object_unref0 (copy);
		_g_object_unref0 (commit);
	}
	_gitg_lanes_lane_container_unref0 (container);
	_g_object_unref0 (ln);
}

static void
gitg_lanes_expand_lane_from_oid (GitgLanes* self,
                                 GgitOId* id)
{
	GitgLanesCollapsedLane* collapsed = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GitgLanesCollapsedLane* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->d_collapsed;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	collapsed = (GitgLanesCollapsedLane*) _tmp1_;
	_tmp2_ = collapsed;
	if (_tmp2_ != NULL) {
		GitgLanesCollapsedLane* _tmp3_;
		GHashTable* _tmp4_;
		_tmp3_ = collapsed;
		gitg_lanes_expand_lane (self, _tmp3_);
		_tmp4_ = self->priv->d_collapsed;
		g_hash_table_remove (_tmp4_, id);
	}
}

static void
gitg_lanes_expand_lanes (GitgLanes* self,
                         GitgCommit* commit)
{
	GgitOId* _tmp0_;
	GgitOId* _tmp1_;
	GgitCommitParents* parents = NULL;
	GgitCommitParents* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (commit != NULL);
	_tmp0_ = ggit_object_get_id ((GgitObject*) commit);
	_tmp1_ = _tmp0_;
	gitg_lanes_expand_lane_from_oid (self, _tmp1_);
	__vala_GgitOId_free0 (_tmp1_);
	_tmp2_ = ggit_commit_get_parents ((GgitCommit*) commit);
	parents = _tmp2_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GgitCommitParents* _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				GgitCommitParents* _tmp8_;
				GgitOId* _tmp9_;
				GgitOId* _tmp10_;
				if (!_tmp3_) {
					guint _tmp4_;
					i = i + 1;
					_tmp4_ = i;
				}
				_tmp3_ = FALSE;
				_tmp5_ = parents;
				_tmp6_ = ggit_commit_parents_get_size (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = parents;
				_tmp9_ = ggit_commit_parents_get_id (_tmp8_, i);
				_tmp10_ = _tmp9_;
				gitg_lanes_expand_lane_from_oid (self, _tmp10_);
				__vala_GgitOId_free0 (_tmp10_);
			}
		}
	}
	_g_object_unref0 (parents);
}

static void
gitg_lanes_init_next_layer (GitgLanes* self)
{
	gint index = 0;
	g_return_if_fail (self != NULL);
	index = 0;
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _container_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _container_index = 0;
		_tmp0_ = self->priv->d_lanes;
		_container_list = _tmp0_;
		_tmp1_ = _container_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_container_size = _tmp3_;
		_container_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			GitgLanesLaneContainer* _tmp8_;
			gint _tmp9_;
			_container_index = _container_index + 1;
			_tmp4_ = _container_index;
			_tmp5_ = _container_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _container_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _container_index);
			container = (GitgLanesLaneContainer*) _tmp7_;
			_tmp8_ = container;
			_tmp9_ = index;
			index = _tmp9_ + 1;
			gitg_lanes_lane_container_next (_tmp8_, _tmp9_);
			_gitg_lanes_lane_container_unref0 (container);
		}
	}
}

static GitgLanesLaneContainer*
gitg_lanes_find_lane_by_oid (GitgLanes* self,
                             GgitOId* id,
                             gint* pos)
{
	gint _vala_pos = 0;
	gint p = 0;
	GitgLanesLaneContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	p = 0;
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _container_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _container_index = 0;
		_tmp0_ = self->priv->d_lanes;
		_container_list = _tmp0_;
		_tmp1_ = _container_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_container_size = _tmp3_;
		_container_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			GitgLanesLaneContainer* _tmp9_;
			gint _tmp12_;
			_container_index = _container_index + 1;
			_tmp4_ = _container_index;
			_tmp5_ = _container_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _container_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _container_index);
			container = (GitgLanesLaneContainer*) _tmp7_;
			_tmp9_ = container;
			if (_tmp9_ != NULL) {
				GitgLanesLaneContainer* _tmp10_;
				GgitOId* _tmp11_;
				_tmp10_ = container;
				_tmp11_ = _tmp10_->to;
				_tmp8_ = ggit_oid_equal (id, _tmp11_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_vala_pos = p;
				result = container;
				if (pos) {
					*pos = _vala_pos;
				}
				return result;
			}
			p = p + 1;
			_tmp12_ = p;
			_gitg_lanes_lane_container_unref0 (container);
		}
	}
	_vala_pos = -1;
	result = NULL;
	if (pos) {
		*pos = _vala_pos;
	}
	return result;
}

static GSList*
gitg_lanes_lanes_list (GitgLanes* self)
{
	GSList* ret = NULL;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _container_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _container_index = 0;
		_tmp0_ = self->priv->d_lanes;
		_container_list = _tmp0_;
		_tmp1_ = _container_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_container_size = _tmp3_;
		_container_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			GitgLanesLaneContainer* _tmp8_;
			GitgLane* _tmp9_;
			GitgLane* _tmp10_;
			_container_index = _container_index + 1;
			_tmp4_ = _container_index;
			_tmp5_ = _container_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _container_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _container_index);
			container = (GitgLanesLaneContainer*) _tmp7_;
			_tmp8_ = container;
			_tmp9_ = _tmp8_->lane;
			_tmp10_ = gitg_lane_copy (_tmp9_);
			ret = g_slist_append (ret, _tmp10_);
			_gitg_lanes_lane_container_unref0 (container);
		}
	}
	result = ret;
	return result;
}

gint
gitg_lanes_get_inactive_max (GitgLanes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_inactive_max;
	return result;
}

void
gitg_lanes_set_inactive_max (GitgLanes* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_lanes_get_inactive_max (self);
	if (old_value != value) {
		self->priv->_inactive_max = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_lanes_properties[GITG_LANES_INACTIVE_MAX_PROPERTY]);
	}
}

gint
gitg_lanes_get_inactive_collapse (GitgLanes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_inactive_collapse;
	return result;
}

void
gitg_lanes_set_inactive_collapse (GitgLanes* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_lanes_get_inactive_collapse (self);
	if (old_value != value) {
		self->priv->_inactive_collapse = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_lanes_properties[GITG_LANES_INACTIVE_COLLAPSE_PROPERTY]);
	}
}

gint
gitg_lanes_get_inactive_gap (GitgLanes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_inactive_gap;
	return result;
}

void
gitg_lanes_set_inactive_gap (GitgLanes* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_lanes_get_inactive_gap (self);
	if (old_value != value) {
		self->priv->_inactive_gap = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_lanes_properties[GITG_LANES_INACTIVE_GAP_PROPERTY]);
	}
}

gboolean
gitg_lanes_get_inactive_enabled (GitgLanes* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inactive_enabled;
	return result;
}

void
gitg_lanes_set_inactive_enabled (GitgLanes* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_lanes_get_inactive_enabled (self);
	if (old_value != value) {
		self->priv->_inactive_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_lanes_properties[GITG_LANES_INACTIVE_ENABLED_PROPERTY]);
	}
}

GeeLinkedList*
gitg_lanes_get_miss_commits (GitgLanes* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_miss_commits;
	result = _tmp0_;
	return result;
}

void
gitg_lanes_set_miss_commits (GitgLanes* self,
                             GeeLinkedList* value)
{
	GeeLinkedList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_lanes_get_miss_commits (self);
	if (old_value != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_miss_commits);
		self->priv->_miss_commits = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_lanes_properties[GITG_LANES_MISS_COMMITS_PROPERTY]);
	}
}

static GitgLanesLaneContainer*
gitg_lanes_lane_container_construct_with_color (GType object_type,
                                                GgitOId* from,
                                                GgitOId* to,
                                                GitgColor* color)
{
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_;
	GgitOId* _tmp1_;
	GitgLane* _tmp2_;
	self = (GitgLanesLaneContainer*) g_type_create_instance (object_type);
	_tmp0_ = __vala_GgitOId_copy0 (from);
	__vala_GgitOId_free0 (self->from);
	self->from = _tmp0_;
	_tmp1_ = __vala_GgitOId_copy0 (to);
	__vala_GgitOId_free0 (self->to);
	self->to = _tmp1_;
	_tmp2_ = gitg_lane_new_with_color (color);
	_g_object_unref0 (self->lane);
	self->lane = _tmp2_;
	self->inactive = 0;
	return self;
}

static GitgLanesLaneContainer*
gitg_lanes_lane_container_new_with_color (GgitOId* from,
                                          GgitOId* to,
                                          GitgColor* color)
{
	return gitg_lanes_lane_container_construct_with_color (GITG_LANES_TYPE_LANE_CONTAINER, from, to, color);
}

static GitgLanesLaneContainer*
gitg_lanes_lane_container_construct (GType object_type,
                                     GgitOId* from,
                                     GgitOId* to)
{
	GitgLanesLaneContainer* self = NULL;
	self = (GitgLanesLaneContainer*) gitg_lanes_lane_container_construct_with_color (object_type, from, to, NULL);
	return self;
}

static GitgLanesLaneContainer*
gitg_lanes_lane_container_new (GgitOId* from,
                               GgitOId* to)
{
	return gitg_lanes_lane_container_construct (GITG_LANES_TYPE_LANE_CONTAINER, from, to);
}

static void
gitg_lanes_lane_container_next (GitgLanesLaneContainer* self,
                                gint index)
{
	gboolean hidden = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GitgLane* _tmp2_;
	GitgLane* _tmp3_;
	GitgLane* _tmp4_;
	GitgLane* _tmp5_;
	gboolean _tmp7_ = FALSE;
	GgitOId* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_lanes_lane_container_get_is_hidden (self);
	_tmp1_ = _tmp0_;
	hidden = _tmp1_;
	_tmp2_ = self->lane;
	_tmp3_ = gitg_lane_copy (_tmp2_);
	_g_object_unref0 (self->lane);
	self->lane = _tmp3_;
	_tmp4_ = self->lane;
	_tmp4_->tag = GITG_LANE_TAG_NONE;
	_tmp5_ = self->lane;
	(_tmp5_->from == NULL) ? NULL : (_tmp5_->from = (g_slist_free (_tmp5_->from), NULL));
	_tmp5_->from = NULL;
	if (!hidden) {
		GitgLane* _tmp6_;
		_tmp6_ = self->lane;
		_tmp6_->from = g_slist_prepend (_tmp6_->from, (gpointer) ((gintptr) index));
	}
	gitg_lanes_lane_container_set_is_hidden (self, hidden);
	_tmp8_ = self->to;
	if (_tmp8_ != NULL) {
		_tmp7_ = self->inactive >= 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gint _tmp9_;
		self->inactive = self->inactive + 1;
		_tmp9_ = self->inactive;
	}
}

static gboolean
gitg_lanes_lane_container_get_is_hidden (GitgLanesLaneContainer* self)
{
	gboolean result;
	GitgLane* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->lane;
	result = (_tmp0_->tag & GITG_LANE_TAG_HIDDEN) != 0;
	return result;
}

static void
gitg_lanes_lane_container_set_is_hidden (GitgLanesLaneContainer* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GitgLane* _tmp0_;
		GitgLane* _tmp1_;
		_tmp0_ = self->lane;
		_tmp1_ = self->lane;
		_tmp1_->tag = _tmp1_->tag | GITG_LANE_TAG_HIDDEN;
	} else {
		GitgLane* _tmp2_;
		GitgLane* _tmp3_;
		_tmp2_ = self->lane;
		_tmp3_ = self->lane;
		_tmp3_->tag = _tmp3_->tag & (~GITG_LANE_TAG_HIDDEN);
	}
}

static void
gitg_lanes_value_lane_container_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_lanes_value_lane_container_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_lanes_lane_container_unref (value->data[0].v_pointer);
	}
}

static void
gitg_lanes_value_lane_container_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_lanes_lane_container_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_lanes_value_lane_container_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_lanes_value_lane_container_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgLanesLaneContainer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_lanes_lane_container_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_lanes_value_lane_container_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	GitgLanesLaneContainer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_lanes_lane_container_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gitg_lanes_param_spec_lane_container (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	GitgLanesParamSpecLaneContainer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gitg_lanes_value_get_lane_container (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
	return value->data[0].v_pointer;
}

static void
gitg_lanes_value_set_lane_container (GValue* value,
                                     gpointer v_object)
{
	GitgLanesLaneContainer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_lanes_lane_container_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_lanes_lane_container_unref (old);
	}
}

static void
gitg_lanes_value_take_lane_container (GValue* value,
                                      gpointer v_object)
{
	GitgLanesLaneContainer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_lanes_lane_container_unref (old);
	}
}

static void
gitg_lanes_lane_container_class_init (GitgLanesLaneContainerClass * klass,
                                      gpointer klass_data)
{
	gitg_lanes_lane_container_parent_class = g_type_class_peek_parent (klass);
	((GitgLanesLaneContainerClass *) klass)->finalize = gitg_lanes_lane_container_finalize;
}

static void
gitg_lanes_lane_container_instance_init (GitgLanesLaneContainer * self,
                                         gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_lanes_lane_container_finalize (GitgLanesLaneContainer * obj)
{
	GitgLanesLaneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->lane);
	__vala_GgitOId_free0 (self->from);
	__vala_GgitOId_free0 (self->to);
}

 G_GNUC_NO_INLINE static GType
gitg_lanes_lane_container_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_lanes_value_lane_container_init, gitg_lanes_value_lane_container_free_value, gitg_lanes_value_lane_container_copy_value, gitg_lanes_value_lane_container_peek_pointer, "p", gitg_lanes_value_lane_container_collect_value, "p", gitg_lanes_value_lane_container_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgLanesLaneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_lane_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanesLaneContainer), 0, (GInstanceInitFunc) gitg_lanes_lane_container_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_lanes_lane_container_type_id;
	gitg_lanes_lane_container_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgLanesLaneContainer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_lanes_lane_container_type_id;
}

static GType
gitg_lanes_lane_container_get_type (void)
{
	static gsize gitg_lanes_lane_container_type_id__once = 0;
	if (g_once_init_enter (&gitg_lanes_lane_container_type_id__once)) {
		GType gitg_lanes_lane_container_type_id;
		gitg_lanes_lane_container_type_id = gitg_lanes_lane_container_get_type_once ();
		g_once_init_leave (&gitg_lanes_lane_container_type_id__once, gitg_lanes_lane_container_type_id);
	}
	return gitg_lanes_lane_container_type_id__once;
}

static gpointer
gitg_lanes_lane_container_ref (gpointer instance)
{
	GitgLanesLaneContainer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gitg_lanes_lane_container_unref (gpointer instance)
{
	GitgLanesLaneContainer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_LANES_LANE_CONTAINER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GitgLanesCollapsedLane*
gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container)
{
	GitgLanesCollapsedLane* self;
	GitgLane* _tmp0_;
	GitgColor* _tmp1_;
	GitgColor* _tmp2_;
	GgitOId* _tmp3_;
	GgitOId* _tmp4_;
	GgitOId* _tmp5_;
	GgitOId* _tmp6_;
	g_return_val_if_fail (container != NULL, NULL);
	self = g_slice_new0 (GitgLanesCollapsedLane);
	gitg_lanes_collapsed_lane_instance_init (self);
	_tmp0_ = container->lane;
	_tmp1_ = _tmp0_->color;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->color);
	self->color = _tmp2_;
	_tmp3_ = container->from;
	_tmp4_ = __vala_GgitOId_copy0 (_tmp3_);
	__vala_GgitOId_free0 (self->from);
	self->from = _tmp4_;
	_tmp5_ = container->to;
	_tmp6_ = __vala_GgitOId_copy0 (_tmp5_);
	__vala_GgitOId_free0 (self->to);
	self->to = _tmp6_;
	return self;
}

static void
gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self)
{
}

static void
gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane * self)
{
	_g_object_unref0 (self->color);
	__vala_GgitOId_free0 (self->from);
	__vala_GgitOId_free0 (self->to);
	g_slice_free (GitgLanesCollapsedLane, self);
}

static void
gitg_lanes_class_init (GitgLanesClass * klass,
                       gpointer klass_data)
{
	gitg_lanes_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgLanes_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_lanes_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_lanes_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_lanes_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_MAX_PROPERTY, gitg_lanes_properties[GITG_LANES_INACTIVE_MAX_PROPERTY] = g_param_spec_int ("inactive-max", "inactive-max", "inactive-max", G_MININT, G_MAXINT, 30, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_COLLAPSE_PROPERTY, gitg_lanes_properties[GITG_LANES_INACTIVE_COLLAPSE_PROPERTY] = g_param_spec_int ("inactive-collapse", "inactive-collapse", "inactive-collapse", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_GAP_PROPERTY, gitg_lanes_properties[GITG_LANES_INACTIVE_GAP_PROPERTY] = g_param_spec_int ("inactive-gap", "inactive-gap", "inactive-gap", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_ENABLED_PROPERTY, gitg_lanes_properties[GITG_LANES_INACTIVE_ENABLED_PROPERTY] = g_param_spec_boolean ("inactive-enabled", "inactive-enabled", "inactive-enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_MISS_COMMITS_PROPERTY, gitg_lanes_properties[GITG_LANES_MISS_COMMITS_PROPERTY] = g_param_spec_object ("miss-commits", "miss-commits", "miss-commits", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gitg_lanes_instance_init (GitgLanes * self,
                          gpointer klass)
{
	self->priv = gitg_lanes_get_instance_private (self);
	self->priv->_inactive_max = 30;
	self->priv->_inactive_collapse = 10;
	self->priv->_inactive_gap = 10;
	self->priv->_inactive_enabled = TRUE;
}

static void
gitg_lanes_finalize (GObject * obj)
{
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LANES, GitgLanes);
	_g_object_unref0 (self->priv->_miss_commits);
	(self->priv->d_previous == NULL) ? NULL : (self->priv->d_previous = (g_slist_free (self->priv->d_previous), NULL));
	_g_object_unref0 (self->priv->d_lanes);
	_g_hash_table_unref0 (self->priv->d_collapsed);
	_g_object_unref0 (self->priv->d_roots);
	G_OBJECT_CLASS (gitg_lanes_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_lanes_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanes), 0, (GInstanceInitFunc) gitg_lanes_instance_init, NULL };
	GType gitg_lanes_type_id;
	gitg_lanes_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgLanes", &g_define_type_info, 0);
	GitgLanes_private_offset = g_type_add_instance_private (gitg_lanes_type_id, sizeof (GitgLanesPrivate));
	return gitg_lanes_type_id;
}

GType
gitg_lanes_get_type (void)
{
	static gsize gitg_lanes_type_id__once = 0;
	if (g_once_init_enter (&gitg_lanes_type_id__once)) {
		GType gitg_lanes_type_id;
		gitg_lanes_type_id = gitg_lanes_get_type_once ();
		g_once_init_leave (&gitg_lanes_type_id__once, gitg_lanes_type_id);
	}
	return gitg_lanes_type_id__once;
}

static void
_vala_gitg_lanes_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
	switch (property_id) {
		case GITG_LANES_INACTIVE_MAX_PROPERTY:
		g_value_set_int (value, gitg_lanes_get_inactive_max (self));
		break;
		case GITG_LANES_INACTIVE_COLLAPSE_PROPERTY:
		g_value_set_int (value, gitg_lanes_get_inactive_collapse (self));
		break;
		case GITG_LANES_INACTIVE_GAP_PROPERTY:
		g_value_set_int (value, gitg_lanes_get_inactive_gap (self));
		break;
		case GITG_LANES_INACTIVE_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_lanes_get_inactive_enabled (self));
		break;
		case GITG_LANES_MISS_COMMITS_PROPERTY:
		g_value_set_object (value, gitg_lanes_get_miss_commits (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_lanes_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
	switch (property_id) {
		case GITG_LANES_INACTIVE_MAX_PROPERTY:
		gitg_lanes_set_inactive_max (self, g_value_get_int (value));
		break;
		case GITG_LANES_INACTIVE_COLLAPSE_PROPERTY:
		gitg_lanes_set_inactive_collapse (self, g_value_get_int (value));
		break;
		case GITG_LANES_INACTIVE_GAP_PROPERTY:
		gitg_lanes_set_inactive_gap (self, g_value_get_int (value));
		break;
		case GITG_LANES_INACTIVE_ENABLED_PROPERTY:
		gitg_lanes_set_inactive_enabled (self, g_value_get_boolean (value));
		break;
		case GITG_LANES_MISS_COMMITS_PROPERTY:
		gitg_lanes_set_miss_commits (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

