{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Cairo.Structs.Glyph
    ( 

-- * Exported types
    Glyph(..)                               ,
    newZeroGlyph                            ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphMethod                      ,
#endif



 -- * Properties


-- ** index #attr:index#
-- | /No description available in the introspection data./

    getGlyphIndex                           ,
#if defined(ENABLE_OVERLOADING)
    glyph_index                             ,
#endif
    setGlyphIndex                           ,


-- ** x #attr:x#
-- | /No description available in the introspection data./

    getGlyphX                               ,
#if defined(ENABLE_OVERLOADING)
    glyph_x                                 ,
#endif
    setGlyphX                               ,


-- ** y #attr:y#
-- | /No description available in the introspection data./

    getGlyphY                               ,
#if defined(ENABLE_OVERLOADING)
    glyph_y                                 ,
#endif
    setGlyphY                               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Glyph = Glyph (SP.ManagedPtr Glyph)
    deriving (Eq)

instance SP.ManagedPtrNewtype Glyph where
    toManagedPtr (Glyph p) = p

foreign import ccall "cairo_gobject_glyph_get_type" c_cairo_gobject_glyph_get_type :: 
    IO GType

type instance O.ParentTypes Glyph = '[]
instance O.HasParentTypes Glyph

instance B.Types.TypedObject Glyph where
    glibType = c_cairo_gobject_glyph_get_type

instance B.Types.GBoxed Glyph

-- | Convert t'Glyph' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Glyph) where
    gvalueGType_ = c_cairo_gobject_glyph_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Glyph)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Glyph)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Glyph ptr
        else return P.Nothing
        
    

-- | Construct a t'Glyph' struct initialized to zero.
newZeroGlyph :: MonadIO m => m Glyph
newZeroGlyph = liftIO $ callocBoxedBytes 24 >>= wrapBoxed Glyph

instance tag ~ 'AttrSet => Constructible Glyph tag where
    new _ attrs = do
        o <- newZeroGlyph
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyph #index
-- @
getGlyphIndex :: MonadIO m => Glyph -> m FCT.CULong
getGlyphIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CULong
    return val

-- | Set the value of the “@index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyph [ #index 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphIndex :: MonadIO m => Glyph -> FCT.CULong -> m ()
setGlyphIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CULong)

#if defined(ENABLE_OVERLOADING)
data GlyphIndexFieldInfo
instance AttrInfo GlyphIndexFieldInfo where
    type AttrBaseTypeConstraint GlyphIndexFieldInfo = (~) Glyph
    type AttrAllowedOps GlyphIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphIndexFieldInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint GlyphIndexFieldInfo = (~)FCT.CULong
    type AttrTransferType GlyphIndexFieldInfo = FCT.CULong
    type AttrGetType GlyphIndexFieldInfo = FCT.CULong
    type AttrLabel GlyphIndexFieldInfo = "index"
    type AttrOrigin GlyphIndexFieldInfo = Glyph
    attrGet = getGlyphIndex
    attrSet = setGlyphIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Glyph.index"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Glyph.html#g:attr:index"
        })

glyph_index :: AttrLabelProxy "index"
glyph_index = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyph #x
-- @
getGlyphX :: MonadIO m => Glyph -> m Double
getGlyphX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyph [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphX :: MonadIO m => Glyph -> Double -> m ()
setGlyphX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 8) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data GlyphXFieldInfo
instance AttrInfo GlyphXFieldInfo where
    type AttrBaseTypeConstraint GlyphXFieldInfo = (~) Glyph
    type AttrAllowedOps GlyphXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphXFieldInfo = (~) Double
    type AttrTransferTypeConstraint GlyphXFieldInfo = (~)Double
    type AttrTransferType GlyphXFieldInfo = Double
    type AttrGetType GlyphXFieldInfo = Double
    type AttrLabel GlyphXFieldInfo = "x"
    type AttrOrigin GlyphXFieldInfo = Glyph
    attrGet = getGlyphX
    attrSet = setGlyphX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Glyph.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Glyph.html#g:attr:x"
        })

glyph_x :: AttrLabelProxy "x"
glyph_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyph #y
-- @
getGlyphY :: MonadIO m => Glyph -> m Double
getGlyphY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyph [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphY :: MonadIO m => Glyph -> Double -> m ()
setGlyphY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data GlyphYFieldInfo
instance AttrInfo GlyphYFieldInfo where
    type AttrBaseTypeConstraint GlyphYFieldInfo = (~) Glyph
    type AttrAllowedOps GlyphYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphYFieldInfo = (~) Double
    type AttrTransferTypeConstraint GlyphYFieldInfo = (~)Double
    type AttrTransferType GlyphYFieldInfo = Double
    type AttrGetType GlyphYFieldInfo = Double
    type AttrLabel GlyphYFieldInfo = "y"
    type AttrOrigin GlyphYFieldInfo = Glyph
    attrGet = getGlyphY
    attrSet = setGlyphY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Glyph.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Glyph.html#g:attr:y"
        })

glyph_y :: AttrLabelProxy "y"
glyph_y = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Glyph
type instance O.AttributeList Glyph = GlyphAttributeList
type GlyphAttributeList = ('[ '("index", GlyphIndexFieldInfo), '("x", GlyphXFieldInfo), '("y", GlyphYFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphMethod t Glyph, O.OverloadedMethod info Glyph p) => OL.IsLabel t (Glyph -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphMethod t Glyph, O.OverloadedMethod info Glyph p, R.HasField t Glyph p) => R.HasField t Glyph p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphMethod t Glyph, O.OverloadedMethodInfo info Glyph) => OL.IsLabel t (O.MethodProxy info Glyph) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


