

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.DbusmenuGtk3.Functions
    ( 

 -- * Methods


-- ** gtkParseGetCachedItem #method:gtkParseGetCachedItem#

    gtkParseGetCachedItem                   ,


-- ** gtkParseMenuStructure #method:gtkParseMenuStructure#

    gtkParseMenuStructure                   ,


-- ** menuitemPropertyGetImage #method:menuitemPropertyGetImage#

    menuitemPropertyGetImage                ,


-- ** menuitemPropertyGetShortcut #method:menuitemPropertyGetShortcut#

    menuitemPropertyGetShortcut             ,


-- ** menuitemPropertySetImage #method:menuitemPropertySetImage#

    menuitemPropertySetImage                ,


-- ** menuitemPropertySetShortcut #method:menuitemPropertySetShortcut#

    menuitemPropertySetShortcut             ,


-- ** menuitemPropertySetShortcutMenuitem #method:menuitemPropertySetShortcutMenuitem#

    menuitemPropertySetShortcutMenuitem     ,


-- ** menuitemPropertySetShortcutString #method:menuitemPropertySetShortcutString#

    menuitemPropertySetShortcutString       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gtk.Objects.MenuItem as Gtk.MenuItem
import qualified GI.Gtk.Objects.Widget as Gtk.Widget

#else
import qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gtk.Objects.MenuItem as Gtk.MenuItem
import qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- function menuitem_property_set_shortcut_string
-- Args: [ Arg
--           { argCName = "menuitem"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the shortcut on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shortcut"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "String describing the shortcut"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_shortcut_string" dbusmenu_menuitem_property_set_shortcut_string :: 
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- menuitem : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- shortcut : TBasicType TUTF8
    IO CInt

-- | This function takes a GTK shortcut string as defined in
-- @/gtk_accelerator_parse/@ and turns that into the information
-- required to send it over DBusmenu.
menuitemPropertySetShortcutString ::
    (B.CallStack.HasCallStack, MonadIO m, Dbusmenu.Menuitem.IsMenuitem a) =>
    a
    -- ^ /@menuitem@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the shortcut on
    -> T.Text
    -- ^ /@shortcut@/: String describing the shortcut
    -> m Bool
    -- ^ __Returns:__ Whether it was successful at setting the property.
menuitemPropertySetShortcutString menuitem shortcut = liftIO $ do
    menuitem' <- unsafeManagedPtrCastPtr menuitem
    shortcut' <- textToCString shortcut
    result <- dbusmenu_menuitem_property_set_shortcut_string menuitem' shortcut'
    let result' = (/= 0) result
    touchManagedPtr menuitem
    freeMem shortcut'
    return result'


-- function menuitem_property_set_shortcut_menuitem
-- Args: [ Arg
--           { argCName = "menuitem"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the shortcut on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gmi"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A menu item to steal the shortcut off of"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_shortcut_menuitem" dbusmenu_menuitem_property_set_shortcut_menuitem :: 
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- menuitem : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Gtk.MenuItem.MenuItem ->            -- gmi : TInterface (Name {namespace = "Gtk", name = "MenuItem"})
    IO CInt

-- | Takes the shortcut that is installed on a menu item and calls
-- @/dbusmenu_menuitem_property_set_shortcut/@ with it.  It also sets
-- up listeners to watch it change.
menuitemPropertySetShortcutMenuitem ::
    (B.CallStack.HasCallStack, MonadIO m, Dbusmenu.Menuitem.IsMenuitem a, Gtk.MenuItem.IsMenuItem b) =>
    a
    -- ^ /@menuitem@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the shortcut on
    -> b
    -- ^ /@gmi@/: A menu item to steal the shortcut off of
    -> m Bool
    -- ^ __Returns:__ Whether it was successful at setting the property.
menuitemPropertySetShortcutMenuitem menuitem gmi = liftIO $ do
    menuitem' <- unsafeManagedPtrCastPtr menuitem
    gmi' <- unsafeManagedPtrCastPtr gmi
    result <- dbusmenu_menuitem_property_set_shortcut_menuitem menuitem' gmi'
    let result' = (/= 0) result
    touchManagedPtr menuitem
    touchManagedPtr gmi
    return result'


-- function menuitem_property_set_shortcut
-- Args: [ Arg
--           { argCName = "menuitem"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the shortcut on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The keycode of the key to send"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifier"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A bitmask of modifiers used to activate the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_shortcut" dbusmenu_menuitem_property_set_shortcut :: 
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- menuitem : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Word32 ->                               -- key : TBasicType TUInt
    CUInt ->                                -- modifier : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Takes the modifer described by /@key@/ and /@modifier@/ and places that into
-- the format sending across Dbus for shortcuts.
menuitemPropertySetShortcut ::
    (B.CallStack.HasCallStack, MonadIO m, Dbusmenu.Menuitem.IsMenuitem a) =>
    a
    -- ^ /@menuitem@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the shortcut on
    -> Word32
    -- ^ /@key@/: The keycode of the key to send
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifier@/: A bitmask of modifiers used to activate the item
    -> m Bool
    -- ^ __Returns:__ Whether it was successful at setting the property.
menuitemPropertySetShortcut menuitem key modifier = liftIO $ do
    menuitem' <- unsafeManagedPtrCastPtr menuitem
    let modifier' = gflagsToWord modifier
    result <- dbusmenu_menuitem_property_set_shortcut menuitem' key modifier'
    let result' = (/= 0) result
    touchManagedPtr menuitem
    return result'


-- function menuitem_property_set_image
-- Args: [ Arg
--           { argCName = "menuitem"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the property to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The image to place on the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_image" dbusmenu_menuitem_property_set_image :: 
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- menuitem : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- data : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO CInt

-- | This function takes the pixbuf that is stored in /@data@/ and
-- turns it into a base64 encoded PNG so that it can be placed
-- onto a standard t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property.
menuitemPropertySetImage ::
    (B.CallStack.HasCallStack, MonadIO m, Dbusmenu.Menuitem.IsMenuitem a, GdkPixbuf.Pixbuf.IsPixbuf b) =>
    a
    -- ^ /@menuitem@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the property on.
    -> T.Text
    -- ^ /@property@/: Name of the property to set.
    -> b
    -- ^ /@data@/: The image to place on the property.
    -> m Bool
    -- ^ __Returns:__ Whether the function was able to set the property
    -- 	or not.
menuitemPropertySetImage menuitem property data_ = liftIO $ do
    menuitem' <- unsafeManagedPtrCastPtr menuitem
    property' <- textToCString property
    data_' <- unsafeManagedPtrCastPtr data_
    result <- dbusmenu_menuitem_property_set_image menuitem' property' data_'
    let result' = (/= 0) result
    touchManagedPtr menuitem
    touchManagedPtr data_
    freeMem property'
    return result'


-- function menuitem_property_get_shortcut
-- Args: [ Arg
--           { argCName = "menuitem"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to get the shortcut off"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Location to put the key value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "modifier"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Location to put the modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get_shortcut" dbusmenu_menuitem_property_get_shortcut :: 
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- menuitem : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Word32 ->                           -- key : TBasicType TUInt
    Ptr CUInt ->                            -- modifier : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO ()

-- | This function gets a GTK shortcut as a key and a mask
-- for use to set the accelerators.
menuitemPropertyGetShortcut ::
    (B.CallStack.HasCallStack, MonadIO m, Dbusmenu.Menuitem.IsMenuitem a) =>
    a
    -- ^ /@menuitem@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to get the shortcut off
    -> m ((Word32, [Gdk.Flags.ModifierType]))
menuitemPropertyGetShortcut menuitem = liftIO $ do
    menuitem' <- unsafeManagedPtrCastPtr menuitem
    key <- allocMem :: IO (Ptr Word32)
    modifier <- allocMem :: IO (Ptr CUInt)
    dbusmenu_menuitem_property_get_shortcut menuitem' key modifier
    key' <- peek key
    modifier' <- peek modifier
    let modifier'' = wordToGFlags modifier'
    touchManagedPtr menuitem
    freeMem key
    freeMem modifier
    return (key', modifier'')


-- function menuitem_property_get_image
-- Args: [ Arg
--           { argCName = "menuitem"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the property to look for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get_image" dbusmenu_menuitem_property_get_image :: 
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- menuitem : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

-- | This function looks on the menu item for a property by the
-- name of /@property@/.  If one exists it tries to turn it into
-- a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'.  It assumes that the property is a base64 encoded
-- PNG file like the one created by @/dbusmenu_menuite_property_set_image/@.
menuitemPropertyGetImage ::
    (B.CallStack.HasCallStack, MonadIO m, Dbusmenu.Menuitem.IsMenuitem a) =>
    a
    -- ^ /@menuitem@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on
    -> T.Text
    -- ^ /@property@/: The name of the property to look for.
    -> m GdkPixbuf.Pixbuf.Pixbuf
    -- ^ __Returns:__ A pixbuf or @/NULL/@ to signal error.
menuitemPropertyGetImage menuitem property = liftIO $ do
    menuitem' <- unsafeManagedPtrCastPtr menuitem
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_get_image menuitem' property'
    checkUnexpectedReturnNULL "menuitemPropertyGetImage" result
    result' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result
    touchManagedPtr menuitem
    freeMem property'
    return result'


-- function gtk_parse_menu_structure
-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GtkMenuItem or #GtkMenuShell to turn into a #DbusmenuMenuitem"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtk_parse_menu_structure" dbusmenu_gtk_parse_menu_structure :: 
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Dbusmenu.Menuitem.Menuitem)

-- | Goes through the GTK structures and turns them into the appropraite
-- Dbusmenu structures along with setting up all the relationships
-- between the objects.  It also stores the dbusmenu items as a cache
-- on the GTK items so that they\'ll be reused if necissary.
gtkParseMenuStructure ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    a
    -- ^ /@widget@/: A t'GI.Gtk.Objects.MenuItem.MenuItem' or t'GI.Gtk.Objects.MenuShell.MenuShell' to turn into a t'GI.Dbusmenu.Objects.Menuitem.Menuitem'
    -> m Dbusmenu.Menuitem.Menuitem
    -- ^ __Returns:__ A dbusmenu item representing the menu structure
gtkParseMenuStructure widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    result <- dbusmenu_gtk_parse_menu_structure widget'
    checkUnexpectedReturnNULL "gtkParseMenuStructure" result
    result' <- (wrapObject Dbusmenu.Menuitem.Menuitem) result
    touchManagedPtr widget
    return result'


-- function gtk_parse_get_cached_item
-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GtkMenuItem that may have a cached #DbusmenuMenuitem from the parser"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_gtk_parse_get_cached_item" dbusmenu_gtk_parse_get_cached_item :: 
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Dbusmenu.Menuitem.Menuitem)

-- | The Dbusmenu GTK parser adds cached items on the various
-- menu items throughout the tree.  Sometimes it can be useful
-- to get that cached item to use directly.  This function
-- will retrieve it for you.
gtkParseGetCachedItem ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    a
    -- ^ /@widget@/: A t'GI.Gtk.Objects.MenuItem.MenuItem' that may have a cached t'GI.Dbusmenu.Objects.Menuitem.Menuitem' from the parser
    -> m Dbusmenu.Menuitem.Menuitem
    -- ^ __Returns:__ A pointer to the cached item
    -- or NULL if it isn\'t there.
gtkParseGetCachedItem widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    result <- dbusmenu_gtk_parse_get_cached_item widget'
    checkUnexpectedReturnNULL "gtkParseGetCachedItem" result
    result' <- (newObject Dbusmenu.Menuitem.Menuitem) result
    touchManagedPtr widget
    return result'



