{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describes a property change on a window.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventProperty
    ( 

-- * Exported types
    EventProperty(..)                       ,
    newZeroEventProperty                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventPropertyMethod              ,
#endif



 -- * Properties


-- ** atom #attr:atom#
-- | the property that was changed.

#if defined(ENABLE_OVERLOADING)
    eventProperty_atom                      ,
#endif
    getEventPropertyAtom                    ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventProperty_sendEvent                 ,
#endif
    getEventPropertySendEvent               ,
    setEventPropertySendEvent               ,


-- ** state #attr:state#
-- | whether the property was changed
--   ('GI.Gdk.Enums.PropertyStateNewValue') or deleted ('GI.Gdk.Enums.PropertyStateDelete').

#if defined(ENABLE_OVERLOADING)
    eventProperty_state                     ,
#endif
    getEventPropertyState                   ,
    setEventPropertyState                   ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventProperty_time                      ,
#endif
    getEventPropertyTime                    ,
    setEventPropertyTime                    ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypePropertyNotify').

#if defined(ENABLE_OVERLOADING)
    eventProperty_type                      ,
#endif
    getEventPropertyType                    ,
    setEventPropertyType                    ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventPropertyWindow                ,
#if defined(ENABLE_OVERLOADING)
    eventProperty_window                    ,
#endif
    getEventPropertyWindow                  ,
    setEventPropertyWindow                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom

#endif

-- | Memory-managed wrapper type.
newtype EventProperty = EventProperty (SP.ManagedPtr EventProperty)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventProperty where
    toManagedPtr (EventProperty p) = p

instance BoxedPtr EventProperty where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr EventProperty)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventProperty where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'EventProperty' struct initialized to zero.
newZeroEventProperty :: MonadIO m => m EventProperty
newZeroEventProperty = liftIO $ boxedPtrCalloc >>= wrapPtr EventProperty

instance tag ~ 'AttrSet => Constructible EventProperty tag where
    new _ attrs = do
        o <- newZeroEventProperty
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProperty #type
-- @
getEventPropertyType :: MonadIO m => EventProperty -> m Gdk.Enums.EventType
getEventPropertyType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProperty [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPropertyType :: MonadIO m => EventProperty -> Gdk.Enums.EventType -> m ()
setEventPropertyType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventPropertyTypeFieldInfo
instance AttrInfo EventPropertyTypeFieldInfo where
    type AttrBaseTypeConstraint EventPropertyTypeFieldInfo = (~) EventProperty
    type AttrAllowedOps EventPropertyTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPropertyTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventPropertyTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventPropertyTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventPropertyTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventPropertyTypeFieldInfo = "type"
    type AttrOrigin EventPropertyTypeFieldInfo = EventProperty
    attrGet = getEventPropertyType
    attrSet = setEventPropertyType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProperty.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventProperty.html#g:attr:type"
        })

eventProperty_type :: AttrLabelProxy "type"
eventProperty_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProperty #window
-- @
getEventPropertyWindow :: MonadIO m => EventProperty -> m (Maybe Gdk.Window.Window)
getEventPropertyWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProperty [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPropertyWindow :: MonadIO m => EventProperty -> Ptr Gdk.Window.Window -> m ()
setEventPropertyWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventPropertyWindow :: MonadIO m => EventProperty -> m ()
clearEventPropertyWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventPropertyWindowFieldInfo
instance AttrInfo EventPropertyWindowFieldInfo where
    type AttrBaseTypeConstraint EventPropertyWindowFieldInfo = (~) EventProperty
    type AttrAllowedOps EventPropertyWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventPropertyWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventPropertyWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventPropertyWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventPropertyWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventPropertyWindowFieldInfo = "window"
    type AttrOrigin EventPropertyWindowFieldInfo = EventProperty
    attrGet = getEventPropertyWindow
    attrSet = setEventPropertyWindow
    attrConstruct = undefined
    attrClear = clearEventPropertyWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProperty.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventProperty.html#g:attr:window"
        })

eventProperty_window :: AttrLabelProxy "window"
eventProperty_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProperty #sendEvent
-- @
getEventPropertySendEvent :: MonadIO m => EventProperty -> m Int8
getEventPropertySendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProperty [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPropertySendEvent :: MonadIO m => EventProperty -> Int8 -> m ()
setEventPropertySendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventPropertySendEventFieldInfo
instance AttrInfo EventPropertySendEventFieldInfo where
    type AttrBaseTypeConstraint EventPropertySendEventFieldInfo = (~) EventProperty
    type AttrAllowedOps EventPropertySendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPropertySendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventPropertySendEventFieldInfo = (~)Int8
    type AttrTransferType EventPropertySendEventFieldInfo = Int8
    type AttrGetType EventPropertySendEventFieldInfo = Int8
    type AttrLabel EventPropertySendEventFieldInfo = "send_event"
    type AttrOrigin EventPropertySendEventFieldInfo = EventProperty
    attrGet = getEventPropertySendEvent
    attrSet = setEventPropertySendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProperty.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventProperty.html#g:attr:sendEvent"
        })

eventProperty_sendEvent :: AttrLabelProxy "sendEvent"
eventProperty_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@atom@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProperty #atom
-- @
getEventPropertyAtom :: MonadIO m => EventProperty -> m Gdk.Atom.Atom
getEventPropertyAtom s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 24 :: (Ptr Gdk.Atom.Atom)
    val' <- (newPtr Gdk.Atom.Atom) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventPropertyAtomFieldInfo
instance AttrInfo EventPropertyAtomFieldInfo where
    type AttrBaseTypeConstraint EventPropertyAtomFieldInfo = (~) EventProperty
    type AttrAllowedOps EventPropertyAtomFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventPropertyAtomFieldInfo = (~) (Ptr Gdk.Atom.Atom)
    type AttrTransferTypeConstraint EventPropertyAtomFieldInfo = (~)(Ptr Gdk.Atom.Atom)
    type AttrTransferType EventPropertyAtomFieldInfo = (Ptr Gdk.Atom.Atom)
    type AttrGetType EventPropertyAtomFieldInfo = Gdk.Atom.Atom
    type AttrLabel EventPropertyAtomFieldInfo = "atom"
    type AttrOrigin EventPropertyAtomFieldInfo = EventProperty
    attrGet = getEventPropertyAtom
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProperty.atom"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventProperty.html#g:attr:atom"
        })

eventProperty_atom :: AttrLabelProxy "atom"
eventProperty_atom = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProperty #time
-- @
getEventPropertyTime :: MonadIO m => EventProperty -> m Word32
getEventPropertyTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProperty [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPropertyTime :: MonadIO m => EventProperty -> Word32 -> m ()
setEventPropertyTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPropertyTimeFieldInfo
instance AttrInfo EventPropertyTimeFieldInfo where
    type AttrBaseTypeConstraint EventPropertyTimeFieldInfo = (~) EventProperty
    type AttrAllowedOps EventPropertyTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPropertyTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPropertyTimeFieldInfo = (~)Word32
    type AttrTransferType EventPropertyTimeFieldInfo = Word32
    type AttrGetType EventPropertyTimeFieldInfo = Word32
    type AttrLabel EventPropertyTimeFieldInfo = "time"
    type AttrOrigin EventPropertyTimeFieldInfo = EventProperty
    attrGet = getEventPropertyTime
    attrSet = setEventPropertyTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProperty.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventProperty.html#g:attr:time"
        })

eventProperty_time :: AttrLabelProxy "time"
eventProperty_time = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProperty #state
-- @
getEventPropertyState :: MonadIO m => EventProperty -> m Gdk.Enums.PropertyState
getEventPropertyState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 36) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProperty [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPropertyState :: MonadIO m => EventProperty -> Gdk.Enums.PropertyState -> m ()
setEventPropertyState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 36) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventPropertyStateFieldInfo
instance AttrInfo EventPropertyStateFieldInfo where
    type AttrBaseTypeConstraint EventPropertyStateFieldInfo = (~) EventProperty
    type AttrAllowedOps EventPropertyStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPropertyStateFieldInfo = (~) Gdk.Enums.PropertyState
    type AttrTransferTypeConstraint EventPropertyStateFieldInfo = (~)Gdk.Enums.PropertyState
    type AttrTransferType EventPropertyStateFieldInfo = Gdk.Enums.PropertyState
    type AttrGetType EventPropertyStateFieldInfo = Gdk.Enums.PropertyState
    type AttrLabel EventPropertyStateFieldInfo = "state"
    type AttrOrigin EventPropertyStateFieldInfo = EventProperty
    attrGet = getEventPropertyState
    attrSet = setEventPropertyState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProperty.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventProperty.html#g:attr:state"
        })

eventProperty_state :: AttrLabelProxy "state"
eventProperty_state = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventProperty
type instance O.AttributeList EventProperty = EventPropertyAttributeList
type EventPropertyAttributeList = ('[ '("type", EventPropertyTypeFieldInfo), '("window", EventPropertyWindowFieldInfo), '("sendEvent", EventPropertySendEventFieldInfo), '("atom", EventPropertyAtomFieldInfo), '("time", EventPropertyTimeFieldInfo), '("state", EventPropertyStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventPropertyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventPropertyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventPropertyMethod t EventProperty, O.OverloadedMethod info EventProperty p) => OL.IsLabel t (EventProperty -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventPropertyMethod t EventProperty, O.OverloadedMethod info EventProperty p, R.HasField t EventProperty p) => R.HasField t EventProperty p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventPropertyMethod t EventProperty, O.OverloadedMethodInfo info EventProperty) => OL.IsLabel t (O.MethodProxy info EventProperty) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


