{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Cursor
    ( 

-- * Exported types
    X11Cursor(..)                           ,
    IsX11Cursor                             ,
    toX11Cursor                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.Gdk.Objects.Cursor#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.Gdk.Objects.Cursor#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCursorType]("GI.Gdk.Objects.Cursor#g:method:getCursorType"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Cursor#g:method:getDisplay"), [getImage]("GI.Gdk.Objects.Cursor#g:method:getImage"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gdk.Objects.Cursor#g:method:getSurface"), [getXcursor]("GI.GdkX11.Objects.X11Cursor#g:method:getXcursor"), [getXdisplay]("GI.GdkX11.Objects.X11Cursor#g:method:getXdisplay").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11CursorMethod                  ,
#endif

-- ** getXcursor #method:getXcursor#

#if defined(ENABLE_OVERLOADING)
    X11CursorGetXcursorMethodInfo           ,
#endif
    x11CursorGetXcursor                     ,


-- ** getXdisplay #method:getXdisplay#

#if defined(ENABLE_OVERLOADING)
    X11CursorGetXdisplayMethodInfo          ,
#endif
    x11CursorGetXdisplay                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Xlib.Structs.Display as Xlib.Display

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Xlib.Structs.Display as Xlib.Display

#endif

-- | Memory-managed wrapper type.
newtype X11Cursor = X11Cursor (SP.ManagedPtr X11Cursor)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Cursor where
    toManagedPtr (X11Cursor p) = p

foreign import ccall "gdk_x11_cursor_get_type"
    c_gdk_x11_cursor_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Cursor where
    glibType = c_gdk_x11_cursor_get_type

instance B.Types.GObject X11Cursor

-- | Type class for types which can be safely cast to t'X11Cursor', for instance with `toX11Cursor`.
class (SP.GObject o, O.IsDescendantOf X11Cursor o) => IsX11Cursor o
instance (SP.GObject o, O.IsDescendantOf X11Cursor o) => IsX11Cursor o

instance O.HasParentTypes X11Cursor
type instance O.ParentTypes X11Cursor = '[Gdk.Cursor.Cursor, GObject.Object.Object]

-- | Cast to t'X11Cursor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11Cursor :: (MIO.MonadIO m, IsX11Cursor o) => o -> m X11Cursor
toX11Cursor = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Cursor

-- | Convert t'X11Cursor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Cursor) where
    gvalueGType_ = c_gdk_x11_cursor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Cursor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Cursor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Cursor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11CursorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11CursorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11CursorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11CursorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11CursorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11CursorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11CursorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11CursorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11CursorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11CursorMethod "ref" o = Gdk.Cursor.CursorRefMethodInfo
    ResolveX11CursorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11CursorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11CursorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11CursorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11CursorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11CursorMethod "unref" o = Gdk.Cursor.CursorUnrefMethodInfo
    ResolveX11CursorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11CursorMethod "getCursorType" o = Gdk.Cursor.CursorGetCursorTypeMethodInfo
    ResolveX11CursorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11CursorMethod "getDisplay" o = Gdk.Cursor.CursorGetDisplayMethodInfo
    ResolveX11CursorMethod "getImage" o = Gdk.Cursor.CursorGetImageMethodInfo
    ResolveX11CursorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11CursorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11CursorMethod "getSurface" o = Gdk.Cursor.CursorGetSurfaceMethodInfo
    ResolveX11CursorMethod "getXcursor" o = X11CursorGetXcursorMethodInfo
    ResolveX11CursorMethod "getXdisplay" o = X11CursorGetXdisplayMethodInfo
    ResolveX11CursorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11CursorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11CursorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11CursorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11CursorMethod t X11Cursor, O.OverloadedMethod info X11Cursor p) => OL.IsLabel t (X11Cursor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11CursorMethod t X11Cursor, O.OverloadedMethod info X11Cursor p, R.HasField t X11Cursor p) => R.HasField t X11Cursor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11CursorMethod t X11Cursor, O.OverloadedMethodInfo info X11Cursor) => OL.IsLabel t (O.MethodProxy info X11Cursor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Cursor
type instance O.AttributeList X11Cursor = X11CursorAttributeList
type X11CursorAttributeList = ('[ '("cursorType", Gdk.Cursor.CursorCursorTypePropertyInfo), '("display", Gdk.Cursor.CursorDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Cursor = X11CursorSignalList
type X11CursorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Cursor::get_xcursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_cursor_get_xcursor" gdk_x11_cursor_get_xcursor :: 
    Ptr X11Cursor ->                        -- cursor : TInterface (Name {namespace = "GdkX11", name = "X11Cursor"})
    IO FCT.CULong

-- | Returns the X cursor belonging to a t'GI.Gdk.Objects.Cursor.Cursor'.
x11CursorGetXcursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Cursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'.
    -> m FCT.CULong
    -- ^ __Returns:__ an Xlib Cursor.
x11CursorGetXcursor cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_x11_cursor_get_xcursor cursor'
    touchManagedPtr cursor
    return result

#if defined(ENABLE_OVERLOADING)
data X11CursorGetXcursorMethodInfo
instance (signature ~ (m FCT.CULong), MonadIO m, IsX11Cursor a) => O.OverloadedMethod X11CursorGetXcursorMethodInfo a signature where
    overloadedMethod = x11CursorGetXcursor

instance O.OverloadedMethodInfo X11CursorGetXcursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Cursor.x11CursorGetXcursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Cursor.html#v:x11CursorGetXcursor"
        })


#endif

-- method X11Cursor::get_xdisplay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cursor"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "xlib" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_cursor_get_xdisplay" gdk_x11_cursor_get_xdisplay :: 
    Ptr X11Cursor ->                        -- cursor : TInterface (Name {namespace = "GdkX11", name = "X11Cursor"})
    IO (Ptr Xlib.Display.Display)

-- | Returns the display of a t'GI.Gdk.Objects.Cursor.Cursor'.
x11CursorGetXdisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Cursor a) =>
    a
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'.
    -> m Xlib.Display.Display
    -- ^ __Returns:__ an Xlib Display*.
x11CursorGetXdisplay cursor = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_x11_cursor_get_xdisplay cursor'
    checkUnexpectedReturnNULL "x11CursorGetXdisplay" result
    result' <- (newPtr Xlib.Display.Display) result
    touchManagedPtr cursor
    return result'

#if defined(ENABLE_OVERLOADING)
data X11CursorGetXdisplayMethodInfo
instance (signature ~ (m Xlib.Display.Display), MonadIO m, IsX11Cursor a) => O.OverloadedMethod X11CursorGetXdisplayMethodInfo a signature where
    overloadedMethod = x11CursorGetXdisplay

instance O.OverloadedMethodInfo X11CursorGetXdisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Cursor.x11CursorGetXdisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Cursor.html#v:x11CursorGetXdisplay"
        })


#endif


