{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A variant of @GtkClosureExpression@ using a C closure.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CClosureExpression
    ( 

-- * Exported types
    CClosureExpression(..)                  ,
    IsCClosureExpression                    ,
    toCClosureExpression                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bind]("GI.Gtk.Objects.Expression#g:method:bind"), [evaluate]("GI.Gtk.Objects.Expression#g:method:evaluate"), [isStatic]("GI.Gtk.Objects.Expression#g:method:isStatic"), [ref]("GI.Gtk.Objects.Expression#g:method:ref"), [unref]("GI.Gtk.Objects.Expression#g:method:unref"), [watch]("GI.Gtk.Objects.Expression#g:method:watch").
-- 
-- ==== Getters
-- [getValueType]("GI.Gtk.Objects.Expression#g:method:getValueType").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveCClosureExpressionMethod         ,
#endif

-- ** new #method:new#

    cClosureExpressionNew                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression

#endif

-- | Memory-managed wrapper type.
newtype CClosureExpression = CClosureExpression (SP.ManagedPtr CClosureExpression)
    deriving (Eq)

instance SP.ManagedPtrNewtype CClosureExpression where
    toManagedPtr (CClosureExpression p) = p

foreign import ccall "gtk_cclosure_expression_get_type"
    c_gtk_cclosure_expression_get_type :: IO B.Types.GType

instance B.Types.TypedObject CClosureExpression where
    glibType = c_gtk_cclosure_expression_get_type

-- | Type class for types which can be safely cast to t'CClosureExpression', for instance with `toCClosureExpression`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf CClosureExpression o) => IsCClosureExpression o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf CClosureExpression o) => IsCClosureExpression o

instance O.HasParentTypes CClosureExpression
type instance O.ParentTypes CClosureExpression = '[Gtk.Expression.Expression]

-- | Cast to t'CClosureExpression', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCClosureExpression :: (MIO.MonadIO m, IsCClosureExpression o) => o -> m CClosureExpression
toCClosureExpression = MIO.liftIO . B.ManagedPtr.unsafeCastTo CClosureExpression

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveCClosureExpressionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCClosureExpressionMethod "bind" o = Gtk.Expression.ExpressionBindMethodInfo
    ResolveCClosureExpressionMethod "evaluate" o = Gtk.Expression.ExpressionEvaluateMethodInfo
    ResolveCClosureExpressionMethod "isStatic" o = Gtk.Expression.ExpressionIsStaticMethodInfo
    ResolveCClosureExpressionMethod "ref" o = Gtk.Expression.ExpressionRefMethodInfo
    ResolveCClosureExpressionMethod "unref" o = Gtk.Expression.ExpressionUnrefMethodInfo
    ResolveCClosureExpressionMethod "watch" o = Gtk.Expression.ExpressionWatchMethodInfo
    ResolveCClosureExpressionMethod "getValueType" o = Gtk.Expression.ExpressionGetValueTypeMethodInfo
    ResolveCClosureExpressionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCClosureExpressionMethod t CClosureExpression, O.OverloadedMethod info CClosureExpression p) => OL.IsLabel t (CClosureExpression -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCClosureExpressionMethod t CClosureExpression, O.OverloadedMethod info CClosureExpression p, R.HasField t CClosureExpression p) => R.HasField t CClosureExpression p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCClosureExpressionMethod t CClosureExpression, O.OverloadedMethodInfo info CClosureExpression) => OL.IsLabel t (O.MethodProxy info CClosureExpression) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr CClosureExpression where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method CClosureExpression::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "value_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the type of the value that this expression evaluates to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ClosureMarshal" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "marshaller used for creating a closure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_params"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of params needed for evaluating @closure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "params"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Gtk" , name = "Expression" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "expressions for each parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "callback_func"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Callback" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback used for creating a closure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 5
--           , argDestroy = 6
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data used for creating a closure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ClosureNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_params"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of params needed for evaluating @closure"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "CClosureExpression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_cclosure_expression_new" gtk_cclosure_expression_new :: 
    CGType ->                               -- value_type : TBasicType TGType
    FunPtr GObject.Callbacks.C_ClosureMarshal -> -- marshal : TInterface (Name {namespace = "GObject", name = "ClosureMarshal"})
    Word32 ->                               -- n_params : TBasicType TUInt
    Ptr (Ptr Gtk.Expression.Expression) ->  -- params : TCArray False (-1) 2 (TInterface (Name {namespace = "Gtk", name = "Expression"}))
    FunPtr GObject.Callbacks.C_Callback ->  -- callback_func : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GObject.Callbacks.C_ClosureNotify -> -- user_destroy : TInterface (Name {namespace = "GObject", name = "ClosureNotify"})
    IO (Ptr CClosureExpression)

-- | Creates a @GtkExpression@ that calls @callback_func@ when it is evaluated.
-- 
-- This function is a variant of 'GI.Gtk.Objects.ClosureExpression.closureExpressionNew' that
-- creates a @GClosure@ by calling @/g_cclosure_new()/@ with the given
-- @callback_func@, @user_data@ and @user_destroy@.
cClosureExpressionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@valueType@/: the type of the value that this expression evaluates to
    -> Maybe (GObject.Callbacks.ClosureMarshal)
    -- ^ /@marshal@/: marshaller used for creating a closure
    -> [Gtk.Expression.Expression]
    -- ^ /@params@/: expressions for each parameter
    -> GObject.Callbacks.Callback
    -- ^ /@callbackFunc@/: callback used for creating a closure
    -> m CClosureExpression
    -- ^ __Returns:__ a new @GtkExpression@
cClosureExpressionNew valueType marshal params callbackFunc = liftIO $ do
    let nParams = fromIntegral $ P.length params
    let valueType' = gtypeToCGType valueType
    maybeMarshal <- case marshal of
        Nothing -> return FP.nullFunPtr
        Just jMarshal -> do
            jMarshal' <- GObject.Callbacks.mk_ClosureMarshal (GObject.Callbacks.wrap_ClosureMarshal Nothing jMarshal)
            return jMarshal'
    params' <- mapM B.ManagedPtr.disownManagedPtr params
    params'' <- packPtrArray params'
    callbackFunc' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callbackFunc)
    let userData = castFunPtrToPtr callbackFunc'
    let userDestroy = SP.safeFreeFunPtrPtr'
    result <- gtk_cclosure_expression_new valueType' maybeMarshal nParams params'' callbackFunc' userData userDestroy
    checkUnexpectedReturnNULL "cClosureExpressionNew" result
    result' <- (wrapPtr CClosureExpression) result
    safeFreeFunPtr $ castFunPtrToPtr maybeMarshal
    mapM_ touchManagedPtr params
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


