{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GdkPaintable@ that displays the contents of a widget.
-- 
-- @GtkWidgetPaintable@ will also take care of the widget not being in a
-- state where it can be drawn (like when it isn\'t shown) and just draw
-- nothing or where it does not have a size (like when it is hidden) and
-- report no size in that case.
-- 
-- Of course, @GtkWidgetPaintable@ allows you to monitor widgets for size
-- changes by emitting the [Paintable::invalidateSize]("GI.Gdk.Interfaces.Paintable#g:signal:invalidateSize") signal
-- whenever the size of the widget changes as well as for visual changes by
-- emitting the [Paintable::invalidateContents]("GI.Gdk.Interfaces.Paintable#g:signal:invalidateContents") signal whenever
-- the widget changes.
-- 
-- You can use a @GtkWidgetPaintable@ everywhere a @GdkPaintable@ is allowed,
-- including using it on a @GtkPicture@ (or one of its parents) that it was
-- set on itself via 'GI.Gtk.Objects.Picture.pictureSetPaintable'. The paintable will take care
-- of recursion when this happens. If you do this however, ensure that the
-- [Picture:canShrink]("GI.Gtk.Objects.Picture#g:attr:canShrink") property is set to 'P.True' or you might
-- end up with an infinitely growing widget.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.WidgetPaintable
    ( 

-- * Exported types
    WidgetPaintable(..)                     ,
    IsWidgetPaintable                       ,
    toWidgetPaintable                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.WidgetPaintable#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setWidget]("GI.Gtk.Objects.WidgetPaintable#g:method:setWidget").

#if defined(ENABLE_OVERLOADING)
    ResolveWidgetPaintableMethod            ,
#endif

-- ** getWidget #method:getWidget#

#if defined(ENABLE_OVERLOADING)
    WidgetPaintableGetWidgetMethodInfo      ,
#endif
    widgetPaintableGetWidget                ,


-- ** new #method:new#

    widgetPaintableNew                      ,


-- ** setWidget #method:setWidget#

#if defined(ENABLE_OVERLOADING)
    WidgetPaintableSetWidgetMethodInfo      ,
#endif
    widgetPaintableSetWidget                ,




 -- * Properties


-- ** widget #attr:widget#
-- | The observed widget or 'P.Nothing' if none.

#if defined(ENABLE_OVERLOADING)
    WidgetPaintableWidgetPropertyInfo       ,
#endif
    clearWidgetPaintableWidget              ,
    constructWidgetPaintableWidget          ,
    getWidgetPaintableWidget                ,
    setWidgetPaintableWidget                ,
#if defined(ENABLE_OVERLOADING)
    widgetPaintableWidget                   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype WidgetPaintable = WidgetPaintable (SP.ManagedPtr WidgetPaintable)
    deriving (Eq)

instance SP.ManagedPtrNewtype WidgetPaintable where
    toManagedPtr (WidgetPaintable p) = p

foreign import ccall "gtk_widget_paintable_get_type"
    c_gtk_widget_paintable_get_type :: IO B.Types.GType

instance B.Types.TypedObject WidgetPaintable where
    glibType = c_gtk_widget_paintable_get_type

instance B.Types.GObject WidgetPaintable

-- | Type class for types which can be safely cast to t'WidgetPaintable', for instance with `toWidgetPaintable`.
class (SP.GObject o, O.IsDescendantOf WidgetPaintable o) => IsWidgetPaintable o
instance (SP.GObject o, O.IsDescendantOf WidgetPaintable o) => IsWidgetPaintable o

instance O.HasParentTypes WidgetPaintable
type instance O.ParentTypes WidgetPaintable = '[GObject.Object.Object, Gdk.Paintable.Paintable]

-- | Cast to t'WidgetPaintable', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toWidgetPaintable :: (MIO.MonadIO m, IsWidgetPaintable o) => o -> m WidgetPaintable
toWidgetPaintable = MIO.liftIO . B.ManagedPtr.unsafeCastTo WidgetPaintable

-- | Convert t'WidgetPaintable' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe WidgetPaintable) where
    gvalueGType_ = c_gtk_widget_paintable_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr WidgetPaintable)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr WidgetPaintable)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject WidgetPaintable ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveWidgetPaintableMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWidgetPaintableMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveWidgetPaintableMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveWidgetPaintableMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveWidgetPaintableMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveWidgetPaintableMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveWidgetPaintableMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveWidgetPaintableMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveWidgetPaintableMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveWidgetPaintableMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveWidgetPaintableMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveWidgetPaintableMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveWidgetPaintableMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveWidgetPaintableMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveWidgetPaintableMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveWidgetPaintableMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveWidgetPaintableMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveWidgetPaintableMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveWidgetPaintableMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveWidgetPaintableMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveWidgetPaintableMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveWidgetPaintableMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveWidgetPaintableMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveWidgetPaintableMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveWidgetPaintableMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveWidgetPaintableMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveWidgetPaintableMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveWidgetPaintableMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveWidgetPaintableMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveWidgetPaintableMethod "getWidget" o = WidgetPaintableGetWidgetMethodInfo
    ResolveWidgetPaintableMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveWidgetPaintableMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveWidgetPaintableMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveWidgetPaintableMethod "setWidget" o = WidgetPaintableSetWidgetMethodInfo
    ResolveWidgetPaintableMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWidgetPaintableMethod t WidgetPaintable, O.OverloadedMethod info WidgetPaintable p) => OL.IsLabel t (WidgetPaintable -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWidgetPaintableMethod t WidgetPaintable, O.OverloadedMethod info WidgetPaintable p, R.HasField t WidgetPaintable p) => R.HasField t WidgetPaintable p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWidgetPaintableMethod t WidgetPaintable, O.OverloadedMethodInfo info WidgetPaintable) => OL.IsLabel t (O.MethodProxy info WidgetPaintable) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetPaintable #widget
-- @
getWidgetPaintableWidget :: (MonadIO m, IsWidgetPaintable o) => o -> m (Maybe Gtk.Widget.Widget)
getWidgetPaintableWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "widget" Gtk.Widget.Widget

-- | Set the value of the “@widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetPaintable [ #widget 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetPaintableWidget :: (MonadIO m, IsWidgetPaintable o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setWidgetPaintableWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "widget" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWidgetPaintableWidget :: (IsWidgetPaintable o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructWidgetPaintableWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "widget" (P.Just val)

-- | Set the value of the “@widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #widget
-- @
clearWidgetPaintableWidget :: (MonadIO m, IsWidgetPaintable o) => o -> m ()
clearWidgetPaintableWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data WidgetPaintableWidgetPropertyInfo
instance AttrInfo WidgetPaintableWidgetPropertyInfo where
    type AttrAllowedOps WidgetPaintableWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WidgetPaintableWidgetPropertyInfo = IsWidgetPaintable
    type AttrSetTypeConstraint WidgetPaintableWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint WidgetPaintableWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType WidgetPaintableWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType WidgetPaintableWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel WidgetPaintableWidgetPropertyInfo = "widget"
    type AttrOrigin WidgetPaintableWidgetPropertyInfo = WidgetPaintable
    attrGet = getWidgetPaintableWidget
    attrSet = setWidgetPaintableWidget
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructWidgetPaintableWidget
    attrClear = clearWidgetPaintableWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WidgetPaintable.widget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-WidgetPaintable.html#g:attr:widget"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList WidgetPaintable
type instance O.AttributeList WidgetPaintable = WidgetPaintableAttributeList
type WidgetPaintableAttributeList = ('[ '("widget", WidgetPaintableWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
widgetPaintableWidget :: AttrLabelProxy "widget"
widgetPaintableWidget = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList WidgetPaintable = WidgetPaintableSignalList
type WidgetPaintableSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method WidgetPaintable::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "WidgetPaintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_paintable_new" gtk_widget_paintable_new :: 
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr WidgetPaintable)

-- | Creates a new widget paintable observing the given widget.
widgetPaintableNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    Maybe (a)
    -- ^ /@widget@/: a @GtkWidget@
    -> m WidgetPaintable
    -- ^ __Returns:__ a new @GtkWidgetPaintable@
widgetPaintableNew widget = liftIO $ do
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    result <- gtk_widget_paintable_new maybeWidget
    checkUnexpectedReturnNULL "widgetPaintableNew" result
    result' <- (wrapObject WidgetPaintable) result
    whenJust widget touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method WidgetPaintable::get_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetPaintable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidgetPaintable`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_paintable_get_widget" gtk_widget_paintable_get_widget :: 
    Ptr WidgetPaintable ->                  -- self : TInterface (Name {namespace = "Gtk", name = "WidgetPaintable"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the widget that is observed or 'P.Nothing' if none.
widgetPaintableGetWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsWidgetPaintable a) =>
    a
    -- ^ /@self@/: a @GtkWidgetPaintable@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the observed widget.
widgetPaintableGetWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_widget_paintable_get_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WidgetPaintableGetWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsWidgetPaintable a) => O.OverloadedMethod WidgetPaintableGetWidgetMethodInfo a signature where
    overloadedMethod = widgetPaintableGetWidget

instance O.OverloadedMethodInfo WidgetPaintableGetWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WidgetPaintable.widgetPaintableGetWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-WidgetPaintable.html#v:widgetPaintableGetWidget"
        })


#endif

-- method WidgetPaintable::set_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetPaintable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidgetPaintable`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to observe"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_paintable_set_widget" gtk_widget_paintable_set_widget :: 
    Ptr WidgetPaintable ->                  -- self : TInterface (Name {namespace = "Gtk", name = "WidgetPaintable"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the widget that should be observed.
widgetPaintableSetWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsWidgetPaintable a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkWidgetPaintable@
    -> Maybe (b)
    -- ^ /@widget@/: the widget to observe
    -> m ()
widgetPaintableSetWidget self widget = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_widget_paintable_set_widget self' maybeWidget
    touchManagedPtr self
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetPaintableSetWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWidgetPaintable a, Gtk.Widget.IsWidget b) => O.OverloadedMethod WidgetPaintableSetWidgetMethodInfo a signature where
    overloadedMethod = widgetPaintableSetWidget

instance O.OverloadedMethodInfo WidgetPaintableSetWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WidgetPaintable.widgetPaintableSetWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-WidgetPaintable.html#v:widgetPaintableSetWidget"
        })


#endif


