#define XERR
#include "modules.ih"

void Modules::scan(Classes::Info const &info, string const &fname)
{
    Data data{ info.idx, info.subdir };

    d_scanner.switchStreams(d_interface_cc, "-");

    string modName;

    while (true)
    {
        switch (d_scanner.lex())
        {
            case 0:
                if (not data.modName.empty())
                {
                    if (d_dependencies)
                        data.orgImports = data.imports;
                    d_modules.push_back(move(data));
//        xerr("interface in `" << data.subdir << "' completed");
                }
            return;

                                // things like 'export module XXX;'
            case Scanner::MODULENAME:
            {
                data.modName = d_scanner.matched();

                d_extern.erase(data.modName);
                d_project.insert(data.modName);

                imsg << "Module: " << data.modName << '\n';

                size_t pos = data.modName.find(':');
                modName = pos == string::npos ?
                                data.modName        // a plain module, or the
                            :                       // partition's modName
                                data.modName.substr(0, pos);
                continue;
            }
    
                            // things like '(export) import YYY;'
            case Scanner::MODULE:
            {
                string imports = d_scanner.matched();

                if (imports.front() == ':')         // a partition 
                    imports = modName + imports;    // prefix the modName

                if (not d_project.contains(imports))
                    d_extern.insert(imports);

                imsg << "   imports " << imports << endl;
                data.imports.insert(imports);
            }
            continue;
        }
    }
}    


