// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
)

// RoleClient provides methods for managing Role resources of Yandex.Cloud IAM.
type RoleClient interface {
	RoleClientIterator
	Get(context.Context, *iam.GetRoleRequest, ...grpc.CallOption) (*iam.Role, error)
	List(context.Context, *iam.ListRolesRequest, ...grpc.CallOption) (*iam.ListRolesResponse, error)
}

var _ RoleClient = roleClient{}

type roleClient struct {
	connector transport.Connector
}

// NewRoleClient returns RoleClient implementation.
func NewRoleClient(connector transport.Connector) RoleClient {
	return roleClient{connector}
}

// Get is an operation of Yandex.Cloud IAM Role service.
func (c roleClient) Get(ctx context.Context, in *iam.GetRoleRequest, opts ...grpc.CallOption) (*iam.Role, error) {
	connection, err := c.connector.GetConnection(ctx, RoleGet, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewRoleServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud IAM Role service.
func (c roleClient) List(ctx context.Context, in *iam.ListRolesRequest, opts ...grpc.CallOption) (*iam.ListRolesResponse, error) {
	connection, err := c.connector.GetConnection(ctx, RoleList, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewRoleServiceClient(connection).List(ctx, in, opts...)
}

var (
	RoleGet  = protoreflect.FullName("yandex.cloud.iam.v1.RoleService.Get")
	RoleList = protoreflect.FullName("yandex.cloud.iam.v1.RoleService.List")
)
