/* candidate-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from candidate-list.vala, do not modify */

/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SKK_CANDIDATE_LIST_0_PROPERTY,
	SKK_CANDIDATE_LIST_CURSOR_POS_PROPERTY,
	SKK_CANDIDATE_LIST_SIZE_PROPERTY,
	SKK_CANDIDATE_LIST_PAGE_START_PROPERTY,
	SKK_CANDIDATE_LIST_PAGE_SIZE_PROPERTY,
	SKK_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY,
	SKK_CANDIDATE_LIST_NUM_PROPERTIES
};
static GParamSpec* skk_candidate_list_properties[SKK_CANDIDATE_LIST_NUM_PROPERTIES];
enum  {
	SKK_CANDIDATE_LIST_POPULATED_SIGNAL,
	SKK_CANDIDATE_LIST_SELECTED_SIGNAL,
	SKK_CANDIDATE_LIST_NUM_SIGNALS
};
static guint skk_candidate_list_signals[SKK_CANDIDATE_LIST_NUM_SIGNALS] = {0};

#define SKK_TYPE_SIMPLE_CANDIDATE_LIST (skk_simple_candidate_list_get_type ())
#define SKK_SIMPLE_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateList))
#define SKK_SIMPLE_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateListClass))
#define SKK_IS_SIMPLE_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST))
#define SKK_IS_SIMPLE_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_SIMPLE_CANDIDATE_LIST))
#define SKK_SIMPLE_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateListClass))

typedef struct _SkkSimpleCandidateList SkkSimpleCandidateList;
typedef struct _SkkSimpleCandidateListClass SkkSimpleCandidateListClass;
typedef struct _SkkSimpleCandidateListPrivate SkkSimpleCandidateListPrivate;
enum  {
	SKK_SIMPLE_CANDIDATE_LIST_0_PROPERTY,
	SKK_SIMPLE_CANDIDATE_LIST_CURSOR_POS_PROPERTY,
	SKK_SIMPLE_CANDIDATE_LIST_SIZE_PROPERTY,
	SKK_SIMPLE_CANDIDATE_LIST_PAGE_START_PROPERTY,
	SKK_SIMPLE_CANDIDATE_LIST_PAGE_SIZE_PROPERTY,
	SKK_SIMPLE_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY,
	SKK_SIMPLE_CANDIDATE_LIST_NUM_PROPERTIES
};
static GParamSpec* skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SKK_TYPE_PROXY_CANDIDATE_LIST (skk_proxy_candidate_list_get_type ())
#define SKK_PROXY_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_PROXY_CANDIDATE_LIST, SkkProxyCandidateList))
#define SKK_PROXY_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_PROXY_CANDIDATE_LIST, SkkProxyCandidateListClass))
#define SKK_IS_PROXY_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_PROXY_CANDIDATE_LIST))
#define SKK_IS_PROXY_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_PROXY_CANDIDATE_LIST))
#define SKK_PROXY_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_PROXY_CANDIDATE_LIST, SkkProxyCandidateListClass))

typedef struct _SkkProxyCandidateList SkkProxyCandidateList;
typedef struct _SkkProxyCandidateListClass SkkProxyCandidateListClass;
typedef struct _SkkProxyCandidateListPrivate SkkProxyCandidateListPrivate;
enum  {
	SKK_PROXY_CANDIDATE_LIST_0_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_CANDIDATES_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_CURSOR_POS_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_SIZE_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_PAGE_START_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_PAGE_SIZE_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY,
	SKK_PROXY_CANDIDATE_LIST_NUM_PROPERTIES
};
static GParamSpec* skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SkkSimpleCandidateList {
	SkkCandidateList parent_instance;
	SkkSimpleCandidateListPrivate * priv;
};

struct _SkkSimpleCandidateListClass {
	SkkCandidateListClass parent_class;
};

struct _SkkSimpleCandidateListPrivate {
	GeeArrayList* _candidates;
	gint _cursor_pos;
	GeeSet* seen;
	gint _page_start;
	gint _page_size;
};

struct _SkkProxyCandidateList {
	SkkCandidateList parent_instance;
	SkkProxyCandidateListPrivate * priv;
};

struct _SkkProxyCandidateListClass {
	SkkCandidateListClass parent_class;
};

struct _SkkProxyCandidateListPrivate {
	SkkCandidateList* _candidates;
};

static gpointer skk_candidate_list_parent_class = NULL;
static gint SkkSimpleCandidateList_private_offset;
static gpointer skk_simple_candidate_list_parent_class = NULL;
static gint SkkProxyCandidateList_private_offset;
static gpointer skk_proxy_candidate_list_parent_class = NULL;

VALA_EXTERN void skk_candidate_list_clear (SkkCandidateList* self);
VALA_EXTERN void skk_candidate_list_add_candidates (SkkCandidateList* self,
                                        SkkCandidate** array,
                                        gint array_length1);
VALA_EXTERN void skk_candidate_list_add_candidates_end (SkkCandidateList* self);
static SkkCandidate* skk_candidate_list_real_get (SkkCandidateList* self,
                                           gint index);
static void skk_candidate_list_real_clear (SkkCandidateList* self);
static void skk_candidate_list_real_add_candidates (SkkCandidateList* self,
                                             SkkCandidate** array,
                                             gint array_length1);
static void skk_candidate_list_real_add_candidates_end (SkkCandidateList* self);
static gboolean skk_candidate_list_real_cursor_up (SkkCandidateList* self);
static gboolean skk_candidate_list_real_cursor_down (SkkCandidateList* self);
static gboolean skk_candidate_list_real_page_up (SkkCandidateList* self);
static gboolean skk_candidate_list_real_page_down (SkkCandidateList* self);
static gboolean skk_candidate_list_real_next (SkkCandidateList* self);
static gboolean skk_candidate_list_real_previous (SkkCandidateList* self);
static gboolean skk_candidate_list_real_select_at (SkkCandidateList* self,
                                            guint index_in_page);
static void skk_candidate_list_real_select (SkkCandidateList* self);
static GType skk_candidate_list_get_type_once (void);
static void _vala_skk_candidate_list_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_skk_candidate_list_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GType skk_simple_candidate_list_get_type (void) G_GNUC_CONST ;
static SkkCandidate* skk_simple_candidate_list_real_get (SkkCandidateList* base,
                                                  gint index);
static void skk_simple_candidate_list_real_clear (SkkCandidateList* base);
static void skk_simple_candidate_list_real_add_candidates (SkkCandidateList* base,
                                                    SkkCandidate** array,
                                                    gint array_length1);
static void skk_simple_candidate_list_real_add_candidates_end (SkkCandidateList* base);
static gboolean skk_simple_candidate_list_real_select_at (SkkCandidateList* base,
                                                   guint index_in_page);
static void skk_simple_candidate_list_real_select (SkkCandidateList* base);
VALA_EXTERN SkkSimpleCandidateList* skk_simple_candidate_list_new (guint page_start,
                                                       guint page_size);
VALA_EXTERN SkkSimpleCandidateList* skk_simple_candidate_list_construct (GType object_type,
                                                             guint page_start,
                                                             guint page_size);
static gboolean skk_simple_candidate_list_real_cursor_up (SkkCandidateList* base);
static gboolean skk_simple_candidate_list_real_cursor_down (SkkCandidateList* base);
static gboolean skk_simple_candidate_list_real_page_up (SkkCandidateList* base);
static gboolean skk_simple_candidate_list_real_page_down (SkkCandidateList* base);
static void skk_simple_candidate_list_finalize (GObject * obj);
static GType skk_simple_candidate_list_get_type_once (void);
static void _vala_skk_simple_candidate_list_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_skk_simple_candidate_list_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
VALA_EXTERN GType skk_proxy_candidate_list_get_type (void) G_GNUC_CONST ;
static void skk_proxy_candidate_list_notify_cursor_pos_cb (SkkProxyCandidateList* self,
                                                    GObject* s,
                                                    GParamSpec* p);
static void skk_proxy_candidate_list_populated_cb (SkkProxyCandidateList* self);
static void skk_proxy_candidate_list_selected_cb (SkkProxyCandidateList* self,
                                           SkkCandidate* c);
static SkkCandidate* skk_proxy_candidate_list_real_get (SkkCandidateList* base,
                                                 gint index);
VALA_EXTERN SkkCandidateList* skk_proxy_candidate_list_get_candidates (SkkProxyCandidateList* self);
static void skk_proxy_candidate_list_real_clear (SkkCandidateList* base);
static void skk_proxy_candidate_list_real_add_candidates (SkkCandidateList* base,
                                                   SkkCandidate** array,
                                                   gint array_length1);
static void skk_proxy_candidate_list_real_add_candidates_end (SkkCandidateList* base);
static gboolean skk_proxy_candidate_list_real_select_at (SkkCandidateList* base,
                                                  guint index_in_page);
static void skk_proxy_candidate_list_real_select (SkkCandidateList* base);
VALA_EXTERN SkkProxyCandidateList* skk_proxy_candidate_list_new (SkkCandidateList* candidates);
VALA_EXTERN SkkProxyCandidateList* skk_proxy_candidate_list_construct (GType object_type,
                                                           SkkCandidateList* candidates);
VALA_EXTERN void skk_proxy_candidate_list_set_candidates (SkkProxyCandidateList* self,
                                              SkkCandidateList* value);
static gboolean skk_proxy_candidate_list_real_cursor_up (SkkCandidateList* base);
static gboolean skk_proxy_candidate_list_real_cursor_down (SkkCandidateList* base);
static gboolean skk_proxy_candidate_list_real_page_up (SkkCandidateList* base);
static gboolean skk_proxy_candidate_list_real_page_down (SkkCandidateList* base);
static void _skk_proxy_candidate_list_notify_cursor_pos_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _skk_proxy_candidate_list_populated_cb_skk_candidate_list_populated (SkkCandidateList* _sender,
                                                                          gpointer self);
static void _skk_proxy_candidate_list_selected_cb_skk_candidate_list_selected (SkkCandidateList* _sender,
                                                                        SkkCandidate* candidate,
                                                                        gpointer self);
static void skk_proxy_candidate_list_finalize (GObject * obj);
static GType skk_proxy_candidate_list_get_type_once (void);
static void _vala_skk_proxy_candidate_list_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_skk_proxy_candidate_list_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
         * Get the current candidate at the given index.
         *
         * @param index candidate position (-1 for the current cursor position)
         *
         * @return a Candidate
         */
static SkkCandidate*
skk_candidate_list_real_get (SkkCandidateList* self,
                             gint index)
{
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

SkkCandidate*
skk_candidate_list_get (SkkCandidateList* self,
                        gint index)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->get) {
		return _klass_->get (self, index);
	}
	return NULL;
}

static void
skk_candidate_list_real_clear (SkkCandidateList* self)
{
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
skk_candidate_list_clear (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->clear) {
		_klass_->clear (self);
	}
}

static void
skk_candidate_list_real_add_candidates (SkkCandidateList* self,
                                        SkkCandidate** array,
                                        gint array_length1)
{
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_add_candidates'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
skk_candidate_list_add_candidates (SkkCandidateList* self,
                                   SkkCandidate** array,
                                   gint array_length1)
{
	SkkCandidateListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->add_candidates) {
		_klass_->add_candidates (self, array, array_length1);
	}
}

static void
skk_candidate_list_real_add_candidates_end (SkkCandidateList* self)
{
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_add_candidates_end'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
skk_candidate_list_add_candidates_end (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->add_candidates_end) {
		_klass_->add_candidates_end (self);
	}
}

/**
         * Move cursor to the previous candidate.
         *
         * @return `true` if cursor position has changed, `false` otherwise.
         */
static gboolean
skk_candidate_list_real_cursor_up (SkkCandidateList* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_cursor_up'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
skk_candidate_list_cursor_up (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->cursor_up) {
		return _klass_->cursor_up (self);
	}
	return FALSE;
}

/**
         * Move cursor to the next candidate.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean
skk_candidate_list_real_cursor_down (SkkCandidateList* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_cursor_down'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
skk_candidate_list_cursor_down (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->cursor_down) {
		return _klass_->cursor_down (self);
	}
	return FALSE;
}

/**
         * Move cursor to the previous page.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean
skk_candidate_list_real_page_up (SkkCandidateList* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_page_up'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
skk_candidate_list_page_up (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->page_up) {
		return _klass_->page_up (self);
	}
	return FALSE;
}

/**
         * Move cursor to the next page.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean
skk_candidate_list_real_page_down (SkkCandidateList* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_page_down'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
skk_candidate_list_page_down (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->page_down) {
		return _klass_->page_down (self);
	}
	return FALSE;
}

/**
         * Move cursor forward.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean
skk_candidate_list_real_next (SkkCandidateList* self)
{
	gint _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean result;
	_tmp0_ = skk_candidate_list_get_cursor_pos (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_page_start (self);
	_tmp3_ = _tmp2_;
	if (((guint) _tmp1_) < _tmp3_) {
		result = skk_candidate_list_cursor_down (self);
		return result;
	} else {
		result = skk_candidate_list_page_down (self);
		return result;
	}
}

gboolean
skk_candidate_list_next (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->next) {
		return _klass_->next (self);
	}
	return FALSE;
}

/**
         * Move cursor backward.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean
skk_candidate_list_real_previous (SkkCandidateList* self)
{
	gint _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean result;
	_tmp0_ = skk_candidate_list_get_cursor_pos (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_page_start (self);
	_tmp3_ = _tmp2_;
	if (((guint) _tmp1_) <= _tmp3_) {
		result = skk_candidate_list_cursor_up (self);
		return result;
	} else {
		result = skk_candidate_list_page_up (self);
		return result;
	}
}

gboolean
skk_candidate_list_previous (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->previous) {
		return _klass_->previous (self);
	}
	return FALSE;
}

/**
         * Return cursor position of the beginning of the current page.
         *
         * @return cursor position
         */
guint
skk_candidate_list_get_page_start_cursor_pos (SkkCandidateList* self)
{
	guint pages = 0U;
	gint _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = skk_candidate_list_get_cursor_pos (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_page_start (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = skk_candidate_list_get_page_size (self);
	_tmp5_ = _tmp4_;
	pages = (_tmp1_ - _tmp3_) / _tmp5_;
	_tmp6_ = skk_candidate_list_get_page_size (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = skk_candidate_list_get_page_start (self);
	_tmp9_ = _tmp8_;
	result = (pages * _tmp7_) + _tmp9_;
	return result;
}

/**
         * Select a candidate in the current page.
         *
         * @param index_in_page cursor position in the page to select
         *
         * @return `true` if a candidate is selected, `false` otherwise
         */
static gboolean
skk_candidate_list_real_select_at (SkkCandidateList* self,
                                   guint index_in_page)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_select_at'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
skk_candidate_list_select_at (SkkCandidateList* self,
                              guint index_in_page)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->select_at) {
		return _klass_->select_at (self, index_in_page);
	}
	return FALSE;
}

/**
         * Select the current candidate.
         */
static void
skk_candidate_list_real_select (SkkCandidateList* self)
{
	g_critical ("Type `%s' does not implement abstract method `skk_candidate_list_select'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
skk_candidate_list_select (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->select) {
		_klass_->select (self);
	}
}

SkkCandidateList*
skk_candidate_list_construct (GType object_type)
{
	SkkCandidateList * self = NULL;
	self = (SkkCandidateList*) g_object_new (object_type, NULL);
	return self;
}

gint
skk_candidate_list_get_cursor_pos (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->get_cursor_pos) {
		return _klass_->get_cursor_pos (self);
	}
	return -1;
}

gint
skk_candidate_list_get_size (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->get_size) {
		return _klass_->get_size (self);
	}
	return -1;
}

guint
skk_candidate_list_get_page_start (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->get_page_start) {
		return _klass_->get_page_start (self);
	}
	return 0U;
}

void
skk_candidate_list_set_page_start (SkkCandidateList* self,
                                   guint value)
{
	SkkCandidateListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->set_page_start) {
		_klass_->set_page_start (self, value);
	}
}

guint
skk_candidate_list_get_page_size (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->get_page_size) {
		return _klass_->get_page_size (self);
	}
	return 0U;
}

void
skk_candidate_list_set_page_size (SkkCandidateList* self,
                                  guint value)
{
	SkkCandidateListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->set_page_size) {
		_klass_->set_page_size (self, value);
	}
}

gboolean
skk_candidate_list_get_page_visible (SkkCandidateList* self)
{
	SkkCandidateListClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_CANDIDATE_LIST_GET_CLASS (self);
	if (_klass_->get_page_visible) {
		return _klass_->get_page_visible (self);
	}
	return FALSE;
}

static void
skk_candidate_list_class_init (SkkCandidateListClass * klass,
                               gpointer klass_data)
{
	skk_candidate_list_parent_class = g_type_class_peek_parent (klass);
	((SkkCandidateListClass *) klass)->get = (SkkCandidate* (*) (SkkCandidateList*, gint)) skk_candidate_list_real_get;
	((SkkCandidateListClass *) klass)->clear = (void (*) (SkkCandidateList*)) skk_candidate_list_real_clear;
	((SkkCandidateListClass *) klass)->add_candidates = (void (*) (SkkCandidateList*, SkkCandidate**, gint)) skk_candidate_list_real_add_candidates;
	((SkkCandidateListClass *) klass)->add_candidates_end = (void (*) (SkkCandidateList*)) skk_candidate_list_real_add_candidates_end;
	((SkkCandidateListClass *) klass)->cursor_up = (gboolean (*) (SkkCandidateList*)) skk_candidate_list_real_cursor_up;
	((SkkCandidateListClass *) klass)->cursor_down = (gboolean (*) (SkkCandidateList*)) skk_candidate_list_real_cursor_down;
	((SkkCandidateListClass *) klass)->page_up = (gboolean (*) (SkkCandidateList*)) skk_candidate_list_real_page_up;
	((SkkCandidateListClass *) klass)->page_down = (gboolean (*) (SkkCandidateList*)) skk_candidate_list_real_page_down;
	((SkkCandidateListClass *) klass)->next = (gboolean (*) (SkkCandidateList*)) skk_candidate_list_real_next;
	((SkkCandidateListClass *) klass)->previous = (gboolean (*) (SkkCandidateList*)) skk_candidate_list_real_previous;
	((SkkCandidateListClass *) klass)->select_at = (gboolean (*) (SkkCandidateList*, guint)) skk_candidate_list_real_select_at;
	((SkkCandidateListClass *) klass)->select = (void (*) (SkkCandidateList*)) skk_candidate_list_real_select;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_candidate_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_candidate_list_set_property;
	/**
	         * Current cursor position.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_LIST_CURSOR_POS_PROPERTY, skk_candidate_list_properties[SKK_CANDIDATE_LIST_CURSOR_POS_PROPERTY] = g_param_spec_int ("cursor-pos", "cursor-pos", "cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The number of candidate in the candidate list.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_LIST_SIZE_PROPERTY, skk_candidate_list_properties[SKK_CANDIDATE_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Starting index of paging.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_LIST_PAGE_START_PROPERTY, skk_candidate_list_properties[SKK_CANDIDATE_LIST_PAGE_START_PROPERTY] = g_param_spec_uint ("page-start", "page-start", "page-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Page size.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_LIST_PAGE_SIZE_PROPERTY, skk_candidate_list_properties[SKK_CANDIDATE_LIST_PAGE_SIZE_PROPERTY] = g_param_spec_uint ("page-size", "page-size", "page-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Flag to indicate whether page (lookup table) is visible.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY, skk_candidate_list_properties[SKK_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY] = g_param_spec_boolean ("page-visible", "page-visible", "page-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Signal emitted when candidates are filled and ready for traversal.
	         */
	skk_candidate_list_signals[SKK_CANDIDATE_LIST_POPULATED_SIGNAL] = g_signal_new ("populated", SKK_TYPE_CANDIDATE_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Signal emitted when a candidate is selected.
	         *
	         * @param candidate selected candidate
	         */
	skk_candidate_list_signals[SKK_CANDIDATE_LIST_SELECTED_SIGNAL] = g_signal_new ("selected", SKK_TYPE_CANDIDATE_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SKK_TYPE_CANDIDATE);
}

static void
skk_candidate_list_instance_init (SkkCandidateList * self,
                                  gpointer klass)
{
}

/**
     * Base abstract class of candidate list.
     */
static GType
skk_candidate_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkCandidateListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_candidate_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkCandidateList), 0, (GInstanceInitFunc) skk_candidate_list_instance_init, NULL };
	GType skk_candidate_list_type_id;
	skk_candidate_list_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkCandidateList", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return skk_candidate_list_type_id;
}

GType
skk_candidate_list_get_type (void)
{
	static volatile gsize skk_candidate_list_type_id__once = 0;
	if (g_once_init_enter (&skk_candidate_list_type_id__once)) {
		GType skk_candidate_list_type_id;
		skk_candidate_list_type_id = skk_candidate_list_get_type_once ();
		g_once_init_leave (&skk_candidate_list_type_id__once, skk_candidate_list_type_id);
	}
	return skk_candidate_list_type_id__once;
}

static void
_vala_skk_candidate_list_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SkkCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_CANDIDATE_LIST, SkkCandidateList);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_skk_candidate_list_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SkkCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_CANDIDATE_LIST, SkkCandidateList);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
skk_simple_candidate_list_get_instance_private (SkkSimpleCandidateList* self)
{
	return G_STRUCT_MEMBER_P (self, SkkSimpleCandidateList_private_offset);
}

static SkkCandidate*
skk_simple_candidate_list_real_get (SkkCandidateList* base,
                                    gint index)
{
	SkkSimpleCandidateList * self;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	SkkCandidate* result;
	self = (SkkSimpleCandidateList*) base;
	if (index < 0) {
		index = self->priv->_cursor_pos;
	}
	if (0 <= index) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = skk_candidate_list_get_size ((SkkCandidateList*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = index < _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "0 <= index && index < size");
	_tmp3_ = self->priv->_candidates;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, index);
	result = (SkkCandidate*) _tmp4_;
	return result;
}

static void
skk_simple_candidate_list_real_clear (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	gboolean is_populated = FALSE;
	gboolean is_cursor_changed = FALSE;
	GeeSet* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (SkkSimpleCandidateList*) base;
	is_populated = FALSE;
	is_cursor_changed = FALSE;
	_tmp0_ = self->priv->seen;
	gee_collection_clear ((GeeCollection*) _tmp0_);
	_tmp1_ = self->priv->_candidates;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		_tmp4_ = self->priv->_candidates;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
		is_populated = TRUE;
	}
	if (self->priv->_cursor_pos >= 0) {
		self->priv->_cursor_pos = -1;
		is_cursor_changed = TRUE;
	}
	if (is_populated) {
		g_signal_emit ((SkkCandidateList*) self, skk_candidate_list_signals[SKK_CANDIDATE_LIST_POPULATED_SIGNAL], 0);
	}
	if (is_cursor_changed) {
		g_object_notify ((GObject*) self, "cursor-pos");
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
skk_simple_candidate_list_real_add_candidates (SkkCandidateList* base,
                                               SkkCandidate** array,
                                               gint array_length1)
{
	SkkSimpleCandidateList * self;
	self = (SkkSimpleCandidateList*) base;
	{
		SkkCandidate** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = array;
		c_collection_length1 = array_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			SkkCandidate* _tmp0_;
			SkkCandidate* c = NULL;
			_tmp0_ = _g_object_ref0 (c_collection[c_it]);
			c = _tmp0_;
			{
				GeeSet* _tmp1_;
				SkkCandidate* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = self->priv->seen;
				_tmp2_ = c;
				_tmp3_ = skk_candidate_get_output (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!gee_collection_contains ((GeeCollection*) _tmp1_, _tmp4_)) {
					GeeArrayList* _tmp5_;
					SkkCandidate* _tmp6_;
					GeeSet* _tmp7_;
					SkkCandidate* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp5_ = self->priv->_candidates;
					_tmp6_ = c;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
					_tmp7_ = self->priv->seen;
					_tmp8_ = c;
					_tmp9_ = skk_candidate_get_output (_tmp8_);
					_tmp10_ = _tmp9_;
					gee_collection_add ((GeeCollection*) _tmp7_, _tmp10_);
				}
				_g_object_unref0 (c);
			}
		}
	}
}

static void
skk_simple_candidate_list_real_add_candidates_end (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (SkkSimpleCandidateList*) base;
	_tmp0_ = self->priv->_candidates;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		self->priv->_cursor_pos = 0;
	}
	g_signal_emit ((SkkCandidateList*) self, skk_candidate_list_signals[SKK_CANDIDATE_LIST_POPULATED_SIGNAL], 0);
	g_object_notify ((GObject*) self, "cursor-pos");
}

static gboolean
skk_simple_candidate_list_real_select_at (SkkCandidateList* base,
                                          guint index_in_page)
{
	SkkSimpleCandidateList * self;
	guint _tmp0_;
	guint _tmp1_;
	guint page_offset = 0U;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	self = (SkkSimpleCandidateList*) base;
	_tmp0_ = skk_candidate_list_get_page_size ((SkkCandidateList*) self);
	_tmp1_ = _tmp0_;
	_vala_assert (index_in_page < _tmp1_, "index_in_page < page_size");
	page_offset = skk_candidate_list_get_page_start_cursor_pos ((SkkCandidateList*) self);
	_tmp2_ = skk_candidate_list_get_size ((SkkCandidateList*) self);
	_tmp3_ = _tmp2_;
	if ((page_offset + index_in_page) < ((guint) _tmp3_)) {
		self->priv->_cursor_pos = (gint) (page_offset + index_in_page);
		g_object_notify ((GObject*) self, "cursor-pos");
		skk_candidate_list_select ((SkkCandidateList*) self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
skk_simple_candidate_list_real_select (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	SkkCandidate* candidate = NULL;
	SkkCandidate* _tmp0_;
	self = (SkkSimpleCandidateList*) base;
	_tmp0_ = skk_candidate_list_get ((SkkCandidateList*) self, -1);
	candidate = _tmp0_;
	g_signal_emit ((SkkCandidateList*) self, skk_candidate_list_signals[SKK_CANDIDATE_LIST_SELECTED_SIGNAL], 0, candidate);
	_g_object_unref0 (candidate);
}

SkkSimpleCandidateList*
skk_simple_candidate_list_construct (GType object_type,
                                     guint page_start,
                                     guint page_size)
{
	SkkSimpleCandidateList * self = NULL;
	self = (SkkSimpleCandidateList*) skk_candidate_list_construct (object_type);
	self->priv->_page_start = (gint) page_start;
	self->priv->_page_size = (gint) page_size;
	return self;
}

SkkSimpleCandidateList*
skk_simple_candidate_list_new (guint page_start,
                               guint page_size)
{
	return skk_simple_candidate_list_construct (SKK_TYPE_SIMPLE_CANDIDATE_LIST, page_start, page_size);
}

static gboolean
skk_simple_candidate_list_real_cursor_up (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	gboolean result;
	self = (SkkSimpleCandidateList*) base;
	_vala_assert (self->priv->_cursor_pos >= 0, "_cursor_pos >= 0");
	if (self->priv->_cursor_pos > 0) {
		gint _tmp0_;
		_tmp0_ = self->priv->_cursor_pos;
		self->priv->_cursor_pos = _tmp0_ - 1;
		g_object_notify ((GObject*) self, "cursor-pos");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
skk_simple_candidate_list_real_cursor_down (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	self = (SkkSimpleCandidateList*) base;
	_vala_assert (self->priv->_cursor_pos >= 0, "_cursor_pos >= 0");
	_tmp0_ = self->priv->_candidates;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (self->priv->_cursor_pos < (_tmp2_ - 1)) {
		gint _tmp3_;
		_tmp3_ = self->priv->_cursor_pos;
		self->priv->_cursor_pos = _tmp3_ + 1;
		g_object_notify ((GObject*) self, "cursor-pos");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
skk_simple_candidate_list_real_page_up (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	gboolean result;
	self = (SkkSimpleCandidateList*) base;
	_vala_assert (self->priv->_cursor_pos >= 0, "_cursor_pos >= 0");
	if (self->priv->_cursor_pos >= (self->priv->_page_start + self->priv->_page_size)) {
		self->priv->_cursor_pos = self->priv->_cursor_pos - self->priv->_page_size;
		self->priv->_cursor_pos = (gint) skk_candidate_list_get_page_start_cursor_pos ((SkkCandidateList*) self);
		g_object_notify ((GObject*) self, "cursor-pos");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
skk_simple_candidate_list_real_page_down (SkkCandidateList* base)
{
	SkkSimpleCandidateList * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (SkkSimpleCandidateList*) base;
	_vala_assert (self->priv->_cursor_pos >= 0, "_cursor_pos >= 0");
	if (self->priv->_cursor_pos >= self->priv->_page_start) {
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->_candidates;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = self->priv->_cursor_pos < (_tmp3_ - self->priv->_page_size);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->_cursor_pos = self->priv->_cursor_pos + self->priv->_page_size;
		self->priv->_cursor_pos = (gint) skk_candidate_list_get_page_start_cursor_pos ((SkkCandidateList*) self);
		g_object_notify ((GObject*) self, "cursor-pos");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gint
skk_simple_candidate_list_real_get_cursor_pos (SkkCandidateList* base)
{
	gint result;
	SkkSimpleCandidateList* self;
	self = (SkkSimpleCandidateList*) base;
	result = self->priv->_cursor_pos;
	return result;
}

static gint
skk_simple_candidate_list_real_get_size (SkkCandidateList* base)
{
	gint result;
	SkkSimpleCandidateList* self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (SkkSimpleCandidateList*) base;
	_tmp0_ = self->priv->_candidates;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static guint
skk_simple_candidate_list_real_get_page_start (SkkCandidateList* base)
{
	guint result;
	SkkSimpleCandidateList* self;
	self = (SkkSimpleCandidateList*) base;
	result = (guint) self->priv->_page_start;
	return result;
}

static void
skk_simple_candidate_list_real_set_page_start (SkkCandidateList* base,
                                               guint value)
{
	SkkSimpleCandidateList* self;
	self = (SkkSimpleCandidateList*) base;
	self->priv->_page_start = (gint) value;
	g_object_notify_by_pspec ((GObject *) self, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_PAGE_START_PROPERTY]);
}

static guint
skk_simple_candidate_list_real_get_page_size (SkkCandidateList* base)
{
	guint result;
	SkkSimpleCandidateList* self;
	self = (SkkSimpleCandidateList*) base;
	result = (guint) self->priv->_page_size;
	return result;
}

static void
skk_simple_candidate_list_real_set_page_size (SkkCandidateList* base,
                                              guint value)
{
	SkkSimpleCandidateList* self;
	self = (SkkSimpleCandidateList*) base;
	self->priv->_page_size = (gint) value;
	g_object_notify_by_pspec ((GObject *) self, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_PAGE_SIZE_PROPERTY]);
}

static gboolean
skk_simple_candidate_list_real_get_page_visible (SkkCandidateList* base)
{
	gboolean result;
	SkkSimpleCandidateList* self;
	self = (SkkSimpleCandidateList*) base;
	result = self->priv->_cursor_pos >= self->priv->_page_start;
	return result;
}

static void
skk_simple_candidate_list_class_init (SkkSimpleCandidateListClass * klass,
                                      gpointer klass_data)
{
	skk_simple_candidate_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkSimpleCandidateList_private_offset);
	((SkkCandidateListClass *) klass)->get = (SkkCandidate* (*) (SkkCandidateList*, gint)) skk_simple_candidate_list_real_get;
	((SkkCandidateListClass *) klass)->clear = (void (*) (SkkCandidateList*)) skk_simple_candidate_list_real_clear;
	((SkkCandidateListClass *) klass)->add_candidates = (void (*) (SkkCandidateList*, SkkCandidate**, gint)) skk_simple_candidate_list_real_add_candidates;
	((SkkCandidateListClass *) klass)->add_candidates_end = (void (*) (SkkCandidateList*)) skk_simple_candidate_list_real_add_candidates_end;
	((SkkCandidateListClass *) klass)->select_at = (gboolean (*) (SkkCandidateList*, guint)) skk_simple_candidate_list_real_select_at;
	((SkkCandidateListClass *) klass)->select = (void (*) (SkkCandidateList*)) skk_simple_candidate_list_real_select;
	((SkkCandidateListClass *) klass)->cursor_up = (gboolean (*) (SkkCandidateList*)) skk_simple_candidate_list_real_cursor_up;
	((SkkCandidateListClass *) klass)->cursor_down = (gboolean (*) (SkkCandidateList*)) skk_simple_candidate_list_real_cursor_down;
	((SkkCandidateListClass *) klass)->page_up = (gboolean (*) (SkkCandidateList*)) skk_simple_candidate_list_real_page_up;
	((SkkCandidateListClass *) klass)->page_down = (gboolean (*) (SkkCandidateList*)) skk_simple_candidate_list_real_page_down;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_cursor_pos = (gint (*) (SkkCandidateList*)) skk_simple_candidate_list_real_get_cursor_pos;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_size = (gint (*) (SkkCandidateList*)) skk_simple_candidate_list_real_get_size;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_page_start = (guint (*) (SkkCandidateList*)) skk_simple_candidate_list_real_get_page_start;
	SKK_CANDIDATE_LIST_CLASS (klass)->set_page_start = (void (*) (SkkCandidateList*, guint)) skk_simple_candidate_list_real_set_page_start;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_page_size = (guint (*) (SkkCandidateList*)) skk_simple_candidate_list_real_get_page_size;
	SKK_CANDIDATE_LIST_CLASS (klass)->set_page_size = (void (*) (SkkCandidateList*, guint)) skk_simple_candidate_list_real_set_page_size;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_page_visible = (gboolean (*) (SkkCandidateList*)) skk_simple_candidate_list_real_get_page_visible;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_simple_candidate_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_simple_candidate_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_simple_candidate_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_SIMPLE_CANDIDATE_LIST_CURSOR_POS_PROPERTY, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_CURSOR_POS_PROPERTY] = g_param_spec_int ("cursor-pos", "cursor-pos", "cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_SIMPLE_CANDIDATE_LIST_SIZE_PROPERTY, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_SIMPLE_CANDIDATE_LIST_PAGE_START_PROPERTY, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_PAGE_START_PROPERTY] = g_param_spec_uint ("page-start", "page-start", "page-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_SIMPLE_CANDIDATE_LIST_PAGE_SIZE_PROPERTY, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_PAGE_SIZE_PROPERTY] = g_param_spec_uint ("page-size", "page-size", "page-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_SIMPLE_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY, skk_simple_candidate_list_properties[SKK_SIMPLE_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY] = g_param_spec_boolean ("page-visible", "page-visible", "page-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_simple_candidate_list_instance_init (SkkSimpleCandidateList * self,
                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = skk_simple_candidate_list_get_instance_private (self);
	_tmp0_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_candidates = _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->seen = (GeeSet*) _tmp1_;
}

static void
skk_simple_candidate_list_finalize (GObject * obj)
{
	SkkSimpleCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateList);
	_g_object_unref0 (self->priv->_candidates);
	_g_object_unref0 (self->priv->seen);
	G_OBJECT_CLASS (skk_simple_candidate_list_parent_class)->finalize (obj);
}

static GType
skk_simple_candidate_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkSimpleCandidateListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_simple_candidate_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkSimpleCandidateList), 0, (GInstanceInitFunc) skk_simple_candidate_list_instance_init, NULL };
	GType skk_simple_candidate_list_type_id;
	skk_simple_candidate_list_type_id = g_type_register_static (SKK_TYPE_CANDIDATE_LIST, "SkkSimpleCandidateList", &g_define_type_info, 0);
	SkkSimpleCandidateList_private_offset = g_type_add_instance_private (skk_simple_candidate_list_type_id, sizeof (SkkSimpleCandidateListPrivate));
	return skk_simple_candidate_list_type_id;
}

GType
skk_simple_candidate_list_get_type (void)
{
	static volatile gsize skk_simple_candidate_list_type_id__once = 0;
	if (g_once_init_enter (&skk_simple_candidate_list_type_id__once)) {
		GType skk_simple_candidate_list_type_id;
		skk_simple_candidate_list_type_id = skk_simple_candidate_list_get_type_once ();
		g_once_init_leave (&skk_simple_candidate_list_type_id__once, skk_simple_candidate_list_type_id);
	}
	return skk_simple_candidate_list_type_id__once;
}

static void
_vala_skk_simple_candidate_list_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SkkSimpleCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateList);
	switch (property_id) {
		case SKK_SIMPLE_CANDIDATE_LIST_CURSOR_POS_PROPERTY:
		g_value_set_int (value, skk_candidate_list_get_cursor_pos ((SkkCandidateList*) self));
		break;
		case SKK_SIMPLE_CANDIDATE_LIST_SIZE_PROPERTY:
		g_value_set_int (value, skk_candidate_list_get_size ((SkkCandidateList*) self));
		break;
		case SKK_SIMPLE_CANDIDATE_LIST_PAGE_START_PROPERTY:
		g_value_set_uint (value, skk_candidate_list_get_page_start ((SkkCandidateList*) self));
		break;
		case SKK_SIMPLE_CANDIDATE_LIST_PAGE_SIZE_PROPERTY:
		g_value_set_uint (value, skk_candidate_list_get_page_size ((SkkCandidateList*) self));
		break;
		case SKK_SIMPLE_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY:
		g_value_set_boolean (value, skk_candidate_list_get_page_visible ((SkkCandidateList*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_skk_simple_candidate_list_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SkkSimpleCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateList);
	switch (property_id) {
		case SKK_SIMPLE_CANDIDATE_LIST_PAGE_START_PROPERTY:
		skk_candidate_list_set_page_start ((SkkCandidateList*) self, g_value_get_uint (value));
		break;
		case SKK_SIMPLE_CANDIDATE_LIST_PAGE_SIZE_PROPERTY:
		skk_candidate_list_set_page_size ((SkkCandidateList*) self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
skk_proxy_candidate_list_get_instance_private (SkkProxyCandidateList* self)
{
	return G_STRUCT_MEMBER_P (self, SkkProxyCandidateList_private_offset);
}

static void
skk_proxy_candidate_list_notify_cursor_pos_cb (SkkProxyCandidateList* self,
                                               GObject* s,
                                               GParamSpec* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_object_notify ((GObject*) self, "cursor-pos");
}

static void
skk_proxy_candidate_list_populated_cb (SkkProxyCandidateList* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit ((SkkCandidateList*) self, skk_candidate_list_signals[SKK_CANDIDATE_LIST_POPULATED_SIGNAL], 0);
}

static void
skk_proxy_candidate_list_selected_cb (SkkProxyCandidateList* self,
                                      SkkCandidate* c)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_signal_emit ((SkkCandidateList*) self, skk_candidate_list_signals[SKK_CANDIDATE_LIST_SELECTED_SIGNAL], 0, c);
}

static SkkCandidate*
skk_proxy_candidate_list_real_get (SkkCandidateList* base,
                                   gint index)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidate* _tmp2_;
	SkkCandidate* result;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get (_tmp1_, index);
	result = _tmp2_;
	return result;
}

static void
skk_proxy_candidate_list_real_clear (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	skk_candidate_list_clear (_tmp1_);
}

static void
skk_proxy_candidate_list_real_add_candidates (SkkCandidateList* base,
                                              SkkCandidate** array,
                                              gint array_length1)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	skk_candidate_list_add_candidates (_tmp1_, array, (gint) array_length1);
}

static void
skk_proxy_candidate_list_real_add_candidates_end (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	skk_candidate_list_add_candidates_end (_tmp1_);
}

static gboolean
skk_proxy_candidate_list_real_select_at (SkkCandidateList* base,
                                         guint index_in_page)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gboolean result;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	result = skk_candidate_list_select_at (_tmp1_, index_in_page);
	return result;
}

static void
skk_proxy_candidate_list_real_select (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	skk_candidate_list_select (_tmp1_);
}

SkkProxyCandidateList*
skk_proxy_candidate_list_construct (GType object_type,
                                    SkkCandidateList* candidates)
{
	SkkProxyCandidateList * self = NULL;
	g_return_val_if_fail (candidates != NULL, NULL);
	self = (SkkProxyCandidateList*) skk_candidate_list_construct (object_type);
	skk_proxy_candidate_list_set_candidates (self, candidates);
	return self;
}

SkkProxyCandidateList*
skk_proxy_candidate_list_new (SkkCandidateList* candidates)
{
	return skk_proxy_candidate_list_construct (SKK_TYPE_PROXY_CANDIDATE_LIST, candidates);
}

static gboolean
skk_proxy_candidate_list_real_cursor_up (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gboolean result;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	result = skk_candidate_list_cursor_up (_tmp1_);
	return result;
}

static gboolean
skk_proxy_candidate_list_real_cursor_down (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gboolean result;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	result = skk_candidate_list_cursor_down (_tmp1_);
	return result;
}

static gboolean
skk_proxy_candidate_list_real_page_up (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gboolean result;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	result = skk_candidate_list_page_up (_tmp1_);
	return result;
}

static gboolean
skk_proxy_candidate_list_real_page_down (SkkCandidateList* base)
{
	SkkProxyCandidateList * self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gboolean result;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	result = skk_candidate_list_page_down (_tmp1_);
	return result;
}

SkkCandidateList*
skk_proxy_candidate_list_get_candidates (SkkProxyCandidateList* self)
{
	SkkCandidateList* result;
	SkkCandidateList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_candidates;
	result = _tmp0_;
	return result;
}

static void
_skk_proxy_candidate_list_notify_cursor_pos_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	skk_proxy_candidate_list_notify_cursor_pos_cb ((SkkProxyCandidateList*) self, _sender, pspec);
}

static void
_skk_proxy_candidate_list_populated_cb_skk_candidate_list_populated (SkkCandidateList* _sender,
                                                                     gpointer self)
{
	skk_proxy_candidate_list_populated_cb ((SkkProxyCandidateList*) self);
}

static void
_skk_proxy_candidate_list_selected_cb_skk_candidate_list_selected (SkkCandidateList* _sender,
                                                                   SkkCandidate* candidate,
                                                                   gpointer self)
{
	skk_proxy_candidate_list_selected_cb ((SkkProxyCandidateList*) self, candidate);
}

void
skk_proxy_candidate_list_set_candidates (SkkProxyCandidateList* self,
                                         SkkCandidateList* value)
{
	SkkCandidateList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_candidates;
	if (_tmp0_ != value) {
		SkkCandidateList* _tmp1_;
		SkkCandidateList* _tmp9_;
		SkkCandidateList* _tmp10_;
		SkkCandidateList* _tmp11_;
		SkkCandidateList* _tmp12_;
		_tmp1_ = self->priv->_candidates;
		if (_tmp1_ != NULL) {
			SkkCandidateList* _tmp2_;
			guint _tmp3_;
			GQuark _tmp4_;
			SkkCandidateList* _tmp5_;
			guint _tmp6_;
			SkkCandidateList* _tmp7_;
			guint _tmp8_;
			_tmp2_ = self->priv->_candidates;
			g_signal_parse_name ("notify::cursor-pos", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
			g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _skk_proxy_candidate_list_notify_cursor_pos_cb_g_object_notify, self);
			_tmp5_ = self->priv->_candidates;
			g_signal_parse_name ("populated", SKK_TYPE_CANDIDATE_LIST, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _skk_proxy_candidate_list_populated_cb_skk_candidate_list_populated, self);
			_tmp7_ = self->priv->_candidates;
			g_signal_parse_name ("selected", SKK_TYPE_CANDIDATE_LIST, &_tmp8_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _skk_proxy_candidate_list_selected_cb_skk_candidate_list_selected, self);
		}
		_tmp9_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_candidates);
		self->priv->_candidates = _tmp9_;
		_tmp10_ = self->priv->_candidates;
		g_signal_connect_object ((GObject*) _tmp10_, "notify::cursor-pos", (GCallback) _skk_proxy_candidate_list_notify_cursor_pos_cb_g_object_notify, self, 0);
		_tmp11_ = self->priv->_candidates;
		g_signal_connect_object (_tmp11_, "populated", (GCallback) _skk_proxy_candidate_list_populated_cb_skk_candidate_list_populated, self, 0);
		_tmp12_ = self->priv->_candidates;
		g_signal_connect_object (_tmp12_, "selected", (GCallback) _skk_proxy_candidate_list_selected_cb_skk_candidate_list_selected, self, 0);
		g_signal_emit ((SkkCandidateList*) self, skk_candidate_list_signals[SKK_CANDIDATE_LIST_POPULATED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_CANDIDATES_PROPERTY]);
}

static gint
skk_proxy_candidate_list_real_get_cursor_pos (SkkCandidateList* base)
{
	gint result;
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_cursor_pos (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static gint
skk_proxy_candidate_list_real_get_size (SkkCandidateList* base)
{
	gint result;
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static guint
skk_proxy_candidate_list_real_get_page_start (SkkCandidateList* base)
{
	guint result;
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_page_start (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
skk_proxy_candidate_list_real_set_page_start (SkkCandidateList* base,
                                              guint value)
{
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	skk_candidate_list_set_page_start (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_PAGE_START_PROPERTY]);
}

static guint
skk_proxy_candidate_list_real_get_page_size (SkkCandidateList* base)
{
	guint result;
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_page_size (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
skk_proxy_candidate_list_real_set_page_size (SkkCandidateList* base,
                                             guint value)
{
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	skk_candidate_list_set_page_size (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_PAGE_SIZE_PROPERTY]);
}

static gboolean
skk_proxy_candidate_list_real_get_page_visible (SkkCandidateList* base)
{
	gboolean result;
	SkkProxyCandidateList* self;
	SkkCandidateList* _tmp0_;
	SkkCandidateList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (SkkProxyCandidateList*) base;
	_tmp0_ = skk_proxy_candidate_list_get_candidates (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_candidate_list_get_page_visible (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
skk_proxy_candidate_list_class_init (SkkProxyCandidateListClass * klass,
                                     gpointer klass_data)
{
	skk_proxy_candidate_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkProxyCandidateList_private_offset);
	((SkkCandidateListClass *) klass)->get = (SkkCandidate* (*) (SkkCandidateList*, gint)) skk_proxy_candidate_list_real_get;
	((SkkCandidateListClass *) klass)->clear = (void (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_clear;
	((SkkCandidateListClass *) klass)->add_candidates = (void (*) (SkkCandidateList*, SkkCandidate**, gint)) skk_proxy_candidate_list_real_add_candidates;
	((SkkCandidateListClass *) klass)->add_candidates_end = (void (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_add_candidates_end;
	((SkkCandidateListClass *) klass)->select_at = (gboolean (*) (SkkCandidateList*, guint)) skk_proxy_candidate_list_real_select_at;
	((SkkCandidateListClass *) klass)->select = (void (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_select;
	((SkkCandidateListClass *) klass)->cursor_up = (gboolean (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_cursor_up;
	((SkkCandidateListClass *) klass)->cursor_down = (gboolean (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_cursor_down;
	((SkkCandidateListClass *) klass)->page_up = (gboolean (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_page_up;
	((SkkCandidateListClass *) klass)->page_down = (gboolean (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_page_down;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_cursor_pos = (gint (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_get_cursor_pos;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_size = (gint (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_get_size;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_page_start = (guint (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_get_page_start;
	SKK_CANDIDATE_LIST_CLASS (klass)->set_page_start = (void (*) (SkkCandidateList*, guint)) skk_proxy_candidate_list_real_set_page_start;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_page_size = (guint (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_get_page_size;
	SKK_CANDIDATE_LIST_CLASS (klass)->set_page_size = (void (*) (SkkCandidateList*, guint)) skk_proxy_candidate_list_real_set_page_size;
	SKK_CANDIDATE_LIST_CLASS (klass)->get_page_visible = (gboolean (*) (SkkCandidateList*)) skk_proxy_candidate_list_real_get_page_visible;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_proxy_candidate_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_proxy_candidate_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_proxy_candidate_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_PROXY_CANDIDATE_LIST_CANDIDATES_PROPERTY, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_CANDIDATES_PROPERTY] = g_param_spec_object ("candidates", "candidates", "candidates", SKK_TYPE_CANDIDATE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_PROXY_CANDIDATE_LIST_CURSOR_POS_PROPERTY, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_CURSOR_POS_PROPERTY] = g_param_spec_int ("cursor-pos", "cursor-pos", "cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_PROXY_CANDIDATE_LIST_SIZE_PROPERTY, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_PROXY_CANDIDATE_LIST_PAGE_START_PROPERTY, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_PAGE_START_PROPERTY] = g_param_spec_uint ("page-start", "page-start", "page-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_PROXY_CANDIDATE_LIST_PAGE_SIZE_PROPERTY, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_PAGE_SIZE_PROPERTY] = g_param_spec_uint ("page-size", "page-size", "page-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_PROXY_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY, skk_proxy_candidate_list_properties[SKK_PROXY_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY] = g_param_spec_boolean ("page-visible", "page-visible", "page-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_proxy_candidate_list_instance_init (SkkProxyCandidateList * self,
                                        gpointer klass)
{
	self->priv = skk_proxy_candidate_list_get_instance_private (self);
}

static void
skk_proxy_candidate_list_finalize (GObject * obj)
{
	SkkProxyCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_PROXY_CANDIDATE_LIST, SkkProxyCandidateList);
	_g_object_unref0 (self->priv->_candidates);
	G_OBJECT_CLASS (skk_proxy_candidate_list_parent_class)->finalize (obj);
}

static GType
skk_proxy_candidate_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkProxyCandidateListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_proxy_candidate_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkProxyCandidateList), 0, (GInstanceInitFunc) skk_proxy_candidate_list_instance_init, NULL };
	GType skk_proxy_candidate_list_type_id;
	skk_proxy_candidate_list_type_id = g_type_register_static (SKK_TYPE_CANDIDATE_LIST, "SkkProxyCandidateList", &g_define_type_info, 0);
	SkkProxyCandidateList_private_offset = g_type_add_instance_private (skk_proxy_candidate_list_type_id, sizeof (SkkProxyCandidateListPrivate));
	return skk_proxy_candidate_list_type_id;
}

GType
skk_proxy_candidate_list_get_type (void)
{
	static volatile gsize skk_proxy_candidate_list_type_id__once = 0;
	if (g_once_init_enter (&skk_proxy_candidate_list_type_id__once)) {
		GType skk_proxy_candidate_list_type_id;
		skk_proxy_candidate_list_type_id = skk_proxy_candidate_list_get_type_once ();
		g_once_init_leave (&skk_proxy_candidate_list_type_id__once, skk_proxy_candidate_list_type_id);
	}
	return skk_proxy_candidate_list_type_id__once;
}

static void
_vala_skk_proxy_candidate_list_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SkkProxyCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_PROXY_CANDIDATE_LIST, SkkProxyCandidateList);
	switch (property_id) {
		case SKK_PROXY_CANDIDATE_LIST_CANDIDATES_PROPERTY:
		g_value_set_object (value, skk_proxy_candidate_list_get_candidates (self));
		break;
		case SKK_PROXY_CANDIDATE_LIST_CURSOR_POS_PROPERTY:
		g_value_set_int (value, skk_candidate_list_get_cursor_pos ((SkkCandidateList*) self));
		break;
		case SKK_PROXY_CANDIDATE_LIST_SIZE_PROPERTY:
		g_value_set_int (value, skk_candidate_list_get_size ((SkkCandidateList*) self));
		break;
		case SKK_PROXY_CANDIDATE_LIST_PAGE_START_PROPERTY:
		g_value_set_uint (value, skk_candidate_list_get_page_start ((SkkCandidateList*) self));
		break;
		case SKK_PROXY_CANDIDATE_LIST_PAGE_SIZE_PROPERTY:
		g_value_set_uint (value, skk_candidate_list_get_page_size ((SkkCandidateList*) self));
		break;
		case SKK_PROXY_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY:
		g_value_set_boolean (value, skk_candidate_list_get_page_visible ((SkkCandidateList*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_skk_proxy_candidate_list_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SkkProxyCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_PROXY_CANDIDATE_LIST, SkkProxyCandidateList);
	switch (property_id) {
		case SKK_PROXY_CANDIDATE_LIST_CANDIDATES_PROPERTY:
		skk_proxy_candidate_list_set_candidates (self, g_value_get_object (value));
		break;
		case SKK_PROXY_CANDIDATE_LIST_PAGE_START_PROPERTY:
		skk_candidate_list_set_page_start ((SkkCandidateList*) self, g_value_get_uint (value));
		break;
		case SKK_PROXY_CANDIDATE_LIST_PAGE_SIZE_PROPERTY:
		skk_candidate_list_set_page_size ((SkkCandidateList*) self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

