        #include <cmrc/cmrc.hpp>
#include <map>
#include <utility>

namespace cmrc {
namespace rc {

namespace res_chars {
// These are the files which are available in this resource library
// Pointers to cal/test.cal
extern const char* const f_a280_cal_test_cal_begin;
extern const char* const f_a280_cal_test_cal_end;
// Pointers to cal/x4xx_pwr_zbx_tx_0_tx+rx0.cal
extern const char* const f_24a7_cal_x4xx_pwr_zbx_tx_0_tx_rx0_cal_begin;
extern const char* const f_24a7_cal_x4xx_pwr_zbx_tx_0_tx_rx0_cal_end;
// Pointers to cal/x4xx_pwr_zbx_tx_1_tx+rx0.cal
extern const char* const f_4abb_cal_x4xx_pwr_zbx_tx_1_tx_rx0_cal_begin;
extern const char* const f_4abb_cal_x4xx_pwr_zbx_tx_1_tx_rx0_cal_end;
// Pointers to cal/x4xx_pwr_zbx_rx_0_tx+rx0.cal
extern const char* const f_6c65_cal_x4xx_pwr_zbx_rx_0_tx_rx0_cal_begin;
extern const char* const f_6c65_cal_x4xx_pwr_zbx_rx_0_tx_rx0_cal_end;
// Pointers to cal/x4xx_pwr_zbx_rx_1_tx+rx0.cal
extern const char* const f_e0d7_cal_x4xx_pwr_zbx_rx_1_tx_rx0_cal_begin;
extern const char* const f_e0d7_cal_x4xx_pwr_zbx_rx_1_tx_rx0_cal_end;
// Pointers to cal/x4xx_pwr_zbx_rx_0_rx1.cal
extern const char* const f_d59a_cal_x4xx_pwr_zbx_rx_0_rx1_cal_begin;
extern const char* const f_d59a_cal_x4xx_pwr_zbx_rx_0_rx1_cal_end;
// Pointers to cal/x4xx_pwr_zbx_rx_1_rx1.cal
extern const char* const f_6480_cal_x4xx_pwr_zbx_rx_1_rx1_cal_begin;
extern const char* const f_6480_cal_x4xx_pwr_zbx_rx_1_rx1_cal_end;
// Pointers to cal/zbx_dsa_tx.cal
extern const char* const f_766e_cal_zbx_dsa_tx_cal_begin;
extern const char* const f_766e_cal_zbx_dsa_tx_cal_end;
// Pointers to cal/zbx_dsa_rx.cal
extern const char* const f_9a48_cal_zbx_dsa_rx_cal_begin;
extern const char* const f_9a48_cal_zbx_dsa_rx_cal_end;
}

namespace {

const cmrc::detail::index_type&
get_root_index() {
    static cmrc::detail::directory root_directory_;
    static cmrc::detail::file_or_directory root_directory_fod{root_directory_};
    static cmrc::detail::index_type root_index;
    root_index.emplace("", &root_directory_fod);
    struct dir_inl {
        class cmrc::detail::directory& directory;
    };
    dir_inl root_directory_dir{root_directory_};
    (void)root_directory_dir;
    static auto f_912b_cal_dir = root_directory_dir.directory.add_subdir("cal");
    root_index.emplace("cal", &f_912b_cal_dir.index_entry);
    root_index.emplace(
        "cal/test.cal",
        f_912b_cal_dir.directory.add_file(
            "test.cal",
            res_chars::f_a280_cal_test_cal_begin,
            res_chars::f_a280_cal_test_cal_end
        )
    );
    root_index.emplace(
        "cal/x4xx_pwr_zbx_tx_0_tx+rx0.cal",
        f_912b_cal_dir.directory.add_file(
            "x4xx_pwr_zbx_tx_0_tx+rx0.cal",
            res_chars::f_24a7_cal_x4xx_pwr_zbx_tx_0_tx_rx0_cal_begin,
            res_chars::f_24a7_cal_x4xx_pwr_zbx_tx_0_tx_rx0_cal_end
        )
    );
    root_index.emplace(
        "cal/x4xx_pwr_zbx_tx_1_tx+rx0.cal",
        f_912b_cal_dir.directory.add_file(
            "x4xx_pwr_zbx_tx_1_tx+rx0.cal",
            res_chars::f_4abb_cal_x4xx_pwr_zbx_tx_1_tx_rx0_cal_begin,
            res_chars::f_4abb_cal_x4xx_pwr_zbx_tx_1_tx_rx0_cal_end
        )
    );
    root_index.emplace(
        "cal/x4xx_pwr_zbx_rx_0_tx+rx0.cal",
        f_912b_cal_dir.directory.add_file(
            "x4xx_pwr_zbx_rx_0_tx+rx0.cal",
            res_chars::f_6c65_cal_x4xx_pwr_zbx_rx_0_tx_rx0_cal_begin,
            res_chars::f_6c65_cal_x4xx_pwr_zbx_rx_0_tx_rx0_cal_end
        )
    );
    root_index.emplace(
        "cal/x4xx_pwr_zbx_rx_1_tx+rx0.cal",
        f_912b_cal_dir.directory.add_file(
            "x4xx_pwr_zbx_rx_1_tx+rx0.cal",
            res_chars::f_e0d7_cal_x4xx_pwr_zbx_rx_1_tx_rx0_cal_begin,
            res_chars::f_e0d7_cal_x4xx_pwr_zbx_rx_1_tx_rx0_cal_end
        )
    );
    root_index.emplace(
        "cal/x4xx_pwr_zbx_rx_0_rx1.cal",
        f_912b_cal_dir.directory.add_file(
            "x4xx_pwr_zbx_rx_0_rx1.cal",
            res_chars::f_d59a_cal_x4xx_pwr_zbx_rx_0_rx1_cal_begin,
            res_chars::f_d59a_cal_x4xx_pwr_zbx_rx_0_rx1_cal_end
        )
    );
    root_index.emplace(
        "cal/x4xx_pwr_zbx_rx_1_rx1.cal",
        f_912b_cal_dir.directory.add_file(
            "x4xx_pwr_zbx_rx_1_rx1.cal",
            res_chars::f_6480_cal_x4xx_pwr_zbx_rx_1_rx1_cal_begin,
            res_chars::f_6480_cal_x4xx_pwr_zbx_rx_1_rx1_cal_end
        )
    );
    root_index.emplace(
        "cal/zbx_dsa_tx.cal",
        f_912b_cal_dir.directory.add_file(
            "zbx_dsa_tx.cal",
            res_chars::f_766e_cal_zbx_dsa_tx_cal_begin,
            res_chars::f_766e_cal_zbx_dsa_tx_cal_end
        )
    );
    root_index.emplace(
        "cal/zbx_dsa_rx.cal",
        f_912b_cal_dir.directory.add_file(
            "zbx_dsa_rx.cal",
            res_chars::f_9a48_cal_zbx_dsa_rx_cal_begin,
            res_chars::f_9a48_cal_zbx_dsa_rx_cal_end
        )
    );
    return root_index;
}

}

cmrc::embedded_filesystem get_filesystem() {
    static auto& index = get_root_index();
    return cmrc::embedded_filesystem{index};
}

} // rc
} // cmrc
    