/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: RockAttrDefs.td                                                      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace rock {
// The type of a convolution operation
enum class ConvOpType : uint32_t {
  Fwd = 0,
  BwdData = 1,
  BwdWeight = 2,
};

::std::optional<ConvOpType> symbolizeConvOpType(uint32_t);
::llvm::StringRef getNameForConvOpType(ConvOpType);
::std::optional<ConvOpType> getConvOpTypeForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForConvOpType() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(ConvOpType enumValue) {
  return getNameForConvOpType(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<ConvOpType> symbolizeEnum<ConvOpType>(::llvm::StringRef str) {
  return getConvOpTypeForName(str);
}
} // namespace rock
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::rock::ConvOpType, ::mlir::rock::ConvOpType> {
  template <typename ParserT>
  static FailureOr<::mlir::rock::ConvOpType> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The type of a convolution operation");

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::ConvOpType> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::ConvOpType>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [conv, conv_bwd_data, conv_bwd_weight] for The type of a convolution operation, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::rock::ConvOpType>, std::optional<::mlir::rock::ConvOpType>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::rock::ConvOpType>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::rock::ConvOpType>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::ConvOpType> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::ConvOpType>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [conv, conv_bwd_data, conv_bwd_weight] for The type of a convolution operation, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::rock::ConvOpType value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::rock::ConvOpType> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::rock::ConvOpType getEmptyKey() {
    return static_cast<::mlir::rock::ConvOpType>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::rock::ConvOpType getTombstoneKey() {
    return static_cast<::mlir::rock::ConvOpType>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::rock::ConvOpType &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::rock::ConvOpType &lhs, const ::mlir::rock::ConvOpType &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace rock {
// Any of the possible types of a rock kernel
enum class KernelType : uint32_t {
  Conv = 0,
  ConvBwdData = 1,
  ConvBwdWeight = 2,
  Gemm = 3,
  Attention = 4,
  GemmElementwiseGemm = 5,
  ConvElementwiseGemm = 6,
};

::std::optional<KernelType> symbolizeKernelType(uint32_t);
::llvm::StringRef getNameForKernelType(KernelType);
::std::optional<KernelType> getKernelTypeForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForKernelType() {
  return 6;
}


inline ::llvm::StringRef stringifyEnum(KernelType enumValue) {
  return getNameForKernelType(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<KernelType> symbolizeEnum<KernelType>(::llvm::StringRef str) {
  return getKernelTypeForName(str);
}
} // namespace rock
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::rock::KernelType, ::mlir::rock::KernelType> {
  template <typename ParserT>
  static FailureOr<::mlir::rock::KernelType> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for Any of the possible types of a rock kernel");

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::KernelType> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::KernelType>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [Conv, ConvBwdData, ConvBwdWeight, Gemm, Attention, GemmElementwiseGemm, ConvElementwiseGemm] for Any of the possible types of a rock kernel, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::rock::KernelType>, std::optional<::mlir::rock::KernelType>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::rock::KernelType>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::rock::KernelType>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::KernelType> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::KernelType>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [Conv, ConvBwdData, ConvBwdWeight, Gemm, Attention, GemmElementwiseGemm, ConvElementwiseGemm] for Any of the possible types of a rock kernel, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::rock::KernelType value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::rock::KernelType> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::rock::KernelType getEmptyKey() {
    return static_cast<::mlir::rock::KernelType>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::rock::KernelType getTombstoneKey() {
    return static_cast<::mlir::rock::KernelType>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::rock::KernelType &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::rock::KernelType &lhs, const ::mlir::rock::KernelType &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace rock {
// What operation should be used for the reduction
enum class ReduceMethod : uint32_t {
  Sum = 0,
  Max = 1,
};

::std::optional<ReduceMethod> symbolizeReduceMethod(uint32_t);
::llvm::StringRef getNameForReduceMethod(ReduceMethod);
::std::optional<ReduceMethod> getReduceMethodForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForReduceMethod() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(ReduceMethod enumValue) {
  return getNameForReduceMethod(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<ReduceMethod> symbolizeEnum<ReduceMethod>(::llvm::StringRef str) {
  return getReduceMethodForName(str);
}
} // namespace rock
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::rock::ReduceMethod, ::mlir::rock::ReduceMethod> {
  template <typename ParserT>
  static FailureOr<::mlir::rock::ReduceMethod> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for What operation should be used for the reduction");

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::ReduceMethod> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::ReduceMethod>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [sum, max] for What operation should be used for the reduction, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::rock::ReduceMethod>, std::optional<::mlir::rock::ReduceMethod>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::rock::ReduceMethod>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::rock::ReduceMethod>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::ReduceMethod> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::ReduceMethod>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [sum, max] for What operation should be used for the reduction, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::rock::ReduceMethod value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::rock::ReduceMethod> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::rock::ReduceMethod getEmptyKey() {
    return static_cast<::mlir::rock::ReduceMethod>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::rock::ReduceMethod getTombstoneKey() {
    return static_cast<::mlir::rock::ReduceMethod>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::rock::ReduceMethod &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::rock::ReduceMethod &lhs, const ::mlir::rock::ReduceMethod &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace rock {
// Features that can be enabled on GEMM-based operations
enum class GemmFeatures : uint32_t {
  none = 0,
  mfma = 1,
  wmma = 2,
  dot = 4,
  atomic_add = 8,
  atomic_add_bf16 = 16,
  atomic_add_f16 = 32,
  atomic_fmax_f32 = 64,
  direct_to_lds_32b = 128,
  direct_to_lds_128b = 256,
};

::std::optional<GemmFeatures> symbolizeGemmFeatures(uint32_t);
std::string stringifyGemmFeatures(GemmFeatures);
::std::optional<GemmFeatures> symbolizeGemmFeatures(::llvm::StringRef);

inline constexpr GemmFeatures operator|(GemmFeatures a, GemmFeatures b) {
  return static_cast<GemmFeatures>(static_cast<uint32_t>(a) | static_cast<uint32_t>(b));
}
inline constexpr GemmFeatures operator&(GemmFeatures a, GemmFeatures b) {
  return static_cast<GemmFeatures>(static_cast<uint32_t>(a) & static_cast<uint32_t>(b));
}
inline constexpr GemmFeatures operator^(GemmFeatures a, GemmFeatures b) {
  return static_cast<GemmFeatures>(static_cast<uint32_t>(a) ^ static_cast<uint32_t>(b));
}
inline constexpr GemmFeatures operator~(GemmFeatures bits) {
  // Ensure only bits that can be present in the enum are set
  return static_cast<GemmFeatures>(~static_cast<uint32_t>(bits) & static_cast<uint32_t>(511u));
}
inline constexpr bool bitEnumContainsAll(GemmFeatures bits, GemmFeatures bit) {
  return (bits & bit) == bit;
}
inline constexpr bool bitEnumContainsAny(GemmFeatures bits, GemmFeatures bit) {
  return (static_cast<uint32_t>(bits) & static_cast<uint32_t>(bit)) != 0;
}
inline constexpr GemmFeatures bitEnumClear(GemmFeatures bits, GemmFeatures bit) {
  return bits & ~bit;
}
inline constexpr GemmFeatures bitEnumSet(GemmFeatures bits, GemmFeatures bit, /*optional*/bool value=true) {
  return value ? (bits | bit) : bitEnumClear(bits, bit);
}
  
inline std::string stringifyEnum(GemmFeatures enumValue) {
  return stringifyGemmFeatures(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<GemmFeatures> symbolizeEnum<GemmFeatures>(::llvm::StringRef str) {
  return symbolizeGemmFeatures(str);
}
} // namespace rock
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::rock::GemmFeatures, ::mlir::rock::GemmFeatures> {
  template <typename ParserT>
  static FailureOr<::mlir::rock::GemmFeatures> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for Features that can be enabled on GEMM-based operations");

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::GemmFeatures> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::GemmFeatures>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [none, mfma, wmma, dot, atomic_add, atomic_add_bf16, atomic_add_f16, atomic_fmax_f32, direct_to_lds_32b, direct_to_lds_128b] for Features that can be enabled on GEMM-based operations, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::rock::GemmFeatures>, std::optional<::mlir::rock::GemmFeatures>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::rock::GemmFeatures>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::rock::GemmFeatures>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::GemmFeatures> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::GemmFeatures>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [none, mfma, wmma, dot, atomic_add, atomic_add_bf16, atomic_add_f16, atomic_fmax_f32, direct_to_lds_32b, direct_to_lds_128b] for Features that can be enabled on GEMM-based operations, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::rock::GemmFeatures value) {
  auto valueStr = stringifyEnum(value);
  auto underlyingValue = static_cast<std::make_unsigned_t<::mlir::rock::GemmFeatures>>(value);
  if (underlyingValue && !llvm::has_single_bit(underlyingValue))
    return p << '"' << valueStr << '"';
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::rock::GemmFeatures> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::rock::GemmFeatures getEmptyKey() {
    return static_cast<::mlir::rock::GemmFeatures>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::rock::GemmFeatures getTombstoneKey() {
    return static_cast<::mlir::rock::GemmFeatures>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::rock::GemmFeatures &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::rock::GemmFeatures &lhs, const ::mlir::rock::GemmFeatures &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace rock {
// What operation should be used to write data to memory
enum class StoreMethod : uint32_t {
  Set = 0,
  AtomicAdd = 1,
  AtomicMax = 2,
};

::std::optional<StoreMethod> symbolizeStoreMethod(uint32_t);
::llvm::StringRef getNameForStoreMethod(StoreMethod);
::std::optional<StoreMethod> getStoreMethodForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForStoreMethod() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(StoreMethod enumValue) {
  return getNameForStoreMethod(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<StoreMethod> symbolizeEnum<StoreMethod>(::llvm::StringRef str) {
  return getStoreMethodForName(str);
}
} // namespace rock
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::rock::StoreMethod, ::mlir::rock::StoreMethod> {
  template <typename ParserT>
  static FailureOr<::mlir::rock::StoreMethod> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for What operation should be used to write data to memory");

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::StoreMethod> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::StoreMethod>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [set, atomic_add, atomic_max] for What operation should be used to write data to memory, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::rock::StoreMethod>, std::optional<::mlir::rock::StoreMethod>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::rock::StoreMethod>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::rock::StoreMethod>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::StoreMethod> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::StoreMethod>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [set, atomic_add, atomic_max] for What operation should be used to write data to memory, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::rock::StoreMethod value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::rock::StoreMethod> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::rock::StoreMethod getEmptyKey() {
    return static_cast<::mlir::rock::StoreMethod>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::rock::StoreMethod getTombstoneKey() {
    return static_cast<::mlir::rock::StoreMethod>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::rock::StoreMethod &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::rock::StoreMethod &lhs, const ::mlir::rock::StoreMethod &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace rock {
// The operation type for a coordinate transformation
enum class TransformType : uint32_t {
  PassThrough = 0,
  Pad = 1,
  Slice = 2,
  Embed = 3,
  Unmerge = 4,
  Merge = 5,
  AddDim = 7,
  Broadcast = 8,
  ConstDim = 9,
};

::std::optional<TransformType> symbolizeTransformType(uint32_t);
::llvm::StringRef getNameForTransformType(TransformType);
::std::optional<TransformType> getTransformTypeForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTransformType() {
  return 9;
}


inline ::llvm::StringRef stringifyEnum(TransformType enumValue) {
  return getNameForTransformType(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<TransformType> symbolizeEnum<TransformType>(::llvm::StringRef str) {
  return getTransformTypeForName(str);
}
} // namespace rock
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::rock::TransformType, ::mlir::rock::TransformType> {
  template <typename ParserT>
  static FailureOr<::mlir::rock::TransformType> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The operation type for a coordinate transformation");

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::TransformType> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::TransformType>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [PassThrough, Pad, Slice, Embed, Unmerge, Merge, AddDim, Broadcast, ConstDim] for The operation type for a coordinate transformation, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::rock::TransformType>, std::optional<::mlir::rock::TransformType>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::rock::TransformType>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::rock::TransformType>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::rock::TransformType> attr = ::mlir::rock::symbolizeEnum<::mlir::rock::TransformType>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [PassThrough, Pad, Slice, Embed, Unmerge, Merge, AddDim, Broadcast, ConstDim] for The operation type for a coordinate transformation, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::rock::TransformType value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::rock::TransformType> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::rock::TransformType getEmptyKey() {
    return static_cast<::mlir::rock::TransformType>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::rock::TransformType getTombstoneKey() {
    return static_cast<::mlir::rock::TransformType>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::rock::TransformType &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::rock::TransformType &lhs, const ::mlir::rock::TransformType &rhs) {
    return lhs == rhs;
  }
};
}

