static const struct { const char *name; OptIndex opt_idx; } option_hash_elems[] = {
  { .name = "ea", .opt_idx = kOptEqualalways },
  { .name = "ma", .opt_idx = kOptModifiable },
  { .name = "wa", .opt_idx = kOptWriteany },
  { .name = "pa", .opt_idx = kOptPath },
  { .name = "cb", .opt_idx = kOptClipboard },
  { .name = "eb", .opt_idx = kOptErrorbells },
  { .name = "sb", .opt_idx = kOptSplitbelow },
  { .name = "vb", .opt_idx = kOptVisualbell },
  { .name = "wb", .opt_idx = kOptWritebackup },
  { .name = "pb", .opt_idx = kOptPumblend },
  { .name = "sc", .opt_idx = kOptShowcmd },
  { .name = "wc", .opt_idx = kOptWildchar },
  { .name = "uc", .opt_idx = kOptUpdatecount },
  { .name = "cc", .opt_idx = kOptColorcolumn },
  { .name = "tc", .opt_idx = kOptTagcase },
  { .name = "ic", .opt_idx = kOptIgnorecase },
  { .name = "ed", .opt_idx = kOptEdcompatible },
  { .name = "sd", .opt_idx = kOptShada },
  { .name = "gd", .opt_idx = kOptGdefault },
  { .name = "cd", .opt_idx = kOptCdpath },
  { .name = "wd", .opt_idx = kOptWritedelay },
  { .name = "qe", .opt_idx = kOptQuoteescape },
  { .name = "re", .opt_idx = kOptRegexpengine },
  { .name = "ve", .opt_idx = kOptVirtualedit },
  { .name = "ef", .opt_idx = kOptErrorfile },
  { .name = "tf", .opt_idx = kOptTtyfast },
  { .name = "cf", .opt_idx = kOptConfirm },
  { .name = "hf", .opt_idx = kOptHelpfile },
  { .name = "ff", .opt_idx = kOptFileformat },
  { .name = "nf", .opt_idx = kOptNrformats },
  { .name = "dg", .opt_idx = kOptDigraph },
  { .name = "bg", .opt_idx = kOptBackground },
  { .name = "mh", .opt_idx = kOptMousehide },
  { .name = "sh", .opt_idx = kOptShell },
  { .name = "hh", .opt_idx = kOptHelpheight },
  { .name = "ph", .opt_idx = kOptPumheight },
  { .name = "bh", .opt_idx = kOptBufhidden },
  { .name = "ch", .opt_idx = kOptCmdheight },
  { .name = "wh", .opt_idx = kOptWinheight },
  { .name = "ei", .opt_idx = kOptEventignore },
  { .name = "vi", .opt_idx = kOptShada },
  { .name = "pi", .opt_idx = kOptPreserveindent },
  { .name = "hi", .opt_idx = kOptHistory },
  { .name = "ri", .opt_idx = kOptRevins },
  { .name = "wi", .opt_idx = kOptWindow },
  { .name = "si", .opt_idx = kOptSmartindent },
  { .name = "ci", .opt_idx = kOptCopyindent },
  { .name = "ai", .opt_idx = kOptAutoindent },
  { .name = "sj", .opt_idx = kOptScrolljump },
  { .name = "bk", .opt_idx = kOptBackup },
  { .name = "hk", .opt_idx = kOptHkmap },
  { .name = "tl", .opt_idx = kOptTaglength },
  { .name = "bl", .opt_idx = kOptBuflisted },
  { .name = "ml", .opt_idx = kOptModeline },
  { .name = "rl", .opt_idx = kOptRightleft },
  { .name = "ul", .opt_idx = kOptUndolevels },
  { .name = "al", .opt_idx = kOptAleph },
  { .name = "hl", .opt_idx = kOptHighlight },
  { .name = "km", .opt_idx = kOptKeymodel },
  { .name = "sm", .opt_idx = kOptShowmatch },
  { .name = "wm", .opt_idx = kOptWrapmargin },
  { .name = "tm", .opt_idx = kOptTimeoutlen },
  { .name = "pm", .opt_idx = kOptPatchmode },
  { .name = "lm", .opt_idx = kOptLangmenu },
  { .name = "im", .opt_idx = kOptInsertmode },
  { .name = "bo", .opt_idx = kOptBelloff },
  { .name = "so", .opt_idx = kOptScrolloff },
  { .name = "co", .opt_idx = kOptColumns },
  { .name = "to", .opt_idx = kOptTimeout },
  { .name = "go", .opt_idx = kOptGuioptions },
  { .name = "ro", .opt_idx = kOptReadonly },
  { .name = "fo", .opt_idx = kOptFormatoptions },
  { .name = "ep", .opt_idx = kOptEqualprg },
  { .name = "fp", .opt_idx = kOptFormatprg },
  { .name = "gp", .opt_idx = kOptGrepprg },
  { .name = "sp", .opt_idx = kOptShellpipe },
  { .name = "mp", .opt_idx = kOptMakeprg },
  { .name = "cp", .opt_idx = kOptCompatible },
  { .name = "kp", .opt_idx = kOptKeywordprg },
  { .name = "pp", .opt_idx = kOptPackpath },
  { .name = "ar", .opt_idx = kOptAutoread },
  { .name = "sr", .opt_idx = kOptShiftround },
  { .name = "tr", .opt_idx = kOptTagrelative },
  { .name = "ur", .opt_idx = kOptUndoreload },
  { .name = "fs", .opt_idx = kOptFsync },
  { .name = "ws", .opt_idx = kOptWrapscan },
  { .name = "ts", .opt_idx = kOptTabstop },
  { .name = "ss", .opt_idx = kOptSidescroll },
  { .name = "bs", .opt_idx = kOptBackspace },
  { .name = "ls", .opt_idx = kOptLaststatus },
  { .name = "is", .opt_idx = kOptIncsearch },
  { .name = "js", .opt_idx = kOptJoinspaces },
  { .name = "et", .opt_idx = kOptExpandtab },
  { .name = "ft", .opt_idx = kOptFiletype },
  { .name = "bt", .opt_idx = kOptBuftype },
  { .name = "ut", .opt_idx = kOptUpdatetime },
  { .name = "pt", .opt_idx = kOptPastetoggle },
  { .name = "su", .opt_idx = kOptSuffixes },
  { .name = "ru", .opt_idx = kOptRuler },
  { .name = "nu", .opt_idx = kOptNumber },
  { .name = "aw", .opt_idx = kOptAutowrite },
  { .name = "sw", .opt_idx = kOptShiftwidth },
  { .name = "ww", .opt_idx = kOptWhichwrap },
  { .name = "tw", .opt_idx = kOptTextwidth },
  { .name = "lw", .opt_idx = kOptLispwords },
  { .name = "pw", .opt_idx = kOptPumwidth },
  { .name = "ex", .opt_idx = kOptExrc },
  { .name = "dy", .opt_idx = kOptDisplay },
  { .name = "lz", .opt_idx = kOptLazyredraw },
  { .name = "awa", .opt_idx = kOptAutowriteall },
  { .name = "cia", .opt_idx = kOptCompleteitemalign },
  { .name = "sua", .opt_idx = kOptSuffixesadd },
  { .name = "sta", .opt_idx = kOptSmarttab },
  { .name = "crb", .opt_idx = kOptCursorbind },
  { .name = "rdb", .opt_idx = kOptRedrawdebug },
  { .name = "wfb", .opt_idx = kOptWinfixbuf },
  { .name = "scb", .opt_idx = kOptScrollbind },
  { .name = "swb", .opt_idx = kOptSwitchbuf },
  { .name = "bkc", .opt_idx = kOptBackupcopy },
  { .name = "cuc", .opt_idx = kOptCursorcolumn },
  { .name = "enc", .opt_idx = kOptEncoding },
  { .name = "imc", .opt_idx = kOptImcmdline },
  { .name = "fic", .opt_idx = kOptFileignorecase },
  { .name = "smc", .opt_idx = kOptSynmaxcol },
  { .name = "fdc", .opt_idx = kOptFoldcolumn },
  { .name = "tgc", .opt_idx = kOptTermguicolors },
  { .name = "wic", .opt_idx = kOptWildignorecase },
  { .name = "stc", .opt_idx = kOptStatuscolumn },
  { .name = "spc", .opt_idx = kOptSpellcapcheck },
  { .name = "inc", .opt_idx = kOptInclude },
  { .name = "rlc", .opt_idx = kOptRightleftcmd },
  { .name = "acd", .opt_idx = kOptAutochdir },
  { .name = "ead", .opt_idx = kOptEadirection },
  { .name = "smd", .opt_idx = kOptShowmode },
  { .name = "mod", .opt_idx = kOptModified },
  { .name = "hid", .opt_idx = kOptHidden },
  { .name = "mfd", .opt_idx = kOptMaxfuncdepth },
  { .name = "imd", .opt_idx = kOptImdisable },
  { .name = "mmd", .opt_idx = kOptMaxmapdepth },
  { .name = "sxe", .opt_idx = kOptShellxescape },
  { .name = "fde", .opt_idx = kOptFoldexpr },
  { .name = "mle", .opt_idx = kOptModelineexpr },
  { .name = "def", .opt_idx = kOptDefine },
  { .name = "eof", .opt_idx = kOptEndoffile },
  { .name = "sdf", .opt_idx = kOptShadafile },
  { .name = "vif", .opt_idx = kOptShadafile },
  { .name = "spf", .opt_idx = kOptSpellfile },
  { .name = "tpf", .opt_idx = kOptTermpastefilter },
  { .name = "mef", .opt_idx = kOptMakeef },
  { .name = "ruf", .opt_idx = kOptRulerformat },
  { .name = "udf", .opt_idx = kOptUndofile },
  { .name = "swf", .opt_idx = kOptSwapfile },
  { .name = "isf", .opt_idx = kOptIsfname },
  { .name = "inf", .opt_idx = kOptInfercase },
  { .name = "tag", .opt_idx = kOptTags },
  { .name = "wig", .opt_idx = kOptWildignore },
  { .name = "hlg", .opt_idx = kOptHelplang },
  { .name = "pvh", .opt_idx = kOptPreviewheight },
  { .name = "cdh", .opt_idx = kOptCdhome },
  { .name = "cwh", .opt_idx = kOptCmdwinheight },
  { .name = "wfh", .opt_idx = kOptWinfixheight },
  { .name = "wmh", .opt_idx = kOptWinminheight },
  { .name = "fdi", .opt_idx = kOptFoldignore },
  { .name = "bri", .opt_idx = kOptBreakindent },
  { .name = "ari", .opt_idx = kOptAllowrevins },
  { .name = "imi", .opt_idx = kOptIminsert },
  { .name = "isi", .opt_idx = kOptIsident },
  { .name = "brk", .opt_idx = kOptBreakat },
  { .name = "wak", .opt_idx = kOptWinaltkeys },
  { .name = "spk", .opt_idx = kOptSplitkeep },
  { .name = "bsk", .opt_idx = kOptBackupskip },
  { .name = "isk", .opt_idx = kOptIskeyword },
  { .name = "csl", .opt_idx = kOptCompleteslash },
  { .name = "eol", .opt_idx = kOptEndofline },
  { .name = "cul", .opt_idx = kOptCursorline },
  { .name = "ssl", .opt_idx = kOptShellslash },
  { .name = "stl", .opt_idx = kOptStatusline },
  { .name = "tcl", .opt_idx = kOptTabclose },
  { .name = "fcl", .opt_idx = kOptFoldclose },
  { .name = "sel", .opt_idx = kOptSelection },
  { .name = "fdl", .opt_idx = kOptFoldlevel },
  { .name = "fml", .opt_idx = kOptFoldminlines },
  { .name = "lpl", .opt_idx = kOptLoadplugins },
  { .name = "tal", .opt_idx = kOptTabline },
  { .name = "sol", .opt_idx = kOptStartofline },
  { .name = "spl", .opt_idx = kOptSpelllang },
  { .name = "scl", .opt_idx = kOptSigncolumn },
  { .name = "gtl", .opt_idx = kOptGuitablabel },
  { .name = "efm", .opt_idx = kOptErrorformat },
  { .name = "slm", .opt_idx = kOptSelectmode },
  { .name = "gfm", .opt_idx = kOptGrepformat },
  { .name = "shm", .opt_idx = kOptShortmess },
  { .name = "fdm", .opt_idx = kOptFoldmethod },
  { .name = "msm", .opt_idx = kOptMkspellmem },
  { .name = "com", .opt_idx = kOptComments },
  { .name = "ttm", .opt_idx = kOptTtimeoutlen },
  { .name = "wcm", .opt_idx = kOptWildcharm },
  { .name = "wim", .opt_idx = kOptWildmode },
  { .name = "tpm", .opt_idx = kOptTabpagemax },
  { .name = "icm", .opt_idx = kOptInccommand },
  { .name = "lrm", .opt_idx = kOptLangremap },
  { .name = "gfn", .opt_idx = kOptGuifont },
  { .name = "syn", .opt_idx = kOptSyntax },
  { .name = "fen", .opt_idx = kOptFoldenable },
  { .name = "fdn", .opt_idx = kOptFoldnestmax },
  { .name = "bin", .opt_idx = kOptBinary },
  { .name = "cin", .opt_idx = kOptCindent },
  { .name = "cpo", .opt_idx = kOptCpoptions },
  { .name = "emo", .opt_idx = kOptEmoji },
  { .name = "spo", .opt_idx = kOptSpelloptions },
  { .name = "sbo", .opt_idx = kOptScrollopt },
  { .name = "mco", .opt_idx = kOptMaxcombine },
  { .name = "fdo", .opt_idx = kOptFoldopen },
  { .name = "kmp", .opt_idx = kOptKeymap },
  { .name = "lsp", .opt_idx = kOptLinespace },
  { .name = "flp", .opt_idx = kOptFormatlistpat },
  { .name = "cmp", .opt_idx = kOptCasemap },
  { .name = "top", .opt_idx = kOptTildeop },
  { .name = "wop", .opt_idx = kOptWildoptions },
  { .name = "rtp", .opt_idx = kOptRuntimepath },
  { .name = "vop", .opt_idx = kOptViewoptions },
  { .name = "isp", .opt_idx = kOptIsprint },
  { .name = "mmp", .opt_idx = kOptMaxmempattern },
  { .name = "dip", .opt_idx = kOptDiffopt },
  { .name = "lop", .opt_idx = kOptLispoptions },
  { .name = "hkp", .opt_idx = kOptHkmapp },
  { .name = "jop", .opt_idx = kOptJumpoptions },
  { .name = "shq", .opt_idx = kOptShellquote },
  { .name = "sxq", .opt_idx = kOptShellxquote },
  { .name = "dir", .opt_idx = kOptDirectory },
  { .name = "gcr", .opt_idx = kOptGuicursor },
  { .name = "srr", .opt_idx = kOptShellredir },
  { .name = "fmr", .opt_idx = kOptFoldmarker },
  { .name = "tsr", .opt_idx = kOptThesaurus },
  { .name = "scr", .opt_idx = kOptScroll },
  { .name = "wbr", .opt_idx = kOptWinbar },
  { .name = "spr", .opt_idx = kOptSplitright },
  { .name = "lbr", .opt_idx = kOptLinebreak },
  { .name = "lnr", .opt_idx = kOptLangnoremap },
  { .name = "sbr", .opt_idx = kOptShowbreak },
  { .name = "scs", .opt_idx = kOptSmartcase },
  { .name = "sms", .opt_idx = kOptSmoothscroll },
  { .name = "hls", .opt_idx = kOptHlsearch },
  { .name = "sps", .opt_idx = kOptSpellsuggest },
  { .name = "ffs", .opt_idx = kOptFileformats },
  { .name = "mps", .opt_idx = kOptMatchpairs },
  { .name = "mis", .opt_idx = kOptMenuitems },
  { .name = "mls", .opt_idx = kOptModelines },
  { .name = "cms", .opt_idx = kOptCommentstring },
  { .name = "vts", .opt_idx = kOptVartabstop },
  { .name = "vbs", .opt_idx = kOptVerbose },
  { .name = "tbs", .opt_idx = kOptTagbsearch },
  { .name = "sts", .opt_idx = kOptSofttabstop },
  { .name = "fcs", .opt_idx = kOptFillchars },
  { .name = "ims", .opt_idx = kOptImsearch },
  { .name = "lcs", .opt_idx = kOptListchars },
  { .name = "cot", .opt_idx = kOptCompleteopt },
  { .name = "gtt", .opt_idx = kOptGuitabtooltip },
  { .name = "sft", .opt_idx = kOptShowfulltag },
  { .name = "rdt", .opt_idx = kOptRedrawtime },
  { .name = "fdt", .opt_idx = kOptFoldtext },
  { .name = "mat", .opt_idx = kOptMatchtime },
  { .name = "cpt", .opt_idx = kOptComplete },
  { .name = "rnu", .opt_idx = kOptRelativenumber },
  { .name = "ffu", .opt_idx = kOptFindfunc },
  { .name = "tfu", .opt_idx = kOptTagfunc },
  { .name = "cfu", .opt_idx = kOptCompletefunc },
  { .name = "ofu", .opt_idx = kOptOmnifunc },
  { .name = "ccv", .opt_idx = kOptCharconvert },
  { .name = "pvw", .opt_idx = kOptPreviewwindow },
  { .name = "eiw", .opt_idx = kOptEventignorewin },
  { .name = "gfw", .opt_idx = kOptGuifontwide },
  { .name = "wmw", .opt_idx = kOptWinminwidth },
  { .name = "wiw", .opt_idx = kOptWinwidth },
  { .name = "wfw", .opt_idx = kOptWinfixwidth },
  { .name = "nuw", .opt_idx = kOptNumberwidth },
  { .name = "pex", .opt_idx = kOptPatchexpr },
  { .name = "dex", .opt_idx = kOptDiffexpr },
  { .name = "bex", .opt_idx = kOptBackupext },
  { .name = "pyx", .opt_idx = kOptPyxversion },
  { .name = "fex", .opt_idx = kOptFormatexpr },
  { .name = "para", .opt_idx = kOptParagraphs },
  { .name = "arab", .opt_idx = kOptArabic },
  { .name = "bomb", .opt_idx = kOptBomb },
  { .name = "exrc", .opt_idx = kOptExrc },
  { .name = "fenc", .opt_idx = kOptFileencoding },
  { .name = "sloc", .opt_idx = kOptShowcmdloc },
  { .name = "menc", .opt_idx = kOptMakeencoding },
  { .name = "tenc", .opt_idx = kOptTermencoding },
  { .name = "cole", .opt_idx = kOptConceallevel },
  { .name = "inde", .opt_idx = kOptIndentexpr },
  { .name = "more", .opt_idx = kOptMore },
  { .name = "diff", .opt_idx = kOptDiff },
  { .name = "shcf", .opt_idx = kOptShellcmdflag },
  { .name = "qftf", .opt_idx = kOptQuickfixtextfunc },
  { .name = "path", .opt_idx = kOptPath },
  { .name = "cink", .opt_idx = kOptCinkeys },
  { .name = "scbk", .opt_idx = kOptScrollback },
  { .name = "indk", .opt_idx = kOptIndentkeys },
  { .name = "stal", .opt_idx = kOptShowtabline },
  { .name = "icon", .opt_idx = kOptIcon },
  { .name = "warn", .opt_idx = kOptWarn },
  { .name = "deco", .opt_idx = kOptDelcombine },
  { .name = "cino", .opt_idx = kOptCinoptions },
  { .name = "siso", .opt_idx = kOptSidescrolloff },
  { .name = "lisp", .opt_idx = kOptLisp },
  { .name = "wrap", .opt_idx = kOptWrap },
  { .name = "ssop", .opt_idx = kOptSessionoptions },
  { .name = "stmp", .opt_idx = kOptShelltemp },
  { .name = "lmap", .opt_idx = kOptLangmap },
  { .name = "bdir", .opt_idx = kOptBackupdir },
  { .name = "vdir", .opt_idx = kOptViewdir },
  { .name = "udir", .opt_idx = kOptUndodir },
  { .name = "tags", .opt_idx = kOptTags },
  { .name = "fdls", .opt_idx = kOptFoldlevelstart },
  { .name = "vsts", .opt_idx = kOptVarsofttabstop },
  { .name = "dict", .opt_idx = kOptDictionary },
  { .name = "sect", .opt_idx = kOptSections },
  { .name = "list", .opt_idx = kOptList },
  { .name = "tgst", .opt_idx = kOptTagstack },
  { .name = "mopt", .opt_idx = kOptMessagesopt },
  { .name = "cocu", .opt_idx = kOptConcealcursor },
  { .name = "wmnu", .opt_idx = kOptWildmenu },
  { .name = "odev", .opt_idx = kOptOpendevice },
  { .name = "cinw", .opt_idx = kOptCinwords },
  { .name = "ambw", .opt_idx = kOptAmbiwidth },
  { .name = "inex", .opt_idx = kOptIncludeexpr },
  { .name = "aleph", .opt_idx = kOptAleph },
  { .name = "bsdir", .opt_idx = kOptBrowsedir },
  { .name = "cedit", .opt_idx = kOptCedit },
  { .name = "cinsd", .opt_idx = kOptCinscopedecls },
  { .name = "debug", .opt_idx = kOptDebug },
  { .name = "emoji", .opt_idx = kOptEmoji },
  { .name = "fencs", .opt_idx = kOptFileencodings },
  { .name = "fsync", .opt_idx = kOptFsync },
  { .name = "hkmap", .opt_idx = kOptHkmap },
  { .name = "lines", .opt_idx = kOptLines },
  { .name = "magic", .opt_idx = kOptMagic },
  { .name = "mouse", .opt_idx = kOptMouse },
  { .name = "paste", .opt_idx = kOptPaste },
  { .name = "remap", .opt_idx = kOptRemap },
  { .name = "ruler", .opt_idx = kOptRuler },
  { .name = "shada", .opt_idx = kOptShada },
  { .name = "shell", .opt_idx = kOptShell },
  { .name = "spell", .opt_idx = kOptSpell },
  { .name = "terse", .opt_idx = kOptTerse },
  { .name = "title", .opt_idx = kOptTitle },
  { .name = "tbidi", .opt_idx = kOptTermbidi },
  { .name = "tsrfu", .opt_idx = kOptThesaurusfunc },
  { .name = "vfile", .opt_idx = kOptVerbosefile },
  { .name = "winhl", .opt_idx = kOptWinhighlight },
  { .name = "write", .opt_idx = kOptWrite },
  { .name = "winbl", .opt_idx = kOptWinblend },
  { .name = "arabic", .opt_idx = kOptArabic },
  { .name = "backup", .opt_idx = kOptBackup },
  { .name = "secure", .opt_idx = kOptSecure },
  { .name = "hidden", .opt_idx = kOptHidden },
  { .name = "define", .opt_idx = kOptDefine },
  { .name = "opfunc", .opt_idx = kOptOperatorfunc },
  { .name = "cdhome", .opt_idx = kOptCdhome },
  { .name = "briopt", .opt_idx = kOptBreakindentopt },
  { .name = "makeef", .opt_idx = kOptMakeef },
  { .name = "culopt", .opt_idx = kOptCursorlineopt },
  { .name = "number", .opt_idx = kOptNumber },
  { .name = "hkmapp", .opt_idx = kOptHkmapp },
  { .name = "syntax", .opt_idx = kOptSyntax },
  { .name = "binary", .opt_idx = kOptBinary },
  { .name = "window", .opt_idx = kOptWindow },
  { .name = "winbar", .opt_idx = kOptWinbar },
  { .name = "prompt", .opt_idx = kOptPrompt },
  { .name = "report", .opt_idx = kOptReport },
  { .name = "cdpath", .opt_idx = kOptCdpath },
  { .name = "scroll", .opt_idx = kOptScroll },
  { .name = "mouses", .opt_idx = kOptMouseshape },
  { .name = "mousef", .opt_idx = kOptMousefocus },
  { .name = "mousem", .opt_idx = kOptMousemodel },
  { .name = "mouset", .opt_idx = kOptMousetime },
  { .name = "revins", .opt_idx = kOptRevins },
  { .name = "fixeol", .opt_idx = kOptFixendofline },
  { .name = "keymap", .opt_idx = kOptKeymap },
  { .name = "channel", .opt_idx = kOptChannel },
  { .name = "tabstop", .opt_idx = kOptTabstop },
  { .name = "tabline", .opt_idx = kOptTabline },
  { .name = "include", .opt_idx = kOptInclude },
  { .name = "undodir", .opt_idx = kOptUndodir },
  { .name = "grepprg", .opt_idx = kOptGrepprg },
  { .name = "breakat", .opt_idx = kOptBreakat },
  { .name = "viewdir", .opt_idx = kOptViewdir },
  { .name = "diffopt", .opt_idx = kOptDiffopt },
  { .name = "buftype", .opt_idx = kOptBuftype },
  { .name = "isfname", .opt_idx = kOptIsfname },
  { .name = "digraph", .opt_idx = kOptDigraph },
  { .name = "tagfunc", .opt_idx = kOptTagfunc },
  { .name = "tagcase", .opt_idx = kOptTagcase },
  { .name = "guifont", .opt_idx = kOptGuifont },
  { .name = "isident", .opt_idx = kOptIsident },
  { .name = "makeprg", .opt_idx = kOptMakeprg },
  { .name = "belloff", .opt_idx = kOptBelloff },
  { .name = "columns", .opt_idx = kOptColumns },
  { .name = "tildeop", .opt_idx = kOptTildeop },
  { .name = "viminfo", .opt_idx = kOptShada },
  { .name = "timeout", .opt_idx = kOptTimeout },
  { .name = "confirm", .opt_idx = kOptConfirm },
  { .name = "cinkeys", .opt_idx = kOptCinkeys },
  { .name = "cindent", .opt_idx = kOptCindent },
  { .name = "langmap", .opt_idx = kOptLangmap },
  { .name = "showcmd", .opt_idx = kOptShowcmd },
  { .name = "isprint", .opt_idx = kOptIsprint },
  { .name = "verbose", .opt_idx = kOptVerbose },
  { .name = "arshape", .opt_idx = kOptArabicshape },
  { .name = "display", .opt_idx = kOptDisplay },
  { .name = "casemap", .opt_idx = kOptCasemap },
  { .name = "history", .opt_idx = kOptHistory },
  { .name = "ttyfast", .opt_idx = kOptTtyfast },
  { .name = "autoread", .opt_idx = kOptAutoread },
  { .name = "complete", .opt_idx = kOptComplete },
  { .name = "cinwords", .opt_idx = kOptCinwords },
  { .name = "comments", .opt_idx = kOptComments },
  { .name = "diffexpr", .opt_idx = kOptDiffexpr },
  { .name = "encoding", .opt_idx = kOptEncoding },
  { .name = "equalprg", .opt_idx = kOptEqualprg },
  { .name = "filetype", .opt_idx = kOptFiletype },
  { .name = "findfunc", .opt_idx = kOptFindfunc },
  { .name = "foldexpr", .opt_idx = kOptFoldexpr },
  { .name = "foldopen", .opt_idx = kOptFoldopen },
  { .name = "foldtext", .opt_idx = kOptFoldtext },
  { .name = "gdefault", .opt_idx = kOptGdefault },
  { .name = "helpfile", .opt_idx = kOptHelpfile },
  { .name = "hlsearch", .opt_idx = kOptHlsearch },
  { .name = "helplang", .opt_idx = kOptHelplang },
  { .name = "imsearch", .opt_idx = kOptImsearch },
  { .name = "iminsert", .opt_idx = kOptIminsert },
  { .name = "keymodel", .opt_idx = kOptKeymodel },
  { .name = "langmenu", .opt_idx = kOptLangmenu },
  { .name = "mousemev", .opt_idx = kOptMousemoveevent },
  { .name = "modeline", .opt_idx = kOptModeline },
  { .name = "modified", .opt_idx = kOptModified },
  { .name = "omnifunc", .opt_idx = kOptOmnifunc },
  { .name = "packpath", .opt_idx = kOptPackpath },
  { .name = "pumwidth", .opt_idx = kOptPumwidth },
  { .name = "pumblend", .opt_idx = kOptPumblend },
  { .name = "readonly", .opt_idx = kOptReadonly },
  { .name = "smarttab", .opt_idx = kOptSmarttab },
  { .name = "showmode", .opt_idx = kOptShowmode },
  { .name = "suffixes", .opt_idx = kOptSuffixes },
  { .name = "sections", .opt_idx = kOptSections },
  { .name = "swapfile", .opt_idx = kOptSwapfile },
  { .name = "tabclose", .opt_idx = kOptTabclose },
  { .name = "tagstack", .opt_idx = kOptTagstack },
  { .name = "termbidi", .opt_idx = kOptTermbidi },
  { .name = "termsync", .opt_idx = kOptTermsync },
  { .name = "ttimeout", .opt_idx = kOptTtimeout },
  { .name = "titleold", .opt_idx = kOptTitleold },
  { .name = "titlelen", .opt_idx = kOptTitlelen },
  { .name = "undofile", .opt_idx = kOptUndofile },
  { .name = "wildmode", .opt_idx = kOptWildmode },
  { .name = "winwidth", .opt_idx = kOptWinwidth },
  { .name = "winblend", .opt_idx = kOptWinblend },
  { .name = "wildmenu", .opt_idx = kOptWildmenu },
  { .name = "wildchar", .opt_idx = kOptWildchar },
  { .name = "wrapscan", .opt_idx = kOptWrapscan },
  { .name = "writeany", .opt_idx = kOptWriteany },
  { .name = "linebreak", .opt_idx = kOptLinebreak },
  { .name = "expandtab", .opt_idx = kOptExpandtab },
  { .name = "showbreak", .opt_idx = kOptShowbreak },
  { .name = "whichwrap", .opt_idx = kOptWhichwrap },
  { .name = "langremap", .opt_idx = kOptLangremap },
  { .name = "backspace", .opt_idx = kOptBackspace },
  { .name = "linespace", .opt_idx = kOptLinespace },
  { .name = "showmatch", .opt_idx = kOptShowmatch },
  { .name = "incsearch", .opt_idx = kOptIncsearch },
  { .name = "patchmode", .opt_idx = kOptPatchmode },
  { .name = "lispwords", .opt_idx = kOptLispwords },
  { .name = "mousehide", .opt_idx = kOptMousehide },
  { .name = "foldlevel", .opt_idx = kOptFoldlevel },
  { .name = "bufhidden", .opt_idx = kOptBufhidden },
  { .name = "buflisted", .opt_idx = kOptBuflisted },
  { .name = "modelines", .opt_idx = kOptModelines },
  { .name = "winborder", .opt_idx = kOptWinborder },
  { .name = "splitkeep", .opt_idx = kOptSplitkeep },
  { .name = "scrolloff", .opt_idx = kOptScrolloff },
  { .name = "rightleft", .opt_idx = kOptRightleft },
  { .name = "highlight", .opt_idx = kOptHighlight },
  { .name = "pumheight", .opt_idx = kOptPumheight },
  { .name = "cmdheight", .opt_idx = kOptCmdheight },
  { .name = "winheight", .opt_idx = kOptWinheight },
  { .name = "autochdir", .opt_idx = kOptAutochdir },
  { .name = "backupdir", .opt_idx = kOptBackupdir },
  { .name = "browsedir", .opt_idx = kOptBrowsedir },
  { .name = "endoffile", .opt_idx = kOptEndoffile },
  { .name = "errorfile", .opt_idx = kOptErrorfile },
  { .name = "shadafile", .opt_idx = kOptShadafile },
  { .name = "imdisable", .opt_idx = kOptImdisable },
  { .name = "spellfile", .opt_idx = kOptSpellfile },
  { .name = "shelltemp", .opt_idx = kOptShelltemp },
  { .name = "matchtime", .opt_idx = kOptMatchtime },
  { .name = "menuitems", .opt_idx = kOptMenuitems },
  { .name = "mousetime", .opt_idx = kOptMousetime },
  { .name = "cpoptions", .opt_idx = kOptCpoptions },
  { .name = "endofline", .opt_idx = kOptEndofline },
  { .name = "spelllang", .opt_idx = kOptSpelllang },
  { .name = "imcmdline", .opt_idx = kOptImcmdline },
  { .name = "guicursor", .opt_idx = kOptGuicursor },
  { .name = "synmaxcol", .opt_idx = kOptSynmaxcol },
  { .name = "selection", .opt_idx = kOptSelection },
  { .name = "patchexpr", .opt_idx = kOptPatchexpr },
  { .name = "shellpipe", .opt_idx = kOptShellpipe },
  { .name = "scrollopt", .opt_idx = kOptScrollopt },
  { .name = "fillchars", .opt_idx = kOptFillchars },
  { .name = "listchars", .opt_idx = kOptListchars },
  { .name = "wildcharm", .opt_idx = kOptWildcharm },
  { .name = "clipboard", .opt_idx = kOptClipboard },
  { .name = "directory", .opt_idx = kOptDirectory },
  { .name = "iskeyword", .opt_idx = kOptIskeyword },
  { .name = "formatprg", .opt_idx = kOptFormatprg },
  { .name = "shortmess", .opt_idx = kOptShortmess },
  { .name = "foldclose", .opt_idx = kOptFoldclose },
  { .name = "smartcase", .opt_idx = kOptSmartcase },
  { .name = "infercase", .opt_idx = kOptInfercase },
  { .name = "ambiwidth", .opt_idx = kOptAmbiwidth },
  { .name = "autowrite", .opt_idx = kOptAutowrite },
  { .name = "taglength", .opt_idx = kOptTaglength },
  { .name = "textwidth", .opt_idx = kOptTextwidth },
  { .name = "nrformats", .opt_idx = kOptNrformats },
  { .name = "thesaurus", .opt_idx = kOptThesaurus },
  { .name = "winfixbuf", .opt_idx = kOptWinfixbuf },
  { .name = "switchbuf", .opt_idx = kOptSwitchbuf },
  { .name = "backupext", .opt_idx = kOptBackupext },
  { .name = "laststatus", .opt_idx = kOptLaststatus },
  { .name = "foldenable", .opt_idx = kOptFoldenable },
  { .name = "matchpairs", .opt_idx = kOptMatchpairs },
  { .name = "modifiable", .opt_idx = kOptModifiable },
  { .name = "tagbsearch", .opt_idx = kOptTagbsearch },
  { .name = "paragraphs", .opt_idx = kOptParagraphs },
  { .name = "joinspaces", .opt_idx = kOptJoinspaces },
  { .name = "delcombine", .opt_idx = kOptDelcombine },
  { .name = "cursorbind", .opt_idx = kOptCursorbind },
  { .name = "maxcombine", .opt_idx = kOptMaxcombine },
  { .name = "scrollback", .opt_idx = kOptScrollback },
  { .name = "visualbell", .opt_idx = kOptVisualbell },
  { .name = "scrollbind", .opt_idx = kOptScrollbind },
  { .name = "backupcopy", .opt_idx = kOptBackupcopy },
  { .name = "ignorecase", .opt_idx = kOptIgnorecase },
  { .name = "keywordprg", .opt_idx = kOptKeywordprg },
  { .name = "autoindent", .opt_idx = kOptAutoindent },
  { .name = "lazyredraw", .opt_idx = kOptLazyredraw },
  { .name = "showcmdloc", .opt_idx = kOptShowcmdloc },
  { .name = "copyindent", .opt_idx = kOptCopyindent },
  { .name = "errorbells", .opt_idx = kOptErrorbells },
  { .name = "shellredir", .opt_idx = kOptShellredir },
  { .name = "splitbelow", .opt_idx = kOptSplitbelow },
  { .name = "tabpagemax", .opt_idx = kOptTabpagemax },
  { .name = "writedelay", .opt_idx = kOptWritedelay },
  { .name = "formatexpr", .opt_idx = kOptFormatexpr },
  { .name = "indentexpr", .opt_idx = kOptIndentexpr },
  { .name = "mouseshape", .opt_idx = kOptMouseshape },
  { .name = "guioptions", .opt_idx = kOptGuioptions },
  { .name = "shiftwidth", .opt_idx = kOptShiftwidth },
  { .name = "cinoptions", .opt_idx = kOptCinoptions },
  { .name = "splitright", .opt_idx = kOptSplitright },
  { .name = "compatible", .opt_idx = kOptCompatible },
  { .name = "helpheight", .opt_idx = kOptHelpheight },
  { .name = "scrolljump", .opt_idx = kOptScrolljump },
  { .name = "winaltkeys", .opt_idx = kOptWinaltkeys },
  { .name = "indentkeys", .opt_idx = kOptIndentkeys },
  { .name = "cursorline", .opt_idx = kOptCursorline },
  { .name = "signcolumn", .opt_idx = kOptSigncolumn },
  { .name = "shellslash", .opt_idx = kOptShellslash },
  { .name = "foldcolumn", .opt_idx = kOptFoldcolumn },
  { .name = "undoreload", .opt_idx = kOptUndoreload },
  { .name = "mkspellmem", .opt_idx = kOptMkspellmem },
  { .name = "statusline", .opt_idx = kOptStatusline },
  { .name = "insertmode", .opt_idx = kOptInsertmode },
  { .name = "selectmode", .opt_idx = kOptSelectmode },
  { .name = "inccommand", .opt_idx = kOptInccommand },
  { .name = "dictionary", .opt_idx = kOptDictionary },
  { .name = "foldignore", .opt_idx = kOptFoldignore },
  { .name = "wildignore", .opt_idx = kOptWildignore },
  { .name = "mousemodel", .opt_idx = kOptMousemodel },
  { .name = "shiftround", .opt_idx = kOptShiftround },
  { .name = "background", .opt_idx = kOptBackground },
  { .name = "mousefocus", .opt_idx = kOptMousefocus },
  { .name = "grepformat", .opt_idx = kOptGrepformat },
  { .name = "iconstring", .opt_idx = kOptIconstring },
  { .name = "fileformat", .opt_idx = kOptFileformat },
  { .name = "sidescroll", .opt_idx = kOptSidescroll },
  { .name = "foldmarker", .opt_idx = kOptFoldmarker },
  { .name = "wrapmargin", .opt_idx = kOptWrapmargin },
  { .name = "backupskip", .opt_idx = kOptBackupskip },
  { .name = "pyxversion", .opt_idx = kOptPyxversion },
  { .name = "vartabstop", .opt_idx = kOptVartabstop },
  { .name = "redrawtime", .opt_idx = kOptRedrawtime },
  { .name = "foldmethod", .opt_idx = kOptFoldmethod },
  { .name = "timeoutlen", .opt_idx = kOptTimeoutlen },
  { .name = "updatetime", .opt_idx = kOptUpdatetime },
  { .name = "shellquote", .opt_idx = kOptShellquote },
  { .name = "undolevels", .opt_idx = kOptUndolevels },
  { .name = "opendevice", .opt_idx = kOptOpendevice },
  { .name = "showtabline", .opt_idx = kOptShowtabline },
  { .name = "virtualedit", .opt_idx = kOptVirtualedit },
  { .name = "softtabstop", .opt_idx = kOptSofttabstop },
  { .name = "equalalways", .opt_idx = kOptEqualalways },
  { .name = "guitablabel", .opt_idx = kOptGuitablabel },
  { .name = "writebackup", .opt_idx = kOptWritebackup },
  { .name = "arabicshape", .opt_idx = kOptArabicshape },
  { .name = "colorcolumn", .opt_idx = kOptColorcolumn },
  { .name = "includeexpr", .opt_idx = kOptIncludeexpr },
  { .name = "eadirection", .opt_idx = kOptEadirection },
  { .name = "quoteescape", .opt_idx = kOptQuoteescape },
  { .name = "foldnestmax", .opt_idx = kOptFoldnestmax },
  { .name = "updatecount", .opt_idx = kOptUpdatecount },
  { .name = "completeopt", .opt_idx = kOptCompleteopt },
  { .name = "errorformat", .opt_idx = kOptErrorformat },
  { .name = "viminfofile", .opt_idx = kOptShadafile },
  { .name = "rulerformat", .opt_idx = kOptRulerformat },
  { .name = "messagesopt", .opt_idx = kOptMessagesopt },
  { .name = "eventignore", .opt_idx = kOptEventignore },
  { .name = "breakindent", .opt_idx = kOptBreakindent },
  { .name = "smartindent", .opt_idx = kOptSmartindent },
  { .name = "loadplugins", .opt_idx = kOptLoadplugins },
  { .name = "tagrelative", .opt_idx = kOptTagrelative },
  { .name = "runtimepath", .opt_idx = kOptRuntimepath },
  { .name = "guifontwide", .opt_idx = kOptGuifontwide },
  { .name = "winminwidth", .opt_idx = kOptWinminwidth },
  { .name = "charconvert", .opt_idx = kOptCharconvert },
  { .name = "ttimeoutlen", .opt_idx = kOptTtimeoutlen },
  { .name = "startofline", .opt_idx = kOptStartofline },
  { .name = "langnoremap", .opt_idx = kOptLangnoremap },
  { .name = "fileformats", .opt_idx = kOptFileformats },
  { .name = "lispoptions", .opt_idx = kOptLispoptions },
  { .name = "maxmapdepth", .opt_idx = kOptMaxmapdepth },
  { .name = "viewoptions", .opt_idx = kOptViewoptions },
  { .name = "wildoptions", .opt_idx = kOptWildoptions },
  { .name = "jumpoptions", .opt_idx = kOptJumpoptions },
  { .name = "allowrevins", .opt_idx = kOptAllowrevins },
  { .name = "numberwidth", .opt_idx = kOptNumberwidth },
  { .name = "verbosefile", .opt_idx = kOptVerbosefile },
  { .name = "mousescroll", .opt_idx = kOptMousescroll },
  { .name = "titlestring", .opt_idx = kOptTitlestring },
  { .name = "pastetoggle", .opt_idx = kOptPastetoggle },
  { .name = "showfulltag", .opt_idx = kOptShowfulltag },
  { .name = "redrawdebug", .opt_idx = kOptRedrawdebug },
  { .name = "shellxquote", .opt_idx = kOptShellxquote },
  { .name = "suffixesadd", .opt_idx = kOptSuffixesadd },
  { .name = "winfixwidth", .opt_idx = kOptWinfixwidth },
  { .name = "statuscolumn", .opt_idx = kOptStatuscolumn },
  { .name = "edcompatible", .opt_idx = kOptEdcompatible },
  { .name = "modelineexpr", .opt_idx = kOptModelineexpr },
  { .name = "cmdwinheight", .opt_idx = kOptCmdwinheight },
  { .name = "shellcmdflag", .opt_idx = kOptShellcmdflag },
  { .name = "shellxescape", .opt_idx = kOptShellxescape },
  { .name = "spelloptions", .opt_idx = kOptSpelloptions },
  { .name = "spellsuggest", .opt_idx = kOptSpellsuggest },
  { .name = "operatorfunc", .opt_idx = kOptOperatorfunc },
  { .name = "regexpengine", .opt_idx = kOptRegexpengine },
  { .name = "rightleftcmd", .opt_idx = kOptRightleftcmd },
  { .name = "makeencoding", .opt_idx = kOptMakeencoding },
  { .name = "fileencoding", .opt_idx = kOptFileencoding },
  { .name = "foldminlines", .opt_idx = kOptFoldminlines },
  { .name = "completefunc", .opt_idx = kOptCompletefunc },
  { .name = "winhighlight", .opt_idx = kOptWinhighlight },
  { .name = "winminheight", .opt_idx = kOptWinminheight },
  { .name = "winfixheight", .opt_idx = kOptWinfixheight },
  { .name = "conceallevel", .opt_idx = kOptConceallevel },
  { .name = "smoothscroll", .opt_idx = kOptSmoothscroll },
  { .name = "cursorcolumn", .opt_idx = kOptCursorcolumn },
  { .name = "termencoding", .opt_idx = kOptTermencoding },
  { .name = "autowriteall", .opt_idx = kOptAutowriteall },
  { .name = "fixendofline", .opt_idx = kOptFixendofline },
  { .name = "maxfuncdepth", .opt_idx = kOptMaxfuncdepth },
  { .name = "concealcursor", .opt_idx = kOptConcealcursor },
  { .name = "guitabtooltip", .opt_idx = kOptGuitabtooltip },
  { .name = "spellcapcheck", .opt_idx = kOptSpellcapcheck },
  { .name = "sidescrolloff", .opt_idx = kOptSidescrolloff },
  { .name = "previewwindow", .opt_idx = kOptPreviewwindow },
  { .name = "completeslash", .opt_idx = kOptCompleteslash },
  { .name = "previewheight", .opt_idx = kOptPreviewheight },
  { .name = "maxmempattern", .opt_idx = kOptMaxmempattern },
  { .name = "fileencodings", .opt_idx = kOptFileencodings },
  { .name = "commentstring", .opt_idx = kOptCommentstring },
  { .name = "cinscopedecls", .opt_idx = kOptCinscopedecls },
  { .name = "cursorlineopt", .opt_idx = kOptCursorlineopt },
  { .name = "formatoptions", .opt_idx = kOptFormatoptions },
  { .name = "formatlistpat", .opt_idx = kOptFormatlistpat },
  { .name = "termguicolors", .opt_idx = kOptTermguicolors },
  { .name = "thesaurusfunc", .opt_idx = kOptThesaurusfunc },
  { .name = "breakindentopt", .opt_idx = kOptBreakindentopt },
  { .name = "eventignorewin", .opt_idx = kOptEventignorewin },
  { .name = "foldlevelstart", .opt_idx = kOptFoldlevelstart },
  { .name = "fileignorecase", .opt_idx = kOptFileignorecase },
  { .name = "mousemoveevent", .opt_idx = kOptMousemoveevent },
  { .name = "preserveindent", .opt_idx = kOptPreserveindent },
  { .name = "relativenumber", .opt_idx = kOptRelativenumber },
  { .name = "sessionoptions", .opt_idx = kOptSessionoptions },
  { .name = "varsofttabstop", .opt_idx = kOptVarsofttabstop },
  { .name = "wildignorecase", .opt_idx = kOptWildignorecase },
  { .name = "termpastefilter", .opt_idx = kOptTermpastefilter },
  { .name = "quickfixtextfunc", .opt_idx = kOptQuickfixtextfunc },
  { .name = "completeitemalign", .opt_idx = kOptCompleteitemalign },
};

static int find_option_hash(const char *str, size_t len)
{
  int low = 0, high = 0;
  switch (len) {
    case 2: switch (str[1]) {
      case 'a': low = 0; high = 4; break;
      case 'b': low = 4; high = 10; break;
      case 'c': low = 10; high = 16; break;
      case 'd': low = 16; high = 21; break;
      case 'e': low = 21; high = 24; break;
      case 'f': low = 24; high = 30; break;
      case 'g': low = 30; high = 32; break;
      case 'h': low = 32; high = 39; break;
      case 'i': low = 39; high = 48; break;
      case 'j': low = 48; high = 49; break;
      case 'k': low = 49; high = 51; break;
      case 'l': low = 51; high = 58; break;
      case 'm': low = 58; high = 65; break;
      case 'o': low = 65; high = 72; break;
      case 'p': low = 72; high = 80; break;
      case 'r': low = 80; high = 84; break;
      case 's': low = 84; high = 92; break;
      case 't': low = 92; high = 97; break;
      case 'u': low = 97; high = 100; break;
      case 'w': low = 100; high = 106; break;
      case 'x': low = 106; high = 107; break;
      case 'y': low = 107; high = 108; break;
      case 'z': low = 108; high = 109; break;
      default: break;
    }
    break;
    case 3: switch (str[2]) {
      case 'a': low = 109; high = 113; break;
      case 'b': low = 113; high = 118; break;
      case 'c': low = 118; high = 131; break;
      case 'd': low = 131; high = 139; break;
      case 'e': low = 139; high = 142; break;
      case 'f': low = 142; high = 154; break;
      case 'g': low = 154; high = 157; break;
      case 'h': low = 157; high = 162; break;
      case 'i': low = 162; high = 167; break;
      case 'k': low = 167; high = 172; break;
      case 'l': low = 172; high = 188; break;
      case 'm': low = 188; high = 201; break;
      case 'n': low = 201; high = 207; break;
      case 'o': low = 207; high = 213; break;
      case 'p': low = 213; high = 227; break;
      case 'q': low = 227; high = 229; break;
      case 'r': low = 229; high = 240; break;
      case 's': low = 240; high = 256; break;
      case 't': low = 256; high = 263; break;
      case 'u': low = 263; high = 268; break;
      case 'v': low = 268; high = 269; break;
      case 'w': low = 269; high = 276; break;
      case 'x': low = 276; high = 281; break;
      default: break;
    }
    break;
    case 4: switch (str[3]) {
      case 'a': low = 281; high = 282; break;
      case 'b': low = 282; high = 284; break;
      case 'c': low = 284; high = 289; break;
      case 'e': low = 289; high = 292; break;
      case 'f': low = 292; high = 295; break;
      case 'h': low = 295; high = 296; break;
      case 'k': low = 296; high = 299; break;
      case 'l': low = 299; high = 300; break;
      case 'n': low = 300; high = 302; break;
      case 'o': low = 302; high = 305; break;
      case 'p': low = 305; high = 310; break;
      case 'r': low = 310; high = 313; break;
      case 's': low = 313; high = 316; break;
      case 't': low = 316; high = 321; break;
      case 'u': low = 321; high = 323; break;
      case 'v': low = 323; high = 324; break;
      case 'w': low = 324; high = 326; break;
      case 'x': low = 326; high = 327; break;
      default: break;
    }
    break;
    case 5: switch (str[0]) {
      case 'a': low = 327; high = 328; break;
      case 'b': low = 328; high = 329; break;
      case 'c': low = 329; high = 331; break;
      case 'd': low = 331; high = 332; break;
      case 'e': low = 332; high = 333; break;
      case 'f': low = 333; high = 335; break;
      case 'h': low = 335; high = 336; break;
      case 'l': low = 336; high = 337; break;
      case 'm': low = 337; high = 339; break;
      case 'p': low = 339; high = 340; break;
      case 'r': low = 340; high = 342; break;
      case 's': low = 342; high = 345; break;
      case 't': low = 345; high = 349; break;
      case 'v': low = 349; high = 350; break;
      case 'w': low = 350; high = 353; break;
      default: break;
    }
    break;
    case 6: switch (str[2]) {
      case 'a': low = 353; high = 354; break;
      case 'c': low = 354; high = 356; break;
      case 'd': low = 356; high = 357; break;
      case 'f': low = 357; high = 359; break;
      case 'h': low = 359; high = 360; break;
      case 'i': low = 360; high = 361; break;
      case 'k': low = 361; high = 362; break;
      case 'l': low = 362; high = 363; break;
      case 'm': low = 363; high = 365; break;
      case 'n': low = 365; high = 369; break;
      case 'o': low = 369; high = 370; break;
      case 'p': low = 370; high = 372; break;
      case 'r': low = 372; high = 373; break;
      case 'u': low = 373; high = 377; break;
      case 'v': low = 377; high = 378; break;
      case 'x': low = 378; high = 379; break;
      case 'y': low = 379; high = 380; break;
      default: break;
    }
    break;
    case 7: switch (str[2]) {
      case 'a': low = 380; high = 381; break;
      case 'b': low = 381; high = 383; break;
      case 'c': low = 383; high = 384; break;
      case 'd': low = 384; high = 385; break;
      case 'e': low = 385; high = 388; break;
      case 'f': low = 388; high = 391; break;
      case 'g': low = 391; high = 394; break;
      case 'i': low = 394; high = 396; break;
      case 'k': low = 396; high = 397; break;
      case 'l': low = 397; high = 400; break;
      case 'm': low = 400; high = 402; break;
      case 'n': low = 402; high = 406; break;
      case 'o': low = 406; high = 407; break;
      case 'p': low = 407; high = 408; break;
      case 'r': low = 408; high = 409; break;
      case 's': low = 409; high = 413; break;
      case 'y': low = 413; high = 414; break;
      default: break;
    }
    break;
    case 8: switch (str[0]) {
      case 'a': low = 414; high = 415; break;
      case 'c': low = 415; high = 418; break;
      case 'd': low = 418; high = 419; break;
      case 'e': low = 419; high = 421; break;
      case 'f': low = 421; high = 426; break;
      case 'g': low = 426; high = 427; break;
      case 'h': low = 427; high = 430; break;
      case 'i': low = 430; high = 432; break;
      case 'k': low = 432; high = 433; break;
      case 'l': low = 433; high = 434; break;
      case 'm': low = 434; high = 437; break;
      case 'o': low = 437; high = 438; break;
      case 'p': low = 438; high = 441; break;
      case 'r': low = 441; high = 442; break;
      case 's': low = 442; high = 447; break;
      case 't': low = 447; high = 454; break;
      case 'u': low = 454; high = 455; break;
      case 'w': low = 455; high = 462; break;
      default: break;
    }
    break;
    case 9: switch (str[7]) {
      case 'a': low = 462; high = 467; break;
      case 'c': low = 467; high = 471; break;
      case 'd': low = 471; high = 474; break;
      case 'e': low = 474; high = 480; break;
      case 'f': low = 480; high = 482; break;
      case 'h': low = 482; high = 486; break;
      case 'i': low = 486; high = 489; break;
      case 'l': low = 489; high = 494; break;
      case 'm': low = 494; high = 498; break;
      case 'n': low = 498; high = 502; break;
      case 'o': low = 502; high = 505; break;
      case 'p': low = 505; high = 508; break;
      case 'r': low = 508; high = 515; break;
      case 's': low = 515; high = 519; break;
      case 't': low = 519; high = 524; break;
      case 'u': low = 524; high = 527; break;
      case 'x': low = 527; high = 528; break;
      default: break;
    }
    break;
    case 10: switch (str[6]) {
      case 'a': low = 528; high = 535; break;
      case 'b': low = 535; high = 541; break;
      case 'c': low = 541; high = 543; break;
      case 'd': low = 543; high = 548; break;
      case 'e': low = 548; high = 555; break;
      case 'h': low = 555; high = 556; break;
      case 'i': low = 556; high = 562; break;
      case 'j': low = 562; high = 563; break;
      case 'k': low = 563; high = 565; break;
      case 'l': low = 565; high = 572; break;
      case 'm': low = 572; high = 575; break;
      case 'n': low = 575; high = 578; break;
      case 'o': low = 578; high = 582; break;
      case 'r': low = 582; high = 588; break;
      case 's': low = 588; high = 591; break;
      case 't': low = 591; high = 595; break;
      case 'u': low = 595; high = 596; break;
      case 'v': low = 596; high = 598; break;
      default: break;
    }
    break;
    case 11: switch (str[5]) {
      case 'a': low = 598; high = 602; break;
      case 'b': low = 602; high = 604; break;
      case 'c': low = 604; high = 606; break;
      case 'd': low = 606; high = 607; break;
      case 'e': low = 607; high = 612; break;
      case 'f': low = 612; high = 615; break;
      case 'g': low = 615; high = 616; break;
      case 'i': low = 616; high = 619; break;
      case 'l': low = 619; high = 621; break;
      case 'm': low = 621; high = 622; break;
      case 'n': low = 622; high = 624; break;
      case 'o': low = 624; high = 629; break;
      case 'p': low = 629; high = 634; break;
      case 'r': low = 634; high = 636; break;
      case 's': low = 636; high = 639; break;
      case 't': low = 639; high = 640; break;
      case 'u': low = 640; high = 641; break;
      case 'w': low = 641; high = 642; break;
      case 'x': low = 642; high = 645; break;
      default: break;
    }
    break;
    case 12: switch (str[2]) {
      case 'a': low = 645; high = 646; break;
      case 'c': low = 646; high = 647; break;
      case 'd': low = 647; high = 649; break;
      case 'e': low = 649; high = 654; break;
      case 'g': low = 654; high = 656; break;
      case 'k': low = 656; high = 657; break;
      case 'l': low = 657; high = 659; break;
      case 'm': low = 659; high = 660; break;
      case 'n': low = 660; high = 664; break;
      case 'o': low = 664; high = 665; break;
      case 'r': low = 665; high = 667; break;
      case 't': low = 667; high = 668; break;
      case 'x': low = 668; high = 670; break;
      default: break;
    }
    break;
    case 13: switch (str[5]) {
      case 'a': low = 670; high = 671; break;
      case 'b': low = 671; high = 672; break;
      case 'c': low = 672; high = 674; break;
      case 'e': low = 674; high = 677; break;
      case 'm': low = 677; high = 678; break;
      case 'n': low = 678; high = 680; break;
      case 'o': low = 680; high = 681; break;
      case 'r': low = 681; high = 682; break;
      case 't': low = 682; high = 684; break;
      case 'u': low = 684; high = 686; break;
      default: break;
    }
    break;
    case 14: switch (str[0]) {
      case 'b': low = 686; high = 687; break;
      case 'e': low = 687; high = 688; break;
      case 'f': low = 688; high = 690; break;
      case 'm': low = 690; high = 691; break;
      case 'p': low = 691; high = 692; break;
      case 'r': low = 692; high = 693; break;
      case 's': low = 693; high = 694; break;
      case 'v': low = 694; high = 695; break;
      case 'w': low = 695; high = 696; break;
      default: break;
    }
    break;
    case 15: low = 696; high = 697; break;
    case 16: low = 697; high = 698; break;
    case 17: low = 698; high = 699; break;
    default: break;
  }
  for (int i = low; i < high; i++) {
    if (!memcmp(str, option_hash_elems[i].name, len)) {
      return i;
    }
  }
  return -1;
}


