/* Event.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Event.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>

#define EVENT_SECONDS_PER_DAY ((gint64) ((24 * 60) * 60))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER (event_source_collection_no_event_view_manager_get_type ())
#define EVENT_SOURCE_COLLECTION_NO_EVENT_VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER, EventSourceCollectionNoEventViewManager))
#define EVENT_SOURCE_COLLECTION_NO_EVENT_VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER, EventSourceCollectionNoEventViewManagerClass))
#define EVENT_SOURCE_COLLECTION_IS_NO_EVENT_VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER))
#define EVENT_SOURCE_COLLECTION_IS_NO_EVENT_VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER))
#define EVENT_SOURCE_COLLECTION_NO_EVENT_VIEW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER, EventSourceCollectionNoEventViewManagerClass))

typedef struct _EventSourceCollectionNoEventViewManager EventSourceCollectionNoEventViewManager;
typedef struct _EventSourceCollectionNoEventViewManagerClass EventSourceCollectionNoEventViewManagerClass;
#define _view_collection_monitor_unref0(var) ((var == NULL) ? NULL : (var = (view_collection_monitor_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _view_manager_unref0(var) ((var == NULL) ? NULL : (var = (view_manager_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _EventSourceCollectionNoEventViewManagerPrivate EventSourceCollectionNoEventViewManagerPrivate;
enum  {
	EVENT_SOURCE_COLLECTION_NO_EVENT_COLLECTION_ALTERED_SIGNAL,
	EVENT_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint event_source_collection_signals[EVENT_SOURCE_COLLECTION_NUM_SIGNALS] = {0};
enum  {
	EVENT_0_PROPERTY,
	EVENT_NUM_PROPERTIES
};
static GParamSpec* event_properties[EVENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _event_row_unref0(var) ((var == NULL) ? NULL : (var = (event_row_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define EVENT_TYPE_EVENT_SNAPSHOT (event_event_snapshot_get_type ())
#define EVENT_EVENT_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EVENT_TYPE_EVENT_SNAPSHOT, EventEventSnapshot))
#define EVENT_EVENT_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EVENT_TYPE_EVENT_SNAPSHOT, EventEventSnapshotClass))
#define EVENT_IS_EVENT_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EVENT_TYPE_EVENT_SNAPSHOT))
#define EVENT_IS_EVENT_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EVENT_TYPE_EVENT_SNAPSHOT))
#define EVENT_EVENT_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EVENT_TYPE_EVENT_SNAPSHOT, EventEventSnapshotClass))

typedef struct _EventEventSnapshot EventEventSnapshot;
typedef struct _EventEventSnapshotClass EventEventSnapshotClass;

#define EVENT_TYPE_EVENT_PROXY (event_event_proxy_get_type ())
#define EVENT_EVENT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EVENT_TYPE_EVENT_PROXY, EventEventProxy))
#define EVENT_EVENT_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EVENT_TYPE_EVENT_PROXY, EventEventProxyClass))
#define EVENT_IS_EVENT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EVENT_TYPE_EVENT_PROXY))
#define EVENT_IS_EVENT_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EVENT_TYPE_EVENT_PROXY))
#define EVENT_EVENT_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EVENT_TYPE_EVENT_PROXY, EventEventProxyClass))

typedef struct _EventEventProxy EventEventProxy;
typedef struct _EventEventProxyClass EventEventProxyClass;
typedef struct _EventEventSnapshotPrivate EventEventSnapshotPrivate;
typedef struct _EventEventProxyPrivate EventEventProxyPrivate;
#define _source_snapshot_unref0(var) ((var == NULL) ? NULL : (var = (source_snapshot_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EventSourceCollectionPrivate {
	ViewCollection* no_event;
};

struct _EventSourceCollectionNoEventViewManager {
	ViewManager parent_instance;
	EventSourceCollectionNoEventViewManagerPrivate * priv;
};

struct _EventSourceCollectionNoEventViewManagerClass {
	ViewManagerClass parent_class;
};

struct _EventPrivate {
	EventID event_id;
	gchar* raw_name;
	MediaSource* primary_source;
	ViewCollection* view;
	gboolean unlinking;
	gboolean relinking;
	gchar* indexable_keywords;
	gchar* comment;
};

struct _EventEventSnapshot {
	SourceSnapshot parent_instance;
	EventEventSnapshotPrivate * priv;
};

struct _EventEventSnapshotClass {
	SourceSnapshotClass parent_class;
};

struct _EventEventSnapshotPrivate {
	EventRow* row;
	MediaSource* primary_source;
	GeeArrayList* attached_sources;
};

struct _EventEventProxy {
	SourceProxy parent_instance;
	EventEventProxyPrivate * priv;
};

struct _EventEventProxyClass {
	SourceProxyClass parent_class;
};

static gint EventSourceCollection_private_offset;
static gpointer event_source_collection_parent_class = NULL;
static gpointer event_source_collection_no_event_view_manager_parent_class = NULL;
static gint Event_private_offset;
static gpointer event_parent_class = NULL;
EventSourceCollection* event_global = NULL;
static EventTable* event_event_table;
static EventTable* event_event_table = NULL;
static gint EventEventSnapshot_private_offset;
static gpointer event_event_snapshot_parent_class = NULL;
static gpointer event_event_proxy_parent_class = NULL;
static ContainerSourceIface * event_container_source_parent_iface = NULL;
static ProxyableIface * event_proxyable_parent_iface = NULL;
static IndexableIface * event_indexable_parent_iface = NULL;

static gint64 event_source_collection_get_event_key (DataSource* source);
static gint64 _event_source_collection_get_event_key_get_source_database_key (DataSource* source,
                                                                       gpointer self);
static GType event_source_collection_no_event_view_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static EventSourceCollectionNoEventViewManager* event_source_collection_no_event_view_manager_new (void);
static EventSourceCollectionNoEventViewManager* event_source_collection_no_event_view_manager_construct (GType object_type);
static void event_source_collection_on_no_event_collection_altered (EventSourceCollection* self,
                                                             GeeIterable* added,
                                                             GeeIterable* removed);
static void _event_source_collection_on_no_event_collection_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                                               GeeIterable* added,
                                                                                               GeeIterable* removed,
                                                                                               gpointer self);
static gboolean event_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                            DataSource* source);
static GeeCollection* event_source_collection_real_get_containers_holding_source (ContainerSourceCollection* base,
                                                                           DataSource* source);
static ContainerSource* event_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* base,
                                                                             SourceBacklink* backlink);
static gboolean event_source_collection_no_event_view_manager_real_include_in_view (ViewManager* base,
                                                                             DataSource* source);
static DataView* event_source_collection_no_event_view_manager_real_create_view (ViewManager* base,
                                                                          DataSource* source);
static GType event_source_collection_no_event_view_manager_get_type_once (void);
static void event_source_collection_finalize (DataCollection * obj);
static GType event_source_collection_get_type_once (void);
static void event_on_primary_thumbnail_altered (Event* self);
static void _event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered (ThumbnailSource* _sender,
                                                                             gpointer self);
static void event_on_media_altered (Event* self,
                             GeeMap* items);
static void _event_on_media_altered_data_collection_items_altered (DataCollection* _sender,
                                                            GeeMap* items,
                                                            gpointer self);
static void event_on_media_removed (Event* self,
                             GeeIterable* removed);
static void _event_on_media_removed_data_collection_items_removed (DataCollection* _sender,
                                                            GeeIterable* removed,
                                                            gpointer self);
static void event_on_media_added (Event* self,
                           GeeIterable* added);
static void _event_on_media_added_data_collection_items_added (DataCollection* _sender,
                                                        GeeIterable* added,
                                                        gpointer self);
static void event_on_media_destroyed (Event* self,
                               DataSource* source);
static void _event_on_media_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                 DataSource* source,
                                                                 gpointer self);
static Event* event_new (EventRow* event_row,
                  gint64 object_id);
static Event* event_construct (GType object_type,
                        EventRow* event_row,
                        gint64 object_id);
static gint64 event_view_comparator (void* a,
                              void* b);
static gint64 _event_view_comparator_comparator (void* a,
                                          void* b,
                                          gpointer self);
static gboolean event_view_comparator_predicate (DataObject* object,
                                          Alteration* alteration);
static gboolean _event_view_comparator_predicate_comparator_predicate (DataObject* object,
                                                                Alteration* alteration,
                                                                gpointer self);
static void event_update_indexable_keywords (Event* self);
static gchar* event_real_get_typename (DataSource* base);
static gint64 event_real_get_instance_id (DataSource* base);
static gchar* event_real_get_representative_id (ThumbnailSource* base);
static PhotoFileFormat event_real_get_preferred_thumbnail_format (ThumbnailSource* base);
static GdkPixbuf* event_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
static GeeArrayList* event_views_to_media (Event* self,
                                    GeeIterable* views);
static void event_release_primary_source (Event* self);
static void event_real_notify_relinking (DataSource* base,
                                  SourceCollection* sources);
static Event* event_reconstitute (gint64 object_id,
                           EventRow* row);
static gboolean event_real_has_links (ContainerSource* base);
static SourceBacklink* event_real_get_backlink (ContainerSource* base);
static void event_real_break_link (ContainerSource* base,
                            DataSource* source);
static void event_real_break_link_many (ContainerSource* base,
                                 GeeCollection* sources);
static void event_real_establish_link (ContainerSource* base,
                                DataSource* source);
static void event_real_establish_link_many (ContainerSource* base,
                                     GeeCollection* sources);
static const gchar* event_real_get_indexable_keywords (Indexable* base);
static Event* event_generate_event (MediaSource* media,
                             ViewCollection* events_so_far,
                             const gchar* event_name,
                             gboolean* new_event);
static SourceSnapshot* event_real_save_snapshot (DataSource* base);
static EventEventSnapshot* event_event_snapshot_new (Event* event);
static EventEventSnapshot* event_event_snapshot_construct (GType object_type,
                                                    Event* event);
static GType event_event_snapshot_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SourceProxy* event_real_get_proxy (Proxyable* base);
static EventEventProxy* event_event_proxy_new (Event* event);
static EventEventProxy* event_event_proxy_construct (GType object_type,
                                              Event* event);
static GType event_event_proxy_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean event_real_equals (DataSource* base,
                            DataSource* source);
static gchar* event_real_to_string (DataObject* base);
static gchar* event_real_get_name (DataObject* base);
static gchar* event_real_get_comment (EventSource* base);
static gboolean event_real_set_comment (EventSource* base,
                                 const gchar* comment);
static gint64 event_real_get_start_time (EventSource* base);
static gint64 event_real_get_end_time (EventSource* base);
static guint64 event_real_get_total_filesize (EventSource* base);
static gint event_real_get_media_count (EventSource* base);
static GeeCollection* event_real_get_media (EventSource* base);
static GdkPixbuf* event_real_get_thumbnail (ThumbnailSource* base,
                                     gint scale,
                                     GError** error);
static void event_real_destroy (DataSource* base);
static void event_event_snapshot_on_attached_source_destroyed (EventEventSnapshot* self,
                                                        DataSource* source);
static void _event_event_snapshot_on_attached_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                          DataSource* source,
                                                                                          gpointer self);
static EventRow* event_event_snapshot_get_row (EventEventSnapshot* self);
static void event_event_snapshot_real_notify_broken (SourceSnapshot* base);
static void event_event_snapshot_finalize (SourceSnapshot * obj);
static GType event_event_snapshot_get_type_once (void);
static DataSource* event_event_proxy_real_reconstitute (SourceProxy* base,
                                                 gint64 object_id,
                                                 SourceSnapshot* snapshot);
static GType event_event_proxy_get_type_once (void);
static void event_finalize (GObject * obj);
static GType event_get_type_once (void);

static inline gpointer
event_source_collection_get_instance_private (EventSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, EventSourceCollection_private_offset);
}

static gint64
_event_source_collection_get_event_key_get_source_database_key (DataSource* source,
                                                                gpointer self)
{
	gint64 result;
	result = event_source_collection_get_event_key (source);
	return result;
}

EventSourceCollection*
event_source_collection_construct (GType object_type)
{
	EventSourceCollection* self = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	VideoSourceCollection* _tmp1_;
	self = (EventSourceCollection*) container_source_collection_construct (object_type, EVENT_TYPENAME, "EventSourceCollection", _event_source_collection_get_event_key_get_source_database_key, NULL);
	_tmp0_ = library_photo_global;
	container_source_collection_attach_collection ((ContainerSourceCollection*) self, (SourceCollection*) _tmp0_);
	_tmp1_ = video_global;
	container_source_collection_attach_collection ((ContainerSourceCollection*) self, (SourceCollection*) _tmp1_);
	return self;
}

EventSourceCollection*
event_source_collection_new (void)
{
	return event_source_collection_construct (TYPE_EVENT_SOURCE_COLLECTION);
}

static void
_event_source_collection_on_no_event_collection_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                                          GeeIterable* added,
                                                                                          GeeIterable* removed,
                                                                                          gpointer self)
{
	event_source_collection_on_no_event_collection_altered ((EventSourceCollection*) self, added, removed);
}

void
event_source_collection_init (EventSourceCollection* self)
{
	ViewCollection* _tmp0_;
	EventSourceCollectionNoEventViewManager* view_manager = NULL;
	EventSourceCollectionNoEventViewManager* _tmp1_;
	Alteration* filter_alteration = NULL;
	Alteration* _tmp2_;
	ViewCollection* _tmp3_;
	LibraryPhotoSourceCollection* _tmp4_;
	ViewCollectionMonitor* _tmp5_;
	ViewCollectionMonitor* _tmp6_;
	ViewCollection* _tmp7_;
	VideoSourceCollection* _tmp8_;
	ViewCollectionMonitor* _tmp9_;
	ViewCollectionMonitor* _tmp10_;
	ViewCollection* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = view_collection_new ("No Event View Collection");
	_data_collection_unref0 (self->priv->no_event);
	self->priv->no_event = _tmp0_;
	_tmp1_ = event_source_collection_no_event_view_manager_new ();
	view_manager = _tmp1_;
	_tmp2_ = alteration_new ("metadata", "event");
	filter_alteration = _tmp2_;
	_tmp3_ = self->priv->no_event;
	_tmp4_ = library_photo_global;
	_tmp5_ = view_collection_monitor_source_collection (_tmp3_, (SourceCollection*) _tmp4_, (ViewManager*) view_manager, filter_alteration, NULL, NULL, NULL);
	_tmp6_ = _tmp5_;
	_view_collection_monitor_unref0 (_tmp6_);
	_tmp7_ = self->priv->no_event;
	_tmp8_ = video_global;
	_tmp9_ = view_collection_monitor_source_collection (_tmp7_, (SourceCollection*) _tmp8_, (ViewManager*) view_manager, filter_alteration, NULL, NULL, NULL);
	_tmp10_ = _tmp9_;
	_view_collection_monitor_unref0 (_tmp10_);
	_tmp11_ = self->priv->no_event;
	g_signal_connect ((DataCollection*) _tmp11_, "contents-altered", (GCallback) _event_source_collection_on_no_event_collection_altered_data_collection_contents_altered, self);
	_alteration_unref0 (filter_alteration);
	_view_manager_unref0 (view_manager);
}

static gboolean
event_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                   DataSource* source)
{
	EventSourceCollection * self;
	gboolean result;
	self = (EventSourceCollection*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	result = IS_EVENT (source);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint64
event_source_collection_get_event_key (DataSource* source)
{
	Event* event = NULL;
	Event* _tmp0_;
	EventID event_id = {0};
	EventID _tmp1_ = {0};
	EventID _tmp2_;
	gint64 result;
	g_return_val_if_fail (source != NULL, 0LL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_EVENT, Event));
	event = _tmp0_;
	event_get_event_id (event, &_tmp1_);
	event_id = _tmp1_;
	_tmp2_ = event_id;
	result = _tmp2_.id;
	_g_object_unref0 (event);
	return result;
}

Event*
event_source_collection_fetch (EventSourceCollection* self,
                               EventID* event_id)
{
	EventID _tmp0_;
	DataSource* _tmp1_;
	Event* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = *event_id;
	_tmp1_ = database_source_collection_fetch_by_key ((DatabaseSourceCollection*) self, _tmp0_.id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_EVENT, Event);
	return result;
}

static GeeCollection*
event_source_collection_real_get_containers_holding_source (ContainerSourceCollection* base,
                                                            DataSource* source)
{
	EventSourceCollection * self;
	Event* event = NULL;
	Event* _tmp0_;
	Event* _tmp1_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	Event* _tmp4_;
	GeeCollection* result;
	self = (EventSourceCollection*) base;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = media_source_get_event (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
	event = _tmp0_;
	_tmp1_ = event;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (event);
		return result;
	}
	_tmp2_ = gee_array_list_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp2_;
	_tmp3_ = list;
	_tmp4_ = event;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, (ContainerSource*) _tmp4_);
	result = (GeeCollection*) list;
	_g_object_unref0 (event);
	return result;
}

static ContainerSource*
event_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* base,
                                                            SourceBacklink* backlink)
{
	EventSourceCollection * self;
	EventID event_id = {0};
	gint64 _tmp0_;
	gint64 _tmp1_;
	Event* event = NULL;
	EventID _tmp2_;
	Event* _tmp3_;
	Event* _tmp4_;
	ContainerSource* result;
	self = (EventSourceCollection*) base;
	g_return_val_if_fail (backlink != NULL, NULL);
	_tmp0_ = source_backlink_get_instance_id (backlink);
	_tmp1_ = _tmp0_;
	event_id_init (&event_id, _tmp1_);
	_tmp2_ = event_id;
	_tmp3_ = event_source_collection_fetch (self, &_tmp2_);
	event = _tmp3_;
	_tmp4_ = event;
	if (_tmp4_ != NULL) {
		result = (ContainerSource*) event;
		return result;
	}
	{
		GeeIterator* _container_it = NULL;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp5_ = container_source_collection_get_holding_tank ((ContainerSourceCollection*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_container_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			ContainerSource* _tmp12_;
			EventID _tmp13_ = {0};
			EventID _tmp14_;
			_tmp9_ = _container_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _container_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			container = (ContainerSource*) _tmp11_;
			_tmp12_ = container;
			event_get_event_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_EVENT, Event), &_tmp13_);
			_tmp14_ = event_id;
			if (_tmp13_.id == _tmp14_.id) {
				result = container;
				_g_object_unref0 (_container_it);
				_g_object_unref0 (event);
				return result;
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	result = NULL;
	_g_object_unref0 (event);
	return result;
}

GeeCollection*
event_source_collection_get_no_event_objects (EventSourceCollection* self)
{
	ViewCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->no_event;
	_tmp1_ = view_collection_get_sources (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
event_source_collection_on_no_event_collection_altered (EventSourceCollection* self,
                                                        GeeIterable* added,
                                                        GeeIterable* removed)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, event_source_collection_signals[EVENT_SOURCE_COLLECTION_NO_EVENT_COLLECTION_ALTERED_SIGNAL], 0);
}

static gboolean
event_source_collection_no_event_view_manager_real_include_in_view (ViewManager* base,
                                                                    DataSource* source)
{
	EventSourceCollectionNoEventViewManager * self;
	gboolean _tmp0_ = FALSE;
	EventID _tmp1_ = {0};
	gboolean result;
	self = (EventSourceCollectionNoEventViewManager*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	media_source_get_event_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource), &_tmp1_);
	if (_tmp1_.id != EVENT_ID_INVALID) {
		_tmp0_ = FALSE;
	} else {
		_tmp0_ = VIEW_MANAGER_CLASS (event_source_collection_no_event_view_manager_parent_class)->include_in_view (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIEW_MANAGER, ViewManager), source);
	}
	result = _tmp0_;
	return result;
}

static DataView*
event_source_collection_no_event_view_manager_real_create_view (ViewManager* base,
                                                                DataSource* source)
{
	EventSourceCollectionNoEventViewManager * self;
	ThumbnailView* _tmp0_;
	DataView* result;
	self = (EventSourceCollectionNoEventViewManager*) base;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = thumbnail_view_new ((ThumbnailSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
	result = (DataView*) _tmp0_;
	return result;
}

static EventSourceCollectionNoEventViewManager*
event_source_collection_no_event_view_manager_construct (GType object_type)
{
	EventSourceCollectionNoEventViewManager* self = NULL;
	self = (EventSourceCollectionNoEventViewManager*) view_manager_construct (object_type);
	return self;
}

static EventSourceCollectionNoEventViewManager*
event_source_collection_no_event_view_manager_new (void)
{
	return event_source_collection_no_event_view_manager_construct (EVENT_SOURCE_COLLECTION_TYPE_NO_EVENT_VIEW_MANAGER);
}

static void
event_source_collection_no_event_view_manager_class_init (EventSourceCollectionNoEventViewManagerClass * klass,
                                                          gpointer klass_data)
{
	event_source_collection_no_event_view_manager_parent_class = g_type_class_peek_parent (klass);
	((ViewManagerClass *) klass)->include_in_view = (gboolean (*) (ViewManager*, DataSource*)) event_source_collection_no_event_view_manager_real_include_in_view;
	((ViewManagerClass *) klass)->create_view = (DataView* (*) (ViewManager*, DataSource*)) event_source_collection_no_event_view_manager_real_create_view;
}

static void
event_source_collection_no_event_view_manager_instance_init (EventSourceCollectionNoEventViewManager * self,
                                                             gpointer klass)
{
}

static GType
event_source_collection_no_event_view_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventSourceCollectionNoEventViewManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_source_collection_no_event_view_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventSourceCollectionNoEventViewManager), 0, (GInstanceInitFunc) event_source_collection_no_event_view_manager_instance_init, NULL };
	GType event_source_collection_no_event_view_manager_type_id;
	event_source_collection_no_event_view_manager_type_id = g_type_register_static (TYPE_VIEW_MANAGER, "EventSourceCollectionNoEventViewManager", &g_define_type_info, 0);
	return event_source_collection_no_event_view_manager_type_id;
}

static GType
event_source_collection_no_event_view_manager_get_type (void)
{
	static volatile gsize event_source_collection_no_event_view_manager_type_id__once = 0;
	if (g_once_init_enter (&event_source_collection_no_event_view_manager_type_id__once)) {
		GType event_source_collection_no_event_view_manager_type_id;
		event_source_collection_no_event_view_manager_type_id = event_source_collection_no_event_view_manager_get_type_once ();
		g_once_init_leave (&event_source_collection_no_event_view_manager_type_id__once, event_source_collection_no_event_view_manager_type_id);
	}
	return event_source_collection_no_event_view_manager_type_id__once;
}

static void
event_source_collection_class_init (EventSourceCollectionClass * klass,
                                    gpointer klass_data)
{
	event_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = event_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &EventSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) event_source_collection_real_holds_type_of_source;
	((ContainerSourceCollectionClass *) klass)->get_containers_holding_source = (GeeCollection* (*) (ContainerSourceCollection*, DataSource*)) event_source_collection_real_get_containers_holding_source;
	((ContainerSourceCollectionClass *) klass)->convert_backlink_to_container = (ContainerSource* (*) (ContainerSourceCollection*, SourceBacklink*)) event_source_collection_real_convert_backlink_to_container;
	event_source_collection_signals[EVENT_SOURCE_COLLECTION_NO_EVENT_COLLECTION_ALTERED_SIGNAL] = g_signal_new ("no-event-collection-altered", TYPE_EVENT_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
event_source_collection_instance_init (EventSourceCollection * self,
                                       gpointer klass)
{
	self->priv = event_source_collection_get_instance_private (self);
}

static void
event_source_collection_finalize (DataCollection * obj)
{
	EventSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection);
	_data_collection_unref0 (self->priv->no_event);
	DATA_COLLECTION_CLASS (event_source_collection_parent_class)->finalize (obj);
}

static GType
event_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventSourceCollection), 0, (GInstanceInitFunc) event_source_collection_instance_init, NULL };
	GType event_source_collection_type_id;
	event_source_collection_type_id = g_type_register_static (TYPE_CONTAINER_SOURCE_COLLECTION, "EventSourceCollection", &g_define_type_info, 0);
	EventSourceCollection_private_offset = g_type_add_instance_private (event_source_collection_type_id, sizeof (EventSourceCollectionPrivate));
	return event_source_collection_type_id;
}

GType
event_source_collection_get_type (void)
{
	static volatile gsize event_source_collection_type_id__once = 0;
	if (g_once_init_enter (&event_source_collection_type_id__once)) {
		GType event_source_collection_type_id;
		event_source_collection_type_id = event_source_collection_get_type_once ();
		g_once_init_leave (&event_source_collection_type_id__once, event_source_collection_type_id);
	}
	return event_source_collection_type_id__once;
}

static inline gpointer
event_get_instance_private (Event* self)
{
	return G_STRUCT_MEMBER_P (self, Event_private_offset);
}

static void
_event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered (ThumbnailSource* _sender,
                                                                        gpointer self)
{
	event_on_primary_thumbnail_altered ((Event*) self);
}

static void
_event_on_media_altered_data_collection_items_altered (DataCollection* _sender,
                                                       GeeMap* items,
                                                       gpointer self)
{
	event_on_media_altered ((Event*) self, items);
}

static void
_event_on_media_removed_data_collection_items_removed (DataCollection* _sender,
                                                       GeeIterable* removed,
                                                       gpointer self)
{
	event_on_media_removed ((Event*) self, removed);
}

static void
_event_on_media_added_data_collection_items_added (DataCollection* _sender,
                                                   GeeIterable* added,
                                                   gpointer self)
{
	event_on_media_added ((Event*) self, added);
}

static void
_event_on_media_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                            DataSource* source,
                                                            gpointer self)
{
	event_on_media_destroyed ((Event*) self, source);
}

static gint64
_event_view_comparator_comparator (void* a,
                                   void* b,
                                   gpointer self)
{
	gint64 result;
	result = event_view_comparator (a, b);
	return result;
}

static gboolean
_event_view_comparator_predicate_comparator_predicate (DataObject* object,
                                                       Alteration* alteration,
                                                       gpointer self)
{
	gboolean result;
	result = event_view_comparator_predicate (object, alteration);
	return result;
}

static Event*
event_construct (GType object_type,
                 EventRow* event_row,
                 gint64 object_id)
{
	Event * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	EventID _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GeeCollection* event_source_ids = NULL;
	MediaCollectionRegistry* _tmp7_;
	MediaCollectionRegistry* _tmp8_;
	EventID _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeArrayList* event_thumbs = NULL;
	GeeArrayList* _tmp12_;
	EventID _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ViewCollection* _tmp33_;
	ViewCollection* _tmp34_;
	ViewCollection* _tmp35_;
	GeeArrayList* _tmp36_;
	GeeCollection* _tmp37_;
	GeeCollection* _tmp38_;
	GeeArrayList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	MediaCollectionRegistry* _tmp46_;
	MediaCollectionRegistry* _tmp47_;
	const gchar* _tmp48_;
	MediaSource* _tmp49_;
	gboolean _tmp50_ = FALSE;
	MediaSource* _tmp51_;
	MediaSource* _tmp64_;
	ViewCollection* _tmp66_;
	ViewCollection* _tmp67_;
	ViewCollection* _tmp68_;
	LibraryPhotoSourceCollection* _tmp69_;
	VideoSourceCollection* _tmp70_;
	g_return_val_if_fail (event_row != NULL, NULL);
	self = (Event*) event_source_construct (object_type, object_id);
	_tmp0_ = event_row->name;
	_tmp1_ = event_prep_event_name (_tmp0_);
	_g_free0 (event_row->name);
	event_row->name = _tmp1_;
	_tmp2_ = event_row->event_id;
	self->priv->event_id = _tmp2_;
	_tmp3_ = event_row->name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->raw_name);
	self->priv->raw_name = _tmp4_;
	_tmp5_ = event_row->comment;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->comment);
	self->priv->comment = _tmp6_;
	_tmp7_ = media_collection_registry_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->event_id;
	_tmp10_ = media_collection_registry_get_source_ids_for_event_id (_tmp8_, &_tmp9_);
	_tmp11_ = _tmp10_;
	_media_collection_registry_unref0 (_tmp8_);
	event_source_ids = _tmp11_;
	_tmp12_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	event_thumbs = _tmp12_;
	{
		GeeIterator* _current_source_id_it = NULL;
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_;
		_tmp13_ = event_source_ids;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_current_source_id_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gchar* current_source_id = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			MediaSource* media = NULL;
			MediaCollectionRegistry* _tmp18_;
			MediaCollectionRegistry* _tmp19_;
			const gchar* _tmp20_;
			MediaSource* _tmp21_;
			MediaSource* _tmp22_;
			MediaSource* _tmp23_;
			_tmp15_ = _current_source_id_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _current_source_id_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			current_source_id = (gchar*) _tmp17_;
			_tmp18_ = media_collection_registry_get_instance ();
			_tmp19_ = _tmp18_;
			_tmp20_ = current_source_id;
			_tmp21_ = media_collection_registry_fetch_media (_tmp19_, _tmp20_);
			_tmp22_ = _tmp21_;
			_media_collection_registry_unref0 (_tmp19_);
			media = _tmp22_;
			_tmp23_ = media;
			if (_tmp23_ != NULL) {
				GeeArrayList* _tmp24_;
				MediaSource* _tmp25_;
				ThumbnailView* _tmp26_;
				ThumbnailView* _tmp27_;
				_tmp24_ = event_thumbs;
				_tmp25_ = media;
				_tmp26_ = thumbnail_view_new ((ThumbnailSource*) _tmp25_);
				_tmp27_ = _tmp26_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp27_);
				_g_object_unref0 (_tmp27_);
			}
			_g_object_unref0 (media);
			_g_free0 (current_source_id);
		}
		_g_object_unref0 (_current_source_id_it);
	}
	_tmp28_ = self->priv->event_id;
	_tmp29_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp28_.id);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup_printf ("ViewCollection for Event %s", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = view_collection_new (_tmp32_);
	_data_collection_unref0 (self->priv->view);
	self->priv->view = _tmp33_;
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp34_ = self->priv->view;
	data_collection_set_comparator ((DataCollection*) _tmp34_, _event_view_comparator_comparator, NULL, _event_view_comparator_predicate_comparator_predicate, NULL);
	_tmp35_ = self->priv->view;
	_tmp36_ = event_thumbs;
	_tmp37_ = data_collection_add_many ((DataCollection*) _tmp35_, (GeeCollection*) _tmp36_, NULL, NULL);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (_tmp38_);
	_tmp39_ = event_thumbs;
	_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ > 0) {
		EventSourceCollection* _tmp42_;
		GeeArrayList* _tmp43_;
		EventSourceCollection* _tmp44_;
		GeeArrayList* _tmp45_;
		_tmp42_ = event_global;
		_tmp43_ = event_thumbs;
		container_source_collection_notify_container_contents_added ((ContainerSourceCollection*) _tmp42_, (ContainerSource*) self, (GeeCollection*) _tmp43_, FALSE);
		_tmp44_ = event_global;
		_tmp45_ = event_thumbs;
		container_source_collection_notify_container_contents_altered ((ContainerSourceCollection*) _tmp44_, (ContainerSource*) self, (GeeCollection*) _tmp45_, FALSE, NULL, FALSE);
	}
	_tmp46_ = media_collection_registry_get_instance ();
	_tmp47_ = _tmp46_;
	_tmp48_ = event_row->primary_source_id;
	_tmp49_ = media_collection_registry_fetch_media (_tmp47_, _tmp48_);
	_g_object_unref0 (self->priv->primary_source);
	self->priv->primary_source = _tmp49_;
	_media_collection_registry_unref0 (_tmp47_);
	_tmp51_ = self->priv->primary_source;
	if (_tmp51_ == NULL) {
		ViewCollection* _tmp52_;
		_tmp52_ = self->priv->view;
		_tmp50_ = data_collection_get_count ((DataCollection*) _tmp52_) > 0;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		ViewCollection* _tmp53_;
		DataView* _tmp54_;
		DataView* _tmp55_;
		DataSource* _tmp56_;
		DataSource* _tmp57_;
		MediaSource* _tmp58_;
		EventTable* _tmp59_;
		EventID _tmp60_;
		MediaSource* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp53_ = self->priv->view;
		_tmp54_ = view_collection_get_first_unrejected (_tmp53_);
		_tmp55_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_DATA_VIEW, DataView);
		_tmp56_ = data_view_get_source (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, TYPE_MEDIA_SOURCE, MediaSource));
		_g_object_unref0 (self->priv->primary_source);
		self->priv->primary_source = _tmp58_;
		_g_object_unref0 (_tmp55_);
		_tmp59_ = event_event_table;
		_tmp60_ = self->priv->event_id;
		_tmp61_ = self->priv->primary_source;
		_tmp62_ = data_source_get_source_id ((DataSource*) _tmp61_);
		_tmp63_ = _tmp62_;
		event_table_set_primary_source_id (_tmp59_, &_tmp60_, _tmp63_);
		_g_free0 (_tmp63_);
	}
	_tmp64_ = self->priv->primary_source;
	if (_tmp64_ != NULL) {
		MediaSource* _tmp65_;
		_tmp65_ = self->priv->primary_source;
		g_signal_connect_object ((ThumbnailSource*) _tmp65_, "thumbnail-altered", (GCallback) _event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered, self, 0);
	}
	_tmp66_ = self->priv->view;
	g_signal_connect_object ((DataCollection*) _tmp66_, "items-added", (GCallback) _event_on_media_added_data_collection_items_added, self, 0);
	_tmp67_ = self->priv->view;
	g_signal_connect_object ((DataCollection*) _tmp67_, "items-removed", (GCallback) _event_on_media_removed_data_collection_items_removed, self, 0);
	_tmp68_ = self->priv->view;
	g_signal_connect_object ((DataCollection*) _tmp68_, "items-altered", (GCallback) _event_on_media_altered_data_collection_items_altered, self, 0);
	_tmp69_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp69_, "item-destroyed", (GCallback) _event_on_media_destroyed_source_collection_item_destroyed, self, 0);
	_tmp70_ = video_global;
	g_signal_connect_object ((SourceCollection*) _tmp70_, "item-destroyed", (GCallback) _event_on_media_destroyed_source_collection_item_destroyed, self, 0);
	event_update_indexable_keywords (self);
	_g_object_unref0 (event_thumbs);
	_g_object_unref0 (event_source_ids);
	return self;
}

static Event*
event_new (EventRow* event_row,
           gint64 object_id)
{
	return event_construct (TYPE_EVENT, event_row, object_id);
}

static gchar*
event_real_get_typename (DataSource* base)
{
	Event * self;
	gchar* _tmp0_;
	gchar* result;
	self = (Event*) base;
	_tmp0_ = g_strdup (EVENT_TYPENAME);
	result = _tmp0_;
	return result;
}

static gint64
event_real_get_instance_id (DataSource* base)
{
	Event * self;
	EventID _tmp0_ = {0};
	gint64 result;
	self = (Event*) base;
	event_get_event_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static gchar*
event_real_get_representative_id (ThumbnailSource* base)
{
	Event * self;
	gchar* _tmp0_ = NULL;
	MediaSource* _tmp1_;
	gchar* result;
	self = (Event*) base;
	_tmp1_ = self->priv->primary_source;
	if (_tmp1_ != NULL) {
		MediaSource* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->primary_source;
		_tmp3_ = data_source_get_source_id ((DataSource*) _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = data_source_get_source_id ((DataSource*) self);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static PhotoFileFormat
event_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Event * self;
	PhotoFileFormat _tmp0_ = 0;
	MediaSource* _tmp1_;
	PhotoFileFormat result;
	self = (Event*) base;
	_tmp1_ = self->priv->primary_source;
	if (_tmp1_ != NULL) {
		MediaSource* _tmp2_;
		_tmp2_ = self->priv->primary_source;
		_tmp0_ = thumbnail_source_get_preferred_thumbnail_format ((ThumbnailSource*) _tmp2_);
	} else {
		_tmp0_ = photo_file_format_get_system_default_format ();
	}
	result = _tmp0_;
	return result;
}

static GdkPixbuf*
event_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Event * self;
	GdkPixbuf* _tmp0_ = NULL;
	MediaSource* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (Event*) base;
	_tmp1_ = self->priv->primary_source;
	if (_tmp1_ != NULL) {
		MediaSource* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = self->priv->primary_source;
		_tmp3_ = thumbnail_source_create_thumbnail ((ThumbnailSource*) _tmp2_, scale, &_inner_error0_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		}
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

void
event_init (ProgressMonitor monitor,
            gpointer monitor_target)
{
	EventTable* _tmp0_;
	EventSourceCollection* _tmp1_;
	EventSourceCollection* _tmp2_;
	GeeArrayList* events = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* unlinked = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* event_rows = NULL;
	EventTable* _tmp5_;
	GeeArrayList* _tmp6_;
	gint count = 0;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	EventSourceCollection* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	EventSourceCollection* _tmp28_;
	GeeArrayList* _tmp29_;
	_tmp0_ = event_table_get_instance ();
	_database_table_unref0 (event_event_table);
	event_event_table = _tmp0_;
	_tmp1_ = event_source_collection_new ();
	_data_collection_unref0 (event_global);
	event_global = _tmp1_;
	_tmp2_ = event_global;
	event_source_collection_init (_tmp2_);
	_tmp3_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	events = _tmp3_;
	_tmp4_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unlinked = _tmp4_;
	_tmp5_ = event_event_table;
	_tmp6_ = event_table_get_events (_tmp5_);
	event_rows = _tmp6_;
	_tmp7_ = event_rows;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	count = _tmp9_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				Event* event = NULL;
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				EventRow* _tmp14_;
				Event* _tmp15_;
				Event* _tmp16_;
				Event* _tmp17_;
				Event* _tmp20_;
				EventSourceCollection* _tmp21_;
				GeeArrayList* _tmp22_;
				Event* _tmp23_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = ctr;
					ctr = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp12_ = event_rows;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, ctr);
				_tmp14_ = (EventRow*) _tmp13_;
				_tmp15_ = event_new (_tmp14_, DATA_OBJECT_INVALID_OBJECT_ID);
				_tmp16_ = _tmp15_;
				_event_row_unref0 (_tmp14_);
				event = _tmp16_;
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_tmp17_ = event;
				if (event_source_get_media_count ((EventSource*) _tmp17_) != 0) {
					GeeArrayList* _tmp18_;
					Event* _tmp19_;
					_tmp18_ = events;
					_tmp19_ = event;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
					_g_object_unref0 (event);
					continue;
				}
				_tmp20_ = event;
				_tmp21_ = event_global;
				data_source_rehydrate_backlinks ((DataSource*) _tmp20_, (SourceCollection*) _tmp21_, NULL);
				_tmp22_ = unlinked;
				_tmp23_ = event;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				_g_object_unref0 (event);
			}
		}
	}
	_tmp24_ = event_global;
	_tmp25_ = events;
	_tmp26_ = data_collection_add_many ((DataCollection*) _tmp24_, (GeeCollection*) _tmp25_, NULL, NULL);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp27_);
	_tmp28_ = event_global;
	_tmp29_ = unlinked;
	container_source_collection_init_add_many_unlinked ((ContainerSourceCollection*) _tmp28_, (GeeCollection*) _tmp29_);
	_g_object_unref0 (event_rows);
	_g_object_unref0 (unlinked);
	_g_object_unref0 (events);
}

void
event_terminate (void)
{
}

static gint64
event_view_comparator (void* a,
                       void* b)
{
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	DataSource* _tmp3_;
	gint64 result;
	_tmp0_ = data_view_get_source ((DataView*) ((ThumbnailView*) a));
	_tmp1_ = _tmp0_;
	_tmp2_ = data_view_get_source ((DataView*) ((ThumbnailView*) b));
	_tmp3_ = _tmp2_;
	result = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_SOURCE, MediaSource)) - media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

static gboolean
event_view_comparator_predicate (DataObject* object,
                                 Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = alteration_has_detail (alteration, "metadata", "exposure-time");
	return result;
}

gchar*
event_prep_event_name (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = prepare_input_text (name, (((PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF, DEFAULT_USER_TEXT_INPUT_LENGTH);
	result = _tmp0_;
	return result;
}

void
event_attach (Event* self,
              MediaSource* source)
{
	ViewCollection* _tmp0_;
	ThumbnailView* _tmp1_;
	ThumbnailView* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = thumbnail_view_new ((ThumbnailSource*) source);
	_tmp2_ = _tmp1_;
	data_collection_add ((DataCollection*) _tmp0_, (DataObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}

void
event_attach_many (Event* self,
                   GeeCollection* media)
{
	GeeArrayList* views = NULL;
	GeeArrayList* _tmp0_;
	ViewCollection* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media != NULL);
	_tmp0_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	views = _tmp0_;
	{
		GeeIterator* _current_source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) media);
		_current_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* current_source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeArrayList* _tmp5_;
			MediaSource* _tmp6_;
			ThumbnailView* _tmp7_;
			ThumbnailView* _tmp8_;
			_tmp2_ = _current_source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _current_source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			current_source = (MediaSource*) _tmp4_;
			_tmp5_ = views;
			_tmp6_ = current_source;
			_tmp7_ = thumbnail_view_new ((ThumbnailSource*) _tmp6_);
			_tmp8_ = _tmp7_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp8_);
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (current_source);
		}
		_g_object_unref0 (_current_source_it);
	}
	_tmp9_ = self->priv->view;
	_tmp10_ = views;
	_tmp11_ = data_collection_add_many ((DataCollection*) _tmp9_, (GeeCollection*) _tmp10_, NULL, NULL);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (views);
}

void
event_detach (Event* self,
              MediaSource* source)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	DataView* _tmp3_;
	DataView* _tmp4_;
	Marker* _tmp5_;
	Marker* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->view;
	_tmp2_ = self->priv->view;
	_tmp3_ = view_collection_get_view_for_source (_tmp2_, (DataSource*) source);
	_tmp4_ = _tmp3_;
	_tmp5_ = data_collection_mark ((DataCollection*) _tmp1_, (DataObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	data_collection_remove_marked ((DataCollection*) _tmp0_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
}

void
event_detach_many (Event* self,
                   GeeCollection* media)
{
	GeeArrayList* views = NULL;
	GeeArrayList* _tmp0_;
	ViewCollection* _tmp11_;
	ViewCollection* _tmp12_;
	GeeArrayList* _tmp13_;
	Marker* _tmp14_;
	Marker* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media != NULL);
	_tmp0_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	views = _tmp0_;
	{
		GeeIterator* _current_source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) media);
		_current_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* current_source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ThumbnailView* view = NULL;
			ViewCollection* _tmp5_;
			MediaSource* _tmp6_;
			DataView* _tmp7_;
			ThumbnailView* _tmp8_;
			_tmp2_ = _current_source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _current_source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			current_source = (MediaSource*) _tmp4_;
			_tmp5_ = self->priv->view;
			_tmp6_ = current_source;
			_tmp7_ = view_collection_get_view_for_source (_tmp5_, (DataSource*) _tmp6_);
			view = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_THUMBNAIL_VIEW, ThumbnailView);
			_tmp8_ = view;
			if (_tmp8_ != NULL) {
				GeeArrayList* _tmp9_;
				ThumbnailView* _tmp10_;
				_tmp9_ = views;
				_tmp10_ = view;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (current_source);
		}
		_g_object_unref0 (_current_source_it);
	}
	_tmp11_ = self->priv->view;
	_tmp12_ = self->priv->view;
	_tmp13_ = views;
	_tmp14_ = data_collection_mark_many ((DataCollection*) _tmp12_, (GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	data_collection_remove_marked ((DataCollection*) _tmp11_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (views);
}

gboolean
event_contains_media_type (Event* self,
                           const gchar* media_type)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (media_type != NULL, FALSE);
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = event_source_get_media ((EventSource*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_media_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSource* media = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSource* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _media_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _media_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			media = (MediaSource*) _tmp6_;
			_tmp7_ = media;
			_tmp8_ = data_source_get_typename ((DataSource*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp9_, media_type) == 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				result = TRUE;
				_g_object_unref0 (media);
				_g_object_unref0 (_media_it);
				return result;
			}
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	result = FALSE;
	return result;
}

static GeeArrayList*
event_views_to_media (Event* self,
                      GeeIterable* views)
{
	GeeArrayList* media = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (views != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	media = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (views);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeArrayList* _tmp5_;
			DataObject* _tmp6_;
			DataSource* _tmp7_;
			DataSource* _tmp8_;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = media;
			_tmp6_ = object;
			_tmp7_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView));
			_tmp8_ = _tmp7_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = media;
	return result;
}

static void
event_on_media_added (Event* self,
                      GeeIterable* added)
{
	GeeCollection* media = NULL;
	GeeArrayList* _tmp0_;
	EventSourceCollection* _tmp1_;
	EventSourceCollection* _tmp2_;
	Alteration* _tmp3_;
	Alteration* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	_tmp0_ = event_views_to_media (self, added);
	media = (GeeCollection*) _tmp0_;
	_tmp1_ = event_global;
	container_source_collection_notify_container_contents_added ((ContainerSourceCollection*) _tmp1_, (ContainerSource*) self, media, self->priv->relinking);
	_tmp2_ = event_global;
	container_source_collection_notify_container_contents_altered ((ContainerSourceCollection*) _tmp2_, (ContainerSource*) self, media, self->priv->relinking, NULL, FALSE);
	_tmp3_ = alteration_new_from_list ("contents:added, metadata:time");
	_tmp4_ = _tmp3_;
	data_object_notify_altered ((DataObject*) self, _tmp4_);
	_alteration_unref0 (_tmp4_);
	_g_object_unref0 (media);
}

static void
event_on_media_removed (Event* self,
                        GeeIterable* removed)
{
	GeeArrayList* media = NULL;
	GeeArrayList* _tmp0_;
	EventSourceCollection* _tmp1_;
	GeeArrayList* _tmp2_;
	EventSourceCollection* _tmp3_;
	GeeArrayList* _tmp4_;
	Alteration* _tmp21_;
	Alteration* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = event_views_to_media (self, removed);
	media = _tmp0_;
	_tmp1_ = event_global;
	_tmp2_ = media;
	container_source_collection_notify_container_contents_removed ((ContainerSourceCollection*) _tmp1_, (ContainerSource*) self, (GeeCollection*) _tmp2_, self->priv->unlinking);
	_tmp3_ = event_global;
	_tmp4_ = media;
	container_source_collection_notify_container_contents_altered ((ContainerSourceCollection*) _tmp3_, (ContainerSource*) self, NULL, FALSE, (GeeCollection*) _tmp4_, self->priv->unlinking);
	{
		GeeArrayList* _current_source_list = NULL;
		GeeArrayList* _tmp5_;
		gint _current_source_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _current_source_index = 0;
		_tmp5_ = media;
		_current_source_list = _tmp5_;
		_tmp6_ = _current_source_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_current_source_size = _tmp8_;
		_current_source_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			MediaSource* current_source = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			MediaSource* _tmp13_;
			MediaSource* _tmp14_;
			_current_source_index = _current_source_index + 1;
			_tmp9_ = _current_source_index;
			_tmp10_ = _current_source_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _current_source_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _current_source_index);
			current_source = (MediaSource*) _tmp12_;
			_tmp13_ = current_source;
			_tmp14_ = self->priv->primary_source;
			if (_tmp13_ == _tmp14_) {
				if (event_source_get_media_count ((EventSource*) self) > 0) {
					ViewCollection* _tmp15_;
					DataView* _tmp16_;
					DataView* _tmp17_;
					DataSource* _tmp18_;
					DataSource* _tmp19_;
					_tmp15_ = self->priv->view;
					_tmp16_ = view_collection_get_first_unrejected (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = data_view_get_source (_tmp17_);
					_tmp19_ = _tmp18_;
					event_set_primary_source (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_MEDIA_SOURCE, MediaSource));
					_g_object_unref0 (_tmp17_);
				} else {
					event_release_primary_source (self);
				}
				_g_object_unref0 (current_source);
				break;
			}
			_g_object_unref0 (current_source);
		}
	}
	if (event_source_get_media_count ((EventSource*) self) == 0) {
		EventSourceCollection* _tmp20_;
		_tmp20_ = event_global;
		container_source_collection_evaporate ((ContainerSourceCollection*) _tmp20_, (ContainerSource*) self);
		_g_object_unref0 (media);
		return;
	}
	_tmp21_ = alteration_new_from_list ("contents:removed, metadata:time");
	_tmp22_ = _tmp21_;
	data_object_notify_altered ((DataObject*) self, _tmp22_);
	_alteration_unref0 (_tmp22_);
	_g_object_unref0 (media);
}

static void
event_on_media_destroyed (Event* self,
                          DataSource* source)
{
	ThumbnailView* thumbnail_view = NULL;
	ViewCollection* _tmp0_;
	DataView* _tmp1_;
	ThumbnailView* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = view_collection_get_view_for_source (_tmp0_, source);
	thumbnail_view = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_THUMBNAIL_VIEW, ThumbnailView);
	_tmp2_ = thumbnail_view;
	if (_tmp2_ != NULL) {
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		ThumbnailView* _tmp5_;
		Marker* _tmp6_;
		Marker* _tmp7_;
		_tmp3_ = self->priv->view;
		_tmp4_ = self->priv->view;
		_tmp5_ = thumbnail_view;
		_tmp6_ = data_collection_mark ((DataCollection*) _tmp4_, (DataObject*) _tmp5_);
		_tmp7_ = _tmp6_;
		data_collection_remove_marked ((DataCollection*) _tmp3_, _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
	_g_object_unref0 (thumbnail_view);
}

static void
event_real_notify_relinking (DataSource* base,
                             SourceCollection* sources)
{
	Event * self;
	MediaSource* _tmp0_;
	self = (Event*) base;
	g_return_if_fail (sources != NULL);
	_vala_assert (event_source_get_media_count ((EventSource*) self) > 0, "get_media_count () > 0");
	_tmp0_ = self->priv->primary_source;
	if (_tmp0_ == NULL) {
		ViewCollection* _tmp1_;
		DataView* _tmp2_;
		DataView* _tmp3_;
		DataSource* _tmp4_;
		DataSource* _tmp5_;
		_tmp1_ = self->priv->view;
		_tmp2_ = view_collection_get_first_unrejected (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = data_view_get_source (_tmp3_);
		_tmp5_ = _tmp4_;
		event_set_primary_source (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource));
		_g_object_unref0 (_tmp3_);
	}
	DATA_SOURCE_CLASS (event_parent_class)->notify_relinking ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EVENT_SOURCE, EventSource), sources);
}

/** @brief This gets called when one or more media items inside this
     *  event gets modified in some fashion. If the media item's date changes
     *  and the event was previously undated, the name of the event needs to
     *  change as well; all of that happens automatically in here.
     *
     *  In addition, if the _rating_ of one or more media items has changed,
     *  the thumbnail of this event may need to change, as the primary
     *  image may have been rejected and should not be the thumbnail anymore.
     */
static void
event_on_media_altered (Event* self,
                        GeeMap* items)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (items != NULL);
	{
		GeeIterator* _alteration_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_values (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_alteration_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			Alteration* alteration = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* _tmp8_;
			_tmp5_ = _alteration_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _alteration_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			alteration = (Alteration*) _tmp7_;
			_tmp8_ = alteration;
			if (alteration_has_detail (_tmp8_, "metadata", "exposure-time")) {
				gchar* alt_list = NULL;
				gchar* _tmp9_;
				const gchar* _tmp12_;
				Alteration* _tmp13_;
				Alteration* _tmp14_;
				_tmp9_ = g_strdup ("metadata:time");
				alt_list = _tmp9_;
				if (!event_has_name (self)) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = alt_list;
					_tmp11_ = g_strconcat (_tmp10_, ", metadata:name", NULL);
					_g_free0 (alt_list);
					alt_list = _tmp11_;
				}
				_tmp12_ = alt_list;
				_tmp13_ = alteration_new_from_list (_tmp12_);
				_tmp14_ = _tmp13_;
				data_object_notify_altered ((DataObject*) self, _tmp14_);
				_alteration_unref0 (_tmp14_);
				_g_free0 (alt_list);
				_alteration_unref0 (alteration);
				break;
			}
			_alteration_unref0 (alteration);
		}
		_g_object_unref0 (_alteration_it);
	}
}

Event*
event_create_empty_event (MediaSource* source)
{
	GError* _inner_error0_ = NULL;
	Event* result;
	g_return_val_if_fail (source != NULL, NULL);
	{
		EventRow* _tmp0_ = NULL;
		EventTable* _tmp1_;
		EventTable* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		EventRow* _tmp5_;
		EventRow* _tmp6_;
		Event* event = NULL;
		Event* _tmp7_;
		EventSourceCollection* _tmp8_;
		Event* _tmp9_;
		Event* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = event_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = data_source_get_source_id ((DataSource*) source);
		_tmp4_ = _tmp3_;
		_tmp5_ = event_table_create (_tmp2_, _tmp4_, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp7_ = event_new (_tmp0_, DATA_OBJECT_INVALID_OBJECT_ID);
		event = _tmp7_;
		_tmp8_ = event_global;
		_tmp9_ = event;
		data_collection_add ((DataCollection*) _tmp8_, (DataObject*) _tmp9_);
		_tmp10_ = event;
		_tmp11_ = data_object_to_string ((DataObject*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_debug ("Event.vala:477: Created empty event %s", _tmp12_);
		_g_free0 (_tmp12_);
		result = event;
		_event_row_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		app_window_database_error (_tmp13_);
		result = NULL;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static Event*
event_reconstitute (gint64 object_id,
                    EventRow* row)
{
	EventTable* _tmp0_;
	EventTable* _tmp1_;
	EventID _tmp2_ = {0};
	Event* event = NULL;
	Event* _tmp3_;
	EventSourceCollection* _tmp4_;
	EventSourceCollection* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Event* result;
	g_return_val_if_fail (row != NULL, NULL);
	_tmp0_ = event_table_get_instance ();
	_tmp1_ = _tmp0_;
	event_table_create_from_row (_tmp1_, row, &_tmp2_);
	row->event_id = _tmp2_;
	_database_table_unref0 (_tmp1_);
	_tmp3_ = event_new (row, object_id);
	event = _tmp3_;
	_tmp4_ = event_global;
	data_collection_add ((DataCollection*) _tmp4_, (DataObject*) event);
	_tmp5_ = event_global;
	_vala_assert (data_collection_contains ((DataCollection*) _tmp5_, (DataObject*) event), "global.contains (event)");
	_tmp6_ = data_object_to_string ((DataObject*) event);
	_tmp7_ = _tmp6_;
	g_debug ("Event.vala:494: Reconstituted event %s", _tmp7_);
	_g_free0 (_tmp7_);
	result = event;
	return result;
}

static gboolean
event_real_has_links (ContainerSource* base)
{
	Event * self;
	gboolean _tmp0_ = FALSE;
	LibraryPhotoSourceCollection* _tmp1_;
	SourceBacklink* _tmp2_;
	SourceBacklink* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	self = (Event*) base;
	_tmp1_ = library_photo_global;
	_tmp2_ = container_source_get_backlink ((ContainerSource*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = source_collection_has_backlink ((SourceCollection*) _tmp1_, _tmp3_);
	_source_backlink_unref0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		VideoSourceCollection* _tmp5_;
		SourceBacklink* _tmp6_;
		SourceBacklink* _tmp7_;
		_tmp5_ = video_global;
		_tmp6_ = container_source_get_backlink ((ContainerSource*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = source_collection_has_backlink ((SourceCollection*) _tmp5_, _tmp7_);
		_source_backlink_unref0 (_tmp7_);
	}
	result = _tmp0_;
	return result;
}

static SourceBacklink*
event_real_get_backlink (ContainerSource* base)
{
	Event * self;
	SourceBacklink* _tmp0_;
	SourceBacklink* result;
	self = (Event*) base;
	_tmp0_ = source_backlink_new_from_source ((DataSource*) self);
	result = _tmp0_;
	return result;
}

static void
event_real_break_link (ContainerSource* base,
                       DataSource* source)
{
	Event * self;
	self = (Event*) base;
	g_return_if_fail (source != NULL);
	self->priv->unlinking = TRUE;
	media_source_set_event (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource), NULL);
	self->priv->unlinking = FALSE;
}

static void
event_real_break_link_many (ContainerSource* base,
                            GeeCollection* sources)
{
	Event * self;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (Event*) base;
	g_return_if_fail (sources != NULL);
	self->priv->unlinking = TRUE;
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	videos = _tmp1_;
	media_source_collection_filter_media (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection), (GeeCollection*) photos, (GeeCollection*) videos);
	{
		LibraryPhotoSourceCollection* _tmp2_;
		TransactionController* _tmp3_;
		TransactionController* _tmp4_;
		_tmp2_ = library_photo_global;
		_tmp3_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		media_source_set_many_to_event ((GeeCollection*) photos, NULL, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("%s", _tmp6_);
		_tmp8_ = _tmp7_;
		app_window_error_message (_tmp8_, NULL, NULL);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (videos);
		_g_object_unref0 (photos);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		VideoSourceCollection* _tmp9_;
		TransactionController* _tmp10_;
		TransactionController* _tmp11_;
		_tmp9_ = video_global;
		_tmp10_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		media_source_set_many_to_event ((GeeCollection*) videos, NULL, _tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strdup_printf ("%s", _tmp13_);
		_tmp15_ = _tmp14_;
		app_window_error_message (_tmp15_, NULL, NULL);
		_g_free0 (_tmp15_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (videos);
		_g_object_unref0 (photos);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->unlinking = FALSE;
	_g_object_unref0 (videos);
	_g_object_unref0 (photos);
}

static void
event_real_establish_link (ContainerSource* base,
                           DataSource* source)
{
	Event * self;
	self = (Event*) base;
	g_return_if_fail (source != NULL);
	self->priv->relinking = TRUE;
	media_source_set_event (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource), self);
	self->priv->relinking = FALSE;
}

static void
event_real_establish_link_many (ContainerSource* base,
                                GeeCollection* sources)
{
	Event * self;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (Event*) base;
	g_return_if_fail (sources != NULL);
	self->priv->relinking = TRUE;
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	videos = _tmp1_;
	media_source_collection_filter_media (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection), (GeeCollection*) photos, (GeeCollection*) videos);
	{
		LibraryPhotoSourceCollection* _tmp2_;
		TransactionController* _tmp3_;
		TransactionController* _tmp4_;
		_tmp2_ = library_photo_global;
		_tmp3_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		media_source_set_many_to_event ((GeeCollection*) photos, self, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("%s", _tmp6_);
		_tmp8_ = _tmp7_;
		app_window_error_message (_tmp8_, NULL, NULL);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (videos);
		_g_object_unref0 (photos);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		VideoSourceCollection* _tmp9_;
		TransactionController* _tmp10_;
		TransactionController* _tmp11_;
		_tmp9_ = video_global;
		_tmp10_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		media_source_set_many_to_event ((GeeCollection*) videos, self, _tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strdup_printf ("%s", _tmp13_);
		_tmp15_ = _tmp14_;
		app_window_error_message (_tmp15_, NULL, NULL);
		_g_free0 (_tmp15_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (videos);
		_g_object_unref0 (photos);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->relinking = FALSE;
	_g_object_unref0 (videos);
	_g_object_unref0 (photos);
}

static void
event_update_indexable_keywords (Event* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = event_get_raw_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = indexable_prepare_indexable_string (_tmp1_);
	_g_free0 (self->priv->indexable_keywords);
	self->priv->indexable_keywords = _tmp2_;
	_g_free0 (_tmp1_);
}

static const gchar*
event_real_get_indexable_keywords (Indexable* base)
{
	Event * self;
	const gchar* _tmp0_;
	const gchar* result;
	self = (Event*) base;
	_tmp0_ = self->priv->indexable_keywords;
	result = _tmp0_;
	return result;
}

gboolean
event_is_in_starting_day (Event* self,
                          gint64 time)
{
	ViewCollection* _tmp0_;
	MediaSource* earliest_media = NULL;
	ViewCollection* _tmp1_;
	DataObject* _tmp2_;
	DataView* _tmp3_;
	DataSource* _tmp4_;
	DataSource* _tmp5_;
	MediaSource* _tmp6_;
	MediaSource* _tmp7_;
	GDateTime* earliest_tm = NULL;
	MediaSource* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* start_boundary_dt = NULL;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	gint64 start_boundary = 0LL;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	gint64 end_boundary = 0LL;
	gboolean _tmp16_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->view;
	if (data_collection_get_count ((DataCollection*) _tmp0_) == 0) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->view;
	_tmp2_ = data_collection_get_at ((DataCollection*) _tmp1_, 0);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView);
	_tmp4_ = data_view_get_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	earliest_media = _tmp7_;
	_tmp8_ = earliest_media;
	_tmp9_ = g_date_time_new_from_unix_local (media_source_get_exposure_time (_tmp8_));
	earliest_tm = _tmp9_;
	_tmp10_ = earliest_tm;
	_tmp11_ = earliest_tm;
	_tmp12_ = earliest_tm;
	_tmp13_ = g_date_time_new_local (g_date_time_get_year (_tmp10_), g_date_time_get_month (_tmp11_), g_date_time_get_day_of_month (_tmp12_), EVENT_EVENT_BOUNDARY_HOUR, 0, 0.0);
	start_boundary_dt = _tmp13_;
	_tmp14_ = start_boundary_dt;
	start_boundary = g_date_time_to_unix (_tmp14_);
	_tmp15_ = earliest_tm;
	if (g_date_time_get_hour (_tmp15_) < EVENT_EVENT_BOUNDARY_HOUR) {
		start_boundary -= EVENT_SECONDS_PER_DAY;
	}
	end_boundary = (start_boundary + EVENT_SECONDS_PER_DAY) - 1;
	if (time >= start_boundary) {
		_tmp16_ = time <= end_boundary;
	} else {
		_tmp16_ = FALSE;
	}
	result = _tmp16_;
	_g_date_time_unref0 (start_boundary_dt);
	_g_date_time_unref0 (earliest_tm);
	_g_object_unref0 (earliest_media);
	return result;
}

static Event*
event_generate_event (MediaSource* media,
                      ViewCollection* events_so_far,
                      const gchar* event_name,
                      gboolean* new_event)
{
	gboolean _vala_new_event = FALSE;
	gint64 exposure_time = 0LL;
	gboolean _tmp0_ = FALSE;
	gint count = 0;
	GError* _inner_error0_ = NULL;
	Event* result;
	g_return_val_if_fail (media != NULL, NULL);
	g_return_val_if_fail (events_so_far != NULL, NULL);
	exposure_time = media_source_get_exposure_time (media);
	if (exposure_time == ((gint64) 0)) {
		_tmp0_ = event_name == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = data_object_to_string ((DataObject*) media);
		_tmp2_ = _tmp1_;
		g_debug ("Event.vala:617: Skipping event assignment to %s: no exposure time and " \
"no event name", _tmp2_);
		_g_free0 (_tmp2_);
		_vala_new_event = FALSE;
		result = NULL;
		if (new_event) {
			*new_event = _vala_new_event;
		}
		return result;
	}
	count = data_collection_get_count ((DataCollection*) events_so_far);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				Event* event = NULL;
				DataObject* _tmp5_;
				EventView* _tmp6_;
				DataSource* _tmp7_;
				DataSource* _tmp8_;
				Event* _tmp9_;
				Event* _tmp10_;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp5_ = data_collection_get_at ((DataCollection*) events_so_far, ctr);
				_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_EVENT_VIEW, EventView);
				_tmp7_ = data_view_get_source ((DataView*) _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_EVENT, Event));
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp6_);
				event = _tmp10_;
				if (event_name != NULL) {
					Event* _tmp14_;
					_tmp14_ = event;
					_tmp13_ = event_has_name (_tmp14_);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					Event* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = event;
					_tmp16_ = data_object_get_name ((DataObject*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp12_ = g_strcmp0 (event_name, _tmp17_) == 0;
					_g_free0 (_tmp17_);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					Event* _tmp18_;
					_tmp18_ = event;
					_tmp11_ = event_is_in_starting_day (_tmp18_, exposure_time);
				}
				if (_tmp11_) {
					_vala_new_event = FALSE;
					result = event;
					if (new_event) {
						*new_event = _vala_new_event;
					}
					return result;
				}
				_g_object_unref0 (event);
			}
		}
	}
	{
		EventRow* _tmp19_ = NULL;
		EventTable* _tmp20_;
		EventTable* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		EventRow* _tmp24_;
		EventRow* _tmp25_;
		Event* event = NULL;
		Event* _tmp26_;
		Event* _tmp28_;
		EventView* _tmp29_;
		EventView* _tmp30_;
		_tmp20_ = event_table_get_instance ();
		_tmp21_ = _tmp20_;
		_tmp22_ = data_source_get_source_id ((DataSource*) media);
		_tmp23_ = _tmp22_;
		_tmp24_ = event_table_create (_tmp21_, _tmp23_, NULL, &_inner_error0_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_database_table_unref0 (_tmp21_);
		_tmp19_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp26_ = event_new (_tmp19_, DATA_OBJECT_INVALID_OBJECT_ID);
		event = _tmp26_;
		if (event_name != NULL) {
			Event* _tmp27_;
			_tmp27_ = event;
			event_rename (_tmp27_, event_name);
		}
		_tmp28_ = event;
		_tmp29_ = event_view_new ((EventSource*) _tmp28_);
		_tmp30_ = _tmp29_;
		data_collection_add ((DataCollection*) events_so_far, (DataObject*) _tmp30_);
		_g_object_unref0 (_tmp30_);
		_vala_new_event = TRUE;
		result = event;
		_event_row_unref0 (_tmp19_);
		if (new_event) {
			*new_event = _vala_new_event;
		}
		return result;
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp31_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = err;
		app_window_database_error (_tmp31_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_vala_new_event = FALSE;
	result = NULL;
	if (new_event) {
		*new_event = _vala_new_event;
	}
	return result;
}

void
event_generate_single_event (MediaSource* media,
                             ViewCollection* events_so_far,
                             const gchar* event_name)
{
	Event* _tmp0_;
	Event* _tmp1_;
	gboolean _tmp2_;
	gboolean new_event = FALSE;
	Event* event = NULL;
	gboolean _tmp3_ = FALSE;
	Event* _tmp4_;
	Event* _tmp5_;
	Event* _tmp6_;
	g_return_if_fail (media != NULL);
	g_return_if_fail (events_so_far != NULL);
	_tmp0_ = media_source_get_event (media);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp4_ = event_generate_event (media, events_so_far, event_name, &_tmp3_);
	new_event = _tmp3_;
	event = _tmp4_;
	_tmp5_ = event;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (event);
		return;
	}
	_tmp6_ = event;
	media_source_set_event (media, _tmp6_);
	if (new_event) {
		EventSourceCollection* _tmp7_;
		Event* _tmp8_;
		_tmp7_ = event_global;
		_tmp8_ = event;
		data_collection_add ((DataCollection*) _tmp7_, (DataObject*) _tmp8_);
	}
	_g_object_unref0 (event);
}

void
event_generate_many_events (GeeCollection* sources,
                            ViewCollection* events_so_far)
{
	GeeCollection* to_add = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (sources != NULL);
	g_return_if_fail (events_so_far != NULL);
	_tmp0_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	to_add = (GeeCollection*) _tmp0_;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) sources);
		_media_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* media = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			MediaSource* _tmp5_;
			Event* _tmp6_;
			Event* _tmp7_;
			gboolean _tmp8_;
			gboolean new_event = FALSE;
			Event* event = NULL;
			MediaSource* _tmp9_;
			gboolean _tmp10_ = FALSE;
			Event* _tmp11_;
			Event* _tmp12_;
			MediaSource* _tmp13_;
			Event* _tmp14_;
			_tmp2_ = _media_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _media_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			media = (MediaSource*) _tmp4_;
			_tmp5_ = media;
			_tmp6_ = media_source_get_event (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_g_object_unref0 (_tmp7_);
			if (_tmp8_) {
				_g_object_unref0 (media);
				continue;
			}
			_tmp9_ = media;
			_tmp11_ = event_generate_event (_tmp9_, events_so_far, NULL, &_tmp10_);
			new_event = _tmp10_;
			event = _tmp11_;
			_tmp12_ = event;
			if (_tmp12_ == NULL) {
				_g_object_unref0 (event);
				_g_object_unref0 (media);
				continue;
			}
			_tmp13_ = media;
			_tmp14_ = event;
			media_source_set_event (_tmp13_, _tmp14_);
			if (new_event) {
				GeeCollection* _tmp15_;
				Event* _tmp16_;
				_tmp15_ = to_add;
				_tmp16_ = event;
				gee_collection_add (_tmp15_, _tmp16_);
			}
			_g_object_unref0 (event);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	_tmp17_ = to_add;
	_tmp18_ = gee_collection_get_size (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		EventSourceCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeCollection* _tmp22_;
		GeeCollection* _tmp23_;
		_tmp20_ = event_global;
		_tmp21_ = to_add;
		_tmp22_ = data_collection_add_many ((DataCollection*) _tmp20_, _tmp21_, NULL, NULL);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp23_);
	}
	_g_object_unref0 (to_add);
}

void
event_get_event_id (Event* self,
                    EventID* result)
{
	EventID _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->event_id;
	*result = _tmp0_;
	return;
}

static SourceSnapshot*
event_real_save_snapshot (DataSource* base)
{
	Event * self;
	EventEventSnapshot* _tmp0_;
	SourceSnapshot* result;
	self = (Event*) base;
	_tmp0_ = event_event_snapshot_new (self);
	result = (SourceSnapshot*) _tmp0_;
	return result;
}

static SourceProxy*
event_real_get_proxy (Proxyable* base)
{
	Event * self;
	EventEventProxy* _tmp0_;
	SourceProxy* result;
	self = (Event*) base;
	_tmp0_ = event_event_proxy_new (self);
	result = (SourceProxy*) _tmp0_;
	return result;
}

static gboolean
event_real_equals (DataSource* base,
                   DataSource* source)
{
	Event * self;
	Event* event = NULL;
	Event* _tmp0_;
	Event* _tmp1_;
	gboolean result;
	self = (Event*) base;
	_tmp0_ = _g_object_ref0 (IS_EVENT (source) ? ((Event*) source) : NULL);
	event = _tmp0_;
	_tmp1_ = event;
	if (_tmp1_ != NULL) {
		Event* _tmp2_;
		_tmp2_ = event;
		if (self != _tmp2_) {
			EventID _tmp3_;
			Event* _tmp4_;
			EventID _tmp5_;
			_tmp3_ = self->priv->event_id;
			_tmp4_ = event;
			_tmp5_ = _tmp4_->priv->event_id;
			_vala_assert (_tmp3_.id != _tmp5_.id, "event_id.id != event.event_id.id");
		}
	}
	result = DATA_SOURCE_CLASS (event_parent_class)->equals ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EVENT_SOURCE, EventSource), source);
	_g_object_unref0 (event);
	return result;
}

static gchar*
event_real_to_string (DataObject* base)
{
	Event * self;
	EventID _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	self = (Event*) base;
	_tmp0_ = self->priv->event_id;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_.id);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, data_object_get_object_id ((DataObject*) self));
	_tmp4_ = _tmp3_;
	_tmp5_ = data_object_get_name ((DataObject*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("Event [%s/%s] %s", _tmp2_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp8_;
	return result;
}

gboolean
event_has_name (Event* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->raw_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->raw_name;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gchar*
event_real_get_name (DataObject* base)
{
	Event * self;
	gchar* datestring = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* result;
	self = (Event*) base;
	if (event_has_name (self)) {
		gchar* _tmp0_;
		_tmp0_ = event_get_raw_name (self);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = event_get_formatted_daterange (self);
	datestring = _tmp1_;
	_tmp3_ = datestring;
	if (!is_string_empty (_tmp3_)) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = datestring;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		EventID _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->event_id;
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_.id);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf (_ ("Event %s"), _tmp8_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp9_;
		_g_free0 (_tmp8_);
	}
	result = _tmp2_;
	_g_free0 (datestring);
	return result;
}

gchar*
event_get_formatted_daterange (Event* self)
{
	gint64 start_time = 0LL;
	gint64 end_time = 0LL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GDateTime* start = NULL;
	GDateTime* _tmp6_;
	GDateTime* end = NULL;
	GDateTime* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	start_time = event_source_get_start_time ((EventSource*) self);
	end_time = event_source_get_end_time ((EventSource*) self);
	if (end_time == ((gint64) 0)) {
		_tmp0_ = start_time == ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	if (end_time == ((gint64) 0)) {
		_tmp1_ = start_time != ((gint64) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = g_date_time_new_from_unix_local (start_time);
		_tmp3_ = _tmp2_;
		_tmp4_ = format_local_date (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_date_time_unref0 (_tmp3_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_date_time_new_from_unix_local (start_time);
	start = _tmp6_;
	_tmp7_ = g_date_time_new_from_unix_local (end_time);
	end = _tmp7_;
	_tmp10_ = start;
	_tmp11_ = end;
	if (g_date_time_get_year (_tmp10_) == g_date_time_get_year (_tmp11_)) {
		GDateTime* _tmp12_;
		GDateTime* _tmp13_;
		_tmp12_ = start;
		_tmp13_ = end;
		_tmp9_ = g_date_time_get_month (_tmp12_) == g_date_time_get_month (_tmp13_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		_tmp14_ = start;
		_tmp15_ = end;
		_tmp8_ = g_date_time_get_day_of_month (_tmp14_) == g_date_time_get_day_of_month (_tmp15_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = g_date_time_new_from_unix_local (start_time);
		_tmp17_ = _tmp16_;
		_tmp18_ = format_local_date (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_date_time_unref0 (_tmp17_);
		result = _tmp19_;
		_g_date_time_unref0 (end);
		_g_date_time_unref0 (start);
		return result;
	}
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = format_local_datespan (_tmp20_, _tmp21_);
	result = _tmp22_;
	_g_date_time_unref0 (end);
	_g_date_time_unref0 (start);
	return result;
}

gchar*
event_get_raw_name (Event* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->raw_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
event_real_get_comment (EventSource* base)
{
	Event * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (Event*) base;
	_tmp0_ = self->priv->comment;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
event_rename (Event* self,
              const gchar* name)
{
	gchar* new_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean renamed = FALSE;
	EventTable* _tmp6_;
	EventID _tmp7_;
	const gchar* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = event_prep_event_name (name);
	new_name = _tmp0_;
	_tmp1_ = new_name;
	_tmp2_ = event_get_formatted_daterange (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (new_name);
		new_name = _tmp5_;
	}
	_tmp6_ = event_event_table;
	_tmp7_ = self->priv->event_id;
	_tmp8_ = new_name;
	renamed = event_table_rename (_tmp6_, &_tmp7_, _tmp8_);
	if (renamed) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		Alteration* _tmp11_;
		Alteration* _tmp12_;
		_tmp9_ = new_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->raw_name);
		self->priv->raw_name = _tmp10_;
		event_update_indexable_keywords (self);
		_tmp11_ = alteration_new_from_list ("metadata:name, indexable:keywords");
		_tmp12_ = _tmp11_;
		data_object_notify_altered ((DataObject*) self, _tmp12_);
		_alteration_unref0 (_tmp12_);
	}
	result = renamed;
	_g_free0 (new_name);
	return result;
}

static gboolean
event_real_set_comment (EventSource* base,
                        const gchar* comment)
{
	Event * self;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	EventTable* _tmp1_;
	EventID _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	self = (Event*) base;
	_tmp0_ = media_source_prep_comment (comment);
	new_comment = _tmp0_;
	_tmp1_ = event_event_table;
	_tmp2_ = self->priv->event_id;
	_tmp3_ = new_comment;
	committed = event_table_set_comment (_tmp1_, &_tmp2_, _tmp3_);
	if (committed) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		Alteration* _tmp6_;
		Alteration* _tmp7_;
		_tmp4_ = new_comment;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->priv->comment);
		self->priv->comment = _tmp5_;
		_tmp6_ = alteration_new_from_list ("metadata:comment, indexable:keywords");
		_tmp7_ = _tmp6_;
		data_object_notify_altered ((DataObject*) self, _tmp7_);
		_alteration_unref0 (_tmp7_);
	}
	result = committed;
	_g_free0 (new_comment);
	return result;
}

gint64
event_get_creation_time (Event* self)
{
	EventTable* _tmp0_;
	EventID _tmp1_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = event_event_table;
	_tmp1_ = self->priv->event_id;
	result = event_table_get_time_created (_tmp0_, &_tmp1_);
	return result;
}

static gint64
event_real_get_start_time (EventSource* base)
{
	Event * self;
	gint count = 0;
	ViewCollection* _tmp0_;
	gint64 result;
	self = (Event*) base;
	_tmp0_ = self->priv->view;
	count = data_collection_get_count ((DataCollection*) _tmp0_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint64 time = 0LL;
				ViewCollection* _tmp3_;
				DataObject* _tmp4_;
				DataView* _tmp5_;
				DataSource* _tmp6_;
				DataSource* _tmp7_;
				gint64 _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp3_ = self->priv->view;
				_tmp4_ = data_collection_get_at ((DataCollection*) _tmp3_, i);
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView);
				_tmp6_ = data_view_get_source (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
				_g_object_unref0 (_tmp5_);
				time = _tmp8_;
				if (time != ((gint64) 0)) {
					result = time;
					return result;
				}
			}
		}
	}
	result = (gint64) 0;
	return result;
}

static gint64
event_real_get_end_time (EventSource* base)
{
	Event * self;
	gint count = 0;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	DataObject* _tmp2_;
	DataView* _tmp3_;
	DataSource* _tmp4_;
	DataSource* _tmp5_;
	gint64 _tmp6_;
	gint64 result;
	self = (Event*) base;
	_tmp0_ = self->priv->view;
	count = data_collection_get_count ((DataCollection*) _tmp0_);
	if (count == 0) {
		result = (gint64) 0;
		return result;
	}
	_tmp1_ = self->priv->view;
	_tmp2_ = data_collection_get_at ((DataCollection*) _tmp1_, count - 1);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView);
	_tmp4_ = data_view_get_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource));
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

static guint64
event_real_get_total_filesize (EventSource* base)
{
	Event * self;
	guint64 total = 0ULL;
	guint64 result;
	self = (Event*) base;
	total = (guint64) 0;
	{
		GeeIterator* _current_source_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = event_source_get_media ((EventSource*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_current_source_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSource* current_source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			MediaSource* _tmp7_;
			_tmp4_ = _current_source_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _current_source_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			current_source = (MediaSource*) _tmp6_;
			_tmp7_ = current_source;
			total += media_source_get_filesize (_tmp7_);
			_g_object_unref0 (current_source);
		}
		_g_object_unref0 (_current_source_it);
	}
	result = total;
	return result;
}

static gint
event_real_get_media_count (EventSource* base)
{
	Event * self;
	ViewCollection* _tmp0_;
	gint result;
	self = (Event*) base;
	_tmp0_ = self->priv->view;
	result = data_collection_get_count ((DataCollection*) _tmp0_);
	return result;
}

static GeeCollection*
event_real_get_media (EventSource* base)
{
	Event * self;
	ViewCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	self = (Event*) base;
	_tmp0_ = self->priv->view;
	_tmp1_ = view_collection_get_sources (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

void
event_mirror_photos (Event* self,
                     ViewCollection* view,
                     CreateView mirroring_ctor,
                     gpointer mirroring_ctor_target)
{
	ViewCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = self->priv->view;
	view_collection_mirror (view, _tmp0_, mirroring_ctor, mirroring_ctor_target, NULL, NULL);
}

static void
event_on_primary_thumbnail_altered (Event* self)
{
	g_return_if_fail (self != NULL);
	thumbnail_source_notify_thumbnail_altered ((ThumbnailSource*) self);
}

MediaSource*
event_get_primary_source (Event* self)
{
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->primary_source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
event_set_primary_source (Event* self,
                          MediaSource* source)
{
	ViewCollection* _tmp0_;
	gboolean committed = FALSE;
	EventTable* _tmp1_;
	EventID _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->priv->view;
	_vala_assert (view_collection_has_view_for_source (_tmp0_, (DataSource*) source), "view.has_view_for_source (source)");
	_tmp1_ = event_event_table;
	_tmp2_ = self->priv->event_id;
	_tmp3_ = data_source_get_source_id ((DataSource*) source);
	_tmp4_ = _tmp3_;
	_tmp5_ = event_table_set_primary_source_id (_tmp1_, &_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	committed = _tmp5_;
	if (committed) {
		MediaSource* _tmp6_;
		MediaSource* _tmp9_;
		MediaSource* _tmp10_;
		_tmp6_ = self->priv->primary_source;
		if (_tmp6_ != NULL) {
			MediaSource* _tmp7_;
			guint _tmp8_;
			_tmp7_ = self->priv->primary_source;
			g_signal_parse_name ("thumbnail-altered", TYPE_THUMBNAIL_SOURCE, &_tmp8_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((ThumbnailSource*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered, self);
		}
		_tmp9_ = _g_object_ref0 (source);
		_g_object_unref0 (self->priv->primary_source);
		self->priv->primary_source = _tmp9_;
		_tmp10_ = self->priv->primary_source;
		g_signal_connect_object ((ThumbnailSource*) _tmp10_, "thumbnail-altered", (GCallback) _event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered, self, 0);
		thumbnail_source_notify_thumbnail_altered ((ThumbnailSource*) self);
	}
	result = committed;
	return result;
}

static void
event_release_primary_source (Event* self)
{
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_source;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->primary_source;
	g_signal_parse_name ("thumbnail-altered", TYPE_THUMBNAIL_SOURCE, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ThumbnailSource*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered, self);
	_g_object_unref0 (self->priv->primary_source);
	self->priv->primary_source = NULL;
}

static GdkPixbuf*
event_real_get_thumbnail (ThumbnailSource* base,
                          gint scale,
                          GError** error)
{
	Event * self;
	GdkPixbuf* _tmp0_ = NULL;
	MediaSource* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (Event*) base;
	_tmp1_ = self->priv->primary_source;
	if (_tmp1_ != NULL) {
		MediaSource* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = self->priv->primary_source;
		_tmp3_ = thumbnail_source_get_thumbnail ((ThumbnailSource*) _tmp2_, scale, &_inner_error0_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		}
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

GdkPixbuf*
event_get_preview_pixbuf (Event* self,
                          Scaling* scaling)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		MediaSource* _tmp1_;
		MediaSource* _tmp2_;
		Scaling _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp1_ = event_get_primary_source (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = *scaling;
		_tmp4_ = media_source_get_preview_pixbuf (_tmp2_, &_tmp3_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp6_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
event_real_destroy (DataSource* base)
{
	Event * self;
	ViewCollection* _tmp0_;
	PhotoTable* _tmp4_;
	PhotoTable* _tmp5_;
	EventID _tmp6_;
	VideoTable* _tmp7_;
	VideoTable* _tmp8_;
	EventID _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (Event*) base;
	_tmp0_ = self->priv->view;
	view_collection_halt_all_monitoring (_tmp0_);
	{
		EventTable* _tmp1_;
		EventID _tmp2_;
		_tmp1_ = event_event_table;
		_tmp2_ = self->priv->event_id;
		event_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = photo_table_get_instance ();
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->event_id;
	photo_table_drop_event (_tmp5_, &_tmp6_);
	_database_table_unref0 (_tmp5_);
	_tmp7_ = video_table_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->event_id;
	video_table_drop_event (_tmp8_, &_tmp9_);
	_database_table_unref0 (_tmp8_);
	DATA_SOURCE_CLASS (event_parent_class)->destroy ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EVENT_SOURCE, EventSource));
}

static inline gpointer
event_event_snapshot_get_instance_private (EventEventSnapshot* self)
{
	return G_STRUCT_MEMBER_P (self, EventEventSnapshot_private_offset);
}

static void
_event_event_snapshot_on_attached_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                     DataSource* source,
                                                                                     gpointer self)
{
	event_event_snapshot_on_attached_source_destroyed ((EventEventSnapshot*) self, source);
}

static EventEventSnapshot*
event_event_snapshot_construct (GType object_type,
                                Event* event)
{
	EventEventSnapshot* self = NULL;
	EventTable* _tmp0_;
	EventTable* _tmp1_;
	EventID _tmp2_ = {0};
	EventRow* _tmp3_;
	MediaSource* _tmp4_;
	LibraryPhotoSourceCollection* _tmp14_;
	VideoSourceCollection* _tmp15_;
	g_return_val_if_fail (event != NULL, NULL);
	self = (EventEventSnapshot*) source_snapshot_construct (object_type);
	_tmp0_ = event_table_get_instance ();
	_tmp1_ = _tmp0_;
	event_get_event_id (event, &_tmp2_);
	_tmp3_ = event_table_get_row (_tmp1_, &_tmp2_);
	_event_row_unref0 (self->priv->row);
	self->priv->row = _tmp3_;
	_database_table_unref0 (_tmp1_);
	_tmp4_ = event_get_primary_source (event);
	_g_object_unref0 (self->priv->primary_source);
	self->priv->primary_source = _tmp4_;
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp5_ = event_source_get_media ((EventSource*) event);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_source_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			MediaSource* source = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GeeArrayList* _tmp12_;
			MediaSource* _tmp13_;
			_tmp9_ = _source_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _source_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			source = (MediaSource*) _tmp11_;
			_tmp12_ = self->priv->attached_sources;
			_tmp13_ = source;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp14_ = library_photo_global;
	g_signal_connect ((SourceCollection*) _tmp14_, "item-destroyed", (GCallback) _event_event_snapshot_on_attached_source_destroyed_source_collection_item_destroyed, self);
	_tmp15_ = video_global;
	g_signal_connect ((SourceCollection*) _tmp15_, "item-destroyed", (GCallback) _event_event_snapshot_on_attached_source_destroyed_source_collection_item_destroyed, self);
	return self;
}

static EventEventSnapshot*
event_event_snapshot_new (Event* event)
{
	return event_event_snapshot_construct (EVENT_TYPE_EVENT_SNAPSHOT, event);
}

static gpointer
_event_row_ref0 (gpointer self)
{
	return self ? event_row_ref (self) : NULL;
}

static EventRow*
event_event_snapshot_get_row (EventEventSnapshot* self)
{
	EventRow* _tmp0_;
	EventRow* _tmp1_;
	EventRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->row;
	_tmp1_ = _event_row_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
event_event_snapshot_real_notify_broken (SourceSnapshot* base)
{
	EventEventSnapshot * self;
	EventRow* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (EventEventSnapshot*) base;
	_tmp0_ = event_row_new ();
	_event_row_unref0 (self->priv->row);
	self->priv->row = _tmp0_;
	_g_object_unref0 (self->priv->primary_source);
	self->priv->primary_source = NULL;
	_tmp1_ = self->priv->attached_sources;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	SOURCE_SNAPSHOT_CLASS (event_event_snapshot_parent_class)->notify_broken (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_SNAPSHOT, SourceSnapshot));
}

static void
event_event_snapshot_on_attached_source_destroyed (EventEventSnapshot* self,
                                                   DataSource* source)
{
	MediaSource* media_source = NULL;
	MediaSource* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MediaSource* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
	media_source = _tmp0_;
	_tmp2_ = media_source;
	if (_tmp2_ != NULL) {
		MediaSource* _tmp3_;
		MediaSource* _tmp4_;
		_tmp3_ = self->priv->primary_source;
		_tmp4_ = media_source;
		_tmp1_ = data_source_equals ((DataSource*) _tmp3_, (DataSource*) _tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		source_snapshot_notify_broken ((SourceSnapshot*) self);
	} else {
		GeeArrayList* _tmp5_;
		MediaSource* _tmp6_;
		_tmp5_ = self->priv->attached_sources;
		_tmp6_ = media_source;
		if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp5_, _tmp6_)) {
			source_snapshot_notify_broken ((SourceSnapshot*) self);
		}
	}
	_g_object_unref0 (media_source);
}

static void
event_event_snapshot_class_init (EventEventSnapshotClass * klass,
                                 gpointer klass_data)
{
	event_event_snapshot_parent_class = g_type_class_peek_parent (klass);
	((SourceSnapshotClass *) klass)->finalize = event_event_snapshot_finalize;
	g_type_class_adjust_private_offset (klass, &EventEventSnapshot_private_offset);
	((SourceSnapshotClass *) klass)->notify_broken = (void (*) (SourceSnapshot*)) event_event_snapshot_real_notify_broken;
}

static void
event_event_snapshot_instance_init (EventEventSnapshot * self,
                                    gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = event_event_snapshot_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->attached_sources = _tmp0_;
}

static void
event_event_snapshot_finalize (SourceSnapshot * obj)
{
	EventEventSnapshot * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	VideoSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EVENT_TYPE_EVENT_SNAPSHOT, EventEventSnapshot);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _event_event_snapshot_on_attached_source_destroyed_source_collection_item_destroyed, self);
	_tmp2_ = video_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _event_event_snapshot_on_attached_source_destroyed_source_collection_item_destroyed, self);
	_event_row_unref0 (self->priv->row);
	_g_object_unref0 (self->priv->primary_source);
	_g_object_unref0 (self->priv->attached_sources);
	SOURCE_SNAPSHOT_CLASS (event_event_snapshot_parent_class)->finalize (obj);
}

static GType
event_event_snapshot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventEventSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_event_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventEventSnapshot), 0, (GInstanceInitFunc) event_event_snapshot_instance_init, NULL };
	GType event_event_snapshot_type_id;
	event_event_snapshot_type_id = g_type_register_static (TYPE_SOURCE_SNAPSHOT, "EventEventSnapshot", &g_define_type_info, 0);
	EventEventSnapshot_private_offset = g_type_add_instance_private (event_event_snapshot_type_id, sizeof (EventEventSnapshotPrivate));
	return event_event_snapshot_type_id;
}

static GType
event_event_snapshot_get_type (void)
{
	static volatile gsize event_event_snapshot_type_id__once = 0;
	if (g_once_init_enter (&event_event_snapshot_type_id__once)) {
		GType event_event_snapshot_type_id;
		event_event_snapshot_type_id = event_event_snapshot_get_type_once ();
		g_once_init_leave (&event_event_snapshot_type_id__once, event_event_snapshot_type_id);
	}
	return event_event_snapshot_type_id__once;
}

static EventEventProxy*
event_event_proxy_construct (GType object_type,
                             Event* event)
{
	EventEventProxy* self = NULL;
	g_return_val_if_fail (event != NULL, NULL);
	self = (EventEventProxy*) source_proxy_construct (object_type, (DataSource*) event);
	return self;
}

static EventEventProxy*
event_event_proxy_new (Event* event)
{
	return event_event_proxy_construct (EVENT_TYPE_EVENT_PROXY, event);
}

static gpointer
_source_snapshot_ref0 (gpointer self)
{
	return self ? source_snapshot_ref (self) : NULL;
}

static DataSource*
event_event_proxy_real_reconstitute (SourceProxy* base,
                                     gint64 object_id,
                                     SourceSnapshot* snapshot)
{
	EventEventProxy * self;
	EventEventSnapshot* event_snapshot = NULL;
	EventEventSnapshot* _tmp0_;
	EventRow* _tmp1_;
	EventRow* _tmp2_;
	Event* _tmp3_;
	DataSource* _tmp4_;
	DataSource* result;
	self = (EventEventProxy*) base;
	g_return_val_if_fail (snapshot != NULL, NULL);
	_tmp0_ = _source_snapshot_ref0 (EVENT_IS_EVENT_SNAPSHOT (snapshot) ? ((EventEventSnapshot*) snapshot) : NULL);
	event_snapshot = _tmp0_;
	_vala_assert (event_snapshot != NULL, "event_snapshot != null");
	_tmp1_ = event_event_snapshot_get_row (event_snapshot);
	_tmp2_ = _tmp1_;
	_tmp3_ = event_reconstitute (object_id, _tmp2_);
	_tmp4_ = (DataSource*) _tmp3_;
	_event_row_unref0 (_tmp2_);
	result = _tmp4_;
	_source_snapshot_unref0 (event_snapshot);
	return result;
}

static void
event_event_proxy_class_init (EventEventProxyClass * klass,
                              gpointer klass_data)
{
	event_event_proxy_parent_class = g_type_class_peek_parent (klass);
	((SourceProxyClass *) klass)->reconstitute = (DataSource* (*) (SourceProxy*, gint64, SourceSnapshot*)) event_event_proxy_real_reconstitute;
}

static void
event_event_proxy_instance_init (EventEventProxy * self,
                                 gpointer klass)
{
}

static GType
event_event_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventEventProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_event_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventEventProxy), 0, (GInstanceInitFunc) event_event_proxy_instance_init, NULL };
	GType event_event_proxy_type_id;
	event_event_proxy_type_id = g_type_register_static (TYPE_SOURCE_PROXY, "EventEventProxy", &g_define_type_info, 0);
	return event_event_proxy_type_id;
}

static GType
event_event_proxy_get_type (void)
{
	static volatile gsize event_event_proxy_type_id__once = 0;
	if (g_once_init_enter (&event_event_proxy_type_id__once)) {
		GType event_event_proxy_type_id;
		event_event_proxy_type_id = event_event_proxy_get_type_once ();
		g_once_init_leave (&event_event_proxy_type_id__once, event_event_proxy_type_id);
	}
	return event_event_proxy_type_id__once;
}

static void
event_class_init (EventClass * klass,
                  gpointer klass_data)
{
	event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Event_private_offset);
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) event_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) event_real_get_instance_id;
	((ThumbnailSourceClass *) klass)->get_representative_id = (gchar* (*) (ThumbnailSource*)) event_real_get_representative_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) event_real_get_preferred_thumbnail_format;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) event_real_create_thumbnail;
	((DataSourceClass *) klass)->notify_relinking = (void (*) (DataSource*, SourceCollection*)) event_real_notify_relinking;
	((DataSourceClass *) klass)->save_snapshot = (SourceSnapshot* (*) (DataSource*)) event_real_save_snapshot;
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource*, DataSource*)) event_real_equals;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) event_real_to_string;
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) event_real_get_name;
	((EventSourceClass *) klass)->get_comment = (gchar* (*) (EventSource*)) event_real_get_comment;
	((EventSourceClass *) klass)->set_comment = (gboolean (*) (EventSource*, const gchar*)) event_real_set_comment;
	((EventSourceClass *) klass)->get_start_time = (gint64 (*) (EventSource*)) event_real_get_start_time;
	((EventSourceClass *) klass)->get_end_time = (gint64 (*) (EventSource*)) event_real_get_end_time;
	((EventSourceClass *) klass)->get_total_filesize = (guint64 (*) (EventSource*)) event_real_get_total_filesize;
	((EventSourceClass *) klass)->get_media_count = (gint (*) (EventSource*)) event_real_get_media_count;
	((EventSourceClass *) klass)->get_media = (GeeCollection* (*) (EventSource*)) event_real_get_media;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) event_real_get_thumbnail;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) event_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = event_finalize;
}

static void
event_container_source_interface_init (ContainerSourceIface * iface,
                                       gpointer iface_data)
{
	event_container_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_links = (gboolean (*) (ContainerSource*)) event_real_has_links;
	iface->get_backlink = (SourceBacklink* (*) (ContainerSource*)) event_real_get_backlink;
	iface->break_link = (void (*) (ContainerSource*, DataSource*)) event_real_break_link;
	iface->break_link_many = (void (*) (ContainerSource*, GeeCollection*)) event_real_break_link_many;
	iface->establish_link = (void (*) (ContainerSource*, DataSource*)) event_real_establish_link;
	iface->establish_link_many = (void (*) (ContainerSource*, GeeCollection*)) event_real_establish_link_many;
}

static void
event_proxyable_interface_init (ProxyableIface * iface,
                                gpointer iface_data)
{
	event_proxyable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_proxy = (SourceProxy* (*) (Proxyable*)) event_real_get_proxy;
}

static void
event_indexable_interface_init (IndexableIface * iface,
                                gpointer iface_data)
{
	event_indexable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_indexable_keywords = (const gchar* (*) (Indexable*)) event_real_get_indexable_keywords;
}

static void
event_instance_init (Event * self,
                     gpointer klass)
{
	self->priv = event_get_instance_private (self);
	self->priv->unlinking = FALSE;
	self->priv->relinking = FALSE;
	self->priv->indexable_keywords = NULL;
	self->priv->comment = NULL;
}

static void
event_finalize (GObject * obj)
{
	Event * self;
	MediaSource* _tmp0_;
	ViewCollection* _tmp3_;
	guint _tmp4_;
	ViewCollection* _tmp5_;
	guint _tmp6_;
	ViewCollection* _tmp7_;
	guint _tmp8_;
	LibraryPhotoSourceCollection* _tmp9_;
	guint _tmp10_;
	VideoSourceCollection* _tmp11_;
	guint _tmp12_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT, Event);
	_tmp0_ = self->priv->primary_source;
	if (_tmp0_ != NULL) {
		MediaSource* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->primary_source;
		g_signal_parse_name ("thumbnail-altered", TYPE_THUMBNAIL_SOURCE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((ThumbnailSource*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _event_on_primary_thumbnail_altered_thumbnail_source_thumbnail_altered, self);
	}
	_tmp3_ = self->priv->view;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _event_on_media_altered_data_collection_items_altered, self);
	_tmp5_ = self->priv->view;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _event_on_media_removed_data_collection_items_removed, self);
	_tmp7_ = self->priv->view;
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _event_on_media_added_data_collection_items_added, self);
	_tmp9_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _event_on_media_destroyed_source_collection_item_destroyed, self);
	_tmp11_ = video_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _event_on_media_destroyed_source_collection_item_destroyed, self);
	_g_free0 (self->priv->raw_name);
	_g_object_unref0 (self->priv->primary_source);
	_data_collection_unref0 (self->priv->view);
	_g_free0 (self->priv->indexable_keywords);
	_g_free0 (self->priv->comment);
	G_OBJECT_CLASS (event_parent_class)->finalize (obj);
}

static GType
event_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Event), 0, (GInstanceInitFunc) event_instance_init, NULL };
	static const GInterfaceInfo container_source_info = { (GInterfaceInitFunc) event_container_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo proxyable_info = { (GInterfaceInitFunc) event_proxyable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo indexable_info = { (GInterfaceInitFunc) event_indexable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType event_type_id;
	event_type_id = g_type_register_static (TYPE_EVENT_SOURCE, "Event", &g_define_type_info, 0);
	g_type_add_interface_static (event_type_id, TYPE_CONTAINER_SOURCE, &container_source_info);
	g_type_add_interface_static (event_type_id, TYPE_PROXYABLE, &proxyable_info);
	g_type_add_interface_static (event_type_id, TYPE_INDEXABLE, &indexable_info);
	Event_private_offset = g_type_add_instance_private (event_type_id, sizeof (EventPrivate));
	return event_type_id;
}

GType
event_get_type (void)
{
	static volatile gsize event_type_id__once = 0;
	if (g_once_init_enter (&event_type_id__once)) {
		GType event_type_id;
		event_type_id = event_get_type_once ();
		g_once_init_leave (&event_type_id__once, event_type_id);
	}
	return event_type_id__once;
}

