/* ThumbnailCache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ThumbnailCache.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecThumbnails ParamSpecThumbnails;

#define THUMBNAIL_CACHE_TYPE_IMAGE_DATA (thumbnail_cache_image_data_get_type ())
#define THUMBNAIL_CACHE_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData))
#define THUMBNAIL_CACHE_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))

typedef struct _ThumbnailCacheImageData ThumbnailCacheImageData;
typedef struct _ThumbnailCacheImageDataClass ThumbnailCacheImageDataClass;
enum  {
	THUMBNAIL_CACHE_0_PROPERTY,
	THUMBNAIL_CACHE_NUM_PROPERTIES
};
static GParamSpec* thumbnail_cache_properties[THUMBNAIL_CACHE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB (thumbnail_cache_async_fetch_job_get_type ())
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))

typedef struct _ThumbnailCacheAsyncFetchJob ThumbnailCacheAsyncFetchJob;
typedef struct _ThumbnailCacheAsyncFetchJobClass ThumbnailCacheAsyncFetchJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _ThumbnailCacheAsyncFetchJobPrivate ThumbnailCacheAsyncFetchJobPrivate;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _ThumbnailCacheImageDataPrivate ThumbnailCacheImageDataPrivate;
#define _thumbnail_cache_image_data_unref0(var) ((var == NULL) ? NULL : (var = (thumbnail_cache_image_data_unref (var), NULL)))
typedef struct _ThumbnailCacheParamSpecImageData ThumbnailCacheParamSpecImageData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ThumbnailsPrivate {
	GeeHashMap* map;
};

struct _ParamSpecThumbnails {
	GParamSpec parent_instance;
};

struct _ThumbnailCachePrivate {
	GFile* cache_dir;
	ThumbnailCacheSize size;
	gulong max_cached_bytes;
	GdkInterpType interp;
	JpegQuality quality;
	GeeHashMap* cache_map;
	GeeArrayList* cache_lru;
	gulong cached_bytes;
};

struct _ThumbnailCacheAsyncFetchJob {
	BackgroundJob parent_instance;
	ThumbnailCacheAsyncFetchJobPrivate * priv;
	ThumbnailCache* cache;
	gchar* thumbnail_name;
	ThumbnailSource* source;
	PhotoFileFormat source_format;
	Dimensions dim;
	GdkInterpType interp;
	ThumbnailCacheAsyncFetchCallback callback;
	gpointer callback_target;
	GdkPixbuf* unscaled;
	GdkPixbuf* scaled;
	GError* err;
	gboolean fetched;
};

struct _ThumbnailCacheAsyncFetchJobClass {
	BackgroundJobClass parent_class;
};

struct _ThumbnailCacheImageData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailCacheImageDataPrivate * priv;
	GdkPixbuf* pixbuf;
	gulong bytes;
};

struct _ThumbnailCacheImageDataClass {
	GTypeClass parent_class;
	void (*finalize) (ThumbnailCacheImageData *self);
};

struct _ThumbnailCacheParamSpecImageData {
	GParamSpec parent_instance;
};

static gint Thumbnails_private_offset;
static gpointer thumbnails_parent_class = NULL;
static gint ThumbnailCache_private_offset;
static gpointer thumbnail_cache_parent_class = NULL;
static ThumbnailCacheSize* thumbnail_cache_all_sizes;
static gint thumbnail_cache_all_sizes_length1;
static ThumbnailCacheSize* thumbnail_cache_all_sizes = NULL;
static gint thumbnail_cache_all_sizes_length1 = 0;
static gint _thumbnail_cache_all_sizes_size_ = 0;
static Workers* thumbnail_cache_fetch_workers;
static Workers* thumbnail_cache_fetch_workers = NULL;
static ThumbnailCache* thumbnail_cache_big;
static ThumbnailCache* thumbnail_cache_big = NULL;
static ThumbnailCache* thumbnail_cache_medium;
static ThumbnailCache* thumbnail_cache_medium = NULL;
static OneShotScheduler* thumbnail_cache_debug_scheduler;
static OneShotScheduler* thumbnail_cache_debug_scheduler = NULL;
static gint thumbnail_cache_cycle_fetched_thumbnails;
static gint thumbnail_cache_cycle_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_fetched_thumbnails;
static gint thumbnail_cache_cycle_async_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_resized_thumbnails;
static gint thumbnail_cache_cycle_async_resized_thumbnails = 0;
static gint thumbnail_cache_cycle_overflow_thumbnails;
static gint thumbnail_cache_cycle_overflow_thumbnails = 0;
static gulong thumbnail_cache_cycle_dropped_bytes;
static gulong thumbnail_cache_cycle_dropped_bytes = (gulong) 0;
static gint thumbnail_cache__scale_factor;
static gint thumbnail_cache__scale_factor = 1;
static gpointer thumbnail_cache_image_data_parent_class = NULL;
static gpointer thumbnail_cache_async_fetch_job_parent_class = NULL;

static void thumbnails_finalize (Thumbnails * obj);
static GType thumbnails_get_type_once (void);
static gpointer thumbnail_cache_image_data_ref (gpointer instance);
static void thumbnail_cache_image_data_unref (gpointer instance);
static GParamSpec* thumbnail_cache_param_spec_image_data (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void thumbnail_cache_value_set_image_data (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static void thumbnail_cache_value_take_image_data (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer thumbnail_cache_value_get_image_data (const GValue* value) G_GNUC_UNUSED ;
static GType thumbnail_cache_image_data_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ThumbnailCache* thumbnail_cache_new (ThumbnailCacheSize size,
                                     gulong max_cached_bytes,
                                     GdkInterpType interp,
                                     JpegQuality quality);
static ThumbnailCache* thumbnail_cache_construct (GType object_type,
                                           ThumbnailCacheSize size,
                                           gulong max_cached_bytes,
                                           GdkInterpType interp,
                                           JpegQuality quality);
VALA_EXTERN GFile* app_dirs_get_cache_subdir (const gchar* name,
                                  const gchar* subname);
static void thumbnail_cache_report_cycle (void);
static void _thumbnail_cache_report_cycle_one_shot_callback (gpointer self);
static void _thumbnail_cache_import_from_source (ThumbnailCache* self,
                                          ThumbnailSource* source,
                                          gboolean force,
                                          GError** error);
static void _thumbnail_cache_import_thumbnail (ThumbnailCache* self,
                                        ThumbnailSource* source,
                                        GdkPixbuf* scaled,
                                        gboolean force,
                                        GError** error);
static void _thumbnail_cache_duplicate (ThumbnailCache* self,
                                 ThumbnailSource* src_source,
                                 ThumbnailSource* dest_source);
static void _thumbnail_cache_remove (ThumbnailCache* self,
                              ThumbnailSource* source);
static ThumbnailCache* thumbnail_cache_get_best_cache (gint scale);
static ThumbnailCache* thumbnail_cache_get_cache_for (ThumbnailCacheSize size);
static GdkPixbuf* _thumbnail_cache_fetch (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   GError** error);
static void _thumbnail_cache_fetch_async (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   PhotoFileFormat format,
                                   Dimensions* dim,
                                   GdkInterpType interp,
                                   ThumbnailCacheAsyncFetchCallback callback,
                                   gpointer callback_target,
                                   GCancellable* cancellable);
static void _thumbnail_cache_replace (ThumbnailCache* self,
                               ThumbnailSource* source,
                               GdkPixbuf* original,
                               GError** error);
static gboolean _thumbnail_cache_exists (ThumbnailCache* self,
                                  ThumbnailSource* source);
static void thumbnail_cache_schedule_debug (void);
static GdkPixbuf* thumbnail_cache_fetch_from_memory (ThumbnailCache* self,
                                              const gchar* thumbnail_name);
static GdkPixbuf* thumbnail_cache_read_pixbuf (ThumbnailCache* self,
                                        const gchar* thumbnail_name,
                                        PhotoFileFormat format,
                                        GError** error);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache,
                                                                  const gchar* thumbnail_name,
                                                                  ThumbnailSource* source,
                                                                  GdkPixbuf* prefetched,
                                                                  Dimensions* dim,
                                                                  GdkInterpType interp,
                                                                  ThumbnailCacheAsyncFetchCallback callback,
                                                                  gpointer callback_target,
                                                                  GCancellable* cancellable);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_construct (GType object_type,
                                                                        ThumbnailCache* cache,
                                                                        const gchar* thumbnail_name,
                                                                        ThumbnailSource* source,
                                                                        GdkPixbuf* prefetched,
                                                                        Dimensions* dim,
                                                                        GdkInterpType interp,
                                                                        ThumbnailCacheAsyncFetchCallback callback,
                                                                        gpointer callback_target,
                                                                        GCancellable* cancellable);
static GType thumbnail_cache_async_fetch_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job);
static void thumbnail_cache_store_in_memory (ThumbnailCache* self,
                                      const gchar* thumbnail_name,
                                      GdkPixbuf* thumbnail);
static GFile* thumbnail_cache_get_source_cached_file (ThumbnailCache* self,
                                               ThumbnailSource* source);
static void thumbnail_cache_save_thumbnail (ThumbnailCache* self,
                                     GFile* file,
                                     GdkPixbuf* pixbuf,
                                     ThumbnailSource* source,
                                     GError** error);
static GFile* thumbnail_cache_get_cached_file (ThumbnailCache* self,
                                        const gchar* thumbnail_name,
                                        PhotoFileFormat thumbnail_format);
static gboolean thumbnail_cache_remove_from_memory (ThumbnailCache* self,
                                             const gchar* thumbnail_name);
VALA_EXTERN GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
static ThumbnailCacheImageData* thumbnail_cache_image_data_new (GdkPixbuf* pixbuf);
static ThumbnailCacheImageData* thumbnail_cache_image_data_construct (GType object_type,
                                                               GdkPixbuf* pixbuf);
static void thumbnail_cache_image_data_finalize (ThumbnailCacheImageData * obj);
static GType thumbnail_cache_image_data_get_type_once (void);
static void _thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job,
                                                                           gpointer self);
static BackgroundJobJobPriority thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base);
static void thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static void thumbnail_cache_async_fetch_job_finalize (BackgroundJob * obj);
static GType thumbnail_cache_async_fetch_job_get_type_once (void);
static void thumbnail_cache_finalize (GObject * obj);
static GType thumbnail_cache_get_type_once (void);
static void _vala_thumbnail_cache_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_thumbnail_cache_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
thumbnails_get_instance_private (Thumbnails* self)
{
	return G_STRUCT_MEMBER_P (self, Thumbnails_private_offset);
}

Thumbnails*
thumbnails_construct (GType object_type)
{
	Thumbnails* self = NULL;
	self = (Thumbnails*) g_type_create_instance (object_type);
	return self;
}

Thumbnails*
thumbnails_new (void)
{
	return thumbnails_construct (TYPE_THUMBNAILS);
}

void
thumbnails_set (Thumbnails* self,
                ThumbnailCacheSize size,
                GdkPixbuf* pixbuf)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) size), pixbuf);
}

void
thumbnails_remove (Thumbnails* self,
                   ThumbnailCacheSize size)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->map;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) size), NULL);
}

GdkPixbuf*
thumbnails_get (Thumbnails* self,
                ThumbnailCacheSize size)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) size));
	result = (GdkPixbuf*) _tmp1_;
	return result;
}

static void
value_thumbnails_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_thumbnails_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		thumbnails_unref (value->data[0].v_pointer);
	}
}

static void
value_thumbnails_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = thumbnails_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_thumbnails_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_thumbnails_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Thumbnails * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = thumbnails_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_thumbnails_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Thumbnails ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = thumbnails_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_thumbnails (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecThumbnails* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THUMBNAILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_thumbnails (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_thumbnails (GValue* value,
                      gpointer v_object)
{
	Thumbnails * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		thumbnails_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnails_unref (old);
	}
}

void
value_take_thumbnails (GValue* value,
                       gpointer v_object)
{
	Thumbnails * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnails_unref (old);
	}
}

static void
thumbnails_class_init (ThumbnailsClass * klass,
                       gpointer klass_data)
{
	thumbnails_parent_class = g_type_class_peek_parent (klass);
	((ThumbnailsClass *) klass)->finalize = thumbnails_finalize;
	g_type_class_adjust_private_offset (klass, &Thumbnails_private_offset);
}

static void
thumbnails_instance_init (Thumbnails * self,
                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = thumbnails_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (THUMBNAIL_CACHE_TYPE_SIZE, NULL, NULL, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
	self->ref_count = 1;
}

static void
thumbnails_finalize (Thumbnails * obj)
{
	Thumbnails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAILS, Thumbnails);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->map);
}

static GType
thumbnails_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_thumbnails_init, value_thumbnails_free_value, value_thumbnails_copy_value, value_thumbnails_peek_pointer, "p", value_thumbnails_collect_value, "p", value_thumbnails_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnails_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnails), 0, (GInstanceInitFunc) thumbnails_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType thumbnails_type_id;
	thumbnails_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Thumbnails", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Thumbnails_private_offset = g_type_add_instance_private (thumbnails_type_id, sizeof (ThumbnailsPrivate));
	return thumbnails_type_id;
}

GType
thumbnails_get_type (void)
{
	static volatile gsize thumbnails_type_id__once = 0;
	if (g_once_init_enter (&thumbnails_type_id__once)) {
		GType thumbnails_type_id;
		thumbnails_type_id = thumbnails_get_type_once ();
		g_once_init_leave (&thumbnails_type_id__once, thumbnails_type_id);
	}
	return thumbnails_type_id__once;
}

gpointer
thumbnails_ref (gpointer instance)
{
	Thumbnails * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
thumbnails_unref (gpointer instance)
{
	Thumbnails * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THUMBNAILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
thumbnail_cache_get_instance_private (ThumbnailCache* self)
{
	return G_STRUCT_MEMBER_P (self, ThumbnailCache_private_offset);
}

gint
thumbnail_cache_size_get_scale (ThumbnailCacheSize self)
{
	gint result;
	result = (gint) self;
	return result;
}

void
thumbnail_cache_size_get_scaling (ThumbnailCacheSize self,
                                  Scaling* result)
{
	Scaling _tmp0_ = {0};
	scaling_for_best_fit (thumbnail_cache_size_get_scale (self), TRUE, &_tmp0_);
	*result = _tmp0_;
	return;
}

ThumbnailCacheSize
thumbnail_cache_size_get_best_size (gint scale)
{
	ThumbnailCacheSize _tmp0_ = 0;
	ThumbnailCacheSize result;
	if (scale <= thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM)) {
		_tmp0_ = THUMBNAIL_CACHE_SIZE_MEDIUM;
	} else {
		_tmp0_ = THUMBNAIL_CACHE_SIZE_BIG;
	}
	result = _tmp0_;
	return result;
}

static GType
thumbnail_cache_size_get_type_once (void)
{
	static const GEnumValue values[] = {{THUMBNAIL_CACHE_SIZE_LARGEST, "THUMBNAIL_CACHE_SIZE_LARGEST", "largest"}, {THUMBNAIL_CACHE_SIZE_BIG, "THUMBNAIL_CACHE_SIZE_BIG", "big"}, {THUMBNAIL_CACHE_SIZE_MEDIUM, "THUMBNAIL_CACHE_SIZE_MEDIUM", "medium"}, {THUMBNAIL_CACHE_SIZE_SMALLEST, "THUMBNAIL_CACHE_SIZE_SMALLEST", "smallest"}, {0, NULL, NULL}};
	GType thumbnail_cache_size_type_id;
	thumbnail_cache_size_type_id = g_enum_register_static ("ThumbnailCacheSize", values);
	return thumbnail_cache_size_type_id;
}

GType
thumbnail_cache_size_get_type (void)
{
	static volatile gsize thumbnail_cache_size_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_size_type_id__once)) {
		GType thumbnail_cache_size_type_id;
		thumbnail_cache_size_type_id = thumbnail_cache_size_get_type_once ();
		g_once_init_leave (&thumbnail_cache_size_type_id__once, thumbnail_cache_size_type_id);
	}
	return thumbnail_cache_size_type_id__once;
}

static ThumbnailCache*
thumbnail_cache_construct (GType object_type,
                           ThumbnailCacheSize size,
                           gulong max_cached_bytes,
                           GdkInterpType interp,
                           JpegQuality quality)
{
	ThumbnailCache * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	self = (ThumbnailCache*) g_object_new (object_type, NULL);
	_tmp0_ = thumbnail_cache_get_scale_factor ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("thumbs%d@%dx", thumbnail_cache_size_get_scale (size), _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = app_dirs_get_cache_subdir ("thumbs", _tmp3_);
	_g_object_unref0 (self->priv->cache_dir);
	self->priv->cache_dir = _tmp4_;
	_g_free0 (_tmp3_);
	self->priv->size = size;
	self->priv->max_cached_bytes = max_cached_bytes;
	self->priv->interp = interp;
	self->priv->quality = quality;
	return self;
}

static ThumbnailCache*
thumbnail_cache_new (ThumbnailCacheSize size,
                     gulong max_cached_bytes,
                     GdkInterpType interp,
                     JpegQuality quality)
{
	return thumbnail_cache_construct (TYPE_THUMBNAIL_CACHE, size, max_cached_bytes, interp, quality);
}

static void
_thumbnail_cache_report_cycle_one_shot_callback (gpointer self)
{
	thumbnail_cache_report_cycle ();
}

void
thumbnail_cache_init (void)
{
	OneShotScheduler* _tmp0_;
	Workers* _tmp1_;
	ThumbnailCache* _tmp2_;
	ThumbnailCache* _tmp3_;
	_tmp0_ = one_shot_scheduler_new ("ThumbnailCache cycle reporter", _thumbnail_cache_report_cycle_one_shot_callback, NULL);
	_one_shot_scheduler_unref0 (thumbnail_cache_debug_scheduler);
	thumbnail_cache_debug_scheduler = _tmp0_;
	_tmp1_ = workers_new (workers_threads_per_cpu (1, -1), TRUE);
	_workers_unref0 (thumbnail_cache_fetch_workers);
	thumbnail_cache_fetch_workers = _tmp1_;
	_tmp2_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_BIG, THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
	_g_object_unref0 (thumbnail_cache_big);
	thumbnail_cache_big = _tmp2_;
	_tmp3_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_MEDIUM, THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
	_g_object_unref0 (thumbnail_cache_medium);
	thumbnail_cache_medium = _tmp3_;
}

void
thumbnail_cache_terminate (void)
{
}

void
thumbnail_cache_import_from_source (ThumbnailSource* source,
                                    gboolean force,
                                    GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ThumbnailCache* _tmp2_;
	ThumbnailCache* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (source != NULL);
	_tmp0_ = data_object_to_string ((DataObject*) source);
	_tmp1_ = _tmp0_;
	g_debug ("ThumbnailCache.vala:243: import from source: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = thumbnail_cache_big;
	_thumbnail_cache_import_from_source (_tmp2_, source, force, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = thumbnail_cache_medium;
	_thumbnail_cache_import_from_source (_tmp3_, source, force, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
thumbnail_cache_import_thumbnails (ThumbnailSource* source,
                                   Thumbnails* thumbnails,
                                   gboolean force,
                                   GError** error)
{
	ThumbnailCache* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	ThumbnailCache* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (source != NULL);
	g_return_if_fail (thumbnails != NULL);
	_tmp0_ = thumbnail_cache_big;
	_tmp1_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_BIG);
	_tmp2_ = _tmp1_;
	_thumbnail_cache_import_thumbnail (_tmp0_, source, _tmp2_, force, &_inner_error0_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = thumbnail_cache_medium;
	_tmp4_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_MEDIUM);
	_tmp5_ = _tmp4_;
	_thumbnail_cache_import_thumbnail (_tmp3_, source, _tmp5_, force, &_inner_error0_);
	_g_object_unref0 (_tmp5_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
thumbnail_cache_duplicate (ThumbnailSource* src_source,
                           ThumbnailSource* dest_source)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	g_return_if_fail (src_source != NULL);
	g_return_if_fail (dest_source != NULL);
	_tmp0_ = thumbnail_cache_big;
	_thumbnail_cache_duplicate (_tmp0_, src_source, dest_source);
	_tmp1_ = thumbnail_cache_medium;
	_thumbnail_cache_duplicate (_tmp1_, src_source, dest_source);
}

void
thumbnail_cache_remove (ThumbnailSource* source)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	g_return_if_fail (source != NULL);
	_tmp0_ = thumbnail_cache_big;
	_thumbnail_cache_remove (_tmp0_, source);
	_tmp1_ = thumbnail_cache_medium;
	_thumbnail_cache_remove (_tmp1_, source);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ThumbnailCache*
thumbnail_cache_get_best_cache (gint scale)
{
	ThumbnailCacheSize size = 0;
	ThumbnailCache* result;
	size = thumbnail_cache_size_get_best_size (scale);
	if (size == THUMBNAIL_CACHE_SIZE_BIG) {
		ThumbnailCache* _tmp0_;
		ThumbnailCache* _tmp1_;
		_tmp0_ = thumbnail_cache_big;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		ThumbnailCache* _tmp2_;
		ThumbnailCache* _tmp3_;
		_vala_assert (size == THUMBNAIL_CACHE_SIZE_MEDIUM, "size == Size.MEDIUM");
		_tmp2_ = thumbnail_cache_medium;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
}

static ThumbnailCache*
thumbnail_cache_get_cache_for (ThumbnailCacheSize size)
{
	ThumbnailCache* result;
	switch (size) {
		case THUMBNAIL_CACHE_SIZE_BIG:
		{
			ThumbnailCache* _tmp0_;
			ThumbnailCache* _tmp1_;
			_tmp0_ = thumbnail_cache_big;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case THUMBNAIL_CACHE_SIZE_MEDIUM:
		{
			ThumbnailCache* _tmp2_;
			ThumbnailCache* _tmp3_;
			_tmp2_ = thumbnail_cache_medium;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_error ("ThumbnailCache.vala:284: Unknown thumbnail size %d", thumbnail_cache_size_get_scale (size));
		}
	}
}

GdkPixbuf*
thumbnail_cache_fetch (ThumbnailSource* source,
                       gint scale,
                       GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	ThumbnailCache* _tmp1_;
	ThumbnailCache* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp1_ = thumbnail_cache_get_best_cache (scale);
	_tmp2_ = _tmp1_;
	_tmp3_ = _thumbnail_cache_fetch (_tmp2_, source, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}

void
thumbnail_cache_fetch_async (ThumbnailSource* source,
                             gint scale,
                             ThumbnailCacheAsyncFetchCallback callback,
                             gpointer callback_target,
                             GCancellable* cancellable)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (source != NULL);
	_tmp0_ = thumbnail_cache_get_best_cache (scale);
	_tmp1_ = _tmp0_;
	dimensions_init (&_tmp2_, 0, 0);
	_thumbnail_cache_fetch_async (_tmp1_, source, thumbnail_source_get_preferred_thumbnail_format (source), &_tmp2_, THUMBNAIL_CACHE_DEFAULT_INTERP, callback, callback_target, cancellable);
	_g_object_unref0 (_tmp1_);
}

void
thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                    gint scale,
                                    Dimensions* dim,
                                    GdkInterpType interp,
                                    ThumbnailCacheAsyncFetchCallback callback,
                                    gpointer callback_target,
                                    GCancellable* cancellable)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	Dimensions _tmp2_;
	g_return_if_fail (source != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = thumbnail_cache_get_best_cache (scale);
	_tmp1_ = _tmp0_;
	_tmp2_ = *dim;
	_thumbnail_cache_fetch_async (_tmp1_, source, thumbnail_source_get_preferred_thumbnail_format (source), &_tmp2_, interp, callback, callback_target, cancellable);
	_g_object_unref0 (_tmp1_);
}

void
thumbnail_cache_replace (ThumbnailSource* source,
                         ThumbnailCacheSize size,
                         GdkPixbuf* replacement,
                         GError** error)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (source != NULL);
	g_return_if_fail (replacement != NULL);
	_tmp0_ = thumbnail_cache_get_cache_for (size);
	_tmp1_ = _tmp0_;
	_thumbnail_cache_replace (_tmp1_, source, replacement, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

gboolean
thumbnail_cache_exists (ThumbnailSource* source)
{
	gboolean _tmp0_ = FALSE;
	ThumbnailCache* _tmp1_;
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp1_ = thumbnail_cache_big;
	if (_thumbnail_cache_exists (_tmp1_, source)) {
		ThumbnailCache* _tmp2_;
		_tmp2_ = thumbnail_cache_medium;
		_tmp0_ = _thumbnail_cache_exists (_tmp2_, source);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
thumbnail_cache_rotate (ThumbnailSource* source,
                        Rotation rotation,
                        GError** error)
{
	ThumbnailCacheSize* _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (source != NULL);
	_tmp0_ = thumbnail_cache_all_sizes;
	_tmp0__length1 = thumbnail_cache_all_sizes_length1;
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp0_;
		size_collection_length1 = _tmp0__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			ThumbnailCacheSize size = 0;
			size = size_collection[size_it];
			{
				GdkPixbuf* thumbnail = NULL;
				GdkPixbuf* _tmp1_;
				GdkPixbuf* _tmp2_;
				GdkPixbuf* _tmp3_;
				GdkPixbuf* _tmp4_;
				_tmp1_ = thumbnail_cache_fetch (source, (gint) size, &_inner_error0_);
				thumbnail = _tmp1_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				_tmp2_ = thumbnail;
				_tmp3_ = rotation_perform (rotation, _tmp2_);
				_g_object_unref0 (thumbnail);
				thumbnail = _tmp3_;
				_tmp4_ = thumbnail;
				thumbnail_cache_replace (source, size, _tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (thumbnail);
					return;
				}
				_g_object_unref0 (thumbnail);
			}
		}
	}
}

void
thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                    PhotoFileReader* reader,
                                    Orientation orientation,
                                    Dimensions* original_dim,
                                    GError** error)
{
	ThumbnailCacheSize max_size = 0;
	Dimensions dim = {0};
	Scaling _tmp0_ = {0};
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GdkPixbuf* largest_thumbnail = NULL;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_;
	Dimensions largest_thumb_dimensions = {0};
	GdkPixbuf* _tmp17_;
	Dimensions _tmp18_ = {0};
	ThumbnailCacheSize* _tmp19_;
	gint _tmp19__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (thumbnails != NULL);
	g_return_if_fail (reader != NULL);
	g_return_if_fail (original_dim != NULL);
	max_size = THUMBNAIL_CACHE_SIZE_BIG * 2;
	thumbnail_cache_size_get_scaling (max_size, &_tmp0_);
	_tmp1_ = *original_dim;
	scaling_get_scaled_dimensions (&_tmp0_, &_tmp1_, &_tmp2_);
	dim = _tmp2_;
	_tmp3_ = thumbnail_cache_get_scale_factor ();
	_tmp4_ = _tmp3_;
	dim.width = dim.width * _tmp4_;
	_tmp5_ = thumbnail_cache_get_scale_factor ();
	_tmp6_ = _tmp5_;
	dim.height = dim.height * _tmp6_;
	largest_thumbnail = NULL;
	{
		GdkPixbuf* _tmp7_ = NULL;
		Dimensions _tmp8_;
		Dimensions _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp8_ = *original_dim;
		_tmp9_ = dim;
		_tmp10_ = photo_file_reader_scaled_read (reader, &_tmp8_, &_tmp9_, &_inner_error0_);
		_tmp7_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (largest_thumbnail);
		largest_thumbnail = _tmp11_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		g_clear_error (&_inner_error0_);
		_tmp13_ = photo_file_reader_unscaled_read (reader, &_inner_error0_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (largest_thumbnail);
		largest_thumbnail = _tmp14_;
		_g_object_unref0 (_tmp12_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (largest_thumbnail);
		return;
	}
	_tmp15_ = largest_thumbnail;
	_tmp16_ = orientation_rotate_pixbuf (orientation, _tmp15_);
	_g_object_unref0 (largest_thumbnail);
	largest_thumbnail = _tmp16_;
	_tmp17_ = largest_thumbnail;
	dimensions_for_pixbuf (_tmp17_, &_tmp18_);
	largest_thumb_dimensions = _tmp18_;
	_tmp19_ = thumbnail_cache_all_sizes;
	_tmp19__length1 = thumbnail_cache_all_sizes_length1;
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp19_;
		size_collection_length1 = _tmp19__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			ThumbnailCacheSize size = 0;
			size = size_collection[size_it];
			{
				Scaling _tmp20_ = {0};
				Dimensions _tmp21_;
				Dimensions _tmp22_ = {0};
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				GdkPixbuf* _tmp27_;
				Dimensions _tmp28_;
				Dimensions _tmp29_;
				GdkPixbuf* _tmp30_;
				GdkPixbuf* _tmp31_;
				thumbnail_cache_size_get_scaling (size, &_tmp20_);
				_tmp21_ = largest_thumb_dimensions;
				scaling_get_scaled_dimensions (&_tmp20_, &_tmp21_, &_tmp22_);
				dim = _tmp22_;
				_tmp23_ = thumbnail_cache_get_scale_factor ();
				_tmp24_ = _tmp23_;
				dim.width = dim.width * _tmp24_;
				_tmp25_ = thumbnail_cache_get_scale_factor ();
				_tmp26_ = _tmp25_;
				dim.height = dim.height * _tmp26_;
				_tmp27_ = largest_thumbnail;
				_tmp28_ = dim;
				_tmp29_ = dim;
				_tmp30_ = gdk_pixbuf_scale_simple (_tmp27_, _tmp28_.width, _tmp29_.height, GDK_INTERP_HYPER);
				_tmp31_ = _tmp30_;
				thumbnails_set (thumbnails, size, _tmp31_);
				_g_object_unref0 (_tmp31_);
			}
		}
	}
	_g_object_unref0 (largest_thumbnail);
}

void
thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                          GdkPixbuf* preview_frame)
{
	ThumbnailCacheSize* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (thumbnails != NULL);
	g_return_if_fail (preview_frame != NULL);
	_tmp0_ = thumbnail_cache_all_sizes;
	_tmp0__length1 = thumbnail_cache_all_sizes_length1;
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp0_;
		size_collection_length1 = _tmp0__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			ThumbnailCacheSize size = 0;
			size = size_collection[size_it];
			{
				Scaling current_scaling = {0};
				Scaling _tmp1_ = {0};
				GdkPixbuf* current_thumbnail = NULL;
				GdkPixbuf* _tmp2_;
				GdkPixbuf* _tmp3_;
				thumbnail_cache_size_get_scaling (size, &_tmp1_);
				current_scaling = _tmp1_;
				_tmp2_ = scaling_perform_on_pixbuf (&current_scaling, preview_frame, GDK_INTERP_HYPER, TRUE);
				current_thumbnail = _tmp2_;
				_tmp3_ = current_thumbnail;
				thumbnails_set (thumbnails, size, _tmp3_);
				_g_object_unref0 (current_thumbnail);
			}
		}
	}
}

static void
thumbnail_cache_schedule_debug (void)
{
}

static void
thumbnail_cache_report_cycle (void)
{
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static GdkPixbuf*
_thumbnail_cache_fetch (ThumbnailCache* self,
                        ThumbnailSource* source,
                        GError** error)
{
	GdkPixbuf* pixbuf = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	gint _tmp38_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = data_source_get_source_id ((DataSource*) source);
	_tmp1_ = _tmp0_;
	_tmp2_ = thumbnail_cache_fetch_from_memory (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pixbuf = _tmp3_;
	_tmp4_ = pixbuf;
	if (_tmp4_ != NULL) {
		result = pixbuf;
		return result;
	}
	{
		GdkPixbuf* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp6_ = data_source_get_source_id ((DataSource*) source);
		_tmp7_ = _tmp6_;
		_tmp8_ = thumbnail_cache_read_pixbuf (self, _tmp7_, thumbnail_source_get_preferred_thumbnail_format (source), &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp5_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp10_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err;
		if (_tmp11_->domain == G_FILE_ERROR) {
			{
				Photo* photo = NULL;
				Photo* _tmp12_;
				Video* video = NULL;
				Video* _tmp13_;
				Photo* _tmp14_;
				Video* _tmp26_;
				_tmp12_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
				photo = _tmp12_;
				_tmp13_ = _g_object_ref0 (IS_VIDEO (source) ? ((Video*) source) : NULL);
				video = _tmp13_;
				_tmp14_ = photo;
				if (_tmp14_ != NULL) {
					GdkPixbuf* _tmp15_ = NULL;
					Photo* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					Scaling _tmp19_ = {0};
					GdkPixbuf* _tmp20_;
					GdkPixbuf* _tmp21_;
					GdkPixbuf* _tmp22_;
					Photo* _tmp23_;
					Alteration* _tmp24_;
					Alteration* _tmp25_;
					_tmp16_ = photo;
					_tmp17_ = thumbnail_cache_get_scale_factor ();
					_tmp18_ = _tmp17_;
					scaling_for_best_fit (thumbnail_cache_size_get_scale (self->priv->size) * _tmp18_, TRUE, &_tmp19_);
					_tmp20_ = photo_source_get_pixbuf ((PhotoSource*) _tmp16_, &_tmp19_, &_inner_error0_);
					_tmp15_ = _tmp20_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_tmp21_ = _tmp15_;
					_tmp15_ = NULL;
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp21_;
					_tmp22_ = pixbuf;
					thumbnail_cache_replace (source, self->priv->size, _tmp22_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (_tmp15_);
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_tmp23_ = photo;
					_tmp24_ = alteration_new ("image", "thumbnail");
					_tmp25_ = _tmp24_;
					data_object_notify_altered ((DataObject*) _tmp23_, _tmp25_);
					_alteration_unref0 (_tmp25_);
					_g_object_unref0 (_tmp15_);
				}
				_tmp26_ = video;
				if (_tmp26_ != NULL) {
					GdkPixbuf* _tmp27_ = NULL;
					Video* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					GdkPixbuf* _tmp31_;
					GdkPixbuf* _tmp32_;
					GdkPixbuf* _tmp33_;
					_tmp28_ = video;
					_tmp29_ = thumbnail_cache_get_scale_factor ();
					_tmp30_ = _tmp29_;
					_tmp31_ = thumbnail_source_create_thumbnail ((ThumbnailSource*) _tmp28_, thumbnail_cache_size_get_scale (self->priv->size) * _tmp30_, &_inner_error0_);
					_tmp27_ = _tmp31_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_tmp32_ = _tmp27_;
					_tmp27_ = NULL;
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp32_;
					_tmp33_ = pixbuf;
					thumbnail_cache_replace (source, self->priv->size, _tmp33_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (_tmp27_);
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_g_object_unref0 (_tmp27_);
				}
				_g_object_unref0 (video);
				_g_object_unref0 (photo);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _tmp34_;
				GError* _tmp35_;
				g_clear_error (&_inner_error0_);
				_tmp34_ = err;
				_tmp35_ = _g_error_copy0 (_tmp34_);
				_inner_error0_ = _tmp35_;
				goto __finally1;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				goto __finally0;
			}
		} else {
			GError* _tmp36_;
			GError* _tmp37_;
			_tmp36_ = err;
			_tmp37_ = _g_error_copy0 (_tmp36_);
			_inner_error0_ = _tmp37_;
			_g_error_free0 (err);
			goto __finally0;
		}
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		return NULL;
	}
	_tmp38_ = thumbnail_cache_cycle_fetched_thumbnails;
	thumbnail_cache_cycle_fetched_thumbnails = _tmp38_ + 1;
	thumbnail_cache_schedule_debug ();
	result = pixbuf;
	return result;
}

static void
_thumbnail_cache_fetch_async (ThumbnailCache* self,
                              ThumbnailSource* source,
                              PhotoFileFormat format,
                              Dimensions* dim,
                              GdkInterpType interp,
                              ThumbnailCacheAsyncFetchCallback callback,
                              gpointer callback_target,
                              GCancellable* cancellable)
{
	gchar* thumbnail_name = NULL;
	gchar* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GdkPixbuf* _tmp4_;
	Workers* _tmp12_;
	const gchar* _tmp13_;
	GdkPixbuf* _tmp14_;
	Dimensions _tmp15_;
	ThumbnailCacheAsyncFetchJob* _tmp16_;
	ThumbnailCacheAsyncFetchJob* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = data_source_get_source_id ((DataSource*) source);
	thumbnail_name = _tmp0_;
	_tmp1_ = thumbnail_name;
	_tmp2_ = thumbnail_cache_fetch_from_memory (self, _tmp1_);
	pixbuf = _tmp2_;
	_tmp4_ = pixbuf;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		if (!dimensions_has_area (dim)) {
			_tmp5_ = TRUE;
		} else {
			GdkPixbuf* _tmp6_;
			Dimensions _tmp7_ = {0};
			Dimensions _tmp8_;
			_tmp6_ = pixbuf;
			dimensions_for_pixbuf (_tmp6_, &_tmp7_);
			_tmp8_ = *dim;
			_tmp5_ = dimensions_equals (&_tmp7_, &_tmp8_);
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		Dimensions _tmp11_;
		_tmp9_ = pixbuf;
		_tmp10_ = pixbuf;
		_tmp11_ = *dim;
		callback (_tmp9_, _tmp10_, &_tmp11_, interp, NULL, callback_target);
		_g_object_unref0 (pixbuf);
		_g_free0 (thumbnail_name);
		return;
	}
	_tmp12_ = thumbnail_cache_fetch_workers;
	_tmp13_ = thumbnail_name;
	_tmp14_ = pixbuf;
	_tmp15_ = *dim;
	_tmp16_ = thumbnail_cache_async_fetch_job_new (self, _tmp13_, source, _tmp14_, &_tmp15_, interp, callback, callback_target, cancellable);
	_tmp17_ = _tmp16_;
	workers_enqueue (_tmp12_, (BackgroundJob*) _tmp17_);
	_background_job_unref0 (_tmp17_);
	_g_object_unref0 (pixbuf);
	_g_free0 (thumbnail_name);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job)
{
	ThumbnailCacheAsyncFetchJob* job = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp0_;
	ThumbnailCacheAsyncFetchJob* _tmp1_;
	GdkPixbuf* _tmp2_;
	ThumbnailCacheAsyncFetchJob* _tmp12_;
	ThumbnailCacheAsyncFetchCallback _tmp13_;
	gpointer _tmp13__target;
	ThumbnailCacheAsyncFetchJob* _tmp14_;
	GdkPixbuf* _tmp15_;
	ThumbnailCacheAsyncFetchJob* _tmp16_;
	GdkPixbuf* _tmp17_;
	ThumbnailCacheAsyncFetchJob* _tmp18_;
	Dimensions _tmp19_;
	ThumbnailCacheAsyncFetchJob* _tmp20_;
	ThumbnailCacheAsyncFetchJob* _tmp21_;
	GError* _tmp22_;
	g_return_if_fail (background_job != NULL);
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (background_job, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->unscaled;
	if (_tmp2_ != NULL) {
		ThumbnailCacheAsyncFetchJob* _tmp3_;
		_tmp3_ = job;
		if (_tmp3_->fetched) {
			ThumbnailCacheAsyncFetchJob* _tmp4_;
			ThumbnailCache* _tmp5_;
			ThumbnailCacheAsyncFetchJob* _tmp6_;
			const gchar* _tmp7_;
			ThumbnailCacheAsyncFetchJob* _tmp8_;
			GdkPixbuf* _tmp9_;
			gint _tmp10_;
			_tmp4_ = job;
			_tmp5_ = _tmp4_->cache;
			_tmp6_ = job;
			_tmp7_ = _tmp6_->thumbnail_name;
			_tmp8_ = job;
			_tmp9_ = _tmp8_->unscaled;
			thumbnail_cache_store_in_memory (_tmp5_, _tmp7_, _tmp9_);
			_tmp10_ = thumbnail_cache_cycle_async_fetched_thumbnails;
			thumbnail_cache_cycle_async_fetched_thumbnails = _tmp10_ + 1;
			thumbnail_cache_schedule_debug ();
		} else {
			gint _tmp11_;
			_tmp11_ = thumbnail_cache_cycle_async_resized_thumbnails;
			thumbnail_cache_cycle_async_resized_thumbnails = _tmp11_ + 1;
			thumbnail_cache_schedule_debug ();
		}
	}
	_tmp12_ = job;
	_tmp13_ = _tmp12_->callback;
	_tmp13__target = _tmp12_->callback_target;
	_tmp14_ = job;
	_tmp15_ = _tmp14_->scaled;
	_tmp16_ = job;
	_tmp17_ = _tmp16_->unscaled;
	_tmp18_ = job;
	_tmp19_ = _tmp18_->dim;
	_tmp20_ = job;
	_tmp21_ = job;
	_tmp22_ = _tmp21_->err;
	_tmp13_ (_tmp15_, _tmp17_, &_tmp19_, _tmp20_->interp, _tmp22_, _tmp13__target);
	_background_job_unref0 (job);
}

static void
_thumbnail_cache_import_from_source (ThumbnailCache* self,
                                     ThumbnailSource* source,
                                     gboolean force,
                                     GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Scaling _tmp6_ = {0};
	GdkPixbuf* _tmp7_;
	GFile* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	file = _tmp0_;
	if (!force) {
		if (_thumbnail_cache_exists (self, source)) {
			_g_object_unref0 (file);
			return;
		}
	} else {
		_thumbnail_cache_remove (self, source);
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	photo = _tmp1_;
	_tmp3_ = photo;
	_tmp4_ = thumbnail_cache_get_scale_factor ();
	_tmp5_ = _tmp4_;
	scaling_for_best_fit (thumbnail_cache_size_get_scale (self->priv->size) * _tmp5_, TRUE, &_tmp6_);
	_tmp7_ = photo_source_get_pixbuf ((PhotoSource*) _tmp3_, &_tmp6_, &_inner_error0_);
	_tmp2_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (photo);
		_g_object_unref0 (file);
		return;
	}
	_tmp8_ = file;
	thumbnail_cache_save_thumbnail (self, _tmp8_, _tmp2_, source, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (photo);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (photo);
	_g_object_unref0 (file);
}

static void
_thumbnail_cache_import_thumbnail (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   GdkPixbuf* scaled,
                                   gboolean force,
                                   GError** error)
{
	Dimensions _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_vala_assert (scaled != NULL, "scaled != null");
	dimensions_for_pixbuf (scaled, &_tmp0_);
	_tmp1_ = thumbnail_cache_get_scale_factor ();
	_tmp2_ = _tmp1_;
	_vala_assert (dimensions_approx_scaled (&_tmp0_, thumbnail_cache_size_get_scale (self->priv->size) * _tmp2_, 1), "Dimensions.for_pixbuf (scaled).approx_scaled (size.get_scale () * scale_factor)");
	if (!force) {
		if (_thumbnail_cache_exists (self, source)) {
			return;
		}
	} else {
		_thumbnail_cache_remove (self, source);
	}
	_tmp3_ = thumbnail_cache_get_source_cached_file (self, source);
	_tmp4_ = _tmp3_;
	thumbnail_cache_save_thumbnail (self, _tmp4_, scaled, source, &_inner_error0_);
	_g_object_unref0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_thumbnail_cache_duplicate (ThumbnailCache* self,
                            ThumbnailSource* src_source,
                            ThumbnailSource* dest_source)
{
	GFile* src_file = NULL;
	GFile* _tmp0_;
	GFile* dest_file = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src_source != NULL);
	g_return_if_fail (dest_source != NULL);
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, src_source);
	src_file = _tmp0_;
	_tmp1_ = thumbnail_source_get_representative_id (dest_source);
	_tmp2_ = _tmp1_;
	_tmp3_ = thumbnail_cache_get_cached_file (self, _tmp2_, thumbnail_source_get_preferred_thumbnail_format (src_source));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	dest_file = _tmp4_;
	{
		g_file_copy (src_file, dest_file, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf ("%s", _tmp6_);
		_tmp8_ = _tmp7_;
		app_window_panic (_tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest_file);
		_g_object_unref0 (src_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dest_file);
	_g_object_unref0 (src_file);
}

static void
_thumbnail_cache_replace (ThumbnailCache* self,
                          ThumbnailSource* source,
                          GdkPixbuf* original,
                          GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* scaled = NULL;
	gint _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (original != NULL);
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	file = _tmp0_;
	_tmp1_ = data_source_get_source_id ((DataSource*) source);
	_tmp2_ = _tmp1_;
	thumbnail_cache_remove_from_memory (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = thumbnail_cache_get_scale_factor ();
	_tmp4_ = _tmp3_;
	_tmp5_ = scale_pixbuf (original, thumbnail_cache_size_get_scale (self->priv->size) * _tmp4_, self->priv->interp, TRUE);
	scaled = _tmp5_;
	thumbnail_cache_save_thumbnail (self, file, scaled, source, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (scaled);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = data_source_get_source_id ((DataSource*) source);
	_tmp7_ = _tmp6_;
	thumbnail_cache_store_in_memory (self, _tmp7_, scaled);
	_g_free0 (_tmp7_);
	_g_object_unref0 (scaled);
	_g_object_unref0 (file);
}

static void
_thumbnail_cache_remove (ThumbnailCache* self,
                         ThumbnailSource* source)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	file = _tmp0_;
	_tmp1_ = data_source_get_source_id ((DataSource*) source);
	_tmp2_ = _tmp1_;
	thumbnail_cache_remove_from_memory (self, _tmp2_);
	_g_free0 (_tmp2_);
	{
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static gboolean
_thumbnail_cache_exists (ThumbnailCache* self,
                         ThumbnailSource* source)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static GdkPixbuf*
thumbnail_cache_read_pixbuf (ThumbnailCache* self,
                             const gchar* thumbnail_name,
                             PhotoFileFormat format,
                             GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoFileReader* _tmp5_;
	PhotoFileReader* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	_tmp1_ = thumbnail_cache_get_cached_file (self, thumbnail_name, format);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = photo_file_format_create_reader (format, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = photo_file_reader_unscaled_read (_tmp6_, &_inner_error0_);
	_tmp8_ = _tmp7_;
	_photo_file_adapter_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp9_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GFile*
thumbnail_cache_get_source_cached_file (ThumbnailCache* self,
                                        ThumbnailSource* source)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = thumbnail_source_get_representative_id (source);
	_tmp1_ = _tmp0_;
	_tmp2_ = thumbnail_cache_get_cached_file (self, _tmp1_, thumbnail_source_get_preferred_thumbnail_format (source));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
thumbnail_cache_get_cached_file (ThumbnailCache* self,
                                 const gchar* thumbnail_name,
                                 PhotoFileFormat thumbnail_format)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	_tmp0_ = self->priv->cache_dir;
	_tmp1_ = photo_file_format_get_default_basename (thumbnail_format, thumbnail_name);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static GdkPixbuf*
thumbnail_cache_fetch_from_memory (ThumbnailCache* self,
                                   const gchar* thumbnail_name)
{
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	ThumbnailCacheImageData* _tmp3_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	_tmp0_ = self->priv->cache_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, thumbnail_name);
	data = (ThumbnailCacheImageData*) _tmp1_;
	_tmp3_ = data;
	if (_tmp3_ != NULL) {
		ThumbnailCacheImageData* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = data;
		_tmp5_ = _tmp4_->pixbuf;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	result = _tmp6_;
	_thumbnail_cache_image_data_unref0 (data);
	return result;
}

static void
thumbnail_cache_store_in_memory (ThumbnailCache* self,
                                 const gchar* thumbnail_name,
                                 GdkPixbuf* thumbnail)
{
	ThumbnailCacheImageData* data = NULL;
	ThumbnailCacheImageData* _tmp0_;
	ThumbnailCacheImageData* _tmp1_;
	GeeHashMap* _tmp2_;
	ThumbnailCacheImageData* _tmp3_;
	GeeArrayList* _tmp4_;
	ThumbnailCacheImageData* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (thumbnail_name != NULL);
	g_return_if_fail (thumbnail != NULL);
	if (self->priv->max_cached_bytes <= ((gulong) 0)) {
		return;
	}
	thumbnail_cache_remove_from_memory (self, thumbnail_name);
	_tmp0_ = thumbnail_cache_image_data_new (thumbnail);
	data = _tmp0_;
	_tmp1_ = data;
	if (_tmp1_->bytes > ((gulong) THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE)) {
		g_debug ("ThumbnailCache.vala:616: Persistent thumbnail [%s] too large to cache " \
"in memory", thumbnail_name);
		_thumbnail_cache_image_data_unref0 (data);
		return;
	}
	_tmp2_ = self->priv->cache_map;
	_tmp3_ = data;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, thumbnail_name, _tmp3_);
	_tmp4_ = self->priv->cache_lru;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp4_, 0, thumbnail_name);
	_tmp5_ = data;
	self->priv->cached_bytes = self->priv->cached_bytes + _tmp5_->bytes;
	while (TRUE) {
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint index = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* victim_name = NULL;
		GeeArrayList* _tmp12_;
		gpointer _tmp13_;
		GeeArrayList* _tmp14_;
		gpointer _tmp15_;
		gchar* _tmp16_;
		GeeHashMap* _tmp17_;
		const gchar* _tmp18_;
		gpointer _tmp19_;
		gint _tmp20_;
		gboolean removed = FALSE;
		GeeHashMap* _tmp21_;
		const gchar* _tmp22_;
		ThumbnailCacheImageData* _tmp23_;
		ThumbnailCacheImageData* _tmp24_;
		if (!(self->priv->cached_bytes > self->priv->max_cached_bytes)) {
			break;
		}
		_tmp6_ = self->priv->cache_lru;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ > 0, "cache_lru.size > 0");
		_tmp9_ = self->priv->cache_lru;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		index = _tmp11_ - 1;
		_tmp12_ = self->priv->cache_lru;
		_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, index);
		victim_name = (gchar*) _tmp13_;
		_tmp14_ = self->priv->cache_lru;
		_tmp15_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp14_, index);
		_tmp16_ = (gchar*) _tmp15_;
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->cache_map;
		_tmp18_ = victim_name;
		_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
		_thumbnail_cache_image_data_unref0 (data);
		data = (ThumbnailCacheImageData*) _tmp19_;
		_tmp20_ = thumbnail_cache_cycle_overflow_thumbnails;
		thumbnail_cache_cycle_overflow_thumbnails = _tmp20_ + 1;
		thumbnail_cache_schedule_debug ();
		_tmp21_ = self->priv->cache_map;
		_tmp22_ = victim_name;
		removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp21_, _tmp22_, NULL);
		_vala_assert (removed, "removed");
		_tmp23_ = data;
		_vala_assert (_tmp23_->bytes <= self->priv->cached_bytes, "data.bytes <= cached_bytes");
		_tmp24_ = data;
		self->priv->cached_bytes = self->priv->cached_bytes - _tmp24_->bytes;
		_g_free0 (victim_name);
	}
	_thumbnail_cache_image_data_unref0 (data);
}

static gboolean
thumbnail_cache_remove_from_memory (ThumbnailCache* self,
                                    const gchar* thumbnail_name)
{
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ThumbnailCacheImageData* _tmp2_;
	ThumbnailCacheImageData* _tmp3_;
	ThumbnailCacheImageData* _tmp4_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp5_;
	GeeArrayList* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (thumbnail_name != NULL, FALSE);
	_tmp0_ = self->priv->cache_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, thumbnail_name);
	data = (ThumbnailCacheImageData*) _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_thumbnail_cache_image_data_unref0 (data);
		return result;
	}
	_tmp3_ = data;
	_vala_assert (self->priv->cached_bytes >= _tmp3_->bytes, "cached_bytes >= data.bytes");
	_tmp4_ = data;
	self->priv->cached_bytes = self->priv->cached_bytes - _tmp4_->bytes;
	_tmp5_ = self->priv->cache_map;
	removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, thumbnail_name, NULL);
	_vala_assert (removed, "removed");
	_tmp6_ = self->priv->cache_lru;
	removed = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, thumbnail_name);
	_vala_assert (removed, "removed");
	result = TRUE;
	_thumbnail_cache_image_data_unref0 (data);
	return result;
}

static void
thumbnail_cache_save_thumbnail (ThumbnailCache* self,
                                GFile* file,
                                GdkPixbuf* pixbuf,
                                ThumbnailSource* source,
                                GError** error)
{
	PhotoFileWriter* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileWriter* _tmp3_;
	PhotoFileWriter* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (source != NULL);
	_tmp1_ = g_file_get_path (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_file_format_create_writer (thumbnail_source_get_preferred_thumbnail_format (source), _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	photo_file_writer_write (_tmp0_, pixbuf, THUMBNAIL_CACHE_DEFAULT_QUALITY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp0_);
		return;
	}
	_photo_file_adapter_unref0 (_tmp0_);
}

gint
thumbnail_cache_get_scale_factor (void)
{
	gint result;
	result = thumbnail_cache__scale_factor;
	return result;
}

void
thumbnail_cache_set_scale_factor (gint value)
{
	if (thumbnail_cache__scale_factor != value) {
		ThumbnailCache* _tmp0_;
		ThumbnailCache* _tmp1_;
		thumbnail_cache__scale_factor = value;
		_tmp0_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_BIG, THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
		_g_object_unref0 (thumbnail_cache_big);
		thumbnail_cache_big = _tmp0_;
		_tmp1_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_MEDIUM, THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
		_g_object_unref0 (thumbnail_cache_medium);
		thumbnail_cache_medium = _tmp1_;
	}
}

static ThumbnailCacheImageData*
thumbnail_cache_image_data_construct (GType object_type,
                                      GdkPixbuf* pixbuf)
{
	ThumbnailCacheImageData* self = NULL;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (ThumbnailCacheImageData*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->pixbuf);
	self->pixbuf = _tmp0_;
	self->bytes = ((gulong) gdk_pixbuf_get_rowstride (pixbuf)) * ((gulong) gdk_pixbuf_get_height (pixbuf));
	return self;
}

static ThumbnailCacheImageData*
thumbnail_cache_image_data_new (GdkPixbuf* pixbuf)
{
	return thumbnail_cache_image_data_construct (THUMBNAIL_CACHE_TYPE_IMAGE_DATA, pixbuf);
}

static void
thumbnail_cache_value_image_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
thumbnail_cache_value_image_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		thumbnail_cache_image_data_unref (value->data[0].v_pointer);
	}
}

static void
thumbnail_cache_value_image_data_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = thumbnail_cache_image_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
thumbnail_cache_value_image_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
thumbnail_cache_value_image_data_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ThumbnailCacheImageData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = thumbnail_cache_image_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
thumbnail_cache_value_image_data_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	ThumbnailCacheImageData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = thumbnail_cache_image_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
thumbnail_cache_param_spec_image_data (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ThumbnailCacheParamSpecImageData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
thumbnail_cache_value_get_image_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
	return value->data[0].v_pointer;
}

static void
thumbnail_cache_value_set_image_data (GValue* value,
                                      gpointer v_object)
{
	ThumbnailCacheImageData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		thumbnail_cache_image_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnail_cache_image_data_unref (old);
	}
}

static void
thumbnail_cache_value_take_image_data (GValue* value,
                                       gpointer v_object)
{
	ThumbnailCacheImageData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnail_cache_image_data_unref (old);
	}
}

static void
thumbnail_cache_image_data_class_init (ThumbnailCacheImageDataClass * klass,
                                       gpointer klass_data)
{
	thumbnail_cache_image_data_parent_class = g_type_class_peek_parent (klass);
	((ThumbnailCacheImageDataClass *) klass)->finalize = thumbnail_cache_image_data_finalize;
}

static void
thumbnail_cache_image_data_instance_init (ThumbnailCacheImageData * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
thumbnail_cache_image_data_finalize (ThumbnailCacheImageData * obj)
{
	ThumbnailCacheImageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData);
	g_signal_handlers_destroy (self);
	thumbnail_cache_cycle_dropped_bytes = thumbnail_cache_cycle_dropped_bytes + self->bytes;
	thumbnail_cache_schedule_debug ();
	_g_object_unref0 (self->pixbuf);
}

static GType
thumbnail_cache_image_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { thumbnail_cache_value_image_data_init, thumbnail_cache_value_image_data_free_value, thumbnail_cache_value_image_data_copy_value, thumbnail_cache_value_image_data_peek_pointer, "p", thumbnail_cache_value_image_data_collect_value, "p", thumbnail_cache_value_image_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheImageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_image_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheImageData), 0, (GInstanceInitFunc) thumbnail_cache_image_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType thumbnail_cache_image_data_type_id;
	thumbnail_cache_image_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThumbnailCacheImageData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return thumbnail_cache_image_data_type_id;
}

static GType
thumbnail_cache_image_data_get_type (void)
{
	static volatile gsize thumbnail_cache_image_data_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_image_data_type_id__once)) {
		GType thumbnail_cache_image_data_type_id;
		thumbnail_cache_image_data_type_id = thumbnail_cache_image_data_get_type_once ();
		g_once_init_leave (&thumbnail_cache_image_data_type_id__once, thumbnail_cache_image_data_type_id);
	}
	return thumbnail_cache_image_data_type_id__once;
}

static gpointer
thumbnail_cache_image_data_ref (gpointer instance)
{
	ThumbnailCacheImageData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
thumbnail_cache_image_data_unref (gpointer instance)
{
	ThumbnailCacheImageData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job,
                                                                      gpointer self)
{
	thumbnail_cache_async_fetch_completion_callback (job);
}

static ThumbnailCacheAsyncFetchJob*
thumbnail_cache_async_fetch_job_construct (GType object_type,
                                           ThumbnailCache* cache,
                                           const gchar* thumbnail_name,
                                           ThumbnailSource* source,
                                           GdkPixbuf* prefetched,
                                           Dimensions* dim,
                                           GdkInterpType interp,
                                           ThumbnailCacheAsyncFetchCallback callback,
                                           gpointer callback_target,
                                           GCancellable* cancellable)
{
	ThumbnailCacheAsyncFetchJob* self = NULL;
	ThumbnailCache* _tmp0_;
	gchar* _tmp1_;
	ThumbnailSource* _tmp2_;
	GdkPixbuf* _tmp3_;
	Dimensions _tmp4_;
	g_return_val_if_fail (cache != NULL, NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (dim != NULL, NULL);
	self = (ThumbnailCacheAsyncFetchJob*) background_job_construct (object_type, (GObject*) cache, _thumbnail_cache_async_fetch_completion_callback_completion_callback, NULL, cancellable, NULL, NULL, NULL);
	_tmp0_ = _g_object_ref0 (cache);
	_g_object_unref0 (self->cache);
	self->cache = _tmp0_;
	_tmp1_ = g_strdup (thumbnail_name);
	_g_free0 (self->thumbnail_name);
	self->thumbnail_name = _tmp1_;
	_tmp2_ = _g_object_ref0 (source);
	_g_object_unref0 (self->source);
	self->source = _tmp2_;
	self->source_format = thumbnail_source_get_preferred_thumbnail_format (source);
	_tmp3_ = _g_object_ref0 (prefetched);
	_g_object_unref0 (self->unscaled);
	self->unscaled = _tmp3_;
	_tmp4_ = *dim;
	self->dim = _tmp4_;
	self->interp = interp;
	self->callback = callback;
	self->callback_target = callback_target;
	return self;
}

static ThumbnailCacheAsyncFetchJob*
thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache,
                                     const gchar* thumbnail_name,
                                     ThumbnailSource* source,
                                     GdkPixbuf* prefetched,
                                     Dimensions* dim,
                                     GdkInterpType interp,
                                     ThumbnailCacheAsyncFetchCallback callback,
                                     gpointer callback_target,
                                     GCancellable* cancellable)
{
	return thumbnail_cache_async_fetch_job_construct (THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, cache, thumbnail_name, source, prefetched, dim, interp, callback, callback_target, cancellable);
}

static BackgroundJobJobPriority
thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base)
{
	ThumbnailCacheAsyncFetchJob * self;
	BackgroundJobJobPriority result;
	self = (ThumbnailCacheAsyncFetchJob*) base;
	switch (self->interp) {
		case GDK_INTERP_NEAREST:
		case GDK_INTERP_TILES:
		{
			result = BACKGROUND_JOB_JOB_PRIORITY_HIGH;
			return result;
		}
		default:
		case GDK_INTERP_BILINEAR:
		case GDK_INTERP_HYPER:
		{
			result = BACKGROUND_JOB_JOB_PRIORITY_NORMAL;
			return result;
		}
	}
}

static void
thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base)
{
	ThumbnailCacheAsyncFetchJob * self;
	GError* _inner_error0_ = NULL;
	self = (ThumbnailCacheAsyncFetchJob*) base;
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp12_;
		_tmp0_ = self->unscaled;
		if (_tmp0_ == NULL) {
			GdkPixbuf* _tmp1_ = NULL;
			ThumbnailCache* _tmp2_;
			const gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			_tmp2_ = self->cache;
			_tmp3_ = self->thumbnail_name;
			_tmp4_ = thumbnail_cache_read_pixbuf (_tmp2_, _tmp3_, self->source_format, &_inner_error0_);
			_tmp1_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->unscaled);
			self->unscaled = _tmp5_;
			self->fetched = TRUE;
			_g_object_unref0 (_tmp1_);
		}
		if (background_job_is_cancelled ((BackgroundJob*) self)) {
			return;
		}
		if (dimensions_has_area (&self->dim)) {
			GdkPixbuf* _tmp7_;
			Dimensions _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp7_ = self->unscaled;
			_tmp8_ = self->dim;
			_tmp9_ = resize_pixbuf (_tmp7_, &_tmp8_, self->interp);
			_g_object_unref0 (_tmp6_);
			_tmp6_ = _tmp9_;
		} else {
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			_tmp10_ = self->unscaled;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (_tmp6_);
			_tmp6_ = _tmp11_;
		}
		_tmp12_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->scaled);
		self->scaled = _tmp12_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		GError* _tmp49_;
		GError* _tmp50_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		if (_tmp13_->domain == G_FILE_ERROR) {
			{
				Photo* photo = NULL;
				ThumbnailSource* _tmp14_;
				Photo* _tmp15_;
				Video* video = NULL;
				ThumbnailSource* _tmp16_;
				Video* _tmp17_;
				Photo* _tmp18_;
				Video* _tmp28_;
				_tmp14_ = self->source;
				_tmp15_ = _g_object_ref0 (IS_PHOTO (_tmp14_) ? ((Photo*) _tmp14_) : NULL);
				photo = _tmp15_;
				_tmp16_ = self->source;
				_tmp17_ = _g_object_ref0 (IS_VIDEO (_tmp16_) ? ((Video*) _tmp16_) : NULL);
				video = _tmp17_;
				_tmp18_ = photo;
				if (_tmp18_ != NULL) {
					GdkPixbuf* _tmp19_ = NULL;
					Photo* _tmp20_;
					Dimensions _tmp21_;
					Scaling _tmp22_ = {0};
					GdkPixbuf* _tmp23_;
					GdkPixbuf* _tmp24_;
					Photo* _tmp25_;
					Alteration* _tmp26_;
					Alteration* _tmp27_;
					_tmp20_ = photo;
					_tmp21_ = self->dim;
					scaling_for_best_fit (_tmp21_.width, TRUE, &_tmp22_);
					_tmp23_ = photo_source_get_pixbuf ((PhotoSource*) _tmp20_, &_tmp22_, &_inner_error0_);
					_tmp19_ = _tmp23_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_tmp24_ = _tmp19_;
					_tmp19_ = NULL;
					_g_object_unref0 (self->unscaled);
					self->unscaled = _tmp24_;
					_tmp25_ = photo;
					_tmp26_ = alteration_new ("image", "thumbnail");
					_tmp27_ = _tmp26_;
					data_object_notify_altered ((DataObject*) _tmp25_, _tmp27_);
					_alteration_unref0 (_tmp27_);
					_g_object_unref0 (_tmp19_);
					_g_object_unref0 (video);
					_g_object_unref0 (photo);
					_g_error_free0 (err);
					return;
				}
				_tmp28_ = video;
				if (_tmp28_ != NULL) {
					GdkPixbuf* _tmp29_ = NULL;
					Video* _tmp30_;
					Dimensions _tmp31_;
					GdkPixbuf* _tmp32_;
					GdkPixbuf* _tmp33_;
					GdkPixbuf* _tmp34_;
					Dimensions _tmp35_;
					GdkPixbuf* _tmp36_;
					ThumbnailCache* _tmp37_;
					ThumbnailCache* _tmp38_;
					ThumbnailSource* _tmp39_;
					GFile* _tmp40_;
					GFile* _tmp41_;
					GdkPixbuf* _tmp42_;
					ThumbnailSource* _tmp43_;
					ThumbnailSource* _tmp44_;
					ThumbnailCache* _tmp45_;
					GdkPixbuf* _tmp46_;
					_tmp30_ = video;
					_tmp31_ = self->dim;
					_tmp32_ = thumbnail_source_create_thumbnail ((ThumbnailSource*) _tmp30_, _tmp31_.width, &_inner_error0_);
					_tmp29_ = _tmp32_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_tmp33_ = _tmp29_;
					_tmp29_ = NULL;
					_g_object_unref0 (self->unscaled);
					self->unscaled = _tmp33_;
					_tmp34_ = self->unscaled;
					_tmp35_ = self->dim;
					_tmp36_ = resize_pixbuf (_tmp34_, &_tmp35_, self->interp);
					_g_object_unref0 (self->scaled);
					self->scaled = _tmp36_;
					_tmp37_ = self->cache;
					_tmp38_ = self->cache;
					_tmp39_ = self->source;
					_tmp40_ = thumbnail_cache_get_source_cached_file (_tmp38_, _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = self->unscaled;
					_tmp43_ = self->source;
					thumbnail_cache_save_thumbnail (_tmp37_, _tmp41_, _tmp42_, _tmp43_, &_inner_error0_);
					_g_object_unref0 (_tmp41_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (_tmp29_);
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_tmp44_ = self->source;
					_tmp45_ = self->cache;
					_tmp46_ = self->unscaled;
					thumbnail_cache_replace (_tmp44_, _tmp45_->priv->size, _tmp46_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (_tmp29_);
						_g_object_unref0 (video);
						_g_object_unref0 (photo);
						goto __catch1_g_error;
					}
					_g_object_unref0 (_tmp29_);
					_g_object_unref0 (video);
					_g_object_unref0 (photo);
					_g_error_free0 (err);
					return;
				}
				_g_object_unref0 (video);
				_g_object_unref0 (photo);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp47_;
				GError* _tmp48_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp47_ = e;
				_tmp48_ = _g_error_copy0 (_tmp47_);
				_g_error_free0 (self->err);
				self->err = _tmp48_;
				_g_error_free0 (e);
				_g_error_free0 (err);
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp49_ = err;
		_tmp50_ = _g_error_copy0 (_tmp49_);
		_g_error_free0 (self->err);
		self->err = _tmp50_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
thumbnail_cache_async_fetch_job_class_init (ThumbnailCacheAsyncFetchJobClass * klass,
                                            gpointer klass_data)
{
	thumbnail_cache_async_fetch_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = thumbnail_cache_async_fetch_job_finalize;
	((BackgroundJobClass *) klass)->get_priority = (BackgroundJobJobPriority (*) (BackgroundJob*)) thumbnail_cache_async_fetch_job_real_get_priority;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) thumbnail_cache_async_fetch_job_real_execute;
}

static void
thumbnail_cache_async_fetch_job_instance_init (ThumbnailCacheAsyncFetchJob * self,
                                               gpointer klass)
{
	self->scaled = NULL;
	self->err = NULL;
	self->fetched = FALSE;
}

static void
thumbnail_cache_async_fetch_job_finalize (BackgroundJob * obj)
{
	ThumbnailCacheAsyncFetchJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
	_g_object_unref0 (self->cache);
	_g_free0 (self->thumbnail_name);
	_g_object_unref0 (self->source);
	_g_object_unref0 (self->unscaled);
	_g_object_unref0 (self->scaled);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (thumbnail_cache_async_fetch_job_parent_class)->finalize (obj);
}

static GType
thumbnail_cache_async_fetch_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheAsyncFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_async_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheAsyncFetchJob), 0, (GInstanceInitFunc) thumbnail_cache_async_fetch_job_instance_init, NULL };
	GType thumbnail_cache_async_fetch_job_type_id;
	thumbnail_cache_async_fetch_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ThumbnailCacheAsyncFetchJob", &g_define_type_info, 0);
	return thumbnail_cache_async_fetch_job_type_id;
}

static GType
thumbnail_cache_async_fetch_job_get_type (void)
{
	static volatile gsize thumbnail_cache_async_fetch_job_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_async_fetch_job_type_id__once)) {
		GType thumbnail_cache_async_fetch_job_type_id;
		thumbnail_cache_async_fetch_job_type_id = thumbnail_cache_async_fetch_job_get_type_once ();
		g_once_init_leave (&thumbnail_cache_async_fetch_job_type_id__once, thumbnail_cache_async_fetch_job_type_id);
	}
	return thumbnail_cache_async_fetch_job_type_id__once;
}

static void
thumbnail_cache_class_init (ThumbnailCacheClass * klass,
                            gpointer klass_data)
{
	ThumbnailCacheSize* _tmp0_;
	thumbnail_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ThumbnailCache_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_thumbnail_cache_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_thumbnail_cache_set_property;
	G_OBJECT_CLASS (klass)->finalize = thumbnail_cache_finalize;
	_tmp0_ = g_new0 (ThumbnailCacheSize, 2);
	_tmp0_[0] = THUMBNAIL_CACHE_SIZE_BIG;
	_tmp0_[1] = THUMBNAIL_CACHE_SIZE_MEDIUM;
	thumbnail_cache_all_sizes = _tmp0_;
	thumbnail_cache_all_sizes_length1 = 2;
	_thumbnail_cache_all_sizes_size_ = thumbnail_cache_all_sizes_length1;
}

static void
thumbnail_cache_instance_init (ThumbnailCache * self,
                               gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = thumbnail_cache_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, (GBoxedCopyFunc) thumbnail_cache_image_data_ref, (GDestroyNotify) thumbnail_cache_image_data_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->cache_map = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->cache_lru = _tmp1_;
	self->priv->cached_bytes = (gulong) 0;
}

static void
thumbnail_cache_finalize (GObject * obj)
{
	ThumbnailCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL_CACHE, ThumbnailCache);
	_g_object_unref0 (self->priv->cache_dir);
	_g_object_unref0 (self->priv->cache_map);
	_g_object_unref0 (self->priv->cache_lru);
	G_OBJECT_CLASS (thumbnail_cache_parent_class)->finalize (obj);
}

static GType
thumbnail_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCache), 0, (GInstanceInitFunc) thumbnail_cache_instance_init, NULL };
	GType thumbnail_cache_type_id;
	thumbnail_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "ThumbnailCache", &g_define_type_info, 0);
	ThumbnailCache_private_offset = g_type_add_instance_private (thumbnail_cache_type_id, sizeof (ThumbnailCachePrivate));
	return thumbnail_cache_type_id;
}

GType
thumbnail_cache_get_type (void)
{
	static volatile gsize thumbnail_cache_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_type_id__once)) {
		GType thumbnail_cache_type_id;
		thumbnail_cache_type_id = thumbnail_cache_get_type_once ();
		g_once_init_leave (&thumbnail_cache_type_id__once, thumbnail_cache_type_id);
	}
	return thumbnail_cache_type_id__once;
}

static void
_vala_thumbnail_cache_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	ThumbnailCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL_CACHE, ThumbnailCache);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_thumbnail_cache_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	ThumbnailCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL_CACHE, ThumbnailCache);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

