/* WebPSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WebPSupport.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <webp/decode.h>
#include <webp/encode.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_WEB_PFILE_FORMAT_PROPERTIES (web_pfile_format_properties_get_type ())
#define WEB_PFILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WEB_PFILE_FORMAT_PROPERTIES, WebPFileFormatProperties))
#define WEB_PFILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WEB_PFILE_FORMAT_PROPERTIES, WebPFileFormatPropertiesClass))
#define IS_WEB_PFILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WEB_PFILE_FORMAT_PROPERTIES))
#define IS_WEB_PFILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WEB_PFILE_FORMAT_PROPERTIES))
#define WEB_PFILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WEB_PFILE_FORMAT_PROPERTIES, WebPFileFormatPropertiesClass))

typedef struct _WebPFileFormatProperties WebPFileFormatProperties;
typedef struct _WebPFileFormatPropertiesClass WebPFileFormatPropertiesClass;
typedef struct _WebPFileFormatPropertiesPrivate WebPFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

struct _WebPFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	WebPFileFormatPropertiesPrivate * priv;
};

struct _WebPFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

static gpointer web_pfile_format_properties_parent_class = NULL;
static gchar** web_pfile_format_properties_known_extensions;
static gint web_pfile_format_properties_known_extensions_length1;
static gchar** web_pfile_format_properties_known_extensions = NULL;
static gint web_pfile_format_properties_known_extensions_length1 = 0;
static gint _web_pfile_format_properties_known_extensions_size_ = 0;
static gchar** web_pfile_format_properties_known_mime_types;
static gint web_pfile_format_properties_known_mime_types_length1;
static gchar** web_pfile_format_properties_known_mime_types = NULL;
static gint web_pfile_format_properties_known_mime_types_length1 = 0;
static gint _web_pfile_format_properties_known_mime_types_size_ = 0;
static WebPFileFormatProperties* web_pfile_format_properties_instance;
static WebPFileFormatProperties* web_pfile_format_properties_instance = NULL;
static gpointer web_psniffer_parent_class = NULL;
static gpointer web_preader_parent_class = NULL;
static gpointer web_pfile_format_driver_parent_class = NULL;
static WebPFileFormatDriver* web_pfile_format_driver_instance;
static WebPFileFormatDriver* web_pfile_format_driver_instance = NULL;

VALA_EXTERN GType web_pfile_format_properties_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void web_pfile_format_properties_init (void);
VALA_EXTERN WebPFileFormatProperties* web_pfile_format_properties_new (void);
VALA_EXTERN WebPFileFormatProperties* web_pfile_format_properties_construct (GType object_type);
VALA_EXTERN WebPFileFormatProperties* web_pfile_format_properties_get_instance (void);
static PhotoFileFormat web_pfile_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags web_pfile_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* web_pfile_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar* web_pfile_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** web_pfile_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                               gint* result_length1);
static gchar** _vala_array_dup24 (gchar** self,
                           gssize length);
static gchar* web_pfile_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** web_pfile_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                         gint* result_length1);
static gchar** _vala_array_dup25 (gchar** self,
                           gssize length);
static void web_pfile_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType web_pfile_format_properties_get_type_once (void);
static gboolean web_psniffer_is_webp_file (GFile* file,
                                    GError** error);
static DetectedPhotoInformation* web_psniffer_real_sniff (PhotoFileSniffer* base,
                                                   GError** error);
static GType web_psniffer_get_type_once (void);
static GdkPixbuf* web_preader_real_scaled_read (PhotoFileReader* base,
                                         Dimensions* full,
                                         Dimensions* scaled,
                                         GError** error);
static GdkPixbuf* web_preader_real_unscaled_read (PhotoFileReader* base,
                                           GError** error);
static PhotoMetadata* web_preader_real_read_metadata (PhotoFileReader* base,
                                               GError** error);
static GType web_preader_get_type_once (void);
static PhotoFileFormatProperties* web_pfile_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* web_pfile_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                             const gchar* filepath);
static gboolean web_pfile_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean web_pfile_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* web_pfile_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                             const gchar* filepath);
static PhotoFileMetadataWriter* web_pfile_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                              const gchar* filepath);
static PhotoFileSniffer* web_pfile_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                               GFile* file,
                                                               PhotoFileSnifferOptions options);
static PhotoMetadata* web_pfile_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
static void web_pfile_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType web_pfile_format_driver_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const guint8 WEB_PSNIFFER_MAGIC_SEQUENCE_RIFF[4] = {(guint8) 0x52, (guint8) 0x49, (guint8) 0x46, (guint8) 0x46};
static const guint8 WEB_PSNIFFER_MAGIC_SEQUENCE_WEBP[4] = {(guint8) 0x57, (guint8) 0x45, (guint8) 0x42, (guint8) 0x50};

void
web_pfile_format_properties_init (void)
{
	WebPFileFormatProperties* _tmp0_;
	_tmp0_ = web_pfile_format_properties_new ();
	_photo_file_format_properties_unref0 (web_pfile_format_properties_instance);
	web_pfile_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

WebPFileFormatProperties*
web_pfile_format_properties_get_instance (void)
{
	WebPFileFormatProperties* _tmp0_;
	WebPFileFormatProperties* _tmp1_;
	WebPFileFormatProperties* result;
	_tmp0_ = web_pfile_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
web_pfile_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	WebPFileFormatProperties * self;
	PhotoFileFormat result;
	self = (WebPFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_WEBP;
	return result;
}

static PhotoFileFormatFlags
web_pfile_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	WebPFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = (WebPFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
web_pfile_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	WebPFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (WebPFileFormatProperties*) base;
	_tmp0_ = g_strdup (_ ("WebP"));
	result = _tmp0_;
	return result;
}

static gchar*
web_pfile_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	WebPFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (WebPFileFormatProperties*) base;
	_tmp0_ = web_pfile_format_properties_known_extensions;
	_tmp0__length1 = web_pfile_format_properties_known_extensions_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup24 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
web_pfile_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                       gint* result_length1)
{
	WebPFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (WebPFileFormatProperties*) base;
	_tmp0_ = web_pfile_format_properties_known_extensions;
	_tmp0__length1 = web_pfile_format_properties_known_extensions_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup24 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
web_pfile_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	WebPFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (WebPFileFormatProperties*) base;
	_tmp0_ = web_pfile_format_properties_known_mime_types;
	_tmp0__length1 = web_pfile_format_properties_known_mime_types_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup25 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
web_pfile_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                 gint* result_length1)
{
	WebPFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (WebPFileFormatProperties*) base;
	_tmp0_ = web_pfile_format_properties_known_mime_types;
	_tmp0__length1 = web_pfile_format_properties_known_mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup25 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

WebPFileFormatProperties*
web_pfile_format_properties_construct (GType object_type)
{
	WebPFileFormatProperties* self = NULL;
	self = (WebPFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

WebPFileFormatProperties*
web_pfile_format_properties_new (void)
{
	return web_pfile_format_properties_construct (TYPE_WEB_PFILE_FORMAT_PROPERTIES);
}

static void
web_pfile_format_properties_class_init (WebPFileFormatPropertiesClass * klass,
                                        gpointer klass_data)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	web_pfile_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = web_pfile_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) web_pfile_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) web_pfile_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) web_pfile_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) web_pfile_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) web_pfile_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) web_pfile_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) web_pfile_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("webp");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	web_pfile_format_properties_known_extensions = _tmp1_;
	web_pfile_format_properties_known_extensions_length1 = 1;
	_web_pfile_format_properties_known_extensions_size_ = web_pfile_format_properties_known_extensions_length1;
	_tmp2_ = g_strdup ("image/webp");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	web_pfile_format_properties_known_mime_types = _tmp3_;
	web_pfile_format_properties_known_mime_types_length1 = 1;
	_web_pfile_format_properties_known_mime_types_size_ = web_pfile_format_properties_known_mime_types_length1;
}

static void
web_pfile_format_properties_instance_init (WebPFileFormatProperties * self,
                                           gpointer klass)
{
}

static void
web_pfile_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	WebPFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WEB_PFILE_FORMAT_PROPERTIES, WebPFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (web_pfile_format_properties_parent_class)->finalize (obj);
}

static GType
web_pfile_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WebPFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) web_pfile_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WebPFileFormatProperties), 0, (GInstanceInitFunc) web_pfile_format_properties_instance_init, NULL };
	GType web_pfile_format_properties_type_id;
	web_pfile_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "WebPFileFormatProperties", &g_define_type_info, 0);
	return web_pfile_format_properties_type_id;
}

GType
web_pfile_format_properties_get_type (void)
{
	static volatile gsize web_pfile_format_properties_type_id__once = 0;
	if (g_once_init_enter (&web_pfile_format_properties_type_id__once)) {
		GType web_pfile_format_properties_type_id;
		web_pfile_format_properties_type_id = web_pfile_format_properties_get_type_once ();
		g_once_init_leave (&web_pfile_format_properties_type_id__once, web_pfile_format_properties_type_id);
	}
	return web_pfile_format_properties_type_id__once;
}

WebPSniffer*
web_psniffer_construct (GType object_type,
                        GFile* file,
                        PhotoFileSnifferOptions options)
{
	WebPSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (WebPSniffer*) photo_file_sniffer_construct (object_type, file, options);
	return self;
}

WebPSniffer*
web_psniffer_new (GFile* file,
                  PhotoFileSnifferOptions options)
{
	return web_psniffer_construct (TYPE_WEB_PSNIFFER, file, options);
}

static gboolean
web_psniffer_is_webp_file (GFile* file,
                           GError** error)
{
	GFileInputStream* instream = NULL;
	GFileInputStream* _tmp0_;
	guint8* file_lead_sequence = NULL;
	guint8* _tmp2_;
	gint file_lead_sequence_length1;
	gint _file_lead_sequence_size_;
	GFileInputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GFileInputStream* _tmp11_;
	guint8* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp15_;
	GFileInputStream* _tmp16_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	instream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = g_new0 (guint8, G_N_ELEMENTS (WEB_PSNIFFER_MAGIC_SEQUENCE_RIFF));
	file_lead_sequence = _tmp2_;
	file_lead_sequence_length1 = G_N_ELEMENTS (WEB_PSNIFFER_MAGIC_SEQUENCE_RIFF);
	_file_lead_sequence_size_ = file_lead_sequence_length1;
	_tmp3_ = instream;
	_tmp4_ = file_lead_sequence;
	_tmp4__length1 = file_lead_sequence_length1;
	g_input_stream_read ((GInputStream*) _tmp3_, _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp5_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8 _tmp9_;
				guint8 _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < G_N_ELEMENTS (WEB_PSNIFFER_MAGIC_SEQUENCE_RIFF))) {
					break;
				}
				_tmp8_ = file_lead_sequence;
				_tmp8__length1 = file_lead_sequence_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = WEB_PSNIFFER_MAGIC_SEQUENCE_RIFF[i];
				if (_tmp9_ != _tmp10_) {
					result = FALSE;
					file_lead_sequence = (g_free (file_lead_sequence), NULL);
					_g_object_unref0 (instream);
					return result;
				}
			}
		}
	}
	_tmp11_ = instream;
	_tmp12_ = g_new0 (guint8, 4);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 4;
	g_input_stream_read ((GInputStream*) _tmp11_, _tmp13_, (gsize) 4, NULL, &_inner_error0_);
	_tmp13_ = (g_free (_tmp13_), NULL);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp14_;
	}
	_tmp15_ = g_new0 (guint8, G_N_ELEMENTS (WEB_PSNIFFER_MAGIC_SEQUENCE_WEBP));
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
	file_lead_sequence = _tmp15_;
	file_lead_sequence_length1 = G_N_ELEMENTS (WEB_PSNIFFER_MAGIC_SEQUENCE_WEBP);
	_file_lead_sequence_size_ = file_lead_sequence_length1;
	_tmp16_ = instream;
	_tmp17_ = file_lead_sequence;
	_tmp17__length1 = file_lead_sequence_length1;
	g_input_stream_read ((GInputStream*) _tmp16_, _tmp17_, (gsize) _tmp17__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp18_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				guint8* _tmp21_;
				gint _tmp21__length1;
				guint8 _tmp22_;
				guint8 _tmp23_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(i < G_N_ELEMENTS (WEB_PSNIFFER_MAGIC_SEQUENCE_WEBP))) {
					break;
				}
				_tmp21_ = file_lead_sequence;
				_tmp21__length1 = file_lead_sequence_length1;
				_tmp22_ = _tmp21_[i];
				_tmp23_ = WEB_PSNIFFER_MAGIC_SEQUENCE_WEBP[i];
				if (_tmp22_ != _tmp23_) {
					result = FALSE;
					file_lead_sequence = (g_free (file_lead_sequence), NULL);
					_g_object_unref0 (instream);
					return result;
				}
			}
		}
	}
	result = TRUE;
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
	_g_object_unref0 (instream);
	return result;
}

static gchar*
web_p_status_code_to_string (VP8StatusCode self)
{
	gchar** strv = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint strv_length1;
	gint _strv_size_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	_tmp0_ = g_strdup ("VP8_STATUS_OK");
	_tmp1_ = g_strdup ("VP8_STATUS_OUT_OF_MEMORY");
	_tmp2_ = g_strdup ("VP8_STATUS_INVALID_PARAM");
	_tmp3_ = g_strdup ("VP8_STATUS_BITSTREAM_ERROR");
	_tmp4_ = g_strdup ("VP8_STATUS_UNSUPPORTED_FEATURE");
	_tmp5_ = g_strdup ("VP8_STATUS_SUSPENDED");
	_tmp6_ = g_strdup ("VP8_STATUS_USER_ABORT");
	_tmp7_ = g_strdup ("VP8_STATUS_NOT_ENOUGH_DATA");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	strv = _tmp8_;
	strv_length1 = 8;
	_strv_size_ = strv_length1;
	_tmp9_ = strv[(gint) self];
	_tmp10_ = g_strdup (_tmp9_);
	result = _tmp10_;
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static DetectedPhotoInformation*
web_psniffer_real_sniff (PhotoFileSniffer* base,
                         GError** error)
{
	WebPSniffer * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp2_;
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp3_;
	guint8* _tmp4_ = NULL;
	gsize _tmp5_ = 0;
	WebPBitstreamFeatures features = {0};
	VP8StatusCode status = 0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	WebPBitstreamFeatures _tmp7_ = {0};
	VP8StatusCode _tmp8_;
	DetectedPhotoInformation* _tmp14_;
	WebPBitstreamFeatures _tmp15_;
	WebPBitstreamFeatures _tmp16_;
	DetectedPhotoInformation* _tmp17_;
	gint _tmp18_ = 0;
	WebPBitstreamFeatures _tmp19_;
	DetectedPhotoInformation* _tmp20_;
	DetectedPhotoInformation* _tmp26_;
	gchar* _tmp27_;
	DetectedPhotoInformation* _tmp28_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (WebPSniffer*) base;
	_tmp1_ = ((PhotoFileSniffer*) self)->file;
	_tmp0_ = web_psniffer_is_webp_file (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = detected_photo_information_new ();
	detected = _tmp2_;
	_tmp3_ = ((PhotoFileSniffer*) self)->file;
	g_file_load_contents (_tmp3_, NULL, &_tmp4_, &_tmp5_, NULL, &_inner_error0_);
	contents = (g_free (contents), NULL);
	contents = _tmp4_;
	contents_length1 = _tmp5_;
	_contents_size_ = contents_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		contents = (g_free (contents), NULL);
		_detected_photo_information_unref0 (detected);
		return NULL;
	}
	_tmp6_ = contents;
	_tmp6__length1 = contents_length1;
	_tmp8_ = WebPGetFeatures (_tmp6_, (gint) _tmp6__length1, &_tmp7_);
	features = _tmp7_;
	status = _tmp8_;
	if (status != VP8_STATUS_OK) {
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = ((PhotoFileSniffer*) self)->file;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = web_p_status_code_to_string (status);
		_tmp13_ = _tmp12_;
		g_warning ("WebPSupport.vala:113: Error opening WebP file %s: %s", _tmp11_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		result = NULL;
		contents = (g_free (contents), NULL);
		_detected_photo_information_unref0 (detected);
		return result;
	}
	_tmp14_ = detected;
	_tmp15_ = features;
	_tmp16_ = features;
	dimensions_init (&_tmp14_->image_dim, _tmp15_.width, _tmp16_.height);
	_tmp17_ = detected;
	_tmp17_->bits_per_channel = 8;
	_tmp19_ = features;
	if (_tmp19_.has_alpha) {
		_tmp18_ = 4;
	} else {
		_tmp18_ = 3;
	}
	_tmp20_ = detected;
	_tmp20_->channels = _tmp18_;
	if (((PhotoFileSniffer*) self)->calc_md5) {
		gchar* _tmp21_ = NULL;
		GFile* _tmp22_;
		gchar* _tmp23_;
		DetectedPhotoInformation* _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = ((PhotoFileSniffer*) self)->file;
		_tmp23_ = md5_file (_tmp22_, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			contents = (g_free (contents), NULL);
			_detected_photo_information_unref0 (detected);
			return NULL;
		}
		_tmp24_ = detected;
		_tmp25_ = _tmp21_;
		_tmp21_ = NULL;
		_g_free0 (_tmp24_->md5);
		_tmp24_->md5 = _tmp25_;
		_g_free0 (_tmp21_);
	}
	_tmp26_ = detected;
	_tmp27_ = g_strdup ("webp");
	_g_free0 (_tmp26_->format_name);
	_tmp26_->format_name = _tmp27_;
	_tmp28_ = detected;
	_tmp28_->file_format = PHOTO_FILE_FORMAT_WEBP;
	result = detected;
	contents = (g_free (contents), NULL);
	return result;
}

static void
web_psniffer_class_init (WebPSnifferClass * klass,
                         gpointer klass_data)
{
	web_psniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) web_psniffer_real_sniff;
}

static void
web_psniffer_instance_init (WebPSniffer * self,
                            gpointer klass)
{
}

static GType
web_psniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WebPSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) web_psniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WebPSniffer), 0, (GInstanceInitFunc) web_psniffer_instance_init, NULL };
	GType web_psniffer_type_id;
	web_psniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "WebPSniffer", &g_define_type_info, 0);
	return web_psniffer_type_id;
}

GType
web_psniffer_get_type (void)
{
	static volatile gsize web_psniffer_type_id__once = 0;
	if (g_once_init_enter (&web_psniffer_type_id__once)) {
		GType web_psniffer_type_id;
		web_psniffer_type_id = web_psniffer_get_type_once ();
		g_once_init_leave (&web_psniffer_type_id__once, web_psniffer_type_id);
	}
	return web_psniffer_type_id__once;
}

WebPReader*
web_preader_construct (GType object_type,
                       const gchar* filepath)
{
	WebPReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (WebPReader*) photo_file_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_WEBP);
	return self;
}

WebPReader*
web_preader_new (const gchar* filepath)
{
	return web_preader_construct (TYPE_WEB_PREADER, filepath);
}

static GdkPixbuf*
web_preader_real_scaled_read (PhotoFileReader* base,
                              Dimensions* full,
                              Dimensions* scaled,
                              GError** error)
{
	WebPReader * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	Dimensions _tmp2_;
	Dimensions _tmp3_;
	GdkPixbuf* _tmp4_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (WebPReader*) base;
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_tmp1_ = photo_file_reader_unscaled_read ((PhotoFileReader*) self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = *scaled;
	_tmp3_ = *scaled;
	_tmp4_ = gdk_pixbuf_scale_simple (_tmp0_, _tmp2_.width, _tmp3_.height, GDK_INTERP_BILINEAR);
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GdkPixbuf*
web_preader_real_unscaled_read (PhotoFileReader* base,
                                GError** error)
{
	WebPReader * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp1_;
	guint8* _tmp2_ = NULL;
	gsize _tmp3_ = 0;
	WebPBitstreamFeatures features = {0};
	VP8StatusCode status = 0;
	guint8* _tmp4_;
	gint _tmp4__length1;
	WebPBitstreamFeatures _tmp5_ = {0};
	VP8StatusCode _tmp6_;
	guint8* webp_data = NULL;
	gint webp_data_length1 = 0;
	gint _webp_data_size_ = 0;
	gint width = 0;
	gint height = 0;
	WebPBitstreamFeatures _tmp14_;
	gint _tmp23_ = 0;
	WebPBitstreamFeatures _tmp24_;
	gint rowstride = 0;
	GdkPixbuf* _result_ = NULL;
	guint8* _tmp25_;
	gint _tmp25__length1;
	WebPBitstreamFeatures _tmp26_;
	GdkPixbuf* _tmp27_;
	guint8* png_data = NULL;
	gint png_data_length1 = 0;
	gint _png_data_size_ = 0;
	GdkPixbuf* _tmp28_;
	guint8* _tmp29_ = NULL;
	gsize _tmp30_ = 0;
	GdkPixbufLoader* loader = NULL;
	GdkPixbufLoader* _tmp31_;
	GdkPixbufLoader* _tmp32_;
	guint8* _tmp33_;
	gint _tmp33__length1;
	GdkPixbufLoader* _tmp34_;
	GdkPixbuf* _tmp35_;
	GdkPixbuf* _tmp36_;
	GdkPixbufLoader* _tmp37_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (WebPReader*) base;
	_tmp0_ = photo_file_adapter_get_file ((PhotoFileAdapter*) self);
	file = _tmp0_;
	_tmp1_ = file;
	g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error0_);
	contents = (g_free (contents), NULL);
	contents = _tmp2_;
	contents_length1 = _tmp3_;
	_contents_size_ = contents_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp4_ = contents;
	_tmp4__length1 = contents_length1;
	_tmp6_ = WebPGetFeatures (_tmp4_, (gint) _tmp4__length1, &_tmp5_);
	features = _tmp5_;
	status = _tmp6_;
	if (status != VP8_STATUS_OK) {
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp7_ = file;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = web_p_status_code_to_string (status);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Error opening WebP file %s: %s", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp14_ = features;
	if (_tmp14_.has_alpha) {
		guint8* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		guint8* _tmp18_;
		_tmp15_ = contents;
		_tmp15__length1 = contents_length1;
		_tmp18_ = WebPDecodeRGBA (_tmp15_, (gint) _tmp15__length1, &_tmp16_, &_tmp17_);
		width = _tmp16_;
		height = _tmp17_;
		webp_data = (g_free (webp_data), NULL);
		webp_data = _tmp18_;
		webp_data_length1 = -1;
		_webp_data_size_ = webp_data_length1;
	} else {
		guint8* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		guint8* _tmp22_;
		_tmp19_ = contents;
		_tmp19__length1 = contents_length1;
		_tmp22_ = WebPDecodeRGB (_tmp19_, (gint) _tmp19__length1, &_tmp20_, &_tmp21_);
		width = _tmp20_;
		height = _tmp21_;
		webp_data = (g_free (webp_data), NULL);
		webp_data = _tmp22_;
		webp_data_length1 = -1;
		_webp_data_size_ = webp_data_length1;
	}
	_tmp24_ = features;
	if (_tmp24_.has_alpha) {
		_tmp23_ = 4;
	} else {
		_tmp23_ = 3;
	}
	rowstride = _tmp23_ * width;
	_tmp25_ = webp_data;
	_tmp25__length1 = webp_data_length1;
	_tmp26_ = features;
	_tmp27_ = gdk_pixbuf_new_from_data (_tmp25_, GDK_COLORSPACE_RGB, _tmp26_.has_alpha, 8, width, height, rowstride, (GdkPixbufDestroyNotify) NULL, NULL);
	_result_ = _tmp27_;
	_tmp28_ = _result_;
	gdk_pixbuf_save_to_buffer (_tmp28_, &_tmp29_, &_tmp30_, "png", &_inner_error0_, NULL);
	png_data = (g_free (png_data), NULL);
	png_data = _tmp29_;
	png_data_length1 = _tmp30_;
	_png_data_size_ = png_data_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		png_data = (g_free (png_data), NULL);
		_g_object_unref0 (_result_);
		webp_data = (g_free (webp_data), NULL);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp31_ = gdk_pixbuf_loader_new ();
	loader = _tmp31_;
	_tmp32_ = loader;
	_tmp33_ = png_data;
	_tmp33__length1 = png_data_length1;
	gdk_pixbuf_loader_write (_tmp32_, _tmp33_, (gsize) _tmp33__length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (loader);
		png_data = (g_free (png_data), NULL);
		_g_object_unref0 (_result_);
		webp_data = (g_free (webp_data), NULL);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp34_ = loader;
	_tmp35_ = gdk_pixbuf_loader_get_pixbuf (_tmp34_);
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (_result_);
	_result_ = _tmp36_;
	_tmp37_ = loader;
	gdk_pixbuf_loader_close (_tmp37_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (loader);
		png_data = (g_free (png_data), NULL);
		_g_object_unref0 (_result_);
		webp_data = (g_free (webp_data), NULL);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (file);
		return NULL;
	}
	result = _result_;
	_g_object_unref0 (loader);
	png_data = (g_free (png_data), NULL);
	webp_data = (g_free (webp_data), NULL);
	contents = (g_free (contents), NULL);
	_g_object_unref0 (file);
	return result;
}

static PhotoMetadata*
web_preader_real_read_metadata (PhotoFileReader* base,
                                GError** error)
{
	WebPReader * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (WebPReader*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

static void
web_preader_class_init (WebPReaderClass * klass,
                        gpointer klass_data)
{
	web_preader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) web_preader_real_scaled_read;
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader*, GError**)) web_preader_real_unscaled_read;
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader*, GError**)) web_preader_real_read_metadata;
}

static void
web_preader_instance_init (WebPReader * self,
                           gpointer klass)
{
}

static GType
web_preader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WebPReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) web_preader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WebPReader), 0, (GInstanceInitFunc) web_preader_instance_init, NULL };
	GType web_preader_type_id;
	web_preader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "WebPReader", &g_define_type_info, 0);
	return web_preader_type_id;
}

GType
web_preader_get_type (void)
{
	static volatile gsize web_preader_type_id__once = 0;
	if (g_once_init_enter (&web_preader_type_id__once)) {
		GType web_preader_type_id;
		web_preader_type_id = web_preader_get_type_once ();
		g_once_init_leave (&web_preader_type_id__once, web_preader_type_id);
	}
	return web_preader_type_id__once;
}

void
web_pfile_format_driver_init (void)
{
	WebPFileFormatDriver* _tmp0_;
	_tmp0_ = web_pfile_format_driver_new ();
	_photo_file_format_driver_unref0 (web_pfile_format_driver_instance);
	web_pfile_format_driver_instance = _tmp0_;
	web_pfile_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

WebPFileFormatDriver*
web_pfile_format_driver_get_instance (void)
{
	WebPFileFormatDriver* _tmp0_;
	WebPFileFormatDriver* _tmp1_;
	WebPFileFormatDriver* result;
	_tmp0_ = web_pfile_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
web_pfile_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	WebPFileFormatDriver * self;
	WebPFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = (WebPFileFormatDriver*) base;
	_tmp0_ = web_pfile_format_properties_get_instance ();
	result = (PhotoFileFormatProperties*) _tmp0_;
	return result;
}

static PhotoFileReader*
web_pfile_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                            const gchar* filepath)
{
	WebPFileFormatDriver * self;
	WebPReader* _tmp0_;
	PhotoFileReader* result;
	self = (WebPFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = web_preader_new (filepath);
	result = (PhotoFileReader*) _tmp0_;
	return result;
}

static gboolean
web_pfile_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	WebPFileFormatDriver * self;
	gboolean result;
	self = (WebPFileFormatDriver*) base;
	result = FALSE;
	return result;
}

static gboolean
web_pfile_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	WebPFileFormatDriver * self;
	gboolean result;
	self = (WebPFileFormatDriver*) base;
	result = FALSE;
	return result;
}

static PhotoFileWriter*
web_pfile_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                            const gchar* filepath)
{
	WebPFileFormatDriver * self;
	PhotoFileWriter* result;
	self = (WebPFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileMetadataWriter*
web_pfile_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                     const gchar* filepath)
{
	WebPFileFormatDriver * self;
	PhotoFileMetadataWriter* result;
	self = (WebPFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileSniffer*
web_pfile_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                             GFile* file,
                                             PhotoFileSnifferOptions options)
{
	WebPFileFormatDriver * self;
	WebPSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = (WebPFileFormatDriver*) base;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = web_psniffer_new (file, options);
	result = (PhotoFileSniffer*) _tmp0_;
	return result;
}

static PhotoMetadata*
web_pfile_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	WebPFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (WebPFileFormatDriver*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

WebPFileFormatDriver*
web_pfile_format_driver_construct (GType object_type)
{
	WebPFileFormatDriver* self = NULL;
	self = (WebPFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

WebPFileFormatDriver*
web_pfile_format_driver_new (void)
{
	return web_pfile_format_driver_construct (TYPE_WEB_PFILE_FORMAT_DRIVER);
}

static void
web_pfile_format_driver_class_init (WebPFileFormatDriverClass * klass,
                                    gpointer klass_data)
{
	web_pfile_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = web_pfile_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) web_pfile_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) web_pfile_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) web_pfile_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) web_pfile_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) web_pfile_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) web_pfile_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) web_pfile_format_driver_real_create_sniffer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) web_pfile_format_driver_real_create_metadata;
}

static void
web_pfile_format_driver_instance_init (WebPFileFormatDriver * self,
                                       gpointer klass)
{
}

static void
web_pfile_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	WebPFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WEB_PFILE_FORMAT_DRIVER, WebPFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (web_pfile_format_driver_parent_class)->finalize (obj);
}

static GType
web_pfile_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WebPFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) web_pfile_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WebPFileFormatDriver), 0, (GInstanceInitFunc) web_pfile_format_driver_instance_init, NULL };
	GType web_pfile_format_driver_type_id;
	web_pfile_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "WebPFileFormatDriver", &g_define_type_info, 0);
	return web_pfile_format_driver_type_id;
}

GType
web_pfile_format_driver_get_type (void)
{
	static volatile gsize web_pfile_format_driver_type_id__once = 0;
	if (g_once_init_enter (&web_pfile_format_driver_type_id__once)) {
		GType web_pfile_format_driver_type_id;
		web_pfile_format_driver_type_id = web_pfile_format_driver_get_type_once ();
		g_once_init_leave (&web_pfile_format_driver_type_id__once, web_pfile_format_driver_type_id);
	}
	return web_pfile_format_driver_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

