// python wrapper for vtkSMInteractionUndoStackBuilder
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMInteractionUndoStackBuilder.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMInteractionUndoStackBuilder(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMInteractionUndoStackBuilder_ClassNew(); }


static PyObject *
PyvtkSMInteractionUndoStackBuilder_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMInteractionUndoStackBuilder::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMInteractionUndoStackBuilder::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMInteractionUndoStackBuilder *tempr = vtkSMInteractionUndoStackBuilder::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMInteractionUndoStackBuilder *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMInteractionUndoStackBuilder::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMInteractionUndoStackBuilder::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMInteractionUndoStackBuilder::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_SetRenderView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  vtkSMRenderViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMRenderViewProxy"))
  {
    if (ap.IsBound())
    {
      op->SetRenderView(temp0);
    }
    else
    {
      op->vtkSMInteractionUndoStackBuilder::SetRenderView(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_GetRenderView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMRenderViewProxy *tempr = (ap.IsBound() ?
      op->GetRenderView() :
      op->vtkSMInteractionUndoStackBuilder::GetRenderView());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_GetUndoStack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUndoStack");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMUndoStack *tempr = (ap.IsBound() ?
      op->GetUndoStack() :
      op->vtkSMInteractionUndoStackBuilder::GetUndoStack());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_SetUndoStack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUndoStack");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  vtkSMUndoStack *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMUndoStack"))
  {
    if (ap.IsBound())
    {
      op->SetUndoStack(temp0);
    }
    else
    {
      op->vtkSMInteractionUndoStackBuilder::SetUndoStack(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Clear();
    }
    else
    {
      op->vtkSMInteractionUndoStackBuilder::Clear();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_StartInteraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartInteraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StartInteraction();
    }
    else
    {
      op->vtkSMInteractionUndoStackBuilder::StartInteraction();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMInteractionUndoStackBuilder_EndInteraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndInteraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInteractionUndoStackBuilder *op = static_cast<vtkSMInteractionUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EndInteraction();
    }
    else
    {
      op->vtkSMInteractionUndoStackBuilder::EndInteraction();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMInteractionUndoStackBuilder_Methods[] = {
  {"IsTypeOf", PyvtkSMInteractionUndoStackBuilder_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMInteractionUndoStackBuilder_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMInteractionUndoStackBuilder_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMInteractionUndoStackBuilder\nC++: static vtkSMInteractionUndoStackBuilder *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMInteractionUndoStackBuilder_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMInteractionUndoStackBuilder\nC++: vtkSMInteractionUndoStackBuilder *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMInteractionUndoStackBuilder_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMInteractionUndoStackBuilder_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetRenderView", PyvtkSMInteractionUndoStackBuilder_SetRenderView, METH_VARARGS,
   "SetRenderView(self, __a:vtkSMRenderViewProxy) -> None\nC++: void SetRenderView(vtkSMRenderViewProxy *)\n\nGet/Set the render view proxy for which we are monitoring the\ninteractions.\n"},
  {"GetRenderView", PyvtkSMInteractionUndoStackBuilder_GetRenderView, METH_VARARGS,
   "GetRenderView(self) -> vtkSMRenderViewProxy\nC++: virtual vtkSMRenderViewProxy *GetRenderView()\n\n"},
  {"GetUndoStack", PyvtkSMInteractionUndoStackBuilder_GetUndoStack, METH_VARARGS,
   "GetUndoStack(self) -> vtkSMUndoStack\nC++: virtual vtkSMUndoStack *GetUndoStack()\n\nGet/Set the undo stack that this builder will build.\n"},
  {"SetUndoStack", PyvtkSMInteractionUndoStackBuilder_SetUndoStack, METH_VARARGS,
   "SetUndoStack(self, __a:vtkSMUndoStack) -> None\nC++: virtual void SetUndoStack(vtkSMUndoStack *)\n\n"},
  {"Clear", PyvtkSMInteractionUndoStackBuilder_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\nClear the undo set currently being recorded.\n"},
  {"StartInteraction", PyvtkSMInteractionUndoStackBuilder_StartInteraction, METH_VARARGS,
   "StartInteraction(self) -> None\nC++: void StartInteraction()\n\nCalled to record the state at the beginning of an interaction.\nUsually, this method isn't called directly, since the builder\nlistens to interaction events on the interactor and calls it\nautomatically. May be used when changing the camera\nprogrammatically.\n"},
  {"EndInteraction", PyvtkSMInteractionUndoStackBuilder_EndInteraction, METH_VARARGS,
   "EndInteraction(self) -> None\nC++: void EndInteraction()\n\nCalled to record the state at the end of an interaction and push\nit on the stack. Usually, this method isn't called directly,\nsince the builder listens to interaction events on the interactor\nand calls it automatically. May be used when changing the camera\nprogrammatically.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMInteractionUndoStackBuilder_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("render_view"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMInteractionUndoStackBuilder_GetRenderView(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMInteractionUndoStackBuilder_SetRenderView(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMInteractionUndoStackBuilder_SetRenderView(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderView/SetRenderView\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("undo_stack"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMInteractionUndoStackBuilder_GetUndoStack(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMInteractionUndoStackBuilder_SetUndoStack(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMInteractionUndoStackBuilder_SetUndoStack(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUndoStack/SetUndoStack\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMInteractionUndoStackBuilder_Doc =
  "vtkSMInteractionUndoStackBuilder - builder server manager undo sets\nfor render view interactions and pushes them on the undo stack.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMInteractionUndoStackBuilder specializes in interaction. This\n"
  "class can create undo elements for only one render view at a time.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMInteractionUndoStackBuilder_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingMisc.vtkSMInteractionUndoStackBuilder", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMInteractionUndoStackBuilder_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMInteractionUndoStackBuilder_StaticNew()
{
  return vtkSMInteractionUndoStackBuilder::New();
}

PyObject *PyvtkSMInteractionUndoStackBuilder_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMInteractionUndoStackBuilder_Type, PyvtkSMInteractionUndoStackBuilder_Methods,
    "vtkSMInteractionUndoStackBuilder",
 &PyvtkSMInteractionUndoStackBuilder_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMInteractionUndoStackBuilder_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMInteractionUndoStackBuilder(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMInteractionUndoStackBuilder_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMInteractionUndoStackBuilder", o) != 0)
  {
    Py_DECREF(o);
  }

}

