#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkActorNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCameraNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLightNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPolyDataMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRendererNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkViewNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkViewNodeFactory_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWindowNode_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingSceneGraphCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkActorNode_Init(csi);
  vtkCameraNode_Init(csi);
  vtkLightNode_Init(csi);
  vtkMapperNode_Init(csi);
  vtkPolyDataMapperNode_Init(csi);
  vtkRendererNode_Init(csi);
  vtkViewNode_Init(csi);
  vtkViewNodeFactory_Init(csi);
  vtkVolumeMapperNode_Init(csi);
  vtkVolumeNode_Init(csi);
  vtkWindowNode_Init(csi);
}
