#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBivariateNoiseMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBivariateNoiseRepresentation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBivariateTextureRepresentation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkContext2DTexturedScalarBarActor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkContext2DTexturedScalarBarRepresentation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMBivariateTextureRepresentationProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLBivariateNoiseMapperDelegator_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkBivariateRepresentationsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBivariateNoiseMapper_Init(csi);
  vtkBivariateNoiseRepresentation_Init(csi);
  vtkBivariateTextureRepresentation_Init(csi);
  vtkContext2DTexturedScalarBarActor_Init(csi);
  vtkContext2DTexturedScalarBarRepresentation_Init(csi);
  vtkSMBivariateTextureRepresentationProxy_Init(csi);
  vtkOpenGLBivariateNoiseMapperDelegator_Init(csi);
}
