// ----------------------------------------------------------------------------
//
//  Copyright (C) 2012..2021 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __AMBPAN8_H
#define __AMBPAN8_H


class Ambpan8
{
public:

    enum { MAXDEGR = 8, MAXHARM = 81 };

    Ambpan8 (int fsamp, int degree, bool semi);
    virtual ~Ambpan8 (void);

    void set_direction (float az, float el, float dt);
    void process (int nframes, float *inp, float *out[], bool add = false);
    
private:

    void update (void);
    void encode (float azim, float elev, float *E);
    void encode4 (float azim, float elev, float *E);
    
    int              _fsamp;
    int              _degree;
    bool             _semi;
    float            _az;
    float            _el;
    float            _dt;
    float            _G [MAXHARM];
    float            _T [MAXHARM];
    volatile int     _touch0;
    volatile int     _touch1;
    int              _nipol;

    static float Cnorm [12];
    static float Csemi [12];
};


#endif
