/* Video.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Video.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gst/gst.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "metadata.h"
#include <gobject/gvaluecollector.h>

#define VIDEO_TYPENAME "video"
#define VIDEO_FLAG_TRASH ((guint64) 0x0000000000000001)
#define VIDEO_FLAG_OFFLINE ((guint64) 0x0000000000000002)
#define VIDEO_FLAG_FLAGGED ((guint64) 0x0000000000000004)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;
typedef struct _VideoSourcePrivate VideoSourcePrivate;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
typedef struct _VideoPrivate VideoPrivate;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
enum  {
	VIDEO_0_PROPERTY,
	VIDEO_NUM_PROPERTIES
};
static GParamSpec* video_properties[VIDEO_NUM_PROPERTIES];

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, gpointer user_data);

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_VIDEO_IMPORT_PARAMS (video_import_params_get_type ())
#define VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams))
#define VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))
#define IS_VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_PARAMS))
#define IS_VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_PARAMS))
#define VIDEO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))

typedef struct _VideoImportParams VideoImportParams;
typedef struct _VideoImportParamsClass VideoImportParamsClass;
typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

#define TYPE_IMPORT_RESULT (import_result_get_type ())
typedef struct _VideoImportParamsPrivate VideoImportParamsPrivate;

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 512,
	THUMBNAIL_CACHE_SIZE_LARGE = 512,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define VIDEO_TYPE_INTERPRETABLE_RESULTS (video_interpretable_results_get_type ())
#define VIDEO_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults))
#define VIDEO_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))
#define VIDEO_IS_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_IS_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_INTERPRETABLE_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))

typedef struct _VideoInterpretableResults VideoInterpretableResults;
typedef struct _VideoInterpretableResultsClass VideoInterpretableResultsClass;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_VIDEO_ERROR (video_error_get_type ())
typedef struct _VideoInterpretableResultsPrivate VideoInterpretableResultsPrivate;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _VideoParamSpecInterpretableResults VideoParamSpecInterpretableResults;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	GDateTime* (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, gint* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	GDateTime* (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _VideoSource {
	MediaSource parent_instance;
	VideoSourcePrivate * priv;
};

struct _VideoSourceClass {
	MediaSourceClass parent_class;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, GDateTime* target_time);
	GDateTime* (*get_exposure_time) (Dateable* self);
};

struct _Video {
	VideoSource parent_instance;
	VideoPrivate * priv;
};

struct _VideoClass {
	VideoSourceClass parent_class;
};

struct _VideoPrivate {
	VideoRow* backing_row;
	GRecMutex __lock_backing_row;
};

struct _VideoID {
	gint64 id;
};

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	gint64 time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	gint64 time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _VideoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoImportParamsPrivate * priv;
	GFile* file;
	ImportID import_id;
	gchar* md5;
	GDateTime* exposure_time_override;
	Thumbnails* thumbnails;
	VideoRow* row;
};

struct _VideoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoImportParams *self);
};

typedef enum  {
	VIDEO_ERROR_FILE,
	VIDEO_ERROR_CONTENTS
} VideoError;
#define VIDEO_ERROR video_error_quark ()

struct _VideoInterpretableResults {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoInterpretableResultsPrivate * priv;
	Video* video;
	gboolean update_interpretable;
	gboolean is_interpretable;
	GdkPixbuf* new_thumbnail;
};

struct _VideoInterpretableResultsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoInterpretableResults *self);
};

struct _VideoParamSpecInterpretableResults {
	GParamSpec parent_instance;
};

static gint Video_private_offset;
static gpointer video_parent_class = NULL;
static gboolean video_normal_regen_complete;
static gboolean video_normal_regen_complete = FALSE;
static gboolean video_offline_regen_complete;
static gboolean video_offline_regen_complete = FALSE;
VALA_EXTERN VideoSourceCollection* video_global;
VideoSourceCollection* video_global = NULL;
static gpointer video_interpretable_results_parent_class = NULL;
static FlaggableIface * video_flaggable_parent_iface = NULL;
static MonitorableIface * video_monitorable_parent_iface = NULL;
static DateableIface * video_dateable_parent_iface = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN gpointer backing_file_state_ref (gpointer instance);
VALA_EXTERN void backing_file_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_backing_file_state (const GValue* value);
VALA_EXTERN GType backing_file_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingFileState, backing_file_state_unref)
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN GType monitorable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitorable, g_object_unref)
VALA_EXTERN GType dateable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Dateable, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN gpointer video_row_ref (gpointer instance);
VALA_EXTERN void video_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_video_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_video_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_video_row (const GValue* value);
VALA_EXTERN GType video_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoRow, video_row_unref)
VALA_EXTERN void data_source_commit_backlinks (DataSource* self,
                                   SourceCollection* sources,
                                   const gchar* dehydrated);
VALA_EXTERN gboolean media_source_set_event_id (MediaSource* self,
                                    EventID* id);
VALA_EXTERN BackingFileState** media_source_get_backing_files_state (MediaSource* self,
                                                         gint* result_length1);
VALA_EXTERN GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
VALA_EXTERN gchar* media_source_get_master_md5 (MediaSource* self);
VALA_EXTERN GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self,
                                            Scaling* scaling,
                                            GError** error);
VALA_EXTERN GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self,
                                              gint scale,
                                              GError** error);
VALA_EXTERN gchar* data_source_get_typename (DataSource* self);
VALA_EXTERN gint64 data_source_get_instance_id (DataSource* self);
VALA_EXTERN void media_source_get_import_id (MediaSource* self,
                                 ImportID* result);
VALA_EXTERN PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
VALA_EXTERN gchar* media_source_get_title (MediaSource* self);
VALA_EXTERN void media_source_set_title (MediaSource* self,
                             const gchar* title);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN gboolean media_source_set_comment (MediaSource* self,
                                   const gchar* comment);
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
VALA_EXTERN void media_source_set_rating (MediaSource* self,
                              Rating rating);
VALA_EXTERN void media_source_increase_rating (MediaSource* self);
VALA_EXTERN void media_source_decrease_rating (MediaSource* self);
VALA_EXTERN gboolean media_source_is_trashed (MediaSource* self);
VALA_EXTERN gboolean media_source_is_offline (MediaSource* self);
VALA_EXTERN void media_source_mark_offline (MediaSource* self);
VALA_EXTERN void media_source_mark_online (MediaSource* self);
VALA_EXTERN void media_source_trash (MediaSource* self);
VALA_EXTERN void media_source_untrash (MediaSource* self);
VALA_EXTERN void media_source_get_event_id (MediaSource* self,
                                EventID* result);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN guint64 media_source_get_filesize (MediaSource* self);
VALA_EXTERN guint64 media_source_get_master_filesize (MediaSource* self);
VALA_EXTERN GDateTime* media_source_get_timestamp (MediaSource* self);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN void data_source_destroy (DataSource* self);
VALA_EXTERN gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType video_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSourceCollection, data_collection_unref)
VALA_EXTERN Video* video_new (VideoRow* row);
VALA_EXTERN Video* video_construct (GType object_type,
                        VideoRow* row);
VALA_EXTERN VideoSource* video_source_construct (GType object_type);
VALA_EXTERN gchar* media_source_prep_title (const gchar* title);
VALA_EXTERN GType video_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoID* video_id_dup (const VideoID* self);
VALA_EXTERN void video_id_free (VideoID* self);
VALA_EXTERN void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
VALA_EXTERN void video_init (ProgressMonitor monitor,
                 gpointer monitor_target);
static gboolean __lambda13_ (GstPluginFeature* f);
static gboolean ___lambda13__gst_plugin_feature_filter (GstPluginFeature* feature,
                                                 gpointer self);
VALA_EXTERN VideoSourceCollection* video_source_collection_new (void);
VALA_EXTERN VideoSourceCollection* video_source_collection_construct (GType object_type);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType video_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoTable, database_table_unref)
VALA_EXTERN VideoTable* video_table_get_instance (void);
VALA_EXTERN GeeArrayList* video_table_get_all (VideoTable* self);
VALA_EXTERN void media_source_collection_add_many_to_trash (MediaSourceCollection* self,
                                                GeeCollection* sources);
VALA_EXTERN void media_source_collection_add_many_to_offline (MediaSourceCollection* self,
                                                  GeeCollection* sources);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void video_notify_normal_thumbs_regenerated (void);
VALA_EXTERN void video_notify_offline_thumbs_regenerated (void);
VALA_EXTERN void video_terminate (void);
VALA_EXTERN GType exporter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exporter, g_object_unref)
VALA_EXTERN gpointer exporter_ui_ref (gpointer instance);
VALA_EXTERN void exporter_ui_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exporter_ui (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_exporter_ui (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_exporter_ui (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_exporter_ui (const GValue* value);
VALA_EXTERN GType exporter_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExporterUI, exporter_ui_unref)
VALA_EXTERN ExporterUI* video_export_many (GeeCollection* videos,
                               ExporterCompletionCallback done,
                               gpointer done_target,
                               gboolean export_in_place);
VALA_EXTERN void scaling_for_original (Scaling* result);
VALA_EXTERN GType export_format_parameters_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_free (ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_unmodified (ExportFormatParameters* result);
VALA_EXTERN Exporter* exporter_new_for_temp_file (GeeCollection* to_export,
                                      Scaling* scaling,
                                      ExportFormatParameters* export_params);
VALA_EXTERN Exporter* exporter_construct_for_temp_file (GType object_type,
                                            GeeCollection* to_export,
                                            Scaling* scaling,
                                            ExportFormatParameters* export_params);
VALA_EXTERN ExporterUI* exporter_ui_new (Exporter* exporter);
VALA_EXTERN ExporterUI* exporter_ui_construct (GType object_type,
                                   Exporter* exporter);
VALA_EXTERN void exporter_ui_export (ExporterUI* self,
                         ExporterCompletionCallback completion_callback,
                         gpointer completion_callback_target);
VALA_EXTERN GFile* export_ui_choose_file (const gchar* current_file_basename);
VALA_EXTERN gchar* media_source_get_basename (MediaSource* self);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void page_window_set_busy_cursor (PageWindow* self);
VALA_EXTERN void video_export (Video* self,
                   GFile* dest_file,
                   GError** error);
VALA_EXTERN void page_window_set_normal_cursor (PageWindow* self);
VALA_EXTERN GtkResponseType export_error_dialog (GFile* dest,
                                     gboolean photos_remaining);
VALA_EXTERN GFile* export_ui_choose_dir (const gchar* user_title);
VALA_EXTERN Exporter* exporter_new (GeeCollection* to_export,
                        GFile* dir,
                        Scaling* scaling,
                        ExportFormatParameters* export_params,
                        gboolean auto_replace_all);
VALA_EXTERN Exporter* exporter_construct (GType object_type,
                              GeeCollection* to_export,
                              GFile* dir,
                              Scaling* scaling,
                              ExportFormatParameters* export_params,
                              gboolean auto_replace_all);
static void video_real_commit_backlinks (DataSource* base,
                                  SourceCollection* sources,
                                  const gchar* backlinks);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void video_table_update_backlinks (VideoTable* self,
                                   VideoID* video_id,
                                   const gchar* backlinks,
                                   GError** error);
VALA_EXTERN void video_get_video_id (Video* self,
                         VideoID* result);
static gboolean video_real_set_event_id (MediaSource* base,
                                  EventID* event_id);
VALA_EXTERN gboolean video_table_set_event (VideoTable* self,
                                VideoID* video_id,
                                EventID* event_id);
VALA_EXTERN gboolean video_is_duplicate (GFile* file,
                             const gchar* full_md5);
VALA_EXTERN gboolean video_table_has_duplicate (VideoTable* self,
                                    GFile* file,
                                    const gchar* md5);
VALA_EXTERN gpointer video_import_params_ref (gpointer instance);
VALA_EXTERN void video_import_params_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_import_params (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_video_import_params (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_video_import_params (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_video_import_params (const GValue* value);
VALA_EXTERN GType video_import_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoImportParams, video_import_params_unref)
VALA_EXTERN GType import_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportResult video_import_create (VideoImportParams* params,
                                  Video** video);
VALA_EXTERN void video_table_add (VideoTable* self,
                      VideoRow* video_row,
                      VideoID* result,
                      GError** error);
VALA_EXTERN gpointer thumbnails_ref (gpointer instance);
VALA_EXTERN void thumbnails_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_thumbnails (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_thumbnails (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_thumbnails (const GValue* value);
VALA_EXTERN GType thumbnails_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Thumbnails, thumbnails_unref)
VALA_EXTERN gboolean video_id_is_invalid (VideoID *self);
VALA_EXTERN void video_import_failed (Video* video);
VALA_EXTERN void video_table_remove (VideoTable* self,
                         VideoID* videoID,
                         GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
static BackingFileState** video_real_get_backing_files_state (MediaSource* base,
                                                       gint* result_length1);
VALA_EXTERN BackingFileState* backing_file_state_new (const gchar* filepath,
                                          gint64 filesize,
                                          GDateTime* modification_time,
                                          const gchar* md5);
VALA_EXTERN BackingFileState* backing_file_state_construct (GType object_type,
                                                const gchar* filepath,
                                                gint64 filesize,
                                                GDateTime* modification_time,
                                                const gchar* md5);
static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base,
                                     gint scale,
                                     GError** error);
VALA_EXTERN GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source,
                                  gint scale,
                                  GError** error);
static gchar* video_real_get_master_md5 (MediaSource* base);
static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base,
                                          Scaling* scaling,
                                          GError** error);
VALA_EXTERN GType thumbnail_cache_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
VALA_EXTERN gpointer video_reader_ref (gpointer instance);
VALA_EXTERN void video_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_video_reader (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_video_reader (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_video_reader (const GValue* value);
VALA_EXTERN GType video_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoReader, video_reader_unref)
VALA_EXTERN VideoReader* video_reader_new (GFile* file);
VALA_EXTERN VideoReader* video_reader_construct (GType object_type,
                                     GFile* file);
VALA_EXTERN GdkPixbuf* video_reader_read_preview_frame (VideoReader* self);
VALA_EXTERN GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
static gchar* video_real_get_typename (DataSource* base);
static gint64 video_real_get_instance_id (DataSource* base);
static void video_real_get_import_id (MediaSource* base,
                               ImportID* result);
static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base);
VALA_EXTERN PhotoFileFormat photo_file_format_get_system_default_format (void);
static gchar* video_real_get_title (MediaSource* base);
static void video_real_set_title (MediaSource* base,
                           const gchar* title);
VALA_EXTERN void video_table_set_title (VideoTable* self,
                            VideoID* video_id,
                            const gchar* new_title,
                            GError** error);
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
VALA_EXTERN Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
static gchar* video_real_get_comment (MediaSource* base);
static gboolean video_real_set_comment (MediaSource* base,
                                 const gchar* comment);
VALA_EXTERN void video_table_set_comment (VideoTable* self,
                              VideoID* video_id,
                              const gchar* new_comment,
                              GError** error);
static Rating video_real_get_rating (MediaSource* base);
static void video_real_set_rating (MediaSource* base,
                            Rating rating);
VALA_EXTERN gboolean rating_is_valid (Rating self);
VALA_EXTERN void video_table_set_rating (VideoTable* self,
                             VideoID* video_id,
                             Rating rating,
                             GError** error);
static void video_real_increase_rating (MediaSource* base);
VALA_EXTERN Rating rating_increase (Rating self);
static void video_real_decrease_rating (MediaSource* base);
VALA_EXTERN Rating rating_decrease (Rating self);
static gboolean video_real_is_trashed (MediaSource* base);
VALA_EXTERN gboolean video_is_flag_set (Video* self,
                            guint64 flag);
static gboolean video_real_is_offline (Monitorable* base);
static void video_real_mark_offline (Monitorable* base);
VALA_EXTERN guint64 video_add_flags (Video* self,
                         guint64 flags_to_add,
                         Alteration* additional_alteration);
static void video_real_mark_online (Monitorable* base);
VALA_EXTERN guint64 video_remove_flags (Video* self,
                            guint64 flags_to_remove,
                            Alteration* additional_alteration);
VALA_EXTERN gboolean video_get_is_interpretable (Video* self);
VALA_EXTERN gpointer video_interpretable_results_ref (gpointer instance);
VALA_EXTERN void video_interpretable_results_unref (gpointer instance);
VALA_EXTERN GParamSpec* video_param_spec_interpretable_results (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void video_value_set_interpretable_results (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void video_value_take_interpretable_results (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer video_value_get_interpretable_results (const GValue* value);
VALA_EXTERN GType video_interpretable_results_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoInterpretableResults, video_interpretable_results_unref)
VALA_EXTERN VideoInterpretableResults* video_check_is_interpretable (Video* self);
VALA_EXTERN void video_interpretable_results_foreground_finish (VideoInterpretableResults* self);
static void video_real_trash (MediaSource* base);
static void video_real_untrash (MediaSource* base);
static gboolean video_real_is_flagged (Flaggable* base);
static void video_real_mark_flagged (Flaggable* base);
static void video_real_mark_unflagged (Flaggable* base);
static void video_real_get_event_id (MediaSource* base,
                              EventID* result);
static gchar* video_real_to_string (DataObject* base);
static GDateTime* video_real_get_exposure_time (Dateable* base);
static void video_real_set_exposure_time (Dateable* base,
                                   GDateTime* time);
VALA_EXTERN void video_table_set_exposure_time (VideoTable* self,
                                    VideoID* video_id,
                                    GDateTime* time,
                                    GError** error);
VALA_EXTERN void video_get_frame_dimensions (Video* self,
                                 Dimensions* result);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static void video_real_get_dimensions (MediaSource* base,
                                PhotoException disallowed_steps,
                                Dimensions* result);
static guint64 video_real_get_filesize (MediaSource* base);
static guint64 video_real_get_master_filesize (MediaSource* base);
static GDateTime* video_real_get_timestamp (MediaSource* base);
static void video_real_set_master_timestamp (Monitorable* base,
                                      GFileInfo* info);
VALA_EXTERN void video_table_set_timestamp (VideoTable* self,
                                VideoID* video_id,
                                GDateTime* timestamp,
                                GError** error);
VALA_EXTERN gchar* video_get_filename (Video* self);
static GFile* video_real_get_file (MediaSource* base);
static GFile* video_real_get_master_file (MediaSource* base);
VALA_EXTERN gdouble video_get_clip_duration (Video* self);
static void video_set_is_interpretable (Video* self,
                                 gboolean is_interpretable);
VALA_EXTERN void video_table_update_is_interpretable (VideoTable* self,
                                          VideoID* video_id,
                                          gboolean is_interpretable,
                                          GError** error);
VALA_EXTERN VideoInterpretableResults* video_interpretable_results_new (Video* video);
VALA_EXTERN VideoInterpretableResults* video_interpretable_results_construct (GType object_type,
                                                                  Video* video);
VALA_EXTERN GQuark video_error_quark (void);
VALA_EXTERN GType video_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gdouble video_reader_read_clip_duration (VideoReader* self,
                                         GError** error);
static void video_real_destroy (DataSource* base);
VALA_EXTERN void thumbnail_cache_remove (ThumbnailSource* source);
static gboolean video_real_internal_delete_backing (DataSource* base,
                                             GError** error);
VALA_EXTERN gboolean media_source_delete_original_file (MediaSource* self);
static void video_notify_flags_altered (Video* self,
                                 Alteration* additional_alteration);
VALA_EXTERN Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
VALA_EXTERN guint64 media_source_internal_add_flags (guint64 flags,
                                         guint64 selector);
VALA_EXTERN void video_table_set_flags (VideoTable* self,
                            VideoID* video_id,
                            guint64 flags,
                            GError** error);
VALA_EXTERN guint64 media_source_internal_remove_flags (guint64 flags,
                                            guint64 selector);
VALA_EXTERN gboolean media_source_internal_is_flag_set (guint64 flags,
                                            guint64 selector);
static void video_real_set_master_file (Monitorable* base,
                                 GFile* file);
VALA_EXTERN void video_table_set_filepath (VideoTable* self,
                               VideoID* video_id,
                               const gchar* filepath,
                               GError** error);
VALA_EXTERN void media_source_notify_master_replaced (MediaSource* self,
                                          GFile* old_file,
                                          GFile* new_file);
VALA_EXTERN Alteration* alteration_new_from_list (const gchar* list);
VALA_EXTERN Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
VALA_EXTERN GType video_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMetadata, media_metadata_unref)
VALA_EXTERN VideoMetadata* video_read_metadata (Video* self,
                                    GError** error);
VALA_EXTERN VideoMetadata* video_reader_read_metadata (VideoReader* self,
                                           GError** error);
VALA_EXTERN void thumbnail_cache_replace (ThumbnailSource* source,
                              ThumbnailCacheSize size,
                              GdkPixbuf* replacement,
                              GError** error);
VALA_EXTERN void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void video_interpretable_results_finalize (VideoInterpretableResults * obj);
static GType video_interpretable_results_get_type_once (void);
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_flagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_unflagged (Flaggable* self);
VALA_EXTERN gboolean monitorable_is_offline (Monitorable* self);
VALA_EXTERN void monitorable_mark_offline (Monitorable* self);
VALA_EXTERN void monitorable_mark_online (Monitorable* self);
VALA_EXTERN void monitorable_set_master_timestamp (Monitorable* self,
                                       GFileInfo* info);
VALA_EXTERN void monitorable_set_master_file (Monitorable* self,
                                  GFile* file);
VALA_EXTERN GDateTime* dateable_get_exposure_time (Dateable* self);
VALA_EXTERN void dateable_set_exposure_time (Dateable* self,
                                 GDateTime* target_time);
static void video_finalize (GObject * obj);
static GType video_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
video_get_instance_private (Video* self)
{
	return G_STRUCT_MEMBER_P (self, Video_private_offset);
}

static gpointer
_video_row_ref0 (gpointer self)
{
	return self ? video_row_ref (self) : NULL;
}

Video*
video_construct (GType object_type,
                 VideoRow* row)
{
	Video * self = NULL;
	VideoRow* _tmp0_;
	VideoRow* _tmp1_;
	VideoRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (IS_VIDEO_ROW (row), NULL);
	self = (Video*) video_source_construct (object_type);
	_tmp0_ = _video_row_ref0 (row);
	_video_row_unref0 (self->priv->backing_row);
	self->priv->backing_row = _tmp0_;
	_tmp1_ = self->priv->backing_row;
	_tmp2_ = self->priv->backing_row;
	_tmp3_ = _tmp2_->title;
	_tmp4_ = media_source_prep_title (_tmp3_);
	_g_free0 (_tmp1_->title);
	_tmp1_->title = _tmp4_;
	if ((row->flags & VIDEO_FLAG_TRASH) != ((guint64) 0)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = (row->flags & VIDEO_FLAG_OFFLINE) != ((guint64) 0);
	}
	if (_tmp5_) {
		VideoSourceCollection* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = video_global;
		_tmp7_ = row->backlinks;
		data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp7_);
	}
	return self;
}

Video*
video_new (VideoRow* row)
{
	return video_construct (TYPE_VIDEO, row);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda13_ (GstPluginFeature* f)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (f, gst_plugin_feature_get_type ()), FALSE);
	_tmp0_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (f, gst_object_get_type (), GstObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, "vaapi");
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
___lambda13__gst_plugin_feature_filter (GstPluginFeature* feature,
                                        gpointer self)
{
	gboolean result;
	result = __lambda13_ (feature);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
video_init (ProgressMonitor monitor,
            gpointer monitor_target)
{
	gchar** args = NULL;
	gint args_length1;
	gint _args_size_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp0_;
	GstRegistry* _tmp1_;
	GList* features = NULL;
	GstRegistry* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	VideoSourceCollection* _tmp11_;
	GeeArrayList* all = NULL;
	VideoTable* _tmp12_;
	VideoTable* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* all_videos = NULL;
	GeeArrayList* _tmp16_;
	GeeArrayList* trashed_videos = NULL;
	GeeArrayList* _tmp17_;
	GeeArrayList* offline_videos = NULL;
	GeeArrayList* _tmp18_;
	gint count = 0;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	VideoSourceCollection* _tmp37_;
	GeeArrayList* _tmp38_;
	VideoSourceCollection* _tmp39_;
	GeeArrayList* _tmp40_;
	VideoSourceCollection* _tmp41_;
	GeeArrayList* _tmp42_;
	GeeCollection* _tmp43_;
	GeeCollection* _tmp44_;
	video_normal_regen_complete = FALSE;
	video_offline_regen_complete = FALSE;
	args = NULL;
	args_length1 = 0;
	_args_size_ = args_length1;
	gst_init ((gint*) (&args_length1), &args);
	_args_size_ = args_length1;
	_tmp0_ = gst_registry_get ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	registry = _tmp1_;
	_tmp2_ = registry;
	_tmp3_ = gst_registry_feature_filter (_tmp2_, ___lambda13__gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp3_;
	_tmp4_ = features;
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp4_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp5_;
			GstPluginFeature* feature = NULL;
			_tmp5_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp5_;
			{
				GstPluginFeature* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GstRegistry* _tmp9_;
				GstPluginFeature* _tmp10_;
				_tmp6_ = feature;
				_tmp7_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject));
				_tmp8_ = _tmp7_;
				g_debug ("Video.vala:82: Removing registry feature %s", _tmp8_);
				_g_free0 (_tmp8_);
				_tmp9_ = registry;
				_tmp10_ = feature;
				gst_registry_remove_feature (_tmp9_, _tmp10_);
				_g_object_unref0 (feature);
			}
		}
	}
	_tmp11_ = video_source_collection_new ();
	_data_collection_unref0 (video_global);
	video_global = _tmp11_;
	_tmp12_ = video_table_get_instance ();
	_tmp13_ = _tmp12_;
	_tmp14_ = video_table_get_all (_tmp13_);
	_tmp15_ = _tmp14_;
	_database_table_unref0 (_tmp13_);
	all = _tmp15_;
	_tmp16_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_videos = _tmp16_;
	_tmp17_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	trashed_videos = _tmp17_;
	_tmp18_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	offline_videos = _tmp18_;
	_tmp19_ = all;
	_tmp20_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp21_ = _tmp20_;
	count = _tmp21_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				Video* video = NULL;
				GeeArrayList* _tmp24_;
				gpointer _tmp25_;
				VideoRow* _tmp26_;
				Video* _tmp27_;
				Video* _tmp28_;
				Video* _tmp29_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = ctr;
					ctr = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp24_ = all;
				_tmp25_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
				_tmp26_ = (VideoRow*) _tmp25_;
				_tmp27_ = video_new (_tmp26_);
				_tmp28_ = _tmp27_;
				_video_row_unref0 (_tmp26_);
				video = _tmp28_;
				_tmp29_ = video;
				if (media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_MEDIA_SOURCE, MediaSource))) {
					GeeArrayList* _tmp30_;
					Video* _tmp31_;
					_tmp30_ = trashed_videos;
					_tmp31_ = video;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp31_);
				} else {
					Video* _tmp32_;
					_tmp32_ = video;
					if (media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_MEDIA_SOURCE, MediaSource))) {
						GeeArrayList* _tmp33_;
						Video* _tmp34_;
						_tmp33_ = offline_videos;
						_tmp34_ = video;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp34_);
					} else {
						GeeArrayList* _tmp35_;
						Video* _tmp36_;
						_tmp35_ = all_videos;
						_tmp36_ = video;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp36_);
					}
				}
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (video);
			}
		}
	}
	_tmp37_ = video_global;
	_tmp38_ = trashed_videos;
	media_source_collection_add_many_to_trash (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp39_ = video_global;
	_tmp40_ = offline_videos;
	media_source_collection_add_many_to_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp41_ = video_global;
	_tmp42_ = all_videos;
	_tmp43_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
	_tmp44_ = _tmp43_;
	_g_object_unref0 (_tmp44_);
	_g_object_unref0 (offline_videos);
	_g_object_unref0 (trashed_videos);
	_g_object_unref0 (all_videos);
	_g_object_unref0 (all);
	(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
	_g_object_unref0 (registry);
}

void
video_notify_normal_thumbs_regenerated (void)
{
	if (video_normal_regen_complete) {
		return;
	}
	g_message ("Video.vala:116: normal video thumbnail regeneration completed");
	video_normal_regen_complete = TRUE;
}

void
video_notify_offline_thumbs_regenerated (void)
{
	if (video_offline_regen_complete) {
		return;
	}
	g_message ("Video.vala:125: offline video thumbnail regeneration completed");
	video_offline_regen_complete = TRUE;
}

void
video_terminate (void)
{
}

ExporterUI*
video_export_many (GeeCollection* videos,
                   ExporterCompletionCallback done,
                   gpointer done_target,
                   gboolean export_in_place)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp9_;
	gint _tmp10_;
	GFile* export_dir = NULL;
	GFile* _tmp32_;
	GFile* _tmp33_;
	ExporterUI* exporter = NULL;
	GFile* _tmp34_;
	Scaling _tmp35_ = {0};
	ExportFormatParameters _tmp36_ = {0};
	Exporter* _tmp37_;
	Exporter* _tmp38_;
	ExporterUI* _tmp39_;
	ExporterUI* _tmp40_;
	ExporterUI* _tmp41_;
	GError* _inner_error0_ = NULL;
	ExporterUI* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (videos, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gee_collection_get_size (videos);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	if (export_in_place) {
		ExporterUI* temp_exporter = NULL;
		Scaling _tmp2_ = {0};
		ExportFormatParameters _tmp3_ = {0};
		Exporter* _tmp4_;
		Exporter* _tmp5_;
		ExporterUI* _tmp6_;
		ExporterUI* _tmp7_;
		ExporterUI* _tmp8_;
		scaling_for_original (&_tmp2_);
		export_format_parameters_unmodified (&_tmp3_);
		_tmp4_ = exporter_new_for_temp_file (videos, &_tmp2_, &_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = exporter_ui_new (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		temp_exporter = _tmp7_;
		_tmp8_ = temp_exporter;
		exporter_ui_export (_tmp8_, done, done_target);
		result = temp_exporter;
		return result;
	}
	_tmp9_ = gee_collection_get_size (videos);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 1) {
		Video* video = NULL;
		GFile* save_as = NULL;
		Video* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		video = NULL;
		{
			GeeIterator* _v_it = NULL;
			GeeIterator* _tmp11_;
			_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (videos, GEE_TYPE_ITERABLE, GeeIterable));
			_v_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_;
				Video* v = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				Video* _tmp15_;
				Video* _tmp16_;
				_tmp12_ = _v_it;
				if (!gee_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = _v_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				v = (Video*) _tmp14_;
				_tmp15_ = v;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (video);
				video = _tmp16_;
				_g_object_unref0 (v);
				break;
			}
			_g_object_unref0 (_v_it);
		}
		_tmp17_ = video;
		_tmp18_ = media_source_get_basename (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp19_ = _tmp18_;
		_tmp20_ = export_ui_choose_file (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		save_as = _tmp21_;
		_tmp22_ = save_as;
		if (_tmp22_ == NULL) {
			result = NULL;
			_g_object_unref0 (save_as);
			_g_object_unref0 (video);
			return result;
		}
		{
			AppWindow* _tmp23_;
			AppWindow* _tmp24_;
			Video* _tmp25_;
			GFile* _tmp26_;
			AppWindow* _tmp27_;
			AppWindow* _tmp28_;
			_tmp23_ = app_window_get_instance ();
			_tmp24_ = _tmp23_;
			page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PAGE_WINDOW, PageWindow));
			_g_object_unref0 (_tmp24_);
			_tmp25_ = video;
			_tmp26_ = save_as;
			video_export (_tmp25_, _tmp26_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp27_ = app_window_get_instance ();
			_tmp28_ = _tmp27_;
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_PAGE_WINDOW, PageWindow));
			_g_object_unref0 (_tmp28_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			AppWindow* _tmp29_;
			AppWindow* _tmp30_;
			GFile* _tmp31_;
			g_clear_error (&_inner_error0_);
			_tmp29_ = app_window_get_instance ();
			_tmp30_ = _tmp29_;
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PAGE_WINDOW, PageWindow));
			_g_object_unref0 (_tmp30_);
			_tmp31_ = save_as;
			export_error_dialog (_tmp31_, FALSE);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (save_as);
			_g_object_unref0 (video);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = NULL;
		_g_object_unref0 (save_as);
		_g_object_unref0 (video);
		return result;
	}
	_tmp32_ = export_ui_choose_dir (_ ("Export Videos"));
	export_dir = _tmp32_;
	_tmp33_ = export_dir;
	if (_tmp33_ == NULL) {
		result = NULL;
		_g_object_unref0 (export_dir);
		return result;
	}
	_tmp34_ = export_dir;
	scaling_for_original (&_tmp35_);
	export_format_parameters_unmodified (&_tmp36_);
	_tmp37_ = exporter_new (videos, _tmp34_, &_tmp35_, &_tmp36_, FALSE);
	_tmp38_ = _tmp37_;
	_tmp39_ = exporter_ui_new (_tmp38_);
	_tmp40_ = _tmp39_;
	_g_object_unref0 (_tmp38_);
	exporter = _tmp40_;
	_tmp41_ = exporter;
	exporter_ui_export (_tmp41_, done, done_target);
	result = exporter;
	_g_object_unref0 (export_dir);
	return result;
}

static void
video_real_commit_backlinks (DataSource* base,
                             SourceCollection* sources,
                             const gchar* backlinks)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
		_tmp0_ = video_table_get_instance ();
		_tmp1_ = _tmp0_;
		video_get_video_id (self, &_tmp2_);
		video_table_update_backlinks (_tmp1_, &_tmp2_, backlinks, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
			{
				VideoRow* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = self->priv->backing_row;
				_tmp5_ = g_strdup (backlinks);
				_g_free0 (_tmp4_->backlinks);
				_tmp4_->backlinks = _tmp5_;
			}
			__finally1:
			{
				VideoRow* _tmp6_;
				_tmp6_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp8_ = _tmp7_;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("Video.vala:189: Unable to update link state for %s: %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
video_real_set_event_id (MediaSource* base,
                         EventID* event_id)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	g_return_val_if_fail (event_id != NULL, FALSE);
	{
		VideoRow* _tmp0_;
		gboolean _tmp11_ = FALSE;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			gboolean committed = FALSE;
			VideoTable* _tmp1_;
			VideoTable* _tmp2_;
			VideoRow* _tmp3_;
			VideoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = video_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->priv->backing_row;
			_tmp4_ = _tmp3_->video_id;
			_tmp5_ = *event_id;
			_tmp6_ = video_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
			_database_table_unref0 (_tmp2_);
			committed = _tmp6_;
			if (committed) {
				VideoRow* _tmp7_;
				EventID _tmp8_;
				_tmp7_ = self->priv->backing_row;
				_tmp8_ = *event_id;
				_tmp7_->event_id = _tmp8_;
			}
			result = committed;
			{
				VideoRow* _tmp9_;
				_tmp9_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp10_;
			_tmp10_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
}

gboolean
video_is_duplicate (GFile* file,
                    const gchar* full_md5)
{
	gboolean _tmp0_ = FALSE;
	VideoTable* _tmp1_;
	VideoTable* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	if (file != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = full_md5 != NULL;
	}
	_vala_assert (_tmp0_, "file != null || full_md5 != null");
	_tmp1_ = video_table_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = video_table_has_duplicate (_tmp2_, file, full_md5);
	_database_table_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

ImportResult
video_import_create (VideoImportParams* params,
                     Video** video)
{
	Video* _vala_video = NULL;
	VideoRow* _tmp6_;
	Video* _tmp7_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
	_g_object_unref0 (_vala_video);
	_vala_video = NULL;
	{
		VideoID _tmp0_ = {0};
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoRow* _tmp3_;
		VideoID _tmp4_ = {0};
		VideoID _tmp5_;
		_tmp1_ = video_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = params->row;
		video_table_add (_tmp2_, _tmp3_, &_tmp4_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (_vala_video);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		if (video_id_is_invalid (&_tmp0_)) {
			result = IMPORT_RESULT_DATABASE_ERROR;
			if (video) {
				*video = _vala_video;
			} else {
				_g_object_unref0 (_vala_video);
			}
			return result;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		g_clear_error (&_inner_error0_);
		result = IMPORT_RESULT_DATABASE_ERROR;
		if (video) {
			*video = _vala_video;
		} else {
			_g_object_unref0 (_vala_video);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_vala_video);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp6_ = params->row;
	_tmp7_ = video_new (_tmp6_);
	_g_object_unref0 (_vala_video);
	_vala_video = _tmp7_;
	result = IMPORT_RESULT_SUCCESS;
	if (video) {
		*video = _vala_video;
	} else {
		_g_object_unref0 (_vala_video);
	}
	return result;
}

void
video_import_failed (Video* video)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO (video));
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
		_tmp0_ = video_table_get_instance ();
		_tmp1_ = _tmp0_;
		video_get_video_id (video, &_tmp2_);
		video_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static BackingFileState**
video_real_get_backing_files_state (MediaSource* base,
                                    gint* result_length1)
{
	Video * self;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_ = NULL;
	BackingFileState** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = g_new0 (BackingFileState*, 1 + 1);
	backing = _tmp0_;
	backing_length1 = 1;
	_backing_size_ = backing_length1;
	{
		VideoRow* _tmp1_;
		_tmp1_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			VideoRow* _tmp4_;
			VideoRow* _tmp5_;
			GDateTime* _tmp6_;
			VideoRow* _tmp7_;
			const gchar* _tmp8_;
			BackingFileState* _tmp9_;
			_tmp2_ = self->priv->backing_row;
			_tmp3_ = _tmp2_->filepath;
			_tmp4_ = self->priv->backing_row;
			_tmp5_ = self->priv->backing_row;
			_tmp6_ = _tmp5_->timestamp;
			_tmp7_ = self->priv->backing_row;
			_tmp8_ = _tmp7_->md5;
			_tmp9_ = backing_file_state_new (_tmp3_, _tmp4_->filesize, _tmp6_, _tmp8_);
			_backing_file_state_unref0 (backing[0]);
			backing[0] = _tmp9_;
		}
		__finally0:
		{
			VideoRow* _tmp10_;
			_tmp10_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = backing;
	_tmp11__length1 = backing_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}

static GdkPixbuf*
video_real_get_thumbnail (ThumbnailSource* base,
                          gint scale,
                          GError** error)
{
	Video * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp1_ = thumbnail_cache_fetch (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), scale, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gchar*
video_real_get_master_md5 (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->md5;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static GdkPixbuf*
video_real_get_preview_pixbuf (MediaSource* base,
                               Scaling* scaling,
                               GError** error)
{
	Video * self;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error0_);
	pixbuf = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_NEAREST, TRUE);
	result = _tmp1_;
	_g_object_unref0 (pixbuf);
	return result;
}

static GdkPixbuf*
video_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Video * self;
	VideoReader* reader = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	VideoReader* _tmp2_;
	VideoReader* _tmp3_;
	GdkPixbuf* frame = NULL;
	VideoReader* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = video_reader_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	reader = _tmp3_;
	_tmp4_ = reader;
	_tmp5_ = video_reader_read_preview_frame (_tmp4_);
	frame = _tmp5_;
	_tmp7_ = frame;
	if (_tmp7_ != NULL) {
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp8_ = frame;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = _tmp9_;
	} else {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_tmp10_ = resources_get_noninterpretable_badge_pixbuf ();
		_tmp11_ = _tmp10_;
		_tmp12_ = gdk_pixbuf_copy (_tmp11_);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
	}
	result = _tmp6_;
	_g_object_unref0 (frame);
	_video_reader_unref0 (reader);
	return result;
}

static gchar*
video_real_get_typename (DataSource* base)
{
	Video * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gint64
video_real_get_instance_id (DataSource* base)
{
	Video * self;
	VideoID _tmp0_ = {0};
	gint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_get_video_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static void
video_real_get_import_id (MediaSource* base,
                          ImportID* result)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			ImportID _tmp2_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->import_id;
			*result = _tmp2_;
			{
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static PhotoFileFormat
video_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Video * self;
	PhotoFileFormat result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	result = photo_file_format_get_system_default_format ();
	return result;
}

static gchar*
video_real_get_title (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->title;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
video_real_set_title (MediaSource* base,
                      const gchar* title)
{
	Video * self;
	gchar* new_title = NULL;
	gchar* _tmp0_;
	Alteration* _tmp18_;
	Alteration* _tmp19_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = media_source_prep_title (title);
	new_title = _tmp0_;
	{
		VideoRow* _tmp1_;
		_tmp1_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			VideoRow* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp2_ = self->priv->backing_row;
			_tmp3_ = _tmp2_->title;
			_tmp4_ = new_title;
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
				{
					VideoRow* _tmp5_;
					_tmp5_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_title);
				return;
			}
			{
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				const gchar* _tmp10_;
				_tmp6_ = video_table_get_instance ();
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->backing_row;
				_tmp9_ = _tmp8_->video_id;
				_tmp10_ = new_title;
				video_table_set_title (_tmp7_, &_tmp9_, _tmp10_, &_inner_error0_);
				_database_table_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp11_;
						_tmp11_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_free0 (new_title);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = e;
				app_window_database_error (_tmp12_);
				_g_error_free0 (e);
				{
					VideoRow* _tmp13_;
					_tmp13_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_title);
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (new_title);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp14_ = self->priv->backing_row;
			_tmp15_ = new_title;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (_tmp14_->title);
			_tmp14_->title = _tmp16_;
		}
		__finally0:
		{
			VideoRow* _tmp17_;
			_tmp17_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp18_ = alteration_new ("metadata", "name");
	_tmp19_ = _tmp18_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp19_);
	_alteration_unref0 (_tmp19_);
	_g_free0 (new_title);
}

static gchar*
video_real_get_comment (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->comment;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gboolean
video_real_set_comment (MediaSource* base,
                        const gchar* comment)
{
	Video * self;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	Alteration* _tmp21_;
	Alteration* _tmp22_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = media_source_prep_title (comment);
	new_comment = _tmp0_;
	{
		VideoRow* _tmp1_;
		_tmp1_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			VideoRow* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp2_ = self->priv->backing_row;
			_tmp3_ = _tmp2_->comment;
			_tmp4_ = new_comment;
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
				result = TRUE;
				{
					VideoRow* _tmp5_;
					_tmp5_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_comment);
				return result;
			}
			{
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				const gchar* _tmp10_;
				_tmp6_ = video_table_get_instance ();
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->backing_row;
				_tmp9_ = _tmp8_->video_id;
				_tmp10_ = new_comment;
				video_table_set_comment (_tmp7_, &_tmp9_, _tmp10_, &_inner_error0_);
				_database_table_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp12_ = FALSE;
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp11_;
						_tmp11_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_free0 (new_comment);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp12_;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp13_ = e;
				app_window_database_error (_tmp13_);
				result = FALSE;
				_g_error_free0 (e);
				{
					VideoRow* _tmp14_;
					_tmp14_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_comment);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp15_ = FALSE;
				_g_free0 (new_comment);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp15_;
			}
			_tmp16_ = self->priv->backing_row;
			_tmp17_ = new_comment;
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (_tmp16_->comment);
			_tmp16_->comment = _tmp18_;
		}
		__finally0:
		{
			VideoRow* _tmp19_;
			_tmp19_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			_g_free0 (new_comment);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp20_;
		}
	}
	_tmp21_ = alteration_new ("metadata", "comment");
	_tmp22_ = _tmp21_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp22_);
	_alteration_unref0 (_tmp22_);
	result = TRUE;
	_g_free0 (new_comment);
	return result;
}

static Rating
video_real_get_rating (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	Rating result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->rating;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static void
video_real_set_rating (MediaSource* base,
                       Rating rating)
{
	Video * self;
	Alteration* _tmp12_;
	Alteration* _tmp13_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			gboolean _tmp1_ = FALSE;
			VideoRow* _tmp10_;
			if (!rating_is_valid (rating)) {
				_tmp1_ = TRUE;
			} else {
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				_tmp1_ = rating == _tmp2_->rating;
			}
			if (_tmp1_) {
				{
					VideoRow* _tmp3_;
					_tmp3_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return;
			}
			{
				VideoTable* _tmp4_;
				VideoTable* _tmp5_;
				VideoID _tmp6_ = {0};
				_tmp4_ = video_table_get_instance ();
				_tmp5_ = _tmp4_;
				video_get_video_id (self, &_tmp6_);
				video_table_set_rating (_tmp5_, &_tmp6_, rating, &_inner_error0_);
				_database_table_unref0 (_tmp5_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp7_;
						_tmp7_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = e;
				app_window_database_error (_tmp8_);
				_g_error_free0 (e);
				{
					VideoRow* _tmp9_;
					_tmp9_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp10_ = self->priv->backing_row;
			_tmp10_->rating = rating;
		}
		__finally0:
		{
			VideoRow* _tmp11_;
			_tmp11_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = alteration_new ("metadata", "rating");
	_tmp13_ = _tmp12_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
	_alteration_unref0 (_tmp13_);
}

static void
video_real_increase_rating (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_increase (_tmp1_->rating));
		}
		__finally0:
		{
			VideoRow* _tmp2_;
			_tmp2_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
video_real_decrease_rating (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_decrease (_tmp1_->rating));
		}
		__finally0:
		{
			VideoRow* _tmp2_;
			_tmp2_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gboolean
video_real_is_trashed (MediaSource* base)
{
	Video * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	result = video_is_flag_set (self, VIDEO_FLAG_TRASH);
	return result;
}

static gboolean
video_real_is_offline (Monitorable* base)
{
	Video * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	result = video_is_flag_set (self, VIDEO_FLAG_OFFLINE);
	return result;
}

static void
video_real_mark_offline (Monitorable* base)
{
	Video * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_add_flags (self, VIDEO_FLAG_OFFLINE, NULL);
}

static void
video_real_mark_online (Monitorable* base)
{
	Video * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_remove_flags (self, VIDEO_FLAG_OFFLINE, NULL);
	if (!video_get_is_interpretable (self)) {
		VideoInterpretableResults* _tmp0_;
		VideoInterpretableResults* _tmp1_;
		_tmp0_ = video_check_is_interpretable (self);
		_tmp1_ = _tmp0_;
		video_interpretable_results_foreground_finish (_tmp1_);
		_video_interpretable_results_unref0 (_tmp1_);
	}
}

static void
video_real_trash (MediaSource* base)
{
	Video * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_add_flags (self, VIDEO_FLAG_TRASH, NULL);
}

static void
video_real_untrash (MediaSource* base)
{
	Video * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_remove_flags (self, VIDEO_FLAG_TRASH, NULL);
}

static gboolean
video_real_is_flagged (Flaggable* base)
{
	Video * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	result = video_is_flag_set (self, VIDEO_FLAG_FLAGGED);
	return result;
}

static void
video_real_mark_flagged (Flaggable* base)
{
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	video_add_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static void
video_real_mark_unflagged (Flaggable* base)
{
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	video_remove_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static void
video_real_get_event_id (MediaSource* base,
                         EventID* result)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			EventID _tmp2_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->event_id;
			*result = _tmp2_;
			{
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
video_real_to_string (DataObject* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			VideoRow* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->video_id;
			_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_.id);
			_tmp4_ = _tmp3_;
			_tmp5_ = self->priv->backing_row;
			_tmp6_ = _tmp5_->filepath;
			_tmp7_ = g_strdup_printf ("[%s] %s", _tmp4_, _tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp4_);
			result = _tmp8_;
			{
				VideoRow* _tmp9_;
				_tmp9_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp10_;
			_tmp10_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
video_get_video_id (Video* self,
                    VideoID* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO (self));
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->video_id;
			*result = _tmp2_;
			{
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static GDateTime*
video_real_get_exposure_time (Dateable* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			GDateTime* _tmp2_;
			GDateTime* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->exposure_time;
			_tmp3_ = _g_date_time_ref0 (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
video_real_set_exposure_time (Dateable* base,
                              GDateTime* time)
{
	Video * self;
	Alteration* _tmp10_;
	Alteration* _tmp11_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	g_return_if_fail (time != NULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp7_;
			GDateTime* _tmp8_;
			{
				VideoTable* _tmp1_;
				VideoTable* _tmp2_;
				VideoRow* _tmp3_;
				VideoID _tmp4_;
				_tmp1_ = video_table_get_instance ();
				_tmp2_ = _tmp1_;
				_tmp3_ = self->priv->backing_row;
				_tmp4_ = _tmp3_->video_id;
				video_table_set_exposure_time (_tmp2_, &_tmp4_, time, &_inner_error0_);
				_database_table_unref0 (_tmp2_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp5_;
				const gchar* _tmp6_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp5_ = e;
				_tmp6_ = _tmp5_->message;
				g_debug ("Video.vala:451: Warning - %s", _tmp6_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp7_ = self->priv->backing_row;
			_tmp8_ = _g_date_time_ref0 (time);
			_g_date_time_unref0 (_tmp7_->exposure_time);
			_tmp7_->exposure_time = _tmp8_;
		}
		__finally0:
		{
			VideoRow* _tmp9_;
			_tmp9_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = alteration_new ("metadata", "exposure-time");
	_tmp11_ = _tmp10_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp11_);
	_alteration_unref0 (_tmp11_);
}

void
video_get_frame_dimensions (Video* self,
                            Dimensions* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO (self));
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp2_;
			Dimensions _tmp3_ = {0};
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = self->priv->backing_row;
			dimensions_init (&_tmp3_, _tmp1_->width, _tmp2_->height);
			*result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
video_real_get_dimensions (MediaSource* base,
                           PhotoException disallowed_steps,
                           Dimensions* result)
{
	Video * self;
	Dimensions _tmp0_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_get_frame_dimensions (self, &_tmp0_);
	*result = _tmp0_;
	return;
}

static guint64
video_real_get_filesize (MediaSource* base)
{
	Video * self;
	guint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	result = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

static guint64
video_real_get_master_filesize (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = (guint64) _tmp1_->filesize;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static GDateTime*
video_real_get_timestamp (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			GDateTime* _tmp2_;
			GDateTime* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->timestamp;
			_tmp3_ = _g_date_time_ref0 (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
video_real_set_master_timestamp (Monitorable* base,
                                 GFileInfo* info)
{
	Video * self;
	GDateTime* time_val = NULL;
	GDateTime* _tmp0_;
	Alteration* _tmp17_;
	Alteration* _tmp18_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_info_get_modification_date_time (info);
	time_val = _tmp0_;
	{
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
			{
				VideoRow* _tmp2_;
				GDateTime* _tmp3_;
				GDateTime* _tmp4_;
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				GDateTime* _tmp10_;
				VideoRow* _tmp11_;
				GDateTime* _tmp12_;
				GDateTime* _tmp13_;
				_tmp2_ = self->priv->backing_row;
				_tmp3_ = _tmp2_->timestamp;
				_tmp4_ = time_val;
				if (g_date_time_equal (_tmp3_, _tmp4_)) {
					{
						GError* _inner_error0_ = NULL;
						VideoRow* _tmp5_;
						_tmp5_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_date_time_unref0 (time_val);
					return;
				}
				_tmp6_ = video_table_get_instance ();
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->backing_row;
				_tmp9_ = _tmp8_->video_id;
				_tmp10_ = time_val;
				video_table_set_timestamp (_tmp7_, &_tmp9_, _tmp10_, &_inner_error0_);
				_database_table_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp11_ = self->priv->backing_row;
				_tmp12_ = time_val;
				_tmp13_ = _g_date_time_ref0 (_tmp12_);
				_g_date_time_unref0 (_tmp11_->timestamp);
				_tmp11_->timestamp = _tmp13_;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp14_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp14_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp14_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				VideoRow* _tmp15_;
				_tmp15_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = err;
		app_window_database_error (_tmp16_);
		_g_error_free0 (err);
		_g_date_time_unref0 (time_val);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_date_time_unref0 (time_val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = alteration_new ("metadata", "master-timestamp");
	_tmp18_ = _tmp17_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
	_alteration_unref0 (_tmp18_);
	_g_date_time_unref0 (time_val);
}

gchar*
video_get_filename (Video* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (IS_VIDEO (self), NULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->filepath;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static GFile*
video_real_get_file (MediaSource* base)
{
	Video * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = video_get_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
video_real_get_master_file (MediaSource* base)
{
	Video * self;
	GFile* _tmp0_;
	GFile* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	result = _tmp0_;
	return result;
}

void
video_export (Video* self,
              GFile* dest_file,
              GError** error)
{
	GFile* source_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest_file, g_file_get_type ()));
	_tmp0_ = video_get_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	source_file = _tmp3_;
	g_file_copy (source_file, dest_file, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (source_file);
		return;
	}
	_g_object_unref0 (source_file);
}

gdouble
video_get_clip_duration (Video* self)
{
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (IS_VIDEO (self), 0.0);
	{
		VideoRow* _tmp0_;
		gdouble _tmp4_ = -1.0;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->clip_duration;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

gboolean
video_get_is_interpretable (Video* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
	{
		VideoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->is_interpretable;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
video_set_is_interpretable (Video* self,
                            gboolean is_interpretable)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO (self));
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			if (_tmp1_->is_interpretable == is_interpretable) {
				{
					VideoRow* _tmp2_;
					_tmp2_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return;
			}
			_tmp3_ = self->priv->backing_row;
			_tmp3_->is_interpretable = is_interpretable;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		VideoTable* _tmp5_;
		VideoTable* _tmp6_;
		VideoID _tmp7_ = {0};
		_tmp5_ = video_table_get_instance ();
		_tmp6_ = _tmp5_;
		video_get_video_id (self, &_tmp7_);
		video_table_update_is_interpretable (_tmp6_, &_tmp7_, is_interpretable, &_inner_error0_);
		_database_table_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch1_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_database_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		app_window_database_error (_tmp8_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

VideoInterpretableResults*
video_check_is_interpretable (Video* self)
{
	VideoInterpretableResults* results = NULL;
	VideoInterpretableResults* _tmp0_;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* backing_file_reader = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	VideoInterpretableResults* _tmp20_;
	VideoInterpretableResults* _tmp21_;
	VideoInterpretableResults* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GError* _inner_error0_ = NULL;
	VideoInterpretableResults* result;
	g_return_val_if_fail (IS_VIDEO (self), NULL);
	_tmp0_ = video_interpretable_results_new (self);
	results = _tmp0_;
	clip_duration = -1.0;
	preview_frame = NULL;
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp2_ = _tmp1_;
	_tmp3_ = video_reader_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	backing_file_reader = _tmp4_;
	{
		gdouble _tmp5_ = 0.0;
		VideoReader* _tmp6_;
		VideoReader* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp6_ = backing_file_reader;
		_tmp5_ = video_reader_read_clip_duration (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VIDEO_ERROR) {
				goto __catch0_video_error;
			}
			_video_reader_unref0 (backing_file_reader);
			_g_object_unref0 (preview_frame);
			_video_interpretable_results_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		clip_duration = _tmp5_;
		_tmp7_ = backing_file_reader;
		_tmp8_ = video_reader_read_preview_frame (_tmp7_);
		_g_object_unref0 (preview_frame);
		preview_frame = _tmp8_;
	}
	goto __finally0;
	__catch0_video_error:
	{
		VideoInterpretableResults* _tmp9_;
		VideoInterpretableResults* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp9_ = results;
		_tmp9_->update_interpretable = video_get_is_interpretable (self);
		_tmp10_ = results;
		_tmp10_->is_interpretable = FALSE;
		result = results;
		_video_reader_unref0 (backing_file_reader);
		_g_object_unref0 (preview_frame);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_video_reader_unref0 (backing_file_reader);
		_g_object_unref0 (preview_frame);
		_video_interpretable_results_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (video_get_is_interpretable (self)) {
		VideoInterpretableResults* _tmp11_;
		VideoInterpretableResults* _tmp12_;
		_tmp11_ = results;
		_tmp11_->update_interpretable = FALSE;
		_tmp12_ = results;
		_tmp12_->is_interpretable = TRUE;
		result = results;
		_video_reader_unref0 (backing_file_reader);
		_g_object_unref0 (preview_frame);
		return result;
	}
	_tmp13_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_basename (_tmp14_);
	_tmp16_ = _tmp15_;
	g_debug ("Video.vala:582: video %s has become interpretable", _tmp16_);
	_g_free0 (_tmp16_);
	_g_object_unref0 (_tmp14_);
	{
		VideoRow* _tmp17_;
		_tmp17_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp18_;
			_tmp18_ = self->priv->backing_row;
			_tmp18_->clip_duration = clip_duration;
		}
		__finally1:
		{
			VideoRow* _tmp19_;
			_tmp19_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_video_reader_unref0 (backing_file_reader);
			_g_object_unref0 (preview_frame);
			_video_interpretable_results_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = results;
	_tmp20_->update_interpretable = TRUE;
	_tmp21_ = results;
	_tmp21_->is_interpretable = TRUE;
	_tmp22_ = results;
	_tmp23_ = preview_frame;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (_tmp22_->new_thumbnail);
	_tmp22_->new_thumbnail = _tmp24_;
	result = results;
	_video_reader_unref0 (backing_file_reader);
	_g_object_unref0 (preview_frame);
	return result;
}

static void
video_real_destroy (DataSource* base)
{
	Video * self;
	VideoID video_id = {0};
	VideoID _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	video_get_video_id (self, &_tmp0_);
	video_id = _tmp0_;
	thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
	{
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoID _tmp3_;
		_tmp1_ = video_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = video_id;
		video_table_remove (_tmp2_, &_tmp3_, &_inner_error0_);
		_database_table_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp5_ = _tmp4_;
		g_error ("Video.vala:604: failed to remove video %s from video table", _tmp5_);
		_g_free0 (_tmp5_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	DATA_SOURCE_CLASS (video_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource));
}

static gboolean
video_real_internal_delete_backing (DataSource* base,
                                    GError** error)
{
	Video * self;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	ret = media_source_delete_original_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = DATA_SOURCE_CLASS (video_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = ret;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
video_notify_flags_altered (Video* self,
                            Alteration* additional_alteration)
{
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp3_;
	g_return_if_fail (IS_VIDEO (self));
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
	_tmp0_ = alteration_new ("metadata", "flags");
	alteration = _tmp0_;
	if (additional_alteration != NULL) {
		Alteration* _tmp1_;
		Alteration* _tmp2_;
		_tmp1_ = alteration;
		_tmp2_ = alteration_compress (_tmp1_, additional_alteration);
		_alteration_unref0 (alteration);
		alteration = _tmp2_;
	}
	_tmp3_ = alteration;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp3_);
	_alteration_unref0 (alteration);
}

guint64
video_add_flags (Video* self,
                 guint64 flags_to_add,
                 Alteration* additional_alteration)
{
	guint64 new_flags = 0ULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp2_;
			VideoRow* _tmp14_;
			_tmp1_ = self->priv->backing_row;
			new_flags = media_source_internal_add_flags (_tmp1_->flags, flags_to_add);
			_tmp2_ = self->priv->backing_row;
			if (_tmp2_->flags == new_flags) {
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				result = _tmp3_->flags;
				{
					VideoRow* _tmp4_;
					_tmp4_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			{
				VideoTable* _tmp5_;
				VideoTable* _tmp6_;
				VideoID _tmp7_ = {0};
				_tmp5_ = video_table_get_instance ();
				_tmp6_ = _tmp5_;
				video_get_video_id (self, &_tmp7_);
				video_table_set_flags (_tmp6_, &_tmp7_, new_flags, &_inner_error0_);
				_database_table_unref0 (_tmp6_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					guint64 _tmp9_ = 0ULL;
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp8_;
						_tmp8_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp10_;
				VideoRow* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = e;
				app_window_database_error (_tmp10_);
				_tmp11_ = self->priv->backing_row;
				result = _tmp11_->flags;
				_g_error_free0 (e);
				{
					VideoRow* _tmp12_;
					_tmp12_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint64 _tmp13_ = 0ULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp13_;
			}
			_tmp14_ = self->priv->backing_row;
			_tmp14_->flags = new_flags;
		}
		__finally0:
		{
			VideoRow* _tmp15_;
			_tmp15_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp16_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	video_notify_flags_altered (self, additional_alteration);
	result = new_flags;
	return result;
}

guint64
video_remove_flags (Video* self,
                    guint64 flags_to_remove,
                    Alteration* additional_alteration)
{
	guint64 new_flags = 0ULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp2_;
			VideoRow* _tmp14_;
			_tmp1_ = self->priv->backing_row;
			new_flags = media_source_internal_remove_flags (_tmp1_->flags, flags_to_remove);
			_tmp2_ = self->priv->backing_row;
			if (_tmp2_->flags == new_flags) {
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				result = _tmp3_->flags;
				{
					VideoRow* _tmp4_;
					_tmp4_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			{
				VideoTable* _tmp5_;
				VideoTable* _tmp6_;
				VideoID _tmp7_ = {0};
				_tmp5_ = video_table_get_instance ();
				_tmp6_ = _tmp5_;
				video_get_video_id (self, &_tmp7_);
				video_table_set_flags (_tmp6_, &_tmp7_, new_flags, &_inner_error0_);
				_database_table_unref0 (_tmp6_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					guint64 _tmp9_ = 0ULL;
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp8_;
						_tmp8_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp10_;
				VideoRow* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = e;
				app_window_database_error (_tmp10_);
				_tmp11_ = self->priv->backing_row;
				result = _tmp11_->flags;
				_g_error_free0 (e);
				{
					VideoRow* _tmp12_;
					_tmp12_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint64 _tmp13_ = 0ULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp13_;
			}
			_tmp14_ = self->priv->backing_row;
			_tmp14_->flags = new_flags;
		}
		__finally0:
		{
			VideoRow* _tmp15_;
			_tmp15_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp16_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	video_notify_flags_altered (self, additional_alteration);
	result = new_flags;
	return result;
}

gboolean
video_is_flag_set (Video* self,
                   guint64 flag)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
	{
		VideoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = media_source_internal_is_flag_set (_tmp1_->flags, flag);
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
video_real_set_master_file (Monitorable* base,
                            GFile* file)
{
	Video * self;
	gchar* new_filepath = NULL;
	gchar* _tmp0_;
	gchar* old_filepath = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	Alteration* _tmp24_;
	Alteration* _tmp25_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (file);
	new_filepath = _tmp0_;
	old_filepath = NULL;
	{
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
			{
				VideoRow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				VideoRow* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				VideoTable* _tmp9_;
				VideoTable* _tmp10_;
				VideoRow* _tmp11_;
				VideoID _tmp12_;
				const gchar* _tmp13_;
				VideoRow* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp2_ = self->priv->backing_row;
				_tmp3_ = _tmp2_->filepath;
				_tmp4_ = new_filepath;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					{
						GError* _inner_error0_ = NULL;
						VideoRow* _tmp5_;
						_tmp5_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_free0 (old_filepath);
					_g_free0 (new_filepath);
					return;
				}
				_tmp6_ = self->priv->backing_row;
				_tmp7_ = _tmp6_->filepath;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (old_filepath);
				old_filepath = _tmp8_;
				_tmp9_ = video_table_get_instance ();
				_tmp10_ = _tmp9_;
				_tmp11_ = self->priv->backing_row;
				_tmp12_ = _tmp11_->video_id;
				_tmp13_ = new_filepath;
				video_table_set_filepath (_tmp10_, &_tmp12_, _tmp13_, &_inner_error0_);
				_database_table_unref0 (_tmp10_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp14_ = self->priv->backing_row;
				_tmp15_ = new_filepath;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_tmp14_->filepath);
				_tmp14_->filepath = _tmp16_;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp17_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp17_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				VideoRow* _tmp18_;
				_tmp18_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = err;
		app_window_database_error (_tmp19_);
		_g_error_free0 (err);
		_g_free0 (old_filepath);
		_g_free0 (new_filepath);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (old_filepath);
		_g_free0 (new_filepath);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = old_filepath;
	_vala_assert (_tmp20_ != NULL, "old_filepath != null");
	_tmp21_ = old_filepath;
	_tmp22_ = g_file_new_for_path (_tmp21_);
	_tmp23_ = _tmp22_;
	media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp23_, file);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = alteration_new_from_list ("backing:master,metadata:name");
	_tmp25_ = _tmp24_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
	_alteration_unref0 (_tmp25_);
	_g_free0 (old_filepath);
	_g_free0 (new_filepath);
}

VideoMetadata*
video_read_metadata (Video* self,
                     GError** error)
{
	VideoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	VideoMetadata* _tmp5_;
	VideoMetadata* _tmp6_;
	VideoMetadata* _tmp7_;
	GError* _inner_error0_ = NULL;
	VideoMetadata* result;
	g_return_val_if_fail (IS_VIDEO (self), NULL);
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp2_ = _tmp1_;
	_tmp3_ = video_reader_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = video_reader_read_metadata (_tmp4_, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_video_reader_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_media_metadata_unref0 (_tmp0_);
	return result;
}

VideoInterpretableResults*
video_interpretable_results_construct (GType object_type,
                                       Video* video)
{
	VideoInterpretableResults* self = NULL;
	Video* _tmp0_;
	g_return_val_if_fail (IS_VIDEO (video), NULL);
	self = (VideoInterpretableResults*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (video);
	_g_object_unref0 (self->video);
	self->video = _tmp0_;
	return self;
}

VideoInterpretableResults*
video_interpretable_results_new (Video* video)
{
	return video_interpretable_results_construct (VIDEO_TYPE_INTERPRETABLE_RESULTS, video);
}

void
video_interpretable_results_foreground_finish (VideoInterpretableResults* self)
{
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (VIDEO_IS_INTERPRETABLE_RESULTS (self));
	if (self->update_interpretable) {
		Video* _tmp0_;
		_tmp0_ = self->video;
		video_set_is_interpretable (_tmp0_, self->is_interpretable);
	}
	_tmp1_ = self->new_thumbnail;
	if (_tmp1_ != NULL) {
		{
			Video* _tmp2_;
			GdkPixbuf* _tmp3_;
			Video* _tmp4_;
			GdkPixbuf* _tmp5_;
			Video* _tmp6_;
			_tmp2_ = self->video;
			_tmp3_ = self->new_thumbnail;
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_BIG, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = self->video;
			_tmp5_ = self->new_thumbnail;
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_MEDIUM, _tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = self->video;
			thumbnail_source_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			Video* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = self->video;
			_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
			_tmp9_ = _tmp8_;
			_tmp10_ = err;
			_tmp11_ = _tmp10_->message;
			g_message ("Video.vala:35: Unable to update video thumbnails for %s: %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
video_value_interpretable_results_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
video_value_interpretable_results_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_interpretable_results_unref (value->data[0].v_pointer);
	}
}

static void
video_value_interpretable_results_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_interpretable_results_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
video_value_interpretable_results_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
video_value_interpretable_results_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoInterpretableResults * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_interpretable_results_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
video_value_interpretable_results_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	VideoInterpretableResults ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_interpretable_results_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
video_param_spec_interpretable_results (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	VideoParamSpecInterpretableResults* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
video_value_get_interpretable_results (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
	return value->data[0].v_pointer;
}

void
video_value_set_interpretable_results (GValue* value,
                                       gpointer v_object)
{
	VideoInterpretableResults * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_interpretable_results_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_interpretable_results_unref (old);
	}
}

void
video_value_take_interpretable_results (GValue* value,
                                        gpointer v_object)
{
	VideoInterpretableResults * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_interpretable_results_unref (old);
	}
}

static void
video_interpretable_results_class_init (VideoInterpretableResultsClass * klass,
                                        gpointer klass_data)
{
	video_interpretable_results_parent_class = g_type_class_peek_parent (klass);
	((VideoInterpretableResultsClass *) klass)->finalize = video_interpretable_results_finalize;
}

static void
video_interpretable_results_instance_init (VideoInterpretableResults * self,
                                           gpointer klass)
{
	self->update_interpretable = FALSE;
	self->is_interpretable = FALSE;
	self->new_thumbnail = NULL;
	self->ref_count = 1;
}

static void
video_interpretable_results_finalize (VideoInterpretableResults * obj)
{
	VideoInterpretableResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->video);
	_g_object_unref0 (self->new_thumbnail);
}

static GType
video_interpretable_results_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { video_value_interpretable_results_init, video_value_interpretable_results_free_value, video_value_interpretable_results_copy_value, video_value_interpretable_results_peek_pointer, "p", video_value_interpretable_results_collect_value, "p", video_value_interpretable_results_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoInterpretableResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_interpretable_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoInterpretableResults), 0, (GInstanceInitFunc) video_interpretable_results_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_interpretable_results_type_id;
	video_interpretable_results_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoInterpretableResults", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return video_interpretable_results_type_id;
}

GType
video_interpretable_results_get_type (void)
{
	static volatile gsize video_interpretable_results_type_id__once = 0;
	if (g_once_init_enter (&video_interpretable_results_type_id__once)) {
		GType video_interpretable_results_type_id;
		video_interpretable_results_type_id = video_interpretable_results_get_type_once ();
		g_once_init_leave (&video_interpretable_results_type_id__once, video_interpretable_results_type_id);
	}
	return video_interpretable_results_type_id__once;
}

gpointer
video_interpretable_results_ref (gpointer instance)
{
	VideoInterpretableResults * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_interpretable_results_unref (gpointer instance)
{
	VideoInterpretableResults * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_INTERPRETABLE_RESULTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
video_class_init (VideoClass * klass,
                  gpointer klass_data)
{
	video_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Video_private_offset);
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource*, SourceCollection*, const gchar*)) video_real_commit_backlinks;
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource*, EventID*)) video_real_set_event_id;
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource*, gint*)) video_real_get_backing_files_state;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) video_real_get_thumbnail;
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource*)) video_real_get_master_md5;
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) video_real_get_preview_pixbuf;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) video_real_create_thumbnail;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) video_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) video_real_get_instance_id;
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource*, ImportID*)) video_real_get_import_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) video_real_get_preferred_thumbnail_format;
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource*)) video_real_get_title;
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource*, const gchar*)) video_real_set_title;
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource*)) video_real_get_comment;
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource*, const gchar*)) video_real_set_comment;
	((MediaSourceClass *) klass)->get_rating = (Rating (*) (MediaSource*)) video_real_get_rating;
	((MediaSourceClass *) klass)->set_rating = (void (*) (MediaSource*, Rating)) video_real_set_rating;
	((MediaSourceClass *) klass)->increase_rating = (void (*) (MediaSource*)) video_real_increase_rating;
	((MediaSourceClass *) klass)->decrease_rating = (void (*) (MediaSource*)) video_real_decrease_rating;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) video_real_is_trashed;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) video_real_is_offline;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) video_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) video_real_mark_online;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) video_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) video_real_untrash;
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource*, EventID*)) video_real_get_event_id;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) video_real_to_string;
	((MediaSourceClass *) klass)->get_exposure_time = (GDateTime* (*) (MediaSource*)) video_real_get_exposure_time;
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource*, PhotoException, Dimensions*)) video_real_get_dimensions;
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource*)) video_real_get_filesize;
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource*)) video_real_get_master_filesize;
	((MediaSourceClass *) klass)->get_timestamp = (GDateTime* (*) (MediaSource*)) video_real_get_timestamp;
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource*)) video_real_get_file;
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource*)) video_real_get_master_file;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) video_real_destroy;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) video_real_internal_delete_backing;
	G_OBJECT_CLASS (klass)->finalize = video_finalize;
}

static void
video_flaggable_interface_init (FlaggableIface * iface,
                                gpointer iface_data)
{
	video_flaggable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_flagged = (gboolean (*) (Flaggable*)) video_real_is_flagged;
	iface->mark_flagged = (void (*) (Flaggable*)) video_real_mark_flagged;
	iface->mark_unflagged = (void (*) (Flaggable*)) video_real_mark_unflagged;
}

static void
video_monitorable_interface_init (MonitorableIface * iface,
                                  gpointer iface_data)
{
	video_monitorable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_offline = (gboolean (*) (Monitorable*)) video_real_is_offline;
	iface->mark_offline = (void (*) (Monitorable*)) video_real_mark_offline;
	iface->mark_online = (void (*) (Monitorable*)) video_real_mark_online;
	iface->set_master_timestamp = (void (*) (Monitorable*, GFileInfo*)) video_real_set_master_timestamp;
	iface->set_master_file = (void (*) (Monitorable*, GFile*)) video_real_set_master_file;
}

static void
video_dateable_interface_init (DateableIface * iface,
                               gpointer iface_data)
{
	video_dateable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_exposure_time = (GDateTime* (*) (Dateable*)) video_real_get_exposure_time;
	iface->set_exposure_time = (void (*) (Dateable*, GDateTime*)) video_real_set_exposure_time;
}

static void
video_instance_init (Video * self,
                     gpointer klass)
{
	self->priv = video_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_backing_row);
}

static void
video_finalize (GObject * obj)
{
	Video * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO, Video);
	g_rec_mutex_clear (&self->priv->__lock_backing_row);
	_video_row_unref0 (self->priv->backing_row);
	G_OBJECT_CLASS (video_parent_class)->finalize (obj);
}

static GType
video_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Video), 0, (GInstanceInitFunc) video_instance_init, NULL };
	static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) video_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) video_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) video_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType video_type_id;
	video_type_id = g_type_register_static (TYPE_VIDEO_SOURCE, "Video", &g_define_type_info, 0);
	g_type_add_interface_static (video_type_id, TYPE_FLAGGABLE, &flaggable_info);
	g_type_add_interface_static (video_type_id, TYPE_MONITORABLE, &monitorable_info);
	g_type_add_interface_static (video_type_id, TYPE_DATEABLE, &dateable_info);
	Video_private_offset = g_type_add_instance_private (video_type_id, sizeof (VideoPrivate));
	return video_type_id;
}

GType
video_get_type (void)
{
	static volatile gsize video_type_id__once = 0;
	if (g_once_init_enter (&video_type_id__once)) {
		GType video_type_id;
		video_type_id = video_get_type_once ();
		g_once_init_leave (&video_type_id__once, video_type_id);
	}
	return video_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

