// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package network

import (
	"net/netip"
	"time"

	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
	"github.com/siderolabs/talos/pkg/machinery/nethelpers"
)

func (BondConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "BondConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "BondConfig is a config document to create a bond (link aggregation) over a set of links." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "BondConfig is a config document to create a bond (link aggregation) over a set of links.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the bond link (interface) to be created.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the bond link (interface) to be created." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hardwareAddr",
				Type:        "HardwareAddr",
				Note:        "",
				Description: "Override the hardware (MAC) address of the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Override the hardware (MAC) address of the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "links",
				Type:        "[]string",
				Note:        "",
				Description: "Names of the links (interfaces) on which the bond will be created.\nLink aliases can be used here as well.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Names of the links (interfaces) on which the bond will be created." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "bondMode",
				Type:        "BondMode",
				Note:        "",
				Description: "Bond mode.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Bond mode." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"balance-rr",
					"active-backup",
					"balance-xor",
					"broadcast",
					"802.3ad",
					"balance-tlb",
					"balance-alb",
				},
			},
			{
				Name:        "miimon",
				Type:        "uint32",
				Note:        "",
				Description: "Link monitoring frequency in milliseconds.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Link monitoring frequency in milliseconds." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "updelay",
				Type:        "uint32",
				Note:        "",
				Description: "The time, in milliseconds, to wait before enabling a slave after a link recovery has been detected.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The time, in milliseconds, to wait before enabling a slave after a link recovery has been detected." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "downdelay",
				Type:        "uint32",
				Note:        "",
				Description: "The time, in milliseconds, to wait before disabling a slave after a link failure has been detected.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The time, in milliseconds, to wait before disabling a slave after a link failure has been detected." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "useCarrier",
				Type:        "bool",
				Note:        "",
				Description: "Specifies whether or not miimon should use MII or ETHTOOL.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies whether or not miimon should use MII or ETHTOOL." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "xmitHashPolicy",
				Type:        "BondXmitHashPolicy",
				Note:        "",
				Description: "Selects the transmit hash policy to use for slave selection.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Selects the transmit hash policy to use for slave selection." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"layer2",
					"layer3+4",
					"layer2+3",
					"encap2+3",
					"encap3+4",
				},
			},
			{
				Name:        "arpInterval",
				Type:        "uint32",
				Note:        "",
				Description: "ARP link monitoring frequency in milliseconds.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "ARP link monitoring frequency in milliseconds." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "arpIpTargets",
				Type:        "[]Addr",
				Note:        "",
				Description: "The list of IPv4 addresses to use for ARP link monitoring when arpInterval is set.\nMaximum of 16 targets are supported.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The list of IPv4 addresses to use for ARP link monitoring when arpInterval is set." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "nsIp6Targets",
				Type:        "[]Addr",
				Note:        "",
				Description: "The list of IPv6 addresses to use for NS link monitoring when arpInterval is set.\nMaximum of 16 targets are supported.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The list of IPv6 addresses to use for NS link monitoring when arpInterval is set." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "arpValidate",
				Type:        "ARPValidate",
				Note:        "",
				Description: "Specifies whether or not ARP probes and replies should be validated.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies whether or not ARP probes and replies should be validated." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"none",
					"active",
					"backup",
					"all",
					"filter",
					"filter-active",
					"filter-backup",
				},
			},
			{
				Name:        "arpAllTargets",
				Type:        "ARPAllTargets",
				Note:        "",
				Description: "Specifies whether ARP probes should be sent to any or all targets.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies whether ARP probes should be sent to any or all targets." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"any",
					"all",
				},
			},
			{
				Name:        "lacpRate",
				Type:        "LACPRate",
				Note:        "",
				Description: "LACPDU frames periodic transmission rate.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "LACPDU frames periodic transmission rate." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"slow",
					"fast",
				},
			},
			{
				Name:        "failOverMac",
				Type:        "FailOverMAC",
				Note:        "",
				Description: "Specifies whether active-backup mode should set all slaves to the same MAC address\nat enslavement, when enabled, or perform special handling.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies whether active-backup mode should set all slaves to the same MAC address" /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"none",
					"active",
					"follow",
				},
			},
			{
				Name:        "adSelect",
				Type:        "ADSelect",
				Note:        "",
				Description: "Aggregate selection policy for 802.3ad.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Aggregate selection policy for 802.3ad." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"stable",
					"bandwidth",
					"count",
				},
			},
			{
				Name:        "adActorSysPrio",
				Type:        "uint16",
				Note:        "",
				Description: "Actor system priority for 802.3ad.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Actor system priority for 802.3ad." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "adUserPortKey",
				Type:        "uint16",
				Note:        "",
				Description: "User port key (upper 10 bits) for 802.3ad.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "User port key (upper 10 bits) for 802.3ad." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "adLACPActive",
				Type:        "ADLACPActive",
				Note:        "",
				Description: "Whether to send LACPDU frames periodically.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Whether to send LACPDU frames periodically." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"on",
					"off",
				},
			},
			{
				Name:        "primaryReselect",
				Type:        "PrimaryReselect",
				Note:        "",
				Description: "Policy under which the primary slave should be reselected.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Policy under which the primary slave should be reselected." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"always",
					"better",
					"failure",
				},
			},
			{
				Name:        "resendIGMP",
				Type:        "uint32",
				Note:        "",
				Description: "The number of times IGMP packets should be resent.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The number of times IGMP packets should be resent." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "minLinks",
				Type:        "uint32",
				Note:        "",
				Description: "The minimum number of active links required for the bond to be considered active.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The minimum number of active links required for the bond to be considered active." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "lpInterval",
				Type:        "uint32",
				Note:        "",
				Description: "The number of seconds between instances where the bonding driver sends learning packets to each slave's peer switch.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The number of seconds between instances where the bonding driver sends learning packets to each slave's peer switch." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "packetsPerSlave",
				Type:        "uint32",
				Note:        "",
				Description: "The number of packets to transmit through a slave before moving to the next one.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The number of packets to transmit through a slave before moving to the next one." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "numPeerNotif",
				Type:        "uint8",
				Note:        "",
				Description: "The number of peer notifications (gratuitous ARPs and unsolicited IPv6 Neighbor Advertisements)\nto be issued after a failover event.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The number of peer notifications (gratuitous ARPs and unsolicited IPv6 Neighbor Advertisements)" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tlbLogicalLb",
				Type:        "uint8",
				Note:        "",
				Description: "Whether dynamic shuffling of flows is enabled in tlb or alb mode.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Whether dynamic shuffling of flows is enabled in tlb or alb mode." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "allSlavesActive",
				Type:        "uint8",
				Note:        "",
				Description: "Whether duplicate frames (received on inactive ports) should be dropped (0) or delivered (1).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Whether duplicate frames (received on inactive ports) should be dropped (0) or delivered (1)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "peerNotifDelay",
				Type:        "uint32",
				Note:        "",
				Description: "The delay, in milliseconds, between each peer notification.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The delay, in milliseconds, between each peer notification." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "missedMax",
				Type:        "uint8",
				Note:        "",
				Description: "The number of arpInterval monitor checks that must fail in order for an interface to be marked down by the ARP monitor.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The number of arpInterval monitor checks that must fail in order for an interface to be marked down by the ARP monitor." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleBondConfigV1Alpha1())

	doc.Fields[1].AddExample("", "bond.ext")
	doc.Fields[2].AddExample("", nethelpers.HardwareAddr{0x2e, 0x3c, 0x4d, 0x5e, 0x6f, 0x70})
	doc.Fields[3].AddExample("", []string{"enp0s3", "enp0s8"})
	doc.Fields[4].AddExample("", "802.3ad")
	doc.Fields[5].AddExample("", 200)
	doc.Fields[6].AddExample("", 300)
	doc.Fields[7].AddExample("", 100)
	doc.Fields[9].AddExample("", "layer2")
	doc.Fields[10].AddExample("", 1000)
	doc.Fields[11].AddExample("", []netip.Addr{netip.MustParseAddr("10.15.0.1")})
	doc.Fields[12].AddExample("", []netip.Addr{netip.MustParseAddr("fd00::1")})
	doc.Fields[13].AddExample("", "active")
	doc.Fields[14].AddExample("", "all")
	doc.Fields[15].AddExample("", "fast")
	doc.Fields[16].AddExample("", "active")
	doc.Fields[17].AddExample("", "stable")
	doc.Fields[18].AddExample("", 65535)
	doc.Fields[19].AddExample("", 0)
	doc.Fields[20].AddExample("", "on")
	doc.Fields[21].AddExample("", "always")
	doc.Fields[27].AddExample("", 1)
	doc.Fields[28].AddExample("", 0)

	return doc
}

func (BridgeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "BridgeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "BridgeConfig is a config document to create a Bridge (link aggregation) over a set of links." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "BridgeConfig is a config document to create a Bridge (link aggregation) over a set of links.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the bridge link (interface) to be created.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the bridge link (interface) to be created." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hardwareAddr",
				Type:        "HardwareAddr",
				Note:        "",
				Description: "Override the hardware (MAC) address of the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Override the hardware (MAC) address of the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "links",
				Type:        "[]string",
				Note:        "",
				Description: "Names of the links (interfaces) to be aggregated.\nLink aliases can be used here as well.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Names of the links (interfaces) to be aggregated." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "stp",
				Type:        "BridgeSTPConfig",
				Note:        "",
				Description: "Bridge STP (Spanning Tree Protocol) configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Bridge STP (Spanning Tree Protocol) configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "vlan",
				Type:        "BridgeVLANConfig",
				Note:        "",
				Description: "Bridge VLAN configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Bridge VLAN configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleBridgeConfigV1Alpha1())

	doc.Fields[1].AddExample("", "Bridge.ext")
	doc.Fields[2].AddExample("", nethelpers.HardwareAddr{0x2e, 0x3c, 0x4d, 0x5e, 0x6f, 0x70})
	doc.Fields[3].AddExample("", []string{"enp1s3", "enp1s2"})

	return doc
}

func (BridgeSTPConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "BridgeSTPConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "BridgeSTPConfig is a bridge STP (Spanning Tree Protocol) configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "BridgeSTPConfig is a bridge STP (Spanning Tree Protocol) configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "BridgeConfigV1Alpha1",
				FieldName: "stp",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable or disable STP on the bridge.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable or disable STP on the bridge." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", true)

	return doc
}

func (BridgeVLANConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "BridgeVLANConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "BridgeVLANConfig is a bridge VLAN configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "BridgeVLANConfig is a bridge VLAN configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "BridgeConfigV1Alpha1",
				FieldName: "vlan",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "filtering",
				Type:        "bool",
				Note:        "",
				Description: "Enable or disable VLAN filtering on the bridge.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable or disable VLAN filtering on the bridge." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", true)

	return doc
}

func (DefaultActionConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "NetworkDefaultActionConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "NetworkDefaultActionConfig is a ingress firewall default action configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "NetworkDefaultActionConfig is a ingress firewall default action configuration document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "ingress",
				Type:        "DefaultAction",
				Note:        "",
				Description: "Default action for all not explicitly configured ingress traffic: accept or block.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Default action for all not explicitly configured ingress traffic: accept or block." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"accept",
					"block",
				},
			},
		},
	}

	doc.AddExample("", exampleDefaultActionConfigV1Alpha1())

	return doc
}

func (DHCPv4ConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "DHCPv4Config",
		Comments:    [3]string{"" /* encoder.HeadComment */, "DHCPv4Config is a config document to configure DHCPv4 on a network link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "DHCPv4Config is a config document to configure DHCPv4 on a network link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "routeMetric",
				Type:        "uint32",
				Note:        "",
				Description: "An optional metric for the routes received from the DHCP server.\n\nLower values indicate higher priority.\nDefault value is 1024.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "An optional metric for the routes received from the DHCP server." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ignoreHostname",
				Type:        "bool",
				Note:        "",
				Description: "Ignore hostname received from the DHCP server.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Ignore hostname received from the DHCP server." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "clientIdentifier",
				Type:        "ClientIdentifier",
				Note:        "",
				Description: "Client identifier to use when communicating with DHCP servers.\n\nDefaults to 'mac' if not set.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Client identifier to use when communicating with DHCP servers." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"none",
					"mac",
					"duid",
				},
			},
			{
				Name:        "duidRaw",
				Type:        "HardwareAddr",
				Note:        "",
				Description: "Raw value of the DUID to use as client identifier.\n\nThis field is only used if 'clientIdentifier' is set to 'duid'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Raw value of the DUID to use as client identifier." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleDHCPv4ConfigV1Alpha1())

	doc.Fields[1].AddExample("", "enp0s2")
	doc.Fields[5].AddExample("", "00:01:00:01:23:45:67:89:ab:cd:ef:01:23:45")

	return doc
}

func (DHCPv6ConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "DHCPv6Config",
		Comments:    [3]string{"" /* encoder.HeadComment */, "DHCPv6Config is a config document to configure DHCPv6 on a network link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "DHCPv6Config is a config document to configure DHCPv6 on a network link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "routeMetric",
				Type:        "uint32",
				Note:        "",
				Description: "An optional metric for the routes received from the DHCP server.\n\nLower values indicate higher priority.\nDefault value is 1024.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "An optional metric for the routes received from the DHCP server." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ignoreHostname",
				Type:        "bool",
				Note:        "",
				Description: "Ignore hostname received from the DHCP server.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Ignore hostname received from the DHCP server." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "clientIdentifier",
				Type:        "ClientIdentifier",
				Note:        "",
				Description: "Client identifier to use when communicating with DHCP servers.\n\nDefaults to 'mac' if not set.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Client identifier to use when communicating with DHCP servers." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"none",
					"mac",
					"duid",
				},
			},
			{
				Name:        "duidRaw",
				Type:        "HardwareAddr",
				Note:        "",
				Description: "Raw value of the DUID to use as client identifier.\n\nThis field is only used if 'clientIdentifier' is set to 'duid'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Raw value of the DUID to use as client identifier." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleDHCPv6ConfigV1Alpha1())

	doc.Fields[1].AddExample("", "enp0s2")
	doc.Fields[5].AddExample("", "00:01:00:01:23:45:67:89:ab:cd:ef:01:23:45")

	return doc
}

func (DummyLinkConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "DummyLinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "DummyLinkConfig is a config document to create a dummy (virtual) network link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "DummyLinkConfig is a config document to create a dummy (virtual) network link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the dummy link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the dummy link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hardwareAddr",
				Type:        "HardwareAddr",
				Note:        "",
				Description: "Override the hardware (MAC) address of the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Override the hardware (MAC) address of the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleDummyLinkConfigV1Alpha1())

	doc.Fields[1].AddExample("", "dummy1")
	doc.Fields[2].AddExample("", nethelpers.HardwareAddr{0x2e, 0x3c, 0x4d, 0x5e, 0x6f, 0x70})

	return doc
}

func (EthernetConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EthernetConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EthernetConfig is a config document to configure Ethernet interfaces." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EthernetConfig is a config document to configure Ethernet interfaces.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "features",
				Type:        "map[string]bool",
				Note:        "",
				Description: "Configuration for Ethernet features.\n\nSet of features available and whether they can be enabled or disabled is driver specific.\nUse `talosctl get ethernetstatus <link> -o yaml` to get the list of available features and\ntheir current status.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for Ethernet features." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rings",
				Type:        "EthernetRingsConfig",
				Note:        "",
				Description: "Configuration for Ethernet link rings.\n\nThis is similar to `ethtool -G` command.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for Ethernet link rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "channels",
				Type:        "EthernetChannelsConfig",
				Note:        "",
				Description: "Configuration for Ethernet link channels.\n\nThis is similar to `ethtool -L` command.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for Ethernet link channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "wakeOnLan",
				Type:        "[]WOLMode",
				Note:        "",
				Description: "Wake-on-LAN modes to enable.\n\nIf this field is omitted, Wake-on-LAN configuration is not changed.\nAn empty list disables Wake-on-LAN.\n\nThis is similar to `ethtool -s <link> wol <options>` command.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Wake-on-LAN modes to enable." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"phy",
					"unicast",
					"multicast",
					"broadcast",
					"arp",
					"magic",
					"magicsecure",
					"filter",
				},
			},
		},
	}

	doc.AddExample("", exampleEthernetConfigV1Alpha1())

	doc.Fields[5].AddExample("", []nethelpers.WOLMode{nethelpers.WOLModeUnicast, nethelpers.WOLModeMagic})

	return doc
}

func (EthernetRingsConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EthernetRingsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EthernetRingsConfig is a configuration for Ethernet link rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EthernetRingsConfig is a configuration for Ethernet link rings.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EthernetConfigV1Alpha1",
				FieldName: "rings",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "rx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of TX rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of TX rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-mini",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX mini rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX mini rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-jumbo",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX jumbo rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX jumbo rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-buf-len",
				Type:        "uint32",
				Note:        "",
				Description: "RX buffer length.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "RX buffer length." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "cqe-size",
				Type:        "uint32",
				Note:        "",
				Description: "CQE size.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "CQE size." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx-push",
				Type:        "bool",
				Note:        "",
				Description: "TX push enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TX push enabled." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-push",
				Type:        "bool",
				Note:        "",
				Description: "RX push enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "RX push enabled." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx-push-buf-len",
				Type:        "uint32",
				Note:        "",
				Description: "TX push buffer length.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TX push buffer length." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tcp-data-split",
				Type:        "bool",
				Note:        "",
				Description: "TCP data split enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TCP data split enabled." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (EthernetChannelsConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EthernetChannelsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EthernetChannelsConfig is a configuration for Ethernet link channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EthernetChannelsConfig is a configuration for Ethernet link channels.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EthernetConfigV1Alpha1",
				FieldName: "channels",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "rx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of TX channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of TX channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "other",
				Type:        "uint32",
				Note:        "",
				Description: "Number of other channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of other channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "combined",
				Type:        "uint32",
				Note:        "",
				Description: "Number of combined channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of combined channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (HCloudVIPConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "HCloudVIPConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "HCloudVIPConfig is a config document to configure virtual IP using Hetzner Cloud APIs for announcement." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "HCloudVIPConfig is a config document to configure virtual IP using Hetzner Cloud APIs for announcement.\nVirtual IP configuration should be used only on controlplane nodes to provide virtual IP for Kubernetes API server.\nAny other use cases are not supported and may lead to unexpected behavior.\nVirtual IP will be announced from only one node at a time using Hetzner Cloud APIs.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "IP address to be advertised as a Layer 2 VIP.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "IP address to be advertised as a Layer 2 VIP." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "link",
				Type:        "string",
				Note:        "",
				Description: "Name of the link to assign the VIP to.\n\nSelector must match exactly one link, otherwise an error is returned.\nIf multiple selectors match the same link, the first one is used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link to assign the VIP to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "apiToken",
				Type:        "string",
				Note:        "",
				Description: "Specifies the Hetzner Cloud API Token.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies the Hetzner Cloud API Token." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleHCloudVIPConfigV1Alpha1())

	doc.Fields[1].AddExample("", "192.168.100.1")
	doc.Fields[1].AddExample("", "fd00::1")

	return doc
}

func (HostnameConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "HostnameConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "HostnameConfig is a config document to configure the hostname: either a static hostname or an automatically generated hostname." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "HostnameConfig is a config document to configure the hostname: either a static hostname or an automatically generated hostname.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "auto",
				Type:        "AutoHostnameKind",
				Note:        "",
				Description: "A method to automatically generate a hostname for the machine.\n\nThere are two methods available:\n  - `stable` - generates a stable hostname based on machine identity\n  - `off` - disables automatic hostname generation, Talos will wait for an external source to provide a hostname (DHCP, cloud-init, etc).\n\nAutomatic hostnames have the lowest priority over any other hostname sources: DHCP, cloud-init, etc.\nConflicts with `hostname` field.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A method to automatically generate a hostname for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"stable",
					"off",
				},
			},
			{
				Name:        "hostname",
				Type:        "string",
				Note:        "",
				Description: "A static hostname to set for the machine.\n\nThis hostname has the highest priority over any other hostname sources: DHCP, cloud-init, etc.\nConflicts with `auto` field.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A static hostname to set for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleHostnameConfigV1Alpha1())

	doc.AddExample("", exampleHostnameConfigV1Alpha2())

	doc.Fields[2].AddExample("", "controlplane1")
	doc.Fields[2].AddExample("", "controlplane1.example.org")

	return doc
}

func (KubeSpanConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubeSpanConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpanConfig is a config document to configure KubeSpan." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubeSpanConfig is a config document to configure KubeSpan.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable the KubeSpan feature.\nCluster discovery should be enabled with cluster.discovery.enabled for KubeSpan to be enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable the KubeSpan feature." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "advertiseKubernetesNetworks",
				Type:        "bool",
				Note:        "",
				Description: "Control whether Kubernetes pod CIDRs are announced over KubeSpan from the node.\nIf disabled, CNI handles pod-to-pod traffic encapsulation.\nIf enabled, KubeSpan takes over pod-to-pod traffic directly.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Control whether Kubernetes pod CIDRs are announced over KubeSpan from the node." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "allowDownPeerBypass",
				Type:        "bool",
				Note:        "",
				Description: "Skip sending traffic via KubeSpan if the peer connection state is not up.\nThis provides configurable choice between connectivity and security.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Skip sending traffic via KubeSpan if the peer connection state is not up." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "harvestExtraEndpoints",
				Type:        "bool",
				Note:        "",
				Description: "KubeSpan can collect and publish extra endpoints for each member of the cluster\nbased on Wireguard endpoint information for each peer.\nDisabled by default. Do not enable with high peer counts (>50).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpan can collect and publish extra endpoints for each member of the cluster" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mtu",
				Type:        "uint32",
				Note:        "",
				Description: "KubeSpan link MTU size.\nDefault value is 1420.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpan link MTU size." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "filters",
				Type:        "KubeSpanFiltersConfig",
				Note:        "",
				Description: "KubeSpan advanced filtering of network addresses.\nSettings are optional and apply only to this node.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpan advanced filtering of network addresses." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleKubeSpanV1Alpha1())

	return doc
}

func (KubeSpanFiltersConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubeSpanFiltersConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpanFiltersConfig configures KubeSpan endpoint filters." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubeSpanFiltersConfig configures KubeSpan endpoint filters.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "KubeSpanConfigV1Alpha1",
				FieldName: "filters",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "endpoints",
				Type:        "[]string",
				Note:        "",
				Description: "Filter node addresses which will be advertised as KubeSpan endpoints for peer-to-peer Wireguard connections.\n\nBy default, all addresses are advertised, and KubeSpan cycles through all endpoints until it finds one that works.\n\nDefault value: no filtering.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Filter node addresses which will be advertised as KubeSpan endpoints for peer-to-peer Wireguard connections." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("Exclude addresses in 192.168.0.0/16 subnet.", []string{"0.0.0.0/0", "!192.168.0.0/16", "::/0"})

	return doc
}

func (KubespanEndpointsConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubeSpanEndpointsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpanEndpointsConfig is a config document to configure KubeSpan endpoints." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubeSpanEndpointsConfig is a config document to configure KubeSpan endpoints.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "extraAnnouncedEndpoints",
				Type:        "[]AddrPort",
				Note:        "",
				Description: "A list of extra Wireguard endpoints to announce from this machine.\n\nTalos automatically adds endpoints based on machine addresses, public IP, etc.\nThis field allows to add extra endpoints which are managed outside of Talos, e.g. NAT mapping.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of extra Wireguard endpoints to announce from this machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleKubespanEndpointsV1Alpha1())

	return doc
}

func (Layer2VIPConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "Layer2VIPConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "Layer2VIPConfig is a config document to configure virtual IP using Layer 2 (Ethernet) advertisement." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "Layer2VIPConfig is a config document to configure virtual IP using Layer 2 (Ethernet) advertisement.\nVirtual IP configuration should be used only on controlplane nodes to provide virtual IP for Kubernetes API server.\nAny other use cases are not supported and may lead to unexpected behavior.\nVirtual IP will be announced from only one node at a time using gratuitous ARP announcements for IPv4.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "IP address to be advertised as a Layer 2 VIP.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "IP address to be advertised as a Layer 2 VIP." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "link",
				Type:        "string",
				Note:        "",
				Description: "Name of the link to assign the VIP to.\n\nSelector must match exactly one link, otherwise an error is returned.\nIf multiple selectors match the same link, the first one is used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link to assign the VIP to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleLayer2VIPConfigV1Alpha1())

	doc.Fields[1].AddExample("", "192.168.100.1")
	doc.Fields[1].AddExample("", "fd00::1")

	return doc
}

func (LinkConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LinkConfig is a config document to configure physical interfaces (network links)." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LinkConfig is a config document to configure physical interfaces (network links).",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleLinkConfigV1Alpha1())

	doc.Fields[1].AddExample("", "enp0s2")
	doc.Fields[1].AddExample("", "eth1")

	return doc
}

func (CommonLinkConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "CommonLinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "CommonLinkConfig is common configuration for network links, and logical links." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "CommonLinkConfig is common configuration for network links, and logical links.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "BondConfigV1Alpha1",
				FieldName: "",
			},
			{
				TypeName:  "BridgeConfigV1Alpha1",
				FieldName: "",
			},
			{
				TypeName:  "DummyLinkConfigV1Alpha1",
				FieldName: "",
			},
			{
				TypeName:  "LinkConfigV1Alpha1",
				FieldName: "",
			},
			{
				TypeName:  "VLANConfigV1Alpha1",
				FieldName: "",
			},
			{
				TypeName:  "WireguardConfigV1Alpha1",
				FieldName: "",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "up",
				Type:        "bool",
				Note:        "",
				Description: "Bring the link up or down.\n\nIf not specified, the link will be brought up.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Bring the link up or down." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mtu",
				Type:        "uint32",
				Note:        "",
				Description: "Configure LinkMTU (Maximum Transmission Unit) for the link.\n\nIf not specified, the system default LinkMTU will be used (usually 1500).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure LinkMTU (Maximum Transmission Unit) for the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "addresses",
				Type:        "[]AddressConfig",
				Note:        "",
				Description: "Configure addresses to be statically assigned to the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure addresses to be statically assigned to the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "routes",
				Type:        "[]RouteConfig",
				Note:        "",
				Description: "Configure routes to be statically created via the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure routes to be statically created via the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "multicast",
				Type:        "bool",
				Note:        "",
				Description: "Set the multicast capability of the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Set the multicast capability of the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (AddressConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "AddressConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "AddressConfig represents a network address configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "AddressConfig represents a network address configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "CommonLinkConfig",
				FieldName: "addresses",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "address",
				Type:        "Prefix",
				Note:        "",
				Description: "IP address to be assigned to the link.\n\nThis field must include the network prefix length (e.g. /24 for IPv4, /64 for IPv6).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "IP address to be assigned to the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "routePriority",
				Type:        "uint32",
				Note:        "",
				Description: "Configure the route priority (metric) for routes created for this address.\n\nIf not specified, the system default route priority will be used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the route priority (metric) for routes created for this address." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", netip.MustParsePrefix("192.168.1.100/24"))
	doc.Fields[0].AddExample("", netip.MustParsePrefix("fd00::1/64"))

	return doc
}

func (RouteConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RouteConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RouteConfig represents a network route configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RouteConfig represents a network route configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "CommonLinkConfig",
				FieldName: "routes",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "destination",
				Type:        "Prefix",
				Note:        "",
				Description: "The route's destination as an address prefix.\n\nIf not specified, a default route will be created for the address family of the gateway.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The route's destination as an address prefix." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "gateway",
				Type:        "Addr",
				Note:        "",
				Description: "The route's gateway (if empty, creates link scope route).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The route's gateway (if empty, creates link scope route)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "source",
				Type:        "Addr",
				Note:        "",
				Description: "The route's source address (optional).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The route's source address (optional)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "metric",
				Type:        "uint32",
				Note:        "",
				Description: "The optional metric for the route.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The optional metric for the route." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mtu",
				Type:        "uint32",
				Note:        "",
				Description: "The optional MTU for the route.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The optional MTU for the route." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "table",
				Type:        "RoutingTable",
				Note:        "",
				Description: "The routing table to use for the route.\n\nIf not specified, the main routing table will be used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The routing table to use for the route." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", Prefix{netip.MustParsePrefix("10.0.0.0/8")})
	doc.Fields[1].AddExample("", Addr{netip.MustParseAddr("10.0.0.1")})

	return doc
}

func (LinkAliasConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LinkAliasConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LinkAliasConfig is a config document to alias (give a different name) to a physical link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LinkAliasConfig is a config document to alias (give a different name) to a physical link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Alias for the link.\n\nDon't use system interface names like \"eth0\", \"ens3\", \"enp0s2\", etc. as those may conflict\nwith existing physical interfaces.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Alias for the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "selector",
				Type:        "LinkSelector",
				Note:        "",
				Description: "Selector to match the link to alias.\n\nSelector must match exactly one link, otherwise an error is returned.\nIf multiple selectors match the same link, the first one is used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Selector to match the link to alias." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleLinkAliasConfigV1Alpha1())

	doc.Fields[1].AddExample("", "net0")
	doc.Fields[1].AddExample("", "private")

	return doc
}

func (LinkSelector) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LinkSelector",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LinkSelector selects a link to alias." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LinkSelector selects a link to alias.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "LinkAliasConfigV1Alpha1",
				FieldName: "selector",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "match",
				Type:        "Expression",
				Note:        "",
				Description: "The Common Expression Language (CEL) expression to match the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The Common Expression Language (CEL) expression to match the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("match links with a specific MAC address", exampleLinkSelector1())
	doc.Fields[0].AddExample("match links by MAC address prefix", exampleLinkSelector2())
	doc.Fields[0].AddExample("match links by driver name", exampleLinkSelector3())

	return doc
}

func (ResolverConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ResolverConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ResolverConfig is a config document to configure DNS resolving." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ResolverConfig is a config document to configure DNS resolving.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "nameservers",
				Type:        "[]NameserverConfig",
				Note:        "",
				Description: "A list of nameservers (DNS servers) to use for resolving domain names.\n\nNameservers are used to resolve domain names on the host, and they are also\npropagated to Kubernetes DNS (CoreDNS) for use by pods running on the cluster.\n\nThis overrides any nameservers obtained via DHCP or platform configuration.\nDefault configuration is to use 1.1.1.1 and 8.8.8.8 as nameservers.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of nameservers (DNS servers) to use for resolving domain names." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "searchDomains",
				Type:        "SearchDomainsConfig",
				Note:        "",
				Description: "Configuration for search domains (in /etc/resolv.conf).\n\nThe default is to derive search domains from the hostname FQDN.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for search domains (in /etc/resolv.conf)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleResolverConfigV1Alpha1())

	doc.AddExample("", exampleResolverConfigV1Alpha2())

	return doc
}

func (NameserverConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "NameserverConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "NameserverConfig represents a single nameserver configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "NameserverConfig represents a single nameserver configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ResolverConfigV1Alpha1",
				FieldName: "nameservers",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "address",
				Type:        "Addr",
				Note:        "",
				Description: "The IP address of the nameserver.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The IP address of the nameserver." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", Addr{netip.MustParseAddr("10.0.0.1")})

	return doc
}

func (SearchDomainsConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "SearchDomainsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "SearchDomainsConfig represents search domains configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "SearchDomainsConfig represents search domains configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ResolverConfigV1Alpha1",
				FieldName: "searchDomains",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "domains",
				Type:        "[]string",
				Note:        "",
				Description: "A list of search domains to be used for DNS resolution.\n\nSearch domains are appended to unqualified domain names during DNS resolution.\nFor example, if \"example.com\" is a search domain and a user tries to resolve\n\"host\", the system will attempt to resolve \"host.example.com\".\n\nThis overrides any search domains obtained via DHCP or platform configuration.\nThe default configuration derives the search domain from the hostname FQDN.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of search domains to be used for DNS resolution." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "disableDefault",
				Type:        "bool",
				Note:        "",
				Description: "Disable default search domain configuration from hostname FQDN.\n\nWhen set to true, the system will not derive search domains from the hostname FQDN.\nThis allows for a custom configuration of search domains without any defaults.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable default search domain configuration from hostname FQDN." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (RuleConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "NetworkRuleConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "NetworkRuleConfig is a network firewall rule config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "NetworkRuleConfig is a network firewall rule config document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the config document.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "portSelector",
				Type:        "RulePortSelector",
				Note:        "",
				Description: "Port selector defines which ports and protocols on the host are affected by the rule.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Port selector defines which ports and protocols on the host are affected by the rule." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ingress",
				Type:        "[]IngressRule",
				Note:        "",
				Description: "Ingress defines which source subnets are allowed to access the host ports/protocols defined by the `portSelector`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Ingress defines which source subnets are allowed to access the host ports/protocols defined by the `portSelector`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleRuleConfigV1Alpha1())

	return doc
}

func (RulePortSelector) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RulePortSelector",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RulePortSelector is a port selector for the network rule." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RulePortSelector is a port selector for the network rule.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RuleConfigV1Alpha1",
				FieldName: "portSelector",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "ports",
				Type:        "PortRanges",
				Note:        "",
				Description: "Ports defines a list of port ranges or single ports.\nThe port ranges are inclusive, and should not overlap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Ports defines a list of port ranges or single ports." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "protocol",
				Type:        "Protocol",
				Note:        "",
				Description: "Protocol defines traffic protocol (e.g. TCP or UDP).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Protocol defines traffic protocol (e.g. TCP or UDP)." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"tcp",
					"udp",
					"icmp",
					"icmpv6",
				},
			},
		},
	}

	doc.Fields[0].AddExample("", examplePortRanges1())
	doc.Fields[0].AddExample("", examplePortRanges2())

	return doc
}

func (IngressRule) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "IngressRule",
		Comments:    [3]string{"" /* encoder.HeadComment */, "IngressRule is a ingress rule." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "IngressRule is a ingress rule.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RuleConfigV1Alpha1",
				FieldName: "ingress",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "subnet",
				Type:        "Prefix",
				Note:        "",
				Description: "Subnet defines a source subnet.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Subnet defines a source subnet." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "except",
				Type:        "Prefix",
				Note:        "",
				Description: "Except defines a source subnet to exclude from the rule, it gets excluded from the `subnet`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Except defines a source subnet to exclude from the rule, it gets excluded from the `subnet`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", netip.MustParsePrefix("10.3.4.0/24"))
	doc.Fields[0].AddExample("", netip.MustParsePrefix("2001:db8::/32"))
	doc.Fields[0].AddExample("", netip.MustParsePrefix("1.3.4.5/32"))

	return doc
}

func (StaticHostConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "StaticHostConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "StaticHostConfig is a config document to set /etc/hosts entries." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "StaticHostConfig is a config document to set /etc/hosts entries.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "IP address (IPv4 or IPv6) to map the hostnames to.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "IP address (IPv4 or IPv6) to map the hostnames to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hostnames",
				Type:        "[]string",
				Note:        "",
				Description: "List of hostnames to map to the IP address.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "List of hostnames to map to the IP address." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleStaticHostConfigV1Alpha1())

	return doc
}

func (TCPProbeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "TCPProbeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "TCPProbeConfig is a config document to configure network TCP connectivity probes." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "TCPProbeConfig is a config document to configure network TCP connectivity probes.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the probe.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the probe." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonProbeConfig",
				Inline: true,
			},
			{
				Name:        "endpoint",
				Type:        "string",
				Note:        "",
				Description: "Endpoint to probe in the format host:port.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Endpoint to probe in the format host:port." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "timeout",
				Type:        "Duration",
				Note:        "",
				Description: "Timeout for the probe.\nDefaults to 10s.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Timeout for the probe." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleTCPProbeConfigV1Alpha1())

	doc.Fields[1].AddExample("", "proxy-check")
	doc.Fields[3].AddExample("", "proxy.example.com:3128")
	doc.Fields[4].AddExample("", 10*time.Second)

	return doc
}

func (CommonProbeConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "CommonProbeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "CommonProbeConfig holds fields common to all probe types." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "CommonProbeConfig holds fields common to all probe types.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "TCPProbeConfigV1Alpha1",
				FieldName: "",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "interval",
				Type:        "Duration",
				Note:        "",
				Description: "Interval between probe attempts.\nDefaults to 1s.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Interval between probe attempts." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "failureThreshold",
				Type:        "int",
				Note:        "",
				Description: "Number of consecutive failures for the probe to be considered failed after having succeeded.\nDefaults to 0 (immediately fail on first failure).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of consecutive failures for the probe to be considered failed after having succeeded." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", time.Second)
	doc.Fields[1].AddExample("", 3)

	return doc
}

func (TimeSyncConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "TimeSyncConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "TimeSyncConfig is a config document to configure time synchronization (NTP)." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "TimeSyncConfig is a config document to configure time synchronization (NTP).",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Indicates if the time synchronization is enabled for the machine.\nDefaults to `true`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Indicates if the time synchronization is enabled for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "bootTimeout",
				Type:        "Duration",
				Note:        "",
				Description: "Specifies the timeout when the node time is considered to be in sync unlocking the boot sequence.\nNTP sync will be still running in the background.\nDefaults to \"infinity\" (waiting forever for time sync)",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies the timeout when the node time is considered to be in sync unlocking the boot sequence." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ntp",
				Type:        "NTPConfig",
				Note:        "",
				Description: "Specifies NTP configuration to sync the time over network.\nMutually exclusive with PTP configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies NTP configuration to sync the time over network." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ptp",
				Type:        "PTPConfig",
				Note:        "",
				Description: "Specific PTP (Precision Time Protocol) configuration to sync the time over PTP devices.\nMutually exclusive with NTP configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specific PTP (Precision Time Protocol) configuration to sync the time over PTP devices." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleTimeSyncConfigV1Alpha1())

	doc.AddExample("", exampleTimeSyncConfigV1Alpha2())

	return doc
}

func (NTPConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "NTPConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "NTPConfig represents a NTP server configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "NTPConfig represents a NTP server configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "TimeSyncConfigV1Alpha1",
				FieldName: "ntp",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "servers",
				Type:        "[]string",
				Note:        "",
				Description: "Specifies time (NTP) servers to use for setting the system time.\nDefaults to `time.cloudflare.com`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies time (NTP) servers to use for setting the system time." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (PTPConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "PTPConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "PTPConfig represents a PTP (Precision Time Protocol) configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "PTPConfig represents a PTP (Precision Time Protocol) configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "TimeSyncConfigV1Alpha1",
				FieldName: "ptp",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "devices",
				Type:        "[]string",
				Note:        "",
				Description: "description: |\n    A list of PTP devices to sync with (e.g. provided by the hypervisor).\n\n    A PTP device is typically represented as a character device file in the /dev directory,\n   such as /dev/ptp0 or /dev/ptp_kvm. These devices are used to synchronize the system time\n    with an external time source that supports the Precision Time Protocol.\n",
				Comments:    [3]string{"" /* encoder.HeadComment */, "description: |" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (VLANConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "VLANConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "VLANConfig is a config document to create a VLAN (virtual LAN) over a parent link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "VLANConfig is a config document to create a VLAN (virtual LAN) over a parent link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the VLAN link (interface) to be created.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the VLAN link (interface) to be created." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "vlanID",
				Type:        "uint16",
				Note:        "",
				Description: "VLAN ID to be used for the VLAN link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "VLAN ID to be used for the VLAN link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "vlanMode",
				Type:        "VLANProtocol",
				Note:        "",
				Description: "Set the VLAN mode to use.\nIf not set, defaults to '802.1q'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Set the VLAN mode to use." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"802.1q",
					"802.1ad",
				},
			},
			{
				Name:        "parent",
				Type:        "string",
				Note:        "",
				Description: "Name of the parent link (interface) on which the VLAN link will be created.\nLink aliases can be used here as well.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the parent link (interface) on which the VLAN link will be created." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleVLANConfigV1Alpha1())

	doc.Fields[1].AddExample("", "enp0s3.34")
	doc.Fields[2].AddExample("", 34)
	doc.Fields[3].AddExample("", "802.1q")
	doc.Fields[4].AddExample("", "enp0s3")

	return doc
}

func (WireguardConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "WireguardConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "WireguardConfig is a config document to create and configure a Wireguard network link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "WireguardConfig is a config document to create and configure a Wireguard network link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the Wireguard link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the Wireguard link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "privateKey",
				Type:        "string",
				Note:        "",
				Description: "Specifies a private key configuration (base64 encoded).\nCan be generated by `wg genkey`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies a private key configuration (base64 encoded)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "listenPort",
				Type:        "int",
				Note:        "",
				Description: "Specifies a device's listening port (UDP).\nIf not specified, a random port will be chosen.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies a device's listening port (UDP)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "firewallMark",
				Type:        "int",
				Note:        "",
				Description: "Specifies a device's firewall mark.\nUseful for advanced routing setups, marking packets originating from this device.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies a device's firewall mark." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "peers",
				Type:        "[]WireguardPeer",
				Note:        "",
				Description: "Specifies a list of peer configurations to apply to a device.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies a list of peer configurations to apply to a device." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleWireguardConfigV1Alpha1())

	doc.Fields[1].AddExample("", "wg.int")

	return doc
}

func (WireguardPeer) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "WireguardPeer",
		Comments:    [3]string{"" /* encoder.HeadComment */, "WireguardPeer describes a Wireguard peer configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "WireguardPeer describes a Wireguard peer configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "WireguardConfigV1Alpha1",
				FieldName: "peers",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "publicKey",
				Type:        "string",
				Note:        "",
				Description: "Specifies the public key of this peer.\nCan be extracted from private key by running `wg pubkey < private.key`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies the public key of this peer." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "presharedKey",
				Type:        "string",
				Note:        "",
				Description: "Specifies the preshared key for this peer (base64 encoded).\nCan be generated by `wg genpsk`.\nOptional, this key provides an additional layer of symmetric-key cryptography\nto the peer connection.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies the preshared key for this peer (base64 encoded)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "endpoint",
				Type:        "AddrPort",
				Note:        "",
				Description: "Specifies the endpoint of this peer entry.\nFormat: <IP address>:<port>.\nIf not set, the peer should connect to us without us connecting to it first.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies the endpoint of this peer entry." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "persistentKeepaliveInterval",
				Type:        "Duration",
				Note:        "",
				Description: "Specifies the persistent keepalive interval for this peer.\nField format accepts any Go time.Duration format ('1h' for one hour, '10m' for ten minutes).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specifies the persistent keepalive interval for this peer." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "allowedIPs",
				Type:        "[]Prefix",
				Note:        "",
				Description: "AllowedIPs specifies a list of allowed IP addresses in CIDR notation for this peer.\nThese IPs will be routed to this peer, and defines which IPs this peer is allowed to use.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "AllowedIPs specifies a list of allowed IP addresses in CIDR notation for this peer." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

// GetFileDoc returns documentation for the file network_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "network",
		Description: "Package network provides network machine configuration documents.\n",
		Structs: []*encoder.Doc{
			BondConfigV1Alpha1{}.Doc(),
			BridgeConfigV1Alpha1{}.Doc(),
			BridgeSTPConfig{}.Doc(),
			BridgeVLANConfig{}.Doc(),
			DefaultActionConfigV1Alpha1{}.Doc(),
			DHCPv4ConfigV1Alpha1{}.Doc(),
			DHCPv6ConfigV1Alpha1{}.Doc(),
			DummyLinkConfigV1Alpha1{}.Doc(),
			EthernetConfigV1Alpha1{}.Doc(),
			EthernetRingsConfig{}.Doc(),
			EthernetChannelsConfig{}.Doc(),
			HCloudVIPConfigV1Alpha1{}.Doc(),
			HostnameConfigV1Alpha1{}.Doc(),
			KubeSpanConfigV1Alpha1{}.Doc(),
			KubeSpanFiltersConfig{}.Doc(),
			KubespanEndpointsConfigV1Alpha1{}.Doc(),
			Layer2VIPConfigV1Alpha1{}.Doc(),
			LinkConfigV1Alpha1{}.Doc(),
			CommonLinkConfig{}.Doc(),
			AddressConfig{}.Doc(),
			RouteConfig{}.Doc(),
			LinkAliasConfigV1Alpha1{}.Doc(),
			LinkSelector{}.Doc(),
			ResolverConfigV1Alpha1{}.Doc(),
			NameserverConfig{}.Doc(),
			SearchDomainsConfig{}.Doc(),
			RuleConfigV1Alpha1{}.Doc(),
			RulePortSelector{}.Doc(),
			IngressRule{}.Doc(),
			StaticHostConfigV1Alpha1{}.Doc(),
			TCPProbeConfigV1Alpha1{}.Doc(),
			CommonProbeConfig{}.Doc(),
			TimeSyncConfigV1Alpha1{}.Doc(),
			NTPConfig{}.Doc(),
			PTPConfig{}.Doc(),
			VLANConfigV1Alpha1{}.Doc(),
			WireguardConfigV1Alpha1{}.Doc(),
			WireguardPeer{}.Doc(),
		},
	}
}
