// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse BatchAuthorizationTestIamPermissionsResponse is the set of granted permissions for multiple resources.
//
// swagger:model hashicorp.cloud.resourcemanager.BatchAuthorizationTestIamPermissionsResponse
type HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse struct {

	// resource_permissions is a map of resource_id and/or resource_name to the granted permissions.
	// The key is determined by whether or not the resource_id/resource_name is a non-empty string.
	// Take for example the following psuedo-code:
	//
	// Request:
	// [
	//   {
	//     Permissions: [...],
	//     ResourceId: "abc123",
	//     ResourceName: "",
	//   },
	//   {
	//     Permissions: [...],
	//     ResourceId: "",
	//     ResourceName: "iam/group/456"
	//   },
	//   {
	//     Permissions: [...],
	//     ResourceId: "def789",
	//     ResourceName: "iam/group/789",
	//   },
	// ]
	//
	// Response:
	// {
	//    "abc123": { AllowedPermissions: [...] },
	//    "iam/group/456": { AllowedPermissions: [...] },
	//    "def789": { AllowedPermissions: [...] },
	//    "iam/group/789": { AllowedPermissions: [...] },
	// }
	ResourcePermissions map[string]HashicorpCloudResourcemanagerAuthorizationTestIamPermissionsResponse `json:"resource_permissions,omitempty"`
}

// Validate validates this hashicorp cloud resourcemanager batch authorization test iam permissions response
func (m *HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateResourcePermissions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse) validateResourcePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourcePermissions) { // not required
		return nil
	}

	for k := range m.ResourcePermissions {

		if err := validate.Required("resource_permissions"+"."+k, "body", m.ResourcePermissions[k]); err != nil {
			return err
		}
		if val, ok := m.ResourcePermissions[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resource_permissions" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resource_permissions" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud resourcemanager batch authorization test iam permissions response based on the context it is used
func (m *HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateResourcePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse) contextValidateResourcePermissions(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ResourcePermissions {

		if val, ok := m.ResourcePermissions[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudResourcemanagerBatchAuthorizationTestIamPermissionsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
