/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAesCtrParams.h"

#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CryptoAlgorithmAesCtrParams>> convertDictionary<CryptoAlgorithmAesCtrParams>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CryptoAlgorithmAesCtrParams result;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "AesCtrParams"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue counterValue;
    if (isNullOrUndefined)
        counterValue = jsUndefined();
    else {
        counterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "counter"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (counterValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "counter"_s, "AesCtrParams"_s, "(ArrayBufferView or ArrayBuffer)"_s);
        return ConversionResultException { };
    }
    auto counterConversionResult = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, counterValue);
    if (counterConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.counter = counterConversionResult.releaseReturnValue();
    JSValue lengthValue;
    if (isNullOrUndefined)
        lengthValue = jsUndefined();
    else {
        lengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "length"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (lengthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "length"_s, "AesCtrParams"_s, "octet"_s);
        return ConversionResultException { };
    }
    auto lengthConversionResult = convert<IDLEnforceRangeAdaptor<IDLOctet>>(lexicalGlobalObject, lengthValue);
    if (lengthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.length = lengthConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

