/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUDepthStencilState.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUCompareFunction.h"
#include "JSGPUStencilFaceState.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUDepthStencilState>> convertDictionary<GPUDepthStencilState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUDepthStencilState result;
    JSValue depthBiasValue;
    if (isNullOrUndefined)
        depthBiasValue = jsUndefined();
    else {
        depthBiasValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthBias"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthBiasConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLLong>>(lexicalGlobalObject, depthBiasValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLLong>> { return Converter<IDLEnforceRangeAdaptor<IDLLong>>::ReturnType { 0 }; });
    if (depthBiasConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.depthBias = depthBiasConversionResult.releaseReturnValue();
    JSValue depthBiasClampValue;
    if (isNullOrUndefined)
        depthBiasClampValue = jsUndefined();
    else {
        depthBiasClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthBiasClamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthBiasClampConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, depthBiasClampValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (depthBiasClampConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.depthBiasClamp = depthBiasClampConversionResult.releaseReturnValue();
    JSValue depthBiasSlopeScaleValue;
    if (isNullOrUndefined)
        depthBiasSlopeScaleValue = jsUndefined();
    else {
        depthBiasSlopeScaleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthBiasSlopeScale"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthBiasSlopeScaleConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, depthBiasSlopeScaleValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (depthBiasSlopeScaleConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.depthBiasSlopeScale = depthBiasSlopeScaleConversionResult.releaseReturnValue();
    JSValue depthCompareValue;
    if (isNullOrUndefined)
        depthCompareValue = jsUndefined();
    else {
        depthCompareValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthCompare"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthCompareValue.isUndefined()) {
        auto depthCompareConversionResult = convert<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, depthCompareValue);
        if (depthCompareConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthCompare = depthCompareConversionResult.releaseReturnValue();
    }
    JSValue depthWriteEnabledValue;
    if (isNullOrUndefined)
        depthWriteEnabledValue = jsUndefined();
    else {
        depthWriteEnabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthWriteEnabled"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthWriteEnabledValue.isUndefined()) {
        auto depthWriteEnabledConversionResult = convert<IDLBoolean>(lexicalGlobalObject, depthWriteEnabledValue);
        if (depthWriteEnabledConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthWriteEnabled = depthWriteEnabledConversionResult.releaseReturnValue();
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (formatValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format"_s, "GPUDepthStencilState"_s, "GPUTextureFormat"_s);
        return ConversionResultException { };
    }
    auto formatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
    if (formatConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue stencilBackValue;
    if (isNullOrUndefined)
        stencilBackValue = jsUndefined();
    else {
        stencilBackValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilBack"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!stencilBackValue.isUndefined()) {
        auto stencilBackConversionResult = convert<IDLDictionary<GPUStencilFaceState>>(lexicalGlobalObject, stencilBackValue);
        if (stencilBackConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.stencilBack = stencilBackConversionResult.releaseReturnValue();
    }
    JSValue stencilFrontValue;
    if (isNullOrUndefined)
        stencilFrontValue = jsUndefined();
    else {
        stencilFrontValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilFront"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!stencilFrontValue.isUndefined()) {
        auto stencilFrontConversionResult = convert<IDLDictionary<GPUStencilFaceState>>(lexicalGlobalObject, stencilFrontValue);
        if (stencilFrontConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.stencilFront = stencilFrontConversionResult.releaseReturnValue();
    }
    JSValue stencilReadMaskValue;
    if (isNullOrUndefined)
        stencilReadMaskValue = jsUndefined();
    else {
        stencilReadMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilReadMask"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stencilReadMaskConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, stencilReadMaskValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0xFFFFFFFF }; });
    if (stencilReadMaskConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.stencilReadMask = stencilReadMaskConversionResult.releaseReturnValue();
    JSValue stencilWriteMaskValue;
    if (isNullOrUndefined)
        stencilWriteMaskValue = jsUndefined();
    else {
        stencilWriteMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilWriteMask"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stencilWriteMaskConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, stencilWriteMaskValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0xFFFFFFFF }; });
    if (stencilWriteMaskConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.stencilWriteMask = stencilWriteMaskConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

