/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-qc-firehose-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_qc_firehose_functions_to_string:
 * @val: value, e.g. %FU_QC_FIREHOSE_FUNCTIONS_PROGRAM
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
gchar *
fu_qc_firehose_functions_to_string(FuQcFirehoseFunctions val)
{
    const gchar *data[19] = {0};
    guint idx = 0;
    if (val == FU_QC_FIREHOSE_FUNCTIONS_NONE)
        return g_strdup("none");
    if (val & FU_QC_FIREHOSE_FUNCTIONS_PROGRAM)
        data[idx++] = "program";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_CONFIGURE)
        data[idx++] = "configure";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_POWER)
        data[idx++] = "power";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_READ)
        data[idx++] = "read";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_GETSTORAGEINFO)
        data[idx++] = "getstorageinfo";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_ERASE)
        data[idx++] = "erase";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_NOP)
        data[idx++] = "nop";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_SETBOOTABLESTORAGEDRIVE)
        data[idx++] = "setbootablestoragedrive";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_PATCH)
        data[idx++] = "patch";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_UFS)
        data[idx++] = "ufs";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_EMMC)
        data[idx++] = "emmc";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_XML)
        data[idx++] = "xml";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_PEEK)
        data[idx++] = "peek";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_POKE)
        data[idx++] = "poke";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_FIRMWAREWRITE)
        data[idx++] = "firmwarewrite";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_BENCHMARK)
        data[idx++] = "benchmark";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_GETCRC16DIGEST)
        data[idx++] = "getcrc16digest";
    if (val & FU_QC_FIREHOSE_FUNCTIONS_GETSHA256DIGEST)
        data[idx++] = "getsha256digest";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_qc_firehose_functions_from_string:
 * @val: (nullable): a string, e.g. `program`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuQcFirehoseFunctions
fu_qc_firehose_functions_from_string(const gchar *val)
{
    FuQcFirehoseFunctions value = 0;
    g_auto(GStrv) split = NULL;
    g_return_val_if_fail(val != NULL, 0);
    split = g_strsplit(val, ",", -1);
    for (guint i = 0; split[i] != NULL; i++) {
        if (g_strcmp0(split[i], "none") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_NONE;
            continue;
        }
        if (g_strcmp0(split[i], "program") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_PROGRAM;
            continue;
        }
        if (g_strcmp0(split[i], "configure") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_CONFIGURE;
            continue;
        }
        if (g_strcmp0(split[i], "power") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_POWER;
            continue;
        }
        if (g_strcmp0(split[i], "read") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_READ;
            continue;
        }
        if (g_strcmp0(split[i], "getstorageinfo") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_GETSTORAGEINFO;
            continue;
        }
        if (g_strcmp0(split[i], "erase") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_ERASE;
            continue;
        }
        if (g_strcmp0(split[i], "nop") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_NOP;
            continue;
        }
        if (g_strcmp0(split[i], "setbootablestoragedrive") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_SETBOOTABLESTORAGEDRIVE;
            continue;
        }
        if (g_strcmp0(split[i], "patch") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_PATCH;
            continue;
        }
        if (g_strcmp0(split[i], "ufs") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_UFS;
            continue;
        }
        if (g_strcmp0(split[i], "emmc") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_EMMC;
            continue;
        }
        if (g_strcmp0(split[i], "xml") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_XML;
            continue;
        }
        if (g_strcmp0(split[i], "peek") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_PEEK;
            continue;
        }
        if (g_strcmp0(split[i], "poke") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_POKE;
            continue;
        }
        if (g_strcmp0(split[i], "firmwarewrite") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_FIRMWAREWRITE;
            continue;
        }
        if (g_strcmp0(split[i], "benchmark") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_BENCHMARK;
            continue;
        }
        if (g_strcmp0(split[i], "getcrc16digest") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_GETCRC16DIGEST;
            continue;
        }
        if (g_strcmp0(split[i], "getsha256digest") == 0) {
            value |= FU_QC_FIREHOSE_FUNCTIONS_GETSHA256DIGEST;
            continue;
        }
    }
    return value;
}

/**
 * fu_qc_firehose_sahara_command_id_to_string:
 * @val: value, e.g. %FU_QC_FIREHOSE_SAHARA_COMMAND_ID_HELLO
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_qc_firehose_sahara_command_id_to_string(FuQcFirehoseSaharaCommandId val)
{
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_NO_CMD)
        return "no-cmd";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_HELLO)
        return "hello";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_HELLO_RESPONSE)
        return "hello-response";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_READ)
        return "read";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_END_OF_IMAGE)
        return "end-of-image";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_DONE)
        return "done";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_DONE_RESPONSE)
        return "done-response";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_RESET)
        return "reset";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_RESET_RESPONSE)
        return "reset-response";
    if (val == FU_QC_FIREHOSE_SAHARA_COMMAND_ID_READ64)
        return "read64";
    return NULL;
}

/**
 * fu_qc_firehose_sahara_status_to_string:
 * @val: value, e.g. %FU_QC_FIREHOSE_SAHARA_STATUS_FAILED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_qc_firehose_sahara_status_to_string(FuQcFirehoseSaharaStatus val)
{
    if (val == FU_QC_FIREHOSE_SAHARA_STATUS_SUCCESS)
        return "success";
    if (val == FU_QC_FIREHOSE_SAHARA_STATUS_FAILED)
        return "failed";
    return NULL;
}
/**
 * fu_qc_firehose_sahara_pkt_ref: (skip):
 **/
FuQcFirehoseSaharaPkt *
fu_qc_firehose_sahara_pkt_ref(FuQcFirehoseSaharaPkt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_unref(FuQcFirehoseSaharaPkt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPkt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPkt *
fu_qc_firehose_sahara_pkt_new_internal(void)
{
    FuQcFirehoseSaharaPkt *st = g_new0(FuQcFirehoseSaharaPkt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_qc_firehose_sahara_pkt_get_command_id: (skip):
 **/
FuQcFirehoseSaharaCommandId
fu_qc_firehose_sahara_pkt_get_command_id(const FuQcFirehoseSaharaPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_get_hdr_length: (skip):
 **/
guint32
fu_qc_firehose_sahara_pkt_get_hdr_length(const FuQcFirehoseSaharaPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_to_string: (skip):
 **/
static gchar *
fu_qc_firehose_sahara_pkt_to_string(const FuQcFirehoseSaharaPkt *st)
{
    g_autoptr(GString) str = g_string_new("FuQcFirehoseSaharaPkt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_qc_firehose_sahara_command_id_to_string(fu_qc_firehose_sahara_pkt_get_command_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  command_id: 0x%x [%s]\n", (guint) fu_qc_firehose_sahara_pkt_get_command_id(st), tmp);
        } else {
            g_string_append_printf(str, "  command_id: 0x%x\n", (guint) fu_qc_firehose_sahara_pkt_get_command_id(st));
        }
    }
    g_string_append_printf(str, "  hdr_length: 0x%x\n",
                           (guint) fu_qc_firehose_sahara_pkt_get_hdr_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_qc_firehose_sahara_pkt_validate_internal(FuQcFirehoseSaharaPkt *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_qc_firehose_sahara_pkt_parse_internal(FuQcFirehoseSaharaPkt *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_qc_firehose_sahara_pkt_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_qc_firehose_sahara_pkt_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_qc_firehose_sahara_pkt_parse: (skip):
 **/
FuQcFirehoseSaharaPkt *
fu_qc_firehose_sahara_pkt_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuQcFirehoseSaharaPkt) st = fu_qc_firehose_sahara_pkt_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuQcFirehoseSaharaPkt: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_qc_firehose_sahara_pkt_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_ref: (skip):
 **/
FuQcFirehoseSaharaPktHello *
fu_qc_firehose_sahara_pkt_hello_ref(FuQcFirehoseSaharaPktHello *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_hello_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_hello_unref(FuQcFirehoseSaharaPktHello *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktHello refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktHello *
fu_qc_firehose_sahara_pkt_hello_new_internal(void)
{
    FuQcFirehoseSaharaPktHello *st = g_new0(FuQcFirehoseSaharaPktHello, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_qc_firehose_sahara_pkt_hello_get_command_id: (skip):
 **/
static FuQcFirehoseSaharaCommandId
fu_qc_firehose_sahara_pkt_hello_get_command_id(const FuQcFirehoseSaharaPktHello *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_get_mode: (skip):
 **/
guint32
fu_qc_firehose_sahara_pkt_hello_get_mode(const FuQcFirehoseSaharaPktHello *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_hello_to_string: (skip):
 **/
static gchar *
fu_qc_firehose_sahara_pkt_hello_to_string(const FuQcFirehoseSaharaPktHello *st)
{
    g_autoptr(GString) str = g_string_new("FuQcFirehoseSaharaPktHello:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  mode: 0x%x\n",
                           (guint) fu_qc_firehose_sahara_pkt_hello_get_mode(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_qc_firehose_sahara_pkt_hello_validate_internal(FuQcFirehoseSaharaPktHello *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_qc_firehose_sahara_pkt_hello_get_command_id(st) != FU_QC_FIREHOSE_SAHARA_COMMAND_ID_HELLO) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktHello.command_id was not valid, "
                    "expected 'FuQcFirehoseSaharaCommandId' and got '%s'",
                    fu_qc_firehose_sahara_command_id_to_string(fu_qc_firehose_sahara_pkt_hello_get_command_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_qc_firehose_sahara_pkt_hello_parse_internal(FuQcFirehoseSaharaPktHello *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_qc_firehose_sahara_pkt_hello_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_qc_firehose_sahara_pkt_hello_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_qc_firehose_sahara_pkt_hello_parse: (skip):
 **/
FuQcFirehoseSaharaPktHello *
fu_qc_firehose_sahara_pkt_hello_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuQcFirehoseSaharaPktHello) st = fu_qc_firehose_sahara_pkt_hello_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error_literal(error, "invalid struct FuQcFirehoseSaharaPktHello: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 24);
    if (!fu_qc_firehose_sahara_pkt_hello_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_ref: (skip):
 **/
FuQcFirehoseSaharaPktHelloResp *
fu_qc_firehose_sahara_pkt_hello_resp_ref(FuQcFirehoseSaharaPktHelloResp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_hello_resp_unref(FuQcFirehoseSaharaPktHelloResp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktHelloResp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktHelloResp *
fu_qc_firehose_sahara_pkt_hello_resp_new_internal(void)
{
    FuQcFirehoseSaharaPktHelloResp *st = g_new0(FuQcFirehoseSaharaPktHelloResp, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_set_command_id: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_hello_resp_set_command_id(FuQcFirehoseSaharaPktHelloResp *st, FuQcFirehoseSaharaCommandId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_set_hdr_length: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_hello_resp_set_hdr_length(FuQcFirehoseSaharaPktHelloResp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_set_version: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_hello_resp_set_version(FuQcFirehoseSaharaPktHelloResp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_set_compatible: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_hello_resp_set_compatible(FuQcFirehoseSaharaPktHelloResp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_set_status: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_hello_resp_set_status(FuQcFirehoseSaharaPktHelloResp *st, FuQcFirehoseSaharaStatus value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_set_mode: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_hello_resp_set_mode(FuQcFirehoseSaharaPktHelloResp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_hello_resp_new: (skip):
 **/
FuQcFirehoseSaharaPktHelloResp *
fu_qc_firehose_sahara_pkt_hello_resp_new(void)
{
    FuQcFirehoseSaharaPktHelloResp *st = fu_qc_firehose_sahara_pkt_hello_resp_new_internal();
    st->buf = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st->buf, 48, 0x0);
    fu_qc_firehose_sahara_pkt_hello_resp_set_command_id(st, FU_QC_FIREHOSE_SAHARA_COMMAND_ID_HELLO_RESPONSE);
    fu_qc_firehose_sahara_pkt_hello_resp_set_hdr_length(st, 48);
    fu_qc_firehose_sahara_pkt_hello_resp_set_version(st, 2);
    fu_qc_firehose_sahara_pkt_hello_resp_set_compatible(st, 1);
    fu_qc_firehose_sahara_pkt_hello_resp_set_status(st, FU_QC_FIREHOSE_SAHARA_STATUS_SUCCESS);
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_read_ref: (skip):
 **/
FuQcFirehoseSaharaPktRead *
fu_qc_firehose_sahara_pkt_read_ref(FuQcFirehoseSaharaPktRead *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_read_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_read_unref(FuQcFirehoseSaharaPktRead *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktRead refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_read_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktRead *
fu_qc_firehose_sahara_pkt_read_new_internal(void)
{
    FuQcFirehoseSaharaPktRead *st = g_new0(FuQcFirehoseSaharaPktRead, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_qc_firehose_sahara_pkt_read_get_command_id: (skip):
 **/
static FuQcFirehoseSaharaCommandId
fu_qc_firehose_sahara_pkt_read_get_command_id(const FuQcFirehoseSaharaPktRead *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_read_get_hdr_length: (skip):
 **/
static guint32
fu_qc_firehose_sahara_pkt_read_get_hdr_length(const FuQcFirehoseSaharaPktRead *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_read_get_offset: (skip):
 **/
guint32
fu_qc_firehose_sahara_pkt_read_get_offset(const FuQcFirehoseSaharaPktRead *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_read_get_length: (skip):
 **/
guint32
fu_qc_firehose_sahara_pkt_read_get_length(const FuQcFirehoseSaharaPktRead *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_read_to_string: (skip):
 **/
static gchar *
fu_qc_firehose_sahara_pkt_read_to_string(const FuQcFirehoseSaharaPktRead *st)
{
    g_autoptr(GString) str = g_string_new("FuQcFirehoseSaharaPktRead:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_qc_firehose_sahara_pkt_read_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_qc_firehose_sahara_pkt_read_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_qc_firehose_sahara_pkt_read_validate_internal(FuQcFirehoseSaharaPktRead *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_qc_firehose_sahara_pkt_read_get_command_id(st) != FU_QC_FIREHOSE_SAHARA_COMMAND_ID_READ) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktRead.command_id was not valid, "
                    "expected 'FuQcFirehoseSaharaCommandId' and got '%s'",
                    fu_qc_firehose_sahara_command_id_to_string(fu_qc_firehose_sahara_pkt_read_get_command_id(st)));
        return FALSE;
    }
    if (fu_qc_firehose_sahara_pkt_read_get_hdr_length(st) != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktRead.hdr_length was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) fu_qc_firehose_sahara_pkt_read_get_hdr_length(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_qc_firehose_sahara_pkt_read_parse_internal(FuQcFirehoseSaharaPktRead *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_qc_firehose_sahara_pkt_read_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_qc_firehose_sahara_pkt_read_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_qc_firehose_sahara_pkt_read_parse: (skip):
 **/
FuQcFirehoseSaharaPktRead *
fu_qc_firehose_sahara_pkt_read_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuQcFirehoseSaharaPktRead) st = fu_qc_firehose_sahara_pkt_read_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuQcFirehoseSaharaPktRead: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 20);
    if (!fu_qc_firehose_sahara_pkt_read_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_qc_firehose_sahara_pkt_read64_ref: (skip):
 **/
FuQcFirehoseSaharaPktRead64 *
fu_qc_firehose_sahara_pkt_read64_ref(FuQcFirehoseSaharaPktRead64 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_read64_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_read64_unref(FuQcFirehoseSaharaPktRead64 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktRead64 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_read64_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktRead64 *
fu_qc_firehose_sahara_pkt_read64_new_internal(void)
{
    FuQcFirehoseSaharaPktRead64 *st = g_new0(FuQcFirehoseSaharaPktRead64, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_qc_firehose_sahara_pkt_read64_get_command_id: (skip):
 **/
static FuQcFirehoseSaharaCommandId
fu_qc_firehose_sahara_pkt_read64_get_command_id(const FuQcFirehoseSaharaPktRead64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_read64_get_hdr_length: (skip):
 **/
static guint32
fu_qc_firehose_sahara_pkt_read64_get_hdr_length(const FuQcFirehoseSaharaPktRead64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_read64_get_offset: (skip):
 **/
guint64
fu_qc_firehose_sahara_pkt_read64_get_offset(const FuQcFirehoseSaharaPktRead64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_read64_get_length: (skip):
 **/
guint64
fu_qc_firehose_sahara_pkt_read64_get_length(const FuQcFirehoseSaharaPktRead64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_read64_to_string: (skip):
 **/
static gchar *
fu_qc_firehose_sahara_pkt_read64_to_string(const FuQcFirehoseSaharaPktRead64 *st)
{
    g_autoptr(GString) str = g_string_new("FuQcFirehoseSaharaPktRead64:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_qc_firehose_sahara_pkt_read64_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_qc_firehose_sahara_pkt_read64_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_qc_firehose_sahara_pkt_read64_validate_internal(FuQcFirehoseSaharaPktRead64 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_qc_firehose_sahara_pkt_read64_get_command_id(st) != FU_QC_FIREHOSE_SAHARA_COMMAND_ID_READ64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktRead64.command_id was not valid, "
                    "expected 'FuQcFirehoseSaharaCommandId' and got '%s'",
                    fu_qc_firehose_sahara_command_id_to_string(fu_qc_firehose_sahara_pkt_read64_get_command_id(st)));
        return FALSE;
    }
    if (fu_qc_firehose_sahara_pkt_read64_get_hdr_length(st) != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktRead64.hdr_length was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) fu_qc_firehose_sahara_pkt_read64_get_hdr_length(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_qc_firehose_sahara_pkt_read64_parse_internal(FuQcFirehoseSaharaPktRead64 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_qc_firehose_sahara_pkt_read64_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_qc_firehose_sahara_pkt_read64_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_qc_firehose_sahara_pkt_read64_parse: (skip):
 **/
FuQcFirehoseSaharaPktRead64 *
fu_qc_firehose_sahara_pkt_read64_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuQcFirehoseSaharaPktRead64) st = fu_qc_firehose_sahara_pkt_read64_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error_literal(error, "invalid struct FuQcFirehoseSaharaPktRead64: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 32);
    if (!fu_qc_firehose_sahara_pkt_read64_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_ref: (skip):
 **/
FuQcFirehoseSaharaPktEndOfImage *
fu_qc_firehose_sahara_pkt_end_of_image_ref(FuQcFirehoseSaharaPktEndOfImage *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_end_of_image_unref(FuQcFirehoseSaharaPktEndOfImage *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktEndOfImage refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktEndOfImage *
fu_qc_firehose_sahara_pkt_end_of_image_new_internal(void)
{
    FuQcFirehoseSaharaPktEndOfImage *st = g_new0(FuQcFirehoseSaharaPktEndOfImage, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_get_command_id: (skip):
 **/
static FuQcFirehoseSaharaCommandId
fu_qc_firehose_sahara_pkt_end_of_image_get_command_id(const FuQcFirehoseSaharaPktEndOfImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_get_hdr_length: (skip):
 **/
static guint32
fu_qc_firehose_sahara_pkt_end_of_image_get_hdr_length(const FuQcFirehoseSaharaPktEndOfImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_get_status: (skip):
 **/
FuQcFirehoseSaharaStatus
fu_qc_firehose_sahara_pkt_end_of_image_get_status(const FuQcFirehoseSaharaPktEndOfImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_end_of_image_to_string: (skip):
 **/
static gchar *
fu_qc_firehose_sahara_pkt_end_of_image_to_string(const FuQcFirehoseSaharaPktEndOfImage *st)
{
    g_autoptr(GString) str = g_string_new("FuQcFirehoseSaharaPktEndOfImage:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_qc_firehose_sahara_status_to_string(fu_qc_firehose_sahara_pkt_end_of_image_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_qc_firehose_sahara_pkt_end_of_image_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_qc_firehose_sahara_pkt_end_of_image_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_qc_firehose_sahara_pkt_end_of_image_validate_internal(FuQcFirehoseSaharaPktEndOfImage *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_qc_firehose_sahara_pkt_end_of_image_get_command_id(st) != FU_QC_FIREHOSE_SAHARA_COMMAND_ID_END_OF_IMAGE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktEndOfImage.command_id was not valid, "
                    "expected 'FuQcFirehoseSaharaCommandId' and got '%s'",
                    fu_qc_firehose_sahara_command_id_to_string(fu_qc_firehose_sahara_pkt_end_of_image_get_command_id(st)));
        return FALSE;
    }
    if (fu_qc_firehose_sahara_pkt_end_of_image_get_hdr_length(st) != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktEndOfImage.hdr_length was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) fu_qc_firehose_sahara_pkt_end_of_image_get_hdr_length(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_qc_firehose_sahara_pkt_end_of_image_parse_internal(FuQcFirehoseSaharaPktEndOfImage *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_qc_firehose_sahara_pkt_end_of_image_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_qc_firehose_sahara_pkt_end_of_image_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_qc_firehose_sahara_pkt_end_of_image_parse: (skip):
 **/
FuQcFirehoseSaharaPktEndOfImage *
fu_qc_firehose_sahara_pkt_end_of_image_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuQcFirehoseSaharaPktEndOfImage) st = fu_qc_firehose_sahara_pkt_end_of_image_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuQcFirehoseSaharaPktEndOfImage: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 16);
    if (!fu_qc_firehose_sahara_pkt_end_of_image_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_qc_firehose_sahara_pkt_done_ref: (skip):
 **/
FuQcFirehoseSaharaPktDone *
fu_qc_firehose_sahara_pkt_done_ref(FuQcFirehoseSaharaPktDone *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_done_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_done_unref(FuQcFirehoseSaharaPktDone *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktDone refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_done_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktDone *
fu_qc_firehose_sahara_pkt_done_new_internal(void)
{
    FuQcFirehoseSaharaPktDone *st = g_new0(FuQcFirehoseSaharaPktDone, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_done_set_command_id: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_done_set_command_id(FuQcFirehoseSaharaPktDone *st, FuQcFirehoseSaharaCommandId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_done_set_hdr_length: (skip):
 **/
static void
fu_qc_firehose_sahara_pkt_done_set_hdr_length(FuQcFirehoseSaharaPktDone *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_done_new: (skip):
 **/
FuQcFirehoseSaharaPktDone *
fu_qc_firehose_sahara_pkt_done_new(void)
{
    FuQcFirehoseSaharaPktDone *st = fu_qc_firehose_sahara_pkt_done_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_qc_firehose_sahara_pkt_done_set_command_id(st, FU_QC_FIREHOSE_SAHARA_COMMAND_ID_DONE);
    fu_qc_firehose_sahara_pkt_done_set_hdr_length(st, 8);
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_done_resp_ref: (skip):
 **/
FuQcFirehoseSaharaPktDoneResp *
fu_qc_firehose_sahara_pkt_done_resp_ref(FuQcFirehoseSaharaPktDoneResp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_qc_firehose_sahara_pkt_done_resp_unref: (skip):
 **/
void
fu_qc_firehose_sahara_pkt_done_resp_unref(FuQcFirehoseSaharaPktDoneResp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuQcFirehoseSaharaPktDoneResp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_qc_firehose_sahara_pkt_done_resp_new_internal: (skip):
 **/
static FuQcFirehoseSaharaPktDoneResp *
fu_qc_firehose_sahara_pkt_done_resp_new_internal(void)
{
    FuQcFirehoseSaharaPktDoneResp *st = g_new0(FuQcFirehoseSaharaPktDoneResp, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_qc_firehose_sahara_pkt_done_resp_get_command_id: (skip):
 **/
static FuQcFirehoseSaharaCommandId
fu_qc_firehose_sahara_pkt_done_resp_get_command_id(const FuQcFirehoseSaharaPktDoneResp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_done_resp_get_hdr_length: (skip):
 **/
static guint32
fu_qc_firehose_sahara_pkt_done_resp_get_hdr_length(const FuQcFirehoseSaharaPktDoneResp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_qc_firehose_sahara_pkt_done_resp_get_status: (skip):
 **/
FuQcFirehoseSaharaStatus
fu_qc_firehose_sahara_pkt_done_resp_get_status(const FuQcFirehoseSaharaPktDoneResp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_qc_firehose_sahara_pkt_done_resp_to_string: (skip):
 **/
static gchar *
fu_qc_firehose_sahara_pkt_done_resp_to_string(const FuQcFirehoseSaharaPktDoneResp *st)
{
    g_autoptr(GString) str = g_string_new("FuQcFirehoseSaharaPktDoneResp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_qc_firehose_sahara_status_to_string(fu_qc_firehose_sahara_pkt_done_resp_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_qc_firehose_sahara_pkt_done_resp_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_qc_firehose_sahara_pkt_done_resp_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_qc_firehose_sahara_pkt_done_resp_validate_internal(FuQcFirehoseSaharaPktDoneResp *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_qc_firehose_sahara_pkt_done_resp_get_command_id(st) != FU_QC_FIREHOSE_SAHARA_COMMAND_ID_DONE_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktDoneResp.command_id was not valid, "
                    "expected 'FuQcFirehoseSaharaCommandId' and got '%s'",
                    fu_qc_firehose_sahara_command_id_to_string(fu_qc_firehose_sahara_pkt_done_resp_get_command_id(st)));
        return FALSE;
    }
    if (fu_qc_firehose_sahara_pkt_done_resp_get_hdr_length(st) != 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuQcFirehoseSaharaPktDoneResp.hdr_length was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 12,
                    (guint) fu_qc_firehose_sahara_pkt_done_resp_get_hdr_length(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_qc_firehose_sahara_pkt_done_resp_parse_internal(FuQcFirehoseSaharaPktDoneResp *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_qc_firehose_sahara_pkt_done_resp_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_qc_firehose_sahara_pkt_done_resp_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_qc_firehose_sahara_pkt_done_resp_parse: (skip):
 **/
FuQcFirehoseSaharaPktDoneResp *
fu_qc_firehose_sahara_pkt_done_resp_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuQcFirehoseSaharaPktDoneResp) st = fu_qc_firehose_sahara_pkt_done_resp_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuQcFirehoseSaharaPktDoneResp: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 12);
    if (!fu_qc_firehose_sahara_pkt_done_resp_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
