/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.ExpiringErrorCache;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.quota.ControllerMutationQuota;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001b\u0001\u0005\u0002)Dqa\u001d\u0001C\u0002\u0013%A\u000fC\u0004\u0002\u0012\u0001\u0001\u000b\u0011B;\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0006\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002X\u0002!I!!7\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqA!\u000b\u0001\t\u0003\u0012YcB\u0005\u0003.}\t\t\u0011#\u0001\u00030\u0019AadHA\u0001\u0012\u0003\u0011\t\u0004\u0003\u0004j7\u0011\u0005!1\u0007\u0005\n\u0005kY\u0012\u0013!C\u0001\u0005o\u0011q\u0004R3gCVdG/Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0015\t\u0001\u0013%\u0001\u0004tKJ4XM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001&W=\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005y\u0012B\u0001\u0018 \u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\t\u0003aMj\u0011!\r\u0006\u0003e\u0005\nQ!\u001e;jYNL!\u0001N\u0019\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001L\u001c\n\u0005az\"aC&bM.\f7i\u001c8gS\u001e\fab\u00195b]:,G.T1oC\u001e,'\u000f\u0005\u0002<\t6\tAH\u0003\u0002>}\u000511m\\7n_:T!\u0001I \u000b\u0005\t\u0002%BA!C\u0003\u0019\t\u0007/Y2iK*\t1)A\u0002pe\u001eL!!\u0012\u001f\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s!\tAU*D\u0001J\u0015\tQ5*A\u0003he>,\bO\u0003\u0002M\u007f\u0005Y1m\\8sI&t\u0017\r^8s\u0013\tq\u0015J\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\bCA)V\u001b\u0005\u0011&BA*U\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u00051\u000b\u0013B\u0001,S\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\u0018\u0001E:iCJ,7i\\8sI&t\u0017\r^8s!\tIF,D\u0001[\u0015\tY6*A\u0003tQ\u0006\u0014X-\u0003\u0002^5\n\u00012\u000b[1sK\u000e{wN\u001d3j]\u0006$xN]\u0001\u0005i&lW\r\u0005\u0002aG6\t\u0011M\u0003\u00023E*\u0011QhP\u0005\u0003I\u0006\u0014A\u0001V5nK\u00069Bo\u001c9jG\u0016\u0013(o\u001c:DC\u000eDWmQ1qC\u000eLG/\u001f\t\u0003M\u001dL!\u0001[\u0014\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\tW2lgn\u001c9reB\u0011A\u0006\u0001\u0005\u0006k!\u0001\rA\u000e\u0005\u0006s!\u0001\rA\u000f\u0005\u0006\r\"\u0001\ra\u0012\u0005\u0006\u001f\"\u0001\r\u0001\u0015\u0005\u0006/\"\u0001\r\u0001\u0017\u0005\u0006=\"\u0001\ra\u0018\u0005\bK\"\u0001\n\u00111\u0001g\u00039IgN\u001a7jO\"$Hk\u001c9jGN,\u0012!\u001e\t\u0004mnlX\"A<\u000b\u0005aL\u0018\u0001B;uS2T\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}o\n\u00191+\u001a;\u0011\u0007y\fYAD\u0002\u0000\u0003\u000f\u00012!!\u0001(\u001b\t\t\u0019AC\u0002\u0002\u0006\r\na\u0001\u0010:p_Rt\u0014bAA\u0005O\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u0003(\u0003=IgN\u001a7jO\"$Hk\u001c9jGN\u0004\u0013a\u0006;pa&\u001c7I]3bi&|g.\u0012:s_J\u001c\u0015m\u00195f+\t\t9\u0002E\u0002-\u00033I1!a\u0007 \u0005I)\u0005\u0010]5sS:<WI\u001d:pe\u000e\u000b7\r[3\u00021Q|\u0007/[2De\u0016\fG/[8o\u000bJ\u0014xN]\"bG\",\u0007%\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0005\u0002$\u0005U\u0013QLA7!\u0019\t)#a\u000b\u000205\u0011\u0011q\u0005\u0006\u0004\u0003S9\u0013AC2pY2,7\r^5p]&!\u0011QFA\u0014\u0005\r\u0019V-\u001d\t\u0005\u0003c\tyE\u0004\u0003\u00024\u0005%c\u0002BA\u001b\u0003\u000brA!a\u000e\u0002D9!\u0011\u0011HA!\u001d\u0011\tY$a\u0010\u000f\t\u0005\u0005\u0011QH\u0005\u0002\u0007&\u0011\u0011IQ\u0005\u0003E\u0001K!!P \n\u0007\u0005\u001d#-A\u0004nKN\u001c\u0018mZ3\n\t\u0005-\u0013QJ\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\u000b\u0007\u0005\u001d#-\u0003\u0003\u0002R\u0005M#!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0006\u0005\u0003\u0017\ni\u0005C\u0004\u0002X5\u0001\r!!\u0017\u0002\rQ|\u0007/[2t!\u0015\t)#a\u0017~\u0013\ra\u0018q\u0005\u0005\b\u0003?j\u0001\u0019AA1\u0003]\u0019wN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\r\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9GP\u0001\u0006cV|G/Y\u0005\u0005\u0003W\n)GA\fD_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC\"9\u0011qN\u0007A\u0002\u0005E\u0014AF7fi\u0006$\u0017\r^1SKF,Xm\u001d;D_:$X\r\u001f;\u0011\u000b\u0019\n\u0019(a\u001e\n\u0007\u0005UtE\u0001\u0004PaRLwN\u001c\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u00102\u0002\u0011I,\u0017/^3tiNLA!!!\u0002|\tq!+Z9vKN$8i\u001c8uKb$\u0018aG2sK\u0006$Xm\u0015;sK\u0006l7/\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000f\u0006\u0005\u0002\b\u00065\u00151UAT!\r1\u0013\u0011R\u0005\u0004\u0003\u0017;#\u0001B+oSRDq!a\u0016\u000f\u0001\u0004\ty\tE\u0004\u0002&\u0005EU0!&\n\t\u0005M\u0015q\u0005\u0002\u0004\u001b\u0006\u0004\b\u0003BAL\u0003;sA!a\r\u0002\u001a&!\u00111TA'\u0003]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002 \u0006\u0005&AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u00037\u000bi\u0005C\u0004\u0002&:\u0001\r!a\u001e\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yi\"9\u0011\u0011\u0016\bA\u0002\u0005-\u0016!\u0003;j[\u0016|W\u000f^'t!\r1\u0013QV\u0005\u0004\u0003_;#\u0001\u0002'p]\u001e\fQeZ3u'R\u0014X-Y7t\u0013:$XM\u001d8bYR{\u0007/[2De\u0016\fG/[8o\u000bJ\u0014xN]:\u0015\r\u0005U\u0016qWA^!\u0019\t)#!%~{\"9\u0011\u0011X\bA\u0002\u0005e\u0013A\u0003;pa&\u001cg*Y7fg\"9\u0011QX\bA\u0002\u0005-\u0016!D2veJ,g\u000e\u001e+j[\u0016l5/\u0001\ftK:$7I]3bi\u0016$v\u000e]5d%\u0016\fX/Z:u)\u0019\t\u0019#a1\u0002H\"9\u0011Q\u0019\tA\u0002\u0005=\u0015aD2sK\u0006$\u0018M\u00197f)>\u0004\u0018nY:\t\u000f\u0005\u0015\u0006\u00031\u0001\u0002r\u0005)2\r\\3be&sg\r\\5hQR\u0014V-];fgR\u001cH\u0003BAD\u0003\u001bDq!!2\u0012\u0001\u0004\ty)\u0001\bde\u0016\fG/\u00192mKR{\u0007/[2\u0015\t\u0005U\u00151\u001b\u0005\u0007\u0003+\u0014\u0002\u0019A?\u0002\u000bQ|\u0007/[2\u0002?\r|gN^3siR{Gk\u001c9jG\u000e{gNZ5h\u0007>dG.Z2uS>t7\u000f\u0006\u0003\u0002\\\u0006\u0005\b\u0003BAL\u0003;LA!a8\u0002\"\nq2I]3bi\u0006\u0014G.\u001a+pa&\u001c7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0007kM\u0001\r!a9\u0011\u0007Y\f)/C\u0002\u0002h^\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003AI7OV1mS\u0012$v\u000e]5d\u001d\u0006lW\r\u0006\u0003\u0002n\u0006M\bc\u0001\u0014\u0002p&\u0019\u0011\u0011_\u0014\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\u001b\u000bA\u0002u\fQCZ5mi\u0016\u00148I]3bi\u0006\u0014G.\u001a+pa&\u001c7\u000f\u0006\u0003\u0002z\u0006}\bc\u0002\u0014\u0002|\u0006=\u00151E\u0005\u0004\u0003{<#A\u0002+va2,'\u0007C\u0004\u0002XU\u0001\r!!\u0017\u0002MM,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR<\u0016\u000e\u001e5FeJ|'oQ1dQ&tw\r\u0006\u0005\u0002$\t\u0015!q\u0001B\u0005\u0011\u001d\t)M\u0006a\u0001\u0003\u001fCq!!*\u0017\u0001\u0004\t\t\bC\u0004\u0002*Z\u0001\r!a+\u00021\r\f7\r[3U_BL7m\u0011:fCRLwN\\#se>\u00148\u000f\u0006\u0005\u0002\b\n=!\u0011\u0003B\u000b\u0011\u001d\tIl\u0006a\u0001\u00033BaAa\u0005\u0018\u0001\u0004i\u0018\u0001D3se>\u0014X*Z:tC\u001e,\u0007b\u0002B\f/\u0001\u0007\u00111V\u0001\u0006iRdWj]\u0001%G\u0006\u001c\u0007.\u001a+pa&\u001c7I]3bi&|g.\u0012:s_J\u001chI]8n%\u0016\u001c\bo\u001c8tKR1\u0011q\u0011B\u000f\u0005OAqAa\b\u0019\u0001\u0004\u0011\t#\u0001\u0005sKN\u0004xN\\:f!\u0011\tIHa\t\n\t\t\u0015\u00121\u0010\u0002\u0015\u0007J,\u0017\r^3U_BL7m\u001d*fgB|gn]3\t\u000f\t]\u0001\u00041\u0001\u0002,\u0006)1\r\\8tKR\u0011\u0011qQ\u0001 \t\u00164\u0017-\u001e7u\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014\bC\u0001\u0017\u001c'\tYR\u0005\u0006\u0002\u00030\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"A!\u000f+\u0007\u0019\u0014Yd\u000b\u0002\u0003>A!!q\bB%\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013!C;oG\",7m[3e\u0015\r\u00119eJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B&\u0005\u0003\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final NodeToControllerChannelManager channelManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ShareCoordinator shareCoordinator;
    private final Time time;
    private final java.util.Set<String> inflightTopics;
    private final ExpiringErrorCache topicCreationErrorCache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$7() {
        return 1000;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    private ExpiringErrorCache topicCreationErrorCache() {
        return this.topicCreationErrorCache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = var5_5.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, metadataRequestContext);
        return (Seq)var6_6.$plus$plus(creatableTopicResponses);
    }

    @Override
    public void createStreamsInternalTopics(Map<String, CreateTopicsRequestData.CreatableTopic> topics, RequestContext requestContext, long timeoutMs) {
        if (topics.isEmpty()) {
            return;
        }
        long currentTimeMs = this.time.milliseconds();
        Map topicsToCreate = (Map)topics.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$createStreamsInternalTopics$1(this, currentTimeMs, x0$1)));
        if (topicsToCreate.nonEmpty()) {
            this.sendCreateTopicRequestWithErrorCaching((Map<String, CreateTopicsRequestData.CreatableTopic>)topicsToCreate, (Option<RequestContext>)new Some((Object)requestContext), timeoutMs);
            return;
        }
    }

    @Override
    public Map<String, String> getStreamsInternalTopicCreationErrors(Set<String> topicNames, long currentTimeMs) {
        return this.topicCreationErrorCache().getErrorsForTopics(topicNames, currentTimeMs);
    }

    /*
     * Unable to fully structure code
     */
    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> requestContext) {
        topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(this.config.requestTimeoutMs()).setTopics(topicsToCreate));
        requestHeaderForParsing = requestContext.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$sendCreateTopicRequest$1(kafka.server.DefaultAutoTopicCreationManager org.apache.kafka.common.requests.RequestContext ), (Lorg/apache/kafka/common/requests/RequestContext;)Lorg/apache/kafka/common/requests/RequestHeader;)((DefaultAutoTopicCreationManager)this));
        requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics, requestHeaderForParsing){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;
            private final Option requestHeaderForParsing$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation timed out for " + $this.creatableTopics$1.keys() + ".");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with authentication exception");
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with invalid version exception");
                    return;
                }
                if (response.hasResponse()) {
                    AbstractResponse abstractResponse = response.responseBody();
                    if (abstractResponse instanceof EnvelopeResponse) {
                        Errors envelopeError;
                        EnvelopeResponse envelopeResponse = (EnvelopeResponse)abstractResponse;
                        Errors errors = envelopeError = envelopeResponse.error();
                        Errors errors2 = Errors.NONE;
                        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                            this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with envelope error: " + envelopeError);
                        } else {
                            Option option = this.requestHeaderForParsing$1;
                            if (option instanceof Some) {
                                RequestHeader requestHeader = (RequestHeader)((Some)option).value();
                                try {
                                    ((CreateTopicsResponse)AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)requestHeader)).data().topics().forEach(topicResult -> {
                                        Errors error;
                                        Errors errors = error = Errors.forCode((short)topicResult.errorCode());
                                        Errors errors2 = Errors.NONE;
                                        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                                            $this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + topicResult.name() + " with error '" + error.name() + "': " + topicResult.errorMessage());
                                            return;
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to parse envelope response for auto topic creation of " + $this.creatableTopics$1.keys(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                                }
                            } else {
                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot parse envelope response without original request header information");
                            }
                        }
                    } else if (abstractResponse instanceof CreateTopicsResponse) {
                        ((CreateTopicsResponse)abstractResponse).data().topics().forEach(topicResult -> {
                            Errors error;
                            Errors errors = error = Errors.forCode((short)topicResult.errorCode());
                            Errors errors2 = Errors.NONE;
                            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                                $this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + topicResult.name() + " with error '" + error.name() + "': " + topicResult.errorMessage());
                                return;
                            }
                        });
                    } else {
                        this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation request received unexpected response type: " + abstractResponse.getClass().getSimpleName());
                    }
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation completed for " + $this.creatableTopics$1.keys() + " with response " + response.responseBody() + ".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
                this.requestHeaderForParsing$1 = requestHeaderForParsing$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$2 ), $anonfun$onComplete$10(org.apache.kafka.common.message.CreateTopicsResponseData$CreatableTopicResult org.apache.kafka.common.protocol.Errors ), $anonfun$onComplete$11(org.apache.kafka.common.requests.AbstractResponse ), $anonfun$onComplete$12(kafka.server.DefaultAutoTopicCreationManager$$anon$2 org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$2 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$2 org.apache.kafka.common.protocol.Errors ), $anonfun$onComplete$5(org.apache.kafka.common.message.CreateTopicsResponseData$CreatableTopicResult org.apache.kafka.common.protocol.Errors ), $anonfun$onComplete$6(kafka.server.DefaultAutoTopicCreationManager$$anon$2 ), $anonfun$onComplete$7(java.lang.Exception ), $anonfun$onComplete$8(), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$2 )}, serializedLambda);
            }
        };
        if (!(requestContext instanceof Some)) ** GOTO lbl-1000
        context = (RequestContext)((Some)requestContext).value();
        if (requestHeaderForParsing instanceof Some) {
            requestHeader = (RequestHeader)((Some)requestHeaderForParsing).value();
            v0 = ForwardingManager$.MODULE$.buildEnvelopeRequest(context, createTopicsRequest.build(requestHeader.apiVersion()).serializeWithHeader(requestHeader));
        } else lbl-1000:
        // 2 sources

        {
            v0 = createTopicsRequest;
        }
        request = v0;
        this.channelManager.sendRequest((AbstractRequest.Builder)request, requestCompletionHandler);
        creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$sendCreateTopicRequest$2(java.lang.String ), (Ljava/lang/String;)Lorg/apache/kafka/common/message/MetadataResponseData$MetadataResponseTopic;)());
        this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$sendCreateTopicRequest$3(scala.collection.Map ), ()Ljava/lang/String;)(creatableTopics));
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Cleared inflight topic creation state for " + creatableTopics);
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        switch (topic == null ? 0 : topic.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(topic)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.groupCoordinatorConfig().offsetsTopicPartitions()).setReplicationFactor(this.config.groupCoordinatorConfig().offsetsTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs()));
            }
            case -253293552: {
                if (!"__transaction_state".equals(topic)) break;
                TransactionLogConfig transactionLogConfig = new TransactionLogConfig((AbstractConfig)this.config);
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(transactionLogConfig.transactionTopicPartitions()).setReplicationFactor(transactionLogConfig.transactionTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
            case -81655151: {
                if (!"__share_group_state".equals(topic)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()).setReplicationFactor(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.shareCoordinator.shareGroupStateTopicConfigs()));
            }
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private CreateTopicsRequestData.CreatableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        CreateTopicsRequestData.CreatableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreatableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return topicConfigs;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable)topic -> {
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                return uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(validationError)) {
                return creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            }
            throw new MatchError((Object)validationError);
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    /*
     * Unable to fully structure code
     */
    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequestWithErrorCaching(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> requestContext, long timeoutMs) {
        topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(this.config.requestTimeoutMs()).setTopics(topicsToCreate));
        requestHeaderForParsing = requestContext.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$sendCreateTopicRequestWithErrorCaching$1(kafka.server.DefaultAutoTopicCreationManager org.apache.kafka.common.requests.RequestContext ), (Lorg/apache/kafka/common/requests/RequestContext;)Lorg/apache/kafka/common/requests/RequestHeader;)((DefaultAutoTopicCreationManager)this));
        requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics, timeoutMs, requestHeaderForParsing){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$4;
            private final long timeoutMs$1;
            private final Option requestHeaderForParsing$2;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$4);
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation timed out for " + $this.creatableTopics$4.keys() + ".");
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), "Auto topic creation timed out.", this.timeoutMs$1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$4);
                if (response.authenticationException() != null) {
                    AuthenticationException authException = response.authenticationException();
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$4.keys() + " with authentication exception: " + authException.getMessage());
                    this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), authException.getMessage(), this.timeoutMs$1);
                    return;
                }
                if (response.versionMismatch() != null) {
                    UnsupportedVersionException versionException = response.versionMismatch();
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$4.keys() + " with version mismatch exception: " + versionException.getMessage());
                    this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), versionException.getMessage(), this.timeoutMs$1);
                    return;
                }
                if (!response.hasResponse()) return;
                AbstractResponse abstractResponse = response.responseBody();
                if (abstractResponse instanceof EnvelopeResponse) {
                    Errors envelopeError;
                    EnvelopeResponse envelopeResponse = (EnvelopeResponse)abstractResponse;
                    Errors errors = envelopeError = envelopeResponse.error();
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$4.keys() + " with envelope error: " + envelopeError);
                        this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), "Envelope error: " + envelopeError, this.timeoutMs$1);
                    } else {
                        Option option = this.requestHeaderForParsing$2;
                        if (option instanceof Some) {
                            RequestHeader requestHeader = (RequestHeader)((Some)option).value();
                            try {
                                CreateTopicsResponse createTopicsResponse = (CreateTopicsResponse)AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)requestHeader);
                                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrorsFromResponse(createTopicsResponse, this.timeoutMs$1);
                            }
                            catch (Exception e) {
                                this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to parse envelope response for auto topic creation of " + $this.creatableTopics$4.keys(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), "Response parsing error: " + e.getMessage(), this.timeoutMs$1);
                            }
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot parse envelope response without original request header information");
                            this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), "Missing request header for envelope parsing", this.timeoutMs$1);
                        }
                    }
                } else if (abstractResponse instanceof CreateTopicsResponse) {
                    CreateTopicsResponse createTopicsResponse = (CreateTopicsResponse)abstractResponse;
                    this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrorsFromResponse(createTopicsResponse, this.timeoutMs$1);
                } else {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation request received unexpected response type: " + abstractResponse.getClass().getSimpleName());
                    this.$outer.kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors((Set<String>)this.creatableTopics$4.keys().toSet(), "Unexpected response type: " + abstractResponse.getClass().getSimpleName(), this.timeoutMs$1);
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation completed for " + $this.creatableTopics$4.keys() + " with response " + response.responseBody() + ".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$4 = creatableTopics$4;
                this.timeoutMs$1 = timeoutMs$1;
                this.requestHeaderForParsing$2 = requestHeaderForParsing$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$13(kafka.server.DefaultAutoTopicCreationManager$$anon$3 org.apache.kafka.common.errors.AuthenticationException ), $anonfun$onComplete$14(kafka.server.DefaultAutoTopicCreationManager$$anon$3 org.apache.kafka.common.errors.UnsupportedVersionException ), $anonfun$onComplete$15(kafka.server.DefaultAutoTopicCreationManager$$anon$3 org.apache.kafka.common.protocol.Errors ), $anonfun$onComplete$16(kafka.server.DefaultAutoTopicCreationManager$$anon$3 ), $anonfun$onComplete$17(java.lang.Exception ), $anonfun$onComplete$18(), $anonfun$onComplete$19(org.apache.kafka.common.requests.AbstractResponse ), $anonfun$onComplete$20(kafka.server.DefaultAutoTopicCreationManager$$anon$3 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$2(kafka.server.DefaultAutoTopicCreationManager$$anon$3 )}, serializedLambda);
            }
        };
        if (!(requestContext instanceof Some)) ** GOTO lbl-1000
        context = (RequestContext)((Some)requestContext).value();
        if (requestHeaderForParsing instanceof Some) {
            requestHeader = (RequestHeader)((Some)requestHeaderForParsing).value();
            v0 = ForwardingManager$.MODULE$.buildEnvelopeRequest(context, createTopicsRequest.build(requestHeader.apiVersion()).serializeWithHeader(requestHeader));
        } else lbl-1000:
        // 2 sources

        {
            v0 = createTopicsRequest;
        }
        request = v0;
        this.channelManager.sendRequest((AbstractRequest.Builder)request, requestCompletionHandler);
        return (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$sendCreateTopicRequestWithErrorCaching$2(java.lang.String ), (Ljava/lang/String;)Lorg/apache/kafka/common/message/MetadataResponseData$MetadataResponseTopic;)());
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrors(Set<String> topicNames, String errorMessage, long ttlMs) {
        topicNames.foreach((Function1 & Serializable)topicName -> {
            DefaultAutoTopicCreationManager.$anonfun$cacheTopicCreationErrors$1(this, errorMessage, ttlMs, topicName);
            return BoxedUnit.UNIT;
        });
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$cacheTopicCreationErrorsFromResponse(CreateTopicsResponse response, long ttlMs) {
        response.data().topics().forEach(topicResult -> {
            if (topicResult.errorCode() != Errors.NONE.code()) {
                String errorMessage = (String)Option$.MODULE$.apply((Object)topicResult.errorMessage()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0 & Serializable)() -> Errors.forCode((short)topicResult.errorCode()).message());
                this.topicCreationErrorCache().put(topicResult.name(), errorMessage, ttlMs);
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Cached topic creation error for " + topicResult.name() + ": " + errorMessage);
                return;
            }
        });
    }

    @Override
    public void close() {
        this.topicCreationErrorCache().clear();
    }

    public static final /* synthetic */ boolean $anonfun$createStreamsInternalTopics$1(DefaultAutoTopicCreationManager $this, long currentTimeMs$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            return !$this.topicCreationErrorCache().hasError(topicName, currentTimeMs$2) && $this.inflightTopics().add(topicName);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ RequestHeader $anonfun$sendCreateTopicRequest$1(DefaultAutoTopicCreationManager $this, RequestContext context) {
        short s;
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.channelManager.controllerApiVersions()));
        if (None$.MODULE$.equals(option)) {
            s = ApiKeys.CREATE_TOPICS.latestVersion();
        } else if (option instanceof Some) {
            s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
        } else {
            throw new MatchError((Object)option);
        }
        short requestVersion = s;
        return new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
    }

    public static final /* synthetic */ MetadataResponseData.MetadataResponseTopic $anonfun$sendCreateTopicRequest$2(String topic) {
        return new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
    }

    public static final /* synthetic */ String $anonfun$sendCreateTopicRequest$3(Map creatableTopics$1) {
        return "Sent auto-creation request for " + creatableTopics$1.keys() + " to the active controller.";
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public static final /* synthetic */ RequestHeader $anonfun$sendCreateTopicRequestWithErrorCaching$1(DefaultAutoTopicCreationManager $this, RequestContext context) {
        short s;
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.channelManager.controllerApiVersions()));
        if (None$.MODULE$.equals(option)) {
            s = ApiKeys.CREATE_TOPICS.latestVersion();
        } else if (option instanceof Some) {
            s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
        } else {
            throw new MatchError((Object)option);
        }
        short requestVersion = s;
        return new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
    }

    public static final /* synthetic */ MetadataResponseData.MetadataResponseTopic $anonfun$sendCreateTopicRequestWithErrorCaching$2(String topic) {
        return new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
    }

    public static final /* synthetic */ void $anonfun$cacheTopicCreationErrors$1(DefaultAutoTopicCreationManager $this, String errorMessage$1, long ttlMs$1, String topicName) {
        $this.topicCreationErrorCache().put(topicName, errorMessage$1, ttlMs$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, NodeToControllerChannelManager channelManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ShareCoordinator shareCoordinator, Time time, int topicErrorCacheCapacity) {
        this.config = config;
        this.channelManager = channelManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.time = time;
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
        this.topicCreationErrorCache = new ExpiringErrorCache(topicErrorCacheCapacity, time);
    }
}

