/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.MatchedStringMatcher;
import proguard.util.OrMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;

public class ClassNameParser
implements StringParser {
    private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D'};
    private List variableStringMatchers;

    public ClassNameParser() {
        this(null);
    }

    public ClassNameParser(List variableStringMatchers) {
        this.variableStringMatchers = variableStringMatchers;
    }

    @Override
    public StringMatcher parse(String regularExpression) {
        int index;
        StringMatcher nextMatcher = new EmptyStringMatcher();
        for (index = 0; index < regularExpression.length(); ++index) {
            if (regularExpression.regionMatches(index, "L///;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{')'}, 0, Integer.MAX_VALUE, settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 5)));
                break;
            }
            if (regularExpression.regionMatches(index, "L***;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(this.createAnyTypeMatcher(settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 5)));
                break;
            }
            if (regularExpression.regionMatches(index, "**", 0, 2)) {
                SettableMatcher settableMatcher = index + 2 == regularExpression.length() ? null : new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, settableMatcher));
                if (settableMatcher == null) break;
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 2)));
                break;
            }
            if (regularExpression.charAt(index) == '*') {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{';', '/'}, 0, Integer.MAX_VALUE, settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                break;
            }
            if (regularExpression.charAt(index) == '?') {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, new char[]{';', '/'}, 1, 1, settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                break;
            }
            if (regularExpression.charAt(index) == '%') {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(PRIMITIVE_TYPES, null, 1, 1, settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                break;
            }
            int wildCardIndex = this.wildCardIndex(regularExpression, index);
            if (wildCardIndex <= 0) continue;
            int closingIndex = regularExpression.indexOf(62, index + 1);
            nextMatcher = new MatchedStringMatcher(this.retrieveVariableStringMatcher(wildCardIndex - 1), this.parse(regularExpression.substring(closingIndex + 1)));
            break;
        }
        return index != 0 ? new FixedStringMatcher(regularExpression.substring(0, index), nextMatcher) : nextMatcher;
    }

    private VariableStringMatcher createAnyTypeMatcher(StringMatcher nextMatcher) {
        return new VariableStringMatcher(new char[]{'['}, null, 0, 255, new OrMatcher(new VariableStringMatcher(PRIMITIVE_TYPES, null, 1, 1, nextMatcher), new VariableStringMatcher(new char[]{'L'}, null, 1, 1, new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, new VariableStringMatcher(new char[]{';'}, null, 1, 1, nextMatcher)))));
    }

    private VariableStringMatcher rememberVariableStringMatcher(VariableStringMatcher variableStringMatcher) {
        if (this.variableStringMatchers != null) {
            this.variableStringMatchers.add(variableStringMatcher);
        }
        return variableStringMatcher;
    }

    private VariableStringMatcher retrieveVariableStringMatcher(int index) {
        return (VariableStringMatcher)this.variableStringMatchers.get(index);
    }

    private int wildCardIndex(String string, int index) throws IllegalArgumentException {
        if (string.charAt(index) != '<') {
            return 0;
        }
        int closingBracketIndex = string.indexOf(62, index);
        if (closingBracketIndex < 0) {
            throw new IllegalArgumentException("Missing closing angular bracket after opening bracket at index " + index + " in [" + string + "]");
        }
        if (this.variableStringMatchers == null) {
            throw new IllegalArgumentException("References to wildcards are not supported in this argument [" + string + "]");
        }
        String argumentBetweenBrackets = string.substring(index + 1, closingBracketIndex);
        try {
            int wildcardIndex = Integer.parseInt(argumentBetweenBrackets);
            if (wildcardIndex < 1 || wildcardIndex > this.variableStringMatchers.size()) {
                throw new IllegalArgumentException("Invalid reference to wildcard (" + wildcardIndex + ", must lie between 1 and " + this.variableStringMatchers.size() + " in [" + string + "])");
            }
            return wildcardIndex;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Reference to wildcard must be a number [" + argumentBetweenBrackets + "] in [" + string + "]");
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("Regular expression [" + args[0] + "]");
            ClassNameParser parser = new ClassNameParser();
            StringMatcher matcher = parser.parse(args[0]);
            for (int index = 1; index < args.length; ++index) {
                String string = args[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + matcher.matches(args[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

