/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.utils.ListNode;

public class SQLQueryModel
extends SQLQueryNodeModel {
    @NotNull
    private final Set<SQLQuerySymbolEntry> symbolEntries;
    @Nullable
    private final SQLQueryModelContent queryContent;
    @NotNull
    private final List<SQLQueryLexicalScopeItem> lexicalItems;

    public SQLQueryModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryModelContent queryContent, @NotNull Set<SQLQuerySymbolEntry> symbolEntries, @NotNull List<SQLQueryLexicalScopeItem> lexicalItems) {
        super(syntaxNode.getRealInterval(), syntaxNode, queryContent);
        this.queryContent = queryContent;
        this.symbolEntries = symbolEntries;
        this.lexicalItems = lexicalItems;
    }

    @NotNull
    public Collection<SQLQuerySymbolEntry> getAllSymbols() {
        return this.symbolEntries;
    }

    @Nullable
    public SQLQueryModelContent getQueryModel() {
        return this.queryContent;
    }

    public void resolveRelations(@NotNull SQLQueryRowsSourceContext rowsContext, @NotNull SQLQueryRecognitionContext recognitionContext) {
        int actualTailPosition;
        SQLQueryNodeModel tailNode;
        if (this.queryContent != null) {
            this.queryContent.resolveObjectAndRowsReferences(rowsContext, recognitionContext);
            this.queryContent.resolveValueRelations(rowsContext.makeEmptyTuple(), recognitionContext);
        }
        if ((tailNode = this.findNodeContaining(actualTailPosition = this.getSyntaxNode().getRealInterval().b)) != this) {
            SQLQueryLexicalScope tailNodeScope;
            SQLQuerySymbolOrigin tailOrigin = tailNode.getTailOrigin();
            if (tailOrigin == null && (tailNodeScope = tailNode.findLexicalScope(actualTailPosition)) != null) {
                tailOrigin = tailNodeScope.getSymbolsOrigin();
            }
            if (tailOrigin != null) {
                this.setTailOrigin(tailOrigin);
            }
        }
    }

    @NotNull
    public SQLQueryNodeModel findNodeContaining(int textOffset) {
        SQLQueryNodeModel node = this;
        for (SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset); nested != null; nested = nested.findChildNodeContaining(textOffset)) {
            node = nested;
        }
        return node;
    }

    public LexicalContextResolutionResult findLexicalContext(int textOffset) {
        SQLQuerySymbolOrigin symbolsOrigin;
        ListNode stack = ListNode.of((Object)this);
        SQLQueryModel node = this;
        for (SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset); nested != null; nested = nested.findChildNodeContaining(textOffset)) {
            stack = ListNode.push((ListNode)stack, (Object)nested);
        }
        SQLQueryLexicalScopeItem lexicalItem = null;
        SQLQueryLexicalScope scope = null;
        SQLQuerySymbolOrigin deepestTailOrigin = null;
        while (stack != null && (scope == null || deepestTailOrigin == null)) {
            SQLQueryNodeModel node2 = (SQLQueryNodeModel)stack.data;
            if (scope == null && (scope = node2.findLexicalScope(textOffset)) != null) {
                lexicalItem = scope.findNearestItem(textOffset);
            }
            if (deepestTailOrigin == null && node2.getTailOrigin() != null) {
                deepestTailOrigin = node2.getTailOrigin();
            }
            stack = stack.next;
        }
        if (lexicalItem == null) {
            int index = STMUtils.binarySearchByKey(this.lexicalItems, n -> n.getSyntaxNode().getRealInterval().a, (Object)(textOffset - 1), Comparator.comparingInt(x -> x));
            if (index < 0) {
                index = ~index - 1;
            }
            if (index >= 0) {
                SQLQueryLexicalScopeItem item = this.lexicalItems.get(index);
                Interval interval = item.getSyntaxNode().getRealInterval();
                if (interval.a < textOffset && interval.b + 1 >= textOffset) {
                    lexicalItem = item;
                }
            }
        }
        SQLQuerySymbolOrigin sQLQuerySymbolOrigin = symbolsOrigin = lexicalItem == null ? null : lexicalItem.getOrigin();
        if (symbolsOrigin == null && textOffset > this.getInterval().b && (symbolsOrigin = this.getTailOrigin()) == null) {
            symbolsOrigin = deepestTailOrigin;
        }
        if (symbolsOrigin == null && scope != null) {
            symbolsOrigin = scope.getSymbolsOrigin();
        }
        return new LexicalContextResolutionResult(textOffset, lexicalItem, symbolsOrigin);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitSelectionModel(this, arg);
    }

    public record LexicalContextResolutionResult(int textOffset, SQLQueryLexicalScopeItem lexicalItem, SQLQuerySymbolOrigin symbolsOrigin) {
    }
}

