/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class PostgreInsertReplaceMethod
implements DBDInsertReplaceMethod {
    private static final Log log = Log.getLog(PostgreInsertReplaceMethod.class);

    @NotNull
    public String getOpeningClause(@NotNull DBSTable table, @NotNull DBRProgressMonitor monitor) {
        return "INSERT INTO";
    }

    public String getTrailingClause(@NotNull DBSTable table, @NotNull DBRProgressMonitor monitor, DBSAttributeBase[] attributes) {
        StringBuilder query = new StringBuilder();
        try {
            DBSTableIndex tableIndex;
            List references;
            Optional<DBSTableIndex> optional;
            Collection indexes;
            DBSTableConstraint dbsTableConstraint;
            List attributeReferences;
            Optional<DBSTableConstraint> tableConstraint;
            String onConflictExpression = "ON CONFLICT (%s) DO UPDATE SET %s";
            StringBuilder constraintAttrNames = new StringBuilder();
            Collection constraints = table.getConstraints(monitor);
            if (!CommonUtils.isEmpty((Collection)constraints) && (tableConstraint = constraints.stream().filter(key -> key.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY).findFirst()).isPresent() && !CommonUtils.isEmpty((Collection)(attributeReferences = (dbsTableConstraint = tableConstraint.get()).getAttributeReferences(monitor)))) {
                this.getConstraintAttributesNames(constraintAttrNames, attributeReferences);
            }
            if (constraintAttrNames.isEmpty() && !CommonUtils.isEmpty((Collection)(indexes = table.getIndexes(monitor))) && (optional = indexes.stream().filter(DBSTableIndex::isUnique).findFirst()).isPresent() && !CommonUtils.isEmpty((Collection)(references = (tableIndex = optional.get()).getAttributeReferences(monitor)))) {
                this.getConstraintAttributesNames(constraintAttrNames, references);
            }
            if (constraintAttrNames.isEmpty()) {
                log.debug((Object)"Can't find table constraints for the correct update on conflict operation.");
                return null;
            }
            StringBuilder updateExpression = new StringBuilder();
            updateExpression.append("(");
            this.addAttributesNamesList(table, attributes, false, updateExpression);
            updateExpression.append(") = (");
            this.addAttributesNamesList(table, attributes, true, updateExpression);
            updateExpression.append(")");
            query.append(" ").append(String.format(onConflictExpression, constraintAttrNames, updateExpression));
        }
        catch (DBException e) {
            log.debug((Object)"Can't read table constraints list", (Throwable)e);
        }
        return query.toString();
    }

    private void getConstraintAttributesNames(@NotNull StringBuilder constraintAttrNames, @NotNull List<? extends DBSEntityAttributeRef> attributeReferences) {
        boolean hasKey = false;
        for (DBSEntityAttributeRef dBSEntityAttributeRef : attributeReferences) {
            DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
            if (attribute == null) continue;
            if (hasKey) {
                constraintAttrNames.append(",");
            }
            constraintAttrNames.append(DBUtils.getQuotedIdentifier((DBSObject)attribute));
            hasKey = true;
        }
    }

    private void addAttributesNamesList(@NotNull DBSTable table, @NotNull DBSAttributeBase[] attributes, boolean isExcluded, @NotNull StringBuilder updateExpression) {
        boolean hasKey = false;
        for (DBSAttributeBase attribute : attributes) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attribute)) continue;
            if (hasKey) {
                updateExpression.append(",");
            }
            hasKey = true;
            if (isExcluded) {
                updateExpression.append("EXCLUDED.");
            }
            updateExpression.append(this.getAttributeName(table, attribute));
        }
    }

    private String getAttributeName(@NotNull DBSTable table, @NotNull DBSAttributeBase attribute) {
        return DBUtils.isPseudoAttribute((DBSAttributeBase)attribute) ? attribute.getName() : DBUtils.getObjectFullName((DBPDataSource)table.getDataSource(), (DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }
}

