/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.util.Objects;
import org.freeplane.plugin.ai.chat.AIModelSelection;

class AIModelDescriptor {
    private final String providerName;
    private final String modelName;
    private final String displayName;
    private final boolean isFreeModel;

    AIModelDescriptor(String providerName, String modelName, String displayName, boolean isFreeModel) {
        this.providerName = Objects.requireNonNull(providerName, "providerName");
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.displayName = Objects.requireNonNull(displayName, "displayName");
        this.isFreeModel = isFreeModel;
    }

    String getProviderName() {
        return this.providerName;
    }

    String getModelName() {
        return this.modelName;
    }

    String getDisplayName() {
        return this.displayName;
    }

    boolean isFreeModel() {
        return this.isFreeModel;
    }

    String getSelectionValue() {
        return AIModelSelection.createSelectionValue(this.providerName, this.modelName);
    }

    public String toString() {
        return this.displayName;
    }
}

