/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;

public class ScriptResources {
    static final IFreeplaneScriptErrorHandler IGNORING_SCRIPT_ERROR_HANDLER = new IFreeplaneScriptErrorHandler(){

        @Override
        public void gotoLine(int pLineNumber) {
        }
    };
    private static final String RESOURCES_SCRIPT_COMPILATION_DISABLED_EXTENSIONS = "script_compilation_disabled_extensions";
    static final String RESOURCES_SCRIPT_DIRECTORIES = "script_directories";
    static final String RESOURCES_SCRIPT_CLASSPATH = "script_classpath";
    static final String[] SCRIPT_COMPILATION_DISABLED_EXTENSIONS = ResourceController.getResourceController().getProperty("script_compilation_disabled_extensions", "").split("\\W+");
    private static final String USER_SCRIPTS_DIR_PROPERTY = "org.freeplane.scripts.user.dir";
    private static final String USER_SCRIPTS_DIR = System.getProperty("org.freeplane.scripts.user.dir", "scripts");
    private static final String INIT_SCRIPTS_DIR_PROPERTY = "org.freeplane.init.scripts.dir";
    private static final String INIT_SCRIPTS_DIR = System.getProperty("org.freeplane.init.scripts.dir", "scripts/init");
    private static final String USER_LIB_DIR_PROPERTY = "org.freeplane.scripts.user.lib.dir";
    private static final String USER_LIB_DIR = System.getProperty("org.freeplane.scripts.user.lib.dir", "lib");
    private static final String BUILTIN_SCRIPTS_DIR_PROPERTY = "org.freeplane.builtin.scripts.dir";
    private static final String BUILTIN_SCRIPTS_DIR = System.getProperty("org.freeplane.builtin.scripts.dir", "scripts");
    private static final String PRECOMPILED_SCRIPTS_DIRECTORY = "compiledscripts";
    private static final String COMPILED_SCRIPTS_DIRECTORY = "compiledscripts2";
    private static List<String> classpath;
    private static final File builtinScriptsDir;
    private static final File userScriptsDir;
    private static final File initScriptsDir;
    private static final File userLibDir;

    public static File getUserScriptDir() {
        return ScriptResources.getUserScriptsDir();
    }

    public static File getUserScriptsDir() {
        return userScriptsDir;
    }

    public static File getInitScriptsDir() {
        return initScriptsDir;
    }

    public static File getUserLibDir() {
        return userLibDir;
    }

    static File getBuiltinScriptsDir() {
        return builtinScriptsDir;
    }

    static List<String> getClasspath() {
        return classpath;
    }

    static void setClasspath(List<String> newClasspath) {
        if (classpath != null) {
            throw new SecurityException("reset of script classpath is forbidden.");
        }
        classpath = Collections.unmodifiableList(newClasspath);
        if (!classpath.isEmpty()) {
            LogUtils.info((String)("extending script's classpath by " + classpath));
        }
    }

    private static File buildBuiltinScriptsDir() {
        return FileUtils.getAbsoluteFile((String)ResourceController.getResourceController().getInstallationBaseDir(), (String)BUILTIN_SCRIPTS_DIR);
    }

    private static File buildUserScriptsDir(String userDir) {
        return FileUtils.getAbsoluteFile((String)ResourceController.getResourceController().getFreeplaneUserDirectory(), (String)userDir);
    }

    static File getPrecompiledScriptsDir() {
        return ScriptResources.buildUserScriptsDir(PRECOMPILED_SCRIPTS_DIRECTORY);
    }

    static File getCompiledScriptsDir() {
        return ScriptResources.buildUserScriptsDir(COMPILED_SCRIPTS_DIRECTORY);
    }

    static {
        builtinScriptsDir = ScriptResources.buildBuiltinScriptsDir();
        userScriptsDir = ScriptResources.buildUserScriptsDir(USER_SCRIPTS_DIR);
        initScriptsDir = ScriptResources.buildUserScriptsDir(INIT_SCRIPTS_DIR);
        userLibDir = ScriptResources.buildUserScriptsDir(USER_LIB_DIR);
    }
}

