import { jsx, jsxs } from 'react/jsx-runtime';
import { useState, useEffect } from 'react';
import { css } from '@emotion/css';
import { useTheme2, Button } from '@grafana/ui';
import { CustomHeader } from './CustomHeader.js';
import { ConfigSubSection } from '../../ConfigSection/ConfigSubSection.js';
import '@grafana/data';

const CustomHeaders = ({ headers: headersFromProps, onChange, readOnly }) => {
  const { spacing } = useTheme2();
  const [headers, setHeaders] = useState(
    headersFromProps.map((header) => ({
      ...header,
      id: uniqueId(),
      value: ""
    }))
  );
  useEffect(() => {
    setHeaders((headers2) => {
      let changed = false;
      const newHeaders = headers2.map((header) => {
        var _a;
        const configured = (_a = headersFromProps.find((h) => h.name === header.name)) == null ? undefined : _a.configured;
        if (typeof configured !== "undefined" && header.configured !== configured) {
          changed = true;
          return { ...header, configured };
        }
        return header;
      });
      if (changed) {
        return newHeaders;
      }
      return headers2;
    });
  }, [headersFromProps]);
  const onHeaderAdd = () => {
    setHeaders([...headers, { id: uniqueId(), name: "", value: "", configured: false }]);
  };
  const onHeaderChange = (id, header) => {
    setHeaders(headers.map((h) => h.id === id ? { ...header } : h));
  };
  const onHeaderDelete = (id) => {
    const index = headers.findIndex((h) => h.id === id);
    if (index === -1) {
      return;
    }
    const newHeaders = [...headers];
    newHeaders.splice(index, 1);
    setHeaders(newHeaders);
    onChange(
      newHeaders.map(({ name, value, configured }) => ({
        name,
        value,
        configured
      }))
    );
  };
  const onBlur = () => {
    onChange(
      headers.map(({ name, value, configured }) => ({
        name,
        value,
        configured
      }))
    );
  };
  const styles = {
    container: css({
      marginTop: spacing(3)
    }),
    addHeaderButton: css({
      marginTop: spacing(1.5)
    })
  };
  return /* @__PURE__ */ jsx("div", { className: styles.container, children: /* @__PURE__ */ jsxs(
    ConfigSubSection,
    {
      title: "HTTP headers",
      description: "Pass along additional context and metadata about the request/response",
      isCollapsible: true,
      isInitiallyOpen: headers.length > 0,
      children: [
        /* @__PURE__ */ jsx("div", { children: headers.map((header) => /* @__PURE__ */ jsx(
          CustomHeader,
          {
            header,
            onChange: (header2) => onHeaderChange(header2.id, header2),
            onDelete: () => onHeaderDelete(header.id),
            onBlur,
            readOnly
          },
          header.id
        )) }),
        /* @__PURE__ */ jsx("div", { className: styles.addHeaderButton, children: /* @__PURE__ */ jsx(Button, { icon: "plus", variant: "secondary", fill: "outline", onClick: onHeaderAdd, disabled: readOnly, children: headers.length === 0 ? "Add header" : "Add another header" }) })
      ]
    }
  ) });
};
function uniqueId() {
  return Math.random().toString(16).slice(2);
}

export { CustomHeaders };
//# sourceMappingURL=CustomHeaders.js.map
