/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootChecker;
import com.intellij.openapi.vcs.impl.OptionsAndConfirmationsHolder;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.console.VcsConsoleTabService;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="VcsDirectoryMappings", storages={@Storage(value="vcs.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00c8\u00012\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\b\u00c5\u0001\u00c6\u0001\u00c7\u0001\u00c8\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010$\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020'0+H\u0016\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\u000eJ#\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040+H\u0016\u00a2\u0006\u0002\u00105J\u0015\u00106\u001a\u00070)\u00a2\u0006\u0002\b72\u0006\u00108\u001a\u000204H\u0017J\u0014\u00109\u001a\u0004\u0018\u00010'2\b\u00108\u001a\u0004\u0018\u000104H\u0016J\u0014\u00109\u001a\u0004\u0018\u00010'2\b\u00108\u001a\u0004\u0018\u00010:H\u0016J\u0014\u0010;\u001a\u0004\u0018\u0001042\b\u00108\u001a\u0004\u0018\u000104H\u0016J\u0014\u0010<\u001a\u0004\u0018\u00010=2\b\u00108\u001a\u0004\u0018\u000104H\u0016J\u0014\u0010;\u001a\u0004\u0018\u0001042\b\u00108\u001a\u0004\u0018\u00010:H\u0016J\u0014\u0010<\u001a\u0004\u0018\u00010=2\b\u00108\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010B\u001a\u00020%2\u0006\u0010C\u001a\u00020'H\u0007J\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020'H\u0016J\u0012\u0010J\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u00010)H\u0016J\u0013\u0010L\u001a\b\u0012\u0004\u0012\u00020'0+H\u0016\u00a2\u0006\u0002\u0010/J\n\u0010M\u001a\u0004\u0018\u00010'H\u0016J\b\u0010N\u001a\u00020\u000eH\u0016J\b\u0010O\u001a\u00020\u000eH\u0016J\b\u0010P\u001a\u00020\u000eH\u0016J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0016J\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0?2\u0006\u0010C\u001a\u00020'H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010S2\u0006\u0010U\u001a\u00020:H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010S2\u0006\u00108\u001a\u000204H\u0002J$\u0010V\u001a\u00020%2\u000b\u0010U\u001a\u00070)\u00a2\u0006\u0002\bW2\r\u0010X\u001a\t\u0018\u00010)\u00a2\u0006\u0002\bWH\u0016J \u0010Y\u001a\u00020%2\u0018\u0010Z\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020'0\\0[J\u0016\u0010]\u001a\u00020%2\u000e\u0010^\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010S0?J\u000e\u0010_\u001a\u00020%2\u0006\u0010`\u001a\u00020SJ\u0016\u0010a\u001a\u00020%2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020S0?H\u0016J\b\u0010b\u001a\u00020%H\u0016J\u0006\u0010c\u001a\u00020%J \u0010d\u001a\u00020%2\u0006\u0010e\u001a\u0002042\u000e\u0010f\u001a\n\u0012\u0006\b\u0000\u0012\u00020:0gH\u0016J*\u0010d\u001a\u00020%2\u0006\u0010e\u001a\u0002042\u000e\u0010f\u001a\n\u0012\u0006\b\u0000\u0012\u00020:0g2\b\u0010h\u001a\u0004\u0018\u00010iH\u0016J \u0010j\u001a\u00020%2\u0006\u00108\u001a\u0002042\u000e\u0010k\u001a\n\u0012\u0006\b\u0000\u0012\u0002040gH\u0016J\u0018\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020o2\u0006\u0010C\u001a\u00020'H\u0016J\u001a\u0010p\u001a\u00020q2\u0006\u0010n\u001a\u00020r2\b\u0010C\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010z\u001a\u00020x2\u0006\u0010n\u001a\u00020rH\u0016J\u0010\u0010{\u001a\u00020|2\u0006\u0010n\u001a\u00020oH\u0016J\t\u0010\u0081\u0001\u001a\u00020%H\u0016J\t\u0010\u0082\u0001\u001a\u00020%H\u0016J\u0017\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u0002040?2\u0006\u0010C\u001a\u00020'H\u0016J\u001d\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u0002040+2\u0006\u0010C\u001a\u00020'H\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J\u0015\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u0002040+H\u0016\u00a2\u0006\u0003\u0010\u0087\u0001J\u0015\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020=0+H\u0016\u00a2\u0006\u0003\u0010\u0089\u0001J\t\u0010\u008a\u0001\u001a\u00020)H\u0016J\t\u0010\u008b\u0001\u001a\u00020%H\u0017J\u0012\u0010\u008c\u0001\u001a\u00020%2\u0007\u0010\u008d\u0001\u001a\u00020\u0003H\u0016J\t\u0010\u008e\u0001\u001a\u00020\u0003H\u0016J\u0013\u0010\u008f\u0001\u001a\u0004\u0018\u00010'2\u0006\u00108\u001a\u000204H\u0016J\u0012\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0006\u0010C\u001a\u00020'H\u0016J\u0013\u0010\u0092\u0001\u001a\u0004\u0018\u00010,2\u0006\u0010K\u001a\u00020)H\u0002J\t\u0010\u0097\u0001\u001a\u00020%H\u0016J\u000b\u0010\u0098\u0001\u001a\u0004\u0018\u00010)H\u0016J$\u0010\u0099\u0001\u001a\u00020\u000e2\u0015\u0010\u009a\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u009b\u00010+\"\u00030\u009b\u0001\u00a2\u0006\u0003\u0010\u009c\u0001J&\u0010\u009d\u0001\u001a\u00020%2\u0015\u0010\u009a\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u009b\u00010+\"\u00030\u009b\u0001H\u0007\u00a2\u0006\u0003\u0010\u009e\u0001J&\u0010\u009f\u0001\u001a\u00020%2\u0015\u0010\u009a\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u009b\u00010+\"\u00030\u009b\u0001H\u0007\u00a2\u0006\u0003\u0010\u009e\u0001J\u001b\u0010\u00a0\u0001\u001a\u00020%2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001J\u0013\u0010\u00a5\u0001\u001a\u00020%2\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0010\u0010\u00a6\u0001\u001a\u00020%H\u0096@\u00a2\u0006\u0003\u0010\u00a7\u0001J\u0014\u0010\u00a8\u0001\u001a\u00020\u000e2\t\u0010\u00a9\u0001\u001a\u0004\u0018\u000104H\u0016J\u0012\u0010\u00aa\u0001\u001a\u00020\u000e2\u0007\u0010\u00a9\u0001\u001a\u000204H\u0016J\u0012\u0010\u00aa\u0001\u001a\u00020\u000e2\u0007\u0010\u00ab\u0001\u001a\u00020:H\u0016J\u0011\u0010\u00ac\u0001\u001a\u00020\u000e2\u0006\u00108\u001a\u000204H\u0002J\u0011\u0010\u00ad\u0001\u001a\u00020\u000e2\u0006\u00108\u001a\u000204H\u0002J\u0012\u0010\u00ae\u0001\u001a\u00020\u000e2\u0007\u0010\u00af\u0001\u001a\u000204H\u0002J\t\u0010\u00b0\u0001\u001a\u00020%H\u0007J\u0015\u0010\u00b1\u0001\u001a\u00020%2\n\u0010\u00b2\u0001\u001a\u0005\u0018\u00010\u00a4\u0001H\u0017J\t\u0010\u00b3\u0001\u001a\u00020%H\u0017J \u0010\u00b4\u0001\u001a\u00020%2\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010)2\n\u0010\u00b6\u0001\u001a\u0005\u0018\u00010\u00b7\u0001H\u0017J\u001e\u0010\u00b4\u0001\u001a\u00020%2\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010)2\b\u0010\u00b8\u0001\u001a\u00030\u00b9\u0001H\u0016J\u0015\u0010\u00b4\u0001\u001a\u00020%2\n\u0010\u00ba\u0001\u001a\u0005\u0018\u00010\u00bb\u0001H\u0016J8\u0010\u00bc\u0001\u001a\u0005\u0018\u00010\u00bd\u00012\n\u0010\u00be\u0001\u001a\u0005\u0018\u00010\u00bf\u00012\t\u0010\u00c0\u0001\u001a\u0004\u0018\u00010)2\n\u0010\u00c1\u0001\u001a\u0005\u0018\u00010\u00c2\u00012\u0007\u0010\u00c3\u0001\u001a\u00020\u000eH\u0017J\u0011\u0010\u00c4\u0001\u001a\u00020%2\u0006\u0010C\u001a\u00020'H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0011\u001a2\u0012\u000e\u0012\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015 \u0017*\u0017\u0012\u000e\u0012\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00150\u0016\u00a2\u0006\u0002\b\u00140\u0012\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020=0?8G\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u001c\u0010D\u001a\u0004\u0018\u00010E8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u0014\u0010s\u001a\u00020t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bu\u0010vR\u001a\u0010w\u001a\b\u0012\u0004\u0012\u00020x0?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010AR\u001a\u0010}\u001a\b\u0012\u0004\u0012\u00020|0?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b~\u0010AR\u0015\u0010\u007f\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u007f\u0010\u0080\u0001R\u0018\u0010\u0093\u0001\u001a\u00030\u0094\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0095\u0001\u0010\u0096\u0001\u00a8\u0006\u00c9\u0001"}, d2={"Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "Lcom/intellij/openapi/vcs/ex/ProjectLevelVcsManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "mappingsHolder", "Lcom/intellij/openapi/vcs/impl/projectlevelman/NewMappings;", "mappingsLoaded", "", "backgroundOperationCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "backgroundRunningTasks", "", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActionKey;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "annotationLocalChangesListener", "Lcom/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListener;", "getAnnotationLocalChangesListener", "()Lcom/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListener;", "vcsHistoryCache", "Lcom/intellij/openapi/vcs/history/VcsHistoryCache;", "getVcsHistoryCache", "()Lcom/intellij/openapi/vcs/history/VcsHistoryCache;", "contentRevisionCache", "Lcom/intellij/openapi/vcs/impl/ContentRevisionCache;", "getContentRevisionCache", "()Lcom/intellij/openapi/vcs/impl/ContentRevisionCache;", "dispose", "", "findVcsByName", "Lcom/intellij/openapi/vcs/AbstractVcs;", "name", "", "getAllVcss", "", "Lcom/intellij/openapi/vcs/impl/VcsDescriptor;", "()[Lcom/intellij/openapi/vcs/impl/VcsDescriptor;", "getAllSupportedVcss", "()[Lcom/intellij/openapi/vcs/AbstractVcs;", "haveVcses", "checkAllFilesAreUnder", "abstractVcs", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vcs/AbstractVcs;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "getShortNameForVcsRoot", "Lcom/intellij/openapi/util/NlsSafe;", "file", "getVcsFor", "Lcom/intellij/openapi/vcs/FilePath;", "getVcsRootFor", "getVcsRootObjectFor", "Lcom/intellij/openapi/vcs/VcsRoot;", "vcsRootObjectsForDefaultMapping", "", "getVcsRootObjectsForDefaultMapping", "()Ljava/util/List;", "unregisterVcs", "vcs", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "getContentManager$annotations", "()V", "getContentManager", "()Lcom/intellij/ui/content/ContentManager;", "checkVcsIsActive", "vcsName", "getAllActiveVcss", "getSingleVCS", "hasActiveVcss", "areVcsesActivated", "hasAnyMappings", "getDirectoryMappings", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "getDirectoryMappingFor", "path", "setDirectoryMapping", "Lorg/jetbrains/annotations/NonNls;", "activeVcsName", "registerNewDirectMappings", "detectedRoots", "", "Lkotlin/Pair;", "setAutoDirectoryMappings", "mappings", "removeDirectoryMapping", "mapping", "setDirectoryMappings", "scheduleMappedRootsUpdate", "updateMappedVcsesImmediately", "iterateVcsRoot", "root", "iterator", "Lcom/intellij/util/Processor;", "directoryFilter", "Lcom/intellij/openapi/vcs/VirtualFileFilter;", "iterateVfUnderVcsRoot", "processor", "getStandardOption", "Lcom/intellij/openapi/vcs/VcsShowSettingOption;", "option", "Lcom/intellij/openapi/vcs/VcsConfiguration$StandardOption;", "getStandardConfirmation", "Lcom/intellij/openapi/vcs/VcsShowConfirmationOption;", "Lcom/intellij/openapi/vcs/VcsConfiguration$StandardConfirmation;", "optionsAndConfirmations", "Lcom/intellij/openapi/vcs/impl/projectlevelman/OptionsAndConfirmations;", "getOptionsAndConfirmations", "()Lcom/intellij/openapi/vcs/impl/projectlevelman/OptionsAndConfirmations;", "allConfirmations", "Lcom/intellij/openapi/vcs/impl/projectlevelman/PersistentVcsShowConfirmationOption;", "getAllConfirmations", "getConfirmation", "getOptions", "Lcom/intellij/openapi/vcs/impl/projectlevelman/PersistentVcsShowSettingOption;", "allOptions", "getAllOptions", "isBackgroundVcsOperationRunning", "()Z", "startBackgroundVcsOperation", "stopBackgroundVcsOperation", "getRootsUnderVcsWithoutFiltering", "getRootsUnderVcs", "(Lcom/intellij/openapi/vcs/AbstractVcs;)[Lcom/intellij/openapi/vfs/VirtualFile;", "getAllVersionedRoots", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getAllVcsRoots", "()[Lcom/intellij/openapi/vcs/VcsRoot;", "getConsolidatedVcsName", "notifyDirectoryMappingChanged", "loadState", "element", "getState", "findVersioningVcs", "getRootChecker", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "getDescriptor", "compositeCheckoutListener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "getCompositeCheckoutListener", "()Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "fireDirectoryMappingsChanged", "haveDefaultMapping", "isBackgroundTaskRunning", "keys", "", "([Ljava/lang/Object;)Z", "startBackgroundTask", "([Ljava/lang/Object;)V", "stopBackgroundTask", "addInitializationRequest", "vcsInitObject", "Lcom/intellij/openapi/vcs/impl/VcsInitObject;", "runnable", "Ljava/lang/Runnable;", "runAfterInitialization", "awaitInitialization", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isFileInContent", "vf", "isIgnored", "filePath", "isInDirectoryBasedRoot", "isFileInBaseDir", "hasExplicitMapping", "vFile", "waitForInitialized", "showConsole", "then", "scrollConsoleToTheEnd", "addMessageToConsoleWindow", "message", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "line", "Lcom/intellij/openapi/vcs/VcsConsoleLine;", "showUpdateProjectInfo", "Lcom/intellij/openapi/vcs/update/UpdateInfoTree;", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "displayActionName", "actionInfo", "Lcom/intellij/openapi/vcs/update/ActionInfo;", "canceled", "registerVcs", "ActionKey", "ActivateVcsesStartupActivity", "TrustListener", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nProjectLevelVcsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLevelVcsManagerImpl.kt\ncom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,651:1\n30#2,2:652\n75#2:669\n12767#3,2:654\n1#4:656\n774#5:657\n865#5,2:658\n1563#5:660\n1634#5,3:661\n1634#5,3:664\n37#6,2:667\n*S KotlinDebug\n*F\n+ 1 ProjectLevelVcsManagerImpl.kt\ncom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl\n*L\n75#1:652,2\n484#1:669\n104#1:654,2\n147#1:657\n147#1:658,2\n150#1:660\n150#1:661,3\n210#1:664,3\n323#1:667,2\n*E\n"})
public final class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final NewMappings mappingsHolder;
    private boolean mappingsLoaded;
    @NotNull
    private final AtomicInteger backgroundOperationCounter;
    @NotNull
    private final Set<ActionKey> backgroundRunningTasks;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String ELEMENT_MAPPING = "mapping";
    @NotNull
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NotNull
    private static final String ATTRIBUTE_VCS = "vcs";
    @NotNull
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NotNull
    private static final String ATTRIBUTE_CLASS = "class";

    public ProjectLevelVcsManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.mappingsHolder = new NewMappings(this.project, this, coroutineScope);
        this.backgroundOperationCounter = new AtomicInteger();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.backgroundRunningTasks = set;
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsAnnotationLocalChangesListener> serviceClass$iv = VcsAnnotationLocalChangesListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VcsAnnotationLocalChangesListener)object;
    }

    @NotNull
    public VcsHistoryCache getVcsHistoryCache() {
        VcsHistoryCache vcsHistoryCache = VcsCacheManager.getInstance(this.project).getVcsHistoryCache();
        Intrinsics.checkNotNullExpressionValue((Object)vcsHistoryCache, (String)"getVcsHistoryCache(...)");
        return vcsHistoryCache;
    }

    @NotNull
    public ContentRevisionCache getContentRevisionCache() {
        ContentRevisionCache contentRevisionCache = VcsCacheManager.getInstance(this.project).getContentRevisionCache();
        Intrinsics.checkNotNullExpressionValue((Object)contentRevisionCache, (String)"getContentRevisionCache(...)");
        return contentRevisionCache;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.mappingsHolder);
    }

    @Nullable
    public AbstractVcs findVcsByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        AbstractVcs vcs = AllVcses.getInstance(this.project).getByName(name);
        if (vcs == null && this.project.isDisposed()) {
            ReadAction.run(ProjectLevelVcsManagerImpl::findVcsByName$lambda$0);
        }
        return vcs;
    }

    @NotNull
    public VcsDescriptor[] getAllVcss() {
        VcsDescriptor[] vcsDescriptorArray = AllVcses.getInstance(this.project).getAll();
        Intrinsics.checkNotNullExpressionValue((Object)vcsDescriptorArray, (String)"getAll(...)");
        return vcsDescriptorArray;
    }

    @NotNull
    public AbstractVcs[] getAllSupportedVcss() {
        AbstractVcs[] abstractVcsArray = AllVcses.getInstance(this.project).getSupportedVcses();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getSupportedVcses(...)");
        return abstractVcsArray;
    }

    public final boolean haveVcses() {
        return !AllVcses.getInstance(this.project).isEmpty();
    }

    public boolean checkAllFilesAreUnder(@NotNull AbstractVcs abstractVcs, @NotNull VirtualFile[] files) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)abstractVcs, (String)"abstractVcs");
            Intrinsics.checkNotNullParameter((Object)files, (String)"files");
            VirtualFile[] $this$all$iv = files;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (this.getVcsFor(it) == abstractVcs) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NlsSafe
    @NotNull
    public String getShortNameForVcsRoot(@NotNull VirtualFile file) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            v0 = this.mappingsHolder.getShortNameFor(file);
            if (v0 != null) break block5;
            v1 /* !! */  = this.project.getBaseDir();
            if (v1 /* !! */  == null) ** GOTO lbl-1000
            it = v1 /* !! */ ;
            $i$a$-let-ProjectLevelVcsManagerImpl$getShortNameForVcsRoot$1 = false;
            v2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)it, (char)File.separatorChar);
            v1 /* !! */  = v2;
            if (v2 != null) {
                var2_5 = (CharSequence)v1 /* !! */ ;
                if (var2_5.length() == 0) {
                    $i$a$-ifEmpty-ProjectLevelVcsManagerImpl$getShortNameForVcsRoot$2 = false;
                    v3 = file.getName();
                    v4 = v3;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                } else {
                    v4 = var2_5;
                }
                v5 = (String)v4;
            } else lbl-1000:
            // 2 sources

            {
                v5 = v0 = null;
            }
            if (v5 == null) {
                v6 = file.getPresentableName();
                v0 = v6;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getPresentableName(...)");
            }
        }
        return v0;
    }

    @Nullable
    public AbstractVcs getVcsFor(@Nullable VirtualFile file) {
        if (this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(file);
        return mappedRoot != null ? mappedRoot.vcs : null;
    }

    @Nullable
    public AbstractVcs getVcsFor(@Nullable FilePath file) {
        if (this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(file);
        return mappedRoot != null ? mappedRoot.vcs : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file) {
        if (file == null || this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(file);
        return mappedRoot != null ? mappedRoot.root : null;
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable VirtualFile file) {
        VcsRoot vcsRoot;
        if (file == null || this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(file);
        if (mappedRoot != null) {
            NewMappings.MappedRoot it = mappedRoot;
            boolean bl = false;
            vcsRoot = new VcsRoot(it.vcs, it.root);
        } else {
            vcsRoot = null;
        }
        return vcsRoot;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable FilePath file) {
        if (file == null || this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(file);
        return mappedRoot != null ? mappedRoot.root : null;
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable FilePath file) {
        if (file == null || this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.mappingsHolder.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final List<VcsRoot> getVcsRootObjectsForDefaultMapping() {
        void $this$mapTo$iv$iv;
        NewMappings.MappedRoot root;
        Iterable $this$filterTo$iv$iv;
        List<NewMappings.MappedRoot> list = this.mappingsHolder.getAllMappedRoots();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllMappedRoots(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            root = (NewMappings.MappedRoot)element$iv$iv;
            boolean bl = false;
            AbstractVcs vcs = root.vcs;
            if (!(root.mapping.isDefaultMapping() && vcs != null && vcs.getCustomConvertor() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            root = (NewMappings.MappedRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new VcsRoot(it.vcs, it.root));
        }
        return (List)destination$iv$iv;
    }

    @TestOnly
    public final void unregisterVcs(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.mappingsHolder.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.mappingsHolder.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.project).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Version Control");
        return toolWindow != null ? toolWindow.getContentManager() : null;
    }

    public static /* synthetic */ void getContentManager$annotations() {
    }

    public boolean checkVcsIsActive(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(@Nullable String vcsName) {
        return this.mappingsHolder.haveActiveVcs(vcsName);
    }

    @NotNull
    public AbstractVcs[] getAllActiveVcss() {
        AbstractVcs[] abstractVcsArray = this.mappingsHolder.getActiveVcses();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getActiveVcses(...)");
        return abstractVcsArray;
    }

    @Nullable
    public AbstractVcs getSingleVCS() {
        return (AbstractVcs)ArraysKt.singleOrNull((Object[])this.getAllActiveVcss());
    }

    public boolean hasActiveVcss() {
        return this.mappingsHolder.hasActiveVcss();
    }

    public boolean areVcsesActivated() {
        return this.mappingsHolder.isActivated();
    }

    public boolean hasAnyMappings() {
        return !this.mappingsHolder.isEmpty();
    }

    @NotNull
    public List<VcsDirectoryMapping> getDirectoryMappings() {
        List<VcsDirectoryMapping> list = this.mappingsHolder.getDirectoryMappings();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDirectoryMappings(...)");
        return list;
    }

    @NotNull
    public List<VcsDirectoryMapping> getDirectoryMappings(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        List<VcsDirectoryMapping> list = this.mappingsHolder.getDirectoryMappings(vcs.getName());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDirectoryMappings(...)");
        return list;
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(@NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(path);
        return mappedRoot != null ? mappedRoot.mapping : null;
    }

    private final VcsDirectoryMapping getDirectoryMappingFor(VirtualFile file) {
        if (this.project.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot mappedRoot = this.mappingsHolder.getMappedRootFor(file);
        return mappedRoot != null ? mappedRoot.mapping : null;
    }

    public void setDirectoryMapping(@NotNull String path, @Nullable String activeVcsName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.mappingsLoaded) {
            return;
        }
        this.mappingsHolder.setMapping(FileUtil.toSystemIndependentName((String)path), activeVcsName);
    }

    /*
     * WARNING - void declaration
     */
    public final void registerNewDirectMappings(@NotNull Collection<? extends Pair<? extends VirtualFile, ? extends AbstractVcs>> detectedRoots) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(detectedRoots, (String)"detectedRoots");
        List<VcsDirectoryMapping> list = this.mappingsHolder.getDirectoryMappings();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDirectoryMappings(...)");
        List mappings = CollectionsKt.toMutableList((Collection)list);
        Iterable iterable = mappings;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv;
            void var11_10 = destination$iv;
            boolean bl = false;
            var11_10.add(it.getDirectory());
        }
        Set knownMappedRoots = (Set)destination$iv;
        Sequence newMappings = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)detectedRoots), ProjectLevelVcsManagerImpl::registerNewDirectMappings$lambda$1), arg_0 -> ProjectLevelVcsManagerImpl.registerNewDirectMappings$lambda$2(knownMappedRoots, arg_0));
        CollectionsKt.addAll((Collection)mappings, (Sequence)newMappings);
        this.setAutoDirectoryMappings(mappings);
    }

    public final void setAutoDirectoryMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.mappingsHolder.setDirectoryMappings(mappings);
        this.mappingsHolder.cleanupMappings();
    }

    public final void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)ELEMENT_MAPPING);
        this.mappingsHolder.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.mappingsHolder.setDirectoryMappings(mappings);
    }

    @Override
    public void scheduleMappedRootsUpdate() {
        this.mappingsHolder.scheduleMappedRootsUpdate();
    }

    public final void updateMappedVcsesImmediately() {
        this.mappingsHolder.updateMappedVcsesImmediately();
    }

    public void iterateVcsRoot(@NotNull VirtualFile root, @NotNull Processor<? super FilePath> iterator) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        VcsRootIterator.iterateVcsRoot(this.project, root, iterator);
    }

    public void iterateVcsRoot(@NotNull VirtualFile root, @NotNull Processor<? super FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        VcsRootIterator.iterateVcsRoot(this.project, root, iterator, directoryFilter);
    }

    public void iterateVfUnderVcsRoot(@NotNull VirtualFile file, @NotNull Processor<? super VirtualFile> processor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        VcsRootIterator.iterateVfUnderVcsRoot(this.project, file, processor2);
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option, @NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        PersistentVcsShowSettingOption options = this.getOptions(option);
        options.addApplicableVcs(vcs);
        return options;
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option, @Nullable AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        PersistentVcsShowConfirmationOption result2 = this.getConfirmation(option);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        return result2;
    }

    private final OptionsAndConfirmations getOptionsAndConfirmations() {
        OptionsAndConfirmations optionsAndConfirmations = OptionsAndConfirmationsHolder.getInstance(this.project).getOptionsAndConfirmations();
        Intrinsics.checkNotNullExpressionValue((Object)optionsAndConfirmations, (String)"getOptionsAndConfirmations(...)");
        return optionsAndConfirmations;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowConfirmationOption> getAllConfirmations() {
        List<PersistentVcsShowConfirmationOption> list = this.getOptionsAndConfirmations().getAllConfirmations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllConfirmations(...)");
        return list;
    }

    @Override
    @NotNull
    public PersistentVcsShowConfirmationOption getConfirmation(@NotNull VcsConfiguration.StandardConfirmation option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = this.getOptionsAndConfirmations().getConfirmation(option);
        Intrinsics.checkNotNullExpressionValue((Object)persistentVcsShowConfirmationOption, (String)"getConfirmation(...)");
        return persistentVcsShowConfirmationOption;
    }

    @Override
    @NotNull
    public PersistentVcsShowSettingOption getOptions(@NotNull VcsConfiguration.StandardOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.getOptionsAndConfirmations().getOption(option);
        Intrinsics.checkNotNullExpressionValue((Object)persistentVcsShowSettingOption, (String)"getOption(...)");
        return persistentVcsShowSettingOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowSettingOption> getAllOptions() {
        List<PersistentVcsShowSettingOption> list = this.getOptionsAndConfirmations().getAllOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllOptions(...)");
        return list;
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.backgroundOperationCounter.get() > 0;
    }

    public void startBackgroundVcsOperation() {
        this.backgroundOperationCounter.incrementAndGet();
    }

    public void stopBackgroundVcsOperation() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        int counter = this.backgroundOperationCounter.getAndDecrement();
        LOG.assertTrue(counter > 0, (Object)("myBackgroundOperationCounter was " + counter + " while should have been > 0"));
    }

    @NotNull
    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        List<VirtualFile> list = this.mappingsHolder.getMappingsAsFilesUnderVcs(vcs);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMappingsAsFilesUnderVcs(...)");
        return list;
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        VirtualFile[] virtualFileArray = MappingsToRoots.getRootsUnderVcs(this.project, this.mappingsHolder, vcs);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootsUnderVcs(...)");
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getAllVersionedRoots() {
        ArrayList vFiles = new ArrayList();
        AbstractVcs[] abstractVcsArray = this.mappingsHolder.getActiveVcses();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getActiveVcses(...)");
        for (AbstractVcs vcs : abstractVcsArray) {
            Collection collection = vFiles;
            Intrinsics.checkNotNull((Object)vcs);
            VirtualFile[] virtualFileArray = this.getRootsUnderVcs(vcs);
            Collections.addAll(collection, Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)vFiles);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
        return virtualFileArray;
    }

    @NotNull
    public VcsRoot[] getAllVcsRoots() {
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        AbstractVcs[] abstractVcsArray = this.mappingsHolder.getActiveVcses();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getActiveVcses(...)");
        for (AbstractVcs vcs : abstractVcsArray) {
            Intrinsics.checkNotNull((Object)vcs);
            for (VirtualFile root : this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        Collection $this$toTypedArray$iv = vcsRoots;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VcsRoot[0]);
    }

    @NotNull
    public String getConsolidatedVcsName() {
        AbstractVcs singleVcs = this.getSingleVCS();
        Object object = singleVcs;
        if (object == null || (object = object.getShortNameWithMnemonic()) == null) {
            String string = VcsBundle.message((String)"vcs.generic.name.with.mnemonic", (Object[])new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        return object;
    }

    @Override
    @Deprecated(message="A plugin should not need to call this.")
    public void notifyDirectoryMappingChanged() {
        this.fireDirectoryMappingsChanged();
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List mappingsList = new ArrayList();
        for (Element child : element.getChildren(ELEMENT_MAPPING)) {
            String vcsName = child.getAttributeValue(ATTRIBUTE_VCS);
            String directory = child.getAttributeValue(ATTRIBUTE_DIRECTORY);
            if (directory == null) continue;
            VcsRootSettings rootSettings = null;
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement != null) {
                AbstractVcs vcsInstance;
                String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
                AbstractVcs abstractVcs = vcsInstance = vcsName == null ? null : AllVcses.getInstance(this.project).getByName(vcsName);
                if (vcsInstance != null && className != null && (rootSettings = vcsInstance.createEmptyVcsRootSettings()) != null) {
                    try {
                        rootSettings.readExternal(rootSettingsElement);
                    }
                    catch (InvalidDataException e) {
                        LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
                    }
                }
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(directory, vcsName, rootSettings);
            mappingsList.add(mapping);
            this.mappingsLoaded |= !mapping.isDefaultMapping();
        }
        this.mappingsHolder.setDirectoryMappingsFromConfig(mappingsList);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && mapping.isDefaultMapping() && mapping.isNoneMapping()) continue;
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
        return element;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashSet<String> checkedVcses = new HashSet<String>();
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            String vcsName = checker.getSupportedVcs().getName();
            checkedVcses.add(vcsName);
            if (!checker.isRoot(file)) continue;
            return this.findVcsByName(vcsName);
        }
        String foundVcs = null;
        for (VcsDescriptor vcsDescriptor : this.getAllVcss()) {
            String vcsName = vcsDescriptor.getName();
            if (checkedVcses.contains(vcsName) || !vcsDescriptor.probablyUnderVcs(file)) continue;
            if (foundVcs != null) {
                return null;
            }
            foundVcs = vcsName;
        }
        return this.findVcsByName(foundVcs);
    }

    @NotNull
    public VcsRootChecker getRootChecker(@NotNull AbstractVcs vcs) {
        VcsRootChecker checker;
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        Iterator iterator = VcsRootChecker.EXTENSION_POINT_NAME.getIterable().iterator();
        while (iterator.hasNext() && (checker = (VcsRootChecker)iterator.next()) != null) {
            if (!Intrinsics.areEqual((Object)checker.getSupportedVcs(), (Object)vcs.getKeyInstanceMethod())) continue;
            return checker;
        }
        String string = vcs.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new DefaultVcsRootChecker(vcs, this.getDescriptor(string));
    }

    private final VcsDescriptor getDescriptor(String vcsName) {
        if (this.project.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.project).getDescriptor(vcsName);
    }

    @NotNull
    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.project);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.project.isOpen() && !this.project.isDisposed()) {
            this.mappingsHolder.notifyMappingsChanged();
        }
    }

    @Override
    @Nullable
    public String haveDefaultMapping() {
        return this.mappingsHolder.haveDefaultMapping();
    }

    public final boolean isBackgroundTaskRunning(Object ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        return this.backgroundRunningTasks.contains(new ActionKey(Arrays.copyOf(keys, keys.length)));
    }

    @RequiresEdt
    public final void startBackgroundTask(Object ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.backgroundRunningTasks.add(new ActionKey(Arrays.copyOf(keys, keys.length))));
    }

    @RequiresEdt
    public final void stopBackgroundTask(Object ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.backgroundRunningTasks.remove(new ActionKey(Arrays.copyOf(keys, keys.length))));
    }

    public final void addInitializationRequest(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)vcsInitObject), (String)"vcsInitObject");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        VcsInitialization.Companion.getInstance(this.project).add(vcsInitObject, runnable);
    }

    public void runAfterInitialization(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, runnable);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object awaitInitialization(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitInitialization.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectLevelVcsManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitInitialization((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$serviceAsync$iv = (ComponentManager)this.project;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.label = 1;
                v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(VcsInitialization.class, (Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = ((VcsInitialization)v0).await((Continuation<? super Unit>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl37
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean isFileInContent(@Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        Object object = ReadAction.compute(() -> ProjectLevelVcsManagerImpl.isFileInContent$lambda$0(vf, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    public boolean isIgnored(@NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        Object object = ReadAction.compute(() -> ProjectLevelVcsManagerImpl.isIgnored$lambda$0(this, vf));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    public boolean isIgnored(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Object object = ReadAction.compute(() -> ProjectLevelVcsManagerImpl.isIgnored$lambda$1(this, filePath));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    private final boolean isInDirectoryBasedRoot(VirtualFile file) {
        if (ProjectKt.isDirectoryBased((Project)this.project)) {
            return ProjectKt.getStateStore((Project)this.project).isProjectFile(file);
        }
        return false;
    }

    private final boolean isFileInBaseDir(VirtualFile file) {
        VirtualFile virtualFile = this.project.getBaseDir();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile baseDir = virtualFile;
        if (file.isDirectory()) {
            return Intrinsics.areEqual((Object)baseDir, (Object)file);
        }
        return Intrinsics.areEqual((Object)baseDir, (Object)file.getParent());
    }

    private final boolean hasExplicitMapping(VirtualFile vFile) {
        VcsDirectoryMapping mapping = this.getDirectoryMappingFor(vFile);
        return mapping != null && !mapping.isDefaultMapping();
    }

    @TestOnly
    public final void waitForInitialized() {
        VcsInitialization.Companion.getInstance(this.project).waitFinished();
    }

    @Deprecated(message="Use {@link com.intellij.vcs.console.VcsConsoleTabService}")
    public void showConsole(@Nullable Runnable then) {
        VcsConsoleTabService.Companion.getInstance(this.project).showConsoleTab(true, null);
    }

    @Deprecated(message="Use {@link com.intellij.vcs.console.VcsConsoleTabService}")
    public void scrollConsoleToTheEnd() {
        VcsConsoleTabService.Companion.getInstance(this.project).showConsoleTabAndScrollToTheEnd();
    }

    @Deprecated(message="")
    public void addMessageToConsoleWindow(@Nullable String message, @Nullable TextAttributes attributes) {
        this.addMessageToConsoleWindow(message, new ConsoleViewContentType("", attributes));
    }

    public void addMessageToConsoleWindow(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        VcsConsoleTabService.Companion.getInstance(this.project).addMessage(message, contentType);
    }

    public void addMessageToConsoleWindow(@Nullable VcsConsoleLine line) {
        VcsConsoleTabService.Companion.getInstance(this.project).addMessage(line);
    }

    @Override
    @RequiresEdt
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(@Nullable UpdatedFiles updatedFiles, @Nullable String displayActionName, @Nullable ActionInfo actionInfo, boolean canceled) {
        if (!this.project.isOpen() || this.project.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        ContentManager contentManager2 = contentManager;
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager2, this.project, updatedFiles, displayActionName, actionInfo);
        String string = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String tabName = string;
        ContentUtilEx.addTabbedContent((ContentManager)contentManager2, (JComponent)((JComponent)((Object)updateInfoTree)), (String)"Update Info", (Supplier)VcsBundle.messagePointer((String)"vcs.update.tab.name", (Object[])new Object[0]), () -> ProjectLevelVcsManagerImpl.showUpdateProjectInfo$lambda$0(tabName), (boolean)false, (Disposable)((Disposable)updateInfoTree));
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    @TestOnly
    public final void registerVcs(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)ATTRIBUTE_VCS);
        AllVcses.getInstance(this.project).registerManually(vcs);
    }

    private static final void findVcsByName$lambda$0() {
        ProgressManager.checkCanceled();
    }

    private static final VcsDirectoryMapping registerNewDirectMappings$lambda$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        VirtualFile file = (VirtualFile)pair.component1();
        AbstractVcs vcs = (AbstractVcs)pair.component2();
        return new VcsDirectoryMapping(file.getPath(), vcs.getName());
    }

    private static final boolean registerNewDirectMappings$lambda$2(Set $knownMappedRoots, VcsDirectoryMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$knownMappedRoots.contains(it.getDirectory());
    }

    private static final Boolean isFileInContent$lambda$0(VirtualFile $vf, ProjectLevelVcsManagerImpl this$0) {
        if (!$vf.isValid()) {
            return false;
        }
        FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this$0.project);
        boolean isUnderProject = this$0.isFileInBaseDir($vf) || this$0.isInDirectoryBasedRoot($vf) || this$0.hasExplicitMapping($vf) || fileIndex.isInContent($vf) || !Registry.Companion.is("ide.hide.excluded.files") && fileIndex.isExcludedFile($vf);
        return isUnderProject && !this$0.isIgnored($vf);
    }

    private static final Boolean isIgnored$lambda$0(ProjectLevelVcsManagerImpl this$0, VirtualFile $vf) {
        if (this$0.project.isDisposed() || this$0.project.isDefault()) {
            return false;
        }
        if (!$vf.isValid()) {
            return false;
        }
        if (Registry.Companion.is("ide.hide.excluded.files")) {
            return FileIndexFacade.getInstance((Project)this$0.project).isExcludedFile($vf);
        }
        return FileIndexFacade.getInstance((Project)this$0.project).isUnderIgnored($vf);
    }

    private static final Boolean isIgnored$lambda$1(ProjectLevelVcsManagerImpl this$0, FilePath $filePath) {
        if (this$0.project.isDisposed() || this$0.project.isDefault()) {
            return false;
        }
        if (Registry.Companion.is("ide.hide.excluded.files")) {
            VirtualFile vf = VcsImplUtil.findValidParentAccurately($filePath);
            return vf != null && FileIndexFacade.getInstance((Project)this$0.project).isExcludedFile(vf);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (String name : StringUtil.tokenize((String)$filePath.getPath(), (String)"/")) {
            if (!fileTypeManager.isFileIgnored(name)) continue;
            return true;
        }
        return false;
    }

    private static final String showUpdateProjectInfo$lambda$0(String $tabName) {
        return $tabName;
    }

    @JvmStatic
    @NotNull
    public static final ProjectLevelVcsManagerImpl getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    static {
        Logger logger = Logger.getInstance(ProjectLevelVcsManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActionKey;", "", "objects", "", "<init>", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class ActionKey {
        @NotNull
        private final Object[] objects;

        public ActionKey(Object ... objects) {
            Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
            this.objects = objects;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            Object[] objectArray = this.objects;
            return Arrays.equals(objectArray, ((ActionKey)other).objects);
        }

        public int hashCode() {
            return Arrays.hashCode(this.objects);
        }

        @NotNull
        public String toString() {
            String string = this.getClass().toString();
            String string2 = Arrays.toString(this.objects);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string + " - " + string2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActivateVcsesStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "<init>", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "order", "", "getOrder", "()I", "intellij.platform.vcs.impl"})
    public static final class ActivateVcsesStartupActivity
    implements VcsStartupActivity {
        @Override
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstanceImpl(project).mappingsHolder.activateActiveVcses();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ELEMENT_MAPPING", "", "Lorg/jetbrains/annotations/NonNls;", "ATTRIBUTE_DIRECTORY", "ATTRIBUTE_VCS", "ELEMENT_ROOT_SETTINGS", "ATTRIBUTE_CLASS", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectLevelVcsManagerImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)projectLevelVcsManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
            return (ProjectLevelVcsManagerImpl)projectLevelVcsManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$TrustListener;", "Lcom/intellij/ide/trustedProjects/TrustedProjectsListener;", "<init>", "()V", "onProjectTrusted", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class TrustListener
    implements TrustedProjectsListener {
        public void onProjectTrusted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstanceImpl(project).updateMappedVcsesImmediately();
        }
    }
}

