/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.StubbedSentence;
import ai.grazie.rules.tree.Tree;
import ai.grazie.text.exclusions.SentenceWithExclusions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DocumentParserHelper {
    private final List<DocumentSentence> rawDoc;

    public DocumentParserHelper(List<DocumentSentence> rawDoc) {
        this.rawDoc = rawDoc;
        for (DocumentSentence sentence : rawDoc) {
            if (!(sentence instanceof DocumentSentence.Parsed)) continue;
            throw new IllegalArgumentException("The document is already parsed");
        }
    }

    public List<DocumentSentence.Parsed> withTrees(Map<Language, Map<String, Tree>> trees) {
        ArrayList<DocumentSentence.Parsed> parsedDoc = new ArrayList<DocumentSentence.Parsed>();
        int offset = 0;
        for (DocumentSentence sentence : this.rawDoc) {
            Map langTrees = trees.getOrDefault(sentence.language, Map.of());
            Tree tree = (Tree)langTrees.get(sentence.text);
            if (tree != null) {
                Tree stubTree;
                tree = tree.withStartOffset(offset);
                SentenceWithExclusions swe = DocumentParserHelper.toSentenceWithExclusions(sentence);
                String stubbedText = swe.stubExclusions();
                if (stubbedText != null && (stubTree = (Tree)langTrees.get(stubbedText)) != null) {
                    tree = tree.withStubbed(new StubbedSentence(swe, stubTree.withStartOffset(offset)));
                }
            }
            parsedDoc.add(sentence.withTree(tree));
            offset += sentence.text.length();
        }
        return parsedDoc;
    }

    private static SentenceWithExclusions toSentenceWithExclusions(DocumentSentence sentence) {
        return new SentenceWithExclusions(sentence.text, sentence.exclusions);
    }

    public Map<Language, List<String>> sentencesToParse() {
        LinkedHashMap<Language, List<String>> textsToParse = new LinkedHashMap<Language, List<String>>();
        for (DocumentSentence sentence : this.rawDoc) {
            List texts = textsToParse.computeIfAbsent(sentence.language, __ -> new ArrayList());
            texts.add(sentence.text);
            String stub = DocumentParserHelper.toSentenceWithExclusions(sentence).stubExclusions();
            if (stub == null) continue;
            texts.add(stub);
        }
        return textsToParse;
    }
}

