/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javajs.util.BS;
import javajs.util.JSJSONParser;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.jmol.c.CBK;
import org.jmol.dialog.FileChooser;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.quantum.NMRCalculation;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.janocchio.CoupleTable;
import org.openscience.jmol.app.janocchio.FrameCounter;
import org.openscience.jmol.app.janocchio.FrameDeltaDisplay;
import org.openscience.jmol.app.janocchio.LabelSetter;
import org.openscience.jmol.app.janocchio.LoadMeasureThread;
import org.openscience.jmol.app.janocchio.LoadMeasureThreadJSON;
import org.openscience.jmol.app.janocchio.MyFileFilter;
import org.openscience.jmol.app.janocchio.NMR_DisplayPanel;
import org.openscience.jmol.app.janocchio.NMR_Viewer;
import org.openscience.jmol.app.janocchio.NamfisReader;
import org.openscience.jmol.app.janocchio.NamfisSaver;
import org.openscience.jmol.app.janocchio.Nmr;
import org.openscience.jmol.app.janocchio.NmrApplet;
import org.openscience.jmol.app.janocchio.NmrGuiMap;
import org.openscience.jmol.app.janocchio.NmrMolecule;
import org.openscience.jmol.app.janocchio.NmrReader;
import org.openscience.jmol.app.janocchio.NmrResourceHandler;
import org.openscience.jmol.app.janocchio.NmrSaver;
import org.openscience.jmol.app.janocchio.NoeTable;
import org.openscience.jmol.app.janocchio.PopulationDisplay;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.status.StatusListener;

public class NMR_JmolPanel
extends JmolPanel {
    static final int MIN_SIZE = 600;
    private NMR_DisplayPanel nmrDisplay;
    public JSplitPane mainSplitPane;
    public NoeTable noeTable;
    public CoupleTable coupleTable;
    public FrameCounter frameCounter;
    public LabelSetter labelSetter;
    public PopulationDisplay populationDisplay;
    public FrameDeltaDisplay frameDeltaDisplay;
    protected static File currentDir;
    FileChooser openChooser;
    JFileChooser exportChooser;
    JFileChooser saveNmrChooser;
    JFileChooser readNmrChooser;
    JFileChooser saveNamfisChooser;
    JFileChooser readNamfisChooser;
    NmrApplet nmrApplet;
    boolean isApplet;
    private NmrGuiMap nmrguimap;
    static Point border;
    static Boolean haveBorder;
    static Set<String> htGuiChanges;
    private static final String saveNmrAction = "NMR.saveNmr";
    private static final String readNmrAction = "NMR.readNmr";
    private static final String detachAppletAction = "NMR.detachApplet";
    private static final String reattachAppletAction = "NMR.reattachApplet";
    private static final String writeNamfisAction = "NMR.writeNamfis";
    private static final String readNamfisAction = "NMR.readNamfis";
    private static final String jumpBestFrameAction = "NMR.jumpBestFrame";
    private static final String labelNmrAction = "NMR.labelNmr";
    public static final String chemFileProperty = "chemFile";
    protected Map<String, Thread> htMessageCallbacks = new Hashtable<String, Thread>();

    public JMenuItem getMenuItem(String name) {
        return (JMenuItem)this.nmrguimap.get(name);
    }

    public NMR_JmolPanel(JmolApp jmolApp, Splash splash, JFrame frame, Jmol parent, int startupWidth, int startupHeight, Map<String, Object> vwrOptions, Point loc) {
        super(jmolApp, splash, frame, (JmolPanel)parent, startupWidth, startupHeight, vwrOptions, loc);
    }

    NmrMolecule getDistanceJMolecule(BS mol, String[] labelArray, boolean forNOE) {
        return new NmrMolecule(this, mol == null ? this.vwr.getFrameAtoms() : mol, labelArray, forNOE);
    }

    BS[] getAllMolecules() {
        int mc = ((NMR_Viewer)this.vwr).getModelCount();
        BS[] mols = new BS[mc];
        int i = mc;
        while (--i >= 0) {
            mols[i] = this.vwr.getModelUndeletedAtomsBitSet(i);
        }
        return mols;
    }

    protected String getWindowName() {
        return "Janocchio";
    }

    protected List<Action> getFrameActions() {
        List actions = super.getFrameActions();
        Action[] a = new Action[]{new ReadNmrAction(), new SaveNmrAction(), new DetachAppletAction(), new ReattachAppletAction(), new WriteNamfisAction(), new ReadNamfisAction(), new LabelNmrAction(), new JumpBestFrameAction(), new ViewNoeTableAction(), new ViewCoupleTableAction()};
        int i = a.length;
        while (--i >= 0) {
            actions.add(a[i]);
        }
        return actions;
    }

    protected String getStringX(String cmd) {
        return cmd.indexOf("NMR.") == 0 ? NmrResourceHandler.getStringX(cmd) : JmolResourceHandler.getStringX((String)cmd);
    }

    protected ImageIcon getIconX(String img) {
        return img.indexOf("NMR.") == 0 ? NmrResourceHandler.getIconX(img) : JmolResourceHandler.getIconX((String)img);
    }

    protected GuiMap createGuiMap() {
        this.nmrguimap = new NmrGuiMap();
        return this.nmrguimap;
    }

    protected StatusBar createStatusBar() {
        return super.createStatusBar();
    }

    protected JToolBar createToolBar() {
        JToolBar toolbar = this.newToolbar(NMR_JmolPanel.tokenize(NmrResourceHandler.getStringX("toolbar")));
        this.frameCounter = new FrameCounter((NMR_Viewer)this.vwr);
        toolbar.add((Component)this.frameCounter, "East");
        this.say(GT.$("Initializing Noes..."));
        this.noeTable = new NoeTable(this, this.frame);
        this.say(GT.$("Initializing Couples..."));
        this.coupleTable = new CoupleTable(this, this.frame);
        this.labelSetter = new LabelSetter((NMR_Viewer)this.vwr, this.noeTable, this.coupleTable);
        toolbar.add((Component)this.labelSetter, "East");
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    protected void createDisplayAndAddStatusListener() {
        this.isPlugin = ((Nmr)this.jmolApp).isPlugin();
        this.say(GT.$("Initializing 3D display..."));
        this.nmrDisplay = new NMR_DisplayPanel(this);
        this.display = this.nmrDisplay;
        this.vwrOptions.put("display", this.display);
        this.myStatusListener = new MyStatusListener((JmolPanel)this, this.display);
        this.vwrOptions.put("statusListener", this.myStatusListener);
    }

    protected void setupModelAdapterAndViewer() {
        if (JmolResourceHandler.codePath != null) {
            this.vwrOptions.put("codePath", JmolResourceHandler.codePath);
        }
        if (this.modelAdapter != null) {
            this.vwrOptions.put("modelAdapter", this.modelAdapter);
        }
        this.say(GT.$("Initializing 3D display...4"));
        this.vwr = new NMR_Viewer(this.vwrOptions);
        this.say(GT.$("Initializing 3D display...5"));
        this.nmrDisplay.setViewer(this.vwr);
    }

    protected void getDialogs() {
        super.getDialogs();
    }

    protected void getMeasurementTable() {
        super.getMeasurementTable();
    }

    protected void setupDisplay() {
        super.setupDisplay();
    }

    protected void setFrameLocation(Point loc, JmolPanel parent) {
        super.setFrameLocation(loc, parent);
    }

    protected void setIntoFrame() {
        this.frame.setTitle("Janocchio");
        this.frame.setBackground(Color.lightGray);
        this.frame.setLayout(new BorderLayout());
        this.frame.setBounds(0, 0, this.startupWidth, this.startupHeight);
        Container contentPane = this.frame.getContentPane();
        this.mainSplitPane = new JSplitPane(1, null, null);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setContinuousLayout(true);
        this.mainSplitPane.setLeftComponent((Component)((Object)this));
        this.frame.setMinimumSize(new Dimension(this.startupWidth + 400, 100));
        JSplitPane splitPaneRight = new JSplitPane(0, null, null);
        splitPaneRight.setOneTouchExpandable(true);
        JPanel noePanel = new JPanel();
        noePanel.setLayout(new BoxLayout(noePanel, 3));
        JLabel label = new JLabel("NOE Table", null, 0);
        label.setAlignmentX(0.5f);
        noePanel.add(label);
        noePanel.add(this.noeTable);
        JPanel couplePanel = new JPanel();
        couplePanel.setLayout(new BoxLayout(couplePanel, 3));
        JLabel label1 = new JLabel("Couple Table", null, 0);
        label1.setAlignmentX(0.5f);
        this.populationDisplay = new PopulationDisplay((NMR_Viewer)this.vwr);
        this.frameDeltaDisplay = new FrameDeltaDisplay((NMR_Viewer)this.vwr);
        this.nmrDisplay.setPopulationDisplay(this.populationDisplay);
        this.nmrDisplay.setFrameDeltaDisplay(this.frameDeltaDisplay);
        this.noeTable.setFrameDeltaDisplay(this.frameDeltaDisplay);
        this.coupleTable.setFrameDeltaDisplay(this.frameDeltaDisplay);
        couplePanel.add((Component)label1, "First");
        couplePanel.add((Component)this.coupleTable, "Center");
        couplePanel.add((Component)this.populationDisplay, "Last");
        couplePanel.add((Component)this.frameDeltaDisplay, "Last");
        splitPaneRight.setTopComponent(couplePanel);
        splitPaneRight.setBottomComponent(noePanel);
        this.mainSplitPane.setRightComponent(splitPaneRight);
        splitPaneRight.setMinimumSize(new Dimension(300, 500));
        contentPane.add((Component)this.mainSplitPane, "Center");
        contentPane.setPreferredSize(new Dimension(this.startupWidth, this.startupHeight));
        this.frame.pack();
        ImageIcon jmolIcon = JmolResourceHandler.getIconX((String)"icon");
        Image iconImage = jmolIcon.getImage();
        this.frame.setIconImage(iconImage);
        if (!((Nmr)this.jmolApp).isPlugin()) {
            this.frame.addWindowListener((WindowListener)new JmolPanel.AppCloser((JmolPanel)this));
        }
    }

    protected void setupConsole() {
        super.setupConsole();
    }

    protected void setupDnD() {
        super.setupDnD();
    }

    protected void setAtomChooser() {
        super.setAtomChooser();
    }

    protected void launchMainFrame() {
        this.say(GT.$("Launching main frame..."));
    }

    protected void saveWindowSizes() {
        super.saveWindowSizes();
    }

    public void getJavaConsole() {
        super.getJavaConsole();
    }

    protected String setMenuKeys(String key, String tokens) {
        if (htGuiChanges.contains(key)) {
            String s = NmrResourceHandler.getStringX(key);
            if (s == null) {
                System.err.println("Replacement for " + key + " not found; using " + tokens);
            } else {
                if (s.startsWith("+")) {
                    s = s.substring(1);
                    int pt = tokens.lastIndexOf(" - ");
                    tokens = pt < 0 ? tokens + (key.endsWith("bar") ? " " : " - ") + s : tokens.substring(0, pt + 3) + s + tokens.substring(pt);
                } else {
                    tokens = s;
                }
                System.out.println("Replacement for " + key + " = " + tokens);
            }
        }
        return tokens;
    }

    protected boolean doClose(boolean saveSize) {
        if (this.isPlugin) {
            this.frame.setVisible(false);
            ((Nmr)this.jmolApp).plugin.setVisible(false);
        } else {
            super.doClose(saveSize);
        }
        return true;
    }

    void setCurrentDirectoryAll(File cDir) {
        this.openChooser.setCurrentDirectory(cDir);
        this.saveNmrChooser.setCurrentDirectory(cDir);
        this.saveNamfisChooser.setCurrentDirectory(cDir);
        this.readNmrChooser.setCurrentDirectory(cDir);
        this.readNamfisChooser.setCurrentDirectory(cDir);
    }

    public int getMinindex() {
        return this.labelSetter.getMinindex();
    }

    public String getCurrentStructureFile() {
        return this.vwr.getModelSetPathName();
    }

    public static File getUserDirectory() {
        if (System.getProperty("user.dir") == null) {
            return null;
        }
        return new File(System.getProperty("user.dir"));
    }

    protected static void dumpContainer(Container c, String s) {
        if (c == null) {
            return;
        }
        int i = c.getComponentCount();
        while (--i >= 0) {
            Container c1 = (Container)c.getComponent(i);
            System.out.println(s + c1);
            NMR_JmolPanel.dumpContainer(c1, s + " ");
        }
    }

    protected static String[] tokenize(String input) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.add(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.get(i);
        }
        return cmd;
    }

    public void writeNmrData(File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        String structurefile = this.vwr.getModelSetPathName();
        out.println(structurefile);
        String[] labelArray = this.labelSetter.getLabelArray();
        for (int i = 0; i < labelArray.length; ++i) {
            if (labelArray[i] == null) continue;
            out.println(String.valueOf(i + 1) + " " + labelArray[i]);
        }
        out.println("");
        int noeCount = this.noeTable.getRowCount();
        for (int i = 0; i < noeCount; ++i) {
            int[] atomIndices = this.noeTable.getMeasurementCountPlusIndices(i);
            out.println(String.valueOf(atomIndices[1] + 1) + " " + String.valueOf(atomIndices[2] + 1) + " " + this.noeTable.getExpNoe(atomIndices[1], atomIndices[2]));
        }
        out.println("");
        int coupleCount = this.coupleTable.getRowCount();
        for (int i = 0; i < coupleCount; ++i) {
            int[] atomIndices = this.coupleTable.getMeasurementCountPlusIndices(i);
            out.println(String.valueOf(atomIndices[1] + 1) + " " + String.valueOf(atomIndices[2] + 1) + " " + String.valueOf(atomIndices[3] + 1) + " " + String.valueOf(atomIndices[4] + 1) + " " + this.coupleTable.getExpCouple(atomIndices[1], atomIndices[4]));
        }
        out.flush();
        out.close();
    }

    public void readNmrData(File file) throws Exception {
        String fileData = this.vwr.getFileAsString(file.getAbsolutePath());
        String structureFile = NMR_JmolPanel.firstLineOf(fileData);
        fileData = fileData.substring(structureFile.length()).trim();
        this.checkLoadAndRun(structureFile, fileData, "jnc");
    }

    public void readNmrDataJSON(File file) throws Exception {
        String json = this.vwr.getFileAsString(file.getAbsolutePath());
        Map<String, Object> jsonData = new JSJSONParser().parseMap(json, true);
        String structureFile = (String)jsonData.get("StructureFile");
        this.checkLoadAndRun(structureFile, jsonData, "json");
    }

    private void checkLoadAndRun(String structureFile, Object fileData, String fileType) {
        LoadMeasureThread thread;
        int opt;
        String currentStructureFile = this.getCurrentStructureFile();
        if (currentStructureFile == null) {
            opt = JOptionPane.showConfirmDialog((Component)((Object)this), "No Structure File currently loaded.\nLoad Structure File " + structureFile + "\ndefined in this NMR Data File?", "No Structure Warning", 0);
            if (opt != 0) {
                return;
            }
        } else if (!currentStructureFile.equals(structureFile)) {
            opt = JOptionPane.showConfirmDialog((Component)((Object)this), "This NMR Data file was saved from a different structure file from that currently loaded.\nContinue Reading Data?", "Read NMR Data Warning", 0);
            if (opt != 0) {
                return;
            }
            structureFile = null;
        }
        LoadMeasureThread loadMeasureThread = thread = "jnc".equals(fileType) ? new LoadMeasureThread(this, (String)fileData) : new LoadMeasureThreadJSON(this, (Map)fileData);
        if (structureFile == null) {
            thread.start();
        } else {
            thread.loadAndRun(structureFile);
        }
    }

    private static String firstLineOf(String s) {
        int pt = s.indexOf("\n");
        if (pt < 0 && (pt = s.indexOf("\r")) < 0) {
            pt = s.length();
        }
        return s.substring(0, pt).trim();
    }

    void runScriptWithCallback(Thread t, String command) {
        String key = "NMR:" + t.getClass().getName();
        this.htMessageCallbacks.put(key, t);
        this.vwr.script(command);
        this.vwr.script("#>NMR>" + key + "<NMR<");
    }

    void notifyScriptCallback(String script) {
        int pt;
        int n = pt = script.startsWith("#>NMR>") ? script.indexOf("<NMR<") : -1;
        if (pt < 0) {
            return;
        }
        String key = script.substring(6, pt);
        Thread t = this.htMessageCallbacks.remove(key);
        if (t != null) {
            t.start();
        }
    }

    public int getFrameAtomCount() {
        return this.vwr.getFrameAtoms().cardinality();
    }

    Atom[] getViewerMeasurement(int vRow, int type) {
        int[] m = this.vwr.getMeasurementCountPlusIndices(vRow);
        if (m[0] != 2) {
            return null;
        }
        Atom[] atoms = new Atom[]{((NMR_Viewer)this.vwr).getAtomAt(m[1]), null, null, ((NMR_Viewer)this.vwr).getAtomAt(m[2])};
        return NMRCalculation.getCalcType(atoms, null, type) == 0 ? null : atoms;
    }

    int getViewerRow(int row, int type) {
        int j = -1;
        for (int i = 0; i < this.vwr.getMeasurementCount(); ++i) {
            if (this.getViewerMeasurement(i, type) == null || ++j != row) continue;
            return i;
        }
        return -1;
    }

    void clearViewerSelection() {
        this.vwr.script("select none");
    }

    static {
        haveBorder = Boolean.FALSE;
        htGuiChanges = new HashSet<String>();
        String[] changes = NMR_JmolPanel.tokenize(NmrResourceHandler.getStringX("changes"));
        int i = changes.length;
        while (--i >= 0) {
            htGuiChanges.add(changes[i]);
        }
    }

    class MyStatusListener
    extends StatusListener {
        private String defaultFormat;

        MyStatusListener(JmolPanel jmol, DisplayPanel display) {
            super(jmol, display);
            this.defaultFormat = "set measurementUnits noe_hz";
        }

        private void notifyFileLoaded(String fullPathName, String fileName, String modelName, String errorMsg, Boolean isAsync) {
            if (errorMsg != null) {
                return;
            }
            if (NMR_JmolPanel.this.jmolApp.haveDisplay) {
                NMR_JmolPanel.this.pcs.firePropertyChange(NMR_JmolPanel.chemFileProperty, null, fullPathName);
            }
            int nmodel = ((NMR_Viewer)NMR_JmolPanel.this.vwr).getModelCount();
            NMR_JmolPanel.this.frameCounter.setFrameCount(nmodel);
            NMR_JmolPanel.this.populationDisplay.setVisible(false);
            NMR_JmolPanel.this.frameDeltaDisplay.setVisible(true);
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)NMR_JmolPanel.this.getMenuItem("NMR.frameDeltaDisplayCheck");
            mi.setSelected(true);
            if (this.defaultFormat != null) {
                NMR_JmolPanel.this.vwr.script(this.defaultFormat);
            }
        }

        public void notifyFrameChanged(int modelIndex) {
            if (NMR_JmolPanel.this.vwr == null || modelIndex < 0) {
                return;
            }
            if (modelIndex == Integer.MIN_VALUE) {
                modelIndex = ((NMR_Viewer)NMR_JmolPanel.this.vwr).getCurrentModelIndex();
            }
            int modelAtomCount = NMR_JmolPanel.this.getFrameAtomCount();
            if (NMR_JmolPanel.this.labelSetter.getLabelArray() == null || modelAtomCount != NMR_JmolPanel.this.labelSetter.getLabelArray().length) {
                NMR_JmolPanel.this.labelSetter.allocateLabelArray(modelAtomCount);
                NMR_JmolPanel.this.noeTable.allocateLabelArray(modelAtomCount);
                NMR_JmolPanel.this.noeTable.allocateExpNoes(modelAtomCount);
                NMR_JmolPanel.this.coupleTable.allocateLabelArray(modelAtomCount);
                NMR_JmolPanel.this.coupleTable.allocateExpCouples(modelAtomCount);
            }
            NMR_JmolPanel.this.frameCounter.setFrameNumberFromViewer(modelIndex + 1);
            NMR_JmolPanel.this.populationDisplay.setFrameNumberFromViewer(modelIndex + 1);
            NMR_JmolPanel.this.coupleTable.setmolCDKuptodate(false);
            NMR_JmolPanel.this.noeTable.setmolCDKuptodate(false);
            NMR_JmolPanel.this.noeTable.addMol();
            NMR_JmolPanel.this.coupleTable.updateTables();
            NMR_JmolPanel.this.noeTable.updateTables();
        }

        public void notifyAtomPicked(int atomIndex, String strInfo) {
            if (atomIndex < 0) {
                return;
            }
            int atomNo = ((NMR_Viewer)NMR_JmolPanel.this.vwr).getAtomNumber(atomIndex);
            NMR_JmolPanel.this.labelSetter.setSelectedAtomIndex(atomNo - 1);
            String command = "set display SELECTED; select (atomindex=" + atomIndex + ")";
            NMR_JmolPanel.this.vwr.script(command);
        }

        @Override
        public void notifyCallback(CBK type, Object[] data) {
            String strInfo = data == null || data[1] == null ? null : data[1].toString();
            super.notifyCallback(type, data);
            switch (type) {
                case LOADSTRUCT: {
                    this.notifyFileLoaded(strInfo, (String)data[2], (String)data[3], (String)data[4], (Boolean)data[8]);
                    break;
                }
                case ANIMFRAME: {
                    int[] iData = (int[])data[1];
                    int modelIndex = iData[0];
                    this.notifyFrameChanged(modelIndex);
                    break;
                }
                case PICK: {
                    int atomIndex = (Integer)data[2];
                    this.notifyAtomPicked(atomIndex, strInfo);
                    break;
                }
                case MEASURE: {
                    Integer picked;
                    String mystatus = (String)data[3];
                    if (this.defaultFormat != null) {
                        NMR_JmolPanel.this.vwr.script(this.defaultFormat);
                        this.defaultFormat = null;
                    }
                    if (mystatus.equals("measurePending") || mystatus.equals("measureDeleted")) {
                        return;
                    }
                    if (mystatus.indexOf("Sequence") < 0 && mystatus.indexOf("Picked") >= 0 && (picked = (Integer)NMR_JmolPanel.this.vwr.getPOrNull("_picked")) != null) {
                        this.notifyAtomPicked(picked, strInfo);
                    }
                    int n = NMR_JmolPanel.this.vwr.getMeasurementCount() - 1;
                    System.out.println("checking for measurement " + n);
                    if (NMR_JmolPanel.this.getViewerMeasurement(n, 7) == null && NMR_JmolPanel.this.getViewerMeasurement(n, 8) == null) {
                        NMR_JmolPanel.this.vwr.deleteMeasurement(n);
                        return;
                    }
                    System.out.println("updating for measurement " + n);
                    NMR_JmolPanel.this.noeTable.updateTables();
                    NMR_JmolPanel.this.coupleTable.updateTables();
                    break;
                }
                case MESSAGE: {
                    break;
                }
                case APPLETREADY: 
                case ATOMMOVED: 
                case AUDIO: 
                case CLICK: 
                case DRAGDROP: 
                case ECHO: 
                case ERROR: 
                case EVAL: 
                case HOVER: 
                case IMAGE: 
                case MINIMIZATION: 
                case RESIZE: 
                case SELECT: {
                    break;
                }
                case SCRIPT: {
                    Integer status = (Integer)data[3];
                    if (status >= -1) break;
                    NMR_JmolPanel.this.notifyScriptCallback(data[2].toString());
                    break;
                }
                case SERVICE: {
                    break;
                }
                case STRUCTUREMODIFIED: {
                    this.notifyStructureModified();
                    break;
                }
                case SYNC: {
                    break;
                }
            }
        }

        public void notifyStructureModified() {
            NMR_JmolPanel.this.vwr.deleteMeasurement(NMR_JmolPanel.this.vwr.getMeasurementCount() - 1);
            this.notifyFrameChanged(Integer.MIN_VALUE);
        }
    }

    private abstract class MoleculeDependentAction
    extends AbstractAction
    implements PropertyChangeListener {
        public MoleculeDependentAction(String name) {
            super(name);
            this.setEnabled(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals(NMR_JmolPanel.chemFileProperty)) {
                if (event.getNewValue() != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }

    public class ViewCoupleTableAction
    extends MoleculeDependentAction {
        public ViewCoupleTableAction() {
            super("viewCoupleTable");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NMR_JmolPanel.this.coupleTable.activate();
        }
    }

    public class ViewNoeTableAction
    extends MoleculeDependentAction {
        public ViewNoeTableAction() {
            super("viewNoeTable");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NMR_JmolPanel.this.noeTable.activate();
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super("atomsetchooser");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NMR_JmolPanel.this.atomSetChooser != null) {
                NMR_JmolPanel.this.atomSetChooser.setVisible(true);
            }
        }
    }

    public class JumpBestFrameAction
    extends AbstractAction {
        public JumpBestFrameAction() {
            super(NMR_JmolPanel.jumpBestFrameAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int frame = new LoadMeasureThreadJSON(NMR_JmolPanel.this, null).jumpBestFrame();
            if (frame >= 0) {
                NMR_JmolPanel.this.frameCounter.setFrameNumberChangeViewer(frame);
            }
        }
    }

    public class WriteNamfisAction
    extends AbstractAction {
        public WriteNamfisAction() {
            super(NMR_JmolPanel.writeNamfisAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            NamfisSaver namfisSaver = new NamfisSaver(NMR_JmolPanel.this.saveNamfisChooser);
            NMR_JmolPanel.this.saveNamfisChooser.setAccessory(namfisSaver);
            int retval = NMR_JmolPanel.this.saveNamfisChooser.showSaveDialog((Component)((Object)NMR_JmolPanel.this));
            File cDir = NMR_JmolPanel.this.saveNamfisChooser.getCurrentDirectory();
            NMR_JmolPanel.this.setCurrentDirectoryAll(cDir);
            if (retval == 0 && (file = NMR_JmolPanel.this.saveNamfisChooser.getSelectedFile()) != null) {
                String name = file.getAbsolutePath();
                String[] exts = new String[]{"in1", "in2", "in3"};
                MyFileFilter filter = new MyFileFilter(exts, "");
                if (filter.checkExtension(file)) {
                    name = name.replaceFirst(".in[0-9]$", "");
                }
                try {
                    new LoadMeasureThreadJSON(NMR_JmolPanel.this, null).writeNamfisFiles(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class ReadNamfisAction
    extends AbstractAction {
        public ReadNamfisAction() {
            super(NMR_JmolPanel.readNamfisAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            NamfisReader namfisReader = new NamfisReader(NMR_JmolPanel.this.readNamfisChooser);
            NMR_JmolPanel.this.readNamfisChooser.setAccessory(namfisReader);
            int retval = NMR_JmolPanel.this.readNamfisChooser.showOpenDialog((Component)((Object)NMR_JmolPanel.this));
            File cDir = NMR_JmolPanel.this.readNamfisChooser.getCurrentDirectory();
            NMR_JmolPanel.this.setCurrentDirectoryAll(cDir);
            if (retval == 0 && (file = NMR_JmolPanel.this.readNamfisChooser.getSelectedFile()) != null) {
                try {
                    this.readNamfisOutput(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean readNamfisOutput(File file) throws IOException {
            BufferedReader inp = new BufferedReader(new FileReader(file));
            String line = inp.readLine();
            if (line.matches("No feasible solution")) {
                inp.close();
                return false;
            }
            inp.readLine();
            inp.readLine();
            inp.readLine();
            int nmodel = ((NMR_Viewer)NMR_JmolPanel.this.vwr).getModelCount();
            double[] population = new double[nmodel + 1];
            for (int i = 0; i <= nmodel; ++i) {
                population[i] = 0.0;
            }
            while ((line = inp.readLine()).trim().length() != 0) {
                double p;
                String[] l = line.split("[()=\\s]+");
                int i = new Integer(l[1]);
                population[i] = p = new Double(l[2]).doubleValue();
            }
            NMR_JmolPanel.this.populationDisplay.addPopulation(population);
            NMR_JmolPanel.this.frameDeltaDisplay.setVisible(false);
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)NMR_JmolPanel.this.getMenuItem("NMR.populationDisplayCheck");
            mi.setSelected(true);
            inp.close();
            return true;
        }
    }

    public class ReattachAppletAction
    extends AbstractAction {
        public ReattachAppletAction() {
            super(NMR_JmolPanel.reattachAppletAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class DetachAppletAction
    extends AbstractAction {
        public DetachAppletAction() {
            super(NMR_JmolPanel.detachAppletAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class LabelNmrAction
    extends AbstractAction {
        public LabelNmrAction() {
            super(NMR_JmolPanel.labelNmrAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] labelArray = NMR_JmolPanel.this.labelSetter.getLabelArray();
            String command = new String();
            for (int i = 0; i < labelArray.length; ++i) {
                command = command + NMR_JmolPanel.this.labelSetter.setLabelString(i, labelArray[i]);
            }
            NMR_JmolPanel.this.vwr.script(command);
        }
    }

    public class ReadNmrAction
    extends AbstractAction {
        public ReadNmrAction() {
            super(NMR_JmolPanel.readNmrAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            NmrReader nmrReader = new NmrReader(NMR_JmolPanel.this.readNmrChooser);
            NMR_JmolPanel.this.readNmrChooser.setAccessory(nmrReader);
            int retval = NMR_JmolPanel.this.readNmrChooser.showOpenDialog((Component)((Object)NMR_JmolPanel.this));
            File cDir = NMR_JmolPanel.this.readNmrChooser.getCurrentDirectory();
            NMR_JmolPanel.this.setCurrentDirectoryAll(cDir);
            if (retval == 0 && (file = NMR_JmolPanel.this.readNmrChooser.getSelectedFile()) != null) {
                try {
                    MyFileFilter filter = new MyFileFilter("jnc", "NMR Data files");
                    if (filter.checkExtension(file)) {
                        NMR_JmolPanel.this.readNmrData(file);
                    } else {
                        NMR_JmolPanel.this.readNmrDataJSON(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class SaveNmrAction
    extends AbstractAction {
        public SaveNmrAction() {
            super(NMR_JmolPanel.saveNmrAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NmrSaver nmrSaver = new NmrSaver(NMR_JmolPanel.this.saveNmrChooser);
            NMR_JmolPanel.this.saveNmrChooser.setAccessory(nmrSaver);
            int retval = NMR_JmolPanel.this.saveNmrChooser.showSaveDialog((Component)((Object)NMR_JmolPanel.this));
            File cDir = NMR_JmolPanel.this.saveNmrChooser.getCurrentDirectory();
            NMR_JmolPanel.this.setCurrentDirectoryAll(cDir);
            if (retval == 0) {
                File file = NMR_JmolPanel.this.saveNmrChooser.getSelectedFile();
                MyFileFilter filter = new MyFileFilter("jsn", "NMR Data files");
                if (file != null) {
                    if (!filter.checkExtension(file)) {
                        String name = file.getAbsolutePath();
                        name = name + ".jsn";
                        file = new File(name);
                    }
                    try {
                        new LoadMeasureThreadJSON(NMR_JmolPanel.this, null).writeNmrDataJSON(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

