/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaJoin;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.AliasCollisionException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.spi.NavigablePath;

public class SqmPathRegistryImpl
implements SqmPathRegistry {
    private final SqmCreationProcessingState associatedProcessingState;
    private final JpaCompliance jpaCompliance;
    private final Map<NavigablePath, SqmPath<?>> sqmPathByPath = new HashMap();
    private final Map<NavigablePath, SqmFrom<?, ?>> sqmFromByPath = new HashMap();
    private final Map<String, SqmFrom<?, ?>> sqmFromByAlias = new HashMap();
    private final List<SqmAliasedNode<?>> simpleSelectionNodes = new ArrayList();

    public SqmPathRegistryImpl(SqmCreationProcessingState associatedProcessingState) {
        this.associatedProcessingState = associatedProcessingState;
        this.jpaCompliance = associatedProcessingState.getCreationState().getCreationContext().getNodeBuilder().getJpaCompliance();
    }

    private String handleAliasCaseSensitivity(String alias) {
        return this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
    }

    @Override
    public void register(SqmPath<?> sqmPath) {
        SqmPath<?> previousPath;
        NavigablePath navigablePath = sqmPath.getNavigablePath();
        if (sqmPath instanceof SqmFrom) {
            SqmFrom sqmFrom = (SqmFrom)sqmPath;
            this.registerByAliasOnly(sqmFrom);
            SqmFrom previousFromByPath = this.sqmFromByPath.put(navigablePath, sqmFrom);
            if (previousFromByPath != null) {
                throw new ParsingException(String.format(Locale.ROOT, "Registration for SqmFrom [%s] overrode previous registration: %s -> %s", navigablePath, previousFromByPath, sqmFrom));
            }
        }
        if ((previousPath = this.sqmPathByPath.put(navigablePath, sqmPath)) instanceof SqmFrom) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for path [%s] overrode previous registration: %s -> %s", navigablePath, previousPath, sqmPath));
        }
    }

    private static String fromPath(SqmFrom<?, ?> sqmFrom, boolean first) {
        String keyword = sqmFrom instanceof SqmRoot && first ? "from " : (sqmFrom instanceof SqmJoin ? (first ? "join " : " join ") : (first ? "" : ", "));
        String path = sqmFrom.getNavigablePath().getLocalName();
        String alias = sqmFrom.getExplicitAlias();
        return keyword + (String)(alias == null ? path : path + " as " + alias);
    }

    @Override
    public void registerByAliasOnly(SqmFrom<?, ?> sqmFrom) {
        SqmFrom<?, ?> previousFrom;
        String alias = sqmFrom.getExplicitAlias();
        if (alias != null && (previousFrom = this.sqmFromByAlias.put(this.handleAliasCaseSensitivity(alias), sqmFrom)) != null) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Duplicate identification variable '%s' in 'from' clause [%s%s]", alias, SqmPathRegistryImpl.fromPath(previousFrom, true), SqmPathRegistryImpl.fromPath(sqmFrom, false)));
        }
    }

    @Override
    public <E> void replace(SqmEntityJoin<?, E> sqmJoin, SqmRoot<E> sqmRoot) {
        SqmFrom previousFrom;
        String alias = sqmJoin.getExplicitAlias();
        if (alias != null && (previousFrom = (SqmFrom)this.sqmFromByAlias.put(this.handleAliasCaseSensitivity(alias), sqmJoin)) != null && !(previousFrom instanceof SqmRoot)) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Duplicate identification variable '%s' in 'join' clause [%s%s]", alias, SqmPathRegistryImpl.fromPath(previousFrom, true), SqmPathRegistryImpl.fromPath(sqmJoin, false)));
        }
        NavigablePath navigablePath = sqmJoin.getNavigablePath();
        SqmFrom previousFromByPath = this.sqmFromByPath.put(navigablePath, sqmJoin);
        if (previousFromByPath != null && !(previousFromByPath instanceof SqmRoot)) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for SqmFrom [%s] overrode previous registration: %s -> %s", navigablePath, previousFromByPath, sqmJoin));
        }
        SqmPath previousPath = this.sqmPathByPath.put(navigablePath, sqmJoin);
        if (previousPath instanceof SqmFrom && !(previousPath instanceof SqmRoot)) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for path [%s] overrode previous registration: %s -> %s", navigablePath, previousPath, sqmJoin));
        }
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromByPath(NavigablePath navigablePath) {
        return (X)this.sqmFromByPath.get(navigablePath);
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromByAlias(String alias, boolean searchParent) {
        SqmRoot root;
        boolean onlyOneFrom;
        String localAlias = this.handleAliasCaseSensitivity(alias);
        SqmFrom<?, ?> registered = this.sqmFromByAlias.get(localAlias);
        if (registered != null) {
            return (X)registered;
        }
        SqmCreationProcessingState parentProcessingState = this.associatedProcessingState.getParentProcessingState();
        if (searchParent && parentProcessingState != null) {
            Object parentRegistered;
            do {
                parentRegistered = parentProcessingState.getPathRegistry().findFromByAlias(alias, false);
            } while ((parentProcessingState = parentProcessingState.getParentProcessingState()) != null && parentRegistered == null);
            if (parentRegistered != null) {
                SqmFrom<?, ?> correlated = this.correlate(parentRegistered);
                this.register(correlated);
                return (X)correlated;
            }
        }
        boolean bl = onlyOneFrom = this.sqmFromByPath.size() == 1;
        if (onlyOneFrom && localAlias.equalsIgnoreCase("this") && (root = (SqmRoot)this.sqmFromByPath.entrySet().iterator().next().getValue()).getAlias() == null) {
            return (X)root;
        }
        return null;
    }

    private <X extends SqmFrom<?, ?>> SqmFrom<?, ?> correlate(X parentRegistered) {
        SqmSubQuery selectQuery = (SqmSubQuery)this.associatedProcessingState.getProcessingQuery();
        if (parentRegistered instanceof Root) {
            Root root = (Root)parentRegistered;
            return selectQuery.correlate(root);
        }
        if (parentRegistered instanceof Join) {
            Join join = (Join)parentRegistered;
            return selectQuery.correlate(join);
        }
        throw new UnsupportedOperationException("Can't correlate from node: " + String.valueOf(parentRegistered));
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromExposing(String navigableName) {
        SqmCreationProcessingState processingState;
        SqmFrom<?, ?> found = null;
        for (Map.Entry<NavigablePath, SqmFrom<?, ?>> entry : this.sqmFromByPath.entrySet()) {
            SqmFrom<?, ?> fromElement = entry.getValue();
            if (!this.definesAttribute(fromElement.getReferencedPathSource(), navigableName)) continue;
            if (found != null) {
                throw new SemanticException("Ambiguous unqualified attribute reference '" + navigableName + "' (qualify the attribute reference by an identification variable)");
            }
            found = fromElement;
        }
        if (found == null && (processingState = this.associatedProcessingState.getParentProcessingState()) != null) {
            found = (SqmFrom<?, ?>)processingState.getPathRegistry().findFromExposing(navigableName);
        }
        return (X)found;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X resolveFrom(NavigablePath navigablePath, Function<NavigablePath, SqmFrom<?, ?>> creator) {
        SqmFrom<?, ?> existing = this.sqmFromByPath.get(navigablePath);
        if (existing != null) {
            return (X)existing;
        }
        SqmFrom<?, ?> sqmFrom = creator.apply(navigablePath);
        this.register(sqmFrom);
        return (X)sqmFrom;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X resolveFrom(SqmPath<?> path) {
        NavigablePath navigablePath = path.getNavigablePath();
        SqmFrom<?, ?> existing = this.sqmFromByPath.get(navigablePath);
        if (existing != null) {
            return (X)existing;
        }
        JpaJoin sqmFrom = this.resolveFrom((SqmPath<?>)path.getLhs()).join(navigablePath.getLocalName());
        this.register((SqmPath<?>)((Object)sqmFrom));
        return (X)sqmFrom;
    }

    private boolean definesAttribute(SqmPathSource<?> containerType, String name) {
        return !(containerType.getSqmType() instanceof BasicDomainType) && containerType.findSubPathSource(name, true) != null;
    }

    @Override
    public SqmAliasedNode<?> findAliasedNodeByAlias(String alias) {
        assert (alias != null);
        String aliasToUse = this.handleAliasCaseSensitivity(alias);
        for (int i = 0; i < this.simpleSelectionNodes.size(); ++i) {
            SqmAliasedNode<?> node = this.simpleSelectionNodes.get(i);
            if (!aliasToUse.equals(node.getAlias())) continue;
            return node;
        }
        return null;
    }

    @Override
    public Integer findAliasedNodePosition(String alias) {
        if (alias != null) {
            String aliasToUse = this.handleAliasCaseSensitivity(alias);
            for (int i = 0; i < this.simpleSelectionNodes.size(); ++i) {
                SqmAliasedNode<?> node = this.simpleSelectionNodes.get(i);
                if (!aliasToUse.equals(node.getAlias())) continue;
                return i + 1;
            }
        }
        return null;
    }

    @Override
    public SqmAliasedNode<?> findAliasedNodeByPosition(int position) {
        return position > this.simpleSelectionNodes.size() ? null : this.simpleSelectionNodes.get(position - 1);
    }

    @Override
    public void register(SqmAliasedNode<?> node) {
        this.checkResultVariable(node);
        this.simpleSelectionNodes.add(node);
    }

    private void checkResultVariable(SqmAliasedNode<?> selection) {
        Integer position;
        String alias = selection.getAlias();
        if (alias != null && (position = this.findAliasedNodePosition(alias)) != null) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Duplicate alias '%s' at position %s in 'select' clause", alias, position));
        }
    }
}

