/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Options;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoredLexicon
extends BaseLexicon {
    private static final long serialVersionUID = 8496467161563992530L;
    private static final boolean DEBUG = false;
    private MorphoFeatureSpecification morphoSpec;

    public FactoredLexicon(MorphoFeatureSpecification morphoSpec) {
        this.morphoSpec = morphoSpec;
    }

    public FactoredLexicon(Options.LexOptions op, MorphoFeatureSpecification morphoSpec) {
        super(op);
        this.morphoSpec = morphoSpec;
    }

    @Override
    public Iterator<IntTaggedWord> ruleIteratorByWord(int word, int loc, String featureSpec) {
        MorphoFeatures feats = this.morphoSpec.strToFeatures(featureSpec);
        List<Object> wordTaggings = new ArrayList();
        if (this.isKnown(word)) {
            wordTaggings = this.rulesForWord(word, feats);
        }
        if (wordTaggings.size() == 0 && (wordTaggings = this.rulesForWord(this.wordNumberer.number("UNK"), feats)).size() == 0) {
            System.err.printf("%s: Unseen word/feature combination: %s %s%n", this.getClass().getName(), (String)this.wordNumberer.object(word), feats.toString());
            wordTaggings = new ArrayList(40);
            for (IntTaggedWord iTW : this.rulesWithWord[this.wordNumberer.number("UNK")]) {
                wordTaggings.add(new IntTaggedWord(word, iTW.tag));
            }
        }
        if (wordTaggings.size() == 0) {
            System.err.printf("%s: No lexical insertion rules for (%s): %s%n", this.getClass().getName(), (String)this.wordNumberer().object(word), feats.toString());
        }
        return wordTaggings.iterator();
    }

    private List<IntTaggedWord> rulesForWord(int word, MorphoFeatures wordFeats) {
        ArrayList<IntTaggedWord> tagRules = new ArrayList<IntTaggedWord>();
        for (IntTaggedWord iTW : this.rulesWithWord[word]) {
            String tagStr = (String)this.tagNumberer().object(iTW.tag());
            MorphoFeatures tagFeats = wordFeats.fromTagString(tagStr);
            int nMatches = wordFeats.numFeatureMatches(tagFeats);
            if (this.flexiTag && nMatches > 0) {
                tagRules.add(iTW);
                continue;
            }
            if (tagFeats.numActiveFeatures() != wordFeats.numActiveFeatures() || wordFeats.numActiveFeatures() != nMatches) continue;
            tagRules.add(iTW);
        }
        return tagRules;
    }
}

