/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.tokenattributes.PartOfSpeechAttribute;

public final class KoreanPartOfSpeechStopFilter
extends FilteringTokenFilter {
    private final Set<POS.Tag> stopTags;
    private final PartOfSpeechAttribute posAtt = (PartOfSpeechAttribute)this.addAttribute(PartOfSpeechAttribute.class);
    public static final Set<POS.Tag> DEFAULT_STOP_TAGS = Collections.unmodifiableSet(EnumSet.of(POS.Tag.EP, new POS.Tag[]{POS.Tag.EF, POS.Tag.EC, POS.Tag.ETN, POS.Tag.ETM, POS.Tag.IC, POS.Tag.JKS, POS.Tag.JKC, POS.Tag.JKG, POS.Tag.JKO, POS.Tag.JKB, POS.Tag.JKV, POS.Tag.JKQ, POS.Tag.JX, POS.Tag.JC, POS.Tag.MAG, POS.Tag.MAJ, POS.Tag.MM, POS.Tag.SP, POS.Tag.SSC, POS.Tag.SSO, POS.Tag.SC, POS.Tag.SE, POS.Tag.XPN, POS.Tag.XSA, POS.Tag.XSN, POS.Tag.XSV, POS.Tag.UNA, POS.Tag.NA, POS.Tag.VSV}));

    public KoreanPartOfSpeechStopFilter(TokenStream input) {
        this(input, DEFAULT_STOP_TAGS);
    }

    public KoreanPartOfSpeechStopFilter(TokenStream input, Set<POS.Tag> stopTags) {
        super(input);
        this.stopTags = stopTags;
    }

    protected boolean accept() {
        POS.Tag leftPOS = this.posAtt.getLeftPOS();
        return leftPOS == null || !this.stopTags.contains((Object)leftPOS);
    }
}

