"use strict";

var _events = require("events");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable */
// transpiled typescript->javascript from
// https://github.com/aurelia/pal-nodejs/blob/master/src/polyfills/mutation-observer.ts

/*
 * Based on Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 */

var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return function (d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();
module.exports = {};
Object.defineProperty(module.exports, "__esModule", {
  value: true
});
var Util = /** @class */function () {
  function Util() {}
  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level
    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      };
      // Store current character data of target text or comment node if the config requests
      // those properties to be observed.
      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }
            return memo;
          }, {});
        }
        // whether we should iterate the children of $target node
        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }
        recurse = config.descendents;
      }
      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */
  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };
    return this.indexOf(set, $node, idx, JSCompiler_renameProperty("node"));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */
  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */
  Util.map = function (set, iterator) {
    var results = [];
    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }
    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */
  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }
    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */
  Util.indexOf = function (set, item, idx, prop) {
    for (; /*idx = ~~idx*/idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }
    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */
  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = "mo_id";
  return Util;
}();
module.exports.Util = Util;
var MutationObserver = /** @class */function () {
  function MutationObserver(listener) {
    var _this = this;
    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;
    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }
  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on("changed", this._notifyListener);
    var watched = this._watched;
    // remove already observed target element from pool
    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }
    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }
    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };
  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;
    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }
    return mutations;
  };
  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed
    MutationNotifier.getInstance().removeListener("changed", this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection
    this._timeout = null;
  };
  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */
    var $oldstate = Util.clone($target, config); // create the cloned datastructure
    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */
    return function (mutations) {
      var olen = mutations.length;
      var dirty;
      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: "characterData",
          target: $target,
          oldValue: $oldstate.charData
        }));
      }
      // Alright we check base level changes in attributes... easy
      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      }
      // check childlist or subtree for mutations
      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      }
      // reclone data structure if theres changes
      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };
  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this;
    // Only schedule if there isn't already a timer.
    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };
  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();
    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };
  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this;
    // Track if the tree is dirty and has to be recomputed (#14).
    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */
    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1;
      // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;
      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j];
        // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts
        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: "childList",
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        }
        // Alright we found the resorted nodes now check for other types of mutations
        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: "characterData",
            target: $cur,
            oldValue: oldstruct.charData
          }));
        }
        // now look @ subtree
        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */
    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length;
      // $oldkids will be undefined for text and comment nodes
      var olen = $oldkids ? $oldkids.length : 0;
      // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice
      var map;
      // array of potential conflicts (ie nodes that may have been re arranged)
      var conflicts;
      var id; // element id from getElementId helper
      var idx; // index of a moved or inserted element
      var oldstruct;
      // current and old nodes
      var $cur;
      var $old;
      // track the number of added nodes so we can resolve conflicts more accurately
      var numAddedNodes = 0;
      // iterate over both old and current child nodes at the same time
      var i = 0;
      var j = 0;
      // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;
        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          }
          // check character data if node is a comment or textNode and it's being observed
          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: "characterData",
              target: $cur
            }));
          }
          // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
          // recurse on next level of children. Avoids the recursive call when there are no children left to iterate
          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;
          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }
          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true;
              // custom indexOf using comparitor checking oldkids[i].node === $cur
              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: "childList",
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }
            i++;
          }
          if ($old &&
          // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;
              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: "childList",
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }
            j++;
          }
        } // end uncommon case
      } // end loop
      // resolve any remaining conflicts
      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };
    _findMutations($target, $oldstate);
    return dirty;
  };
  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;
    while (i--) {
      attr = attributes[i];
      name = attr.name;
      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: "attributes",
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined
          }));
        }

        checked[name] = true;
      }
    }
    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: "attributes",
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };
  return MutationObserver;
}();
module.exports.MutationObserver = MutationObserver;
var MutationRecord = /** @class */function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };
    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }
    return settings;
  }
  return MutationRecord;
}();
module.exports.MutationRecord = MutationRecord;
var MutationNotifier = /** @class */function (_super) {
  __extends(MutationNotifier, _super);
  function MutationNotifier() {
    var _this = _super.call(this) || this;
    _this.setMaxListeners(100);
    return _this;
  }
  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }
    return MutationNotifier._instance;
  };
  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners("changed");
  };
  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit("changed", node);
  };
  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);
module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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